/*
* @category    Programacion Eventos Formulario Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmVerPacientesObservacionHospitaliza = Ext.extend(winFrmVerPacientesObservacionHospitalizaUi, {
    initComponent: function() {
        winFrmVerPacientesObservacionHospitaliza.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        el = Ext.get('idprofesionalhc');
        ID_PROFESIONAL_HC = el.getValue();
        BD_MULTIPRESTADOR = "NA";

        objREM = "new SolRem002Ui();";
        objEXA = "new SolExaIPS002Ui();";
        objMX = "new SolMxIPS001Ui();";
        objREMADD = "new winSolRem002Ui();";
        objEXAADD = "new winSolExaIPS002Ui();";
        objMXADD = "new winSolMxIPS001Ui();";
        
        wPaciente = 0;
        wCAS = 0;
        wURL = "";
        wNomImagen = "";
        winImgxPac = "";
        winDocxPac = "";
        paramOpcion = "Nuevo";
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        
        Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        Ext.getCmp('fNomSede').setValue("");
        Ext.getCmp('fNomIPS').setValue("");
        Ext.getCmp('fNomUSR').setValue("");
        
        searchStoreExa = new Ext.data.Store({
            //id: 'dsSolExaIPS002',
            proxy: new Ext.data.ScriptTagProxy({
                url: '../../controlador/asistencial/controlador_oficlinic_solexa.php'
            }),
            reader: new Ext.data.JsonReader({
                root: 'data',
                totalProperty: 'totalCount',
                id: 'id'
            }, 
            [
                {name: 'Codigo'},
                {name: 'Descripcion'},
                {name: 'TipoEstudio'},
                {name: 'Tarifa'},
                {name: 'TipoAutoriza'}
            ])
        });
        
        //var btnCargarObservaHospitaliza = Ext.getCmp('btnCargarObservaHospitaliza').on("click",this.ActualizarGridObservaHospitaliza,this);
        var btnSalir = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion, this);
        var btnBuscarPacienteObservaHospitaliza = Ext.getCmp('btnBuscarPacienteObservaHospitaliza').on("click",this.BuscarPacienteObservaHospitaliza,this);
        var btnLimpiarPacienteObservaHospitaliza = Ext.getCmp('btnLimpiarPacienteObservaHospitaliza').on("click",this.LimpiarDatosPaciente,this);
        var btnActualizarInformacion = Ext.getCmp('btnActualizarInformacion').on("click",this.ActualizarGridObservaHospitaliza,this);
        var btnNotasMedicas = Ext.getCmp('btnNotasMedicas').on("click",this.NotasMedicas,this);
        var btnNotasEnfermeria = Ext.getCmp('btnNotasEnfermeria').on("click",this.NotasEnfermeria,this);
        var btnPrintObservaHospitaliza = Ext.getCmp('btnPrintObservaHospitaliza').on("click",this.verObservaHospitalizacion,this);
        var btnEpicrisis = Ext.getCmp('btnEpicrisis').on("click",this.Epicrisis,this);
        
        Ext.getCmp('sysProfeObservaHospitaliza').setValue(ID_PROFESIONAL_HC);
    },
    Epicrisis: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() === 1){
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            wPaciente = selections[0].json.Paciente;
            wCAS = selections[0].json.CAS;
            var winHCEpicrisis001 = new winHCEpicrisis001Ui();
            Ext.getCmp('sysYaGuardoHC').setValue(0);
            Ext.getCmp('sysProfesionalHC').setValue(ID_PROFESIONAL_HC);
            Ext.getCmp('sysActividadHC').setValue("EPICRISIS");
            Ext.getCmp('sysUsuarioHC').setValue(ID_USUARIO);
            Ext.getCmp('sysIdPacienteHC').setValue(selections[0].json.Paciente);
            Ext.getCmp('sysAperturaHC').setValue(new Date().format("h:i:s"));
            Ext.getCmp('sysFechaHC').setValue(new Date().format("Y/m/d"));
            Ext.getCmp('sysHoraHC').setValue(new Date().format("h:i:s"));
            Ext.getCmp('sysCASHC').setValue(selections[0].json.CAS);
            Ext.getCmp('sysPacienteHC').setValue(selections[0].json.TipDoc + " " + selections[0].json.Documento + ' - ' + selections[0].json.PrimerNombre + " " + selections[0].json.SegundoNombre + " " + selections[0].json.PrimerApellido + " " + selections[0].json.SegundoApellido);
            Ext.getCmp('sysConsecutivoDetalleHC').setValue(selections[0].json.ConsecutivoDetalle);
            Ext.getCmp('sysEmpresaHC').setValue(ID_EMPRESA);
            Ext.getCmp('sysIPSHC').setValue(ID_IPS);
            Ext.getCmp('sysIdClienteHC').setValue(selections[0].json.Cliente);
            Ext.getCmp('sysIdPlanHC').setValue(selections[0].json.Plan);
            Ext.getCmp('sysIdSubPlanHC').setValue(selections[0].json.Subplan);
            Ext.getCmp('sysIdContratoHC').setValue(selections[0].json.idContrato);
            Ext.getCmp('sysPlantillaHC').setValue(PonerAcentosMayusculas("EPICRISIS - OBSERVACION - HOSPITALIZACION"));
            Ext.getCmp('sysActividadHC').setValue(PonerAcentosMayusculas("EPICRISIS - OBSERVACION - HOSPITALIZACION"));
            Ext.getCmp('sysClienteHC').setValue(selections[0].json.nomCliente);
            Ext.getCmp('sysServicioHC').setValue(selections[0].json.Tipo);
            Ext.getCmp('sysTipoNotaHC').setValue("EPICRISIS");
            Ext.getCmp('sysProfesionalAgendaHC').setValue();
            Ext.getCmp('sysIdCodPlantillaHC').setValue(1000);
            if(selections[0].json.Genero === "M"){
                Ext.getCmp('sysGeneroPacHC').setValue("MASCULINO");
                Ext.getCmp('sysGeneroHC').setValue("MASCULINO");
            }else{
                Ext.getCmp('sysGeneroPacHC').setValue("FEMENINO");
                Ext.getCmp('sysGeneroHC').setValue("FEMENINO");
            }
            Ext.getCmp('sysFechaNac').setValue(selections[0].json.FecNac);
            Ext.getCmp('sysEdadHC').setValue(selections[0].json.Edad);
            Ext.getCmp('sysEdadPacHC').setValue(selections[0].json.Edad);
            winHCEpicrisis001.show();
        }
    },        
    NotasEnfermeria: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() === 1){
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            wPaciente = selections[0].json.Paciente;
            wCAS = selections[0].json.CAS;
            var winHCNotaEnfermeria = new winHCNotaEnfermeriaUi();
            Ext.getCmp('sysYaGuardoEnfHC').setValue(0);
            Ext.getCmp('sysProfesionalEnfHC').setValue(ID_PROFESIONAL_HC);
            Ext.getCmp('sysActividadEnfHC').setValue("NOTAS ENFERMERIA");
            Ext.getCmp('sysUsuarioEnfHC').setValue(ID_USUARIO);
            Ext.getCmp('sysIdPacienteEnfHC').setValue(selections[0].json.Paciente);
            Ext.getCmp('sysAperturaEnfHC').setValue(new Date().format("h:i:s"));
            Ext.getCmp('sysFechaEnfHC').setValue(new Date().format("Y/m/d"));
            Ext.getCmp('sysHoraEnfHC').setValue(new Date().format("h:i:s"));
            Ext.getCmp('sysCASEnfHC').setValue(selections[0].json.CAS);
            Ext.getCmp('sysPacienteEnfHC').setValue(selections[0].json.TipDoc + " " + selections[0].json.Documento + ' - ' + selections[0].json.PrimerNombre + " " + selections[0].json.SegundoNombre + " " + selections[0].json.PrimerApellido + " " + selections[0].json.SegundoApellido);
            Ext.getCmp('sysConsecutivoDetalleEnfHC').setValue(selections[0].json.ConsecutivoDetalle);
            Ext.getCmp('sysEmpresaEnfHC').setValue(ID_EMPRESA);
            Ext.getCmp('sysIPSEnfHC').setValue(ID_IPS);
            Ext.getCmp('sysIdClienteEnfHC').setValue(selections[0].json.Cliente);
            Ext.getCmp('sysIdPlanEnfHC').setValue(selections[0].json.Plan);
            Ext.getCmp('sysIdSubPlanEnfHC').setValue(selections[0].json.Subplan);
            Ext.getCmp('sysIdContratoEnfHC').setValue(selections[0].json.idContrato);
            Ext.getCmp('sysPlantillaEnfHC').setValue(PonerAcentosMayusculas("NOTAS ENFERMERIA - OBSERVACION - HOSPITALIZACION"));
            Ext.getCmp('sysActividadEnfHC').setValue(PonerAcentosMayusculas("NOTAS ENFERMERIA - OBSERVACION - HOSPITALIZACION"));
            Ext.getCmp('sysClienteEnfHC').setValue(selections[0].json.nomCliente);
            Ext.getCmp('sysServicioEnfHC').setValue(selections[0].json.Tipo);
            Ext.getCmp('sysTipoNotaEnfHC').setValue("NOTA ENFERMERIA");
            Ext.getCmp('sysProfesionalAgendaEnfHC').setValue();
            Ext.getCmp('sysIdCodPlantillaEnfHC').setValue(1000);
            if(selections[0].json.Genero === "M"){
                Ext.getCmp('sysGeneroPacEnfHC').setValue("MASCULINO");
                Ext.getCmp('sysGeneroEnfHC').setValue("MASCULINO");
            }else{
                Ext.getCmp('sysGeneroPacEnfHC').setValue("FEMENINO");
                Ext.getCmp('sysGeneroEnfHC').setValue("FEMENINO");
            }
            Ext.getCmp('sysFechaEnfNac').setValue(selections[0].json.FecNac);
            Ext.getCmp('sysEdadEnfHC').setValue(selections[0].json.Edad);
            Ext.getCmp('sysEdadPacEnfHC').setValue(selections[0].json.Edad);
            winHCNotaEnfermeria.show();
        }
    },
    verObservaHospitalizacion: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() === 1){
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            var cmpResumenHC = new winViewEvolucionObservaHospitalizaHC({
                renderTo: Ext.getBody()
            });
            Ext.getCmp('sysEmpresaViewObservaHospitaliza').setValue(ID_EMPRESA);
            Ext.getCmp('sysPacienteViewObservaHospitaliza').setValue(selections[0].json.Paciente);
            Ext.getCmp('winViewEvolucionObservaHospitalizaHC').title = "PACIENTE: " + selections[0].json.TipDoc + '-' + selections[0].json.Documento + ' ' + selections[0].json.PrimerNombre + ' ' + selections[0].json.SegundoNombre + ' ' + selections[0].json.PrimerApellido + ' ' + selections[0].json.SegundoApellido + ' Genero: ' + selections[0].json.Genero + ' FecNac: ' + selections[0].json.FecNac + ' Edad: ' + selections[0].json.Edad;
            Ext.getCmp('gridHistorialEvolucionesObservaHospitaliza').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pPaciente: selections[0].json.Paciente
                }
            });
            cmpResumenHC.show();
        }
    },
    NotasMedicas: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() === 1){
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            wPaciente = selections[0].json.Paciente;
            wCAS = selections[0].json.CAS;
            var winHCNotaMedica = new winHCNotaMedicaUi();
            Ext.getCmp('sysYaGuardoHC').setValue(0);
            Ext.getCmp('sysProfesionalHC').setValue(ID_PROFESIONAL_HC);
            Ext.getCmp('sysActividadHC').setValue("NOTAS MEDICAS");
            Ext.getCmp('sysUsuarioHC').setValue(ID_USUARIO);
            Ext.getCmp('sysIdPacienteHC').setValue(selections[0].json.Paciente);
            Ext.getCmp('sysAperturaHC').setValue(new Date().format("h:i:s"));
            Ext.getCmp('sysFechaHC').setValue(new Date().format("Y/m/d"));
            Ext.getCmp('sysHoraHC').setValue(new Date().format("h:i:s"));
            Ext.getCmp('sysCASHC').setValue(selections[0].json.CAS);
            Ext.getCmp('sysPacienteHC').setValue(selections[0].json.TipDoc + " " + selections[0].json.Documento + ' - ' + selections[0].json.PrimerNombre + " " + selections[0].json.SegundoNombre + " " + selections[0].json.PrimerApellido + " " + selections[0].json.SegundoApellido);
            Ext.getCmp('sysConsecutivoDetalleHC').setValue(selections[0].json.ConsecutivoDetalle);
            Ext.getCmp('sysEmpresaHC').setValue(ID_EMPRESA);
            Ext.getCmp('sysIPSHC').setValue(ID_IPS);
            Ext.getCmp('sysIdClienteHC').setValue(selections[0].json.Cliente);
            Ext.getCmp('sysIdPlanHC').setValue(selections[0].json.Plan);
            Ext.getCmp('sysIdSubPlanHC').setValue(selections[0].json.Subplan);
            Ext.getCmp('sysIdContratoHC').setValue(selections[0].json.idContrato);
            Ext.getCmp('sysPlantillaHC').setValue(PonerAcentosMayusculas("NOTAS MEDICAS - OBSERVACION - HOSPITALIZACION"));
            Ext.getCmp('sysActividadHC').setValue(PonerAcentosMayusculas("NOTAS MEDICAS - OBSERVACION - HOSPITALIZACION"));
            Ext.getCmp('sysClienteHC').setValue(selections[0].json.nomCliente);
            Ext.getCmp('sysServicioHC').setValue(selections[0].json.Tipo);
            Ext.getCmp('sysTipoNotaHC').setValue("NOTA MEDICA");
            Ext.getCmp('sysProfesionalAgendaHC').setValue();
            Ext.getCmp('sysIdCodPlantillaHC').setValue(1000);
            if(selections[0].json.Genero === "M"){
                Ext.getCmp('sysGeneroPacHC').setValue("MASCULINO");
                Ext.getCmp('sysGeneroHC').setValue("MASCULINO");
            }else{
                Ext.getCmp('sysGeneroPacHC').setValue("FEMENINO");
                Ext.getCmp('sysGeneroHC').setValue("FEMENINO");
            }
            Ext.getCmp('sysFechaNac').setValue(selections[0].json.FecNac);
            Ext.getCmp('sysEdadHC').setValue(selections[0].json.Edad);
            Ext.getCmp('sysEdadPacHC').setValue(selections[0].json.Edad);
            winHCNotaMedica.show();
        }
    },
    LimpiarDatosPaciente: function(){
        Ext.getCmp('intPacienteObservaHospitaliza').setValue(0);
        Ext.getCmp('sysPacienteObservaHospitaliza').setValue(null);
        //Ext.getCmp('gridFormulario').store.removeAll();
    },
    BuscarPacienteObservaHospitaliza: function(){
        buscarpaciente("Hospitaliza");
    },
    ActualizarGridObservaHospitaliza: function(){
        Ext.getCmp('gridFormulario').store.load({
            params: {
                pPaciente: Ext.getCmp('intPacienteObservaHospitaliza').getValue(),
                pServicio: Ext.getCmp('sysTipoServicioObservaHospitaliza').getValue()
            }
        });
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn){
                if(btn === "yes"){
                    window.close();
                }
            }
        });
    }
});

