/*
* @category    Formulario Grid Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmVerPacientesObservacionHospitalizaUi = Ext.extend(Ext.Window, {
    //title: 'OfiClinic© Web..! .:: Agenda por Profesional ::.',
    id: 'winFrmVerPacientesObservacionHospitaliza',
    closable:false,
    draggable : false,
    width:980,
    height:480,
    plain:true,
    resizable : false,
    y:120,
    padding: 5,
    frame: true,
    layout: 'form',
    initComponent: function() {
        function VerIngreso(value, metaData, record, rowIndex, colIndex, store){
            metaData.attr = '<style="white-space:normal;"';
            var Servicio = "OBSERVACION";
            if(record.get('Tipo') === "H"){
                Servicio = 'HOSPITALIZACION';
            }
            return '<span style="color: darkblue; font-weight:bold; text-align:center;">'+value + '</span><br>Hora Ingreso: </br>' + record.get('HoraIngreso') + '</br><span style="color: red; font-weight:bold; text-align:center;">' + Servicio + '</span>';
	}
        function VerUbicacion(value, metaData, record, rowIndex, colIndex, store){
            metaData.attr = '<style="white-space:normal;"';
            if(record.get('Tipo') === "H"){
                return '<span><b>Habitacion: ' + record.get('NroHabitacion') + '</span><br>Cama: ' + record.get('NroCama');
            }else{
                return '';
            }
	}
        function VerPaciente(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return '<p>' + record.get('TipDoc') + '-' + record.get('Documento') + '</br>' + record.get('PrimerNombre') + ' ' + record.get('SegundoNombre') + ' ' + record.get('PrimerApellido') + ' ' + record.get('SegundoApellido') + '</br>Genero: ' + record.get('Genero') + ' FecNac: ' + record.get('FecNac') + '</br>' + record.get('Edad');  
        }
        
        function VerCita(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return value + '</br>' + record.get('DescAdiHora');  
        }
        
        function VerCliente(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return record.get('nomCliente');  
        }
        
        var dataTipoRegistro = [
            ['U','OBSERVACION'],
            ['H','HOSPITALIZACION']
        ];
        var stTipoRegistro = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stTipoRegistro.loadData(dataTipoRegistro);

        var mybbar = new utilBbarUi();
        var stGrid = new StoreGridObservaHospitaliza();
        this.bbar = mybbar;
        this.items = [
            {
                xtype: 'hidden',
                id: 'sysProfeObservaHospitaliza'
            },
            {
                xtype: 'hidden',
                id: 'intPacienteObservaHospitaliza'
            },
            {
                xtype: 'compositefield',
                anchor: '100%',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'textfield',
                        width: 794,
                        fieldLabel: 'Paciente',
                        readOnly: true,
                        allowBlank: true,
                        emptyText: 'Buscar Paciente....',
                        id: 'sysPacienteObservaHospitaliza'
                    },
                    {
                        xtype: 'button',
                        iconCls: 'btnBuscar',
                        tooltip: 'Buscar Paciente',
                        id: 'btnBuscarPacienteObservaHospitaliza'
                    },
                    {
                        xtype: 'button',
                        tooltip: 'Limpiar Datos del Paciente',
                        iconCls: 'btnLimpiar',
                        id: 'btnLimpiarPacienteObservaHospitaliza'
                    }
                ]
            },
            {
                xtype: 'combo',
                fieldLabel: 'Servicio',
                anchor: '100%',
                allowBlank: true,
                store: stTipoRegistro,
                forceSelection: true,
                triggerAction: 'all',
                mode: 'local',
                typeAhead: true,
                typeAheadDelay: 50,
                emptyText: 'Seleccione ....',
                valueField: 'Codigo',
                displayField: 'Descripcion',
                id: 'sysTipoServicioObservaHospitaliza'
            },
            {
                xtype: 'grid',
                id: 'gridFormulario',
                store: stGrid,
                anchor: "100%",
                height: 375,
                border: false,
                frame: true,
                loadMask: true,
                stripeRows: true,
                colModel: new Ext.ux.grid.LockingColumnModel([
                    {
                        header: 'Estado',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'EstadoAtencion',
                        width: 1,
                        hidden: true,
                        hideable: false
                    },
                    {
                        header: 'CAS',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'CAS',
                        width: 1,
                        hidden: true,
                        hideable: false
                    },
                    {
                        header: 'Ingreso',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'FechaIngreso',
                        width: 130,
                        renderer: VerIngreso,
                        hideable: false
                    },
                    {
                        header: 'Ubicacion',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Tipo',
                        renderer: VerUbicacion,
                        width: 110,
                        hideable: false
                    },
                    
                    {
                        header: 'Paciente',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Paciente',
                        width: 330,
                        renderer: VerPaciente,
                        hideable: false
                    },
                    {
                        header: 'Cliente',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'nomCliente',
                        width: 250,
                        renderer: VerCliente,
                        hideable: false
                    }
                ]),
                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                //view: new Ext.grid.GroupingView({
                /*view: new Ext.ux.grid.LockingGridView({
                    //groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})',
                    getRowClass: function(record, index, rowParams, store){
                        var estado = record.data.ClasificaTriage;
                        switch (estado)
                        {
                            case "V":
                                return 'AtencionNormal';
                                break;
                            case "A":
                                return 'AtencionPrioritaria';
                                break;
                            case "R":
                                return 'AtencionUrgencias';
                                break;
                            default:
                                break;
                        }
                    }
                }),*/
                columnLines: true,
                tbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Actualizar',
                                iconCls: 'btnActualizarGrid',
                                tooltip: 'Actualizar Informacion',
                                id: 'btnActualizarInformacion'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Consultar Observacion / Hospitalizacion',
                                iconCls: 'btnVerHCObservaHospitaliza',
                                tooltip: 'Consultar Observacion / Hospitalizacion',
                                id: 'btnPrintObservaHospitaliza'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            '->',
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Notas Medicas',
                                iconCls: 'btnNotasMedicas',
                                tooltip: 'Notas Medicas',
                                id: 'btnNotasMedicas'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Notas Enfermeria',
                                iconCls: 'btnNotasEnfermeria',
                                tooltip: 'Notas Enfermeria',
                                id: 'btnNotasEnfermeria'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                html: ' -> '
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Salida del Paciente',
                                iconCls: 'btnEvolucionar1',
                                tooltip: 'Salida del Paciente',
                                id: 'btnEpicrisis'
                            }
                        ]
                    }
            }
        ];
        winFrmVerPacientesObservacionHospitalizaUi.superclass.initComponent.call(this);
    }
});
