/*
* @category    Grid Odontograma Inicial o Control
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

GridEditOdontogramaUi = Ext.extend(Ext.Window, {
    title: 'Editar Odontograma',
    anchor: '100%',
    autoHeight: true,
    closable: true,
    modal: true,
    initComponent: function() {
        function DescripcionSuperficie(val, x, store){
            var superficie = val.replace(/-N/g,"");
            return superficie;
        }
        
        this.items = [
            {
                xtype: 'hidden',
                anchor: '100%',
                allowBlank: true,
                readOnly: true,
                id: 'sysIdOdontogramaItemOdontograma'
            },
            {
                xtype: 'hidden',
                anchor: '100%',
                allowBlank: true,
                readOnly: true,
                id: 'sysTipoDenticionItemOdontograma'
            },
            {
                xtype: 'grid',
                title: ' ',
                id: 'gridEditOdontogramaHC',
                store: 'StoreGridEditOdontogramaHC',
                anchor: "100%",
                height: 470,
                border: false,
                frame: true,
                loadMask: true,
                colModel: new Ext.ux.grid.LockingColumnModel([
                    {
                        xtype: 'gridcolumn',
                        header: 'Id',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'IdOdontogramaDetalle',
                        id: 'IdOdontogramaDetalle'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Diente',
                        sortable: true,
                        width: 50,
                        dataIndex: 'Diente',
                        id: 'Diente'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Diagnostico',
                        sortable: false,
                        width: 250,
                        dataIndex: 'descDiagnostico',
                        id: 'descDiagnostico'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Superficie',
                        sortable: false,
                        width: 100,
                        dataIndex: 'Superficies',
                        renderer: DescripcionSuperficie,
                        id: 'Superficies'
                    }
                ]),
                selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                iconCls:'icon-grid',
                //view: new Ext.grid.GroupingView(),
                bbar: {
                    xtype: 'toolbar',
                    items: [
                        {
                            xtype: 'button',
                            text: 'Pintar Odontograma',
                            iconCls: 'btnDiente',
                            id: 'btnDrawItemOdontograma',
                            listeners: {
                                click : function() {
                                    var updater = Ext.getCmp('OdontogramaInical').getUpdater();
                                    updater.setDefaultUrl('../../../app/frm/odontograma/odontograma002.php?pPaciente=' + wPaciente + '&pCAS=' + wCAS + '&pOdontograma=' + Ext.getCmp('sysIdOdontogramaItemOdontograma').getValue());
                                    updater.refresh();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        }
                    ]
                },
                tbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'button',
                                text: 'Adicionar',
                                iconCls: 'btnAddRow',
                                id: 'btnAddItemOdontograma',
                                listeners: {
                                    click : function() {
                                        var winAddItemDetelleOdontograma = new winAddItemDetelleOdontogramaUi();
                                        Ext.getCmp('intIdOdontogramaDetalleOdontograma').setValue(Ext.getCmp('sysIdOdontogramaItemOdontograma').getValue());
                                        Ext.getCmp('intNroDienteDetalleOdontograma').store.load({
                                            params: {
                                                pTipo: Ext.getCmp('sysTipoDenticionItemOdontograma').getValue()
                                            }
                                        });
                                        winAddItemDetelleOdontograma.show();
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Eliminar',
                                iconCls: 'btnDelRow',
                                id: 'btnDelItemOdontograma',
                                listeners: {
                                    click : function() {
                                        if(Ext.getCmp('gridEditOdontogramaHC').selModel.getCount() === 1){
                                            var selections = Ext.getCmp('gridEditOdontogramaHC').selModel.getSelections();
                                            Ext.Msg.show({
                                                title: 'Diagnostico Odontograma',
                                                msg: 'Esta Seguro que Desea Eliminar el Registro Diente: ' + selections[0].json.Diente + ' - Dx: ' + selections[0].json.descDiagnostico + ' -Sup: ' + selections[0].json.Superficies + '?',
                                                buttons: Ext.Msg.YESNO,
                                                icon: Ext.Msg.QUESTION,
                                                fn: function(btn){
                                                    if(btn==="yes"){
                                                        fnEliminarRegistrosOdontograma("../../controlador/odontograma/controlador_odontograma.php",{task: "ELIMINAR_ITEM_DETALLEODONTOGRAMA", pIdItem: selections[0].json.IdOdontogramaDetalle}, 'gridEditOdontogramaHC')
                                                    }
                                                }
                                            });
                                        }else{
                                            Ext.MessageBox.show({
                                                title: 'Error',
                                                msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'tbfill'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Cargar SANO',
                                iconCls: 'btnAddRow',
                                id: 'btnSanoItemOdontograma',
                                listeners: {
                                    click : function() {
                                        Ext.Ajax.request({
                                            url: '../../controlador/odontograma/controlador_odontograma.php',
                                            params:{
                                                task: 'CREAR_DETALLEODONTOGRAMA_SANO',
                                                pOdontograma: Ext.getCmp('sysIdOdontogramaItemOdontograma').getValue(),
                                                pDenticion: Ext.getCmp('sysTipoDenticionItemOdontograma').getValue()
                                            },
                                            success: function(response,options){
                                                Ext.getCmp('gridEditOdontogramaHC').store.load({
                                                    params: {
                                                        task: 'LOAD_DETALLEODONTOGRAMA',
                                                        pOdontograma: Ext.getCmp('sysIdOdontogramaItemOdontograma').getValue()
                                                    }
                                                });
                                            },
                                            scope:this //bind the callbacks
                                        });
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            }
                        ]
                    }
            }
        ];
        GridEditOdontogramaUi.superclass.initComponent.call(this);
    }
});


function fnEliminarRegistrosOdontograma(URL,arrParam, pGrid, arrParamStore){
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid != 'undefined')
                    {
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                    }
                    break;

                case 3:
                    if (typeof pGrid != 'undefined')
                    {
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Alguno de los registros no se pudieron eliminar',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el registro en estos momentos o existen datos relacionados en otras tablas',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}