/*
* @category    Formulario Adicionar Item Detalle Odontograma
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddItemDetelleOdontogramaUi = Ext.extend(Ext.Window, {
    title: '.:: Diagonstico Odontograma ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winAddItemDetelleOdontogramaUi',
    initComponent: function() {
        Ext.QuickTips.init();
        Ext.form.Field.prototype.msgTarget = 'side';
        
        var stDxOdontograma = new StoreDiagnosticoOdontograma();
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddItemDetelleOdontograma',
                padding: 10,
                labelWidth: 200,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 80,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'intIdOdontogramaDetalleOdontograma',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'strAfectaDetalleOdontograma',
                                allowBlank: true
                            },
                            {
                                xtype: 'compositefield',
                                anchor: '95%',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Nro. Diente',
                                        width: 70,
                                        name: 'Nro. Diente',
                                        allowBlank: false,
                                        store: 'StoreDientesOdontograma',
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Diente',
                                        displayField: 'Diente',
                                        emptyText: 'Seleccione....',
                                        id: 'intNroDienteDetalleOdontograma'
                                    },
                                    {
                                        html: 'Diagnostico: '
                                    },
                                    {
                                        xtype: 'combo',
                                        width: 350,
                                        name: 'Diagnostico',
                                        allowBlank: false,
                                        store: 'StoreDiagnosticoOdontograma',
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        itemSelector: 'div.search-item',
                                        tpl: new Ext.XTemplate('<tpl for="."><div class="search-item" style="background-image:url({urlImagen})"><div class="name">{Descripcion}</div><div class="desc">{txtCaracteristicas}</div></div></tpl>'),
                                        id: 'strDiagnosticoDetalleOdontograma',
                                        listeners:{
                                            blur: function(f) {
                                                if(f.getValue() !== "" && f.getValue() !== null){
                                                    var dx = f.getValue();
                                                    stDxOdontograma.filterBy(function(record,id){  
                                                        return record.get('Codigo') === dx;
                                                    });  
                                                    stDxOdontograma.each(function(record){  
                                                        Ext.getCmp('strAfectaDetalleOdontograma').setValue(record.get('Afecta'));
                                                    });  
                                                    stDxOdontograma.clearFilter();
                                                    if(Ext.getCmp('strAfectaDetalleOdontograma').getValue() === "Diente"){
                                                        Ext.getCmp('strSuperficiesDetalleOdontograma').setValue("N-N-N-N-N");
                                                        Ext.getCmp('strSuperficiesDetalleOdontograma').readOnly = true;
                                                    }else{
                                                        Ext.getCmp('strSuperficiesDetalleOdontograma').readOnly = false;
                                                    }
                                                }else{
                                                    Ext.getCmp('strAfectaDetalleOdontograma').setValue(null);
                                                    Ext.getCmp('strSuperficiesDetalleOdontograma').setValue("N-N-N-N-N");
                                                    Ext.getCmp('strSuperficiesDetalleOdontograma').readOnly = true;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: 'Superficie: '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 100,
                                        allowBlank: false,
                                        value: 'N-N-N-N-N',
                                        plugins: [
                                            new Ext.ux.InputTextMask({
                                                mask:'X[OMDLPVNomdlpvn]X-X[OMDLPVNomdlpvn]X-X[OMDLPVNomdlpvn]X-X[OMDLPVNomdlpvn]X-X[OMDLPVNomdlpvn]X',
                                                clearInvalid: false
                                            })
                                        ],
                                        id: 'strSuperficiesDetalleOdontograma'
                                    }
                                ]
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btn_AddItemDetalleOdontograma',
                            listeners:{
                                click : function(){
                                    fnGuardarRegItemOdontograma("GUARDAR_ITEM_DETALLEODONTOGRAMA","NO","winAddItemDetelleOdontogramaUi","frmAddItemDetelleOdontograma","../../controlador/odontograma/controlador_odontograma.php","gridEditOdontogramaHC");
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winAddItemDetelleOdontogramaUi.superclass.initComponent.call(this);
    }
});

function fnGuardarRegItemOdontograma(pAccion,pCerrar,pWin,pForm,URL,pGrid){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        frm.reset();
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.reload();
                            }
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
