/*
* @category    Formulario Modelo Evolucion Historia Clinica Claudia Del Pilar Botero 001
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCCPBOTERO001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Plantilla HC - AAA FORMATO SLEEVE O BYPASS ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
     
        var dataTipoCirugia = [
            ['CIRUGIA BARIATRICA POR LAPAROSCOPIA'],
            ['SLEEV GASTRICO POR LAPAROSCOPIA'],
            ['BYPASS GASTRICO'],
            ['BYPASS GASTRICO']
        ];
        var stTipoCirugia = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTipoCirugia.loadData(dataTipoCirugia);
        
     
     
     
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                padding: 10,
                border: false,
                height: 610,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                     {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Genero',
                        id: 'sysGeneroPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 100,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 90,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 100,
                                id: 'sysLegalizaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysAutorizacionHC',
                                value: 'Nro Autorización: '
                            },
                            {
                                xtype: 'textfield',
                                width: 210,
                                allowBlank: true,
                                style: 'color:brown;',
                                readOnly: true,
                                id: 'sysNroAutorizacionHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        width: 930,
                        autoHeight: true,
                        border: false,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                anchor: '99%',
                                                fieldLabel: 'ACOMPAÑANTE',
                                                name: 'ACOMPAÑANTE',
                                                allowBlank: true,
                                                id: 'memAcompanante'
                                            },
                                            {
                                                xtype: 'textfield',
                                                anchor: '99%',
                                                fieldLabel: 'OCUPACION',
                                                name: 'OCUPACION',
                                                allowBlank: true,
                                                id: 'strOcupacion'
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'COMORBILIDADES',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 150,
                                                        allowBlank: true,
                                                        fieldLabel: 'Obesidad desde',
                                                        name: 'Obesidad desde',
                                                        id: 'strCOMORBObesidadDesde'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                name: 'Hipertension',
                                                                fieldLabel: 'Hipertension',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value:'NO',
                                                                store: 'StoreSiNo',
                                                                valuteField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strCOMORBHTA',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strCOMORBHTAObservacion').allowBlank = true;
                                                                            Ext.getCmp('strCOMORBHTAObservacion').setValue(null);
                                                                            Ext.getCmp('strCOMORBHTAObservacion').disable();
                                                                            Ext.getCmp('strCOMORBHTAObservacion').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strCOMORBHTAObservacion').enable();
                                                                            Ext.getCmp('strCOMORBHTAObservacion').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 680,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'Observaciones',
                                                                name: 'Observacion HTA',
                                                                id: 'strCOMORBHTAObservacion'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                name: 'Diabetes',
                                                                fieldLabel: 'Diabetes',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value:'NO',
                                                                store: 'StoreSiNo',
                                                                valuteField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strCOMORBDiabetes',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strCOMORBDiabetesObservacion').allowBlank = true;
                                                                            Ext.getCmp('strCOMORBDiabetesObservacion').setValue(null);
                                                                            Ext.getCmp('strCOMORBDiabetesObservacion').disable();
                                                                            Ext.getCmp('strCOMORBDiabetesObservacion').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strCOMORBDiabetesObservacion').enable();
                                                                            Ext.getCmp('strCOMORBDiabetesObservacion').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 680,
                                                                disabled: true,
                                                                emptyText: 'Observaciones',
                                                                allowBlank: true,
                                                                name: 'Observacion Diabetes',
                                                                id: 'strCOMORBDiabetesObservacion'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                name: 'Dislipidemia',
                                                                fieldLabel: 'Dislipidemia',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value:'NO',
                                                                store: 'StoreSiNo',
                                                                valuteField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strCOMORBDislipidemia',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strCOMORBDislipidemiaObservacion').allowBlank = true;
                                                                            Ext.getCmp('strCOMORBDislipidemiaObservacion').setValue(null);
                                                                            Ext.getCmp('strCOMORBDislipidemiaObservacion').disable();
                                                                            Ext.getCmp('strCOMORBDislipidemiaObservacion').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strCOMORBDislipidemiaObservacion').enable();
                                                                            Ext.getCmp('strCOMORBDislipidemiaObservacion').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 680,
                                                                disabled: true,
                                                                emptyText: 'Observaciones',
                                                                allowBlank: true,
                                                                name: 'Observacion Dislipidemia',
                                                                id: 'strCOMORBDislipidemiaObservacion'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                name: 'Enfermedad Coronaria',
                                                                fieldLabel: 'Enfermedad Coronaria',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value:'NO',
                                                                store: 'StoreSiNo',
                                                                valuteField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strCOMORBEnfermedadCoronaria',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strCOMORBEnfermedadCoronariaObservacion').allowBlank = true;
                                                                            Ext.getCmp('strCOMORBEnfermedadCoronariaObservacion').setValue(null);
                                                                            Ext.getCmp('strCOMORBEnfermedadCoronariaObservacion').disable();
                                                                            Ext.getCmp('strCOMORBEnfermedadCoronariaObservacion').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strCOMORBEnfermedadCoronariaObservacion').enable();
                                                                            Ext.getCmp('strCOMORBEnfermedadCoronariaObservacion').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 680,
                                                                disabled: true,
                                                                emptyText: 'Observaciones',
                                                                allowBlank: true,
                                                                name: 'Observacion Enfermedad Coronaria',
                                                                id: 'strCOMORBEnfermedadCoronariaObservacion'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                name: 'Enfermedad Pulmonar',
                                                                fieldLabel: 'Enfermedad Pulmonar',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value:'NO',
                                                                store: 'StoreSiNo',
                                                                valuteField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strCOMORBEnfermedadPulmonar',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strCOMORBEnfermedadPulmonarObservacion').allowBlank = true;
                                                                            Ext.getCmp('strCOMORBEnfermedadPulmonarObservacion').setValue(null);
                                                                            Ext.getCmp('strCOMORBEnfermedadPulmonarObservacion').disable();
                                                                            Ext.getCmp('strCOMORBEnfermedadPulmonarObservacion').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strCOMORBEnfermedadPulmonarObservacion').enable();
                                                                            Ext.getCmp('strCOMORBEnfermedadPulmonarObservacion').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 680,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'Observaciones',
                                                                name: 'Observacion Enfermedad Pulmonar',
                                                                id: 'strCOMORBEnfermedadPulmonarObservacion'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                name: 'Hipotiroidismo',
                                                                fieldLabel: 'Hipotiroidismo',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value:'NO',
                                                                store: 'StoreSiNo',
                                                                valuteField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strCOMORBHipotiroidismo',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strCOMORBHipotiroidismoObservacion').allowBlank = true;
                                                                            Ext.getCmp('strCOMORBHipotiroidismoObservacion').setValue(null);
                                                                            Ext.getCmp('strCOMORBHipotiroidismoObservacion').disable();
                                                                            Ext.getCmp('strCOMORBHipotiroidismoObservacion').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strCOMORBHipotiroidismoObservacion').enable();
                                                                            Ext.getCmp('strCOMORBHipotiroidismoObservacion').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 680,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'Observaciones',
                                                                name: 'Observacion Hipotiroidismo',
                                                                id: 'strCOMORBHipotiroidismoObservacion'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                name: 'Enf. Osteoarticular',
                                                                fieldLabel: 'Enf. Osteoarticular',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value:'NO',
                                                                store: 'StoreSiNo',
                                                                valuteField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strCOMORBEnfOsteoarticular',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strCOMORBEnfOsteoarticularObservacion').allowBlank = true;
                                                                            Ext.getCmp('strCOMORBEnfOsteoarticularObservacion').setValue(null);
                                                                            Ext.getCmp('strCOMORBEnfOsteoarticularObservacion').disable();
                                                                            Ext.getCmp('strCOMORBEnfOsteoarticularObservacion').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strCOMORBEnfOsteoarticularObservacion').enable();
                                                                            Ext.getCmp('strCOMORBEnfOsteoarticularObservacion').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 680,
                                                                disabled: true,
                                                                emptyText: 'Observaciones',
                                                                allowBlank: true,
                                                                name: 'Observacion Enf. Osteoarticular',
                                                                id: 'strCOMORBEnfOsteoarticularObservacion'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                name: 'Insuficiencia Venosa (Varices)',
                                                                fieldLabel: 'Insuficiencia Venosa (Varices)',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value:'NO',
                                                                store: 'StoreSiNo',
                                                                valuteField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strCOMORBInsVernosa',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strCOMORBInsVenosaObservacion').allowBlank = true;
                                                                            Ext.getCmp('strCOMORBInsVenosaObservacion').setValue(null);
                                                                            Ext.getCmp('strCOMORBInsVenosaObservacion').disable();
                                                                            Ext.getCmp('strCOMORBInsVenosaObservacion').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strCOMORBInsVenosaObservacion').enable();
                                                                            Ext.getCmp('strCOMORBInsVenosaObservacion').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 680,
                                                                disabled: true,
                                                                emptyText: 'Observaciones',
                                                                allowBlank: true,
                                                                name: 'Observacion Insuficiencia Venosa (Varices)',
                                                                id: 'strCOMORBInsVenosaObservacion'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EVALUACIONES PREVIAS',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'EVALUACIONES PREVIAS',
                                                        name: 'EVALUACIONES PREVIAS',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,           
                                                        allowBlank: false,
                                                        id: 'memEvaluacionesPrevias'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'OTROS MEDICAMENTOS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '99%',
                                                        width: 850,
                                                        fieldLabel: 'OTROS MEDICAMENTOS',
                                                        name: 'OTROS MEDICAMENTOS',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,           
                                                        allowBlank: false,
                                                        id: 'memOtrosMedicamentos'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '99%',
                                                        allowBlank: true,
                                                        name: 'Consumo (ASA)',
                                                        fieldLabel: 'Consumo (ASA)',
                                                        id: 'strConsumoASA'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '99%',
                                                        allowBlank: true,
                                                        name: 'Consumo Ginkgo Biloba',
                                                        fieldLabel: 'Consumo Ginkgo Biloba',
                                                        id: 'strConsumoGinkgoBiloba'
                                                    },
                                                ]
                                            },
                                            
                                            {
                                                xtype: 'fieldset',
                                                title: 'OTROS ANTECEDENTES',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '99%',
                                                        allowBlank: true,
                                                        name: 'Patologicos',
                                                        fieldLabel: 'Patologicos',
                                                        id: 'strAntPatologicos'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '99%',
                                                        allowBlank: true,
                                                        name: 'Quirurgicos',
                                                        fieldLabel: 'Quirurgicos',
                                                        id: 'strAntQuirurgicos'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '99%',
                                                        allowBlank: true,
                                                        name: 'Alergicos',
                                                        fieldLabel: 'Alergicos',
                                                        id: 'strAntAlergicos'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                name: 'Fuma',
                                                                fieldLabel: 'Fuma',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value:'NO',
                                                                store: 'StoreSiNo',
                                                                valuteField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strAntFuma',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strAntFumaObser').allowBlank = true;
                                                                            Ext.getCmp('strAntFumaObser').setValue(null);
                                                                            Ext.getCmp('strAntFumaObser').disable();
                                                                            Ext.getCmp('strAntFumaObser').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAntFumaObser').enable();
                                                                            Ext.getCmp('strAntFumaObser').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 680,
                                                                disabled: true,
                                                                emptyText: 'Observaciones',
                                                                allowBlank: true,
                                                                name: 'Observaciones',
                                                                id: 'strAntFumaObser'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                name: 'Consume Alcohol',
                                                                fieldLabel: 'Consume Alcohol',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value:'NO',
                                                                store: 'StoreSiNo',
                                                                valuteField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strAntConsumeAlcohol',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strAntConsuAlcoholObser').allowBlank = true;
                                                                            Ext.getCmp('strAntConsuAlcoholObser').setValue(null);
                                                                            Ext.getCmp('strAntConsuAlcoholObser').disable();
                                                                            Ext.getCmp('strAntConsuAlcoholObser').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAntConsuAlcoholObser').enable();
                                                                            Ext.getCmp('strAntConsuAlcoholObser').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 680,
                                                                disabled: true,
                                                                emptyText: 'Observaciones',
                                                                allowBlank: true,
                                                                name: 'Observaciones',
                                                                id: 'strAntConsuAlcoholObser'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                name: 'Infecciones Recurrentes',
                                                                fieldLabel: 'Infecciones Recurrentes',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value:'NO',
                                                                store: 'StoreSiNo',
                                                                valuteField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strAntInfecRecu',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strAntInfecRecuObser').allowBlank = true;
                                                                            Ext.getCmp('strAntInfecRecuObser').setValue(null);
                                                                            Ext.getCmp('strAntInfecRecuObser').disable();
                                                                            Ext.getCmp('strAntInfecRecuObser').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAntInfecRecuObser').enable();
                                                                            Ext.getCmp('strAntInfecRecuObser').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 680,
                                                                disabled: true,
                                                                emptyText: 'Observaciones',
                                                                allowBlank: true,
                                                                name: 'Observaciones',
                                                                id: 'strAntInfecRecuObser'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {   
                                                                xtype: 'combo',
                                                                name: 'Frecuente Uso Antibioticos',
                                                                fieldLabel: 'Frecuente Uso Antibioticos',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value:'NO',
                                                                store: 'StoreSiNo',
                                                                valuteField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strAntUsoAntibio',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue == "NO"){
                                                                            Ext.getCmp('strAntUsoAntibioObser').allowBlank = true;
                                                                            Ext.getCmp('strAntUsoAntibioObser').setValue(null);
                                                                            Ext.getCmp('strAntUsoAntibioObser').disable();
                                                                            Ext.getCmp('strAntUsoAntibioObser').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAntUsoAntibioObser').enable();
                                                                            Ext.getCmp('strAntUsoAntibioObser').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 680,
                                                                disabled: true,
                                                                emptyText: 'Observaciones',
                                                                allowBlank: true,
                                                                name: 'Observaciones',
                                                                id: 'strAntUsoAntibioObser'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'Tratamientos Previos Obesidad',
                                                        layout: 'table',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 7,
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                anchor: '99%',
                                                                height: 30,
                                                                grow: true,
                                                                minGrow: 30,  
                                                                fieldLabel: 'Tratamientos Previos Obesidad',
                                                                name: 'Tratamientos Previos Obesidad',
                                                                allowBlank: false,
                                                                id: 'memTratamientosPreviosObesidad'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EXAMENES PREQUIRURGICOS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '99%',
                                                        allowBlank: true,
                                                        name: 'Electrocardiograma',
                                                        fieldLabel: 'Electrocardiograma',
                                                        id: 'strPreQxEKG'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '99%',
                                                        allowBlank: true,
                                                        name: 'Endoscopia Digestiva Alta',
                                                        fieldLabel: 'Endoscopia Digestiva Alta',
                                                        id: 'strPreQxEnDiAl'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '99%',
                                                        allowBlank: true,
                                                        name: 'Ecografia Abdominal',
                                                        fieldLabel: 'Ecografia Abdominal',
                                                        id: 'strPreQxEcoAbd'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '99%',
                                                        allowBlank: true,
                                                        name: 'Polisomnografia',
                                                        fieldLabel: 'Polisomnografia',
                                                        id: 'strPreQxPolisomnografia'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '99%',
                                                        allowBlank: true,
                                                        name: 'Ecocardiograma',
                                                        fieldLabel: 'Ecocardiograma',
                                                        id: 'strPreQxEcocardiograma'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '99%',
                                                        allowBlank: true,
                                                        name: 'Prueba de Esfuerzo',
                                                        fieldLabel: 'Prueba de Esfuerzo',
                                                        id: 'strPreQxPruebaEsfuerzo'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '99%',
                                                        allowBlank: true,
                                                        name: 'Espirometria',
                                                        fieldLabel: 'Espirometria',
                                                        id: 'strPreQxEspirometria'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EXAMEN FISICO',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 80,
                                                                allowBlank: true,
                                                                name: 'TA',
                                                                fieldLabel: 'TA',
                                                                id: 'strEFTA'
                                                            },
                                                            {
                                                                html: 'FC:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 80,
                                                                allowBlank: true,
                                                                name: 'FC',
                                                                id: 'strEFFC'
                                                            },
                                                            {
                                                                html: 'SAO2:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 80,
                                                                allowBlank: true,
                                                                name: 'SAO2',
                                                                id: 'strEFSAO2'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'TALLA (cm)',
                                                                name:"TALLA (cm)",
                                                                emptyText: '(cm)',
                                                                id: 'intEF_Talla',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEF_Talla').setValue(null);
                                                                            Ext.getCmp('intEF_IMC').setValue(0);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('intEF_Peso').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEF_Talla').getValue() / 100;
                                                                                Ext.getCmp('intEF_IMC').setValue(Ext.getCmp('intEF_Peso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEF_IMC').setValue(0);
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('intEF_IMC').getValue()<1){
                                                                           Ext.getCmp('strEF_IMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEF_IMC').getValue()<24.9){
                                                                               Ext.getCmp('strEF_IMCClasificacon').setValue("ACEPTABLE");
                                                                            }else{
                                                                                if(Ext.getCmp('intEF_IMC').getValue()<29.9){
                                                                                   Ext.getCmp('strEF_IMCClasificacon').setValue("SOBREPESO");
                                                                                }else{
                                                                                    Ext.getCmp('strEF_IMCClasificacon').setValue("OBESIDAD");
                                                                                }

                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEF02',
                                                                value: 'PESO (Kg): '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                emptyText: '(Kg)',
                                                                name:"PESO (Kg)",
                                                                id: 'intEF_Peso',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEF_Peso').setValue(null);
                                                                            Ext.getCmp('intEF_IMC').setValue(0);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('intEF_Talla').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEF_Talla').getValue() / 100;
                                                                                Ext.getCmp('intEF_IMC').setValue(Ext.getCmp('intEF_Peso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEF_IMC').setValue(0);
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('intEF_IMC').getValue()<1){
                                                                           Ext.getCmp('strEF_IMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEF_IMC').getValue()<24.9){
                                                                               Ext.getCmp('strEF_IMCClasificacon').setValue("ACEPTABLE");
                                                                            }else{
                                                                                if(Ext.getCmp('intEF_IMC').getValue()<29.9){
                                                                                   Ext.getCmp('strEF_IMCClasificacon').setValue("SOBREPESO");
                                                                                }else{
                                                                                    if(Ext.getCmp('intEF_IMC').getValue()<34.9){
                                                                                       Ext.getCmp('strEF_IMCClasificacon').setValue("OBESIDAD PRIMER GRADO");
                                                                                    }else{
                                                                                        if(Ext.getCmp('intEF_IMC').getValue()<39.9){
                                                                                           Ext.getCmp('strEF_IMCClasificacon').setValue("OBESIDAD SEGUNDO GRADO");
                                                                                        }else{
                                                                                            Ext.getCmp('strEF_IMCClasificacon').setValue("OBESIDAD TERCER GRADO");
                                                                                        }
                                                                                    }
                                                                                }

                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEF03',
                                                                value: 'IMC: '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                name: "IMC",
                                                                id: 'intEF_IMC'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                name: "IMC - CLASIFICACION",
                                                                id: 'strEF_IMCClasificacon'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'Cintura (cm)',
                                                                name:"Cintura (cm)",
                                                                emptyText: '(cm)',
                                                                id: 'intEF_Cintura'
                                                            },
                                                            {
                                                                html: 'Cadera'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"Cadera (cm)",
                                                                emptyText: '(cm)',
                                                                id: 'intEF_Cadera'
                                                            },
                                                            {
                                                                html: 'Cuello'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"Cuello (cm)",
                                                                emptyText: '(cm)',
                                                                id: 'intEF_Cuello'
                                                            },
                                                            {
                                                                html: 'Brazo'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"Brazo (cm)",
                                                                emptyText: '(cm)',
                                                                id: 'intEF_Brazo'
                                                            },
                                                            {
                                                                html: 'Muslo'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"Muslo (cm)",
                                                                emptyText: '(cm)',
                                                                id: 'intEF_Muslo'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '99%',
                                                        allowBlank: true,
                                                        name: 'Cuello',
                                                        fieldLabel: 'Cuello',
                                                        id: 'strEFCuello'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '99%',
                                                        allowBlank: true,
                                                        name: 'Cardiopulmonar',
                                                        fieldLabel: 'Cardiopulmonar',
                                                        id: 'strEFCardiopulmonar'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '99%',
                                                        allowBlank: true,
                                                        name: 'Abdomen',
                                                        fieldLabel: 'Abdomen',
                                                        id: 'strEFAbdomen'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '99%',
                                                        allowBlank: true,
                                                        name: 'Extremidades Inferiores',
                                                        fieldLabel: 'Extremidades Inferiores',
                                                        id: 'strEFExtremidadesInferiores'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '99%',
                                                        allowBlank: true,
                                                        name: 'Piel',
                                                        fieldLabel: 'Piel',
                                                        id: 'strEFPiel'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '99%',
                                                        allowBlank: true,
                                                        name: 'Otros',
                                                        fieldLabel: 'Otros',
                                                        id: 'strEFOtros'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'PLAN',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'PLAN',
                                                        name: 'PLAN',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,           
                                                        allowBlank: true,
                                                        value: '1. COMPLETAR PARACLINICOS PREQUIRURGICOS PRIORITARIO (CIRUGIA BARIATRICA): EKG. CREATININA - GLICEMIA BASAL Y POSTCARGA 75 GM GLUCOSA - TP - INR – TPT - PARCIAL DE ORINA MAS GRAM - CUADRO HEMATICO AUTOMATIZADO - AST – ALT – FERRITINA - FOSFATASA ALCALINA - PERFIL LIPIDICO COMPLETO - TSH.\n\n2. INICIAR DIETA SUGERIDA POR NUTRICION CUANDO ORDENE CIRUGIA, CON RESTRICCION DE CARBOHIDRATOS (AZÚCARES – HARINAS) (PARA DISMINUIR RIESGO DE COMPLICACIONES INTRAOPERATORIAS).\n\n3. BAÑO DIARIO DESDE TRES DIAS ANTES Y HASTA TRES DIAS DESPUES DE LA CIRUGIA, REALIZANDO UN FROTE CON LAS MANOS (NO CEPILLOS NI ESPONJAS NI ESTROPAJOS) CON CLORHEXIDINA JABON QUIRURGICO, EN LOS SIGUIENTES PLIEGUES: CUELLO - AXILAS – DEBAJO DE LOS SENOS - OMBLIGO – PLIEGUES INGUINALES – DEBAJO DEL ABDOMEN – ENTRE LOS GLUTEOS – DETR?S DE LAS RODILLAS - ENTRE LOS DEDOS DE MANOS Y DE LOS PIES. ESPECIAL ENFASIS LA NOCHE PREVIA Y LA MAÑANA ANTES DE LA CIRUGIA.\n\n4. COMO SU PIEL PUEDE RESECARSE POR LA RUTINA DE BAÑO A SEGUIR, SE SUGIERE HIDRATACION DE LA PIEL CON CREMA PARA PIEL EXTRASECA, PARA QUE SU PIEL ESTE INTACTA EL DIA DE LA CIRUGIA (SIN MICROFISURAS DADAS POR LA RESEQUEDAD).\n\n5. TROMBOPROFILAXIS PREVIA A CIRUGIA – COMENZAR USO DE MEDIAS ANTIEMBOLICAS AL HOSPITALIZARSE, DURANTE Y DESPUES DE LA CIRUGIA\n\n6. SEGUIMIENTO POR GRUPO INTERDISCIPLINARIO INTRA Y POST-OPERATORIO.',
                                                        id: 'memPlan'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'PROGRAMACION CIRUGIA',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Tipo Cirugia',
                                                                fieldLabel: 'Tipo Cirugia',
                                                                width: 200,
                                                                allowBlank: true,
                                                                store: stTipoCirugia,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 'CIRUGIA BARIATRICA POR LAPAROSCOPIA',
                                                                id: 'strTipoCx'
                                                            },
                                                            {
                                                                html: 'Fecha Probable:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'Fecha Probable',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecFechaProbable'
                                                            },
                                                            {
                                                                html: 'Clinica:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 300,
                                                                allowBlank: true,
                                                                name: 'Clinica',
                                                                id: 'strClinicaCx'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'INCAPACIDAD',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Dias',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 50,
                                                                name: 'INCAPACIDAD DIAS',
                                                                minValue: 0,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                id: 'intDiasIncapacidad',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        //new Date(año,mes,dia) 01/05/2010
                                                                        if(Ext.getCmp('fecDesdeIncapacidad').getValue() == null || Ext.getCmp('fecDesdeIncapacidad').getValue() == ""){
                                                                            Ext.getCmp('fecDesdeIncapacidad').setValue(new Date().format('d/m/Y'))
                                                                        }
                                                                        var xFecha = Ext.getCmp('fecDesdeIncapacidad').getValue().format('d/m/Y')
                                                                        var xMes = xFecha.substr(3,2);
                                                                        var NewFecha = new Date(xFecha.substr(6,10),(xMes-1),xFecha.substr(0,2));
                                                                        if(pNew > 0)
                                                                            DiasIncapacidad = pNew - 1;
                                                                        else
                                                                            DiasIncapacidad = pNew;
                                                                        NewFecha.setDate(NewFecha.getDate()+DiasIncapacidad);
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(NewFecha.format('d/m/Y'));
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysIncDsd',
                                                                value: 'Desde:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'INCAPACIDAD DESDE',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecDesdeIncapacidad',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(null);
                                                                        Ext.getCmp('fecHastaIncapacidad').setMinValue(pNew.format("d/m/Y"));
                                                                        Ext.getCmp('fecHastaIncapacidad').clearInvalid();
                                                                        var xFecha = pNew.format('d/m/Y')
                                                                        var xMes = xFecha.substr(3,2);
                                                                        var NewFecha = new Date(xFecha.substr(6,10),(xMes-1),xFecha.substr(0,2));
                                                                        if(Ext.getCmp('intDiasIncapacidad').getValue() > 0){
                                                                            DiasIncapacidad = Ext.getCmp('intDiasIncapacidad').getValue() - 1;
                                                                        }else{
                                                                            DiasIncapacidad = Ext.getCmp('intDiasIncapacidad').getValue();
                                                                        }
                                                                        NewFecha.setDate(NewFecha.getDate()+DiasIncapacidad);
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(NewFecha.format('d/m/Y'));
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysIncHst',
                                                                value: 'Hasta:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'INCAPACIDAD HASTA',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecHastaIncapacidad'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Observaciones',
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                anchor: '100%',
                                                                width: 615,
                                                                name: 'INCAPACIDAD OBSERVACIONES',
                                                                height: 50,
                                                                allowBlank: true,
                                                                id: 'memIncapacidadObserva'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnImprimir',
                                                                text: 'Imprimir Incapacidad',
                                                                tooltip: 'Imprimir Incapacidad',
                                                                id: 'btnPrintIncapacidadHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        if (Ext.getCmp('sysYaGuardoHC').getValue() == 1)
                                                                            window.open ("../../controlador/asistencial/printincapacidad0.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pCAS=" + Ext.getCmp('sysCASHC').getValue() + "&pConsecutivo=" + Ext.getCmp('sysConsecutivoDetalleHC').getValue(),"Incapacidad");
                                                                        else{
                                                                            Ext.Msg.show({
                                                                                title: 'eOfiClinic',
                                                                                msg: 'Usted No ha Guardado la Evolución',
                                                                                buttons: Ext.Msg.OK,
                                                                                icon: Ext.Msg.ERROR
                                                                            });
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsRips',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                value: 'E669',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 3,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }                            
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 352,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                            /*,
                            {
                                xtype: 'panel',
                                title: 'Solicitud CTC',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaCTC',
                                items: [
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                items: [
                                ]
                            },*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    if (Ext.getCmp('sysUsaGridSalida').getValue() == 1){
                                                        Ext.getCmp('gridFormulario').store.reload();
                                                    }
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistros();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistros();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winHCCPBOTERO001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
