/*
* @category    Formulario Modelo Evolucion Historia Clinica Abelardo Montenegro 001
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCamontenegro001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC - Especialistas ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
            
        var dataAparienciaPie = [
            ['NORMAL'],
            ['DEFORMIDADES'],
            ['PIEL SECA'],
            ['FISURAS'],
            ['CALLOS'],
            ['INFECCION'],
            ['OTRA']
        ];
        var stAparienciaPie = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stAparienciaPie.loadData(dataAparienciaPie);
    
        var dataRefelejoAquileano = [
            ['PRESENTE'],
            ['DEBIL'],
            ['AUSENTE']
        ];
        var stRefelejoAquileano = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stRefelejoAquileano.loadData(dataRefelejoAquileano);
        
        var dataPieNormalAnormal = [
            ['NORMAL'],
            ['ANORMAL']
        ];
        var stPieNormalAnormal = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stPieNormalAnormal.loadData(dataPieNormalAnormal);
        
        var dataIndicetobilloBrazo = [
            ['MAYOR A 1'],
            ['MENOR A 1 PERO MAYOR A 0.5'],
            ['MENOR A 0.5 (ISQUEMIA GRAVE)']
        ];
        var stIndicetobilloBrazo = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stIndicetobilloBrazo.loadData(dataIndicetobilloBrazo);
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                padding: 10,
                border: false,
                height: 610,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 100,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 90,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 100,
                                id: 'sysLegalizaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysAutorizacionHC',
                                value: 'Nro Autorización: '
                            },
                            {
                                xtype: 'textfield',
                                width: 210,
                                allowBlank: true,
                                style: 'color:brown;',
                                readOnly: true,
                                id: 'sysNroAutorizacionHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 120,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroPacHC'
                            },
                            {
                                html: 'Fecha Nacimiento'
                            },
                            {
                                xtype: 'datefield',
                                width: 120,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFecNacPacHC'
                            },
                            {
                                html: 'Edad'
                            },
                            {
                                xtype: 'textfield',
                                width: 250,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysEdadPacHC'
                            }
                        ]
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        width: 930,
                        autoHeight: true,
                        border: false,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'fieldset',
                                                title: 'MOTIVO DE CONSULTA',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'MOTIVO DE CONSULTA',
                                                        name: 'MOTIVO DE CONSULTA',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: false,
                                                        id: 'memMotivoConsulta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ENFERMEDAD ACTUAL',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'ENFERMEDAD ACTUAL',
                                                        name: 'ENFERMEDAD ACTUAL',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,          
                                                        allowBlank: false,
                                                        id: 'memEnfermedadActual'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES PERSONALES',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'ANTECEDENTES PERSONALES',
                                                        name: 'ANTECEDENTES PERSONALES',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,            
                                                        allowBlank: false,
                                                        id: 'memAntecedentesPersonales'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES FAMILIARES',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'ANTECEDENTES FAMILIARES',
                                                        name: 'ANTECEDENTES FAMILIARES',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,            
                                                        allowBlank: false,
                                                        id: 'memAntecedentesFamiliares'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EXAMEN FISICO',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 70,
                                                                fieldLabel: 'TA SENTADO',
                                                                name: 'TA SENTADO',
                                                                allowBlank: true,
                                                                id: 'strEF_TASentado'
                                                            },
                                                            {
                                                                html: 'TA ACOSTADO: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 70,
                                                                name: 'TA ACOSTADO',
                                                                allowBlank: true,
                                                                id: 'strEF_TAAcostado'
                                                            },
                                                            {
                                                                html: 'TA DE PIE: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 70,
                                                                name: 'TA DE PIE',
                                                                allowBlank: true,
                                                                id: 'strEF_TAPie'
                                                            },
                                                            {
                                                                html: 'FC: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 70,
                                                                name: 'FC',
                                                                allowBlank: true,
                                                                id: 'strEF_FC'
                                                            },
                                                            {
                                                                html: 'FR: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 70,
                                                                name: 'FR',
                                                                allowBlank: true,
                                                                id: 'strEF_FR'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'TALLA (cm)',
                                                                name:"TALLA (cm)",
                                                                emptyText: '(cm)',
                                                                id: 'intEF_Talla',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEF_Talla').setValue(null);
                                                                            Ext.getCmp('intEF_PESOIDEAL').setValue(null);
                                                                            Ext.getCmp('intEF_PESOKILOSMAS').setValue(null);
                                                                            Ext.getCmp('intEF_IMC').setValue(0);
                                                                        }else{
                                                                            var pTalla = Ext.getCmp('intEF_Talla').getValue() / 100;
                                                                            Ext.getCmp('intEF_PESOIDEAL').setValue(parseInt((pTalla*pTalla*24.9)+0.5));
                                                                            if(Ext.getCmp('intEF_Peso').getValue() > 0){
                                                                                Ext.getCmp('intEF_IMC').setValue(Ext.getCmp('intEF_Peso').getValue()/(pTalla*pTalla));
                                                                                Ext.getCmp('intEF_PESOKILOSMAS').setValue(Ext.getCmp('intEF_Peso').getValue()-Ext.getCmp('intEF_PESOIDEAL').getValue());
                                                                                if(Ext.getCmp('intEF_PESOKILOSMAS').getValue()<1){
                                                                                    Ext.getCmp('intEF_PESOKILOSMAS').setValue(null);
                                                                                }
                                                                            }else{
                                                                                Ext.getCmp('intEF_IMC').setValue(0);
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('intEF_IMC').getValue()<1){
                                                                           Ext.getCmp('strEF_IMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEF_IMC').getValue()<24.9){
                                                                               Ext.getCmp('strEF_IMCClasificacon').setValue("ACEPTABLE");
                                                                            }else{
                                                                                if(Ext.getCmp('intEF_IMC').getValue()<29.9){
                                                                                   Ext.getCmp('strEF_IMCClasificacon').setValue("SOBREPESO");
                                                                                }else{
                                                                                    Ext.getCmp('strEF_IMCClasificacon').setValue("OBESIDAD");
                                                                                }

                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'PESO (Kg): '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                emptyText: '(Kg)',
                                                                name:"PESO (Kg)",
                                                                id: 'intEF_Peso',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEF_Peso').setValue(null);
                                                                            Ext.getCmp('intEF_PESOKILOSMAS').setValue(null);
                                                                            Ext.getCmp('intEF_IMC').setValue(0);
                                                                            Ext.getCmp('intEF_TASACOCKROFT').setValue(null);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('intEF_CREATININASERICA').getValue() > 0 && Ext.getCmp('intEF_CREATININASERICA').getValue() != null){
                                                                                Ext.getCmp('intEF_TASACOCKROFT').setValue(TasaCockroft(Ext.getCmp('intEF_Peso').getValue(), MostrarEdadAniosT(new Date().format('Y/m/d'),Ext.getCmp('sysFecNacPacHC').getValue().format('Y/m/d')), Ext.getCmp('sysGeneroPacHC').getValue(), Ext.getCmp('intEF_CREATININASERICA').getValue()));
                                                                            }
                                                                            if(Ext.getCmp('intEF_Talla').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEF_Talla').getValue() / 100;
                                                                                Ext.getCmp('intEF_IMC').setValue(Ext.getCmp('intEF_Peso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEF_IMC').setValue(0);
                                                                            }
                                                                            Ext.getCmp('intEF_PESOKILOSMAS').setValue(Ext.getCmp('intEF_Peso').getValue()-Ext.getCmp('intEF_PESOIDEAL').getValue());
                                                                            if(Ext.getCmp('intEF_PESOKILOSMAS').getValue()<1){
                                                                                Ext.getCmp('intEF_PESOKILOSMAS').setValue(null);
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('intEF_IMC').getValue()<1){
                                                                           Ext.getCmp('strEF_IMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEF_IMC').getValue()<24.9){
                                                                               Ext.getCmp('strEF_IMCClasificacon').setValue("ACEPTABLE");
                                                                            }else{
                                                                                if(Ext.getCmp('intEF_IMC').getValue()<29.9){
                                                                                   Ext.getCmp('strEF_IMCClasificacon').setValue("SOBREPESO");
                                                                                }else{
                                                                                    Ext.getCmp('strEF_IMCClasificacon').setValue("OBESIDAD");
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'PESO IDEAL (Kg): '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                name: "PESO IDEAL",
                                                                style: 'color: blue;text-align:center',
                                                                id: 'intEF_PESOIDEAL'
                                                            },
                                                            {
                                                                html: 'IMC: '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                name: "IMC",
                                                                id: 'intEF_IMC'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 90,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                name: "IMC - CLASIFICACION",
                                                                id: 'strEF_IMCClasificacon'
                                                            },
                                                            {
                                                                html: 'KILOS SOBREPESO: '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                name: "# KILOS SOBREPESO",
                                                                style: 'color: red;text-align:center',
                                                                id: 'intEF_PESOKILOSMAS'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'CIRCUNFERENCIA ABDOMINAL: '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'CIRCUNFERENCIA ABDOMINAL',
                                                                allowBlank: true,
                                                                id: 'intEF_CIRCUNFERENCIAABDOMINAL'
                                                            },
                                                            {
                                                                html: 'CREATININA SERICA: '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                decimalPrecision: 2,
                                                                name: 'CREATININA SERICA',
                                                                allowBlank: true,
                                                                id: 'intEF_CREATININASERICA',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEF_TASACOCKROFT').setValue(null);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2] rafa
                                                                            if(Ext.getCmp('intEF_Peso').getValue() > 0){
                                                                                Ext.getCmp('intEF_TASACOCKROFT').setValue(TasaCockroft(Ext.getCmp('intEF_Peso').getValue(), MostrarEdadAniosT(new Date().format('Y/m/d'),Ext.getCmp('sysFecNacPacHC').getValue().format('Y/m/d')), Ext.getCmp('sysGeneroPacHC').getValue(), Ext.getCmp('intEF_CREATININASERICA').getValue()));
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'TASA COCKROFT: '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'TASA COCKROFT',
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                id: 'intEF_TASACOCKROFT'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'OTROS',
                                                        name: 'OTROS',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,            
                                                        allowBlank: true,
                                                        id: 'memEF_OTROS'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'LABORATORIOS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                labelWidth: 175,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 450,
                                                                allowBlank: true,
                                                                fieldLabel: 'HEMOGRAMA',
                                                                name: "HEMOGRAMA",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_HEOGRAMA'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                name: 'fecLAB_HEMOGRAMA',
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                id: 'fecLAB_HEMOGRAMA'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 150,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'VSG',
                                                                name: "VSG",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_VSG'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                name: 'fecLAB_VSG',
                                                                id: 'fecLAB_VSG'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_VSG'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                //xtype: 'numberfield',
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                //decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'E.S.P',
                                                                name: "E.S.P",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_ESP'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                name: 'fecLAB_ESP',
                                                                id: 'fecLAB_ESP'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_ESP'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                //xtype: 'numberfield',
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                //decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'RETICULOCITOS',
                                                                name: "RETICULOCITOS",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_RETICULOCITOS'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                name: 'fecLAB_RETICULOCITOS',
                                                                id: 'fecLAB_RETICULOCITOS'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_RETICULOCITOS'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                //xtype: 'numberfield',
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                //decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'FERRITINA',
                                                                name: "FERRITINA",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_FERRITINA'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                name: 'fecLAB_FERRITINA',
                                                                id: 'fecLAB_FERRITINA'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_FERRITINA'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                //xtype: 'numberfield',
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                //decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'HIERRO SERICO',
                                                                name: "HIERRO SERICO",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_HIERROSERICO'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                name: 'fecLAB_HIERROSERICO',
                                                                id: 'fecLAB_HIERROSERICO'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_HIERROSERICO'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                //xtype: 'numberfield',
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                //decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'HBA1C GLICOSILADA',
                                                                name: "HBA1C GLICOSILADA",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_HBA1C'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                name: 'fecLAB_HBA1C',
                                                                id: 'fecLAB_HBA1C'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_HBA1C'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                //xtype: 'numberfield',
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                //decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'GLICEMIA',
                                                                name: "GLICEMIA",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_GLICEMIA'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                name: 'fecLAB_GLICEMIA',
                                                                id: 'fecLAB_GLICEMIA'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_GLICEMIA'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                //xtype: 'numberfield',
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                //decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'CREATININA/BUN',
                                                                name: "CREATININA/BUN",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_CREATININABUN'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                name: 'fecLAB_CREATININABUN',
                                                                id: 'fecLAB_CREATININABUN'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_CREATININABUN'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 450,
                                                                allowBlank: true,
                                                                fieldLabel: 'PARCIAL DE ORINA',
                                                                name: "PARCIAL DE ORINA",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_PARCIALORINA'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                name: 'fecLAB_PARCIALORINA',
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                id: 'fecLAB_PARCIALORINA'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                //xtype: 'numberfield',
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                //decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'SODIO',
                                                                name: "SODIO",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_SODIO'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                name: 'fecLAB_SODIO',
                                                                id: 'fecLAB_SODIO'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_SODIO'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                //xtype: 'numberfield',
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                //decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'POTASIO',
                                                                name: "POTASIO",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_POTASIO'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                name: 'fecLAB_POTASIO',
                                                                id: 'fecLAB_POTASIO'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_POTASIO'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                //xtype: 'numberfield',
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                //decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'FOSFORO',
                                                                name: "FOSFORO",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_FOSFORO'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                name: 'fecLAB_FOSFORO',
                                                                id: 'fecLAB_FOSFORO'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_FOSFORO'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                //xtype: 'numberfield',
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                //decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'CALCIO',
                                                                name: "CALCIO",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_CALCIO'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                name: 'fecLAB_CALCIO',
                                                                id: 'fecLAB_CALCIO'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_CALCIO'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                //xtype: 'numberfield',
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                //decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'PROTEINURIA 24 HORAS',
                                                                name: "PROTEINURIA 24 HORAS",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_PROTEINURIA24'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                name: 'fecLAB_PROTEINURIA24',
                                                                id: 'fecLAB_PROTEINURIA24'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_PROTEINURIA24'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                //xtype: 'numberfield',
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                //decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'DEPURACION DE CREATININA ENDOGENA',
                                                                name: "DEPURACION DE CREATININA ENDOGENA",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_DEPURACIONCREATININA'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                name: 'fecLAB_DEPURACIONCREATININA',
                                                                id: 'fecLAB_DEPURACIONCREATININA'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_DEPURACIONCREATININA'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                //xtype: 'numberfield',
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                //decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'MICROALBUMINURIA',
                                                                name: "MICROALBUMINURIA",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_MICROALBUMINURIA'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                name: 'fecLAB_MICROALBUMINURIA',
                                                                id: 'fecLAB_MICROALBUMINURIA'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_MICROALBUMINURIA'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                //xtype: 'numberfield',
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                //decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'ALT/AST',
                                                                name: "ALT/AST",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_ALTAST'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                name: 'fecLAB_ALTAST',
                                                                id: 'fecLAB_ALTAST'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_ALTAST'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                //xtype: 'numberfield',
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                //decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'FOSFATASA ALCALINA',
                                                                name: "FOSFATASA ALCALINA",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_FOSFATASAALCALINA'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                name: 'fecLAB_FOSFATASAALCALINA',
                                                                id: 'fecLAB_FOSFATASAALCALINA'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_FOSFATASAALCALINA'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                //xtype: 'numberfield',
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                //decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'ALBUMINA',
                                                                name: "ALBUMINA",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_ALBUMINA'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                name: 'fecLAB_ALBUMINA',
                                                                id: 'fecLAB_ALBUMINA'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_ALBUMINA'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 150,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'COLESTEROL TOTAL',
                                                                name:"COLESTEROL TOTAL",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_COLEST'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                name: 'fecLAB_COLEST',
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                id: 'fecLAB_COLEST'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_COLEST'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 150,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel:"COLESTEROL HDL",
                                                                name:"COLESTEROL HDL",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_COLESHDL'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                name: 'fecLAB_COLESHDL',
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                id: 'fecLAB_COLESHDL'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_COLESHDL'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 150,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel:"COLESTEROL LDL",
                                                                name:"COLESTEROL LDL",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_COLESLDL'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                name: 'fecLAB_COLESLDL',
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                id: 'fecLAB_COLESLDL'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_COLESLDL'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 150,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel:"TRIGLICERIDOS",
                                                                name:"TRIGLICERIDOS",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_TRIGLICERIDOS'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                name: 'fecLAB_TRIGLICERIDOS',
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                id: 'fecLAB_TRIGLICERIDOS'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_TRIGLICERIDOS'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                //xtype: 'numberfield',
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                //decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'TSH',
                                                                name: "TSH",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_TSH'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                name: 'fecLAB_TSH',
                                                                id: 'fecLAB_TSH'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_TSH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                //xtype: 'numberfield',
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                //decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'T4 LIBRE',
                                                                name: "T4 LIBRE",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_T4LIBRE'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                name: 'fecLAB_T4 LIBRE',
                                                                id: 'fecLAB_T4LIBRE'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_T4LIBRE'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                //xtype: 'numberfield',
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                //decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'ANAS x IFI',
                                                                name: "ANAS x IFI",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_ANASxIFI'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                name: 'fecLAB_ANASxIFI',
                                                                id: 'fecLAB_ANASxIFI'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_ANASxIFI'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                //xtype: 'numberfield',
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                //decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'FACTOR REMATOIDEO',
                                                                name: "FACTOR REMATOIDEO",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_FACTORREMATOIDEO'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                name: 'fecLAB_FACTORREMATOIDEO',
                                                                id: 'fecLAB_FACTORREMATOIDEO'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_FACTORREMATOIDEO'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                //xtype: 'numberfield',
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                //decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'ANTI RO/SSA',
                                                                name: "ANTI RO/SSA",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_ANTIROSSA'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                name: 'fecLAB_ANTIROSSA',
                                                                id: 'fecLAB_ANTIROSSA'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_ANTIROSSA'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                //xtype: 'numberfield',
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                //decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'ANTI LA/SSB',
                                                                name: "ANTI LA/SSB",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_ANTILASSB'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                name: 'fecLAB_ANTILASSB',
                                                                id: 'fecLAB_ANTILASSB'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_ANTILASSB'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                //xtype: 'numberfield',
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                //decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'ANTI DNA/NEGATIVO',
                                                                name: "ANTI DNA/NEGATIVO",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_ANTIDNA'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                name: 'fecLAB_ANTIDNA',
                                                                id: 'fecLAB_ANTIDNA'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_ANTIDNA'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                //xtype: 'numberfield',
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                //decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'TTP',
                                                                name: "TTP",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_TTP'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                name: 'fecLAB_TTP',
                                                                id: 'fecLAB_TTP'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_TTP'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                //xtype: 'numberfield',
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                //decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'TP/INR',
                                                                name: "TP/INR",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_TPINR'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                name: 'fecLAB_TPINR',
                                                                id: 'fecLAB_TPINR'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_TPINR'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                //xtype: 'numberfield',
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                //decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'ACIDO URICO',
                                                                name: "ACIDO URICO",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_ACIDOURICO'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                name: 'fecLAB_ACIDOURICO',
                                                                id: 'fecLAB_ACIDOURICO'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_ACIDOURICO'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                //xtype: 'numberfield',
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                //decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'PSA',
                                                                name: "PSA",
                                                                emptyText: 'Resultado',
                                                                id: 'intLAB_PSA'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                name: 'fecLAB_PSA',
                                                                id: 'fecLAB_PSA'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                id: 'sysLABG_PSA'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'OTROS',
                                                        name: 'OTROS',
                                                        allowBlank: true,
                                                        id: 'memLAB_OBS'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EVALUACION PIE DIABETICO',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'APARIENCIA DEL PIE',
                                                                name: 'APARIENCIA DEL PIE',
                                                                width:150,
                                                                allowBlank: true,
                                                                store: stAparienciaPie,
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                submitValue: true,
                                                                id: 'strPIEDIABETICO_Apariencia'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'APARIENCIA DEL PIE - OTRA',
                                                                width:350,
                                                                allowBlank: true,
                                                                id: 'strPIEDIABETICO_AparienciaH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'REFLEJO AQUILEANO',
                                                        name: 'REFLEJO AQUILEANO',
                                                        width:150,
                                                        allowBlank: true,
                                                        store: stRefelejoAquileano,
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'strPIEDIABETICO_ReflejoAquileano'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'PERCEPCION DE LA VIBRACION PUNTA DEL DEDO MAYOR',
                                                        name: 'PERCEPCION DE LA VIBRACION PUNTA DEL DEDO MAYOR',
                                                        width:150,
                                                        allowBlank: true,
                                                        store: stPieNormalAnormal,
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'strPIEDIABETICO_PercepcionVibraPuntaDedo'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'PERCEPCION DE TEMPERATURA EN DORSO DEL PIE',
                                                        name: 'PERCEPCION DE TEMPERATURA EN DORSO DEL PIE',
                                                        width:150,
                                                        allowBlank: true,
                                                        store: stPieNormalAnormal,
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'strPIEDIABETICO_PercepcionTemperaturaDorsoPie'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'SENSIBILIDAD CON MONOFILAMENTO',
                                                        name: 'SENSIBILIDAD CON MONOFILAMENTO',
                                                        width:150,
                                                        allowBlank: true,
                                                        store: stPieNormalAnormal,
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'strPIEDIABETICO_SensibilidadMonofilamento'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Popliteos:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'VASCULAR PULSOS',
                                                                name: 'POPLITEOS',
                                                                width:150,
                                                                allowBlank: true,
                                                                id: 'strPIEDIABETICO_VascularPulsosPopliteos'
                                                            },
                                                            {
                                                                html: 'Pedios:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'PEDIOS',
                                                                width:150,
                                                                allowBlank: true,
                                                                id: 'strPIEDIABETICO_VascularPulsosPedios'
                                                            },
                                                            {
                                                                html: 'Tibiales Posteriores:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'TIBIALES POSTERIORES',
                                                                width:150,
                                                                allowBlank: true,
                                                                id: 'strPIEDIABETICO_VascularPulsosTibialesPosteriores'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'INDICE TOBILLO / BRAZO',
                                                        name: 'INDICE TOBILLO / BRAZO',
                                                        width:250,
                                                        allowBlank: true,
                                                        store: stIndicetobilloBrazo,
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'strPIEDIABETICO_IndiceTobillo'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'OTROS',
                                                        name: 'OTROS',
                                                        allowBlank: true,
                                                        id: 'memPIEDIABETICO_OTROS'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsRips',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }                            
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANALISIS',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'ANALISIS',
                                                        name: 'ANALISIS',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,           
                                                        allowBlank: true,
                                                        id: 'memAnalisis'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CONDUCTA',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'CONDUCTA',
                                                        name: 'CONDUCTA',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,           
                                                        allowBlank: false,
                                                        id: 'memConducta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'INCAPACIDAD',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Dias',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 50,
                                                                name: 'INCAPACIDAD DIAS',
                                                                minValue: 0,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                id: 'intDiasIncapacidad',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        //new Date(año,mes,dia) 01/05/2010
                                                                        if(Ext.getCmp('fecDesdeIncapacidad').getValue() == null || Ext.getCmp('fecDesdeIncapacidad').getValue() == ""){
                                                                            Ext.getCmp('fecDesdeIncapacidad').setValue(new Date().format('d/m/Y'))
                                                                        }
                                                                        var xFecha = Ext.getCmp('fecDesdeIncapacidad').getValue().format('d/m/Y')
                                                                        var xMes = xFecha.substr(3,2);
                                                                        var NewFecha = new Date(xFecha.substr(6,10),(xMes-1),xFecha.substr(0,2));
                                                                        if(pNew > 0)
                                                                            DiasIncapacidad = pNew - 1;
                                                                        else
                                                                            DiasIncapacidad = pNew;
                                                                        NewFecha.setDate(NewFecha.getDate()+DiasIncapacidad);
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(NewFecha.format('d/m/Y'));
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysIncDsd',
                                                                value: 'Desde:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'INCAPACIDAD DESDE',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecDesdeIncapacidad',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(null);
                                                                        Ext.getCmp('fecHastaIncapacidad').setMinValue(pNew.format("d/m/Y"));
                                                                        Ext.getCmp('fecHastaIncapacidad').clearInvalid();
                                                                        var xFecha = pNew.format('d/m/Y')
                                                                        var xMes = xFecha.substr(3,2);
                                                                        var NewFecha = new Date(xFecha.substr(6,10),(xMes-1),xFecha.substr(0,2));
                                                                        if(Ext.getCmp('intDiasIncapacidad').getValue() > 0){
                                                                            DiasIncapacidad = Ext.getCmp('intDiasIncapacidad').getValue() - 1;
                                                                        }else{
                                                                            DiasIncapacidad = Ext.getCmp('intDiasIncapacidad').getValue();
                                                                        }
                                                                        NewFecha.setDate(NewFecha.getDate()+DiasIncapacidad);
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(NewFecha.format('d/m/Y'));
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysIncHst',
                                                                value: 'Hasta:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'INCAPACIDAD HASTA',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecHastaIncapacidad'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Observaciones',
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                anchor: '100%',
                                                                width: 615,
                                                                name: 'INCAPACIDAD OBSERVACIONES',
                                                                height: 50,
                                                                allowBlank: true,
                                                                id: 'memIncapacidadObserva'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnImprimir',
                                                                text: 'Imprimir Incapacidad',
                                                                tooltip: 'Imprimir Incapacidad',
                                                                id: 'btnPrintIncapacidadHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        if (Ext.getCmp('sysYaGuardoHC').getValue() == 1)
                                                                            window.open ("../../controlador/asistencial/printincapacidad0.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pCAS=" + Ext.getCmp('sysCASHC').getValue() + "&pConsecutivo=" + Ext.getCmp('sysConsecutivoDetalleHC').getValue(),"Incapacidad");
                                                                        else{
                                                                            Ext.Msg.show({
                                                                                title: 'eOfiClinic',
                                                                                msg: 'Usted No ha Guardado la Evolución',
                                                                                buttons: Ext.Msg.OK,
                                                                                icon: Ext.Msg.ERROR
                                                                            });
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 352,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                            /*,
                            {
                                xtype: 'panel',
                                title: 'Solicitud CTC',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaCTC',
                                items: [
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                items: [
                                ]
                            },*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    if (Ext.getCmp('sysUsaGridSalida').getValue() == 1){
                                                        Ext.getCmp('gridFormulario').store.reload();
                                                    }
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistros();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistros();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winHCamontenegro001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
