/*
* @category    Formulario Modelo Evolucion Historia Clinica
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCORamirez001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla Historia Clinica ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        var dataResultadoCitologia = [
            ['NO REALIZADA'],
            ['NORMAL'],
            ['ANORMAL']
        ];
        var stResultadoCitologia = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stResultadoCitologia.loadData(dataResultadoCitologia);
        var dataParentesco = [
            ['CONYUGUE O COMPANERO PERMANENTE'],
            ['HIJO - HIJA'],
            ['PADRE - MADRE'],
            ['OTRO MIEMBRO DE LA FAMILIA'],
            ['OTRO NO PERTENECIENTE A LA FAMILIA']
        ];
        var stParentesco = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stParentesco.loadData(dataParentesco);
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo !== null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente === 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 !== null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente === 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 !== null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 !== null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS === 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 !== null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS === 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 !== null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX !== "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    task: 'MX_IPS_BASICA',
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA !== "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objREM !== "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysFormulacion'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Genero',
                        id: 'sysGeneroPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysLegalizaHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroHC'
                            },
                            {
                                html: 'Fecha Nac:'
                            },
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaNac'
                            },
                            {
                                html: 'Edad:'
                            },
                            {
                                xtype: 'textfield',
                                width: 350,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysEdadHC'
                            }
                        ]
                    },
                    /*{
                        xtype: 'button',
                        iconCls: 'btnImprimir',
                        text: 'Cargar Antecedentes',
                        tooltip: 'Cargar Antecedentes',
                        listeners:{
                            click : function(){
                                Ext.Ajax.request({
                                    url: '../../controlador/asistencial/evolucionhc.php',
                                    waitMsg: 'Cargando Información...',
                                    params:{
                                        pCAS: myCAS,
                                        pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                        task: 'ImportarAntecedentesPersonalesOfiClinic001'
                                    },
                                    success: function(result, request)
                                    {
                                        var jsonAntPersonales = Ext.util.JSON.decode(result.responseText);
                                        UtilCargarAntecedentesOfiClinic001(jsonAntPersonales.data);
                                    },
                                    scope:this
                                });
                            }
                        }
                    },*/
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Acompañante',
                                                        name: 'Acompañante',
                                                        width: 350,
                                                        allowBlank: true,
                                                        id: 'strDATINGPROGAcompanante'
                                                    },
                                                    {
                                                        html: '   Parentesco:'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Parentezco',
                                                        width: 350,
                                                        allowBlank: true,
                                                        store: stParentesco,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strDATINGPROGParentesco'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'MOTIVO DE CONSULTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'MOTIVO DE CONSULTA',
                                                        name: 'MOTIVO DE CONSULTA',
                                                        height: 100,
                                                        allowBlank: true,
                                                        id: 'memMotivoConsulta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ENFERMEDAD ACTUAL',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'ENFERMEDAD ACTUAL',
                                                        name: 'ENFERMEDAD ACTUAL',
                                                        height: 100,
                                                        allowBlank: true,
                                                        id: 'memEnfermedadActual'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'REVISION POR SISTEMAS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [ 
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Piel y Anexos',
                                                        name: 'Piel y Anexos',
                                                        allowBlank: true,
                                                        value: "No Evaluado",
                                                        id: 'strREVxSISTEMASPielAnexos',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strREVxSISTEMASPielAnexos').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Organos de los Sentidos',
                                                        name: 'Organos de los Sentidos',
                                                        allowBlank: true,
                                                        value: "No Evaluado",
                                                        id: 'strREVxSISTEMASOrganosSentidos',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strREVxSISTEMASOrganosSentidos').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Cardiovascular',
                                                        name: 'Cardiovascular',
                                                        allowBlank: true,
                                                        value: "No Evaluado",
                                                        id: 'strREVxSISTEMASCardiovascular',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strREVxSISTEMASCardiovascular').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Pulmonar',
                                                        name: 'Pulmonar',
                                                        allowBlank: true,
                                                        value: "No Evaluado",
                                                        id: 'strREVxSISTEMASPulmonar',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strREVxSISTEMASPulmonar').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Digestivo',
                                                        name: 'Digestivo',
                                                        allowBlank: true,
                                                        value: "No Evaluado",
                                                        id: 'strREVxSISTEMASDigestivo',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strREVxSISTEMASDigestivo').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Genito-Urinario',
                                                        name: 'Genito-Urinario',
                                                        allowBlank: true,
                                                        value: "No Evaluado",
                                                        id: 'strREVxSISTEMASGenitoUrinario',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strREVxSISTEMASGenitoUrinario').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Musculo-Esqueletico',
                                                        name: 'Musculo-Esqueletico',
                                                        allowBlank: true,
                                                        value: "No Evaluado",
                                                        id: 'strREVxSISTEMASMusculoEsqueletico',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strREVxSISTEMASMusculoEsqueletico').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Neurologico',
                                                        name: 'Neurologico',
                                                        allowBlank: true,
                                                        value: "No Evaluado",
                                                        id: 'strREVxSISTEMASNeurologico',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strREVxSISTEMASNeurologico').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Endocrinologico',
                                                        name: 'Otros',
                                                        allowBlank: true,
                                                        value: "No Evaluado",
                                                        id: 'strREVxSISTEMASEndocrinologico',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strREVxSISTEMASEndocrinologico').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES PERSONALES',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Patologicos',
                                                        name: 'Patologicos',
                                                        allowBlank: true,
                                                        id: 'memANTPERSOPatologicos',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('memANTPERSOPatologicos').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Farmacologicos',
                                                        name: 'Farmacologicos',
                                                        allowBlank: true,
                                                        id: 'memANTPERSOFarmacologicos',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('memANTPERSOFarmacologicos').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Quirurgicos',
                                                        name: 'Quirurgicos',
                                                        allowBlank: true,
                                                        id: 'memANTPERSOQuirurgicos',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('memANTPERSOQuirurgicos').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Traumatologicos',
                                                        name: 'Traumatologicos',
                                                        allowBlank: true,
                                                        id: 'memANTPERSOTraumatologicos',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('memANTPERSOTraumatologicos').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Toxicologicos',
                                                        name: 'Toxicologicos',
                                                        allowBlank: true,
                                                        id: 'memANTPERSOToxicologicos',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('memANTPERSOToxicologicos').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Alergicos',
                                                        name: 'Alergicos',
                                                        allowBlank: true,
                                                        id: 'memANTPERSOAlergicos',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('memANTPERSOAlergicos').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        anchor: '100%',
                                                        layout: {
                                                            columns: 3,
                                                            type: 'table'
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 280,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'HTA',
                                                                        name: 'HTA',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTPERSOHTA'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Diabetes',
                                                                        name: 'Diabetes',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTPERSODiabetes'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Nefropatias',
                                                                        name: 'Nefropatias',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTPERSONefropatias'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 280,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Infertilidad',
                                                                        name: 'Infertilidad',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTPERSOInfertilidad'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'VIH',
                                                                        name: 'VIH',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTPERSOVIH'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Cardiopatias',
                                                                        name: 'Cardiopatias',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTPERSOCardiopatias'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 280,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Cx Pelvicas',
                                                                        name: 'Cx Pelvicas',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTPERSOCxPelvicas'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Condicion Medica Grave',
                                                                        name: 'Condicion Medica Grave',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTPERSOCondicionGrave'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'ANTECEDENTES GINECO-OBSTETRICOS',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        labelSeparator: '',
                                                        autoHeight: true,
                                                        id: 'fsANTGINECO',
                                                        items: [
                                                            {
                                                                html: '<br>'
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        html: 'G'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'G',
                                                                        emptyText: 'Gestaciones',
                                                                        width: 68,
                                                                        minValue: 0,
                                                                        maxValue: 20,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intANTGINECOG',
                                                                        listeners:{
                                                                            change : function( t, newValue, oldValue){
                                                                                if(newValue <= 1 && Ext.getCmp('intANTGINECOP').getValue() === 0 && Ext.getCmp('intANTGINECOA').getValue() === 0){
                                                                                    Ext.getCmp('fecANTGINECOFup').setValue(null);
                                                                                    Ext.getCmp('fecANTGINECOFup').disable();
                                                                                    Ext.getCmp('fecANTGINECOFup').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('fecANTGINECOFup').enable();
                                                                                }
                                                                                if(newValue === 0){
                                                                                    Ext.getCmp('intANTGINECOP').disable();
                                                                                    Ext.getCmp('intANTGINECOPV').disable();
                                                                                    Ext.getCmp('intANTGINECOPC').disable();
                                                                                    Ext.getCmp('intANTGINECOA').disable();
                                                                                    Ext.getCmp('intANTGINECOVivos').disable();
                                                                                    Ext.getCmp('intANTGINECOMuertos').disable();
                                                                                    Ext.getCmp('intANTGINECOP').allowBlank = true;
                                                                                    Ext.getCmp('intANTGINECOPV').allowBlank = true;
                                                                                    Ext.getCmp('intANTGINECOPC').allowBlank = true;
                                                                                    Ext.getCmp('intANTGINECOA').allowBlank = true;
                                                                                    Ext.getCmp('intANTGINECOVivos').allowBlank = true;
                                                                                    Ext.getCmp('intANTGINECOMuertos').allowBlank = true;
                                                                                }else{
                                                                                    Ext.getCmp('intANTGINECOP').enable();
                                                                                    Ext.getCmp('intANTGINECOPV').enable();
                                                                                    Ext.getCmp('intANTGINECOPC').enable();
                                                                                    Ext.getCmp('intANTGINECOA').enable();
                                                                                    Ext.getCmp('intANTGINECOVivos').enable();
                                                                                    Ext.getCmp('intANTGINECOMuertos').enable();
                                                                                    Ext.getCmp('intANTGINECOP').allowBlank = false;
                                                                                    Ext.getCmp('intANTGINECOPV').allowBlank = false;
                                                                                    Ext.getCmp('intANTGINECOPC').allowBlank = false;
                                                                                    Ext.getCmp('intANTGINECOA').allowBlank = false;
                                                                                    Ext.getCmp('intANTGINECOVivos').allowBlank = false;
                                                                                    Ext.getCmp('intANTGINECOMuertos').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: 'P'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'P',
                                                                        emptyText: 'Partos',
                                                                        width: 68,
                                                                        minValue: 0,
                                                                        maxValue: 20,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intANTGINECOP',
                                                                        listeners:{
                                                                            change : function( t, newValue, oldValue){
                                                                                if(newValue === 0 && Ext.getCmp('intANTGINECOG').getValue() <= 1 && Ext.getCmp('intANTGINECOA').getValue() === 0){
                                                                                    Ext.getCmp('fecANTGINECOFup').setValue(null);
                                                                                    Ext.getCmp('fecANTGINECOFup').disable();
                                                                                    Ext.getCmp('fecANTGINECOFup').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('fecANTGINECOFup').enable();
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: 'P.V'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'PV',
                                                                        emptyText: 'Vaginales',
                                                                        width: 68,
                                                                        minValue: 0,
                                                                        maxValue: 20,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intANTGINECOPV'
                                                                    },
                                                                    {
                                                                        html: 'P.C'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'PC',
                                                                        emptyText: 'Cesarea',
                                                                        width: 68,
                                                                        minValue: 0,
                                                                        maxValue: 20,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intANTGINECOPC'
                                                                    },
                                                                    {
                                                                        html: 'A'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'A',
                                                                        emptyText: 'Abortos',
                                                                        width: 68,
                                                                        minValue: 0,
                                                                        maxValue: 20,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intANTGINECOA',
                                                                        listeners:{
                                                                            change : function( t, newValue, oldValue){
                                                                                if(newValue === 0 && Ext.getCmp('intANTGINECOG').getValue() <= 1 && Ext.getCmp('intANTGINECOP').getValue() === 0){
                                                                                    Ext.getCmp('fecANTGINECOFup').setValue(null);
                                                                                    Ext.getCmp('fecANTGINECOFup').disable();
                                                                                    Ext.getCmp('fecANTGINECOFup').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('fecANTGINECOFup').enable();
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: 'Vivos'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'V',
                                                                        width: 68,
                                                                        minValue: 0,
                                                                        maxValue: 20,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intANTGINECOVivos'
                                                                    },
                                                                    {
                                                                        html: 'Muertos'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'M',
                                                                        width: 68,
                                                                        minValue: 0,
                                                                        maxValue: 20,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intANTGINECOMuertos'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        html: 'Mola'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Mola',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTGINECOMola'
                                                                    },
                                                                    {
                                                                        html: 'Embarazo Ectopico'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Embarazo Ectopico',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTGINECOEmbEctopico'
                                                                    },
                                                                    {
                                                                        html: 'Preclampsia'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Preclampsia',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTPERSOPreclampsia'
                                                                    },
                                                                    {
                                                                        html: 'Eclampsia'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Eclampsia',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTPERSOEclampsia'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                html: '<br>'
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Esta Lactando Actualmente',
                                                                        name: 'Esta Lactando Actualmente',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strANTGINECOLactanciaHoy'
                                                                    },
                                                                    {
                                                                        html:'Ha Lactando en el Pasado:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Ha Lactando en el Pasado',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strANTGINECOLactanciaPasado',
                                                                        listeners:{
                                                                            change : function( t, newValue, oldValue){
                                                                                if(newValue === "NO"){
                                                                                    Ext.getCmp('strANTGONECOTiempoLactancia').setValue(null);
                                                                                    Ext.getCmp('strANTGONECOTiempoLactancia').disable();
                                                                                    Ext.getCmp('strANTGONECOTiempoLactancia').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('strANTGONECOTiempoLactancia').enable();
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html:'Tiempo de Lactancia:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Tiempo Lactancia',
                                                                        width: 50,
                                                                        allowBlank: true,
                                                                        id: 'strANTGONECOTiempoLactancia'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Menarquia',
                                                                        name: 'Menarquia',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strANTGINECOFum_1',
                                                                        listeners:{
                                                                            change : function( t, newValue, oldValue){
                                                                                if(newValue === "NO"){
                                                                                    Ext.getCmp('fecANTGINECOFum').disable();
                                                                                    Ext.getCmp('fecANTGINECOFum').clearInvalid();
                                                                                    Ext.getCmp('fecANTGINECOFum').setValue(null);
                                                                                    Ext.getCmp('strANTGINECOMenarquia').disable();
                                                                                    Ext.getCmp('strANTGINECOMenarquia').clearInvalid();
                                                                                    Ext.getCmp('strANTGINECOMenarquia').setValue(null);
                                                                                }else{  
                                                                                    Ext.getCmp('fecANTGINECOFum').enable();
                                                                                    Ext.getCmp('strANTGINECOMenarquia').enable();
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '-'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Menarquia Descripcion',
                                                                        width: 370,
                                                                        allowBlank: true,
                                                                        id: 'strANTGINECOMenarquia'
                                                                    },
                                                                    {
                                                                        html: 'FUM'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'FUM',
                                                                        allowBlank: true,
                                                                        disabledDates: '',
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecANTGINECOFum'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'FUP',
                                                                        fieldLabel: 'FUP',
                                                                        allowBlank: true,
                                                                        disabledDates: '',
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecANTGINECOFup'
                                                                    },
                                                                    {
                                                                        html: 'Ultima Citologia'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Ultima Citologia',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strANTGINECOFuc',
                                                                        listeners:{
                                                                            change : function( t, newValue, oldValue){
                                                                                if(newValue === "NO"){
                                                                                    Ext.getCmp('fecANTGINECOFuc').disable();
                                                                                    Ext.getCmp('fecANTGINECOFuc').clearInvalid();
                                                                                    Ext.getCmp('fecANTGINECOFuc').setValue(null);
                                                                                    Ext.getCmp('fecANTGINECOFuc').allowBlank = true;
                                                                                    Ext.getCmp('strANTGINECOFucRes').disable();
                                                                                    Ext.getCmp('strANTGINECOFucRes').clearInvalid();
                                                                                    Ext.getCmp('strANTGINECOFucRes').setValue(null);
                                                                                    Ext.getCmp('strANTGINECOFucRes').allowBlank = true;
                                                                                }else{  
                                                                                    Ext.getCmp('fecANTGINECOFuc').enable();
                                                                                    Ext.getCmp('strANTGINECOFucRes').enable();
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: 'Fecha:'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Ultima Citologia',
                                                                        allowBlank: true,
                                                                        disabledDates: '',
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecANTGINECOFuc'
                                                                    },
                                                                    {
                                                                        html: 'Resultado:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Resultado',
                                                                        width: 150,
                                                                        allowBlank: true,
                                                                        store: stResultadoCitologia,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strANTGINECOFucRes'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Metodo Planificacion',
                                                                name: 'Metodo Planificacion',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                store: 'StoreMetodosPlanificacion',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO PLANIFICA",
                                                                id: 'strANTGINECOMetodoPlanifica'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'Ciclos Mestruales',
                                                                name: 'Ciclos Mestruales',
                                                                allowBlank: true,
                                                                id: 'strANTGINECOCiclosMestruales',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strANTGINECOCiclosMestruales').setValue("Negativo");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'Actividad Sexual',
                                                                name: 'Actividad Sexual',
                                                                allowBlank: true,
                                                                id: 'strANTGINECOActividadSexual',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strANTGINECOActividadSexual').setValue("Negativo");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'Patologias Relacionadas Emb.',
                                                                name: 'Patologias Relacionadas Emb.',
                                                                allowBlank: true,
                                                                id: 'strANTGINECOPatologiaEmbarazo',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strANTGINECOPatologiaEmbarazo').setValue("Negativo");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'Menopausia',
                                                                name: 'Menopausia',
                                                                allowBlank: true,
                                                                id: 'strANTGINECOMenopausia',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strANTGINECOMenopausia').setValue("Negativo");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES FAMILIARES',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'ANTECEDENTES FAMILIARES',
                                                        name: 'ANTECEDENTES FAMILIARES',
                                                        height: 100,
                                                        allowBlank: true,
                                                        id: 'memAntecedentesFamiliares'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EXAMEN FISICO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                fieldLabel: 'T.A. (Sentado)',
                                                                name: 'T.A. (Sentado) Sistolica',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 300,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                id: 'intEXAFISTASentadoSistolica'
                                                            },
                                                            {
                                                                html: '/'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'T.A. (Sentado) Diastolica',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 300,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                id: 'intEXAFISTASentadoDiastolica'
                                                            },
                                                            {
                                                                html: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'
                                                            },
                                                            {
                                                                html: 'T.A. (de Pie):'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'T.A. (de Pie) Sistolica',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 300,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                id: 'intEXAFISTAdePieSistolica'
                                                            },
                                                            {
                                                                html: '/'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'T.A. (de Pie) Diastolica',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 300,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                id: 'intEXAFISTAdePieDiastolica'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'TALLA (cm)',
                                                                name:"TALLA (cm)",
                                                                emptyText: '(cm)',
                                                                id: 'intEXAFISTalla',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew === null || pNew === 0){
                                                                            Ext.getCmp('intEXAFISTalla').setValue(null);
                                                                            Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                        }else{
                                                                            if(Ext.getCmp('intEXAFISPeso').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEXAFISTalla').getValue() / 100;
                                                                                Ext.getCmp('intEXAFISIMC').setValue(Ext.getCmp('intEXAFISPeso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                            }
                                                                        }
                                                                       if(Ext.getCmp('intEXAFISIMC').getValue()<1){
                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEXAFISIMC').getValue() < 16.00){
                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ SEVERA");
                                                                            }else{
                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<=16.90 && Ext.getCmp('intEXAFISIMC').getValue()>=16.00){
                                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ MODERADA");
                                                                                }else{
                                                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<=18.49 && Ext.getCmp('intEXAFISIMC').getValue()>=17.00){
                                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ ACEPTABLE");
                                                                                    }else{
                                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<=24.99 && Ext.getCmp('intEXAFISIMC').getValue()>=18.50){
                                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("NORMAL");
                                                                                        }else{
                                                                                            if(Ext.getCmp('intEXAFISIMC').getValue()<=29.99 && Ext.getCmp('intEXAFISIMC').getValue()>=25.00){
                                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("PREOBESO");
                                                                                            }else{
                                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<=34.99 && Ext.getCmp('intEXAFISIMC').getValue()>=30.00){
                                                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO I");
                                                                                                }else{
                                                                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<=39.99 && Ext.getCmp('intEXAFISIMC').getValue()>=35.00){
                                                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO II");
                                                                                                    }else{
                                                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()>=40.00){
                                                                                                        Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO III");
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEXAFISPeso',
                                                                value: 'PESO (Kg) '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                emptyText: '(Kg)',
                                                                name:"PESO (Kg)",
                                                                id: 'intEXAFISPeso',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew === null || pNew === 0){
                                                                            Ext.getCmp('intEXAFISPeso').setValue(null);
                                                                            Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('intEXAFISTalla').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEXAFISTalla').getValue() / 100;
                                                                                Ext.getCmp('intEXAFISIMC').setValue(Ext.getCmp('intEXAFISPeso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<1){
                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEXAFISIMC').getValue() < 16.00){
                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ SEVERA");
                                                                            }else{
                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<=16.90 && Ext.getCmp('intEXAFISIMC').getValue()>=16.00){
                                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ MODERADA");
                                                                                }else{
                                                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<=18.49 && Ext.getCmp('intEXAFISIMC').getValue()>=17.00){
                                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ ACEPTABLE");
                                                                                    }else{
                                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<=24.99 && Ext.getCmp('intEXAFISIMC').getValue()>=18.50){
                                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("NORMAL");
                                                                                        }else{
                                                                                            if(Ext.getCmp('intEXAFISIMC').getValue()<=29.99 && Ext.getCmp('intEXAFISIMC').getValue()>=25.00){
                                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("PREOBESO");
                                                                                            }else{
                                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<=34.99 && Ext.getCmp('intEXAFISIMC').getValue()>=30.00){
                                                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO I");
                                                                                                }else{
                                                                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<=39.99 && Ext.getCmp('intEXAFISIMC').getValue()>=35.00){
                                                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO II");
                                                                                                    }else{
                                                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()>=40.00){
                                                                                                        Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO III");
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEXAFISIMC',
                                                                value: 'IMC '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                name: "IMC",
                                                                id: 'intEXAFISIMC'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                name: "IMC - CLASIFICACION",
                                                                id: 'strEXAFISIMCClasificacon'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEXAFISPA',
                                                                value: 'P. Abd.'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'Perimetro Abdominal',
                                                                allowBlank: true,
                                                                id: 'strEXAFISPA'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                fieldLabel: 'Temp',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'Temperatura',
                                                                allowBlank: true,
                                                                id: 'intEXAFISTemp'
                                                            },
                                                            {
                                                                html: 'F.C.'
                                                            },                                                            
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'FC',
                                                                allowBlank: true,
                                                                id: 'intEXAFISFC'
                                                            },
                                                            {
                                                                html: 'F.R.'
                                                            },                                                            
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'FR',
                                                                allowBlank: true,
                                                                id: 'intEXAFISFR'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Condiciones Generales',
                                                        name: 'Condiciones Generales',
                                                        allowBlank: true,
                                                        value: "No Evaluado",
                                                        id: 'strEXAFISCondicionesGenerales',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISCondicionesGenerales').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Mental',
                                                        name: 'Mental',
                                                        allowBlank: true,
                                                        value: "No Evaluado",
                                                        id: 'strEXAFISMental',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISCabeza').setValue("Normal");
                                                                });
                                                            }
                                                        }

                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Cabeza',
                                                        name: 'Cabeza',
                                                        allowBlank: true,
                                                        value: "No Evaluado",
                                                        id: 'strEXAFISCabeza',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISCabeza').setValue("Normal");
                                                                });
                                                            }
                                                        }

                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Ojos',
                                                        name: 'Ojos',
                                                        allowBlank: true,
                                                        id: 'strEXAFISOjos',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISOjos').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'ORL',
                                                        name: 'ORL',
                                                        allowBlank: true,
                                                        value: "No Evaluado",
                                                        id: 'strEXAFISORL',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISORL').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Orofaringe',
                                                        name: 'Orofaringe',
                                                        allowBlank: true,
                                                        value: "No Evaluado",
                                                        id: 'strEXAFISOrofaringe',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISOrofaringe').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Cuello',
                                                        name: 'Cuello',
                                                        allowBlank: true,
                                                        value: "No Evaluado",
                                                        id: 'strEXAFISCuello',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISCuello').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Piel y Anexos',
                                                        name: 'Piel y Anexos',
                                                        allowBlank: true,
                                                        value: "No Evaluado",
                                                        id: 'strEXAFISPielyAnexos',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISPielyAnexos').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Torax',
                                                        name: 'Torax',
                                                        allowBlank: true,
                                                        id: 'strEXAFISTorax',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISTorax').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Cardiaco-Pulmonar',
                                                        name: 'Cardiaco-Pulmonar',
                                                        allowBlank: true,
                                                        id: 'strEXAFISCardiaco',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISCardiaco').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Abdomen',
                                                        name: 'Abdomen',
                                                        allowBlank: true,
                                                        id: 'strEXAFISAbdomen',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISAbdomen').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Genitales',
                                                        name: 'Genitales',
                                                        allowBlank: true,
                                                        id: 'strEXAFISGenitales',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISGenitales').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Extremidades',
                                                        name: 'Extremidades',
                                                        allowBlank: true,
                                                        id: 'strEXAFISExtremidades',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISExtremidades').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Neurologico',
                                                        name: 'Neurologico',
                                                        allowBlank: true,
                                                        id: 'strEXAFISNeurologico',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISNeurologico').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    }
                                                    
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CONDUCTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'CONDUCTA',
                                                        name: 'CONDUCTA',
                                                        height: 100,
                                                        allowBlank: true,
                                                        id: 'memConducta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                anchor: '100%',
                                                autoHeight: true,
                                                layout: 'form',
                                                labelWidth: 260,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Certificado Medico',
                                                        name: 'Certificado Medico',
                                                        width: 60,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'sysCertificadoMedico',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue === "NO"){
                                                                    Ext.getCmp('fsCertificadoMedico').setVisible(false);
                                                                    Ext.getCmp('memCertificadoMedico').setValue(null);
                                                                    Ext.getCmp('memCertificadoMedico').clearInvalid();
                                                                }else{
                                                                    Ext.getCmp('fsCertificadoMedico').setVisible(true);
                                                                    Ext.getCmp('memCertificadoMedico').setValue("Certifico que el paciente " + Ext.getCmp('sysPacienteHC').getValue() + ", con" + Ext.getCmp('sysEdadHC').getValue() + " de edad y de la ciudad de Manizales, fue valorado en Consulta medica y el examen fisico se encuentra: XXXXXXXXXXXXXXXX.\n\ \n\ \n\ RECOMENDACIONES: XXXXXXXXXXXXXXXXXXXXXX." );
                                                                }
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CERTIFICADO MEDICO',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                id: 'fsCertificadoMedico',
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 750,
                                                        fieldLabel: 'CERTIFICADO MEDICO',
                                                        name: 'CERTIFICADO MEDICO',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        id: 'memCertificadoMedico'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnImprimir',
                                                        text: 'Imprimir Certificado',
                                                        tooltip: 'Imprimir Certificado',
                                                        id: 'btnPrintCertificadoHC',
                                                        listeners:{
                                                            click : function(){
                                                                if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1)
                                                                    window.open ("../../controlador/asistencial/printcertificacion0.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pCAS=" + Ext.getCmp('sysCASHC').getValue() + "&pConsecutivo=" + Ext.getCmp('sysConsecutivoDetalleHC').getValue(),"Incapacidad");
                                                                else{
                                                                    Ext.Msg.show({
                                                                        title: 'eOfiClinic',
                                                                        msg: 'Usted No ha Guardado la Evolución',
                                                                        buttons: Ext.Msg.OK,
                                                                        icon: Ext.Msg.ERROR
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'INCAPACIDAD',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Dias',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 50,
                                                                name: 'INCAPACIDAD DIAS',
                                                                minValue: 0,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                id: 'intDiasIncapacidad',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        //new Date(año,mes,dia) 01/05/2010
                                                                        if(Ext.getCmp('fecDesdeIncapacidad').getValue() === null || Ext.getCmp('fecDesdeIncapacidad').getValue() === ""){
                                                                            Ext.getCmp('fecDesdeIncapacidad').setValue(new Date().format('d/m/Y'));
                                                                        }
                                                                        var xFecha = Ext.getCmp('fecDesdeIncapacidad').getValue().format('d/m/Y');
                                                                        var xMes = xFecha.substr(3,2);
                                                                        var NewFecha = new Date(xFecha.substr(6,10),(xMes-1),xFecha.substr(0,2));
                                                                        if(pNew > 0)
                                                                            DiasIncapacidad = pNew - 1;
                                                                        else
                                                                            DiasIncapacidad = pNew;
                                                                        NewFecha.setDate(NewFecha.getDate()+DiasIncapacidad);
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(NewFecha.format('d/m/Y'));
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysIncDsd',
                                                                value: 'Desde:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'INCAPACIDAD DESDE',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecDesdeIncapacidad',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(null);
                                                                        Ext.getCmp('fecHastaIncapacidad').setMinValue(pNew.format("d/m/Y"));
                                                                        Ext.getCmp('fecHastaIncapacidad').clearInvalid();
                                                                        var xFecha = pNew.format('d/m/Y');
                                                                        var xMes = xFecha.substr(3,2);
                                                                        var NewFecha = new Date(xFecha.substr(6,10),(xMes-1),xFecha.substr(0,2));
                                                                        if(Ext.getCmp('intDiasIncapacidad').getValue() > 0){
                                                                            DiasIncapacidad = Ext.getCmp('intDiasIncapacidad').getValue() - 1;
                                                                        }else{
                                                                            DiasIncapacidad = Ext.getCmp('intDiasIncapacidad').getValue();
                                                                        }
                                                                        NewFecha.setDate(NewFecha.getDate()+DiasIncapacidad);
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(NewFecha.format('d/m/Y'));
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysIncHst',
                                                                value: 'Hasta:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'INCAPACIDAD HASTA',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecHastaIncapacidad'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Observaciones',
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                anchor: '100%',
                                                                width: 615,
                                                                name: 'INCAPACIDAD OBSERVACIONES',
                                                                height: 50,
                                                                allowBlank: true,
                                                                id: 'memIncapacidadObserva'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnImprimir',
                                                                text: 'Imprimir Incapacidad',
                                                                tooltip: 'Imprimir Incapacidad',
                                                                id: 'btnPrintIncapacidadHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1)
                                                                            window.open ("../../controlador/asistencial/printincapacidad0.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pCAS=" + Ext.getCmp('sysCASHC').getValue() + "&pConsecutivo=" + Ext.getCmp('sysConsecutivoDetalleHC').getValue(),"Incapacidad");
                                                                        else{
                                                                            Ext.Msg.show({
                                                                                title: 'eOfiClinic',
                                                                                msg: 'Usted No ha Guardado la Evolución',
                                                                                buttons: Ext.Msg.OK,
                                                                                icon: Ext.Msg.ERROR
                                                                            });
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [ 
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                                        {
                                                                            if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if(Ext.getCmp('sysDiagPpalHCNom').getValue() === null || Ext.getCmp('sysDiagPpalHCNom').getValue() === "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagPpalHC').getValue() !== "" && Ext.getCmp('sysDiagPpalHC').getValue() !== null && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2HC').getValue() && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                                        {
                                                                            if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel1HCNom').getValue === null ||  Ext.getCmp('sysDiagRel1HCNom').getValue() === "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel1HC').getValue() !== "" && Ext.getCmp('sysDiagRel1HC').getValue() !== null && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2HC').getValue() && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                                        {
                                                                            if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel2HCNom').getValue === null || Ext.getCmp('sysDiagRel2HCNom').getValue() === "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel2HC').getValue() !== "" && Ext.getCmp('sysDiagRel2HC').getValue() !== null && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                                        {
                                                                            if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel3HCNom').getValue === null || Ext.getCmp('sysDiagRel3HCNom').getValue() === "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel3HC').getValue() !== "" && Ext.getCmp('sysDiagRel3HC').getValue() !== null && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                            /*,
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                items: [
                                ]
                            },*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1)
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Imprimir Consentimiento Informado',
                            iconCls: 'btnImprimir',
                            listeners:{
                                click : function(){
                                    
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 0)
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    fnGuardarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    fnModificarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Msg.hide();
                    //Predefinir Comportamiento Campos
                    if(Ext.getCmp('sysFechaHC').getValue() !== null || Ext.getCmp('sysFechaHC').getValue() !== 0){
                       calculoEdadPacienteMeses();
                    }
                    //EVALUA ANTECEDENTES GINOECO-OBSTETrICOS
                    if(Ext.getCmp('sysGeneroHC').getValue() === "MASCULINO" || MesesCumplidos <= 96 || MesesCumplidos >= 661){
                        Ext.getCmp('fsANTGINECO').setVisible(false);
                    }else{
                        Ext.getCmp('fsANTGINECO').setVisible(true);
                        //Ext.getCmp('fsEXAMFISValMamaria').setVisible(true);
                        Ext.getCmp('intANTGINECOG').allowBlank = false;
                        Ext.getCmp('intANTGINECOP').allowBlank = false;
                        Ext.getCmp('intANTGINECOPV').allowBlank = false;
                        Ext.getCmp('intANTGINECOPC').allowBlank = false;
                        Ext.getCmp('intANTGINECOA').allowBlank = false;
                        Ext.getCmp('intANTGINECOVivos').allowBlank = false;
                        Ext.getCmp('intANTGINECOMuertos').allowBlank = false;
                        Ext.getCmp('strANTGINECOLactanciaHoy').allowBlank = false;
                        Ext.getCmp('strANTGINECOLactanciaPasado').allowBlank = false;
                        Ext.getCmp('strANTGONECOTiempoLactancia').allowBlank = false;
                        Ext.getCmp('strANTGINECOFum_1').allowBlank = false;
                        Ext.getCmp('strANTGINECOMenarquia').allowBlank = false;
                        Ext.getCmp('fecANTGINECOFum').allowBlank = false;
                        Ext.getCmp('fecANTGINECOFup').allowBlank = false;
                        Ext.getCmp('strANTGINECOFuc').allowBlank = false;
                        Ext.getCmp('strANTGINECOMetodoPlanifica').allowBlank = false;
                        Ext.getCmp('strANTGINECOCiclosMestruales').allowBlank = false;
                        Ext.getCmp('strANTGINECOActividadSexual').allowBlank = false;
                        Ext.getCmp('strANTGINECOPatologiaEmbarazo').allowBlank = false;
                        Ext.getCmp('strANTGINECOMenopausia').allowBlank = false;
                    }
                    //EVALUAR EDADES
                    //COMPANANTE MENOR A 14 ANOS
                    if(MesesCumplidos <= 179){
                        Ext.getCmp('strDATINGPROGAcompanante').allowBlank = false;
                        Ext.getCmp('strDATINGPROGParentesco').allowBlank = false;
                    }else{
                        Ext.getCmp('strDATINGPROGAcompanante').allowBlank = true;
                        Ext.getCmp('strDATINGPROGParentesco').allowBlank = true;
                    }
                                        
                    //FUM MAYOR A 14 ANOS
                    if(Ext.getCmp('sysGeneroHC').getValue() === "FEMENINO" && MesesCumplidos >= 120 && MesesCumplidos <= 599){
                        Ext.getCmp('strANTGINECOFum_1').setValue (""); 
                        Ext.getCmp('strANTGINECOFum_1').allowBlank = false;
                        Ext.getCmp('fecANTGINECOFum').allowBlank = false;
                    }else{
                        Ext.getCmp('strANTGINECOFum_1').setValue ("NO"); 
                        Ext.getCmp('strANTGINECOFum_1').allowBlank = true;
                        Ext.getCmp('fecANTGINECOFum').allowBlank = true;
                    }
                    //CARGAR ANTECEDENTES
                    if(paramOpcion === "Nuevo"){ 
                        Ext.Ajax.request({
                            url: '../../controlador/asistencial/evolucionhc.php',
                            waitMsg: 'Cargando Información...',
                            params:{
                                pCAS: myCAS,
                                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                task: 'ImportarAntecedentesFamiliares'
                            },
                            success: function(result, request)
                            {
                                if(result.responseText !== "{success:true}" && result.responseText !== "{success:false}"){
                                    var jsonAntFamiliares = Ext.util.JSON.decode(result.responseText);
                                    CargarDataHCAntecedentes(jsonAntFamiliares.data.sysEvolucion);
                                }
                                Ext.Ajax.request({
                                    url: '../../controlador/asistencial/evolucionhc.php',
                                    waitMsg: 'Cargando Información...',
                                    params:{
                                        pCAS: myCAS,
                                        pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                        task: 'ImportarAntecedentesPersonalesOfiClinic001'
                                    },
                                    success: function(result, request)
                                    {
                                        var jsonAntPersonales = Ext.util.JSON.decode(result.responseText);
                                        UtilCargarAntecedentesOfiClinic001(jsonAntPersonales.data);
                                    },
                                    scope:this
                                });
                            },
                            scope:this
                        });
                    }
                }
            }
        });
        winHCORamirez001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc2013.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pFormulacion: Ext.getCmp('sysFormulacion').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc2013.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pFormulacion: Ext.getCmp('sysFormulacion').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function calculoEdadPacienteMeses(){
    var valFecha1 = 0;
    var pFec2Anio = 0;
    var pFec2Mes = 0;
    var pFec2Dia = 0;
    var valFecha2 = 0;
    MesesCumplidos = 0;
    AniosCumplidos = 0;


    valFecha1 = Ext.getCmp('sysFechaHC').getValue();
    pFec2Anio = Ext.getCmp('sysFechaNac').getValue().substr(6,4);
    pFec2Mes = Ext.getCmp('sysFechaNac').getValue().substr(3,2);
    pFec2Dia = Ext.getCmp('sysFechaNac').getValue().substr(0,2);
    
    valFecha2 =  pFec2Anio + "/" + pFec2Mes + "/" + pFec2Dia;

    MesesCumplidos = MostrarEdadMeses(valFecha1, valFecha2);
    
    AniosCumplidos = MostrarEdadAnios(valFecha1, valFecha2);
}