/*
* @category    Formulario Test Barthel
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCTestBarthel = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Test - Geriatria ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHCBerthel',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '98%',
                id: 'frmBarthel',
                url: '../../controlador/asistencial/test.php',
                padding: 0,
                border: false,
                height: 610,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'intTestGeriatriaUsuario'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'intTestGeriatriaPaciente'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'intTestGeriatriaConsecutivoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'strTestGeriatriaHoraApertura'
                    },
                    {
                        xtype: 'fieldset',
                        title: 'TEST BARTHEL',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        labelWidth: 170,
                        id: 'fsBarthel',
                        items: [
                            {
                                xtype: 'radiogroup',
                                fieldLabel: 'ALIMENTACION',
                                labelStyle: 'color: #9E1616;',
                                name: 'ALIMENTACION',
                                vertical: true,
                                columns: 1,
                                id: 'strBarthelComer',
                                items:[
                                    {boxLabel: 'INDEPENDIENTE: Capaz de utilizar cualquier instrumento necesario; come en un tiempo razonable; capaz de desmenuzar la comida, usar condimentos, extender mantequilla, etc. por si solo. la comida puede situarse a su alcance', name: 'BarthelComer', inputValue: 'A'},
                                    {boxLabel: 'NECESITA AYUDA: Ej. para cortar o extender la mantequilla', name: 'BarthelComer', inputValue: 'B'},
                                    {boxLabel: 'DEPENDIENTE: Necesita ser alimentado', name: 'BarthelComer', inputValue: 'C'}
                                ],
                                listeners:{
                                    change : function(radiogroup, radio){
                                        switch(radio.inputValue){
                                            case "A":
                                                Ext.getCmp('intBarthelComerPto').setValue(10);
                                                Ext.getCmp('strBarthelComerDes').setValue("INDEPENDIENTE: Capaz de utilizar cualquier instrumento necesario; come en un tiempo razonable; capaz de desmenuzar la comida, usar condimentos, extender mantequilla, etc. por si solo. la comida puede situarse a su alcance");
                                                break;
                                            case "B":
                                                Ext.getCmp('intBarthelComerPto').setValue(5);
                                                Ext.getCmp('strBarthelComerDes').setValue("NECESITA AYUDA: Ej. para cortar o extender la mantequilla");
                                                break;
                                            case "C":
                                                Ext.getCmp('intBarthelComerPto').setValue(0);
                                                Ext.getCmp('strBarthelComerDes').setValue("DEPENDIENTE: Necesita ser alimentado");
                                                break;
                                            default:
                                                break;
                                        }
                                        CalculaValoracionBarthel();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intBarthelComerPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strBarthelComerDes'
                            },
                            {
                                html: '<br>',
                                style: 'background:transparent;',
                                border: false
                            },
                            {
                                xtype: 'radiogroup',
                                fieldLabel: 'LAVADO (BAÑO)',
                                labelStyle: 'color: #9E1616;',
                                name: 'LAVADO (BAÑO)',
                                vertical: true,
                                columns: 1,
                                id: 'strBarthelLavarse',
                                items:[
                                    {boxLabel: 'INDEPENDIENTE: Capaz de bañarse completo; puede ser usando la ducha, la tina o permaneciendo de pie y aplicando la esponja sobre todo el cuerpo. incluye entrar y salir del baño. puede realizarlo sin necesidad de estar una persona', name: 'BarthelLavarse', inputValue: 'A'},
                                    {boxLabel: 'DEPENDIENTE: Necesita alguna ayuda', name: 'BarthelLavarse', inputValue: 'B'},
                                ],
                                listeners:{
                                    change : function(radiogroup, radio){
                                        switch(radio.inputValue){
                                            case "A":
                                                Ext.getCmp('intBarthelLavarsePto').setValue(5);
                                                Ext.getCmp('strBarthelLavarseDes').setValue("INDEPENDIENTE: Capaz de bañarse completo; puede ser usando la ducha, la tina o permaneciendo de pie y aplicando la esponja sobre todo el cuerpo. incluye entrar y salir del baño. puede realizarlo sin necesidad de estar una persona");
                                                break;
                                            case "B":
                                                Ext.getCmp('intBarthelLavarsePto').setValue(0);
                                                Ext.getCmp('strBarthelLavarseDes').setValue("DEPENDIENTE: Necesita alguna ayuda");
                                                break;
                                            default:
                                                break;
                                        }
                                        CalculaValoracionBarthel();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intBarthelLavarsePto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strBarthelLavarseDes'
                            },
                            {
                                html: '<br>',
                                style: 'background:transparent;',
                                border: false
                            },
                            {
                                xtype: 'radiogroup',
                                fieldLabel: 'Vestirse',
                                labelStyle: 'color: #9E1616;',
                                name: 'Vestirse',
                                vertical: true,
                                columns: 1,
                                id: 'strBarthelVestirse',
                                items:[
                                    {boxLabel: 'INDEPENDIENTE: Capaz de ponerse, quitarse y fijar la ropa. se ata los zapatos, abrocha los botones. se coloca el brasier o corse si lo necesita', name: 'BarthelVestirse', inputValue: 'A'},
                                    {boxLabel: 'NECESITA AYUDA: Pero hace al menos la mitad de las tareas en un tiempo razonable', name: 'BarthelVestirse', inputValue: 'B'},
                                    {boxLabel: 'DEPENDIENTE: Necesita ayuda', name: 'BarthelVestirse', inputValue: 'C'}
                                ],
                                listeners:{
                                    change : function(radiogroup, radio){
                                        switch(radio.inputValue){
                                            case "A":
                                                Ext.getCmp('intBarthelVestirsePto').setValue(10);
                                                Ext.getCmp('strBarthelVestirseDes').setValue("INDEPENDIENTE: Capaz de ponerse, quitarse y fijar la ropa. se ata los zapatos, abrocha los botones. se coloca el brasier o corse si lo necesita");
                                                break;
                                            case "B":
                                                Ext.getCmp('intBarthelVestirsePto').setValue(5);
                                                Ext.getCmp('strBarthelVestirseDes').setValue("NECESITA AYUDA: Pero hace al menos la mitad de las tareas en un tiempo razonable");
                                                break;
                                            case "C":
                                                Ext.getCmp('intBarthelVestirsePto').setValue(0);
                                                Ext.getCmp('strBarthelVestirseDes').setValue("DEPENDIENTE: Necesita ayuda");
                                                break;
                                            default:
                                                break;
                                        }
                                        CalculaValoracionBarthel();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intBarthelVestirsePto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strBarthelVestirseDes'
                            },
                            {
                                html: '<br>',
                                style: 'background:transparent;',
                                border: false
                            },
                            {
                                xtype: 'radiogroup',
                                fieldLabel: 'ARREGLARSE',
                                labelStyle: 'color: #9E1616;',
                                name: 'ARREGLARSE',
                                vertical: true,
                                columns: 1,
                                id: 'strBarthelArreglarse',
                                items:[
                                    {boxLabel: 'INDEPENDIENTE: Realiza todas las actividades personales (ej. lavarse manos y cara, peinarse). incluye afeitarse y lavarse los dientes. no necesita ninguna ayuda', name: 'BarthelArreglarse', inputValue: 'A'},
                                    {boxLabel: 'DEPENDIENTE: Necesita alguna ayuda', name: 'BarthelArreglarse', inputValue: 'B'}
                                ],
                                listeners:{
                                    change : function(radiogroup, radio){
                                        switch(radio.inputValue){
                                            case "A":
                                                Ext.getCmp('intBarthelArreglarsePto').setValue(5);
                                                Ext.getCmp('strBarthelArreglarseDes').setValue("INDEPENDIENTE: Realiza todas las actividades personales (ej. lavarse manos y cara, peinarse). incluye afeitarse y lavarse los dientes. no necesita ninguna ayuda");
                                                break;
                                            case "B":
                                                Ext.getCmp('intBarthelArreglarsePto').setValue(0);
                                                Ext.getCmp('strBarthelArreglarseDes').setValue("DEPENDIENTE: Necesita alguna ayuda");
                                                break;
                                            default:
                                                break;
                                        }
                                        CalculaValoracionBarthel();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intBarthelArreglarsePto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strBarthelArreglarseDes'
                            },
                            {
                                html: '<br>',
                                style: 'background:transparent;',
                                border: false
                            },
                            {
                                xtype: 'radiogroup',
                                fieldLabel: 'DEPOSICION',
                                labelStyle: 'color: #9E1616;',
                                name: 'DEPOSICION',
                                vertical: true,
                                columns: 1,
                                id: 'strBarthelDeposiciones',
                                items:[
                                    {boxLabel: 'CONTINENTE, NINGUN ACCIDENTE: No necesita ninguna ayuda', name: 'BarthelDeposiciones', inputValue: 'A'},
                                    {boxLabel: 'ACCIDENTE OCASIONAL: Raro menos de una vez por semana', name: 'BarthelDeposiciones', inputValue: 'B'},
                                    {boxLabel: 'INCONTINENTE', name: 'BarthelDeposiciones', inputValue: 'C'}
                                ],
                                listeners:{
                                    change : function(radiogroup, radio){
                                        switch(radio.inputValue){
                                            case "A":
                                                Ext.getCmp('intBarthelDeposicionesPto').setValue(10);
                                                Ext.getCmp('strBarthelDeposicionesDes').setValue("CONTINENTE, NINGUN ACCIDENTE: No necesita ninguna ayuda");
                                                break;
                                            case "B":
                                                Ext.getCmp('intBarthelDeposicionesPto').setValue(5);
                                                Ext.getCmp('strBarthelDeposicionesDes').setValue("ACCIDENTE OCASIONAL: Raro menos de una vez por semana");
                                                break;
                                            case "C":
                                                Ext.getCmp('intBarthelDeposicionesPto').setValue(0);
                                                Ext.getCmp('strBarthelDeposicionesDes').setValue("INCONTINENTE");
                                                break;
                                            default:
                                                break;
                                        }
                                        CalculaValoracionBarthel();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intBarthelDeposicionesPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strBarthelDeposicionesDes'
                            },
                            {
                                html: '<br>',
                                style: 'background:transparent;',
                                border: false
                            },
                            {
                                xtype: 'radiogroup',
                                fieldLabel: 'MICCION',
                                labelStyle: 'color: #9E1616;',
                                name: 'MICCION',
                                vertical: true,
                                columns: 1,
                                id: 'strBarthelMiccion',
                                items:[
                                    {boxLabel: 'CONTINENTE, NINGUN ACCIDENTE: Seco dia y noche, capaz de usar cualquier dispositivo ( ej cateter) si es necesario, es capaz de cambiar la bolsa', name: 'BarthelMiccion', inputValue: 'A'},
                                    {boxLabel: 'ACCIDENTE OCASIONAL: Menos de una vez por semana, necesita ayuda con instrumentos', name: 'BarthelMiccion', inputValue: 'B'},
                                    {boxLabel: 'INCONTINENTE', name: 'BarthelMiccion', inputValue: 'C'}
                                ],
                                listeners:{
                                    change : function(radiogroup, radio){
                                        switch(radio.inputValue){
                                            case "A":
                                                Ext.getCmp('intBarthelMiccionPto').setValue(10);
                                                Ext.getCmp('strBarthelMiccionDes').setValue("CONTINENTE, NINGUN ACCIDENTE: Seco dia y noche, capaz de usar cualquier dispositivo ( ej cateter) si es necesario, es capaz de cambiar la bolsa");
                                                break;
                                            case "B":
                                                Ext.getCmp('intBarthelMiccionPto').setValue(5);
                                                Ext.getCmp('strBarthelMiccionDes').setValue("ACCIDENTE OCASIONAL: Menos de una vez por semana, necesita ayuda con instrumentos");
                                                break;
                                            case "C":
                                                Ext.getCmp('intBarthelMiccionPto').setValue(0);
                                                Ext.getCmp('strBarthelMiccionDes').setValue("INCONTINENTE");
                                                break;
                                            default:
                                                break;
                                        }
                                        CalculaValoracionBarthel();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intBarthelMiccionPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strBarthelMiccionDes'
                            },
                            {
                                html: '<br>',
                                style: 'background:transparent;',
                                border: false
                            },
                            {
                                xtype: 'radiogroup',
                                fieldLabel: 'SANITARIO',
                                labelStyle: 'color: #9E1616;',
                                name: 'SANITARIO',
                                vertical: true,
                                columns: 1,
                                id: 'strBarthelRetrete',
                                items:[
                                    {boxLabel: 'INDEPENDIENTE: Entra y sale solo, capaz de quitarse y ponerse la ropa, limpiarse, prevenir el manchado de la ropa, limpiar y vaciar completamente la bacinilla o sanitario, sin ayuda. capaz de sentarse y levantarse sin ayuda. puede utilizar barras para sostenerse', name: 'BarthelRetrete', inputValue: 'A'},
                                    {boxLabel: 'NECESITA AYUDA: Capaz de manejarse con pequeña ayuda en el equilibrio, quitarse y ponerse la ropa o usar el papel higienico. sin embargo, aun es capaz de utilizar el inodoro', name: 'BarthelRetrete', inputValue: 'B'},
                                    {boxLabel: 'DEPENDIENTE: Incapaz de usar el sanitario sin ayuda', name: 'BarthelRetrete', inputValue: 'C'}
                                ],
                                listeners:{
                                    change : function(radiogroup, radio){
                                        switch(radio.inputValue){
                                            case "A":
                                                Ext.getCmp('intBarthelRetretePto').setValue(10);
                                                Ext.getCmp('strBarthelRetreteDes').setValue("INDEPENDIENTE: Entra y sale solo, capaz de quitarse y ponerse la ropa, limpiarse, prevenir el manchado de la ropa, limpiar y vaciar completamente la bacinilla o sanitario, sin ayuda. capaz de sentarse y levantarse sin ayuda. puede utilizar barras para sostenerse");
                                                break;
                                            case "B":
                                                Ext.getCmp('intBarthelRetretePto').setValue(5);
                                                Ext.getCmp('strBarthelRetreteDes').setValue("NECESITA AYUDA: Capaz de manejarse con pequeña ayuda en el equilibrio, quitarse y ponerse la ropa o usar el papel higienico. sin embargo, aun es capaz de utilizar el inodoro");
                                                break;
                                            case "C":
                                                Ext.getCmp('intBarthelRetretePto').setValue(0);
                                                Ext.getCmp('strBarthelRetreteDes').setValue("DEPENDIENTE: Incapaz de usar el sanitario sin ayuda");
                                                break;
                                            default:
                                                break;
                                        }
                                        CalculaValoracionBarthel();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intBarthelRetretePto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strBarthelRetreteDes'
                            },
                            {
                                html: '<br>',
                                style: 'background:transparent;',
                                border: false
                            },
                            {
                                xtype: 'radiogroup',
                                fieldLabel: 'TRASLADO SILLA-CAMA',
                                labelStyle: 'color: #9E1616;',
                                name: 'TRASLADO SILLA-CAMA',
                                vertical: true,
                                columns: 1,
                                id: 'strBarthelTraslado',
                                items:[
                                    {boxLabel: 'INDEPENDIENTE: Sin ayuda en todas las fases, en caso de utilizar la silla de ruedas, se aproxima a la cama, frena y la cierra si es necesario, se mete y se acuesta en la cama, se coloca en posicion sentado en la cama', name: 'BarthelTraslado', inputValue: 'A'},
                                    {boxLabel: 'MINIMA AYUDA: Incluye supervision verbal y pequeña ayuda fisica, tal como la ofrecida por un conyuge no muy fuerte', name: 'BarthelTraslado', inputValue: 'B'},
                                    {boxLabel: 'GRAN AYUDA: Capaz de estar sentado sin ayuda, pero necesita mucha asistencia para salir de la cama o desplazarse', name: 'BarthelTraslado', inputValue: 'C'},
                                    {boxLabel: 'DEPENDIENTE: Necesita grua o desplazamiento por dos personas, incapaz de estar sentado', name: 'BarthelTraslado', inputValue: 'D'}
                                ],
                                listeners:{
                                    change : function(radiogroup, radio){
                                        switch(radio.inputValue){
                                            case "A":
                                                Ext.getCmp('intBarthelTrasladoPto').setValue(15);
                                                Ext.getCmp('strBarthelTrasladoDes').setValue("INDEPENDIENTE: Sin ayuda en todas las fases, en caso de utilizar la silla de ruedas, se aproxima a la cama, frena y la cierra si es necesario, se mete y se acuesta en la cama, se coloca en posicion sentado en la cama");
                                                break;
                                            case "B":
                                                Ext.getCmp('intBarthelTrasladoPto').setValue(10);
                                                Ext.getCmp('strBarthelTrasladoDes').setValue("MINIMA AYUDA: Incluye supervision verbal y pequeña ayuda fisica, tal como la ofrecida por un conyuge no muy fuerte");
                                                break;
                                            case "C":
                                                Ext.getCmp('intBarthelTrasladoPto').setValue(5);
                                                Ext.getCmp('strBarthelTrasladoDes').setValue("GRAN AYUDA: Capaz de estar sentado sin ayuda, pero necesita mucha asistencia para salir de la cama o desplazarse");
                                                break;
                                            case "D":
                                                Ext.getCmp('intBarthelTrasladoPto').setValue(0);
                                                Ext.getCmp('strBarthelTrasladoDes').setValue("DEPENDIENTE: Necesita grua o desplazamiento por dos personas, incapaz de estar sentado");
                                                break;
                                            default:
                                                break;
                                        }
                                        CalculaValoracionBarthel();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intBarthelTrasladoPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strBarthelTrasladoDes'
                            },
                            {
                                html: '<br>',
                                style: 'background:transparent;',
                                border: false
                            },
                            {
                                xtype: 'radiogroup',
                                fieldLabel: 'DEAMBULACION',
                                labelStyle: 'color: #9E1616;',
                                name: 'DEAMBULACION',
                                vertical: true,
                                columns: 1,
                                id: 'strBarthelDeambular',
                                items:[
                                    {boxLabel: 'INDEPENDIENTE: Puede usar cualquier ayuda: protesis, caminador, muletas, la velocidad no es importante, puede caminar al menos 50 mts o su equivalente en casa, sin ayuda o supervision', name: 'BarthelDeambular', inputValue: 'A'},
                                    {boxLabel: 'NECESITA AYUDA: Supervision verbal o fisica, incluyendo instrumentos u otras ayudas para permanecer de pie, deambula 50 mts', name: 'BarthelDeambular', inputValue: 'B'},
                                    {boxLabel: 'INDEPENDIENTE EN SILLA DE RUEDAS: Debe ser capaz de girar solo', name: 'BarthelDeambular', inputValue: 'C'},
                                    {boxLabel: 'INMOVIL: Incluye ayuda para voltearse en la cama', name: 'BarthelDeambular', inputValue: 'D'}
                                ],
                                listeners:{
                                    change : function(radiogroup, radio){
                                        switch(radio.inputValue){
                                            case "A":
                                                Ext.getCmp('intBarthelDeambularPto').setValue(15);
                                                Ext.getCmp('strBarthelDeambularDes').setValue("INDEPENDIENTE: Puede usar cualquier ayuda: protesis, caminador, muletas, la velocidad no es importante, puede caminar al menos 50 mts o su equivalente en casa, sin ayuda o supervision");
                                                break;
                                            case "B":
                                                Ext.getCmp('intBarthelDeambularPto').setValue(10);
                                                Ext.getCmp('strBarthelDeambularDes').setValue("NECESITA AYUDA: Supervision verbal o fisica, incluyendo instrumentos u otras ayudas para permanecer de pie, deambula 50 mts");
                                                break;
                                            case "C":
                                                Ext.getCmp('intBarthelDeambularPto').setValue(5);
                                                Ext.getCmp('strBarthelDeambularDes').setValue("INDEPENDIENTE EN SILLA DE RUEDAS: Debe ser capaz de girar solo");
                                                break;
                                            case "D":
                                                Ext.getCmp('intBarthelDeambularPto').setValue(0);
                                                Ext.getCmp('strBarthelDeambularDes').setValue("INMOVIL: Incluye ayuda para voltearse en la cama");
                                                break;
                                            default:
                                                break;
                                        }
                                        CalculaValoracionBarthel();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intBarthelDeambularPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strBarthelDeambularDes'
                            },
                            {
                                html: '<br>',
                                style: 'background:transparent;',
                                border: false
                            },
                            {
                                xtype: 'radiogroup',
                                fieldLabel: 'ESCALONES',
                                labelStyle: 'color: #9E1616;',
                                name: 'ESCALONES',
                                vertical: true,
                                columns: 1,
                                id: 'strBarthelEscalones',
                                items:[
                                    {boxLabel: 'INDEPENDIENTE: Capaz de subir y bajar un tramo de escalera sin ayuda o supervision, puede utilizar el apoyo que precisa para caminar (baston, muletas, etc) y el pasamanos', name: 'BarthelEscalones', inputValue: 'A'},
                                    {boxLabel: 'NECESITA AYUDA: Supervision fisica o verbal', name: 'BarthelEscalones', inputValue: 'B'},
                                    {boxLabel: 'INCAPAZ: Necesita ascensor o no puede subir escalones', name: 'BarthelEscalones', inputValue: 'C'}
                                ],
                                listeners:{
                                    change : function(radiogroup, radio){
                                        switch(radio.inputValue){
                                            case "A":
                                                Ext.getCmp('intBarthelEscalonesPto').setValue(10);
                                                Ext.getCmp('strBarthelEscalonesDes').setValue("INDEPENDIENTE: Capaz de subir y bajar un tramo de escalera sin ayuda o supervision, puede utilizar el apoyo que precisa para caminar (baston, muletas, etc) y el pasamanos");
                                                break;
                                            case "B":
                                                Ext.getCmp('intBarthelEscalonesPto').setValue(15);
                                                Ext.getCmp('strBarthelEscalonesDes').setValue("NECESITA AYUDA: Supervision fisica o verbal");
                                                break;
                                            case "C":
                                                Ext.getCmp('intBarthelEscalonesPto').setValue(0);
                                                Ext.getCmp('strBarthelEscalonesDes').setValue("INCAPAZ: Necesita ascensor o no puede subir escalones");
                                                break;
                                            default:
                                                break;
                                        }
                                        CalculaValoracionBarthel();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intBarthelEscalonesPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strBarthelEscalonesDes'
                            },
                            {
                                html: '<br>',
                                style: 'background:transparent;',
                                border: false
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                labelStyle: 'color: #9E1616;',
                                fieldLabel: 'Máxima puntuación: 100 puntos (90 si va en silla de ruedas)',
                                items: [
                                    {
                                        xtype: 'numberfield',
                                        width: 100,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'intBarthelTotal'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'sysvCalsifica',
                                        value: 'Grado de Dependencia: '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 150,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'strBarthelValoracion'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'TEST HACHINSKI',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        labelWidth: 170,
                        id: 'fsHACHINSKI',
                        items: [
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Comienzo agudo',
                                name: 'Comienzo agudo',
                                labelStyle: 'color: #9E1616;',
                                id: 'strHachinskiComienzo',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intHachinskiComienzoPto').setValue(2);
                                            Ext.getCmp('strHachinskiComienzoDes').setValue("Comienzo agudo");
                                        }else{
                                            Ext.getCmp('intHachinskiComienzoPto').setValue(0);
                                            Ext.getCmp('strHachinskiComienzoDes').setValue("Comienzo agudo");
                                        }
                                        CalculaValoracionHachinski();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intHachinskiComienzoPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strHachinskiComienzoDes'
                            },
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Progresion escalonada',
                                name: 'Progresion escalonada',
                                labelStyle: 'color: #9E1616;',
                                id: 'strHachinskiDeterioro',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intHachinskiDeterioroPto').setValue(1);
                                            Ext.getCmp('strHachinskiDeterioroDes').setValue("Progresion escalonada");
                                        }else{
                                            Ext.getCmp('intHachinskiDeterioroPto').setValue(0);
                                            Ext.getCmp('strHachinskiDeterioroDes').setValue("Progresion escalonada");
                                        }
                                        CalculaValoracionHachinski();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intHachinskiDeterioroPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strHachinskiDeterioroDes'
                            },
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Curso fluctuante',
                                name: 'Curso fluctuante',
                                labelStyle: 'color: #9E1616;',
                                id: 'strHachinskiCursoF',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intHachinskiCursoFPto').setValue(1);
                                            Ext.getCmp('strHachinskiCursoFDes').setValue("Curso fluctuante");
                                        }else{
                                            Ext.getCmp('intHachinskiCursoFPto').setValue(0);
                                            Ext.getCmp('strHachinskiCursoFDes').setValue("Curso fluctuante");
                                        }
                                        CalculaValoracionHachinski();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intHachinskiCursoFPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strHachinskiCursoFDes'
                            },
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Confusión nocturna',
                                name: 'Confusión nocturna',
                                labelStyle: 'color: #9E1616;',
                                id: 'strHachinskiConfusionNoc',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intHachinskiConfusionNocPto').setValue(1);
                                            Ext.getCmp('strHachinskiConfusionNocDes').setValue("Confusión nocturna");
                                        }else{
                                            Ext.getCmp('intHachinskiConfusionNocPto').setValue(0);
                                            Ext.getCmp('strHachinskiConfusionNocDes').setValue("Confusión nocturna");
                                        }
                                        CalculaValoracionHachinski();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intHachinskiConfusionNocPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strHachinskiConfusionNocDes'
                            },
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Preservación de la personalidad',
                                name: 'Preservación de la personalidad',
                                labelStyle: 'color: #9E1616;',
                                id: 'strHachinskiCoservaPer',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intHachinskiCoservaPerPto').setValue(1);
                                            Ext.getCmp('strHachinskiCoservaPercDes').setValue("Preservación de la personalidad");
                                        }else{
                                            Ext.getCmp('intHachinskiCoservaPerPto').setValue(0);
                                            Ext.getCmp('strHachinskiCoservaPercDes').setValue("Preservación de la personalidad");
                                        }
                                        CalculaValoracionHachinski();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intHachinskiCoservaPerPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strHachinskiCoservaPercDes'
                            },
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Depresión',
                                name: 'Depresión',
                                labelStyle: 'color: #9E1616;',
                                id: 'strHachinskiDepresion',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intHachinskiDepresionPto').setValue(1);
                                            Ext.getCmp('strHachinskiDepresionDes').setValue("Depresión");
                                        }else{
                                            Ext.getCmp('intHachinskiDepresionPto').setValue(0);
                                            Ext.getCmp('strHachinskiDepresionDes').setValue("Depresión");
                                        }
                                        CalculaValoracionHachinski();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intHachinskiDepresionPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strHachinskiDepresionDes'
                            },
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Quejas somáticas',
                                name: 'Quejas somáticas',
                                labelStyle: 'color: #9E1616;',
                                id: 'strHachinskiSinomasSoma',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intHachinskiSinomasSomaPto').setValue(1);
                                            Ext.getCmp('strHachinskiSinomasSomaDes').setValue("Quejas somáticas");
                                        }else{
                                            Ext.getCmp('intHachinskiSinomasSomaPto').setValue(0);
                                            Ext.getCmp('strHachinskiSinomasSomaDes').setValue("Quejas somáticas");
                                        }
                                        CalculaValoracionHachinski();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intHachinskiSinomasSomaPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strHachinskiSinomasSomaDes'
                            },
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Incontinencia emocional',
                                name: 'Incontinencia emocional',
                                labelStyle: 'color: #9E1616;',
                                id: 'strHachinskiLabilidadEmo',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intHachinskiLabilidadEmoPto').setValue(1);
                                            Ext.getCmp('strHachinskiLabilidadEmoDes').setValue("Incontinencia emocional");
                                        }else{
                                            Ext.getCmp('intHachinskiLabilidadEmoPto').setValue(0);
                                            Ext.getCmp('strHachinskiLabilidadEmoDes').setValue("Incontinencia emocional");
                                        }
                                        CalculaValoracionHachinski();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intHachinskiLabilidadEmoPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strHachinskiLabilidadEmoDes'
                            },
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Antecedentes de hipertensión arterial sistémica',
                                name: 'Antecedentes de hipertensión arterial sistémica',
                                labelStyle: 'color: #9E1616;',
                                id: 'strHachinskiHTAS',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intHachinskiHTASPto').setValue(1);
                                            Ext.getCmp('strHachinskiHTASDes').setValue("Antecedentes de hipertensión arterial sistémica");
                                        }else{
                                            Ext.getCmp('intHachinskiHTASPto').setValue(0);
                                            Ext.getCmp('strHachinskiHTASDes').setValue("Antecedentes de hipertensión arterial sistémica");
                                        }
                                        CalculaValoracionHachinski();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intHachinskiHTASPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strHachinskiHTASDes'
                            },
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Antecedentes de ECV',
                                name: 'Antecedentes de ECV',
                                labelStyle: 'color: #9E1616;',
                                id: 'strHachinskiIctus',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intHachinskiIctusPto').setValue(2);
                                            Ext.getCmp('strHachinskiIctusDes').setValue("Antecedentes de ECV");
                                        }else{
                                            Ext.getCmp('intHachinskiIctusPto').setValue(0);
                                            Ext.getCmp('strHachinskiIctusDes').setValue("Antecedentes de ECV");
                                        }
                                        CalculaValoracionHachinski();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intHachinskiIctusPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strHachinskiIctusDes'
                            },
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Evidencia de arteroesclerosis',
                                name: 'Evidencia de arteroesclerosis',
                                labelStyle: 'color: #9E1616;',
                                id: 'strHachinskiSignoArtereoescle',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intHachinskiSignoArtereoesclePto').setValue(1);
                                            Ext.getCmp('strHachinskiSignoArtereoescleDes').setValue("Evidencia de arteroesclerosis");
                                        }else{
                                            Ext.getCmp('intHachinskiSignoArtereoesclePto').setValue(0);
                                            Ext.getCmp('strHachinskiSignoArtereoescleDes').setValue("Evidencia de arteroesclerosis");
                                        }
                                        CalculaValoracionHachinski();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intHachinskiSignoArtereoesclePto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strHachinskiSignoArtereoescleDes'
                            },
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Signos neurológicos focales',
                                name: 'Signos neurológicos focales',
                                labelStyle: 'color: #9E1616;',
                                id: 'strHachinskiSignoNeuroFocal',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intHachinskiSignoNeuroFocalPto').setValue(2);
                                            Ext.getCmp('strHachinskiSignoNeuroFocalDes').setValue("Signos neurológicos focales");
                                        }else{
                                            Ext.getCmp('intHachinskiSignoNeuroFocalPto').setValue(0);
                                            Ext.getCmp('strHachinskiSignoNeuroFocalDes').setValue("Signos neurológicos focales");
                                        }
                                        CalculaValoracionHachinski();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intHachinskiSignoNeuroFocalPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strHachinskiSignoNeuroFocalDes'
                            },
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Sintomas neurológicos focales',
                                name: 'Sintomas neurológicos focales',
                                labelStyle: 'color: #9E1616;',
                                id: 'strHachinskiSintomaNeuroFocal',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intHachinskiSintomaNeuroFocalPto').setValue(2);
                                            Ext.getCmp('strHachinskiSintomaNeuroFocalDes').setValue("Sintomas neurológicos focales");
                                        }else{
                                            Ext.getCmp('intHachinskiSintomaNeuroFocalPto').setValue(0);
                                            Ext.getCmp('strHachinskiSintomaNeuroFocalDes').setValue("Sintomas neurológicos focales");
                                        }
                                        CalculaValoracionHachinski();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intHachinskiSintomaNeuroFocalPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strHachinskiSintomaNeuroFocalDes'
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'TEST YESAVAGE',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        labelWidth: 170,
                        id: 'fsYESAVAGE',
                        items: []
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirBerthel',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1){
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('winHCBerthel').close();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.getCmp('winHCBerthel').close();
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarBarthel',
                            listeners:{
                                click : function(){
                                    Ext.Msg.show({
                                        title: 'eOfiClinic',
                                        msg: 'Esta seguro que desea Modificar el Test, si hace esto no podra realizar ningun cambio?',
                                        buttons: Ext.Msg.YESNO,
                                        icon: Ext.Msg.QUESTION,
                                        fn: function(btn){
                                            if(btn=="yes")
                                            {
                                                fnModificarRegistrosBarthel();
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                var frm = Ext.getCmp('frmBarthel').getForm();
                frm.load({
                    params:{
                        pCAS: Ext.getCmp('sysCASHC').getValue(),
                        pConsecutivo: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                        task: 'PARTISALUD_CARGAR_DATA_TOMAMUESTRAS'
                    }
                });
            }}//jorge
        }); 
        winHCTestBarthel.superclass.initComponent.call(this);
    }
});


function fnModificarRegistrosBarthel(){
    var frm = Ext.getCmp('frmBarthel').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: '../../controlador/asistencial/test.php',
            params:{
                task: 'BARTHEL',
                CAMPOS: listacampos,
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pConsecutivoHC: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        Ext.getCmp('gridFormulario').store.reload();
                        Ext.getCmp('winHCBerthel').close();
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function CalculaValoracionHachinski(){
/*
 * Una puntuación < 4 sugiere un trastorno degenerativo
  Entre 4 y 7 puntos: casos dudosos y demencias mixtas
  Una puntuación > 7 sugiere una demencia vascular
 */    

}

function CalculaValoracionBarthel(){
    var ValoracionComer = 0;
    var ValoracionLavarse = 0;
    var ValoracionVestirse = 0;
    var ValoracionArreglarse = 0;
    var ValoracionDeposiciones = 0;
    var ValoracionMiccion = 0;
    var ValoracionRetrete = 0;
    var ValoracionTraslado = 0;
    var ValoracionDeambular = 0;
    var ValoracionEscalones = 0;
    var ValoracionTotal = 0 ;
    if(Ext.getCmp('intBarthelComerPto').getValue() != null && Ext.getCmp('intBarthelComerPto').getValue() != ""){
        ValoracionComer = parseInt(Ext.getCmp('intBarthelComerPto').getValue());
    }else{
        ValoracionComer = 0;
    }
    if(Ext.getCmp('intBarthelLavarsePto').getValue() != null && Ext.getCmp('intBarthelLavarsePto').getValue() != ""){
        ValoracionLavarse = parseInt(Ext.getCmp('intBarthelLavarsePto').getValue());
    }else{
        ValoracionLavarse = 0;
    }
    if(Ext.getCmp('intBarthelVestirsePto').getValue() != null && Ext.getCmp('intBarthelVestirsePto').getValue() != ""){
        ValoracionVestirse = parseInt(Ext.getCmp('intBarthelVestirsePto').getValue());
    }else{
        ValoracionVestirse = 0;
    }
    if(Ext.getCmp('intBarthelArreglarsePto').getValue() != null && Ext.getCmp('intBarthelArreglarsePto').getValue() != ""){
        ValoracionArreglarse = parseInt(Ext.getCmp('intBarthelArreglarsePto').getValue());
    }else{
        ValoracionArreglarse = 0;
    }
    if(Ext.getCmp('intBarthelDeposicionesPto').getValue() != null && Ext.getCmp('intBarthelDeposicionesPto').getValue() != ""){
        ValoracionDeposiciones = parseInt(Ext.getCmp('intBarthelDeposicionesPto').getValue());
    }else{
        ValoracionDeposiciones = 0;
    }
    if(Ext.getCmp('intBarthelMiccionPto').getValue() != null && Ext.getCmp('intBarthelMiccionPto').getValue() != ""){
        ValoracionMiccion = parseInt(Ext.getCmp('intBarthelMiccionPto').getValue());
    }else{
        ValoracionMiccion = 0;
    }
    if(Ext.getCmp('intBarthelRetretePto').getValue() != null && Ext.getCmp('intBarthelRetretePto').getValue() != ""){
        ValoracionRetrete = parseInt(Ext.getCmp('intBarthelRetretePto').getValue());
    }else{
        ValoracionRetrete = 0;
    }
    if(Ext.getCmp('intBarthelTrasladoPto').getValue() != null && Ext.getCmp('intBarthelTrasladoPto').getValue() != ""){
        ValoracionTraslado = parseInt(Ext.getCmp('intBarthelTrasladoPto').getValue());
    }else{
        ValoracionTraslado = 0;
    }
    if(Ext.getCmp('intBarthelDeambularPto').getValue() != null && Ext.getCmp('intBarthelDeambularPto').getValue() != ""){
        ValoracionDeambular = parseInt(Ext.getCmp('intBarthelDeambularPto').getValue());
    }else{
        ValoracionDeambular = 0;
    }
    if(Ext.getCmp('intBarthelEscalonesPto').getValue() != null && Ext.getCmp('intBarthelEscalonesPto').getValue() != ""){
        ValoracionEscalones = parseInt(Ext.getCmp('intBarthelEscalonesPto').getValue());
    }else{
        ValoracionEscalones = 0;
    }
    ValoracionTotal = ValoracionComer + ValoracionLavarse + ValoracionVestirse + ValoracionArreglarse + ValoracionDeposiciones + ValoracionMiccion + ValoracionRetrete + ValoracionTraslado + ValoracionDeambular + ValoracionEscalones;
    Ext.getCmp('intBarthelTotal').setValue(ValoracionTotal);
    if(ValoracionTotal < 20){
        Ext.getCmp('strBarthelValoracion').setValue("Total");
    }else{
        if(ValoracionTotal < 36){
            Ext.getCmp('strBarthelValoracion').setValue("Grave");
        }else{
            if(ValoracionTotal < 56){
                Ext.getCmp('strBarthelValoracion').setValue("Moderado");
            }else{
                if(ValoracionTotal < 60){
                    Ext.getCmp('strBarthelValoracion').setValue("Moderado");
                }else{
                    Ext.getCmp('strBarthelValoracion').setValue("Independiente");
                }
            }
        }
    }
}