/*
* @category    Formulario Test Barthel
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCTestBarthelUi = Ext.extend(Ext.FormPanel, {
    frame: true,
    anchor: '100%',
    id: 'frmTestBarthel',
    padding: 10,
    border: false,
    autoScroll: true,
    style: 'background:transparent;',
    initComponent: function() {
        this.tbar = {
            xtype: 'toolbar',
            items: [
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Guardar Test',
                    iconCls: 'btnGuardar',
                    id: 'btnGuardarBarthel',
                    listeners:{
                        click : function(){
                            if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) {
                                fnGuardarRegistrosBarthel();
                            }else{
                                Ext.Msg.show({
                                    title: 'eOfiClinic',
                                    msg: 'Debe Guardar la evolución?',
                                    buttons: Ext.Msg.OK,
                                    icon: Ext.Msg.ERROR
                                });
                            }
                        }
                    }
                }
            ]
        };
        this.items = [
            {
                xtype: 'fieldset',
                title: 'TEST BARTHEL',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                labelWidth: 120,
                id: 'fsBarthel',
                items: [
                    {
                        xtype: 'radiogroup',
                        fieldLabel: 'ALIMENTACION',
                        autoHeight: true,
                        labelStyle: 'color: #000000;',
                        name: 'ALIMENTACION',
                        vertical: true,
                        columns: 1,
                        id: 'strBarthelComer',
                        items:[
                            {anchor: '98%', boxLabel: 'INDEPENDIENTE: Capaz de utilizar cualquier instrumento necesario; come en un tiempo razonable; capaz de desmenuzar la comida, usar condimentos, extender mantequilla, etc. por si solo. la comida puede situarse a su alcance', name: 'strBarthelComer', inputValue: 'A'},
                            {anchor: '98%', boxLabel: 'NECESITA AYUDA: Ej. para cortar o extender la mantequilla', name: 'strBarthelComer', inputValue: 'B'},
                            {anchor: '98%', boxLabel: 'DEPENDIENTE: Necesita ser alimentado', name: 'strBarthelComer', inputValue: 'C'}
                        ],
                        listeners:{
                            change : function(radiogroup, radio){
                                switch(radio.inputValue){
                                    case "A":
                                        Ext.getCmp('intBarthelComerPto').setValue(10);
                                        Ext.getCmp('strBarthelComerDes').setValue("INDEPENDIENTE: Capaz de utilizar cualquier instrumento necesario; come en un tiempo razonable; capaz de desmenuzar la comida, usar condimentos, extender mantequilla, etc. por si solo. la comida puede situarse a su alcance");
                                        break;
                                    case "B":
                                        Ext.getCmp('intBarthelComerPto').setValue(5);
                                        Ext.getCmp('strBarthelComerDes').setValue("NECESITA AYUDA: Ej. para cortar o extender la mantequilla");
                                        break;
                                    case "C":
                                        Ext.getCmp('intBarthelComerPto').setValue(0);
                                        Ext.getCmp('strBarthelComerDes').setValue("DEPENDIENTE: Necesita ser alimentado");
                                        break;
                                    default:
                                        break;
                                }
                                CalculaValoracionBarthel();
                            }
                        }
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'intBarthelComerPto'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'strBarthelComerDes'
                    },
                    {
                        html: '<br>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'radiogroup',
                        fieldLabel: 'LAVADO (BAÑO)',
                        labelStyle: 'color: #000000;',
                        name: 'LAVADO (BAÑO)',
                        vertical: true,
                        columns: 1,
                        id: 'strBarthelLavarse',
                        items:[
                            {anchor: '98%', boxLabel: 'INDEPENDIENTE: Capaz de bañarse completo; puede ser usando la ducha, la tina o permaneciendo de pie y aplicando la esponja sobre todo el cuerpo. incluye entrar y salir del baño. puede realizarlo sin necesidad de estar una persona', name: 'strBarthelLavarse', inputValue: 'A'},
                            {anchor: '98%', boxLabel: 'DEPENDIENTE: Necesita alguna ayuda', name: 'strBarthelLavarse', inputValue: 'B'},
                        ],
                        listeners:{
                            change : function(radiogroup, radio){
                                switch(radio.inputValue){
                                    case "A":
                                        Ext.getCmp('intBarthelLavarsePto').setValue(5);
                                        Ext.getCmp('strBarthelLavarseDes').setValue("INDEPENDIENTE: Capaz de bañarse completo; puede ser usando la ducha, la tina o permaneciendo de pie y aplicando la esponja sobre todo el cuerpo. incluye entrar y salir del baño. puede realizarlo sin necesidad de estar una persona");
                                        break;
                                    case "B":
                                        Ext.getCmp('intBarthelLavarsePto').setValue(0);
                                        Ext.getCmp('strBarthelLavarseDes').setValue("DEPENDIENTE: Necesita alguna ayuda");
                                        break;
                                    default:
                                        break;
                                }
                                CalculaValoracionBarthel();
                            }
                        }
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'intBarthelLavarsePto'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'strBarthelLavarseDes'
                    },
                    {
                        html: '<br>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'radiogroup',
                        fieldLabel: 'VESTIRSE',
                        labelStyle: 'color: #000000;',
                        name: 'VESTIRSE',
                        vertical: true,
                        columns: 1,
                        id: 'strBarthelVestirse',
                        items:[
                            {anchor: '98%', boxLabel: 'INDEPENDIENTE: Capaz de ponerse, quitarse y fijar la ropa. se ata los zapatos, abrocha los botones. se coloca el brasier o corse si lo necesita', name: 'strBarthelVestirse', inputValue: 'A'},
                            {anchor: '98%', boxLabel: 'NECESITA AYUDA: Pero hace al menos la mitad de las tareas en un tiempo razonable', name: 'strBarthelVestirse', inputValue: 'B'},
                            {anchor: '98%', boxLabel: 'DEPENDIENTE: Necesita ayuda', name: 'strBarthelVestirse', inputValue: 'C'}
                        ],
                        listeners:{
                            change : function(radiogroup, radio){
                                switch(radio.inputValue){
                                    case "A":
                                        Ext.getCmp('intBarthelVestirsePto').setValue(10);
                                        Ext.getCmp('strBarthelVestirseDes').setValue("INDEPENDIENTE: Capaz de ponerse, quitarse y fijar la ropa. se ata los zapatos, abrocha los botones. se coloca el brasier o corse si lo necesita");
                                        break;
                                    case "B":
                                        Ext.getCmp('intBarthelVestirsePto').setValue(5);
                                        Ext.getCmp('strBarthelVestirseDes').setValue("NECESITA AYUDA: Pero hace al menos la mitad de las tareas en un tiempo razonable");
                                        break;
                                    case "C":
                                        Ext.getCmp('intBarthelVestirsePto').setValue(0);
                                        Ext.getCmp('strBarthelVestirseDes').setValue("DEPENDIENTE: Necesita ayuda");
                                        break;
                                    default:
                                        break;
                                }
                                CalculaValoracionBarthel();
                            }
                        }
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'intBarthelVestirsePto'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'strBarthelVestirseDes'
                    },
                    {
                        html: '<br>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'radiogroup',
                        fieldLabel: 'ARREGLARSE',
                        labelStyle: 'color: #000000;',
                        name: 'ARREGLARSE',
                        vertical: true,
                        columns: 1,
                        id: 'strBarthelArreglarse',
                        items:[
                            {anchor: '98%', boxLabel: 'INDEPENDIENTE: Realiza todas las actividades personales (ej. lavarse manos y cara, peinarse). incluye afeitarse y lavarse los dientes. no necesita ninguna ayuda', name: 'strBarthelArreglarse', inputValue: 'A'},
                            {anchor: '98%', boxLabel: 'DEPENDIENTE: Necesita alguna ayuda', name: 'strBarthelArreglarse', inputValue: 'B'}
                        ],
                        listeners:{
                            change : function(radiogroup, radio){
                                switch(radio.inputValue){
                                    case "A":
                                        Ext.getCmp('intBarthelArreglarsePto').setValue(5);
                                        Ext.getCmp('strBarthelArreglarseDes').setValue("INDEPENDIENTE: Realiza todas las actividades personales (ej. lavarse manos y cara, peinarse). incluye afeitarse y lavarse los dientes. no necesita ninguna ayuda");
                                        break;
                                    case "B":
                                        Ext.getCmp('intBarthelArreglarsePto').setValue(0);
                                        Ext.getCmp('strBarthelArreglarseDes').setValue("DEPENDIENTE: Necesita alguna ayuda");
                                        break;
                                    default:
                                        break;
                                }
                                CalculaValoracionBarthel();
                            }
                        }
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'intBarthelArreglarsePto'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'strBarthelArreglarseDes'
                    },
                    {
                        html: '<br>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'radiogroup',
                        fieldLabel: 'DEPOSICION',
                        labelStyle: 'color: #000000;',
                        name: 'DEPOSICION',
                        vertical: true,
                        columns: 1,
                        id: 'strBarthelDeposiciones',
                        items:[
                            {anchor: '98%', boxLabel: 'CONTINENTE, NINGUN ACCIDENTE: No necesita ninguna ayuda', name: 'strBarthelDeposiciones', inputValue: 'A'},
                            {anchor: '98%', boxLabel: 'ACCIDENTE OCASIONAL: Raro menos de una vez por semana', name: 'strBarthelDeposiciones', inputValue: 'B'},
                            {anchor: '98%', boxLabel: 'INCONTINENTE', name: 'strBarthelDeposiciones', inputValue: 'C'}
                        ],
                        listeners:{
                            change : function(radiogroup, radio){
                                switch(radio.inputValue){
                                    case "A":
                                        Ext.getCmp('intBarthelDeposicionesPto').setValue(10);
                                        Ext.getCmp('strBarthelDeposicionesDes').setValue("CONTINENTE, NINGUN ACCIDENTE: No necesita ninguna ayuda");
                                        break;
                                    case "B":
                                        Ext.getCmp('intBarthelDeposicionesPto').setValue(5);
                                        Ext.getCmp('strBarthelDeposicionesDes').setValue("ACCIDENTE OCASIONAL: Raro menos de una vez por semana");
                                        break;
                                    case "C":
                                        Ext.getCmp('intBarthelDeposicionesPto').setValue(0);
                                        Ext.getCmp('strBarthelDeposicionesDes').setValue("INCONTINENTE");
                                        break;
                                    default:
                                        break;
                                }
                                CalculaValoracionBarthel();
                            }
                        }
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'intBarthelDeposicionesPto'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'strBarthelDeposicionesDes'
                    },
                    {
                        html: '<br>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'radiogroup',
                        fieldLabel: 'MICCION',
                        labelStyle: 'color: #000000;',
                        name: 'MICCION',
                        vertical: true,
                        columns: 1,
                        id: 'strBarthelMiccion',
                        items:[
                            {anchor: '98%', boxLabel: 'CONTINENTE, NINGUN ACCIDENTE: Seco dia y noche, capaz de usar cualquier dispositivo ( ej cateter) si es necesario, es capaz de cambiar la bolsa', name: 'strBarthelMiccion', inputValue: 'A'},
                            {anchor: '98%', boxLabel: 'ACCIDENTE OCASIONAL: Menos de una vez por semana, necesita ayuda con instrumentos', name: 'strBarthelMiccion', inputValue: 'B'},
                            {anchor: '98%', boxLabel: 'INCONTINENTE', name: 'strBarthelMiccion', inputValue: 'C'}
                        ],
                        listeners:{
                            change : function(radiogroup, radio){
                                switch(radio.inputValue){
                                    case "A":
                                        Ext.getCmp('intBarthelMiccionPto').setValue(10);
                                        Ext.getCmp('strBarthelMiccionDes').setValue("CONTINENTE, NINGUN ACCIDENTE: Seco dia y noche, capaz de usar cualquier dispositivo ( ej cateter) si es necesario, es capaz de cambiar la bolsa");
                                        break;
                                    case "B":
                                        Ext.getCmp('intBarthelMiccionPto').setValue(5);
                                        Ext.getCmp('strBarthelMiccionDes').setValue("ACCIDENTE OCASIONAL: Menos de una vez por semana, necesita ayuda con instrumentos");
                                        break;
                                    case "C":
                                        Ext.getCmp('intBarthelMiccionPto').setValue(0);
                                        Ext.getCmp('strBarthelMiccionDes').setValue("INCONTINENTE");
                                        break;
                                    default:
                                        break;
                                }
                                CalculaValoracionBarthel();
                            }
                        }
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'intBarthelMiccionPto'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'strBarthelMiccionDes'
                    },
                    {
                        html: '<br>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'radiogroup',
                        fieldLabel: 'SANITARIO',
                        labelStyle: 'color: #000000;',
                        name: 'SANITARIO',
                        vertical: true,
                        columns: 1,
                        id: 'strBarthelRetrete',
                        items:[
                            {anchor: '98%', boxLabel: 'INDEPENDIENTE: Entra y sale solo, capaz de quitarse y ponerse la ropa, limpiarse, prevenir el manchado de la ropa, limpiar y vaciar completamente la bacinilla o sanitario, sin ayuda. capaz de sentarse y levantarse sin ayuda. puede utilizar barras para sostenerse', name: 'strBarthelRetrete', inputValue: 'A'},
                            {anchor: '98%', boxLabel: 'NECESITA AYUDA: Capaz de manejarse con pequeña ayuda en el equilibrio, quitarse y ponerse la ropa o usar el papel higienico. sin embargo, aun es capaz de utilizar el inodoro', name: 'strBarthelRetrete', inputValue: 'B'},
                            {anchor: '98%', boxLabel: 'DEPENDIENTE: Incapaz de usar el sanitario sin ayuda', name: 'strBarthelRetrete', inputValue: 'C'}
                        ],
                        listeners:{
                            change : function(radiogroup, radio){
                                switch(radio.inputValue){
                                    case "A":
                                        Ext.getCmp('intBarthelRetretePto').setValue(10);
                                        Ext.getCmp('strBarthelRetreteDes').setValue("INDEPENDIENTE: Entra y sale solo, capaz de quitarse y ponerse la ropa, limpiarse, prevenir el manchado de la ropa, limpiar y vaciar completamente la bacinilla o sanitario, sin ayuda. capaz de sentarse y levantarse sin ayuda. puede utilizar barras para sostenerse");
                                        break;
                                    case "B":
                                        Ext.getCmp('intBarthelRetretePto').setValue(5);
                                        Ext.getCmp('strBarthelRetreteDes').setValue("NECESITA AYUDA: Capaz de manejarse con pequeña ayuda en el equilibrio, quitarse y ponerse la ropa o usar el papel higienico. sin embargo, aun es capaz de utilizar el inodoro");
                                        break;
                                    case "C":
                                        Ext.getCmp('intBarthelRetretePto').setValue(0);
                                        Ext.getCmp('strBarthelRetreteDes').setValue("DEPENDIENTE: Incapaz de usar el sanitario sin ayuda");
                                        break;
                                    default:
                                        break;
                                }
                                CalculaValoracionBarthel();
                            }
                        }
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'intBarthelRetretePto'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'strBarthelRetreteDes'
                    },
                    {
                        html: '<br>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'radiogroup',
                        fieldLabel: 'TRASLADO SILLA-CAMA',
                        labelStyle: 'color: #000000;',
                        name: 'TRASLADO SILLA-CAMA',
                        vertical: true,
                        columns: 1,
                        id: 'strBarthelTraslado',
                        items:[
                            {anchor: '98%', boxLabel: 'INDEPENDIENTE: Sin ayuda en todas las fases, en caso de utilizar la silla de ruedas, se aproxima a la cama, frena y la cierra si es necesario, se mete y se acuesta en la cama, se coloca en posicion sentado en la cama', name: 'strBarthelTraslado', inputValue: 'A'},
                            {anchor: '98%', boxLabel: 'MINIMA AYUDA: Incluye supervision verbal y pequeña ayuda fisica, tal como la ofrecida por un conyuge no muy fuerte', name: 'strBarthelTraslado', inputValue: 'B'},
                            {anchor: '98%', boxLabel: 'GRAN AYUDA: Capaz de estar sentado sin ayuda, pero necesita mucha asistencia para salir de la cama o desplazarse', name: 'strBarthelTraslado', inputValue: 'C'},
                            {anchor: '98%', boxLabel: 'DEPENDIENTE: Necesita grua o desplazamiento por dos personas, incapaz de estar sentado', name: 'strBarthelTraslado', inputValue: 'D'}
                        ],
                        listeners:{
                            change : function(radiogroup, radio){
                                switch(radio.inputValue){
                                    case "A":
                                        Ext.getCmp('intBarthelTrasladoPto').setValue(15);
                                        Ext.getCmp('strBarthelTrasladoDes').setValue("INDEPENDIENTE: Sin ayuda en todas las fases, en caso de utilizar la silla de ruedas, se aproxima a la cama, frena y la cierra si es necesario, se mete y se acuesta en la cama, se coloca en posicion sentado en la cama");
                                        break;
                                    case "B":
                                        Ext.getCmp('intBarthelTrasladoPto').setValue(10);
                                        Ext.getCmp('strBarthelTrasladoDes').setValue("MINIMA AYUDA: Incluye supervision verbal y pequeña ayuda fisica, tal como la ofrecida por un conyuge no muy fuerte");
                                        break;
                                    case "C":
                                        Ext.getCmp('intBarthelTrasladoPto').setValue(5);
                                        Ext.getCmp('strBarthelTrasladoDes').setValue("GRAN AYUDA: Capaz de estar sentado sin ayuda, pero necesita mucha asistencia para salir de la cama o desplazarse");
                                        break;
                                    case "D":
                                        Ext.getCmp('intBarthelTrasladoPto').setValue(0);
                                        Ext.getCmp('strBarthelTrasladoDes').setValue("DEPENDIENTE: Necesita grua o desplazamiento por dos personas, incapaz de estar sentado");
                                        break;
                                    default:
                                        break;
                                }
                                CalculaValoracionBarthel();
                            }
                        }
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'intBarthelTrasladoPto'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'strBarthelTrasladoDes'
                    },
                    {
                        html: '<br>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'radiogroup',
                        fieldLabel: 'DEAMBULACION',
                        labelStyle: 'color: #000000;',
                        name: 'DEAMBULACION',
                        vertical: true,
                        columns: 1,
                        id: 'strBarthelDeambular',
                        items:[
                            {anchor: '98%', boxLabel: 'INDEPENDIENTE: Puede usar cualquier ayuda: protesis, caminador, muletas, la velocidad no es importante, puede caminar al menos 50 mts o su equivalente en casa, sin ayuda o supervision', name: 'strBarthelDeambular', inputValue: 'A'},
                            {anchor: '98%', boxLabel: 'NECESITA AYUDA: Supervision verbal o fisica, incluyendo instrumentos u otras ayudas para permanecer de pie, deambula 50 mts', name: 'strBarthelDeambular', inputValue: 'B'},
                            {anchor: '98%', boxLabel: 'INDEPENDIENTE EN SILLA DE RUEDAS: Debe ser capaz de girar solo', name: 'strBarthelDeambular', inputValue: 'C'},
                            {anchor: '98%', boxLabel: 'INMOVIL: Incluye ayuda para voltearse en la cama', name: 'strBarthelDeambular', inputValue: 'D'}
                        ],
                        listeners:{
                            change : function(radiogroup, radio){
                                switch(radio.inputValue){
                                    case "A":
                                        Ext.getCmp('intBarthelDeambularPto').setValue(15);
                                        Ext.getCmp('strBarthelDeambularDes').setValue("INDEPENDIENTE: Puede usar cualquier ayuda: protesis, caminador, muletas, la velocidad no es importante, puede caminar al menos 50 mts o su equivalente en casa, sin ayuda o supervision");
                                        break;
                                    case "B":
                                        Ext.getCmp('intBarthelDeambularPto').setValue(10);
                                        Ext.getCmp('strBarthelDeambularDes').setValue("NECESITA AYUDA: Supervision verbal o fisica, incluyendo instrumentos u otras ayudas para permanecer de pie, deambula 50 mts");
                                        break;
                                    case "C":
                                        Ext.getCmp('intBarthelDeambularPto').setValue(5);
                                        Ext.getCmp('strBarthelDeambularDes').setValue("INDEPENDIENTE EN SILLA DE RUEDAS: Debe ser capaz de girar solo");
                                        break;
                                    case "D":
                                        Ext.getCmp('intBarthelDeambularPto').setValue(0);
                                        Ext.getCmp('strBarthelDeambularDes').setValue("INMOVIL: Incluye ayuda para voltearse en la cama");
                                        break;
                                    default:
                                        break;
                                }
                                CalculaValoracionBarthel();
                            }
                        }
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'intBarthelDeambularPto'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'strBarthelDeambularDes'
                    },
                    {
                        html: '<br>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'radiogroup',
                        fieldLabel: 'ESCALONES',
                        labelStyle: 'color: #000000;',
                        name: 'ESCALONES',
                        vertical: true,
                        columns: 1,
                        id: 'strBarthelEscalones',
                        items:[
                            {anchor: '98%', boxLabel: 'INDEPENDIENTE: Capaz de subir y bajar un tramo de escalera sin ayuda o supervision, puede utilizar el apoyo que precisa para caminar (baston, muletas, etc) y el pasamanos', name: 'strBarthelEscalones', inputValue: 'A'},
                            {anchor: '98%', boxLabel: 'NECESITA AYUDA: Supervision fisica o verbal', name: 'strBarthelEscalones', inputValue: 'B'},
                            {anchor: '98%', boxLabel: 'INCAPAZ: Necesita ascensor o no puede subir escalones', name: 'strBarthelEscalones', inputValue: 'C'}
                        ],
                        listeners:{
                            change : function(radiogroup, radio){
                                switch(radio.inputValue){
                                    case "A":
                                        Ext.getCmp('intBarthelEscalonesPto').setValue(10);
                                        Ext.getCmp('strBarthelEscalonesDes').setValue("INDEPENDIENTE: Capaz de subir y bajar un tramo de escalera sin ayuda o supervision, puede utilizar el apoyo que precisa para caminar (baston, muletas, etc) y el pasamanos");
                                        break;
                                    case "B":
                                        Ext.getCmp('intBarthelEscalonesPto').setValue(15);
                                        Ext.getCmp('strBarthelEscalonesDes').setValue("NECESITA AYUDA: Supervision fisica o verbal");
                                        break;
                                    case "C":
                                        Ext.getCmp('intBarthelEscalonesPto').setValue(0);
                                        Ext.getCmp('strBarthelEscalonesDes').setValue("INCAPAZ: Necesita ascensor o no puede subir escalones");
                                        break;
                                    default:
                                        break;
                                }
                                CalculaValoracionBarthel();
                            }
                        }
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'intBarthelEscalonesPto'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'strBarthelEscalonesDes'
                    },
                    {
                        html: '<br>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        labelStyle: 'color: #000000;',
                        fieldLabel: 'Máxima puntuación: 100 puntos (90 si va en silla de ruedas)',
                        items: [
                            {
                                xtype: 'numberfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                id: 'intBarthelTotal'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysvCalsifica',
                                value: 'Grado de Dependencia: '
                            },
                            {
                                xtype: 'textfield',
                                width: 150,
                                allowBlank: true,
                                readOnly: true,
                                id: 'strBarthelValoracion'
                            }
                        ]
                    }
                ]
            }
        ];
        winHCTestBarthelUi.superclass.initComponent.call(this);
    }
});

function CalculaValoracionBarthel(){
    var ValoracionComer = 0;
    var ValoracionLavarse = 0;
    var ValoracionVestirse = 0;
    var ValoracionArreglarse = 0;
    var ValoracionDeposiciones = 0;
    var ValoracionMiccion = 0;
    var ValoracionRetrete = 0;
    var ValoracionTraslado = 0;
    var ValoracionDeambular = 0;
    var ValoracionEscalones = 0;
    var ValoracionTotal = 0 ;
    if(Ext.getCmp('intBarthelComerPto').getValue() != null && Ext.getCmp('intBarthelComerPto').getValue() != ""){
        ValoracionComer = parseInt(Ext.getCmp('intBarthelComerPto').getValue());
    }else{
        ValoracionComer = 0;
    }
    if(Ext.getCmp('intBarthelLavarsePto').getValue() != null && Ext.getCmp('intBarthelLavarsePto').getValue() != ""){
        ValoracionLavarse = parseInt(Ext.getCmp('intBarthelLavarsePto').getValue());
    }else{
        ValoracionLavarse = 0;
    }
    if(Ext.getCmp('intBarthelVestirsePto').getValue() != null && Ext.getCmp('intBarthelVestirsePto').getValue() != ""){
        ValoracionVestirse = parseInt(Ext.getCmp('intBarthelVestirsePto').getValue());
    }else{
        ValoracionVestirse = 0;
    }
    if(Ext.getCmp('intBarthelArreglarsePto').getValue() != null && Ext.getCmp('intBarthelArreglarsePto').getValue() != ""){
        ValoracionArreglarse = parseInt(Ext.getCmp('intBarthelArreglarsePto').getValue());
    }else{
        ValoracionArreglarse = 0;
    }
    if(Ext.getCmp('intBarthelDeposicionesPto').getValue() != null && Ext.getCmp('intBarthelDeposicionesPto').getValue() != ""){
        ValoracionDeposiciones = parseInt(Ext.getCmp('intBarthelDeposicionesPto').getValue());
    }else{
        ValoracionDeposiciones = 0;
    }
    if(Ext.getCmp('intBarthelMiccionPto').getValue() != null && Ext.getCmp('intBarthelMiccionPto').getValue() != ""){
        ValoracionMiccion = parseInt(Ext.getCmp('intBarthelMiccionPto').getValue());
    }else{
        ValoracionMiccion = 0;
    }
    if(Ext.getCmp('intBarthelRetretePto').getValue() != null && Ext.getCmp('intBarthelRetretePto').getValue() != ""){
        ValoracionRetrete = parseInt(Ext.getCmp('intBarthelRetretePto').getValue());
    }else{
        ValoracionRetrete = 0;
    }
    if(Ext.getCmp('intBarthelTrasladoPto').getValue() != null && Ext.getCmp('intBarthelTrasladoPto').getValue() != ""){
        ValoracionTraslado = parseInt(Ext.getCmp('intBarthelTrasladoPto').getValue());
    }else{
        ValoracionTraslado = 0;
    }
    if(Ext.getCmp('intBarthelDeambularPto').getValue() != null && Ext.getCmp('intBarthelDeambularPto').getValue() != ""){
        ValoracionDeambular = parseInt(Ext.getCmp('intBarthelDeambularPto').getValue());
    }else{
        ValoracionDeambular = 0;
    }
    if(Ext.getCmp('intBarthelEscalonesPto').getValue() != null && Ext.getCmp('intBarthelEscalonesPto').getValue() != ""){
        ValoracionEscalones = parseInt(Ext.getCmp('intBarthelEscalonesPto').getValue());
    }else{
        ValoracionEscalones = 0;
    }
    ValoracionTotal = ValoracionComer + ValoracionLavarse + ValoracionVestirse + ValoracionArreglarse + ValoracionDeposiciones + ValoracionMiccion + ValoracionRetrete + ValoracionTraslado + ValoracionDeambular + ValoracionEscalones;
    Ext.getCmp('intBarthelTotal').setValue(ValoracionTotal);
    if(ValoracionTotal < 20){
        Ext.getCmp('strBarthelValoracion').setValue("Total");
    }else{
        if(ValoracionTotal < 36){
            Ext.getCmp('strBarthelValoracion').setValue("Grave");
        }else{
            if(ValoracionTotal < 56){
                Ext.getCmp('strBarthelValoracion').setValue("Moderado");
            }else{
                if(ValoracionTotal < 60){
                    Ext.getCmp('strBarthelValoracion').setValue("Moderado");
                }else{
                    Ext.getCmp('strBarthelValoracion').setValue("Independiente");
                }
            }
        }
    }
}

function fnGuardarRegistrosBarthel(){
    var frm = Ext.getCmp('frmTestBarthel').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar_barthel',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pResultadoBarthel: Ext.getCmp('intBarthelTotal').getValue() + " - " + Ext.getCmp('strBarthelValoracion').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
