/*
* @category    Formulario Test Folstein
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCTestFolsteinUi = Ext.extend(Ext.FormPanel, {
    frame: true,
    anchor: '100%',
    id: 'frmTestFolstein',
    padding: 10,
    border: false,
    autoScroll: true,
    style: 'background:transparent;',
    initComponent: function() {
        this.tbar = {
            xtype: 'toolbar',
            items: [
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Guardar Test',
                    iconCls: 'btnGuardar',
                    id: 'btnGuardarFolstein',
                    listeners:{
                        click : function(){
                            if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) {
                                fnGuardarRegistrosFolstein();
                            }else{
                                Ext.Msg.show({
                                    title: 'eOfiClinic',
                                    msg: 'Debe Guardar la evolución?',
                                    buttons: Ext.Msg.OK,
                                    icon: Ext.Msg.ERROR
                                });
                            }
                        }
                    }
                }
            ]
        };
        this.items = [
            {
                xtype: 'fieldset',
                title: 'TEST FOLSTEIN',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                id: 'fsFOLSTEIN',
                items: [
                    {
                        xtype: 'fieldset',
                        title: 'ORIENTACION TIEMPO - DIGA EN QUE?',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        labelWidth: 230,
                        id: 'fsOrientaTiempo',
                        items: [
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Año nos encontramos?',
                                name: 'Año nos encontramos?',
                                labelStyle: 'color: #000000;',
                                id: 'bolFolsteinOrientacionAnio',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intFolsteinOrientacionAnioPto').setValue(1);
                                            Ext.getCmp('strFolsteinOrientacionAnioDes').setValue("Diga en que año nos encontramos");
                                        }else{
                                            Ext.getCmp('intFolsteinOrientacionAnioPto').setValue(0);
                                            Ext.getCmp('strFolsteinOrientacionAnioDes').setValue("Diga en que año nos encontramos");
                                        }
                                        CalculaValoracionFolstein();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intFolsteinOrientacionAnioPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strFolsteinOrientacionAnioDes'
                            },
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Mes nos encontramos?',
                                name: 'Mes nos encontramos?',
                                labelStyle: 'color: #000000;',
                                id: 'bolFolsteinOrientacionMes',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intFolsteinOrientacionMesPto').setValue(1);
                                            Ext.getCmp('strFolsteinOrientacionMesDes').setValue("Diga en que mes nos encontramos");
                                        }else{
                                            Ext.getCmp('intFolsteinOrientacionMesPto').setValue(0);
                                            Ext.getCmp('strFolsteinOrientacionMesDes').setValue("Diga en que mes nos encontramos");
                                        }
                                        CalculaValoracionFolstein();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intFolsteinOrientacionMesPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strFolsteinOrientacionMesDes'
                            },
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Dia nos encontramos?',
                                name: 'Dia nos encontramos?',
                                labelStyle: 'color: #000000;',
                                id: 'bolFolsteinOrientacionDia',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intFolsteinOrientacionDiaPto').setValue(1);
                                            Ext.getCmp('strFolsteinOrientacionDiaDes').setValue("Diga en que dia nos encontramos");
                                        }else{
                                            Ext.getCmp('intFolsteinOrientacionDiaPto').setValue(0);
                                            Ext.getCmp('strFolsteinOrientacionDiaDes').setValue("Diga en que dia nos encontramos");
                                        }
                                        CalculaValoracionFolstein();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intFolsteinOrientacionDiaPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strFolsteinOrientacionDiaDes'
                            },
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Dia/Semana nos encontramos?',
                                name: 'Dia/Semana nos encontramos?',
                                labelStyle: 'color: #000000;',
                                id: 'bolFolsteinOrientacionDiaSemana',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intFolsteinOrientacionDiaSemanaPto').setValue(1);
                                            Ext.getCmp('strFolsteinOrientacionDiaSemanaDes').setValue("Diga en que dia/semana nos encontramos");
                                        }else{
                                            Ext.getCmp('intFolsteinOrientacionDiaSemanaPto').setValue(0);
                                            Ext.getCmp('strFolsteinOrientacionDiaSemanaDes').setValue("Diga en que dia/semana nos encontramos");
                                        }
                                        CalculaValoracionFolstein();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intFolsteinOrientacionDiaSemanaPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strFolsteinOrientacionDiaSemanaDes'
                            },
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Hora nos encontramos?',
                                name: 'Hora nos encontramos?',
                                labelStyle: 'color: #000000;',
                                id: 'bolFolsteinOrientacionHora',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intFolsteinOrientacionHoraPto').setValue(1);
                                            Ext.getCmp('strFolsteinOrientacionHoraDes').setValue("Diga en que hora nos encontramos");
                                        }else{
                                            Ext.getCmp('intFolsteinOrientacionHoraPto').setValue(0);
                                            Ext.getCmp('strFolsteinOrientacionHoraDes').setValue("Diga en que hora nos encontramos");
                                        }
                                        CalculaValoracionFolstein();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intFolsteinOrientacionHoraPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strFolsteinOrientacionHoraDes'
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'ORIENTACION LUGAR - DIGA EN QUE?',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        labelWidth: 230,
                        id: 'fsOrientaLugar',
                        items: [
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Pais nos encontramos?',
                                name: 'Pais nos encontramos?',
                                labelStyle: 'color: #000000;',
                                id: 'bolFolsteinOrientacionPais',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intFolsteinOrientacionPaisPto').setValue(1);
                                            Ext.getCmp('strFolsteinOrientacionPaisDes').setValue("Diga en que pais nos encontramos");
                                        }else{
                                            Ext.getCmp('intFolsteinOrientacionPaisPto').setValue(0);
                                            Ext.getCmp('strFolsteinOrientacionPaisDes').setValue("Diga en que pais nos encontramos");
                                        }
                                        CalculaValoracionFolstein();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intFolsteinOrientacionPaisPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strFolsteinOrientacionPaisDes'
                            },
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Departamento nos encontramos?',
                                name: 'Departamento nos encontramos?',
                                labelStyle: 'color: #000000;',
                                id: 'bolFolsteinOrientacionDepto',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intFolsteinOrientacionDeptoPto').setValue(1);
                                            Ext.getCmp('strFolsteinOrientacionDeptoDes').setValue("Diga en que departamento nos encontramos");
                                        }else{
                                            Ext.getCmp('intFolsteinOrientacionDeptoPto').setValue(0);
                                            Ext.getCmp('strFolsteinOrientacionDeptoDes').setValue("Diga en que departamento nos encontramos");
                                        }
                                        CalculaValoracionFolstein();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intFolsteinOrientacionDeptoPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strFolsteinOrientacionDeptoDes'
                            },
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Ciudad nos encontramos?',
                                name: 'Ciudad nos encontramos?',
                                labelStyle: 'color: #000000;',
                                id: 'bolFolsteinOrientacionCiudad',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intFolsteinOrientacionCiudadPto').setValue(1);
                                            Ext.getCmp('strFolsteinOrientacionCiudadDes').setValue("Diga en que ciudad nos encontramos");
                                        }else{
                                            Ext.getCmp('intFolsteinOrientacionCiudadPto').setValue(0);
                                            Ext.getCmp('strFolsteinOrientacionCiudadDes').setValue("Diga en que ciudad nos encontramos");
                                        }
                                        CalculaValoracionFolstein();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intFolsteinOrientacionCiudadPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strFolsteinOrientacionCiudadDes'
                            },
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Barrio/Vereda nos encontramos?',
                                name: 'Barrio/Vereda nos encontramos?',
                                labelStyle: 'color: #000000;',
                                id: 'bolFolsteinOrientacionBarrio',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intFolsteinOrientacionBarrioPto').setValue(1);
                                            Ext.getCmp('strFolsteinOrientacionBarrioDes').setValue("Diga en que barrio/vereda nos encontramos");
                                        }else{
                                            Ext.getCmp('intFolsteinOrientacionBarrioPto').setValue(0);
                                            Ext.getCmp('strFolsteinOrientacionBarrioDes').setValue("Diga en que barrio/vereda nos encontramos");
                                        }
                                        CalculaValoracionFolstein();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intFolsteinOrientacionBarrioPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strFolsteinOrientacionBarrioDes'
                            },
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Lugar nos encontramos?',
                                name: 'Lugar nos encontramos?',
                                labelStyle: 'color: #000000;',
                                id: 'bolFolsteinOrientacionLugar',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intFolsteinOrientacionLugarPto').setValue(1);
                                            Ext.getCmp('strFolsteinOrientacionLugarDes').setValue("Diga en que lugar nos encontramos");
                                        }else{
                                            Ext.getCmp('intFolsteinOrientacionLugarPto').setValue(0);
                                            Ext.getCmp('strFolsteinOrientacionLugarDes').setValue("Diga en que lugar nos encontramos");
                                        }
                                        CalculaValoracionFolstein();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intFolsteinOrientacionLugarPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strFolsteinOrientacionLugarDes'
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'MEMORIA',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        labelWidth: 730,
                        id: 'fsMemoria',
                        items: [
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Diga 3 nombres: casa, mesa, arbol . un segundo para cada uno. luego pida al paciente que los repita. un punto por cada una. repitalos hasta que el paciente los registre. anote el numero de ensayos requeridos',
                                name: 'Diga 3 nombres: casa, mesa, arbol . un segundo para cada uno. luego pida al paciente que los repita. un punto por cada una. repitalos hasta que el paciente los registre. anote el numero de ensayos requeridos',
                                labelStyle: 'color: #000000;',
                                id: 'bolFolsteinMemoria',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intFolsteinMemoriaPto').setValue(3);
                                            Ext.getCmp('strFolsteinMemoriaDes').setValue("Diga 3 nombres: casa, mesa, arbol . un segundo para cada uno. luego pida al paciente que los repita. un punto por cada una. repitalos hasta que el paciente los registre. anote el numero de ensayos requeridos");
                                        }else{
                                            Ext.getCmp('intFolsteinMemoriaPto').setValue(0);
                                            Ext.getCmp('strFolsteinMemoriaDes').setValue("Diga 3 nombres: casa, mesa, arbol . un segundo para cada uno. luego pida al paciente que los repita. un punto por cada una. repitalos hasta que el paciente los registre. anote el numero de ensayos requeridos");
                                        }
                                        CalculaValoracionFolstein();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intFolsteinMemoriaPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strFolsteinMemoriaDes'
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'ATENCION Y CALCULO',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        labelWidth: 730,
                        id: 'fsAtencionCalculo',
                        items: [
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Resta de 100-7 en forma sucesiva. pare a la quinta respuesta registr un punto por cada respuesta correcta (93, 86, 79, 72, 65) si tiene 100 pesos y se gasta 7, cuanto le queda?',
                                name: 'Resta de 100-7 en forma sucesiva. pare a la quinta respuesta registr un punto por cada respuesta correcta (93, 86, 79, 72, 65) si tiene 100 pesos y se gasta 7, cuanto le queda?',
                                labelStyle: 'color: #000000;',
                                id: 'bolFolsteinAtencion',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intFolsteinAtencionPto').setValue(5);
                                            Ext.getCmp('strFolsteinAtencionDes').setValue("Resta de 100-7 en forma sucesiva. pare a la quinta respuesta registr un punto por cada respuesta correcta (93, 86, 79, 72, 65) si tiene 100 pesos y se gasta 7, cuanto le queda?");
                                        }else{
                                            Ext.getCmp('intFolsteinAtencionPto').setValue(0);
                                            Ext.getCmp('strFolsteinAtencionDes').setValue("Resta de 100-7 en forma sucesiva. pare a la quinta respuesta registr un punto por cada respuesta correcta (93, 86, 79, 72, 65) si tiene 100 pesos y se gasta 7, cuanto le queda?");
                                        }
                                        CalculaValoracionFolstein();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intFolsteinAtencionPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strFolsteinAtencionDes'
                            },
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Decir los meses del año al reves (diciembre, noviembre, octubre, septiembre, agosto) realizar uno u otro (numeros o meses)',
                                name: 'Decir los meses del año al reves (diciembre, noviembre, octubre, septiembre, agosto) realizar uno u otro (numeros o meses)',
                                labelStyle: 'color: #000000;',
                                id: 'bolFolsteinAtencion1',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intFolsteinAtencion1Pto').setValue(0);
                                            Ext.getCmp('strFolsteinAtencion1Des').setValue("Decir los meses del año al reves (diciembre, noviembre, octubre, septiembre, agosto) realizar uno u otro (numeros o meses)");
                                        }else{
                                            Ext.getCmp('intFolsteinAtencion1Pto').setValue(0);
                                            Ext.getCmp('strFolsteinAtencion1Des').setValue("Decir los meses del año al reves (diciembre, noviembre, octubre, septiembre, agosto) realizar uno u otro (numeros o meses)");
                                        }
                                        CalculaValoracionFolstein();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intFolsteinAtencion1Pto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strFolsteinAtencion1Des'
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'EVOCACION',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        labelWidth: 730,
                        id: 'fsEvocacion',
                        items: [
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Recuerda las tres palabras que le repeti antes. registre el numero de palabras que recuerde',
                                name: 'Recuerda las tres palabras que le repeti antes. registre el numero de palabras que recuerde',
                                labelStyle: 'color: #000000;',
                                id: 'bolFolsteinEvocacion',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intFolsteinEvocacionPto').setValue(3);
                                            Ext.getCmp('strFolsteinEvocacionDes').setValue("Recuerda las tres palabras que le repeti antes. registre el numero de palabras que recuerde");
                                        }else{
                                            Ext.getCmp('intFolsteinEvocacionPto').setValue(0);
                                            Ext.getCmp('strFolsteinEvocacionDes').setValue("Recuerda las tres palabras que le repeti antes. registre el numero de palabras que recuerde");
                                        }
                                        CalculaValoracionFolstein();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intFolsteinEvocacionPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strFolsteinEvocacionDes'
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'LENGUAJE',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        labelWidth: 730,
                        id: 'fsLenguaje',
                        items: [
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Denominar dos objetos (reloj, lapiz)',
                                name: 'Denominar dos objetos (reloj, lapiz)',
                                labelStyle: 'color: #000000;',
                                id: 'bolFolsteinLenguajeDenominarObj',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intFolsteinLenguajeDenominarObjPto').setValue(2);
                                            Ext.getCmp('strFolsteinLenguajeDonominarObjDes').setValue("Denominar dos objetos (reloj, lapiz)");
                                        }else{
                                            Ext.getCmp('intFolsteinLenguajeDenominarObjPto').setValue(0);
                                            Ext.getCmp('strFolsteinLenguajeDonominarObjDes').setValue("Denominar dos objetos (reloj, lapiz)");
                                        }
                                        CalculaValoracionFolstein();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intFolsteinLenguajeDenominarObjPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strFolsteinLenguajeDonominarObjDes'
                            },
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Repetir: en un trigal habia cinco perros',
                                name: 'Repetir: en un trigal habia cinco perros',
                                labelStyle: 'color: #000000;',
                                id: 'bolFolsteinLenguajeRepetir',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intFolsteinLenguajeRepetirPto').setValue(1);
                                            Ext.getCmp('strFolsteinLenguajeRepetirDes').setValue("Repetir: en un trigal habia cinco perros");
                                        }else{
                                            Ext.getCmp('intFolsteinLenguajeRepetirPto').setValue(0);
                                            Ext.getCmp('strFolsteinLenguajeRepetirDes').setValue("Repetir: en un trigal habia cinco perros");
                                        }
                                        CalculaValoracionFolstein();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intFolsteinLenguajeRepetirPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strFolsteinLenguajeRepetirDes'
                            },
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Comprension: obedecer una orde en tres etapas: tome la hoja con su mano derecha, doblela por la mitad y pongala en el suelo',
                                name: 'Comprension: obedecer una orde en tres etapas: tome la hoja con su mano derecha, doblela por la mitad y pongala en el suelo',
                                labelStyle: 'color: #000000;',
                                id: 'bolFolsteinLenguajeComprension',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intFolsteinLenguajeComprensionPto').setValue(3);
                                            Ext.getCmp('strFolsteinLenguajeComprensionDes').setValue("Comprension: obedecer una orde en tres etapas: tome la hoja con su mano derecha, doblela por la mitad y pongala en el suelo");
                                        }else{
                                            Ext.getCmp('intFolsteinLenguajeComprensionPto').setValue(0);
                                            Ext.getCmp('strFolsteinLenguajeComprensionDes').setValue("Comprension: obedecer una orde en tres etapas: tome la hoja con su mano derecha, doblela por la mitad y pongala en el suelo");
                                        }
                                        CalculaValoracionFolstein();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intFolsteinLenguajeComprensionPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strFolsteinLenguajeComprensionDes'
                            },
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Lea y obedezca la siguiente orden: cierre los ojos',
                                name: 'Lea y obedezca la siguiente orden: cierre los ojos',
                                labelStyle: 'color: #000000;',
                                id: 'bolFolsteinLenguajeLea',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intFolsteinLenguajeLeaPto').setValue(1);
                                            Ext.getCmp('strFolsteinLenguajeLeaDes').setValue("Lea y obedezca la siguiente orden: cierre los ojos");
                                        }else{
                                            Ext.getCmp('intFolsteinLenguajeLeaPto').setValue(0);
                                            Ext.getCmp('strFolsteinLenguajeLeaDes').setValue("Lea y obedezca la siguiente orden: cierre los ojos");
                                        }
                                        CalculaValoracionFolstein();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intFolsteinLenguajeLeaPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strFolsteinLenguajeLeaDes'
                            },
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Escriba una frase',
                                name: 'Escriba una frase',
                                labelStyle: 'color: #000000;',
                                id: 'bolFolsteinLenguajeEscriba',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intFolsteinLenguajeEscribaPto').setValue(1);
                                            Ext.getCmp('strFolsteinLenguajeEscribaDes').setValue("Escriba una frase");
                                        }else{
                                            Ext.getCmp('intFolsteinLenguajeEscribaPto').setValue(0);
                                            Ext.getCmp('strFolsteinLenguajeEscribaDes').setValue("Escriba una frase");
                                        }
                                        CalculaValoracionFolstein();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intFolsteinLenguajeEscribaPto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strFolsteinLenguajeEscribaDes'
                            },
                            {
                                xtype: 'checkbox',
                                allowBlank: true,
                                fieldLabel: 'Copie el diseño o dibujo',
                                name: 'Copie el diseño o dibujo',
                                labelStyle: 'color: #000000;',
                                id: 'bolFolsteinLenguajeCopie',
                                listeners:{
                                    change : function(f, newValue, oldValue){
                                        if(newValue == true){
                                            Ext.getCmp('intFolsteinLenguajeCopiePto').setValue(1);
                                            Ext.getCmp('strFolsteinLenguajeCopieDes').setValue("Copie el diseño o dibujo");
                                        }else{
                                            Ext.getCmp('intFolsteinLenguajeCopiePto').setValue(0);
                                            Ext.getCmp('strFolsteinLenguajeCopieDes').setValue("Copie el diseño o dibujo");
                                        }
                                        CalculaValoracionFolstein();
                                    }
                                }
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'intFolsteinLenguajeCopiePto'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '98%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strFolsteinLenguajeCopieDes'
                            }
                        ]
                    },
                    {
                        xtype: 'hidden',
                        fieldLabel: 'Total Folstein',
                        name: 'Total Folstein',
                        width: 100,
                        allowBlank: true,
                        readOnly: true,
                        id: 'intFolsteinTotal'
                    },
                    {
                        xtype: 'textfield',
                        labelStyle: 'color: #000000;',
                        fieldLabel: 'Valoracion',
                        name: 'Valoracion',
                        width: 150,
                        allowBlank: true,
                        readOnly: true,
                        id: 'strFolsteinValoracion'
                    }
                ]
            }
        ];
        winHCTestFolsteinUi.superclass.initComponent.call(this);
    }
});

function CalculaValoracionFolstein(){

    var ValoracionOrientacionAnio = 0;
    var ValoracionOrientacionMes = 0;
    var ValoracionOrientacionDia = 0;
    var ValoracionOrientacionDiaSemana = 0;
    var ValoracionOrientacionHora = 0;
    var ValoracionOrientacionPais = 0;
    var ValoracionOrientacionDepto = 0;
    var ValoracionOrientacionCiudad = 0;
    var ValoracionOrientacionBarrio = 0;
    var ValoracionOrientacionLugar = 0;
    var ValoracionMemoria = 0;
    var ValoracionAtencion = 0;
    var ValoracionEvocacion = 0;
    var ValoracionLenguajeDenominar = 0;
    var ValoracionLenguajeRepetir = 0;
    var ValoracionLenguajeComprension = 0;
    var ValoracionLenguajeLea = 0;
    var ValoracionLenguajeEscriba = 0;
    var ValoracionLenguajeCopie = 0;
    
    if(Ext.getCmp('intFolsteinOrientacionAnioPto').getValue() != null && Ext.getCmp('intFolsteinOrientacionAnioPto').getValue() != ""){
        ValoracionOrientacionAnio = parseInt(Ext.getCmp('intFolsteinOrientacionAnioPto').getValue());
    }else{
        ValoracionOrientacionAnio = 0;
    }
    if(Ext.getCmp('intFolsteinOrientacionMesPto').getValue() != null && Ext.getCmp('intFolsteinOrientacionMesPto').getValue() != ""){
        ValoracionOrientacionMes = parseInt(Ext.getCmp('intFolsteinOrientacionMesPto').getValue());
    }else{
        ValoracionOrientacionMes = 0;
    }
    if(Ext.getCmp('intFolsteinOrientacionDiaPto').getValue() != null && Ext.getCmp('intFolsteinOrientacionDiaPto').getValue() != ""){
        ValoracionOrientacionDia = parseInt(Ext.getCmp('intFolsteinOrientacionDiaPto').getValue());
    }else{
        ValoracionOrientacionDia = 0;
    }
    if(Ext.getCmp('intFolsteinOrientacionDiaSemanaPto').getValue() != null && Ext.getCmp('intFolsteinOrientacionDiaSemanaPto').getValue() != ""){
        ValoracionOrientacionDiaSemana = parseInt(Ext.getCmp('intFolsteinOrientacionDiaSemanaPto').getValue());
    }else{
        ValoracionOrientacionDiaSemana = 0;
    }
    if(Ext.getCmp('intFolsteinOrientacionHoraPto').getValue() != null && Ext.getCmp('intFolsteinOrientacionHoraPto').getValue() != ""){
        ValoracionOrientacionHora = parseInt(Ext.getCmp('intFolsteinOrientacionHoraPto').getValue());
    }else{
        ValoracionOrientacionHora = 0;
    }
    if(Ext.getCmp('intFolsteinOrientacionPaisPto').getValue() != null && Ext.getCmp('intFolsteinOrientacionPaisPto').getValue() != ""){
        ValoracionOrientacionPais = parseInt(Ext.getCmp('intFolsteinOrientacionPaisPto').getValue());
    }else{
        ValoracionOrientacionPais = 0;
    }
    if(Ext.getCmp('intFolsteinOrientacionDeptoPto').getValue() != null && Ext.getCmp('intFolsteinOrientacionDeptoPto').getValue() != ""){
        ValoracionOrientacionDepto = parseInt(Ext.getCmp('intFolsteinOrientacionDeptoPto').getValue());
    }else{
        ValoracionOrientacionDepto = 0;
    }
    if(Ext.getCmp('intFolsteinOrientacionCiudadPto').getValue() != null && Ext.getCmp('intFolsteinOrientacionCiudadPto').getValue() != ""){
        ValoracionOrientacionCiudad = parseInt(Ext.getCmp('intFolsteinOrientacionCiudadPto').getValue());
    }else{
        ValoracionOrientacionCiudad = 0;
    }
    if(Ext.getCmp('intFolsteinOrientacionBarrioPto').getValue() != null && Ext.getCmp('intFolsteinOrientacionBarrioPto').getValue() != ""){
        ValoracionOrientacionBarrio = parseInt(Ext.getCmp('intFolsteinOrientacionBarrioPto').getValue());
    }else{
        ValoracionOrientacionBarrio = 0;
    }
    if(Ext.getCmp('intFolsteinOrientacionLugarPto').getValue() != null && Ext.getCmp('intFolsteinOrientacionLugarPto').getValue() != ""){
        ValoracionOrientacionLugar = parseInt(Ext.getCmp('intFolsteinOrientacionLugarPto').getValue());
    }else{
        ValoracionOrientacionLugar = 0;
    }
    if(Ext.getCmp('intFolsteinMemoriaPto').getValue() != null && Ext.getCmp('intFolsteinMemoriaPto').getValue() != ""){
        ValoracionMemoria = parseInt(Ext.getCmp('intFolsteinMemoriaPto').getValue());
    }else{
        ValoracionMemoria = 0;
    }
    if(Ext.getCmp('intFolsteinAtencionPto').getValue() != null && Ext.getCmp('intFolsteinAtencionPto').getValue() != ""){
        ValoracionAtencion = parseInt(Ext.getCmp('intFolsteinAtencionPto').getValue());
    }else{
        ValoracionAtencion = 0;
    }
    if(Ext.getCmp('intFolsteinEvocacionPto').getValue() != null && Ext.getCmp('intFolsteinEvocacionPto').getValue() != ""){
        ValoracionEvocacion = parseInt(Ext.getCmp('intFolsteinEvocacionPto').getValue());
    }else{
        ValoracionEvocacion = 0;
    }
    if(Ext.getCmp('intFolsteinLenguajeDenominarObjPto').getValue() != null && Ext.getCmp('intFolsteinLenguajeDenominarObjPto').getValue() != ""){
        ValoracionLenguajeDenominar = parseInt(Ext.getCmp('intFolsteinLenguajeDenominarObjPto').getValue());
    }else{
        ValoracionLenguajeDenominar = 0;
    }
    if(Ext.getCmp('intFolsteinLenguajeRepetirPto').getValue() != null && Ext.getCmp('intFolsteinLenguajeRepetirPto').getValue() != ""){
        ValoracionLenguajeRepetir = parseInt(Ext.getCmp('intFolsteinLenguajeRepetirPto').getValue());
    }else{
        ValoracionLenguajeRepetir = 0;
    }
    if(Ext.getCmp('intFolsteinLenguajeComprensionPto').getValue() != null && Ext.getCmp('intFolsteinLenguajeComprensionPto').getValue() != ""){
        ValoracionLenguajeComprension = parseInt(Ext.getCmp('intFolsteinLenguajeComprensionPto').getValue());
    }else{
        ValoracionLenguajeComprension = 0;
    }
    if(Ext.getCmp('intFolsteinLenguajeLeaPto').getValue() != null && Ext.getCmp('intFolsteinLenguajeLeaPto').getValue() != ""){
        ValoracionLenguajeLea = parseInt(Ext.getCmp('intFolsteinLenguajeLeaPto').getValue());
    }else{
        ValoracionLenguajeLea = 0;
    }
    if(Ext.getCmp('intFolsteinLenguajeEscribaPto').getValue() != null && Ext.getCmp('intFolsteinLenguajeEscribaPto').getValue() != ""){
        ValoracionLenguajeEscriba = parseInt(Ext.getCmp('intFolsteinLenguajeEscribaPto').getValue());
    }else{
        ValoracionLenguajeEscriba = 0;
    }
    if(Ext.getCmp('intFolsteinLenguajeCopiePto').getValue() != null && Ext.getCmp('intFolsteinLenguajeCopiePto').getValue() != ""){
        ValoracionLenguajeCopie = parseInt(Ext.getCmp('intFolsteinLenguajeCopiePto').getValue());
    }else{
        ValoracionLenguajeCopie = 0;
    }
    
    ValoracionTotal = ValoracionOrientacionAnio + ValoracionOrientacionMes + ValoracionOrientacionDia + ValoracionOrientacionDiaSemana + ValoracionOrientacionHora + ValoracionOrientacionPais + ValoracionOrientacionDepto + ValoracionOrientacionCiudad + ValoracionOrientacionBarrio + ValoracionOrientacionLugar + ValoracionMemoria + ValoracionAtencion + ValoracionEvocacion + ValoracionLenguajeDenominar + ValoracionLenguajeRepetir + ValoracionLenguajeComprension + ValoracionLenguajeLea + ValoracionLenguajeEscriba + ValoracionLenguajeCopie;

    Ext.getCmp('intFolsteinTotal').setValue(ValoracionTotal);
    Ext.getCmp('strFolsteinValoracion').setValue("Total:  " + ValoracionTotal + " / 30");
}

function fnGuardarRegistrosFolstein(){
    var frm = Ext.getCmp('frmTestFolstein').getForm();
    if (frm.isValid()){
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar_folstein',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pResultadoClasifica: Ext.getCmp('strFolsteinValoracion').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}