/*
* @category    Formulario Test Hachinski
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCTestHachinskiUi = Ext.extend(Ext.FormPanel, {
    frame: true,
    anchor: '100%',
    id: 'frmTestHachinski',
    padding: 10,
    border: false,
    autoScroll: true,
    style: 'background:transparent;',
    initComponent: function() {
        this.tbar = {
            xtype: 'toolbar',
            items: [
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Guardar Test',
                    iconCls: 'btnGuardar',
                    id: 'btnGuardarHachinski',
                    listeners:{
                        click : function(){
                            if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) {
                                fnGuardarRegistrosHachinski();
                            }else{
                                Ext.Msg.show({
                                    title: 'eOfiClinic',
                                    msg: 'Debe Guardar la evolución?',
                                    buttons: Ext.Msg.OK,
                                    icon: Ext.Msg.ERROR
                                });
                            }
                        }
                    }
                }
            ]
        };
        this.items = [
            {
                xtype: 'fieldset',
                title: 'TEST HACHINSKI',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                labelWidth: 170,
                id: 'fsHACHINSKI',
                items: [
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: 'Comienzo agudo',
                        name: 'Comienzo agudo',
                        labelStyle: 'color: #000000;',
                        id: 'bolHachinskiComienzo',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                if(newValue == true){
                                    Ext.getCmp('intHachinskiComienzoPto').setValue(2);
                                    Ext.getCmp('strHachinskiComienzoDes').setValue("Comienzo agudo");
                                }else{
                                    Ext.getCmp('intHachinskiComienzoPto').setValue(0);
                                    Ext.getCmp('strHachinskiComienzoDes').setValue("Comienzo agudo");
                                }
                                CalculaValoracionHachinski();
                            }
                        }
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'intHachinskiComienzoPto'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'strHachinskiComienzoDes'
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: 'Progresion escalonada',
                        name: 'Progresion escalonada',
                        labelStyle: 'color: #000000;',
                        id: 'bolHachinskiDeterioro',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                if(newValue == true){
                                    Ext.getCmp('intHachinskiDeterioroPto').setValue(1);
                                    Ext.getCmp('strHachinskiDeterioroDes').setValue("Progresion escalonada");
                                }else{
                                    Ext.getCmp('intHachinskiDeterioroPto').setValue(0);
                                    Ext.getCmp('strHachinskiDeterioroDes').setValue("Progresion escalonada");
                                }
                                CalculaValoracionHachinski();
                            }
                        }
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'intHachinskiDeterioroPto'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'strHachinskiDeterioroDes'
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: 'Curso fluctuante',
                        name: 'Curso fluctuante',
                        labelStyle: 'color: #000000;',
                        id: 'bolHachinskiCursoF',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                if(newValue == true){
                                    Ext.getCmp('intHachinskiCursoFPto').setValue(1);
                                    Ext.getCmp('strHachinskiCursoFDes').setValue("Curso fluctuante");
                                }else{
                                    Ext.getCmp('intHachinskiCursoFPto').setValue(0);
                                    Ext.getCmp('strHachinskiCursoFDes').setValue("Curso fluctuante");
                                }
                                CalculaValoracionHachinski();
                            }
                        }
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'intHachinskiCursoFPto'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'strHachinskiCursoFDes'
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: 'Confusión nocturna',
                        name: 'Confusión nocturna',
                        labelStyle: 'color: #000000;',
                        id: 'bolHachinskiConfusionNoc',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                if(newValue == true){
                                    Ext.getCmp('intHachinskiConfusionNocPto').setValue(1);
                                    Ext.getCmp('strHachinskiConfusionNocDes').setValue("Confusión nocturna");
                                }else{
                                    Ext.getCmp('intHachinskiConfusionNocPto').setValue(0);
                                    Ext.getCmp('strHachinskiConfusionNocDes').setValue("Confusión nocturna");
                                }
                                CalculaValoracionHachinski();
                            }
                        }
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'intHachinskiConfusionNocPto'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'strHachinskiConfusionNocDes'
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: 'Preservación de la personalidad',
                        name: 'Preservación de la personalidad',
                        labelStyle: 'color: #000000;',
                        id: 'bolHachinskiCoservaPer',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                if(newValue == true){
                                    Ext.getCmp('intHachinskiCoservaPerPto').setValue(1);
                                    Ext.getCmp('strHachinskiCoservaPercDes').setValue("Preservación de la personalidad");
                                }else{
                                    Ext.getCmp('intHachinskiCoservaPerPto').setValue(0);
                                    Ext.getCmp('strHachinskiCoservaPercDes').setValue("Preservación de la personalidad");
                                }
                                CalculaValoracionHachinski();
                            }
                        }
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'intHachinskiCoservaPerPto'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'strHachinskiCoservaPercDes'
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: 'Depresión',
                        name: 'Depresión',
                        labelStyle: 'color: #000000;',
                        id: 'bolHachinskiDepresion',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                if(newValue == true){
                                    Ext.getCmp('intHachinskiDepresionPto').setValue(1);
                                    Ext.getCmp('strHachinskiDepresionDes').setValue("Depresión");
                                }else{
                                    Ext.getCmp('intHachinskiDepresionPto').setValue(0);
                                    Ext.getCmp('strHachinskiDepresionDes').setValue("Depresión");
                                }
                                CalculaValoracionHachinski();
                            }
                        }
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'intHachinskiDepresionPto'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'strHachinskiDepresionDes'
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: 'Quejas somáticas',
                        name: 'Quejas somáticas',
                        labelStyle: 'color: #000000;',
                        id: 'bolHachinskiSinomasSoma',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                if(newValue == true){
                                    Ext.getCmp('intHachinskiSinomasSomaPto').setValue(1);
                                    Ext.getCmp('strHachinskiSinomasSomaDes').setValue("Quejas somáticas");
                                }else{
                                    Ext.getCmp('intHachinskiSinomasSomaPto').setValue(0);
                                    Ext.getCmp('strHachinskiSinomasSomaDes').setValue("Quejas somáticas");
                                }
                                CalculaValoracionHachinski();
                            }
                        }
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'intHachinskiSinomasSomaPto'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'strHachinskiSinomasSomaDes'
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: 'Incontinencia emocional',
                        name: 'Incontinencia emocional',
                        labelStyle: 'color: #000000;',
                        id: 'bolHachinskiLabilidadEmo',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                if(newValue == true){
                                    Ext.getCmp('intHachinskiLabilidadEmoPto').setValue(1);
                                    Ext.getCmp('strHachinskiLabilidadEmoDes').setValue("Incontinencia emocional");
                                }else{
                                    Ext.getCmp('intHachinskiLabilidadEmoPto').setValue(0);
                                    Ext.getCmp('strHachinskiLabilidadEmoDes').setValue("Incontinencia emocional");
                                }
                                CalculaValoracionHachinski();
                            }
                        }
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'intHachinskiLabilidadEmoPto'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'strHachinskiLabilidadEmoDes'
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: 'Antecedentes de hipertensión arterial sistémica',
                        name: 'Antecedentes de hipertensión arterial sistémica',
                        labelStyle: 'color: #000000;',
                        id: 'bolHachinskiHTAS',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                if(newValue == true){
                                    Ext.getCmp('intHachinskiHTASPto').setValue(1);
                                    Ext.getCmp('strHachinskiHTASDes').setValue("Antecedentes de hipertensión arterial sistémica");
                                }else{
                                    Ext.getCmp('intHachinskiHTASPto').setValue(0);
                                    Ext.getCmp('strHachinskiHTASDes').setValue("Antecedentes de hipertensión arterial sistémica");
                                }
                                CalculaValoracionHachinski();
                            }
                        }
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'intHachinskiHTASPto'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'strHachinskiHTASDes'
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: 'Antecedentes de ECV',
                        name: 'Antecedentes de ECV',
                        labelStyle: 'color: #000000;',
                        id: 'bolHachinskiIctus',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                if(newValue == true){
                                    Ext.getCmp('intHachinskiIctusPto').setValue(2);
                                    Ext.getCmp('strHachinskiIctusDes').setValue("Antecedentes de ECV");
                                }else{
                                    Ext.getCmp('intHachinskiIctusPto').setValue(0);
                                    Ext.getCmp('strHachinskiIctusDes').setValue("Antecedentes de ECV");
                                }
                                CalculaValoracionHachinski();
                            }
                        }
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'intHachinskiIctusPto'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'strHachinskiIctusDes'
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: 'Evidencia de arteroesclerosis',
                        name: 'Evidencia de arteroesclerosis',
                        labelStyle: 'color: #000000;',
                        id: 'bolHachinskiSignoArtereoescle',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                if(newValue == true){
                                    Ext.getCmp('intHachinskiSignoArtereoesclePto').setValue(1);
                                    Ext.getCmp('strHachinskiSignoArtereoescleDes').setValue("Evidencia de arteroesclerosis");
                                }else{
                                    Ext.getCmp('intHachinskiSignoArtereoesclePto').setValue(0);
                                    Ext.getCmp('strHachinskiSignoArtereoescleDes').setValue("Evidencia de arteroesclerosis");
                                }
                                CalculaValoracionHachinski();
                            }
                        }
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'intHachinskiSignoArtereoesclePto'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'strHachinskiSignoArtereoescleDes'
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: 'Signos neurológicos focales',
                        name: 'Signos neurológicos focales',
                        labelStyle: 'color: #000000;',
                        id: 'bolHachinskiSignoNeuroFocal',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                if(newValue == true){
                                    Ext.getCmp('intHachinskiSignoNeuroFocalPto').setValue(2);
                                    Ext.getCmp('strHachinskiSignoNeuroFocalDes').setValue("Signos neurológicos focales");
                                }else{
                                    Ext.getCmp('intHachinskiSignoNeuroFocalPto').setValue(0);
                                    Ext.getCmp('strHachinskiSignoNeuroFocalDes').setValue("Signos neurológicos focales");
                                }
                                CalculaValoracionHachinski();
                            }
                        }
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'intHachinskiSignoNeuroFocalPto'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'strHachinskiSignoNeuroFocalDes'
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: 'Sintomas neurológicos focales',
                        name: 'Sintomas neurológicos focales',
                        labelStyle: 'color: #000000;',
                        id: 'bolHachinskiSintomaNeuroFocal',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                if(newValue == true){
                                    Ext.getCmp('intHachinskiSintomaNeuroFocalPto').setValue(2);
                                    Ext.getCmp('strHachinskiSintomaNeuroFocalDes').setValue("Sintomas neurológicos focales");
                                }else{
                                    Ext.getCmp('intHachinskiSintomaNeuroFocalPto').setValue(0);
                                    Ext.getCmp('strHachinskiSintomaNeuroFocalDes').setValue("Sintomas neurológicos focales");
                                }
                                CalculaValoracionHachinski();
                            }
                        }
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'intHachinskiSintomaNeuroFocalPto'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '98%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'strHachinskiSintomaNeuroFocalDes'
                    },
                    {
                        html: '<br>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        labelStyle: 'color: #000000;',
                        fieldLabel: 'Clasificación',
                        items: [
                            {
                                xtype: 'numberfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                id: 'intHachinskiTotal'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysvCalsifica',
                                value: ' - '
                            },
                            {
                                xtype: 'textfield',
                                width: 350,
                                allowBlank: true,
                                readOnly: true,
                                id: 'strHachinskiValoracion'
                            }
                        ]
                    }
                ]
            }
        ];
        winHCTestHachinskiUi.superclass.initComponent.call(this);
    }
});

function CalculaValoracionHachinski(){

    var ValoracionComienzo = 0;
    var ValoracionDeterioro = 0;
    var ValoracionCursoF = 0;
    var ValoracionConfusionNoc = 0;
    var ValoracionCoservaPer = 0;
    var ValoracionDepresion = 0;
    var ValoracionSinomasSoma = 0;
    var ValoracionLabilidadEmo = 0;
    var ValoracionHTAS = 0;
    var ValoracionIctus = 0;
    var ValoracionSignoArtereoescle = 0;
    var ValoracionSignoNeuroFocal = 0;
    var ValoracionSintomaNeuroFocal = 0;
    var ValoracionTotal = 0 ;

    if(Ext.getCmp('intHachinskiComienzoPto').getValue() != null && Ext.getCmp('intHachinskiComienzoPto').getValue() != ""){
        ValoracionComienzo = parseInt(Ext.getCmp('intHachinskiComienzoPto').getValue());
    }else{
        ValoracionComienzo = 0;
    }

    if(Ext.getCmp('intHachinskiDeterioroPto').getValue() != null && Ext.getCmp('intHachinskiDeterioroPto').getValue() != ""){
        ValoracionDeterioro = parseInt(Ext.getCmp('intHachinskiDeterioroPto').getValue());
    }else{
        ValoracionDeterioro = 0;
    }

    if(Ext.getCmp('intHachinskiCursoFPto').getValue() != null && Ext.getCmp('intHachinskiCursoFPto').getValue() != ""){
        ValoracionCursoF = parseInt(Ext.getCmp('intHachinskiCursoFPto').getValue());
    }else{
        ValoracionCursoF = 0;
    }

    if(Ext.getCmp('intHachinskiConfusionNocPto').getValue() != null && Ext.getCmp('intHachinskiConfusionNocPto').getValue() != ""){
        ValoracionConfusionNoc = parseInt(Ext.getCmp('intHachinskiConfusionNocPto').getValue());
    }else{
        ValoracionConfusionNoc = 0;
    }

    if(Ext.getCmp('intHachinskiCoservaPerPto').getValue() != null && Ext.getCmp('intHachinskiCoservaPerPto').getValue() != ""){
        ValoracionCoservaPer = parseInt(Ext.getCmp('intHachinskiCoservaPerPto').getValue());
    }else{
        ValoracionCoservaPer = 0;
    }

    if(Ext.getCmp('intHachinskiDepresionPto').getValue() != null && Ext.getCmp('intHachinskiDepresionPto').getValue() != ""){
        ValoracionDepresion = parseInt(Ext.getCmp('intHachinskiDepresionPto').getValue());
    }else{
        ValoracionDepresion = 0;
    }

    if(Ext.getCmp('intHachinskiSinomasSomaPto').getValue() != null && Ext.getCmp('intHachinskiSinomasSomaPto').getValue() != ""){
        ValoracionSinomasSoma = parseInt(Ext.getCmp('intHachinskiSinomasSomaPto').getValue());
    }else{
        ValoracionSinomasSoma = 0;
    }

    if(Ext.getCmp('intHachinskiLabilidadEmoPto').getValue() != null && Ext.getCmp('intHachinskiLabilidadEmoPto').getValue() != ""){
        ValoracionLabilidadEmo = parseInt(Ext.getCmp('intHachinskiLabilidadEmoPto').getValue());
    }else{
        ValoracionLabilidadEmo = 0;
    }

    if(Ext.getCmp('intHachinskiHTASPto').getValue() != null && Ext.getCmp('intHachinskiHTASPto').getValue() != ""){
        ValoracionHTAS = parseInt(Ext.getCmp('intHachinskiHTASPto').getValue());
    }else{
        ValoracionHTAS = 0;
    }

    if(Ext.getCmp('intHachinskiIctusPto').getValue() != null && Ext.getCmp('intHachinskiIctusPto').getValue() != ""){
        ValoracionIctus = parseInt(Ext.getCmp('intHachinskiIctusPto').getValue());
    }else{
        ValoracionIctus = 0;
    }

    if(Ext.getCmp('intHachinskiSignoArtereoesclePto').getValue() != null && Ext.getCmp('intHachinskiSignoArtereoesclePto').getValue() != ""){
        ValoracionSignoArtereoescle = parseInt(Ext.getCmp('intHachinskiSignoArtereoesclePto').getValue());
    }else{
        ValoracionSignoArtereoescle = 0;
    }

    if(Ext.getCmp('intHachinskiSignoNeuroFocalPto').getValue() != null && Ext.getCmp('intHachinskiSignoNeuroFocalPto').getValue() != ""){
        ValoracionSignoNeuroFocal = parseInt(Ext.getCmp('intHachinskiSignoNeuroFocalPto').getValue());
    }else{
        ValoracionSignoNeuroFocal = 0;
    }

    if(Ext.getCmp('intHachinskiSintomaNeuroFocalPto').getValue() != null && Ext.getCmp('intHachinskiSignoNeuroFocalPto').getValue() != ""){
        ValoracionSintomaNeuroFocal = parseInt(Ext.getCmp('intHachinskiSintomaNeuroFocalPto').getValue());
    }else{
        ValoracionSintomaNeuroFocal = 0;
    }

    ValoracionTotal = ValoracionComienzo + ValoracionDeterioro + ValoracionCursoF + ValoracionConfusionNoc + ValoracionCoservaPer + ValoracionDepresion + ValoracionSinomasSoma + ValoracionLabilidadEmo + ValoracionHTAS + ValoracionIctus + ValoracionSignoArtereoescle + ValoracionSignoNeuroFocal + ValoracionSintomaNeuroFocal;
    Ext.getCmp('intHachinskiTotal').setValue(ValoracionTotal);
    if(ValoracionTotal < 4){
        Ext.getCmp('strHachinskiValoracion').setValue("Trastorno Degenerativo");
    }else{
        if(ValoracionTotal < 8){
            Ext.getCmp('strHachinskiValoracion').setValue("Casos Dudosos y Demencias Mixtas");
        }else{
            Ext.getCmp('strHachinskiValoracion').setValue("Demencias Vascular");
        }
    }
}

function fnGuardarRegistrosHachinski(){
    var frm = Ext.getCmp('frmTestHachinski').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar_hachinski',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pResultadoClasifica: Ext.getCmp('intHachinskiTotal').getValue() + " - " + Ext.getCmp('strHachinskiValoracion').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}