/*
* @category    Formulario Test Yesavage
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCTestYesavageUi = Ext.extend(Ext.FormPanel, {
    frame: true,
    anchor: '100%',
    id: 'frmTestYesavage',
    padding: 10,
    border: false,
    autoScroll: true,
    style: 'background:transparent;',
    initComponent: function() {
        this.tbar = {
            xtype: 'toolbar',
            items: [
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Guardar Test',
                    iconCls: 'btnGuardar',
                    id: 'btnGuardarYesavage',
                    listeners:{
                        click : function(){
                            if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) {
                                fnGuardarRegistrosYesavage();
                            }else{
                                Ext.Msg.show({
                                    title: 'eOfiClinic',
                                    msg: 'Debe Guardar la evolución?',
                                    buttons: Ext.Msg.OK,
                                    icon: Ext.Msg.ERROR
                                });
                            }
                        }
                    }
                }
            ]
        };
        this.items = [
            {
                xtype: 'fieldset',
                title: 'TEST YESAVAGE',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                labelWidth: 450,
                id: 'fsYESAVAGE',
                items: [
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: '¿Está básicamente satisfecho con su vida?',
                        name: '¿Está básicamente satisfecho con su vida?',
                        labelStyle: 'color: #000000;',
                        id: 'bolYesavage1',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                CalculaValoracionYesavage();
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: '¿Ha renunciado a muchas de sus actividades e intereses?',
                        name: '¿Ha renunciado a muchas de sus actividades e intereses?',
                        labelStyle: 'color: #000000;',
                        id: 'bolYesavage2',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                CalculaValoracionYesavage();
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: '¿Siente que su vida está vacía?',
                        name: '¿Siente que su vida está vacía?',
                        labelStyle: 'color: #000000;',
                        id: 'bolYesavage3',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                CalculaValoracionYesavage();
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: '¿Se encuentra a menudo aburrido?',
                        name: '¿Se encuentra a menudo aburrido?',
                        labelStyle: 'color: #000000;',
                        id: 'bolYesavage4',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                CalculaValoracionYesavage();
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: '¿Tiene esperanza en el futuro?',
                        name: '¿Tiene esperanza en el futuro?',
                        labelStyle: 'color: #000000;',
                        id: 'bolYesavage5',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                CalculaValoracionYesavage();
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: '¿Sufre molestias por pensamientos que  pueda sacarse de la cabeza?',
                        name: '¿Sufre molestias por pensamientos que  pueda sacarse de la cabeza?',
                        labelStyle: 'color: #000000;',
                        id: 'bolYesavage6',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                CalculaValoracionYesavage();
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: '¿Tiene a menudo buen ánimo?',
                        name: '¿Tiene a menudo buen ánimo?',
                        labelStyle: 'color: #000000;',
                        id: 'bolYesavage7',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                CalculaValoracionYesavage();
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: '¿Tiene miedo de que algo le esté pasando?',
                        name: '¿Tiene miedo de que algo le esté pasando?',
                        labelStyle: 'color: #000000;',
                        id: 'bolYesavage8',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                CalculaValoracionYesavage();
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: '¿Se ente feliz muchas veces?',
                        name: '¿Se ente feliz muchas veces?',
                        labelStyle: 'color: #000000;',
                        id: 'bolYesavage9',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                CalculaValoracionYesavage();
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: '¿Se ente a menudo abandonado?',
                        name: '¿Se ente a menudo abandonado?',
                        labelStyle: 'color: #000000;',
                        id: 'bolYesavage10',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                CalculaValoracionYesavage();
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: '¿Está a menudo intranquilo e inquieto?',
                        name: '¿Está a menudo intranquilo e inquieto?',
                        labelStyle: 'color: #000000;',
                        id: 'bolYesavage11',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                CalculaValoracionYesavage();
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: '¿Prefiere quedarse en casa que acaso salir y hacer cosas nuevas?',
                        name: '¿Prefiere quedarse en casa que acaso salir y hacer cosas nuevas?',
                        labelStyle: 'color: #000000;',
                        id: 'bolYesavage12',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                CalculaValoracionYesavage();
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: '¿Frecuentemente está preocupado por el futuro?',
                        name: '¿Frecuentemente está preocupado por el futuro?',
                        labelStyle: 'color: #000000;',
                        id: 'bolYesavage13',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                CalculaValoracionYesavage();
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: '¿Encuentra que tiene más problemas de memoria que la mayoría de la gente?',
                        name: '¿Encuentra que tiene más problemas de memoria que la mayoría de la gente?',
                        labelStyle: 'color: #000000;',
                        id: 'bolYesavage14',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                CalculaValoracionYesavage();
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: '¿Piensa que es maravilloso vivir?',
                        name: '¿Piensa que es maravilloso vivir?',
                        labelStyle: 'color: #000000;',
                        id: 'bolYesavage15',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                CalculaValoracionYesavage();
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: '¿Se ente a menudo desanimado y melancólico?',
                        name: '¿Se ente a menudo desanimado y melancólico?',
                        labelStyle: 'color: #000000;',
                        id: 'bolYesavage16',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                CalculaValoracionYesavage();
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: '¿Se ente bastante inútil en el medio en que está?',
                        name: '¿Se ente bastante inútil en el medio en que está?',
                        labelStyle: 'color: #000000;',
                        id: 'bolYesavage17',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                CalculaValoracionYesavage();
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: '¿Está muy preocupado por el pasado?',
                        name: '¿Está muy preocupado por el pasado?',
                        labelStyle: 'color: #000000;',
                        id: 'bolYesavage18',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                CalculaValoracionYesavage();
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: '¿Encuentra la vida muy estimulante?',
                        name: '¿Encuentra la vida muy estimulante?',
                        labelStyle: 'color: #000000;',
                        id: 'bolYesavage19',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                CalculaValoracionYesavage();
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: '¿Es difícil para usted poner en marcha nuevos proyectos?',
                        name: '¿Es difícil para usted poner en marcha nuevos proyectos?',
                        labelStyle: 'color: #000000;',
                        id: 'bolYesavage20',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                CalculaValoracionYesavage();
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: '¿Se ente lleno de energía?',
                        name: '¿Se ente lleno de energía?',
                        labelStyle: 'color: #000000;',
                        id: 'bolYesavage21',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                CalculaValoracionYesavage();
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: '¿Siente que su tuación es desesperada?',
                        name: '¿Siente que su tuación es desesperada?',
                        labelStyle: 'color: #000000;',
                        id: 'bolYesavage22',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                CalculaValoracionYesavage();
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: '¿Cree que mucha gente está mejor que usted?',
                        name: '¿Cree que mucha gente está mejor que usted?',
                        labelStyle: 'color: #000000;',
                        id: 'bolYesavage23',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                CalculaValoracionYesavage();
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: '¿Frecuentemente está preocupado por pequeñas cosas?',
                        name: '¿Frecuentemente está preocupado por pequeñas cosas?',
                        labelStyle: 'color: #000000;',
                        id: 'bolYesavage24',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                CalculaValoracionYesavage();
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: '¿Frecuentemente ente ganas de llorar?',
                        name: '¿Frecuentemente ente ganas de llorar?',
                        labelStyle: 'color: #000000;',
                        id: 'bolYesavage25',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                CalculaValoracionYesavage();
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: '¿Tiene problemas para concentrarse?',
                        name: '¿Tiene problemas para concentrarse?',
                        labelStyle: 'color: #000000;',
                        id: 'bolYesavage26',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                CalculaValoracionYesavage();
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: '¿Se ente mejor por la mañana al levantarse?',
                        name: '¿Se ente mejor por la mañana al levantarse?',
                        labelStyle: 'color: #000000;',
                        id: 'bolYesavage27',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                CalculaValoracionYesavage();
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: '¿Prefiere evitar reuniones sociales?',
                        name: '¿Prefiere evitar reuniones sociales?',
                        labelStyle: 'color: #000000;',
                        id: 'bolYesavage28',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                CalculaValoracionYesavage();
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: '¿Es fácil para usted tomar decisiones?',
                        name: '¿Es fácil para usted tomar decisiones?',
                        labelStyle: 'color: #000000;',
                        id: 'bolYesavage29',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                CalculaValoracionYesavage();
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        allowBlank: true,
                        fieldLabel: '¿Su mente está tan clara como lo acostumbraba a estar?',
                        name: '¿Su mente está tan clara como lo acostumbraba a estar?',
                        labelStyle: 'color: #000000;',
                        id: 'bolYesavage30',
                        listeners:{
                            change : function(f, newValue, oldValue){
                                CalculaValoracionYesavage();
                            }
                        }
                    }
                ]
            },
            {
                xtype: 'compositefield',
                style: 'background:transparent;',
                labelStyle: 'color: #000000;',
                fieldLabel: 'Clasificación',
                items: [
                    {
                        xtype: 'numberfield',
                        width: 100,
                        allowBlank: true,
                        readOnly: true,
                        id: 'intYesavageTotal'
                    },
                    {
                        xtype: 'displayfield',
                        id: 'sysvCalsificaye',
                        value: ' - '
                    },
                    {
                        xtype: 'textfield',
                        width: 350,
                        allowBlank: true,
                        readOnly: true,
                        id: 'strYesavageValoracion'
                    }
                ]
            }
        ];
        winHCTestYesavageUi.superclass.initComponent.call(this);
    }
});

function CalculaValoracionYesavage(){
    var ValoracionYesavage = 0;
    if(Ext.getCmp('bolYesavage1').getValue() == false){
        ValoracionYesavage = ValoracionYesavage + 1;
    }
    if(Ext.getCmp('bolYesavage2').getValue() == true){
        ValoracionYesavage = ValoracionYesavage + 1;
    }
    if(Ext.getCmp('bolYesavage3').getValue() == true){
        ValoracionYesavage = ValoracionYesavage + 1;
    }
    if(Ext.getCmp('bolYesavage4').getValue() == true){
        ValoracionYesavage = ValoracionYesavage + 1;
    }
    if(Ext.getCmp('bolYesavage5').getValue() == false){
        ValoracionYesavage = ValoracionYesavage + 1;
    }
    if(Ext.getCmp('bolYesavage6').getValue() == true){
        ValoracionYesavage = ValoracionYesavage + 1;
    }
    if(Ext.getCmp('bolYesavage7').getValue() == false){
        ValoracionYesavage = ValoracionYesavage + 1;
    }
    if(Ext.getCmp('bolYesavage8').getValue() == true){
        ValoracionYesavage = ValoracionYesavage + 1;
    }
    if(Ext.getCmp('bolYesavage9').getValue() == false){
        ValoracionYesavage = ValoracionYesavage + 1;
    }
    if(Ext.getCmp('bolYesavage10').getValue() == true){
        ValoracionYesavage = ValoracionYesavage + 1;
    }
    if(Ext.getCmp('bolYesavage11').getValue() == true){
        ValoracionYesavage = ValoracionYesavage + 1;
    }
    if(Ext.getCmp('bolYesavage12').getValue() == true){
        ValoracionYesavage = ValoracionYesavage + 1;
    }
    if(Ext.getCmp('bolYesavage13').getValue() == true){
        ValoracionYesavage = ValoracionYesavage + 1;
    }
    if(Ext.getCmp('bolYesavage14').getValue() == true){
        ValoracionYesavage = ValoracionYesavage + 1;
    }
    if(Ext.getCmp('bolYesavage15').getValue() == false){
        ValoracionYesavage = ValoracionYesavage + 1;
    }
    if(Ext.getCmp('bolYesavage16').getValue() == true){
        ValoracionYesavage = ValoracionYesavage + 1;
    }
    if(Ext.getCmp('bolYesavage17').getValue() == true){
        ValoracionYesavage = ValoracionYesavage + 1;
    }
    if(Ext.getCmp('bolYesavage18').getValue() == true){
        ValoracionYesavage = ValoracionYesavage + 1;
    }
    if(Ext.getCmp('bolYesavage19').getValue() == false){
        ValoracionYesavage = ValoracionYesavage + 1;
    }
    if(Ext.getCmp('bolYesavage20').getValue() == true){
        ValoracionYesavage = ValoracionYesavage + 1;
    }
    if(Ext.getCmp('bolYesavage21').getValue() == false){
        ValoracionYesavage = ValoracionYesavage + 1;
    }
    if(Ext.getCmp('bolYesavage22').getValue() == true){
        ValoracionYesavage = ValoracionYesavage + 1;
    }
    if(Ext.getCmp('bolYesavage23').getValue() == true){
        ValoracionYesavage = ValoracionYesavage + 1;
    }
    if(Ext.getCmp('bolYesavage24').getValue() == true){
        ValoracionYesavage = ValoracionYesavage + 1;
    }
    if(Ext.getCmp('bolYesavage25').getValue() == true){
        ValoracionYesavage = ValoracionYesavage + 1;
    }
    if(Ext.getCmp('bolYesavage26').getValue() == true){
        ValoracionYesavage = ValoracionYesavage + 1;
    }
    if(Ext.getCmp('bolYesavage27').getValue() == false){
        ValoracionYesavage = ValoracionYesavage + 1;
    }
    if(Ext.getCmp('bolYesavage28').getValue() == true){
        ValoracionYesavage = ValoracionYesavage + 1;
    }
    if(Ext.getCmp('bolYesavage29').getValue() == false){
        ValoracionYesavage = ValoracionYesavage + 1;
    }
    if(Ext.getCmp('bolYesavage30').getValue() == false){
        ValoracionYesavage = ValoracionYesavage + 1;
    }
    Ext.getCmp('intYesavageTotal').setValue(ValoracionYesavage);
    if(ValoracionYesavage < 10){
        Ext.getCmp('strYesavageValoracion').setValue("0-10: Normal");
    }else{
        if(ValoracionYesavage < 15){
            Ext.getCmp('strYesavageValoracion').setValue("11-14: Depresion (sensibilidad 84%, especificidad 95%)");
        }else{
            Ext.getCmp('strYesavageValoracion').setValue(">14: Depresion (sensibilidad 80%, especificidad 100%)");
        }
    }

}

function fnGuardarRegistrosYesavage(){
    var frm = Ext.getCmp('frmTestYesavage').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar_yesavage',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pResultadoClasifica: Ext.getCmp('intYesavageTotal').getValue() + " - " + Ext.getCmp('strYesavageValoracion').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}