/*
* @category    Formulario Adicionar Solicitud Examenes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winEgresoHogarPaso001Ui = Ext.extend(Ext.Window, {
    title: '.:: Registro de Egreso ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winEgresoHogarPaso001Ui',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddEgresoHogar',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 80,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'intIdEgresoIngresoHogarPaso',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuarioEgresoHogarPaso',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        fieldLabel: 'Fecha Egreso',
                                        width: 120,
                                        allowBlank: true,
                                        disabledDates: '',
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecfechaEgresoHogarPaso'
                                    },
                                    {
                                        html: 'Hora: '
                                    },
                                    {
                                        xtype: 'timefield',
                                        width: 90,
                                        allowBlank: false,
                                        forceSelection: false,
                                        minValue: '06:00 AM',
                                        maxValue: '09:00 PM',
                                        emptyText: 'p.e. 07:00',
                                        id: 'strHoraEgresoHogarPaso'
                                    }
                                ]
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                allowBlank: true,
                                fieldLabel: 'Observaciones',
                                id: 'strObservacionesEgresoHogarPaso'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                allowBlank: true,
                                fieldLabel: 'Alerta',
                                id: 'strAlertaEgresoHogarPaso'
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            listeners:{
                                click : function(){
                                    Ext.Msg.show({
                                        title: 'Egreso',
                                        msg: 'Esta seguro que desea registrar el egreso del paciente, si hace esto automaticamente todos los acompañantes quedaran registrados como egresados?',
                                        buttons: Ext.Msg.YESNO,
                                        icon: Ext.Msg.QUESTION,
                                        fn: function(btn){
                                            if(btn=="yes"){
                                                fnGuardarRegEgresoHogarPaso("GUARDAR_EGRESO","SI","winEgresoHogarPaso001Ui","frmAddEgresoHogar","../../controlador/asistencial/hogardepaso.php","gridFormulario");
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winEgresoHogarPaso001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegEgresoHogarPaso(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid()){
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.reload();
                            }
                        }
                        if(pCerrar == "SI")
                        {
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Egreso',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Egreso',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Egreso',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
