/*
* @category    Formulario Egreso Acompañantes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winEgresoAcoHogarPaso002Ui = Ext.extend(Ext.Window, {
    title: '.:: Registro de Egreso Acompañante ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winEgresoHogarPaso002Ui',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddEgresoAcoHogar',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 80,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'intIdEgresoAcoHogarPaso',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuarioEgresoAcoHogarPaso',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        fieldLabel: 'Fecha EgresoAco',
                                        width: 120,
                                        allowBlank: true,
                                        disabledDates: '',
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecfechaEgresoAcoHogarPaso'
                                    },
                                    {
                                        html: 'Hora: '
                                    },
                                    {
                                        xtype: 'timefield',
                                        width: 90,
                                        allowBlank: false,
                                        forceSelection: false,
                                        minValue: '06:00 AM',
                                        maxValue: '09:00 PM',
                                        emptyText: 'p.e. 07:00',
                                        id: 'strHoraEgresoAcoHogarPaso'
                                    }
                                ]
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                allowBlank: true,
                                fieldLabel: 'Observaciones',
                                id: 'strObservacionesEgresoAcoHogarPaso'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                allowBlank: true,
                                fieldLabel: 'Alerta',
                                id: 'strAlertaEgresoAcoHogarPaso'
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            listeners:{
                                click : function(){
                                    Ext.Msg.show({
                                        title: 'Egreso Acompañante',
                                        msg: 'Esta seguro que desea registrar el egreso del acompañante?',
                                        buttons: Ext.Msg.YESNO,
                                        icon: Ext.Msg.QUESTION,
                                        fn: function(btn){
                                            if(btn=="yes"){
                                                fnGuardarRegEgresoAcoHogarPaso("GUARDAR_EGRESO_ACO","SI","winEgresoHogarPaso002Ui","frmAddEgresoAcoHogar","../../controlador/asistencial/hogardepaso.php","gridFormularioAcompanantes");
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winEgresoAcoHogarPaso002Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegEgresoAcoHogarPaso(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid()){
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Egreso Acompañante',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.reload();
                            }
                        }
                        if(pCerrar == "SI")
                        {
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Egreso Acompañante',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Egreso Acompañante',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Egreso Acompañante',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
