/*
* @category    Formulario Pacientes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winPacientesUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic .:: Pacientes ::.',
    width: 1014,
    height: 646,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winPacientesUi',
    initComponent: function() {
        Ext.BLANK_IMAGE_URL = '../../../lib/extjs/resources/images/default/s.gif';
        el = Ext.get('idxac');
        ID_CONSULTORIOV = el.getValue();
        
        var stGridHistorialLaboral = new StoreGridHistorialLaboral();
        stGridHistorialLaboral.load({
            params: {
                pPaciente: 0
            }
        });
        wPaciente = 0;
        wCAS = 0;
        
        var showHuella = new Ext.Panel({ 
            autoLoad:{
                url:'../../../app/controlador/pacientes/showhuella.php?pPaciente=0',
                scripts:true,
                scope:this
            },
            id:'showHuella',
            //title: 'Verificacion del Paciente',
            //height: 310,
            autoHeight: true,
            autoScroll:true
        });
        
        var picFoto = {
            id: 'picFoto',
            columnWidth: .5,
            bodyStyle: 'padding:0px 0px 0px 40px',
            items: [
                {
                    xtype: 'box',
                    border: true,
                    autoEl: { tag: 'div', style: 'padding-bottom:20px',
                        html: '<img id="picFoto" src="' + Ext.BLANK_IMAGE_URL + '"/>'
                    }
                }
            ]
        };

        var picHuella = {
            id: 'picHuella',
            columnWidth: .5,
            bodyStyle: 'padding:0px 0px 0px 40px',
            items: [
                {
                    xtype: 'box',
                    border: true,
                    autoEl: { tag: 'div', style: 'padding-bottom:20px',
                        html: '<img id="picHuella" src="' + Ext.BLANK_IMAGE_URL + '"/>'
                    }
                }
            ]
        };
        
        function DescripcionGrid(val, x, store){
            mostrarHC = '<table><tr><td style="padding: 1px;">';
            mostrarHC += val;
            mostrarHC += '</td></tr></table>';
            return mostrarHC;
        }

        function DescripcionProfesional(val, x, store){
            if(store.data.ConceptoMedicoOcupacional === "" || store.data.ConceptoMedicoOcupacional === null){
                return "";
            }else{
                return val;
            }
        }

        var aPanelPublicidad = new Ext.Panel({
            autoLoad:{url:'../publicidad/frminferior/frmpublicidadinf.php',scripts:true,scope:this},
            id: 'Publicidad',
            title: '',
            border: false,
            autoScroll: false,
            closable: true,
            width: 915,
            height: 155
        });
        
        function DescripcionConducta(val, x, store){
            var estructurahc = val.split("¬"); 
            var mostrarHC = "";
            var txtContenido = "";
            
            for (var i = 0; i < (estructurahc.length-1); i++){ 
                var contenidohc = estructurahc[i].split("^~"); 
                switch(contenidohc[1]){
                    case "TRUE":
                        txtContenido = "SI";
                        break;

                    case "FALSE":
                        txtContenido = "NO";
                        break;

                    default:
                        txtContenido = contenidohc[1];
                        break;
                }
                if(contenidohc[2].substr(0,8) === "CONDUCTA"){
                    mostrarHC = '<table><tr><td style="padding: 1px;">';
                    mostrarHC += txtContenido;
                    mostrarHC += '</td></tr></table>';
                }
            }
            return mostrarHC;
        }
        
        function DescripcionMotivoConsulta(val, x, store){
            var estructurahc = val.split("¬"); 
            var mostrarHC = "";
            var txtContenido = "";
            
            for (var i = 0; i < (estructurahc.length-1); i++){ 
                var contenidohc = estructurahc[i].split("^~"); 
                switch(contenidohc[1]){
                    case "TRUE":
                        txtContenido = "SI";
                        break;

                    case "FALSE":
                        txtContenido = "NO";
                        break;

                    default:
                        txtContenido = contenidohc[1];
                        break;
                }
                if(contenidohc[2].substr(0,18) === "MOTIVO DE CONSULTA"){
                    mostrarHC = '<table><tr><td style="padding: 1px;">';
                    mostrarHC += txtContenido;
                    mostrarHC += '</td></tr></table>';
                }else{
                    if(contenidohc[2].substr(0,7) === "CONTROL"){
                        mostrarHC = '<table><tr><td style="padding: 1px;">';
                        mostrarHC += txtContenido;
                        mostrarHC += '</td></tr></table>';
                    }
                }
            }
            return mostrarHC;
        }
        
        var stGridProcesos = new StoreGridProcesosPartisalud();
        stGridProcesos.load({
            params: {
                pFecha: 10
            }
        });
        
        this.items = [
            {
                xtype: 'tabpanel',
                id: 'tbOpcionesPacientes',
                activeTab: 0,
                anchor: '100%',
                height: 570,
                //autoHeight: true,
                border: false,
                items: [
                    {
                        xtype: 'panel',
                        style: 'background:transparent;',
                        title: 'Datos del Paciente',
                        items:[
                            {
                                xtype: 'form',
                                frame: true,
                                height: 542,
                                //autoHeight: true,
                                anchor: '100%',
                                autoScroll: true,
                                id: 'frmPacientes',
                                fileUpload: true,
                                padding: 10,
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        border: false,
                                        labelWidth: 130,
                                        items: [
                                            {
                                                xtype: 'hidden',
                                                id: 'intIdPaciente',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                id: 'sysPacienteValido',
                                                value: 0
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Datos del Paciente',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                width: 915,
                                                //height: 380,
                                                autoHeight: true,
                                                id: 'fsPaciente',
                                                layoutConfig: {
                                                    columns: 4
                                                },
                                                /*tbar:{
                                                    items: [
                                                        {
                                                            html:'<span style="color: darkblue;">Haga click en el cuadro  y coloque la huella, para buscar el paciente...!&nbsp;&nbsp;&nbsp;</span>'
                                                        },
                                                        {
                                                            html:'<img src="../../../resources/botones/fingerprint.png" align="left" alt=""/>',border: false
                                                        },
                                                        {
                                                            xtype: 'textfield',
                                                            width: 60,
                                                            allowBlank: true,
                                                            inputType: 'password',
                                                            id: 'sysSearchPacienteHuellaID',
                                                            listeners:{
                                                                specialkey: function(f,e){
                                                                    if (e.getKey() === e.ENTER || e.getKey() === e.TAB && Ext.getCmp('sysSearchPacienteHuellaID').getValue() !== "" && Ext.getCmp('sysSearchPacienteHuellaID').getValue() !== null){
                                                                        Ext.Ajax.request({
                                                                            url: '../../controlador/pacientes/controlador_pacientes.php',
                                                                            params:{
                                                                                task: 'SEARCH_PACIENTE_XHUELLA',
                                                                                pHuella: Ext.getCmp('sysSearchPacienteHuellaID').getValue()
                                                                            },
                                                                            success: function(response,options){
                                                                                var Respuesta = response.responseText;
                                                                                var Contenido = Respuesta.split('^');
                                                                                if(Contenido[0] === "NO"){
                                                                                    Ext.MessageBox.show({
                                                                                        title: 'eOfiClinic',
                                                                                        msg: 'La huella no ha sido reistrada.',
                                                                                        buttons: Ext.MessageBox.OK,
                                                                                        icon: Ext.MessageBox.INFO
                                                                                    });
                                                                                }else{
                                                                                    var winVerificarHuella = new winVerificarHuellaUi();
                                                                                    winVerificarHuella.show();
                                                                                    Ext.getCmp('intIdPaciente').setValue(Contenido[1]);
                                                                                    Ext.getCmp('sysPacienteValido').setValue(1);
                                                                                    Ext.getCmp('strTdoc').setValue(Contenido[2]);
                                                                                    Ext.getCmp('strDocID').setValue(Contenido[3]);
                                                                                    Ext.getCmp('strApe1').setValue(Contenido[4]);
                                                                                    Ext.getCmp('strApe2').setValue(Contenido[5]);
                                                                                    Ext.getCmp('strNom1').setValue(Contenido[6]);
                                                                                    Ext.getCmp('strNom2').setValue(Contenido[7]);
                                                                                    Ext.getCmp('fecFecNac').setValue(Contenido[8]);
                                                                                    if(Contenido[8] !== "" && Contenido[8] !== "00-0-0000"){
                                                                                        Ext.getCmp('strEdad').setValue(MostrarEdadCompleta(new Date().format('Y/m/d'),Ext.getCmp('fecFecNac').getValue().format('Y/m/d')));
                                                                                    }
                                                                                    Ext.getCmp('strGenero').setValue(Contenido[9]);
                                                                                    Ext.getCmp('strDireccion').setValue(Contenido[10]);
                                                                                    Ext.getCmp('strZona').setValue(Contenido[11]);
                                                                                    Ext.getCmp('strTel1').setValue(Contenido[12]);
                                                                                    Ext.getCmp('strTel2').setValue(Contenido[13]);
                                                                                    Ext.getCmp('strEmail').setValue(Contenido[14]);
                                                                                    Ext.getCmp('strEmpresaTrabaja').setValue(Contenido[15]);
                                                                                    Ext.getCmp('strDeptoMuni').setValue(Contenido[16]);
                                                                                    Ext.getCmp('strEstadoCivilPac').setValue(Contenido[18]);
                                                                                    Ext.getCmp('strEscolaridadPac').setValue(Contenido[19]);
                                                                                    Ext.getCmp('strProfesionPac').setValue(Contenido[20]);
                                                                                    Ext.getCmp('gridFormulario').store.load({
                                                                                        params: {
                                                                                            pPaciente: Contenido[1]
                                                                                        }
                                                                                    });
                                                                                    //Ext.getCmp('').setValue(Contenido[]);
                                                                                }
                                                                                Ext.getCmp('sysSearchPacienteHuellaID').setValue(null);
                                                                            },
                                                                            failure: function(response,options){
                                                                                Ext.MessageBox.show({
                                                                                    title: 'Error Conexión',
                                                                                    msg: 'La huella no ha sido reistrada.',
                                                                                    buttons: Ext.MessageBox.OK,
                                                                                    icon: Ext.MessageBox.ERROR
                                                                                });
                                                                                Ext.getCmp('sysSearchPacienteHuellaID').setValue(null);
                                                                            },
                                                                            scope:this 
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    ]
                                                },*/
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 221,
                                                        border: false,
                                                        id: 'pnTdoc',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Tipo Doc ID',
                                                                anchor: '100%',
                                                                name: 'cbTdoc',
                                                                allowBlank: false,
                                                                //store: 'StoreTdocPac',
                                                                store: 'StoreTdocPac',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione Tipo Documento....',
                                                                mode: 'local',
                                                                triggerAction: 'all',
                                                                forceSelection: true,
                                                                id: 'strTdoc'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 269,
                                                        border: false,
                                                        id: 'pnDocID',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Documento ID',
                                                                        name: 'txtDocID',
                                                                        allowBlank: false,
                                                                        width: 150,
                                                                        id: 'strDocID'
                                                                    },
                                                                    {
                                                                        xtype: 'button',
                                                                        iconCls: 'btnBuscar',
                                                                        tooltip: 'Buscar Paciente',
                                                                        id: 'btnBuscarPacienteFrm'
                                                                    },
                                                                    {
                                                                        xtype: 'button',
                                                                        iconCls: 'btnCamera',
                                                                        tooltip: 'Registrar Fotografia',
                                                                        id: 'btnBuscarPacienteFotoFrm'
                                                                    },
                                                                    /*{
                                                                        xtype: 'button',
                                                                        iconCls: 'btnFingerPrint',
                                                                        tooltip: 'Registrar Huella',
                                                                        id: 'btnBuscarPacienteHuellaFrm'
                                                                    },
                                                                    {
                                                                        xtype: 'button',
                                                                        iconCls: 'btnFirma',
                                                                        tooltip: 'Registrar Firma',
                                                                        id: 'btnBuscarPacienteFirmaFrm',
                                                                        listeners:{
                                                                            click : function(){
                                                                                if (Ext.getCmp('intIdPaciente').getValue() !== 0 && Ext.getCmp('sysPacienteValido').getValue() !== 0){
                                                                                    var fileAdjuntarFoto = new CargarFotoPacienteUi();
                                                                                    Ext.getCmp('sysPacienteFoto').setValue(Ext.getCmp('intIdPaciente').getValue());
                                                                                    fileAdjuntarFoto.show();
                                                                                }else{
                                                                                    Ext.MessageBox.show({
                                                                                        title: 'Error',
                                                                                        msg: 'El Paciente no es valido o no ha sido creado',
                                                                                        buttons: Ext.MessageBox.OK,
                                                                                        icon: Ext.MessageBox.ERROR
                                                                                    });
                                                                                }
                                                                            }
                                                                        }
                                                                    }*/
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 172,
                                                        border: false,
                                                        id: 'pnGenero',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Genero',
                                                                anchor: '100%',
                                                                name: 'cbGenero',
                                                                allowBlank: false,
                                                                store: 'StoreGenero',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                emptyText: 'Seleccione Genero....',
                                                                forceSelection: true,
                                                                id: 'strGenero'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 120,
                                                        border: false,
                                                        id: 'pnRegimen',
                                                        items: [
                                                            {
                                                                xtype: 'hidden',
                                                                fieldLabel: 'Régimen',
                                                                id: 'sysRegimen'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 271,
                                                        border: false,
                                                        id: 'pnApe1',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: '1er Apellido',
                                                                anchor: '100%',
                                                                name: 'txtApe1',
                                                                style: 'text-transform:uppercase;',
                                                                allowBlank: false,
                                                                id: 'strApe1'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 271,
                                                        border: false,
                                                        id: 'pnApe2',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: '2do Apellido',
                                                                anchor: '100%',
                                                                name: 'txtApe2',
                                                                style: 'text-transform:uppercase;',
                                                                id: 'strApe2'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 215,
                                                        border: false,
                                                        id: 'pnNom1',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: '1er Nombre',
                                                                anchor: '96%',
                                                                name: 'txtNom1',
                                                                allowBlank: false,
                                                                style: 'text-transform:uppercase;',
                                                                id: 'strNom1'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        border: false,
                                                        width: 145,
                                                        id: 'pnNom2',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: '2do Nombre',
                                                                anchor: '78%',
                                                                name: 'txtNom2',
                                                                style: 'text-transform:uppercase;',
                                                                id: 'strNom2'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 146,
                                                        border: false,
                                                        id: 'pnFecNac',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                fieldLabel: 'Fecha Nacimiento',
                                                                anchor: '100%',
                                                                name: 'txtFecNac',
                                                                allowBlank: false,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecFecNac'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 271,
                                                        border: false,
                                                        id: 'pnEdad',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'Edad Actual',
                                                                anchor: '100%',
                                                                name: 'txtEdad',
                                                                readOnly: true,
                                                                allowBlank: false,
                                                                style: 'color: blue;text-align:center',
                                                                id: 'strEdad'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 366,
                                                        border: false,
                                                        colspan: 2,
                                                        id: 'pnDeptoMuni',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Municipio - Departamento - Residencia',
                                                                anchor: '93%',
                                                                name: 'cbDeptoMuni',
                                                                allowBlank: false,
                                                                store: 'StoreDeptoMuni',
                                                                valueField: 'IdDeptoMunicipio',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione Municipio - Departamento....',
                                                                mode: 'local',
                                                                listWidth: 450,
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                id: 'strDeptoMuni'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 928,
                                                        border: false,
                                                        colspan: 4,
                                                        height: 54,
                                                        id: 'pnDatDirTel',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                fieldLabel: 'Dirección - Teléfono - Teléfono (Otro - Cel.) - Zona - Email',
                                                                anchor: '100%',
                                                                id: 'composDatDirTel',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'txtDireccion',
                                                                        allowBlank: true,
                                                                        emptyText: 'Dirección....',
                                                                        style: 'text-transform:uppercase;',
                                                                        width: 280,
                                                                        id: 'strDireccion'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'txtTel1',
                                                                        allowBlank: false,
                                                                        emptyText: 'Teléfono',
                                                                        width: 160,
                                                                        id: 'strTel1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'txtTel2',
                                                                        emptyText: 'Teléfono (Otro - Cel.)',
                                                                        width: 160,
                                                                        id: 'strTel2'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        flex: 1,
                                                                        fieldLabel: 'Zona',
                                                                        store: 'StoreZonaResidencia',
                                                                        valueField: 'Codigo',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        name: 'cbZona',
                                                                        emptyText: 'Zona....',
                                                                        allowBlank: false,
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        width: 80,
                                                                        value: 'Urbana',
                                                                        triggerAction: 'all',
                                                                        id: 'strZona'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'txtEmail',
                                                                        vtype: 'email',
                                                                        emptyText: 'Email....',
                                                                        width: 180,
                                                                        id: 'strEmail'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 928,
                                                        border: false,
                                                        colspan: 4,
                                                        autoHeight: true,
                                                        id: 'pnPacEmpresa',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                //fieldLabel: 'Empresa Donde Trabaja',
                                                                anchor: '100%',
                                                                id: 'composDatEmpresa',
                                                                items: [
                                                                    {
                                                                        xtype: 'hidden',
                                                                        name: 'txtEmpresaTrabaja',
                                                                        width: 880,
                                                                        id: 'strEmpresaTrabaja'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 928,
                                                        border: false,
                                                        colspan: 4,
                                                        height: 54,
                                                        id: 'pnPacOtro',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                //fieldLabel: 'Estado Civil - Escolaridad - Profesión',
                                                                anchor: '100%',
                                                                id: 'composDatOtro',
                                                                items: [
                                                                    {
                                                                        xtype: 'hidden',
                                                                        id: 'strEstadoCivilPac'
                                                                    },
                                                                    {
                                                                        xtype: 'hidden',
                                                                        id: 'strEscolaridadPac'
                                                                    },
                                                                    {
                                                                        xtype: 'hidden',
                                                                        id: 'strProfesionPac'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'Archivos Adjuntos del Paciente',
                                        layout: 'table',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        width: 915,
                                        autoHeight: true,
                                        layoutConfig: {
                                            columns: 2
                                        },
                                        tbar:{
                                            items: [
                                                {
                                                    xtype: 'button',
                                                    iconCls: 'btnCamera',
                                                    text: 'Importar Fotografia',
                                                    tooltip: 'Importar Fotografia',                                                    listeners:{
                                                        click : function(){
                                                            if(parseInt(Ext.getCmp('intIdPaciente').getValue()) !== 0 && parseInt(Ext.getCmp('sysPacienteValido').getValue()) !== 0){
                                                                var CargarFotoPaciente = new CargarFotoPacienteUi();
                                                                Ext.getCmp('sysPacienteFoto').setValue(Ext.getCmp('intIdPaciente').getValue());
                                                                CargarFotoPaciente.show();
                                                            }else{
                                                                Ext.MessageBox.show({
                                                                    title: 'Error',
                                                                    msg: 'El Paciente no es valido o no ha sido creado',
                                                                    buttons: Ext.MessageBox.OK,
                                                                    icon: Ext.MessageBox.ERROR
                                                                });
                                                            }
                                                        }
                                                    }
                                                },
                                                '-',
                                                {
                                                    xtype: 'button',
                                                    iconCls: 'btnFingerPrint',
                                                    tooltip: 'Importar Huella',
                                                    text: 'Importar Huella',
                                                    listeners:{
                                                        click : function(){
                                                            if(parseInt(Ext.getCmp('intIdPaciente').getValue()) !== 0 && parseInt(Ext.getCmp('sysPacienteValido').getValue()) !== 0){
                                                                var CargarHuellaPaciente = new CargarHuellaPacienteUi();
                                                                Ext.getCmp('sysPacienteHuella').setValue(Ext.getCmp('intIdPaciente').getValue());
                                                                CargarHuellaPaciente.show();
                                                            }else{
                                                                Ext.MessageBox.show({
                                                                    title: 'Error',
                                                                    msg: 'El Paciente no es valido o no ha sido creado',
                                                                    buttons: Ext.MessageBox.OK,
                                                                    icon: Ext.MessageBox.ERROR
                                                                });
                                                            }
                                                        }
                                                    }
                                                },
                                                '-',
                                                {
                                                    xtype: 'button',
                                                    iconCls: 'btnActualizarGrid',
                                                    tooltip: 'Verificar Archivos',
                                                    text: 'Verificar Archivos',
                                                    listeners:{
                                                        click : function(){
                                                            if(parseInt(Ext.getCmp('intIdPaciente').getValue()) !== 0 && parseInt(Ext.getCmp('sysPacienteValido').getValue()) !== 0){
                                                                var updater = Ext.getCmp('showHuella').getUpdater();
                                                                updater.setDefaultUrl('../../../app/controlador/pacientes/showhuella.php?pPaciente=' + Ext.getCmp('intIdPaciente').getValue());
                                                                updater.refresh();
                                                            }else{
                                                                Ext.MessageBox.show({
                                                                    title: 'Error',
                                                                    msg: 'El Paciente no es valido o no ha sido creado',
                                                                    buttons: Ext.MessageBox.OK,
                                                                    icon: Ext.MessageBox.ERROR
                                                                });
                                                            }
                                                        }
                                                    }
                                                }
                                            ]
                                        },
                                        items: [
                                            showHuella
                                        ]
                                    }
                                ],
                                tbar:{
                                    items: [
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Nuevo',
                                            iconCls: 'btnNuevo',
                                            id: 'btnNuevoFrm'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'tbfill'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Guardar',
                                            iconCls: 'btnGuardar',
                                            id: 'btn_AdicionarItemFrm'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Modificar',
                                            iconCls: 'btnGuardar',
                                            id: 'btn_ModificarItemFrm'
                                        }
                                    ]
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        style: 'background:transparent;',
                        title: 'Ingresos - Egresos',
                        id: 'pntabEvolucion',
                        items:[
                            {
                                xtype: 'hidden',
                                id: 'sysCASRefHC'
                            },
                            {
                                xtype: 'hidden',
                                id: 'sysPacienteRefHC'
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: false,
                                style: 'background:transparent; color: darkblue; font-size:14px; text-align: center; text-transform:uppercase;',
                                width: 972,
                                height: 30,
                                border: false,
                                id: 'sysInfoPaciente'
                            },
                            {
                                xtype: 'panel',
                                border: false, 
                                autoHeight: true,
                                layout: {
                                    columns: 2,
                                    type: 'table'
                                },
                                items:[
                                    {
                                        xtype: 'panel',
                                        title: '<center>Registro de Servicios</center>',
                                        //autoHeight: true,
                                        autoScroll: true,
                                        width: 250,
                                        height: 512,
                                        frame: true,
                                        border: false,
                                        items: [
                                            {
                                                xtype: 'grid',
                                                id: 'gridFormulario',
                                                store: 'StoreGridEvolucionesxPacienteOfimedical',
                                                //title: '',
                                                anchor: "100%",
                                                border: false,
                                                frame: true,
                                                height: 470,
                                                flex: 1,
                                                tbar: {
                                                    xtype: 'toolbar',
                                                    items: [
                                                        {
                                                            xtype: 'tbseparator'
                                                        },
                                                        {
                                                            xtype: 'button',
                                                            text: 'Ingreso',
                                                            iconCls: 'btnAddRow',
                                                            id: 'btnAddIngreso'
                                                        },
                                                        {
                                                            xtype: 'tbseparator'
                                                        },
                                                        {
                                                            xtype: 'button',
                                                            text: 'Modificar',
                                                            iconCls: 'btnEditRow',
                                                            id: 'btnModiEgreso'
                                                        },
                                                        {
                                                            xtype: 'tbseparator'
                                                        },
                                                        {
                                                            xtype: 'button',
                                                            text: 'Egreso',
                                                            iconCls: 'btnDelRow',
                                                            id: 'btnEditEgreso'
                                                        },
                                                        {
                                                            xtype: 'tbseparator'
                                                        }
                                                    ]
                                                },
                                                bbar: {
                                                    xtype: 'toolbar',
                                                    items: [
                                                        '->',
                                                        {
                                                            xtype: 'tbseparator'
                                                        },
                                                        {
                                                            xtype: 'button',
                                                            text: 'Actualizar',
                                                            iconCls: 'btnActualizarGrid',
                                                            id: 'btnActualizarEvolucionHC'
                                                        },
                                                        {
                                                            xtype: 'tbseparator'
                                                        }
                                                    ]
                                                },
                                                columns: [
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'ID_INGRESO',
                                                        sortable: false,
                                                        width: 1,
                                                        hidden: true,
                                                        hideable: false,
                                                        dataIndex: 'ID_INGRESO'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Ingreso',
                                                        sortable: false,
                                                        width: 80,
                                                        hidden: false,
                                                        hideable: false,
                                                        renderer: Ext.util.Format.dateRenderer('d/m/Y'),
                                                        dataIndex: 'FECHA_INGRESO'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Hora Ingreso',
                                                        sortable: false,
                                                        width: 80,
                                                        hidden: false,
                                                        hideable: false,
                                                        dataIndex: 'HORA_INGRESO'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Entidad Remite',
                                                        sortable: false,
                                                        width: 200,
                                                        hidden: false,
                                                        hideable: false,
                                                        dataIndex: 'ENTIDAD_REMITE'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Servicio Remite',
                                                        sortable: false,
                                                        width: 200,
                                                        hidden: false,
                                                        hideable: false,
                                                        dataIndex: 'SERVICIO_REMITE'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'EPS-ARS',
                                                        sortable: false,
                                                        width: 120,
                                                        hidden: false,
                                                        hideable: false,
                                                        dataIndex: 'EPSARS'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Habitacion',
                                                        sortable: false,
                                                        width: 70,
                                                        hidden: false,
                                                        hideable: false,
                                                        dataIndex: 'NOM_HABITACION'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Cama',
                                                        sortable: false,
                                                        width: 50,
                                                        hidden: false,
                                                        hideable: false,
                                                        dataIndex: 'NOM_CAMA'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Egreso',
                                                        sortable: false,
                                                        width: 80,
                                                        hidden: false,
                                                        hideable: false,
                                                        renderer: Ext.util.Format.dateRenderer('d/m/Y'),
                                                        dataIndex: 'FECHA_EGRESO'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Hora Egreso',
                                                        sortable: false,
                                                        width: 80,
                                                        hidden: false,
                                                        hideable: false,
                                                        dataIndex: 'HORA_EGRESO'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Observaciones',
                                                        sortable: false,
                                                        width: 200,
                                                        hidden: false,
                                                        hideable: false,
                                                        dataIndex: 'OBSRVACION_EGRESO'
                                                    }
                                                ],
                                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                                viewConfig: {
                                                    getRowClass: function(record, index) {
                                                        switch(record.get('ACTIVO')){
                                                            case "0":
                                                                return 'NoApto';
                                                                break;
                                                            default:
                                                                return 'Apto';
                                                                break;
                                                        }
                                                    }
                                                }
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        //title: 'Ingresos',
                                        //autoHeight: true,
                                        autoScroll: true,
                                        width: 730,
                                        height: 512,
                                        frame: true,
                                        border: false,
                                        items: [
                                            {
                                                xtype: 'grid',
                                                id: 'gridFormularioAcompanantes',
                                                store: 'StoreGridAcompanantesxIngreso',
                                                title: '<center>Acompañantes</center>',
                                                anchor: "100%",
                                                border: false,
                                                frame: true,
                                                height: 220,
                                                flex: 1,
                                                tbar: {
                                                    xtype: 'toolbar',
                                                    items: [
                                                        {
                                                            xtype: 'tbseparator'
                                                        },
                                                        {
                                                            xtype: 'button',
                                                            text: 'Ingreso Acompañante',
                                                            iconCls: 'btnAddRow',
                                                            id: 'btnAddIngresoAcompanante'
                                                        },
                                                        {
                                                            xtype: 'tbseparator'
                                                        },
                                                        {
                                                            xtype: 'button',
                                                            text: 'Modificar Acompañante',
                                                            iconCls: 'btnEditRow',
                                                            id: 'btnModEgresoAcompanante'
                                                        },
                                                        {
                                                            xtype: 'tbseparator'
                                                        },
                                                        {
                                                            xtype: 'button',
                                                            text: 'Egreso Acompañante',
                                                            iconCls: 'btnDelRow',
                                                            id: 'btnEditEgresoAcompanante'
                                                        },
                                                        {
                                                            xtype: 'tbseparator'
                                                        }
                                                    ]
                                                },
                                                columns: [
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'ID_CONSECUTIVO_ACOMPANANTE',
                                                        sortable: false,
                                                        width: 1,
                                                        hidden: true,
                                                        hideable: false,
                                                        dataIndex: 'ID_CONSECUTIVO_ACOMPANANTE'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Ingreso',
                                                        sortable: false,
                                                        width: 80,
                                                        hidden: false,
                                                        hideable: false,
                                                        renderer: Ext.util.Format.dateRenderer('d/m/Y'),
                                                        dataIndex: 'FECHA_INGRESO'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Hora Ingreso',
                                                        sortable: false,
                                                        width: 80,
                                                        hidden: false,
                                                        hideable: false,
                                                        dataIndex: 'HORA_INGRESO_ACOMPANANTE'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Acompañante',
                                                        sortable: false,
                                                        width: 200,
                                                        hidden: false,
                                                        hideable: false,
                                                        dataIndex: 'NOMBRE_ACOMPANANTE'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Telefono',
                                                        sortable: false,
                                                        width: 200,
                                                        hidden: false,
                                                        hideable: false,
                                                        dataIndex: 'TELEFONO_ACOMPANANTE'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Parentesco',
                                                        sortable: false,
                                                        width: 120,
                                                        hidden: false,
                                                        hideable: false,
                                                        dataIndex: 'PARENTESCO_ACOMPANANTE'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Habitacion',
                                                        sortable: false,
                                                        width: 70,
                                                        hidden: false,
                                                        hideable: false,
                                                        dataIndex: 'NOM_HABITACION'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Cama',
                                                        sortable: false,
                                                        width: 50,
                                                        hidden: false,
                                                        hideable: false,
                                                        dataIndex: 'NOM_CAMA'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Egreso',
                                                        sortable: false,
                                                        width: 80,
                                                        hidden: false,
                                                        hideable: false,
                                                        renderer: Ext.util.Format.dateRenderer('d/m/Y'),
                                                        dataIndex: 'FECHA_EGRESO'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Hora Egreso',
                                                        sortable: false,
                                                        width: 80,
                                                        hidden: false,
                                                        hideable: false,
                                                        dataIndex: 'HORA_EGRESO_ACOMPANANTE'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Observaciones',
                                                        sortable: false,
                                                        width: 200,
                                                        hidden: false,
                                                        hideable: false,
                                                        dataIndex: 'ALERTA_ACOMPANANTE'
                                                    }
                                                ],
                                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                                viewConfig: {
                                                    getRowClass: function(record, index) {
                                                        switch(record.get('ACTIVO')){
                                                            case "0":
                                                                return 'NoApto';
                                                                break;
                                                            default:
                                                                return 'Apto';
                                                                break;
                                                        }
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '<center>Información Detallada</center>',
                                                flex: 1,
                                                tpl: [
                                                    '<tpl if="Origen==\'PACIENTE\'">',
                                                    '<center><span style="color:darkblue; font-size:16px;"><b>DATOS DEL PACIENTE</b></span></center>',
                                                    '<hr>',
                                                    '<tpl if="ALERTA!=\'\'">',
                                                    '<center><span style="color:red; font-size:17px;"><b>ALERTA</b></span></center>',
                                                    '<span style="color:red; font-size:16px;"><b>{ALERTA}</b></span><br>',
                                                    '<hr>',
                                                    '</tpl>',
                                                    '<tpl>',
                                                    '<span style="color:blue; font-size:14px;"><b>ENTIDAD REMITE: </b>{ENTIDAD_REMITE}</span><br>',
                                                    '<span style="font-size:14px;"><b>FECHA INGRESO: </b>{FecIngreso}</span> - ',
                                                    '<span style="font-size:14px;"><b>HORA INGRESO: </b>{HORA_INGRESO}</span><br>',
                                                    '<span style="font-size:14px;"><b>EPS-ARS: </b>{EPSARS}</span><br>',
                                                    '<span style="font-size:14px;"><b>Dx: </b>{DIAGNOSTICO}</span><br>',
                                                    '<span style="font-size:14px;"><b>SERVICIO REMITE: </b>{SERVICIO_REMITE}</span><br>',
                                                    '<span style="font-size:14px;"><b>INGRESO AL HOGAR DEL PACIENTE: </b>{INGRESO_HOGAR}</span><br>',
                                                    '<tpl if="INGRESO_HOGAR==\'SI\'">',
                                                    '<table border="1" width="690">',
                                                    '<tr><td width="680" align="center" bgcolor="#BDBDBD" colspan="3"><span style="font-size:12px;"><b>ALIMENTACION</b></span></td><td align="center" bgcolor="#BDBDBD" colspan="2"><span style="font-size:12px;"><b>HOSPEDAJE</b></span></td></tr>',
                                                    '<tr>',
                                                    '<td width="100" bgcolor="#E6E6E6" align="center"><span style="font-size:12px;"><b>DESAYUNO</b></span></td>',
                                                    '<td width="100" bgcolor="#E6E6E6" align="center"><span style="font-size:12px;"><b>ALMUERZO</b></span></td>',
                                                    '<td width="100" bgcolor="#E6E6E6" align="center"><span style="font-size:12px;"><b>COMIDA</b></span></td>',
                                                    '<td width="100" bgcolor="#E6E6E6" align="center"><span style="font-size:12px;"><b>HABITACION</b></span></td>',
                                                    '<td width="100" bgcolor="#E6E6E6" align="center"><span style="font-size:12px;"><b>CAMA</b></span></td>',
                                                    '</tr>',
                                                    '<tr>',
                                                    '<td width="100" align="center"><span style="font-size:12px;"><b>{ALIMENTO_DESAYUNO}</b></span></td>',
                                                    '<td width="100" align="center"><span style="font-size:12px;"><b>{ALIMENTO_ALMUERZO}</b></span></td>',
                                                    '<td width="100" align="center"><span style="font-size:12px;"><b>{ALIMENTO_COMIDA}</b></span></td>',
                                                    '<td width="100" align="center"><span style="font-size:12px;"><b>{NOM_HABITACION}</b></span></td>',
                                                    '<td width="100" align="center"><span style="font-size:12px;"><b>{NOM_CAMA}</b></span></td>',
                                                    '</tr>',
                                                    '</table>',
                                                    '</tpl>',
                                                    '<hr>',
                                                    '<center><span style="color:#FF8000; font-size:12px;"><b>DATOS DEL EGRESO</b></span></center>',
                                                    '<hr>',
                                                    '<span style="font-size:14px;"><b>FECHA EGRESO: </b>{FECHA_EGRESO}</span> - ',
                                                    '<span style="font-size:14px;"><b>HORA EGRESO: </b>{HORA_EGRESO}</span><br>',
                                                    '<span style="font-size:12px;"><b>OBSERVACIONES: </b>{OBSRVACION_EGRESO}</span>',
                                                    '</tpl>',
                                                    '</tpl>',
                                                    '<tpl if="Origen==\'ACOMPANANTE\'">',
                                                    '<center><span style="color:#FF8000; font-size:12px;"><b>ACOMPAÑANTE</b></span></center>',
                                                    '<hr>',
                                                    '<table border="1" width="690">',
                                                    '<tr>',
                                                    '<td width="520"',
                                                    '<span style="font-size:12px;"><b>DOCUMENTO: </b>{TDOC_ACOMPANANTE} - {DOCUMENTO_ACOMPANANTE}   -  <b>GENERO: </b>{GENERO_ACOMPANANTE}</span><br>',
                                                    '<span style="font-size:12px;"><b>NOMBRE: </b>{NOMBRE_ACOMPANANTE}</span><br>',
                                                    '<span style="font-size:12px;"><b>PARENTESCO: </b>{PARENTESCO_ACOMPANANTE}</span><br>',
                                                    '<span style="font-size:12px;"><b>TELEFONOS: </b>{TELEFONO_ACOMPANANTE}</span><br>',
                                                    '<span style="font-size:12px;"><b>INGRESO AL HOGAR DEL ACOMPAÑANTE: {INGRESO_HOGAR_ACOMPANANTE}</b></span><br>',
                                                    '</td>',
                                                    '<td width="140">',
                                                    '<img src="../../../consultoriovirtual/' + ID_CONSULTORIOV  + '/hogarpaso/acompanantes/{TDOC_ACOMPANANTE}{DOCUMENTO_ACOMPANANTE}.jpg" height="120" width="140">',
                                                    '</td>',
                                                    '</tr>',
                                                    '</table>',
                                                    '<tpl if="INGRESO_HOGAR_ACOMPANANTE==\'SI\'">',
                                                    '<table border="1" width="690">',
                                                    '<tr><td width="680" bgcolor="#BDBDBD" align="center" colspan="3"><span style="font-size:12px;"><b>ALIMENTACION</b></span></td><td align="center" bgcolor="#BDBDBD" colspan="2"><span style="font-size:12px;"><b>HOSPEDAJE</b></span></td></tr>',
                                                    '<tr>',
                                                    '<td width="100" bgcolor="#E6E6E6" align="center"><span style="font-size:12px;"><b>DESAYUNO</b></span></td>',
                                                    '<td width="100" bgcolor="#E6E6E6" align="center"><span style="font-size:12px;"><b>ALMUERZO</b></span></td>',
                                                    '<td width="100" bgcolor="#E6E6E6" align="center"><span style="font-size:12px;"><b>COMIDA</b></span></td>',
                                                    '<td width="100" bgcolor="#E6E6E6" align="center"><span style="font-size:12px;"><b>HABITACION</b></span></td>',
                                                    '<td width="100" bgcolor="#E6E6E6" align="center"><span style="font-size:12px;"><b>CAMA</b></span></td>',
                                                    '</tr>',
                                                    '<tr>',
                                                    '<td width="100" align="center"><span style="font-size:12px;"><b>{ALIMENTO_DESAYUNO_ACOMPANANTE}</b></span></td>',
                                                    '<td width="100" align="center"><span style="font-size:12px;"><b>{ALIMENTO_ALMUERZO_ACOMPANANTE}</b></span></td>',
                                                    '<td width="100" align="center"><span style="font-size:12px;"><b>{ALIMENTO_COMIDA_ACOMPANANTE}</b></span></td>',
                                                    '<td width="100" align="center"><span style="font-size:12px;"><b>{NOM_HABITACION}</b></span></td>',
                                                    '<td width="100" align="center"><span style="font-size:12px;"><b>{NOM_CAMA}</b></span></td>',
                                                    '</tr>',
                                                    '</table>',
                                                    '</tpl>',
                                                    '<hr>',
                                                    '</tpl>',
                                                    '</tpl>'
                                                ],
                                                padding: 10,
                                                height: 275,
                                                autoScroll: true,
                                                id: 'pnDetalleServicio'
                                            }
                                        ]
                                    }
                                ]
                            }
                            /*
                            */
                        ]
                    }
                ]
            }
        ];
        this.bbar = {
            xtype: 'toolbar',
            id: 'bbar',
            items: [
                {
                    xtype: 'button',
                    text: '',
                    iconCls: 'btnAyuda',
                    tooltip: 'Ver Ayuda en Linea',
                    ref: '../btnAyuda',
                    id: 'btnAyuda'
                },
                {
                    xtype: 'tbfill'
                },
                {
                    xtype: 'displayfield',
                    value: 'Empresa: PASBISALUD IPS',
                    name: 'txtNomEmpresa',
                    ref: '../fNomEmpresa',
                    id: 'fNomEmpresa'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'Sede: MANIZALES',
                    name: 'txtNomSede',
                    ref: '../fNomSede',
                    id: 'fNomSede'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'IPS: BELEN',
                    name: 'txtNomSede',
                    ref: '../fNomIPS',
                    id: 'fNomIPS'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: '',
                    iconCls: 'btnUsr',
                    ref: '../btnUsr',
                    id: 'btnUsr'
                },
                {
                    xtype: 'displayfield',
                    value: 'Usuario: GJUAN ',
                    name: 'txtNomUSR',
                    style: 'color:royalblue',
                    ref: '../fNomUSR',
                    id: 'fNomUSR'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Salir',
                    iconCls: 'btnSalir',
                    id: 'btnSalir'
                }
            ]
        };
        winPacientesUi.superclass.initComponent.call(this);
    }
});
