/*
* @category    Formulario Adicionar Tratamiento Laser
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddTtoCorporal001Ui = Ext.extend(Ext.Window, {
    title: '.:: Ficha Corporal ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winAddTtoCorporal001Ui',
    initComponent: function() {
        var dataTratamientoCorporal = [
            ['PAQUETES']
        ];
        var stTratamientoCorporal = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTratamientoCorporal.loadData(dataTratamientoCorporal);
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddTratamientoCorporal',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 80,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'strFormato',
                                value: "Corporal_BRestrepo",
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPacienteTtoCorporal',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intConsecutivoTtoCorporal',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuarioTtoCorporal',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        fieldLabel: 'Fecha',
                                        name: 'Fecha',
                                        width: 110,
                                        allowBlank: false,
                                        disabledDates: '',
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        value: new Date().format('d/m/Y'),
                                        id: 'fecFecTtoCorporal'
                                    },
                                    {
                                        html: '# SESION:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: '# Sesion',
                                        width: 50,
                                        minValue: 1,
                                        decimalPrecision: 0,
                                        allowBlank: false,
                                        id: 'intSesionTtoCorporal'
                                    }
                                ]
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Tratamiento',
                                name: 'Tratamiento',
                                anchor: '100%',
                                allowBlank: false,
                                store: stTratamientoCorporal,
                                forceSelection: false,
                                triggerAction: 'all',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                mode: 'local',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                id: 'strTratamientoTtoCorporal'
                            },
                            {
                                xtype: 'fieldset',
                                title: 'MEDIDAS',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '100%',
                                labelWidth: 130,
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'numberfield',
                                                fieldLabel: 'Abdomen Superior',
                                                name: 'Abdomen Superior',
                                                width: 80,
                                                alwaysDisplayDecimals: true,
                                                minValue: 0,
                                                decimalPrecision: 2,
                                                allowBlank: true,
                                                id: 'strAbdSuperiorTtoCorporal'
                                            },
                                            {
                                                html: 'Abdomen Medio:'
                                            },
                                            {
                                                xtype: 'numberfield',
                                                name: 'Abdomen Medio',
                                                width: 80,
                                                alwaysDisplayDecimals: true,
                                                minValue: 0,
                                                decimalPrecision: 2,
                                                allowBlank: true,
                                                id: 'strAbdMedioTtoCorporal'
                                            },
                                            {
                                                html: 'Abdomen Bajo:'
                                            },
                                            {
                                                xtype: 'numberfield',
                                                name: 'Abdomen Bajo',
                                                width: 80,
                                                alwaysDisplayDecimals: true,
                                                minValue: 0,
                                                decimalPrecision: 2,
                                                allowBlank: true,
                                                id: 'strAbdBajoTtoCorporal'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'numberfield',
                                                fieldLabel: 'Cadera',
                                                name: 'Cadera',
                                                width: 80,
                                                alwaysDisplayDecimals: true,
                                                minValue: 0,
                                                decimalPrecision: 2,
                                                allowBlank: true,
                                                id: 'strCaderaTtoCorporal'
                                            },
                                            {
                                                html: 'Pierna Derecha:'
                                            },
                                            {
                                                xtype: 'numberfield',
                                                name: 'Pierna Derecha',
                                                width: 80,
                                                alwaysDisplayDecimals: true,
                                                minValue: 0,
                                                decimalPrecision: 2,
                                                allowBlank: true,
                                                id: 'strPiernaDerechaTtoCorporal'
                                            },
                                            {
                                                html: 'Pierna Izquierda:'
                                            },
                                            {
                                                xtype: 'numberfield',
                                                name: 'Pierna Izquierda',
                                                width: 80,
                                                alwaysDisplayDecimals: true,
                                                minValue: 0,
                                                decimalPrecision: 2,
                                                allowBlank: true,
                                                id: 'strPiernaIzquierdaTtoCorporal'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'numberfield',
                                                fieldLabel: 'Brazo',
                                                name: 'Brazo',
                                                width: 80,
                                                alwaysDisplayDecimals: true,
                                                minValue: 0,
                                                decimalPrecision: 2,
                                                allowBlank: true,
                                                id: 'strBrazoTtoCorporal'
                                            },
                                            {
                                                html: 'Peso:'
                                            },
                                            {
                                                xtype: 'numberfield',
                                                name: 'Peso',
                                                width: 80,
                                                alwaysDisplayDecimals: true,
                                                minValue: 0,
                                                decimalPrecision: 2,
                                                allowBlank: true,
                                                id: 'strPesoTtoCorporal'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Protocolo',
                                name: 'Protocolo',
                                anchor: '100%',
                                allowBlank: true,
                                maxLength: 250,
                                id: 'strProtocoloTtoCorporal'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Medida Final',
                                name: 'Medida Final',
                                anchor: '100%',
                                allowBlank: true,
                                maxLength: 250,
                                id: 'strMedidaFinalTtoCorporal'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Observaciones',
                                name: 'Observaciones',
                                anchor: '100%',
                                allowBlank: true,
                                id: 'strObservacionesTtoCorporal'
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            listeners:{
                                click : function(){
                                    fnGuardarRegTtoCorporal("GUARDAR_TTOCORPORAL","SI","winAddTtoCorporal001Ui","frmAddTratamientoCorporal","../../controlador/asistencial/brestrepo.php","gridFormularioCorporal");
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winAddTtoCorporal001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegTtoCorporal(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid()){
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        if (typeof pLimpiarForm !== 'undefined'){
                            if (pLimpiarForm === "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid !== 'undefined'){
                            if (pGrid !== 'NA'){
                                Ext.getCmp(pGrid).store.load({
                                    params:{
                                        pPaciente: Ext.getCmp('intPacienteTtoCorporal').getValue()
                                    }
                                });
                            }
                        }
                        if(pCerrar === "SI"){
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
