/*
* @category    Formulario Modelo Evolucion Historia Clinica Fisioterapia 001
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCVEMONCADA002Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Valoracion Rehabilitacion Cardiopulmonar Fase II ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                padding: 5,
                border: false,
                height: 610,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Genero',
                        id: 'sysGeneroPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysLegalizaHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 300,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Edad',
                                id: 'sysInfoPacHCEdad'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysInfoPac1',
                                value: 'Genero: '
                            },
                            {
                                xtype: 'textfield',
                                width: 120,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysInfoPacHCGenero'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysInfoPac2',
                                value: 'Ocupación: '
                            },
                            {
                                xtype: 'textfield',
                                width: 260,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysInfoPacHCOcupacion'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 450,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Dirección',
                                id: 'sysInfoPacHCDireccion'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysInfoPac1',
                                value: 'Telefonos: '
                            },
                            {
                                xtype: 'textfield',
                                width: 300,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysInfoPacHCTelefonos'
                            }
                        ]
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'form',
                        frame: true,
                        anchor: '100%',
                        id: 'frmHC',
                        padding: 5,
                        border: false,
                        autoScroll: true,
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'numberfield',
                                width: 100,
                                minValue: 1,
                                maxValue: 50,
                                decimalPrecision: 0,
                                allowBlank: true,
                                fieldLabel: 'Sesion Nro',
                                name: 'Sesion Nro',
                                id: 'intSesionNroHC'
                            },
                            {
                                xtype: 'panel',
                                title: 'CONDICIONES GENERALES',
                                layout: 'table',
                                collapsible: true,
                                titleCollapse: true,
                                anchor: '100%',
                                autoHeight: true,
                                padding: 5,
                                items: [
                                    {
                                        xtype: 'textarea',
                                        width: 850,
                                        fieldLabel: 'CONDICIONES GENERALES',
                                        name: 'CONDICIONES GENERALES',
                                        height: 30,
                                        grow: true,
                                        minGrow: 30,
                                        allowBlank: true,
                                        id: 'memCondicionesGenerales'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                autoHeight: true,
                                anchor: '100%',
                                layout: {
                                    columns: 2,
                                    type: 'table'
                                },
                                items: [
                                    {           
                                        xtype: 'panel',
                                        layout: 'form',
                                        height: 115,
                                        width: 455,
                                        padding: 5,
                                        labelWidth: 150,
                                        title: 'TRABAJO RESPIRATORIO',
                                        items:[
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                fieldLabel: 'Control Respiratorio',
                                                name: 'Control Respiratorio',
                                                allowBlank: true,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strControlRespiratorio'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                fieldLabel: 'Reexpansion Pulmonar',
                                                name: 'Reexpansion Pulmonar',
                                                allowBlank: true,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strReexpansionPulmonar'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                fieldLabel: 'Fortalecimiento Muscular',
                                                name: 'Fortalecimiento Muscula',
                                                allowBlank: true,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strFortalecimientoMuscula'
                                            }
                                        ]
                                    },
                                    {           
                                        xtype: 'panel',
                                        layout: 'form',
                                        height: 115,
                                        width: 440,
                                        padding: 5,
                                        title: 'MONITOREO INICIAL',
                                        items:[
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                anchor: '100%',
                                                items: [
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 50,
                                                        decimalPrecision: 0,
                                                        allowBlank: true,
                                                        fieldLabel: 'FC',
                                                        name: 'FC',
                                                        id: 'intMI_FCHC'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysMI_1',
                                                        value: 'TA:'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 50,
                                                        decimalPrecision: 0,
                                                        allowBlank: true,
                                                        name: 'TA',
                                                        id: 'intMI_TAHC'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysMI_2',
                                                        value: 'SpO2:'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 50,
                                                        decimalPrecision: 0,
                                                        allowBlank: true,
                                                        name: 'SpO2',
                                                        id: 'intMI_SPO2HC'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysMI_3',
                                                        value: 'BORG:'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 50,
                                                        decimalPrecision: 0,
                                                        allowBlank: true,
                                                        name: 'BORG',
                                                        id: 'intMI_BORGHC'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                anchor: '100%',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        width: 100,
                                                        fieldLabel: 'Oxigeno',
                                                        name: 'Oxigeno',
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strMI_OxigenoHC'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysMI_4',
                                                        value: '2"'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 50,
                                                        decimalPrecision: 0,
                                                        allowBlank: true,
                                                        name: '2min',
                                                        id: 'intMI_2minHC'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysMI_5',
                                                        value: '3"'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 50,
                                                        decimalPrecision: 0,
                                                        allowBlank: true,
                                                        name: '3min',
                                                        id: 'intMI_3minHC'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysMI_6',
                                                        value: '4":'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 50,
                                                        decimalPrecision: 0,
                                                        allowBlank: true,
                                                        name: '4min',
                                                        id: 'intMI_4minHC'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                fieldLabel: 'Calistenia',
                                                name: 'Calistenia',
                                                allowBlank: true,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strMI_CalisteniaHC'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                autoHeight: true,
                                anchor: '100%',
                                title: 'ENTRENAMIENTO DE FUERZA',
                                layout: {
                                    columns: 2,
                                    type: 'table'
                                },
                                items: [
                                    {           
                                        xtype: 'panel',
                                        layout: 'form',
                                        //height: 315,
                                        autoHeight: 315,
                                        width: 635,
                                        padding: 5,
                                        items:[
                                            {
                                                xtype: 'fieldset',
                                                title: 'MIEMBROS SUPERIORES',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        labelStyle: 'text-align:right;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 1,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                fieldLabel: '90°',
                                                                border: 0,
                                                                style: 'background:transparent;text-align:right;border:none;',
                                                                id: 'sysEF_90HC'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEF_1',
                                                                value: 'PESO:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 90,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                name: 'PESO',
                                                                id: 'intEF_90PESOHC'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEF_2',
                                                                value: 'SERIES:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 90,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                name: 'SERIES',
                                                                id: 'intEF_90SERIESHC'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEF_3',
                                                                value: 'REPETICIONES:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 90,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                name: 'REPETICIONES',
                                                                id: 'intEF_90REPETICIONESHC'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        labelStyle: 'text-align:right;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 1,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                fieldLabel: 'DIAGONAL',
                                                                border: 0,
                                                                style: 'background:transparent;text-align:right;border:none;',
                                                                id: 'sysEF_DIAGONALHC'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEF_4',
                                                                value: 'PESO:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 90,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                name: 'PESO',
                                                                id: 'intEF_DIAGONALPESOHC'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEF_5',
                                                                value: 'SERIES:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 90,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                name: 'SERIES',
                                                                id: 'intEF_DIAGONALSERIESHC'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEF_6',
                                                                value: 'REPETICIONES:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 90,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                name: 'REPETICIONES',
                                                                id: 'intEF_DIAGONALREPETICIONESHC'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        labelStyle: 'text-align:right;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 1,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                fieldLabel: '180°',
                                                                border: 0,
                                                                style: 'background:transparent;text-align:right;border:none;',
                                                                id: 'sysEF_180HC'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEF_7',
                                                                value: 'PESO:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 90,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                name: 'PESO',
                                                                id: 'intEF_180PESOHC'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEF_8',
                                                                value: 'SERIES:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 90,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                name: 'SERIES',
                                                                id: 'intEF_180SERIESHC'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEF_9',
                                                                value: 'REPETICIONES:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 90,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                name: 'REPETICIONES',
                                                                id: 'intEF_180REPETICIONESHC'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        labelStyle: 'text-align:right;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 1,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                fieldLabel: 'ABD°',
                                                                border: 0,
                                                                style: 'background:transparent;text-align:right;border:none;',
                                                                id: 'sysEF_ABDHC'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEF_10',
                                                                value: 'PESO:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 90,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                name: 'PESO',
                                                                id: 'intEF_ABDPESOHC'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEF_11',
                                                                value: 'SERIES:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 90,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                name: 'SERIES',
                                                                id: 'intEF_ABDSERIESHC'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEF_12',
                                                                value: 'REPETICIONES:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 90,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                name: 'REPETICIONES',
                                                                id: 'intEF_ABDREPETICIONESHC'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'MIEMBROS INFERIORES',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        labelSeparator: ' ',
                                                        labelStyle: 'text-align:right;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 1,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                fieldLabel: ' ',
                                                                border: 0,
                                                                style: 'background:transparent;text-align:right;border:none;',
                                                                id: 'sysEF_MIHC'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEF_13',
                                                                value: 'PESO:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 90,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                name: 'PESO',
                                                                id: 'intEF_MIPESOHC'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEF_14',
                                                                value: 'SERIES:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 90,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                name: 'SERIES',
                                                                id: 'intEF_MISERIESHC'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEF_15',
                                                                value: 'REPETICIONES:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 90,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                name: 'REPETICIONES',
                                                                id: 'intEF_MIREPETICIONESHC'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    {           
                                        xtype: 'panel',
                                        layout: 'form',
                                        //height: 315,
                                        autoHeight: true,
                                        width: 265,
                                        padding: 5,
                                        items:[
                                            {
                                                xtype: 'fieldset',
                                                title: 'BANDAS ELASTICAS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        labelSeparator: '',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 1,
                                                                allowBlank: true,
                                                                fieldLabel: 'COLOR',
                                                                border: 0,
                                                                style: 'background:transparent;border:none;',
                                                                id: 'sysEF_BEHC'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEF_16',
                                                                value: 'REPETICIONES:'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 100,
                                                        allowBlank: true,
                                                        fieldLabel: 'AMARILLO',
                                                        name: 'AMARILLO',
                                                        id: 'intEF_BEAMARILLOHC'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 100,
                                                        allowBlank: true,
                                                        fieldLabel: 'ROJO',
                                                        name: 'ROJO',
                                                        id: 'intEF_BEROJOHC'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 100,
                                                        allowBlank: true,
                                                        fieldLabel: 'VERDE',
                                                        name: 'VERDE',
                                                        id: 'intEF_BEVERDEHC'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                autoHeight: true,
                                anchor: '100%',
                                title: 'ENTRENAMIENTO DE RESISTENCIA',
                                layout: 'form',
                                padding: 5,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        anchor: '100%',
                                        labelSeparator: ' ',
                                        labelStyle: 'text-align:right;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 1,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'ERGOMETRO MSS',
                                                border: 0,
                                                style: 'background:transparent;text-align:right;border:none;',
                                                id: 'sysER_ERGOMETROHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysER_1',
                                                value: 'INTENSIDAD: '
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysER_2',
                                                value: ' B:'
                                            },
                                            {
                                                xtype: 'checkbox',
                                                name: 'B',
                                                anchor: '100%',
                                                value: 'false',
                                                id: 'bolER_ERGOMETRO_INTENSIDAD_BHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysER_3',
                                                value: ' M:'
                                            },
                                            {
                                                xtype: 'checkbox',
                                                name: 'M',
                                                anchor: '100%',
                                                value: 'false',
                                                id: 'bolER_ERGOMETRO_INTENSIDAD_MHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysER_4',
                                                value: ' A:'
                                            },
                                            {
                                                xtype: 'checkbox',
                                                name: 'A',
                                                anchor: '100%',
                                                value: 'false',
                                                id: 'bolER_ERGOMETRO_INTENSIDAD_AHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysER_5',
                                                value: 'REVOLUCIONES:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 90,
                                                allowBlank: true,
                                                name: 'REVOLUCIONES',
                                                id: 'intER_ERGOMETRO_WATTSHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysER_6',
                                                value: 'DURACION:'
                                            },
                                            {
                                                xtype: 'numberfield',
                                                width: 90,
                                                decimalPrecision: 0,
                                                allowBlank: true,
                                                name: 'DURACION',
                                                emptyText: 'min',
                                                id: 'intER_ERGOMETRO_DURACIONHC'
                                            }
                                        ]
                                    },
                                    {
                                        html: '<br>'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        anchor: '100%',
                                        labelSeparator: ' ',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 1,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'BICICLETA',
                                                border: 0,
                                                style: 'background:transparent;border:none;',
                                                id: 'sysER_BICICLETAHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysER_7',
                                                value: 'INTENSIDAD: '
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysER_8',
                                                value: ' B:'
                                            },
                                            {
                                                xtype: 'checkbox',
                                                name: 'B',
                                                anchor: '100%',
                                                value: 'false',
                                                id: 'bolER_BICICLETA_INTENSIDAD_BHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysER_9',
                                                value: ' M:'
                                            },
                                            {
                                                xtype: 'checkbox',
                                                name: 'M',
                                                anchor: '100%',
                                                value: 'false',
                                                id: 'bolER_BICICLETA_INTENSIDAD_MHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysER_10',
                                                value: ' A:'
                                            },
                                            {
                                                xtype: 'checkbox',
                                                name: 'A',
                                                anchor: '100%',
                                                value: 'false',
                                                id: 'bolER_BICICLETA_INTENSIDAD_AHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysER_11',
                                                value: 'REVOLUCIONES:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 90,
                                                allowBlank: true,
                                                name: 'REVOLUCIONES',
                                                id: 'intER_BICICLETA_WATTSHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysER_12',
                                                value: 'DURACION:'
                                            },
                                            {
                                                xtype: 'numberfield',
                                                width: 90,
                                                decimalPrecision: 0,
                                                allowBlank: true,
                                                name: 'DURACION',
                                                emptyText: 'min',
                                                id: 'intER_BICICLETA_DURACIONHC'
                                            }
                                        ]
                                    },
                                    {
                                        html: '<br>'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        anchor: '100%',
                                        labelSeparator: ' ',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 1,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'CAMINADOR',
                                                border: 0,
                                                style: 'background:transparent;border:none;',
                                                id: 'sysER_CAMINADORHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysER_13',
                                                value: 'INTENSIDAD: '
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysER_14',
                                                value: ' B:'
                                            },
                                            {
                                                xtype: 'checkbox',
                                                name: 'B',
                                                anchor: '100%',
                                                value: 'false',
                                                id: 'bolER_CAMINADOR_INTENSIDAD_BHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysER_15',
                                                value: ' M:'
                                            },
                                            {
                                                xtype: 'checkbox',
                                                name: 'M',
                                                anchor: '100%',
                                                value: 'false',
                                                id: 'bolER_CAMINADOR_INTENSIDAD_MHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysER_16',
                                                value: ' A:'
                                            },
                                            {
                                                xtype: 'checkbox',
                                                name: 'A',
                                                anchor: '100%',
                                                value: 'false',
                                                id: 'bolER_CAMINADOR_INTENSIDAD_AHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysER_17',
                                                value: 'VELOCIDAD:'
                                            },
                                            {
                                                xtype: 'numberfield',
                                                width: 90,
                                                decimalPrecision: 0,
                                                allowBlank: true,
                                                name: 'VELOCIDAD',
                                                emptyText: 'km/hora',
                                                id: 'intER_CAMINADOR_VELOCIDADHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysER_12',
                                                value: 'DURACION:'
                                            },
                                            {
                                                xtype: 'numberfield',
                                                width: 90,
                                                decimalPrecision: 0,
                                                allowBlank: true,
                                                name: 'DURACION',
                                                emptyText: 'min',
                                                id: 'intER_CAMINADOR_DURACIONHC'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                autoHeight: true,
                                anchor: '100%',
                                title: 'MONITOREO FINAL',
                                layout: 'form',
                                padding: 5,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        anchor: '100%',
                                        items: [
                                            {
                                                xtype: 'numberfield',
                                                width: 100,
                                                decimalPrecision: 0,
                                                allowBlank: true,
                                                fieldLabel: 'FC',
                                                name: 'FC',
                                                id: 'intMF_FCHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysMF_2',
                                                value: 'SpO2:'
                                            },
                                            {
                                                xtype: 'numberfield',
                                                width: 100,
                                                decimalPrecision: 0,
                                                allowBlank: true,
                                                name: 'SpO2',
                                                id: 'intMF_SPO2HC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysMF_1',
                                                value: 'TA:'
                                            },
                                            {
                                                xtype: 'numberfield',
                                                width: 100,
                                                decimalPrecision: 0,
                                                allowBlank: true,
                                                name: 'TA',
                                                id: 'intMF_TAHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysMF_3',
                                                value: 'BORG:'
                                            },
                                            {
                                                xtype: 'numberfield',
                                                width: 100,
                                                decimalPrecision: 0,
                                                allowBlank: true,
                                                name: 'BORG',
                                                id: 'intMF_BORGHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysMF_4',
                                                value: '%FC Max:'
                                            },
                                            {
                                                xtype: 'numberfield',
                                                width: 100,
                                                decimalPrecision: 2,
                                                allowBlank: true,
                                                name: '%FC Max',
                                                id: 'intMF_FCMaxHC'
                                            },
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'OBSERVACIONES',
                                layout: 'table',
                                collapsible: true,
                                titleCollapse: true,
                                anchor: '100%',
                                autoHeight: true,
                                padding: 5,
                                items: [
                                    {
                                        xtype: 'textarea',
                                        width: 850,
                                        fieldLabel: 'OBSERVACIONES',
                                        name: 'OBSERVACIONES',
                                        height: 30,
                                        grow: true,
                                        minGrow: 30,
                                        allowBlank: true,
                                        id: 'memObservaciones'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'RIPS',
                                layout: 'form',
                                collapsible: true,
                                titleCollapse: true,
                                anchor: '100%',
                                autoHeight: true,
                                id: 'fsRips',
                                padding: 5,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 96,
                                                allowBlank: false,
                                                fieldLabel: 'Diagnostico Principal',
                                                id: 'sysDiagPpalHC',
                                                listeners:{
                                                    specialkey: function(f,e){
                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                        {
                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                Ext.Ajax.request({
                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                    params:{
                                                                        task: 'BUSCAR',
                                                                        pCodigo: f.getValue().toUpperCase()
                                                                    },
                                                                    success: function(response,options)
                                                                    {
                                                                        var el = Ext.get('response'); // get the LOG
                                                                        var Respuesta = response.responseText;
                                                                        var Contenido = Respuesta.split('^');
                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                        } else {
                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                        }
                                                                    },
                                                                    failure: function(response,options){
                                                                        var el = Ext.get('response');
                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                    },
                                                                    scope:this //bind the callbacks
                                                                });
                                                            }else{
                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                            }
                                                        }
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'textarea',
                                                readOnly: true,
                                                width: 625,
                                                height: 22,
                                                id: 'sysDiagPpalHCNom'
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnBuscar',
                                                tooltip: 'Buscar Diagnostico Principal',
                                                id: 'btnSearchDiagPpalHC',
                                                listeners:{
                                                    click : function(){
                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                    }
                                                }
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 96,
                                                allowBlank: true,
                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                id: 'sysDiagRel1HC',
                                                listeners:{
                                                    specialkey: function(f,e){
                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                        {
                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                Ext.Ajax.request(
                                                                {
                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                    params:{
                                                                        task: 'BUSCAR',
                                                                        pCodigo: f.getValue().toUpperCase()
                                                                    },
                                                                    success: function(response,options)
                                                                    {
                                                                        var el = Ext.get('response'); // get the LOG
                                                                        var Respuesta = response.responseText;
                                                                        var Contenido = Respuesta.split('^');
                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                        } else {
                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                        }
                                                                    },
                                                                    failure: function(response,options){
                                                                        var el = Ext.get('response');
                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                    },
                                                                    scope:this //bind the callbacks
                                                                });
                                                            }else{
                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                            }
                                                        }
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'textarea',
                                                readOnly: true,
                                                width: 625,
                                                height: 22,
                                                id: 'sysDiagRel1HCNom'
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnBuscar',
                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                id: 'btnSearchDiagRel1HC',
                                                listeners:{
                                                    click : function(){
                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                    }
                                                }
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 96,
                                                allowBlank: true,
                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                id: 'sysDiagRel2HC',
                                                listeners:{
                                                    specialkey: function(f,e){
                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                        {
                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                Ext.Ajax.request(
                                                                {
                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                    params:{
                                                                        task: 'BUSCAR',
                                                                        pCodigo: f.getValue().toUpperCase()
                                                                    },
                                                                    success: function(response,options)
                                                                    {
                                                                        var el = Ext.get('response'); // get the LOG
                                                                        var Respuesta = response.responseText;
                                                                        var Contenido = Respuesta.split('^');
                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                        } else {
                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                        }
                                                                    },
                                                                    failure: function(response,options){
                                                                        var el = Ext.get('response');
                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                    },
                                                                    scope:this //bind the callbacks
                                                                });
                                                            }else{
                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                            }
                                                        }
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'textarea',
                                                readOnly: true,
                                                width: 625,
                                                height: 22,
                                                id: 'sysDiagRel2HCNom'
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnBuscar',
                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                id: 'btnSearchDiagRel2HC1',
                                                listeners:{
                                                    click : function(){
                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                    }
                                                }
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 96,
                                                allowBlank: true,
                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                id: 'sysDiagRel3HC',
                                                listeners:{
                                                    specialkey: function(f,e){
                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                        {
                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                Ext.Ajax.request(
                                                                {
                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                    params:{
                                                                        task: 'BUSCAR',
                                                                        pCodigo: f.getValue().toUpperCase()
                                                                    },
                                                                    success: function(response,options)
                                                                    {
                                                                        var el = Ext.get('response'); // get the LOG
                                                                        var Respuesta = response.responseText;
                                                                        var Contenido = Respuesta.split('^');
                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                        } else {
                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                        }
                                                                    },
                                                                    failure: function(response,options){
                                                                        var el = Ext.get('response');
                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                    },
                                                                    scope:this //bind the callbacks
                                                                });
                                                            }else{
                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                            }
                                                        }
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'textarea',
                                                readOnly: true,
                                                width: 625,
                                                height: 22,
                                                id: 'sysDiagRel3HCNom'
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnBuscar',
                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                id: 'btnSearchDiagRel3HC',
                                                listeners:{
                                                    click : function(){
                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                    }
                                                }
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Tipo de Diagnostico',
                                        width:750,
                                        name: 'Tipo de Diagnostico',
                                        allowBlank: false,
                                        store: 'StoreTipoDiagnostico',
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        submitValue: true,
                                        id: 'sysTipoDiagosticoHC'
                                    },
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Finalidad Consulta',
                                        width:750,
                                        name: 'Finalidad Consulta',
                                        allowBlank: false,
                                        store: 'StoreFinalidadConsulta',
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        submitValue: true,
                                        value: 10,
                                        id: 'sysFinalidadConsultaHC'
                                    },
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Causa Externa',
                                        width:750,
                                        name: 'Causa Externa',
                                        allowBlank: false,
                                        store: 'StoreCausaExterna',
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        submitValue: true,
                                        value: 13,
                                        id: 'sysCausaExternaHC'
                                    }                            
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    if (Ext.getCmp('sysUsaGridSalida').getValue() == 1){
                                                        Ext.getCmp('gridFormulario').store.reload();
                                                    }
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistros();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistros();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winHCVEMONCADA002Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
