/*
* @category    Formulario Cierra Proceso
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winCierraProcesoUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Cerrar Proceso ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winCierraProceso',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmCerrarProceso',
                padding: 10,
                border: false,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'CAS',
                        id: 'sysCASCierraProceso'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Concepto',
                        width: 150,
                        name: 'CONCEPTO',
                        allowBlank: false,
                        store: 'StoreAptoNoApto',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        emptyText: 'Seleccione....',
                        submitValue: true,
                        id: 'strConceptoCierraProceso'
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Cerrar Proceso',
                            iconCls: 'btnCerrar',
                            id: 'btnCerrar_Proceso',
                            listeners:{
                                click : function(){
                                    var frm = Ext.getCmp('frmCerrarProceso').getForm();
                                    if (frm.isValid())
                                    {
                                        frm.submit({
                                            url: '../../controlador/asistencial/saludocupacional.php',
                                            params: {
                                                task: 'PARTISALUD_CERRAR_PROCESO',
                                                pCAS: Ext.getCmp('sysCASCierraProceso').getValue(),
                                                pConcepto: Ext.getCmp('strConceptoCierraProceso').getValue(),
                                                pUsuario: ID_USUARIO
                                            },
                                            success: function(res,req)
                                            {
                                                switch(req.result.requestedId){
                                                    case "1":
                                                        Ext.getCmp('gridProcesoPartisaludxPac').store.reload();
                                                        Ext.MessageBox.show({
                                                            title: 'Cerrar Proceso',
                                                            msg: 'Se Cerro el Proceso con Exito.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.INFO
                                                        });
                                                        Ext.getCmp('winCierraProceso').close();
                                                        break;

                                                    default:
                                                        Ext.MessageBox.show({
                                                            title: 'Cerrar Proceso',
                                                            msg: 'Ocurrio un error al cerrar el proceso o no se pudo establecer conexión con el servidor.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.ERROR
                                                        });
                                                        break;
                                                }
                                            },
                                            failure: function(response,options)
                                            {
                                                Ext.MessageBox.show({
                                                    title: 'Error Base Datos',
                                                    msg: 'No podemos Cerrar el Proceso en estos momentos',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        });
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'El Concepto Final es Requerido',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winCierraProcesoUi.superclass.initComponent.call(this);
    }
});
