/*
* @category    Formulario Pacientes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winPacientesUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic .:: Pacientes ::.',
    width: 1014,
    height: 646,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winPacientesUi',
    initComponent: function() {
        Ext.BLANK_IMAGE_URL = '../../../lib/extjs/resources/images/default/s.gif';
        var stGridHistorialLaboral = new StoreGridHistorialLaboral();
        stGridHistorialLaboral.load({
            params: {
                pPaciente: 0
            }
        });
        wPaciente = 0;
        wCAS = 0;
        
        var picFoto = {
            id: 'picFoto',
            columnWidth: .5,
            bodyStyle: 'padding:0px 0px 0px 40px',
            items: [
                {
                    xtype: 'box',
                    border: true,
                    autoEl: { tag: 'div', style: 'padding-bottom:20px',
                        html: '<img id="picFoto" src="' + Ext.BLANK_IMAGE_URL + '"/>'
                    }
                }
            ]
        }

        var picFirma = {
            id: 'pic',
            columnWidth: .5,
            bodyStyle: 'padding:0px 0px 0px 40px',
            items: [
                {
                    xtype: 'box',
                    border: true,
                    autoEl: { tag: 'div', style: 'padding-bottom:20px',
                        html: '<img id="pic" src="' + Ext.BLANK_IMAGE_URL + '"/>'
                    }
                }
            ]
        }
        
        function DescripcionGrid(val, x, store){
            mostrarHC = '<table><tr><td style="padding: 1px;">';
            mostrarHC += val;
            mostrarHC += '</td></tr></table>';
            return mostrarHC;
        }

        function DescripcionProfesional(val, x, store){
            if(store.data.ConceptoMedicoOcupacional == "" || store.data.ConceptoMedicoOcupacional == null){
                return "";
            }else{
                return val;
            }
        }

        var aPanelPublicidad = new Ext.Panel({
            autoLoad:{url:'../publicidad/frminferior/frmpublicidadinf.php',scripts:true,scope:this},
            id: 'Publicidad',
            title: '',
            border: false,
            autoScroll: false,
            closable: true,
            width: 915,
            height: 155
        });
        
        function DescripcionConducta(val, x, store){
            var estructurahc = val.split("¬"); 
            var mostrarHC = "";
            var txtContenido = "";
            
            for (var i = 0; i < (estructurahc.length-1); i++){ 
                var contenidohc = estructurahc[i].split("^~"); 
                switch(contenidohc[1]){
                    case "TRUE":
                        txtContenido = "SI";
                        break;

                    case "FALSE":
                        txtContenido = "NO";
                        break;

                    default:
                        txtContenido = contenidohc[1];
                        break;
                }
                if(contenidohc[2].substr(0,8) == "CONDUCTA"){
                    mostrarHC = '<table><tr><td style="padding: 1px;">';
                    mostrarHC += txtContenido;
                    mostrarHC += '</td></tr></table>';
                }
            }
            return mostrarHC;
        }
        
        function DescripcionMotivoConsulta(val, x, store){
            var estructurahc = val.split("¬"); 
            var mostrarHC = "";
            var txtContenido = "";
            
            for (var i = 0; i < (estructurahc.length-1); i++){ 
                var contenidohc = estructurahc[i].split("^~"); 
                switch(contenidohc[1]){
                    case "TRUE":
                        txtContenido = "SI";
                        break;

                    case "FALSE":
                        txtContenido = "NO";
                        break;

                    default:
                        txtContenido = contenidohc[1];
                        break;
                }
                if(contenidohc[2].substr(0,18) == "MOTIVO DE CONSULTA"){
                    mostrarHC = '<table><tr><td style="padding: 1px;">';
                    mostrarHC += txtContenido;
                    mostrarHC += '</td></tr></table>';
                }else{
                    if(contenidohc[2].substr(0,7) == "CONTROL"){
                        mostrarHC = '<table><tr><td style="padding: 1px;">';
                        mostrarHC += txtContenido;
                        mostrarHC += '</td></tr></table>';
                    }
                }
            }
            return mostrarHC;
        }
        
        var stGridProcesos = new StoreGridProcesosPartisalud();
        stGridProcesos.load({
            params: {
                pFecha: 10
            }
        })
        
        this.items = [
            {
                xtype: 'tabpanel',
                id: 'tbOpcionesPacientes',
                activeTab: 0,
                anchor: '100%',
                height: 570,
                //autoHeight: true,
                border: false,
                items: [
                    {
                        xtype: 'panel',
                        style: 'background:transparent;',
                        title: 'Datos del Paciente',
                        items:[
                            {
                                xtype: 'form',
                                frame: true,
                                height: 542,
                                //autoHeight: true,
                                anchor: '100%',
                                autoScroll: true,
                                id: 'frmPacientes',
                                fileUpload: true,
                                padding: 10,
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        border: false,
                                        labelWidth: 130,
                                        items: [
                                            {
                                                xtype: 'hidden',
                                                id: 'intIdPaciente',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                id: 'sysPacienteValido',
                                                value: 0
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Datos del Paciente',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                width: 915,
                                                //height: 380,
                                                autoHeight: true,
                                                id: 'fsPaciente',
                                                layoutConfig: {
                                                    columns: 4
                                                },
                                                tbar:{
                                                    items: [
                                                        {
                                                            html:'<span style="color: darkblue;">Haga click en el cuadro  y coloque la huella, para buscar el paciente...!&nbsp;&nbsp;&nbsp;</span>'
                                                        },
                                                        {
                                                            html:'<img src="../../../resources/botones/fingerprint.png" align="left" alt=""/>',border: false
                                                        },
                                                        {
                                                            xtype: 'textfield',
                                                            width: 60,
                                                            allowBlank: true,
                                                            inputType: 'password',
                                                            id: 'sysSearchPacienteHuellaID',
                                                            listeners:{
                                                                specialkey: function(f,e){
                                                                    if (e.getKey() === e.ENTER || e.getKey() === e.TAB && Ext.getCmp('sysSearchPacienteHuellaID').getValue() !== "" && Ext.getCmp('sysSearchPacienteHuellaID').getValue() !== null){
                                                                        Ext.Ajax.request({
                                                                            url: '../../controlador/pacientes/controlador_pacientes.php',
                                                                            params:{
                                                                                task: 'SEARCH_PACIENTE_XHUELLA',
                                                                                pHuella: Ext.getCmp('sysSearchPacienteHuellaID').getValue()
                                                                            },
                                                                            success: function(response,options){
                                                                                var Respuesta = response.responseText;
                                                                                var Contenido = Respuesta.split('^');
                                                                                if(Contenido[0] === "NO"){
                                                                                    Ext.MessageBox.show({
                                                                                        title: 'eOfiClinic',
                                                                                        msg: 'La huella no ha sido reistrada.',
                                                                                        buttons: Ext.MessageBox.OK,
                                                                                        icon: Ext.MessageBox.INFO
                                                                                    });
                                                                                }else{
                                                                                    var winVerificarHuella = new winVerificarHuellaUi();
                                                                                    winVerificarHuella.show();
                                                                                    Ext.getCmp('intIdPaciente').setValue(Contenido[1]);
                                                                                    Ext.getCmp('sysPacienteValido').setValue(1);
                                                                                    Ext.getCmp('strTdoc').setValue(Contenido[2]);
                                                                                    Ext.getCmp('strDocID').setValue(Contenido[3]);
                                                                                    Ext.getCmp('strApe1').setValue(Contenido[4]);
                                                                                    Ext.getCmp('strApe2').setValue(Contenido[5]);
                                                                                    Ext.getCmp('strNom1').setValue(Contenido[6]);
                                                                                    Ext.getCmp('strNom2').setValue(Contenido[7]);
                                                                                    Ext.getCmp('fecFecNac').setValue(Contenido[8]);
                                                                                    if(Contenido[8] !== "" && Contenido[8] !== "00-0-0000"){
                                                                                        Ext.getCmp('strEdad').setValue(MostrarEdadCompleta(new Date().format('Y/m/d'),Ext.getCmp('fecFecNac').getValue().format('Y/m/d')));
                                                                                    }
                                                                                    Ext.getCmp('strGenero').setValue(Contenido[9]);
                                                                                    Ext.getCmp('strDireccion').setValue(Contenido[10]);
                                                                                    Ext.getCmp('strZona').setValue(Contenido[11]);
                                                                                    Ext.getCmp('strTel1').setValue(Contenido[12]);
                                                                                    Ext.getCmp('strTel2').setValue(Contenido[13]);
                                                                                    Ext.getCmp('strEmail').setValue(Contenido[14]);
                                                                                    Ext.getCmp('strEmpresaTrabaja').setValue(Contenido[15]);
                                                                                    Ext.getCmp('strDeptoMuni').setValue(Contenido[16]);
                                                                                    Ext.getCmp('strEstadoCivilPac').setValue(Contenido[18]);
                                                                                    Ext.getCmp('strEscolaridadPac').setValue(Contenido[19]);
                                                                                    Ext.getCmp('strProfesionPac').setValue(Contenido[20]);
                                                                                    //Ext.getCmp('').setValue(Contenido[]);
                                                                                }
                                                                                Ext.getCmp('sysSearchPacienteHuellaID').setValue(null);
                                                                            },
                                                                            failure: function(response,options){
                                                                                Ext.MessageBox.show({
                                                                                    title: 'Error Conexión',
                                                                                    msg: 'La huella no ha sido reistrada.',
                                                                                    buttons: Ext.MessageBox.OK,
                                                                                    icon: Ext.MessageBox.ERROR
                                                                                });
                                                                                Ext.getCmp('sysSearchPacienteHuellaID').setValue(null);
                                                                            },
                                                                            scope:this 
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    ]
                                                },
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 221,
                                                        border: false,
                                                        id: 'pnTdoc',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Tipo Doc ID',
                                                                anchor: '100%',
                                                                name: 'cbTdoc',
                                                                allowBlank: false,
                                                                //store: 'StoreTdocPac',
                                                                store: 'StoreTdocPac',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione Tipo Documento....',
                                                                mode: 'local',
                                                                triggerAction: 'all',
                                                                forceSelection: true,
                                                                id: 'strTdoc'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 269,
                                                        border: false,
                                                        id: 'pnDocID',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Documento ID',
                                                                        name: 'txtDocID',
                                                                        allowBlank: false,
                                                                        width: 150,
                                                                        id: 'strDocID'
                                                                    },
                                                                    {
                                                                        xtype: 'button',
                                                                        iconCls: 'btnBuscar',
                                                                        tooltip: 'Buscar Paciente',
                                                                        id: 'btnBuscarPacienteFrm'
                                                                    },
                                                                    {
                                                                        xtype: 'button',
                                                                        iconCls: 'btnFingerPrint',
                                                                        tooltip: 'Registrar Huella',
                                                                        id: 'btnBuscarPacienteHuellaFrm'
                                                                    },
                                                                    {
                                                                        xtype: 'button',
                                                                        iconCls: 'btnCamera',
                                                                        tooltip: 'Registrar Fotografia',
                                                                        id: 'btnBuscarPacienteFotoFrm'
                                                                    },
                                                                    {
                                                                        xtype: 'button',
                                                                        iconCls: 'btnFirma',
                                                                        tooltip: 'Registrar Firma',
                                                                        id: 'btnBuscarPacienteFirmaFrm',
                                                                        listeners:{
                                                                            click : function(){
                                                                                if (Ext.getCmp('intIdPaciente').getValue() !== 0 && Ext.getCmp('sysPacienteValido').getValue() !== 0){
                                                                                    var fileAdjuntarFoto = new CargarFotoPacienteUi();
                                                                                    Ext.getCmp('sysPacienteFoto').setValue(Ext.getCmp('intIdPaciente').getValue());
                                                                                    fileAdjuntarFoto.show();
                                                                                }else{
                                                                                    Ext.MessageBox.show({
                                                                                        title: 'Error',
                                                                                        msg: 'El Paciente no es valido o no ha sido creado',
                                                                                        buttons: Ext.MessageBox.OK,
                                                                                        icon: Ext.MessageBox.ERROR
                                                                                    });
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 172,
                                                        border: false,
                                                        id: 'pnGenero',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Genero',
                                                                anchor: '100%',
                                                                name: 'cbGenero',
                                                                allowBlank: false,
                                                                store: 'StoreGenero',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                emptyText: 'Seleccione Genero....',
                                                                forceSelection: true,
                                                                id: 'strGenero'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 120,
                                                        border: false,
                                                        id: 'pnRegimen',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Régimen',
                                                                anchor: '100%',
                                                                name: 'cbRegimen',
                                                                allowBlank: false,
                                                                store: 'StoreTipoRegimen',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                emptyText: 'Seleccione Régimen/Tipo Usuario....',
                                                                forceSelection: true,
                                                                value: '1 - Contributivo',
                                                                listWidth: 350,
                                                                id: 'strRegimen'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 271,
                                                        border: false,
                                                        id: 'pnApe1',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: '1er Apellido',
                                                                anchor: '100%',
                                                                name: 'txtApe1',
                                                                style: 'text-transform:uppercase;',
                                                                allowBlank: false,
                                                                id: 'strApe1'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 271,
                                                        border: false,
                                                        id: 'pnApe2',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: '2do Apellido',
                                                                anchor: '100%',
                                                                name: 'txtApe2',
                                                                style: 'text-transform:uppercase;',
                                                                id: 'strApe2'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 215,
                                                        border: false,
                                                        id: 'pnNom1',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: '1er Nombre',
                                                                anchor: '96%',
                                                                name: 'txtNom1',
                                                                allowBlank: false,
                                                                style: 'text-transform:uppercase;',
                                                                id: 'strNom1'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        border: false,
                                                        width: 145,
                                                        id: 'pnNom2',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: '2do Nombre',
                                                                anchor: '78%',
                                                                name: 'txtNom2',
                                                                style: 'text-transform:uppercase;',
                                                                id: 'strNom2'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 146,
                                                        border: false,
                                                        id: 'pnFecNac',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                fieldLabel: 'Fecha Nacimiento',
                                                                anchor: '100%',
                                                                name: 'txtFecNac',
                                                                allowBlank: false,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecFecNac'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 271,
                                                        border: false,
                                                        id: 'pnEdad',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'Edad Actual',
                                                                anchor: '100%',
                                                                name: 'txtEdad',
                                                                readOnly: true,
                                                                allowBlank: false,
                                                                style: 'color: blue;text-align:center',
                                                                id: 'strEdad'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 366,
                                                        border: false,
                                                        colspan: 2,
                                                        id: 'pnDeptoMuni',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Municipio - Departamento - Residencia',
                                                                anchor: '93%',
                                                                name: 'cbDeptoMuni',
                                                                allowBlank: false,
                                                                store: 'StoreDeptoMuni',
                                                                valueField: 'IdDeptoMunicipio',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione Municipio - Departamento....',
                                                                mode: 'local',
                                                                listWidth: 450,
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                id: 'strDeptoMuni'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 928,
                                                        border: false,
                                                        colspan: 4,
                                                        height: 54,
                                                        id: 'pnDatDirTel',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                fieldLabel: 'Dirección - Teléfono - Teléfono (Otro - Cel.) - Zona - Email',
                                                                anchor: '100%',
                                                                id: 'composDatDirTel',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'txtDireccion',
                                                                        allowBlank: false,
                                                                        emptyText: 'Dirección....',
                                                                        style: 'text-transform:uppercase;',
                                                                        width: 280,
                                                                        id: 'strDireccion'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'txtTel1',
                                                                        allowBlank: false,
                                                                        emptyText: 'Teléfono',
                                                                        width: 160,
                                                                        id: 'strTel1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'txtTel2',
                                                                        emptyText: 'Teléfono (Otro - Cel.)',
                                                                        width: 160,
                                                                        id: 'strTel2'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        flex: 1,
                                                                        fieldLabel: 'Zona',
                                                                        store: 'StoreZonaResidencia',
                                                                        valueField: 'Codigo',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        name: 'cbZona',
                                                                        emptyText: 'Zona....',
                                                                        allowBlank: false,
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        width: 80,
                                                                        value: 'Urbana',
                                                                        triggerAction: 'all',
                                                                        id: 'strZona'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'txtEmail',
                                                                        vtype: 'email',
                                                                        emptyText: 'Email....',
                                                                        width: 180,
                                                                        id: 'strEmail'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 928,
                                                        border: false,
                                                        colspan: 4,
                                                        autoHeight: true,
                                                        id: 'pnPacEmpresa',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                fieldLabel: 'Empresa Donde Trabaja',
                                                                anchor: '100%',
                                                                id: 'composDatEmpresa',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'txtEmpresaTrabaja',
                                                                        width: 880,
                                                                        id: 'strEmpresaTrabaja'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 928,
                                                        border: false,
                                                        colspan: 4,
                                                        height: 54,
                                                        id: 'pnPacOtro',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                fieldLabel: 'Estado Civil - Escolaridad - Profesión',
                                                                anchor: '100%',
                                                                id: 'composDatOtro',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        flex: 1,
                                                                        store: 'StoreEstadoCivil',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        emptyText: 'Estado Civil',
                                                                        allowBlank: true,
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        width: 120,
                                                                        triggerAction: 'all',
                                                                        id: 'strEstadoCivilPac'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        flex: 1,
                                                                        store: 'StoreEscolaridad',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        emptyText: 'Escolaridad',
                                                                        allowBlank: true,
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        width: 180,
                                                                        triggerAction: 'all',
                                                                        id: 'strEscolaridadPac'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        flex: 1,
                                                                        store: 'StoreProfesion',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        emptyText: 'Profesión',
                                                                        allowBlank: true,
                                                                        forceSelection: false,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        width: 570,
                                                                        triggerAction: 'all',
                                                                        id: 'strProfesionPac'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ],
                                tbar:{
                                    items: [
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Nuevo',
                                            iconCls: 'btnNuevo',
                                            id: 'btnNuevoFrm'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'tbfill'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Guardar',
                                            iconCls: 'btnGuardar',
                                            id: 'btn_AdicionarItemFrm'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Modificar',
                                            iconCls: 'btnGuardar',
                                            id: 'btn_ModificarItemFrm'
                                        }
                                    ]
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        style: 'background:transparent;',
                        title: 'Historial Laboral',
                        id: 'pntabHistorialLaboralPac',
                        items:[
                            {
                                xtype: 'grid',
                                title: 'Historial Laboral',
                                id: 'gridHistorialLaboral',
                                store: stGridHistorialLaboral,
                                anchor: "100%",
                                height: 542,
                                border: false,
                                frame: true,
                                loadMask: true,
                                colModel: new Ext.ux.grid.LockingColumnModel([
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Id',
                                        sortable: false,
                                        width: 1,
                                        hidden: true,
                                        hideable: false,
                                        dataIndex: 'idConsecutivo',
                                        id: 'idConsecutivo'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Paciente',
                                        sortable: false,
                                        width: 1,
                                        hidden: true,
                                        hideable: false,
                                        dataIndex: 'idPaciente',
                                        id: 'idPaciente'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Empresa',
                                        sortable: false,
                                        width: 250,
                                        dataIndex: 'descEmpresa',
                                        id: 'descEmpresa'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Cargo',
                                        sortable: false,
                                        width: 180,
                                        dataIndex: 'descCargo',
                                        id: 'descCargo'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Tiempo',
                                        sortable: false,
                                        width: 150,
                                        dataIndex: 'descTiempo',
                                        id: 'descTiempo'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Riesgo',
                                        sortable: false,
                                        width: 150,
                                        dataIndex: 'descRisego',
                                        renderer: DescripcionGrid,
                                        id: 'descRisego'
                                    }
                                ]),
                                selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                                iconCls:'icon-grid',
                                //view: new Ext.grid.GroupingView(),
                                tbar:
                                    {
                                        xtype: 'toolbar',
                                        items: [
                                            {
                                                xtype: 'button',
                                                text: 'Adicionar Registro',
                                                iconCls: 'btnAddRow',
                                                id: 'btnAddHistorialLaboral',
                                                listeners: {
                                                    click : function() {
                                                        var winHistorialLobral = new winAddHistorialLaboralPartisaludUi();
                                                        Ext.getCmp('intPacienteHistoLaboral').setValue(Ext.getCmp('intIdPaciente').getValue());
                                                        winHistorialLobral.show();
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Eliminar Registro',
                                                iconCls: 'btnDelRow',
                                                id: 'btnDelHistorialLaboral',
                                                listeners: {
                                                    click : function() {
                                                         if(Ext.getCmp('gridHistorialLaboral').selModel.getCount() == 1)
                                                        {
                                                            var selections = Ext.getCmp('gridHistorialLaboral').selModel.getSelections();
                                                            Ext.Msg.show({
                                                                title: 'Historial Laboral',
                                                                msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.descEmpresa + ', ' + selections[0].json.descCargo + '?',
                                                                buttons: Ext.Msg.YESNO,
                                                                icon: Ext.Msg.QUESTION,
                                                                fn: function(btn)
                                                                {
                                                                    if(btn=="yes")
                                                                    {
                                                                        fnEliminarRegistros("../../controlador/asistencial/saludocupacional.php",{task: "ELIMINAR_HISTORIAL_LABORAL", pIdHistorial: selections[0].json.idConsecutivo}, 'gridHistorialLaboral')
                                                                    }
                                                                }
                                                            });
                                                        }else{
                                                            Ext.MessageBox.show({
                                                                title: 'Error',
                                                                msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                                buttons: Ext.MessageBox.OK,
                                                                icon: Ext.MessageBox.ERROR
                                                            });
                                                        }
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            }
                                        ]
                                    }
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        style: 'background:transparent;',
                        title: 'Proceso de Evaluación',
                        id: 'pntabEvaluacion',
                        items:[
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                style: 'background:#F2F2F2; color: #298A08; font-size:14px; text-align: center; text-transform:uppercase;',
                                width: 982,
                                height: 30,
                                border: false,
                                readOnly: true,
                                id: 'sysInfoPaciente'
                            },
                            {
                                xtype: 'grid',
                                id: 'gridProcesoPartisaludxPac',
                                store: 'StoreGridProcesosxPacientePartisalud',
                                title: '',
                                anchor: "100%",
                                border: false,
                                frame: true,
                                height: 510,
                                tbar:{
                                    items: [
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Actualizar',
                                            iconCls: 'btnActualizarGrid',
                                            tooltip: 'Actualizar',
                                            id: 'btnActualizarInfoPac'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Iniciar Proceso',
                                            iconCls: 'btnVerHC',
                                            id: 'btnIniciarProceso'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Cerrar Proceso',
                                            iconCls: 'btnCerrar',
                                            id: 'btnCerrarProceso'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Eliminar Proceso',
                                            iconCls: 'btnDelRow',
                                            id: 'btnEliminarProceso'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'tbfill'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Imp. Historia',
                                            iconCls: 'btnImprimir',
                                            tooltip: 'Imprimir Historia',
                                            id: 'btnPrintHCSO'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Imp. Certificado',
                                            iconCls: 'btnImprimir',
                                            tooltip: 'Imprimir Certificado',
                                            id: 'btnPrintCertificadoSO'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Imp. Visiometria',
                                            iconCls: 'btnImprimir',
                                            tooltip: 'Imprimir Visiometria',
                                            id: 'btnPrintVisiometriaSO'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Imp. Audiometria',
                                            iconCls: 'btnImprimir',
                                            tooltip: 'Imprimir Audiometria',
                                            id: 'btnPrintAudiometriaSO'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Imp. Laboratorio',
                                            iconCls: 'btnImprimir',
                                            tooltip: 'Imprimir Resultados Laboratorio',
                                            id: 'btnPrintLaboratorioSO'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        }
                                    ]
                                },
                                columns: [
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'IdCliente',
                                        sortable: false,
                                        width: 1,
                                        hidden: true,
                                        hideable: false,
                                        dataIndex: 'IdCliente'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'CAS',
                                        sortable: false,
                                        width: 80,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'CAS'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Fecha',
                                        sortable: false,
                                        width: 80,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'FechaAtencion'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Cliente',
                                        sortable: false,
                                        width: 200,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'Cliente'
                                    },
                                    {
                                        header: 'Proceso Actual',
                                        dataIndex: 'ProcesoActual',
                                        sortable: true,
                                        width: 190
                                    },
                                    {
                                        header: 'Ubicación Actual',
                                        dataIndex: 'UbicacionActual',
                                        sortable: true,
                                        width: 190
                                    },
                                    {
                                        header: 'Concepto Final',
                                        dataIndex: 'ConceptoFinal',
                                        sortable: true,
                                        width: 100
                                    },
                                    {
                                        header: 'Tamizaje Visual',
                                        dataIndex: 'ConceptoTomaSignos',
                                        sortable: true,
                                        width: 130
                                    },
                                    {
                                        header: 'Concepto Laboratorio',
                                        dataIndex: 'ConceptoLaboratorio',
                                        sortable: true,
                                        width: 130
                                    },
                                    {
                                        header: 'Concepto Fonoaudiologia',
                                        dataIndex: 'ConceptoFonoaudiologia',
                                        sortable: true,
                                        width: 130
                                    },
                                    {
                                        header: 'Concepto Medicina',
                                        dataIndex: 'ConceptoMedicoOcupacional',
                                        sortable: true,
                                        width: 130
                                    },
                                    {
                                        header: 'Medico Ocupacional',
                                        dataIndex: 'NomProfesional',
                                        sortable: true,
                                        renderer: DescripcionProfesional,
                                        width: 130
                                    },
                                    {
                                        header: 'Tipo Examen',
                                        dataIndex: 'TipoExamen',
                                        sortable: false,
                                        width: 150
                                    }
                                ],
                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                viewConfig: {
                                    getRowClass: function(record, index) {
                                        switch(record.get('ConceptoFinal')){
                                            case "APTO":
                                                return 'Apto';
                                                break;
                                            case "NO APTO":
                                                return 'NoApto';
                                                break;
                                            default:
                                                break;
                                        }
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        layout: 'form',
                        padding: 5,
                        //style: 'background:transparent;',
                        frame: true,
                        title: 'Ver Todos los Procesos',
                        id: 'pntabProcesos',
                        items:[
                            {
                                xtype: 'datefield',
                                fieldLabel: 'Fecha Proceso',
                                width: 120,
                                allowBlank: false,
                                style: 'text-align:center;',
                                emptyText: '(dia/mes/año) ',
                                id: 'sysFechaAgenda'
                            },
                            {
                                xtype: 'grid',
                                id: 'gridFormularioProcesos',
                                store: stGridProcesos,
                                anchor: "100%",
                                height: 500,
                                border: false,
                                frame: true,
                                tbar:{
                                    xtype: 'toolbar',
                                    items: [
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Actualizar',
                                            iconCls: 'btnActualizarGrid',
                                            tooltip: 'Actualizar',
                                            id: 'btnActualizarAgenda'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Cerrar Proceso',
                                            iconCls: 'btnCerrar',
                                            id: 'btnCerrarProceso1'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Desbloquear Proceso',
                                            iconCls: 'btnDesbloquear',
                                            id: 'btnDesbloquearProceso'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'tbfill'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Imp. Historia',
                                            iconCls: 'btnImprimir',
                                            tooltip: 'Imprimir Historia',
                                            id: 'btnPrintHCSO1'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Imp. Certificado',
                                            iconCls: 'btnImprimir',
                                            tooltip: 'Imprimir Certificado',
                                            id: 'btnPrintCertificadoSO1'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Imp. Visiometria',
                                            iconCls: 'btnImprimir',
                                            tooltip: 'Imprimir Visiometria',
                                            id: 'btnPrintVisiometriaSO1'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Imp. Audiometria',
                                            iconCls: 'btnImprimir',
                                            tooltip: 'Imprimir Audiometria',
                                            id: 'btnPrintAudiometriaSO1'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Imp. Laboratorio',
                                            iconCls: 'btnImprimir',
                                            tooltip: 'Imprimir Resultados Laboratorio',
                                            id: 'btnPrintLaboratorioSO1'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        }
                                    ]
                                },
                                columns: [
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'IdCliente',
                                        sortable: false,
                                        width: 1,
                                        hidden: true,
                                        hideable: false,
                                        dataIndex: 'IdCliente'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Paciente',
                                        sortable: false,
                                        width: 200,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'NomPaciente'
                                    },
                                    {
                                        header: 'Proceso Actual',
                                        dataIndex: 'ProcesoActual',
                                        sortable: true,
                                        width: 130
                                    },
                                    {
                                        header: 'Ubicación Actual',
                                        dataIndex: 'UbicacionActual',
                                        sortable: true,
                                        width: 100
                                    },
                                    {
                                        header: 'Tamizaje Visual',
                                        dataIndex: 'ConceptoTomaSignos',
                                        sortable: true,
                                        width: 130
                                    },
                                    {
                                        header: 'Toma Muestras',
                                        dataIndex: 'TomaMuestras',
                                        sortable: false,
                                        width: 70
                                    },
                                    {
                                        header: 'Concepto Laboratorio',
                                        dataIndex: 'ConceptoLaboratorio',
                                        sortable: true,
                                        width: 130
                                    },
                                    {
                                        header: 'Concepto Fonoaudiologia',
                                        dataIndex: 'ConceptoFonoaudiologia',
                                        sortable: true,
                                        width: 130
                                    },
                                    {
                                        header: 'Concepto Medicina',
                                        dataIndex: 'ConceptoMedicoOcupacional',
                                        sortable: true,
                                        width: 130
                                    },
                                    {
                                        header: 'Tipo Examen',
                                        dataIndex: 'TipoExamen',
                                        sortable: false,
                                        width: 150
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Cliente',
                                        sortable: false,
                                        width: 200,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'Cliente'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'CAS',
                                        sortable: false,
                                        width: 80,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'CAS'
                                    }
                                ],
                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                view: new Ext.grid.GroupingView({
                                    groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})',
                                    getRowClass: function(record, index, rowParams, store){
                                        switch(record.get('ProcesoActual')){
                                            case "TOMA DE SIGNOS":
                                                return 'PasoTomaSignos';
                                                break;
                                            case "LABORATORIO":
                                                return 'PasoLaboratorio';
                                                break;
                                            case "FONOAUDIOLOGIA":
                                                return 'PasoFonoaudiologia';
                                                break;
                                            case "VALORACION MEDICA":
                                                return 'PasoMedico';
                                                break;
                                            case "TOMA MUESTRAS":
                                                return 'PasoTomaMuestras';
                                                break;
                                            case "PROCESO CERRADO":
                                                if(record.get('ConceptoFinal') == "APTO"){
                                                    return 'Apto';
                                                }else{
                                                    return 'NoApto';
                                                }
                                                break;
                                            default:
                                                break;
                                        }
                                    }
                                }),
                                columnLines: true,
                                bbar:{
                                    xtype: 'toolbar',
                                    items: [
                                        {
                                            xtype: 'cycle',
                                            prependText: 'Vista por: ',
                                            iconCls: 'btnGrouping',
                                            showText: true,
                                            items: [
                                                {
                                                    xtype: 'menucheckitem',
                                                    id: 'btnGrouping1',
                                                    text: 'Ubicación Actual',
                                                    checked: true
                                                },
                                                {
                                                    xtype: 'menucheckitem',
                                                    id: 'btnGrouping2',
                                                    text: 'Proceso Actual'
                                                }
                                            ]
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                ]
            }
        ];
        this.bbar = {
            xtype: 'toolbar',
            id: 'bbar',
            items: [
                {
                    xtype: 'button',
                    text: '',
                    iconCls: 'btnAyuda',
                    tooltip: 'Ver Ayuda en Linea',
                    ref: '../btnAyuda',
                    id: 'btnAyuda'
                },
                {
                    xtype: 'tbfill'
                },
                {
                    xtype: 'displayfield',
                    value: 'Empresa: PASBISALUD IPS',
                    name: 'txtNomEmpresa',
                    ref: '../fNomEmpresa',
                    id: 'fNomEmpresa'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'Sede: MANIZALES',
                    name: 'txtNomSede',
                    ref: '../fNomSede',
                    id: 'fNomSede'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'IPS: BELEN',
                    name: 'txtNomSede',
                    ref: '../fNomIPS',
                    id: 'fNomIPS'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: '',
                    iconCls: 'btnUsr',
                    ref: '../btnUsr',
                    id: 'btnUsr'
                },
                {
                    xtype: 'displayfield',
                    value: 'Usuario: GJUAN ',
                    name: 'txtNomUSR',
                    style: 'color:royalblue',
                    ref: '../fNomUSR',
                    id: 'fNomUSR'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Salir',
                    iconCls: 'btnSalir',
                    id: 'btnSalir'
                }
            ]
        };
        winPacientesUi.superclass.initComponent.call(this);
    }
});
