/*
* @category    Programacion Eventos Formulario Pacientes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmPacientes = Ext.extend(winPacientesUi, {
    initComponent: function() {
        winFrmPacientes.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        el = Ext.get('idaplicacion');
        NOM_APLICACION = el.getValue();
        el = Ext.get('idxac');
        var ID_CONSULTORIO = el.getValue();
        el = Ext.get('usaPatrocinador');
        USA_PATROCINADOR = el.getValue();
        ID_wPACIENTE = 0;
        
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        this.setPagePosition((screen.width - 1004)/2, 5);
        this.fNomEmpresa.setValue("Consultorio Virtual: " + Ext.get('nomConsultorio').getValue());
        this.fNomSede.setValue();
        this.fNomIPS.setValue();
        this.fNomUSR.setValue("Usr: [" + Ext.get('codusuario').getValue() + "]-" + Ext.get('nomusuario').getValue());
        
        //fsPublicidad
        if(USA_PATROCINADOR == "SI"){
            Ext.getCmp('Publicidad').setVisible(true);
        }else{
            Ext.getCmp('Publicidad').setVisible(false);
        }
        
        Ext.getCmp('btn_ModificarItemFrm').setVisible(false);
        
        var fFecNac = Ext.getCmp('fecFecNac').on("Blur",this.MostrarEdad,this);
        var btn_SalirItemFrm = Ext.getCmp('btnSalir').on("click",this.CerrarVentana,this);
        var btnNuevoFrm = Ext.getCmp('btnNuevoFrm').on("click",this.NuevoPaciente,this);
        var btnBuscarPacienteFrm = Ext.getCmp('btnBuscarPacienteFrm').on("click",this.BuscarPaciente,this);
        var btnBuscarPacienteHuellaFrm = Ext.getCmp('btnBuscarPacienteHuellaFrm').on("click",this.RegistrarHuellaPacientes02,this);
        var btnBuscarPacienteFotoFrm = Ext.getCmp('btnBuscarPacienteFotoFrm').on("click",this.RegistrarFotoPacientes02,this);
        
        
        var btn_AdicionarItemFrm = Ext.getCmp('btn_AdicionarItemFrm').on("click",this.GuardarItem,this);
        var btn_ModificarItemFrm = Ext.getCmp('btn_ModificarItemFrm').on("click",this.ModificarItem,this);
        var btnIniciarProceso = Ext.getCmp('btnIniciarProceso').on("click",this.IniciarProcesoEvaluacion,this);
        var btnEliminarProceso = Ext.getCmp('btnEliminarProceso').on("click",this.EliminarProcesoEvaluacion,this);
        var btnCerrarProceso = Ext.getCmp('btnCerrarProceso').on("click",this.CerrarProcesoEvaluacion,this);
        var btnPrintHCSO = Ext.getCmp('btnPrintHCSO').on("click",this.PrintHistoriaOcupacionalSO,this);
        var btnPrintCertificadoSO = Ext.getCmp('btnPrintCertificadoSO').on("click",this.PrintCertificadoSO,this);
        var btnActualizarInfoPac = Ext.getCmp('btnActualizarInfoPac').on("click",this.ActualizarInfoFac,this);
        var sysFechaAgenda = Ext.getCmp('sysFechaAgenda').on("select",this.CargaDetalleAgenda,this);
        var btnActualizarAgenda = Ext.getCmp('btnActualizarAgenda').on("click",this.ActualizarAgenda,this);
        var btnGrouping1 = Ext.getCmp('btnGrouping1').on("click",this.GroupingUbicacionActual,this);
        var btnGrouping2 = Ext.getCmp('btnGrouping2').on("click",this.GroupingProcesoActual,this);
        var btnCerrarProceso1 = Ext.getCmp('btnCerrarProceso1').on("click",this.CerrarProcesoEvaluacion1,this);
        var btnPrintHCSO1 = Ext.getCmp('btnPrintHCSO1').on("click",this.PrintHistoriaOcupacionalSO1,this);
        var btnPrintCertificadoSO1 = Ext.getCmp('btnPrintCertificadoSO1').on("click",this.PrintCertificadoSO1,this);
        var btnPrintVisiometriaSO = Ext.getCmp('btnPrintVisiometriaSO').on("click",this.PrintVisiometriaSO,this);
        var btnPrintAudiometriaSO = Ext.getCmp('btnPrintAudiometriaSO').on("click",this.PrintAudiometriaSO,this);
        var btnPrintVisiometriaSO1 = Ext.getCmp('btnPrintVisiometriaSO1').on("click",this.PrintVisiometriaSO1,this);
        var btnPrintAudiometriaSO1 = Ext.getCmp('btnPrintAudiometriaSO1').on("click",this.PrintAudiometriaSO1,this);
        var btnPrintLaboratorioSO1 = Ext.getCmp('btnPrintLaboratorioSO1').on("click",this.PrintLaboratorioSO1,this);
        var btnPrintLaboratorioSO = Ext.getCmp('btnPrintLaboratorioSO').on("click",this.PrintLaboratorioSO,this);
        
        var btnDesbloquearProceso = Ext.getCmp('btnDesbloquearProceso').on("click",this.DesbloquearProcesoSO,this);
        
    },
    RegistrarFotoPacientes02: function(){
        if(parseInt(Ext.getCmp('intIdPaciente').getValue()) !== 0 && parseInt(Ext.getCmp('sysPacienteValido').getValue()) !== 0){
            window.open ("../../../app/controlador/fotopaciente/fotopaciente.php?pPaciente=" + Ext.getCmp('intIdPaciente').getValue(),"Registro Foto");
        }else{
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'Debe Crear el Paciente',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    RegistrarHuellaPacientes02: function(){
        if(parseInt(Ext.getCmp('intIdPaciente').getValue()) !== 0 && parseInt(Ext.getCmp('sysPacienteValido').getValue()) !== 0){
            var winRegistrarHuella = new winRegistrarHuellaUi();
            Ext.getCmp('sysPacienteHuella').setValue(Ext.getCmp('intIdPaciente').getValue());
            winRegistrarHuella.show();
        }else{
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'Debe Crear el Paciente',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    PrintLaboratorioSO: function(){
        if (Ext.getCmp('intIdPaciente').getValue() != 0 && Ext.getCmp('sysPacienteValido').getValue() != 0){
            if(Ext.getCmp('gridProcesoPartisaludxPac').selModel.getCount() == 1){
                var selections = Ext.getCmp('gridProcesoPartisaludxPac').selModel.getSelections();
                window.open ("../../controlador/asistencial/saludocupa004/printsaludocupa_laboratorio.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pEvolucion=" + selections[0].json.CAS,"Certificado");
            }
        }
    },
    PrintLaboratorioSO1: function(){
        if(Ext.getCmp('gridFormularioProcesos').selModel.getCount() == 1){
            var selections = Ext.getCmp('gridFormularioProcesos').selModel.getSelections();
            window.open ("../../controlador/asistencial/saludocupa004/printsaludocupa_laboratorio.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pEvolucion=" + selections[0].json.CAS,"Certificado");
        }
    },
    DesbloquearProcesoSO: function(){
        if(Ext.getCmp('gridFormularioProcesos').selModel.getCount() == 1){
            var selections = Ext.getCmp('gridFormularioProcesos').selModel.getSelections();
            if(selections[0].json.ConceptoFinal == "SIN DEFINIR"){
                var winDesbloquearProceso = new winDesbloquearProcesoUi();
                Ext.getCmp('sysCASDesbloquearProceso').setValue(selections[0].json.CAS),
                winDesbloquearProceso.show();
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'El Paciente no ha finalizado el proceso',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    PrintVisiometriaSO1: function(){
        if(Ext.getCmp('gridFormularioProcesos').selModel.getCount() == 1){
            var selections = Ext.getCmp('gridFormularioProcesos').selModel.getSelections();
            //if(selections[0].json.ConceptoFinal != "SIN DEFINIR"){
                window.open ("../../controlador/asistencial/saludocupa004/printsaludocupa_visiometria.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pEvolucion=" + selections[0].json.CAS,"Certificado");
            //}else{
            //    Ext.MessageBox.show({
            //        title: 'Error',
            //        msg: 'El Paciente no ha finalizado el proceso',
            //        buttons: Ext.MessageBox.OK,
            //        icon: Ext.MessageBox.ERROR
            //    });
            //}
        }
    },
    PrintAudiometriaSO1: function(){
        if(Ext.getCmp('gridFormularioProcesos').selModel.getCount() == 1){
            var selections = Ext.getCmp('gridFormularioProcesos').selModel.getSelections();
            //if(selections[0].json.ConceptoFinal != "SIN DEFINIR"){
                window.open ("../../controlador/asistencial/saludocupa004/printsaludocupa_audiometria.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pEvolucion=" + selections[0].json.CAS,"Certificado");
            //}else{
            //    Ext.MessageBox.show({
            //        title: 'Error',
            //        msg: 'El Paciente no ha finalizado el proceso',
            //        buttons: Ext.MessageBox.OK,
            //        icon: Ext.MessageBox.ERROR
            //    });
            //}
        }
    },
    PrintCertificadoSO1: function(){
        if(Ext.getCmp('gridFormularioProcesos').selModel.getCount() == 1){
            var selections = Ext.getCmp('gridFormularioProcesos').selModel.getSelections();
            if(selections[0].json.ConceptoFinal != "SIN DEFINIR"){
                Ext.Ajax.request({
                    url: '../../controlador/pacientes/savehuella.php',
                    params:{
                        pPaciente: selections[0].json.Paciente
                    }
                });
                window.open ("../../controlador/asistencial/saludocupa004/printsaludocupa_certificado.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pEvolucion=" + selections[0].json.CAS,"Certificado");
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'El Paciente no ha finalizado el proceso',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    PrintHistoriaOcupacionalSO1: function(){
        if(Ext.getCmp('gridFormularioProcesos').selModel.getCount() == 1){
            var selections = Ext.getCmp('gridFormularioProcesos').selModel.getSelections();
            if(selections[0].json.ConceptoFinal != "SIN DEFINIR"){
                Ext.Ajax.request({
                    url: '../../controlador/pacientes/savehuella.php',
                    params:{
                        pPaciente: selections[0].json.Paciente
                    }
                });
                window.open ("../../controlador/asistencial/saludocupa004/printsaludocupa.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pEvolucion=" + selections[0].json.CAS,"Historia Ocupacional");
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'El Paciente no ha finalizado el proceso',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    CerrarProcesoEvaluacion1: function(){
        if(Ext.getCmp('gridFormularioProcesos').selModel.getCount() == 1){
            var selections = Ext.getCmp('gridFormularioProcesos').selModel.getSelections();
            if (selections[0].json.ConceptoFinal == "SIN DEFINIR"){
                var winCierraProceso = new winCierraProcesoUi();
                Ext.getCmp('sysCASCierraProceso').setValue(selections[0].json.CAS),
                winCierraProceso.show();
            }
        }
    },
    
    GroupingUbicacionActual: function(){
        Ext.getCmp('gridFormularioProcesos').store.clearGrouping();
        Ext.getCmp('gridFormularioProcesos').store.groupBy("UbicacionActual");
    },
    GroupingProcesoActual: function(){
        Ext.getCmp('gridFormularioProcesos').store.clearGrouping();
        Ext.getCmp('gridFormularioProcesos').store.groupBy("ProcesoActual");
    },
    ActualizarAgenda: function(){
        Ext.getCmp('gridFormularioProcesos').store.reload();
    },
    CargaDetalleAgenda: function(f, d) {
        Ext.getCmp('gridFormularioProcesos').store.load({
            params: {
                pAgenda: d.format("Y-m-d")
            }
        }); 
    },
    ActualizarInfoFac: function(){
        Ext.getCmp('gridProcesoPartisaludxPac').store.reload();
    },
    PrintVisiometriaSO: function(){
        if (Ext.getCmp('intIdPaciente').getValue() != 0 && Ext.getCmp('sysPacienteValido').getValue() != 0){
            if(Ext.getCmp('gridProcesoPartisaludxPac').selModel.getCount() == 1){
                var selections = Ext.getCmp('gridProcesoPartisaludxPac').selModel.getSelections();
                //if(selections[0].json.ConceptoFinal != "SIN DEFINIR"){
                    window.open ("../../controlador/asistencial/saludocupa004/printsaludocupa_visiometria.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pEvolucion=" + selections[0].json.CAS,"Certificado");
                //}else{
                //    Ext.MessageBox.show({
                //        title: 'Error',
                //        msg: 'El Paciente no ha finalizado el proceso',
                //        buttons: Ext.MessageBox.OK,
                //        icon: Ext.MessageBox.ERROR
                //    });
                //}
            }
        }
    },
    PrintAudiometriaSO: function(){
        if (Ext.getCmp('intIdPaciente').getValue() != 0 && Ext.getCmp('sysPacienteValido').getValue() != 0){
            if(Ext.getCmp('gridProcesoPartisaludxPac').selModel.getCount() == 1){
                var selections = Ext.getCmp('gridProcesoPartisaludxPac').selModel.getSelections();
                //if(selections[0].json.ConceptoFinal != "SIN DEFINIR"){
                    window.open ("../../controlador/asistencial/saludocupa004/printsaludocupa_audiometria.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pEvolucion=" + selections[0].json.CAS,"Certificado");
                //}else{
                //    Ext.MessageBox.show({
                //       title: 'Error',
                //        msg: 'El Paciente no ha finalizado el proceso',
                //        buttons: Ext.MessageBox.OK,
                //        icon: Ext.MessageBox.ERROR
                //    });
                //}
            }
        }
    },
    PrintCertificadoSO: function(){
        if (Ext.getCmp('intIdPaciente').getValue() != 0 && Ext.getCmp('sysPacienteValido').getValue() != 0){
            if(Ext.getCmp('gridProcesoPartisaludxPac').selModel.getCount() == 1){
                var selections = Ext.getCmp('gridProcesoPartisaludxPac').selModel.getSelections();
                if(selections[0].json.ConceptoFinal != "SIN DEFINIR"){
                    Ext.Ajax.request({
                        url: '../../controlador/pacientes/savehuella.php',
                        params:{
                            pPaciente: selections[0].json.Paciente
                        }
                    });
                    window.open ("../../controlador/asistencial/saludocupa004/printsaludocupa_certificado.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pEvolucion=" + selections[0].json.CAS,"Certificado");
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'El Paciente no ha finalizado el proceso',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }
        }
    },
    PrintHistoriaOcupacionalSO: function(){
        if (Ext.getCmp('intIdPaciente').getValue() != 0 && Ext.getCmp('sysPacienteValido').getValue() != 0){
            if(Ext.getCmp('gridProcesoPartisaludxPac').selModel.getCount() == 1){
                var selections = Ext.getCmp('gridProcesoPartisaludxPac').selModel.getSelections();
                if(selections[0].json.ConceptoFinal != "SIN DEFINIR"){
                    Ext.Ajax.request({
                        url: '../../controlador/pacientes/savehuella.php',
                        params:{
                            pPaciente: selections[0].json.Paciente
                        }
                    });
                    window.open ("../../controlador/asistencial/saludocupa004/printsaludocupa.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pEvolucion=" + selections[0].json.CAS,"Historia Ocupacional");
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'El Paciente no ha finalizado el proceso',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }
        }
    },
    CerrarProcesoEvaluacion: function(){
        if (Ext.getCmp('intIdPaciente').getValue() != 0 && Ext.getCmp('sysPacienteValido').getValue() != 0){
            if(Ext.getCmp('gridProcesoPartisaludxPac').selModel.getCount() == 1){
                var selections = Ext.getCmp('gridProcesoPartisaludxPac').selModel.getSelections();
                if (selections[0].json.ConceptoFinal == "SIN DEFINIR"){
                    var winCierraProceso = new winCierraProcesoUi();
                    Ext.getCmp('sysCASCierraProceso').setValue(selections[0].json.CAS),
                    winCierraProceso.show();
                }
            }
        }
    },
    EliminarProcesoEvaluacion: function(){
        if (Ext.getCmp('intIdPaciente').getValue() != 0 && Ext.getCmp('sysPacienteValido').getValue() != 0){
            if(Ext.getCmp('gridProcesoPartisaludxPac').selModel.getCount() == 1){
                var selections = Ext.getCmp('gridProcesoPartisaludxPac').selModel.getSelections();
                if (selections[0].json.ConceptoFinal == "SIN DEFINIR"){
                    var winEliminarProceso = new winEliminaProcesoUi();
                    Ext.getCmp('sysCASEliminaProceso').setValue(selections[0].json.CAS),
                    winEliminarProceso.show();
                }
            }
        }
    },
    IniciarProcesoEvaluacion: function(){
        if (Ext.getCmp('intIdPaciente').getValue() != 0 && Ext.getCmp('sysPacienteValido').getValue() != 0){
            var frmAddEvolucionOfimedical = new winAddEvolucionOfimedicalUi();
            Ext.getCmp('sysEmpresaPlantillaHC').setValue(ID_EMPRESA);
            Ext.getCmp('sysSedePlantillaHC').setValue(ID_SEDE);
            Ext.getCmp('sysIPSPlantillaHC').setValue(ID_IPS);
            Ext.getCmp('sysUsuarioPlantillaHC').setValue(ID_USUARIO);
            Ext.getCmp('sysProfesionalPlantillaHC').setValue(1);
            Ext.getCmp('sysPacientePlantillaHC').setValue(Ext.getCmp('intIdPaciente').getValue());
            Ext.getCmp('sysNomProfesionalPlantillaHC').setValue("");
            Ext.getCmp('sysNomPacientePlantillaHC').setValue(PonerAcentosMayusculas(Ext.getCmp('strTdoc').getValue() + '-' + Ext.getCmp('strDocID').getValue() + ' ' + Ext.getCmp('strNom1').getValue() + ' ' + Ext.getCmp('strNom2').getValue() + ' ' + Ext.getCmp('strApe1').getValue() + ' ' + Ext.getCmp('strApe2').getValue()));
            frmAddEvolucionOfimedical.show();
        }else{
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'El Paciente no es valido o no ha sido creado',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    ModificarItem: function(){ //ok
        Ext.Msg.show({
            title: 'Guardar Pacientes',
            msg: 'Esta Seguro que Desea Guardar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("MODIFICAR_PARTISALUD","NO","winPacientesUi","frmPacientes","../../controlador/pacientes/controlador_ofimedical.php","NA","NA","NA","NO","NO");
                }
            }
        });
    },
    GuardarItem: function(){ //ok
        Ext.Msg.show({
            title: 'Guardar Pacientes',
            msg: 'Esta Seguro que Desea Guardar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnInsertarRegistros("INSERTAR_PARTISALUD","SI","winPacientesUi","frmPacientes","../../controlador/pacientes/controlador_ofimedical.php","NA");
                }
            }
        });
    },
    
    BuscarPaciente: function(){
        buscarpacienteofimedical("partisalud");
    },
    NuevoPaciente: function(){
        Ext.Msg.show({
            title: 'Nuevo Registro',
            msg: 'Esta seguro que desea hacer un nuevo registro, si hace este se perdera la información ingresada hasta ahora',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    var frm = Ext.getCmp('frmPacientes').getForm();
                    frm.reset();
                    frm.clearInvalid();
                    Ext.getCmp('sysInfoPaciente').setValue(null);
                    Ext.getCmp('intIdPaciente').setValue(0);
                    Ext.getCmp('btn_AdicionarItemFrm').setVisible(true);
                    Ext.getCmp('btn_ModificarItemFrm').setVisible(false);
                    Ext.getCmp('gridProcesoPartisaludxPac').store.load({
                        params: {
                            pPaciente: 0
                        }
                    });
                    Ext.getCmp('gridHistorialLaboral').store.load({
                        params: {
                            pPaciente: 0
                        }
                    });
                }
            }
        });
    },
    MostrarEdad: function(f) {
        Ext.getCmp('strEdad').setValue(MostrarEdadCompleta(new Date().format('Y/m/d'),f.getValue().format('Y/m/d')));
    },
    CerrarVentana: function(){
        el = Ext.get('idaplicacion');
        var NOM_APLICACION = el.getValue();
        Ext.Msg.show({
            title: NOM_APLICACION,
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                  window.close();
                }
            }
        });
    }
    
});

function fnEliminarRegistros(URL,arrParam, pGrid, arrParamStore)
{
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid != 'undefined')
                    {
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                    }
                    break;

                case 3:
                    if (typeof pGrid != 'undefined')
                    {
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Alguno de los registros no se pudieron eliminar',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el registro en estos momentos o existen datos relacionados en otras tablas',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}

function fnInsertarRegistros(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            waitMsg: 'Por favor Espere...',
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                var Respuesta = req.result.requestedId;
                var Contenido = Respuesta.split('^');
                if(Contenido[0]=="0" || Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                    Ext.getCmp('intIdPaciente').setValue(0);
                    Ext.getCmp('sysPacienteValido').setValue(0);
                    Ext.Msg.hide();
                    Ext.MessageBox.show({
                        title: 'Guardando Paciente',
                        msg: 'Ocurrio un error al guardar la información del paciente o no se pudo establecer conexión con el servidor.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                } else {
                    Ext.getCmp('intIdPaciente').setValue(Contenido[0]);
                    Ext.getCmp('sysPacienteValido').setValue(1);
                    Ext.getCmp('sysInfoPaciente').setValue(Ext.getCmp('strDocID').getValue() + " - " + Ext.getCmp('strNom1').getValue() + " " + Ext.getCmp('strNom2').getValue() + " " + Ext.getCmp('strApe1').getValue() + " " + Ext.getCmp('strApe2').getValue());
                    Ext.getCmp('gridFormulario').store.load({
                        params: {
                            pPaciente: 0
                        }
                    });
                    Ext.getCmp('strProfesionPac').store.reload();
                    Ext.getCmp('btn_AdicionarItemFrm').setVisible(false);
                    Ext.getCmp('btn_ModificarItemFrm').setVisible(true);
                    Ext.MessageBox.hide();
                    Ext.MessageBox.show({
                        title: 'Guardar',
                        msg: 'Se Guardo la Información con Exito.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.INFO
                    });
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.hide();
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.hide();
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

                                                
function fnGuardarRegistros(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            waitMsg: 'Por favor Espere...',
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.hide();
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysInfoPaciente').setValue(Ext.getCmp('strDocID').getValue() + " - " + Ext.getCmp('strNom1').getValue() + " " + Ext.getCmp('strNom2').getValue() + " " + Ext.getCmp('strApe1').getValue() + " " + Ext.getCmp('strApe2').getValue());
                        Ext.getCmp('strProfesionPac').store.reload();
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.reload(arrParam);
                            }
                        }
                        if (typeof pCampoLlave != 'undefined')
                        {
                            if (pCampoLlave != 'NA')
                            {
                                Ext.getCmp(pCampoLlave).setValue(req.result.Data);
                                if (typeof pCampoTextoLlave != 'undefined')
                                    Ext.getCmp(pCampoTextoLlave).setValue("Tarjeta Nro: " + req.result.Data);
                            }
                        }
                        if (typeof pCambiarBotones != 'undefined')
                        {
                            if (pCambiarBotones == 'SI')
                            {
                                Ext.getCmp('btnGuardarDatosBasicosTarjeta').setVisible(false);
                                Ext.getCmp('btnModificarDatosBasicosTarjeta').setVisible(true);
                            }
                        }
                        if(pCerrar == "SI")
                        {
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.hide();
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.hide();
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.hide();
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

