
winHCSALUDOCUPACIONAL001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC - Salud Ocupacional ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;

        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        
        function DescripcionGrid(val, x, store){
            mostrarHC = '<table><tr><td style="padding: 1px;">';
            mostrarHC += val;
            mostrarHC += '</td></tr></table>';
            return mostrarHC;
        }
        
        var stGridHistorialLaboral = new StoreGridHistorialLaboral();
        stGridHistorialLaboral.load({
            params: {
                pPaciente: Ext.getCmp('intIdPaciente').getValue()
            }
        });
            
        this.items = [
            {
                xtype: 'panel',
                layout: 'form',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                padding: 0,
                border: false,
                height: 610,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysYaGuardoAnexo'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'CAS',
                        id: 'sysCASHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Fecha',
                        id: 'sysFechaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Hora',
                        id: 'sysHoraHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Hora',
                        id: 'sysLegalizaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysPacienteHC'
                    },
                    {
                        xtype: 'tabpanel',
                        anchor: '99%',
                        //autoHeight: true,
                        height: 400,
                        border: false,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'HISTORIA CLINICA OCUPACIONAL',
                                //autoHeight: true,
                                //height: 300,
                                autoScroll: true,
                                frame: true,
                                border: false,
                                anchor: '99%',
                                id: 'fichaHCOcupacional',
                                layout: 'form',
                                tbar: {
                                    xtype: 'toolbar',
                                    items: [
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Guardar Historia',
                                            iconCls: 'btnGuardar',
                                            id: 'btnGuardarEvolucion',
                                            listeners:{
                                                click : function(){
                                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                                    {
                                                        Ext.Msg.show({
                                                            title: 'eOfiClinic',
                                                            msg: 'Esta seguro que desea guardar la evolución, si hace esto ya no podra realizar ningun cambio?',
                                                            buttons: Ext.Msg.YESNO,
                                                            icon: Ext.Msg.QUESTION,
                                                            fn: function(btn)
                                                            {
                                                                if(btn=="yes")
                                                                {
                                                                    fnGuardarRegistros();
                                                                }
                                                            }
                                                        });
                                                    }else{
                                                        Ext.Msg.show({
                                                            title: 'eOfiClinic',
                                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                                            buttons: Ext.Msg.YESNO,
                                                            icon: Ext.Msg.QUESTION,
                                                            fn: function(btn)
                                                            {
                                                                if(btn=="yes")
                                                                {
                                                                    fnModificarRegistros();
                                                                }
                                                            }
                                                        });
                                                    }
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'tbfill'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Histroria',
                                            iconCls: 'btnImprimir',
                                            id: 'btnPrintEvolucionFromHC',
                                            listeners:{
                                                click : function(){
                                                    window.open ("../../controlador/asistencial/ofimedicalprinthc_saludocupa001.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('intIdPaciente').getValue() + "&pEvolucion=" + Ext.getCmp('sysCASHC').getValue(),"Historia Clinica");
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Certificado',
                                            iconCls: 'btnImprimir',
                                            id: 'btnPrintCertificadoFromHC',
                                            listeners:{
                                                click : function(){
                                                    window.open ("../../controlador/asistencial/ofimedicalprinthc_socertificado001.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('intIdPaciente').getValue() + "&pEvolucion=" + Ext.getCmp('sysCASHC').getValue(),"Certificado Laboral");
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        }
                                    ]
                                },
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '99%',
                                        id: 'frmHC',
                                        url: '../../controlador/asistencial/saludocupacional.php',
                                        padding: 0,
                                        border: false,
                                        //height: 300,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [ // UNO
                                            {
                                                xtype: 'fieldset',
                                                title: 'INFORMACIÓN TRABAJO ACTUAL',
                                                layout: 'form',
                                                //collapseFirst: false,
                                                collapsible: true,
                                                //animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs1',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Donde Se Realizo el Examen',
                                                        anchor: '99%',
                                                        name: 'cbDeptoMuni',
                                                        allowBlank: false,
                                                        store: 'StoreDeptoMuni',
                                                        //valueField: 'IdDeptoMunicipio',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione Municipio....',
                                                        mode: 'local',
                                                        triggerAction: 'all',
                                                        forceSelection: false,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        //value: "17001",
                                                        id: 'strDeptoMuniRealiza'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Empresa',
                                                        anchor: '100%',
                                                        name: 'EMPRESA',
                                                        allowBlank: false,
                                                        store: 'StoreEmpresaTrabaja',
                                                        forceSelection: false,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'strEmpresaSaludOcupacional'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Tipo Examen',
                                                                width: 100,
                                                                listWidth: 150,
                                                                name: 'TIPO EXAMEN',
                                                                allowBlank: false,
                                                                store: 'StoreTipoExamenSaludOcupacional',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                submitValue: true,
                                                                id: 'strTipoExamen'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys1',
                                                                value: 'EPS:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 180,
                                                                listWidth: 500,
                                                                name: 'EPS',
                                                                allowBlank: false,
                                                                store: 'StoreSGSSEPS',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NO APLICA',
                                                                id: 'strEPS'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys2',
                                                                value: 'PENSION:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 175,
                                                                listWidth: 500,
                                                                name: 'PENSION',
                                                                allowBlank: false,
                                                                store: 'StoreSGSSPENSION',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NO APLICA',
                                                                id: 'strPENSION'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys3',
                                                                value: 'ARP:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 170,
                                                                listWidth: 500,
                                                                name: 'ARP',
                                                                allowBlank: false,
                                                                store: 'StoreSGSSARP',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'DESCONOCIDO',
                                                                id: 'strARP'
                                                            }

                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Cargo',
                                                                name: 'CARGO ACTUAL',
                                                                width: 554,
                                                                allowBlank: false,
                                                                store: 'StoreCargoActual',
                                                                forceSelection: false,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                id: 'strCargoActual'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys4',
                                                                value: 'Fecha Ingreso:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 114,
                                                                name: 'FECHA INGRESO',
                                                                allowBlank: false,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecFechaIngreso'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        columns: 2,
                                                        border: false,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                width: 841,
                                                                layout: 'form',
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        fieldLabel: 'Factores de Riesgo',
                                                                        name: 'FACTORES DE RIESGO',
                                                                        height: 35,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 35,
                                                                        growMax: 400,
                                                                        allowBlank: false,
                                                                        id: 'memFactorRiesgoActual'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                id: 'sysSelectRiesgo',
                                                                items:[
                                                                    {
                                                                        xtype: 'button',
                                                                        iconCls: 'btnBuscar',
                                                                        tooltip: 'Seleccionar Riesgos',
                                                                        id: 'btnSelectRiesgo',
                                                                        listeners:{
                                                                            click : function(){
                                                                                var searchFactoresRiesgo = new winSeleccionarRiesgosUi();
                                                                                searchFactoresRiesgo.show();
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'grid',
                                                title: 'HISTORIAL LABORAL',
                                                id: 'gridHistorialLaboral',
                                                store: stGridHistorialLaboral,
                                                anchor: "100%",
                                                height: 320,
                                                border: false,
                                                frame: true,
                                                loadMask: true,
                                                colModel: new Ext.ux.grid.LockingColumnModel([
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Id',
                                                        sortable: false,
                                                        width: 1,
                                                        hidden: true,
                                                        hideable: false,
                                                        dataIndex: 'idConsecutivo',
                                                        id: 'idConsecutivo'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Paciente',
                                                        sortable: false,
                                                        width: 1,
                                                        hidden: true,
                                                        hideable: false,
                                                        dataIndex: 'idPaciente',
                                                        id: 'idPaciente'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Empresa',
                                                        sortable: false,
                                                        width: 250,
                                                        dataIndex: 'descEmpresa',
                                                        id: 'descEmpresa'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Cargo',
                                                        sortable: false,
                                                        width: 180,
                                                        dataIndex: 'descCargo',
                                                        id: 'descCargo'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Tiempo',
                                                        sortable: false,
                                                        width: 150,
                                                        dataIndex: 'descTiempo',
                                                        id: 'descTiempo'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Riesgo',
                                                        sortable: false,
                                                        width: 150,
                                                        dataIndex: 'descRisego',
                                                        renderer: DescripcionGrid,
                                                        id: 'descRisego'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Elementos Protección',
                                                        sortable: false,
                                                        width: 150,
                                                        dataIndex: 'descElementos',
                                                        renderer: DescripcionGrid,
                                                        id: 'descElementos'
                                                    }
                                                ]),
                                                selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                                                iconCls:'icon-grid',
                                                //view: new Ext.grid.GroupingView(),
                                                tbar:
                                                    {
                                                        xtype: 'toolbar',
                                                        items: [
                                                            {
                                                                xtype: 'button',
                                                                text: 'Adicionar Registro',
                                                                iconCls: 'btnAddRow',
                                                                id: 'btnAddHistorialLaboral',
                                                                listeners: {
                                                                    click : function() {
                                                                        var winHistorialLobral = new winAddHistorialLaboralUi();
                                                                        Ext.getCmp('intPacienteHistoLaboral').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                                        winHistorialLobral.show();
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'tbseparator'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                text: 'Eliminar Registro',
                                                                iconCls: 'btnDelRow',
                                                                id: 'btnDelHistorialLaboral',
                                                                listeners: {
                                                                    click : function() {
                                                                        if(Ext.getCmp('gridHistorialLaboral').selModel.getCount() == 1)
                                                                        {
                                                                            var selections = Ext.getCmp('gridHistorialLaboral').selModel.getSelections();
                                                                            Ext.Msg.show({
                                                                                title: 'Historial Laboral',
                                                                                msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.descEmpresa + ', ' + selections[0].json.descCargo + '?',
                                                                                buttons: Ext.Msg.YESNO,
                                                                                icon: Ext.Msg.QUESTION,
                                                                                fn: function(btn)
                                                                                {
                                                                                    if(btn=="yes")
                                                                                    {
                                                                                        fnEliminarRegistros("../../controlador/asistencial/saludocupacional.php",{task: "ELIMINAR_HISTORIAL_LABORAL", pIdHistorial: selections[0].json.idConsecutivo}, 'gridHistorialLaboral')
                                                                                    }
                                                                                }
                                                                            });
                                                                        }else{
                                                                            Ext.MessageBox.show({
                                                                                title: 'Error',
                                                                                msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                                                buttons: Ext.MessageBox.OK,
                                                                                icon: Ext.MessageBox.ERROR
                                                                            });
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'tbseparator'
                                                            }
                                                        ]
                                                    }
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ENFERMEDAD PROFESIONAL O ACCIDENTES LABORALES',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs2',
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Cuál?',
                                                        name: 'ENFERMEDAD PROFESIONAL O ACCIDENTES LABORALES',
                                                        height: 50,
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: false,
                                                        value: 'NINGUNA',
                                                        id: 'memEnfermedadProfesional'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ENFERMEDAD ACTUAL',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs2_1',
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Cuál?',
                                                        name: 'ENFERMEDAD ACTUAL',
                                                        height: 50,
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: false,
                                                        value: 'ASINTOMATICO ACTUALMENTE\nNO REFIERE SINTOMATOLOGIA EN SU ACTIVIDAD LABORAL ACTUAL',
                                                        id: 'memEnfermedadActual'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES PERSONALES',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs3',
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Cuáles?',
                                                        name: 'ANTECEDENTES PERSONALES',
                                                        height: 50,         
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: false,
                                                        value: 'NINGUNO',
                                                        id: 'memAntecedentesPersonales'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Gineco–Obstétricos',
                                                        name: 'GINECO–OBSTÉTRICOS',
                                                        height: 50,            
                                                        allowBlank: true,
                                                        grow: true,
                                                        minGrow: 50,
                                                        id: 'memAPGineco'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5',
                                                                value: 'Se Realizó Citología Ultimo Año?:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'SE REALIZO CITOLOGIA ULTIMO AÑO',
                                                                width: 100,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                forceSelection: false,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NO',
                                                                id: 'strAPGinecoCitologiaUltimoAno'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: '',
                                                        anchor: '100%',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                fieldLabel: 'Planifica Actualente',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAPPlanificaActualmenteSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys2_l',
                                                                value: 'Metodo:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 340,
                                                                store: 'StoreMetodosPlanificacion',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                allowBlank: true,
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                triggerAction: 'all',
                                                                id: 'strAPPlanificaMetodoSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys2_m',
                                                                value: 'Tiempo:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                allowBlank: true,
                                                                width: 140,
                                                                id: 'strAPPlanificaTiempoSO'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        title: 'Hábitos:',
                                                        unstyled: true,
                                                        layoutConfig: {
                                                            columns: 4
                                                        },
                                                        border: false,
                                                        items: [
                                                            {
                                                                xtype: 'panel', // col1
                                                                width: 105,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: []
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [

                                                                    {
                                                                        xtype: 'combo', // col2
                                                                        fieldLabel: 'Licor',
                                                                        name: 'CONSUME LICOR',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        forceSelection: false,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NO',
                                                                        id: 'strAPHabitoLicor'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col3
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Cigarrillo',
                                                                        name: 'FUMA',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        forceSelection: false,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NO',
                                                                        id: 'strAPHabitoCigarrillo'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col4
                                                                width: 555,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        fieldLabel: 'Otros',
                                                                        name: 'OTROS',
                                                                        anchor: '99%',
                                                                        height: 25,
                                                                        grow: true,
                                                                        growMin: 25,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'strAPHabitosOtros'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col5
                                                                width: 105,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: []
                                                            },
                                                            {
                                                                xtype: 'panel',// col6
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Deporte',
                                                                        name: 'HACE DEPORTE',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        forceSelection: false,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NO',
                                                                        id: 'strAPDeporte',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if (cmb.getValue() == "SI"){
                                                                                    Ext.getCmp('strAPDeporteOtros').enable();
                                                                                    Ext.getCmp('strAPDeporteOtros').allowBlank = false;
                                                                                }else{
                                                                                    Ext.getCmp('strAPDeporteOtros').setValue('');
                                                                                    Ext.getCmp('strAPDeporteOtros').disable();
                                                                                    Ext.getCmp('strAPDeporteOtros').allowBlank = true;
                                                                                    Ext.getCmp('strAPDeporteOtros').clearInvalid();
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',// col7
                                                                width: 665,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                colspan: 2,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        fieldLabel: 'Cuáles Practica?',
                                                                        name: 'CUALES PRACTICA',
                                                                        disabled: true,
                                                                        anchor: '99%',
                                                                        height: 25,
                                                                        grow: true,
                                                                        growMin: 25,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'strAPDeporteOtros'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }

                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES FAMILIARES',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs4',
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Cuál?',
                                                        name: 'ANTECEDENTES FAMILIARES',
                                                        height: 50,     
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: false,
                                                        value: 'NINGUNO',
                                                        id: 'memAntecedentesFamiliares'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'REVISION POR SISTEMAS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs5',
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Respiratorio',
                                                        name: 'RESPIRATORIO',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        id: 'memRSRespiratorio'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Circulatorio',
                                                        name: 'CIRCULATORIO',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        id: 'memRSCirculatorio'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Digestivo',
                                                        name: 'DIGESTIVO',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        id: 'memRSDigestivo'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Metabólico',
                                                        name: 'METABÓLICO',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        id: 'memRSMetabolico'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Hematopoyético',
                                                        name: 'HEMATOPOYÉTICO',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        id: 'memRSHematopoyetico'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Urogenital',
                                                        name: 'UROGENITAL',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        id: 'memRSUrogenital'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Locomotor',
                                                        name: 'LOCOMOTOR',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        id: 'memRSLocomotor'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Nervioso',
                                                        name: 'NERVIOSO',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        id: 'memRSNervioso'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Piel',
                                                        name: 'PIEL',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        id: 'memRSPiel'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Oncológico',
                                                        name: 'ONCOLÓGICO',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        id: 'memRSOncologico'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Traumático',
                                                        name: 'TRAUMÁTICO',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        id: 'memRSTraumatico'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Oftalmológico',
                                                        name: 'OFTALMOLÓGICO',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        id: 'memRSOftalmologico'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Toxicológico',
                                                        name: 'TOXICOLÓGICO',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        id: 'memRSToxicologico'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EXAMEN FISICO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs6',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys7',
                                                                value: 'TA:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 80,
                                                                name:"EXANEN FISICO - TA",
                                                                fieldLabel: 'Signos',
                                                                allowBlank: false,
                                                                id: 'strEF_TA'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys8',
                                                                value: 'FC:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 80,
                                                                allowBlank: false,
                                                                name:"EXANEN FISICO - FC",
                                                                id: 'strEF_FC'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys9',
                                                                value: 'FR:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 80,
                                                                allowBlank: false,
                                                                name:"EXANEN FISICO - FC",
                                                                id: 'strEF_FR'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys10',
                                                                value: 'PESO:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                emptyText: '(Kg)',
                                                                name:"EXANEN FISICO - PESO (Kg)",
                                                                id: 'intEF_Peso',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEF_Peso').setValue(null);
                                                                            Ext.getCmp('intEF_IMC').setValue(0);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('intEF_Talla').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEF_Talla').getValue() / 100; 
                                                                                Ext.getCmp('intEF_IMC').setValue(Ext.getCmp('intEF_Peso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEF_IMC').setValue(0);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys11',
                                                                value: 'TALLA:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                name:"EXANEN FISICO - TALLA (cm)",
                                                                emptyText: '(cm)',
                                                                id: 'intEF_Talla',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEF_Talla').setValue(null);
                                                                            Ext.getCmp('intEF_IMC').setValue(0);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('intEF_Peso').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEF_Talla').getValue() / 100; 
                                                                                Ext.getCmp('intEF_IMC').setValue(Ext.getCmp('intEF_Peso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEF_IMC').setValue(0);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys12',
                                                                value: 'IMC:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                value: 0,
                                                                name:"EXANEN FISICO - IMC",
                                                                id: 'intEF_IMC'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys13',
                                                                value: 'T°:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 70,
                                                                allowBlank: false,
                                                                name:"EXANEN FISICO - TE",
                                                                id: 'strEF_TE'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Biotipo',
                                                                width: 320,
                                                                allowBlank: false,
                                                                store: 'StoreBiotipo',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                name:"EXANEN FISICO - BIOTIPO",
                                                                id: 'strEF_Biotipo'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysT14',
                                                                value: 'Dominancia:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 320,
                                                                allowBlank: false,
                                                                store: 'StoreDominancia',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                name:"EXANEN FISICO - DOMINANCIA",
                                                                id: 'strEF_Dominancia'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<hr>',
                                                        style: 'background:transparent;',
                                                        border: false
                                                    },
                                                    { // Tabla Examen Fisico
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        unstyled: true,
                                                        layoutConfig: {
                                                            columns: 5
                                                        },
                                                        border: false,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 1.1
                                                                        fieldLabel: 'Aspecto General',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - ASPECTO GENERAL",
                                                                        id: 'strEF_AspectoGeneral',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_AspectoGeneralH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_AspectoGeneralH').setValue(null);
                                                                                    Ext.getCmp('memEF_AspectoGeneralH').disable();
                                                                                    Ext.getCmp('memEF_AspectoGeneralH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_AspectoGeneralH').enable();
                                                                                    Ext.getCmp('memEF_AspectoGeneralH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 1.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - DOMINANCIA - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_AspectoGeneralH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Piel y Faneras',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - PIEL Y FANERAS",
                                                                        id: 'strEF_PielFaneras',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_PielFanerasH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_PielFanerasH').setValue(null);
                                                                                    Ext.getCmp('memEF_PielFanerasH').disable();
                                                                                    Ext.getCmp('memEF_PielFanerasH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_PielFanerasH').enable();
                                                                                    Ext.getCmp('memEF_PielFanerasH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - PIEL Y FANERAS - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_PielFanerasH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 3.1
                                                                        fieldLabel: 'Ojos',
                                                                        name:"EXANEN FISICO - OJOS",
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        id: 'strEF_Ojos',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_OjosH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_OjosH').setValue(null);
                                                                                    Ext.getCmp('memEF_OjosH').disable();
                                                                                    Ext.getCmp('memEF_OjosH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_OjosH').enable();
                                                                                    Ext.getCmp('memEF_OjosH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 3.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - OJOS - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_OjosH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 4.1
                                                                width: 105,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: []
                                                            },
                                                            {
                                                                xtype: 'panel', // col 4.2
                                                                width: 150,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        style: 'text-align:center;',
                                                                        fieldLabel: 'AV.Lejana:OD',
                                                                        name: 'AV.LEJANA:OD',
                                                                        value: '20/',
                                                                        width: 80,
                                                                        allowBlank: true,
                                                                        id: 'strEF_AVLejanaOD'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 4.3
                                                                width: 150,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        style: 'text-align:center;',
                                                                        fieldLabel: 'AV.Lejana:OI',
                                                                        name: 'AV.LEJANA:OI',
                                                                        value: '20/',
                                                                        width: 80,
                                                                        allowBlank: true,
                                                                        id: 'strEF_AVLejanaOI'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 4.4
                                                                width: 150,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        style: 'text-align:center;',
                                                                        fieldLabel: 'AV.Cercana: OD',
                                                                        nameLabel: 'AV.CERCANA: OD',
                                                                        value: '20/',
                                                                        width: 80,
                                                                        allowBlank: true,
                                                                        id: 'strEF_AVCercanaOD'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 4.5
                                                                width: 150,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        style: 'text-align:center;',
                                                                        fieldLabel: 'AV.Cercana: OI',
                                                                        name: 'AV.CERCANA: OI',
                                                                        value: '20/',
                                                                        width: 80,
                                                                        allowBlank: true,
                                                                        id: 'strEF_AVCercanaOI'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Oidos',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - OIDOS",
                                                                        id: 'strEF_Oidos',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_OidosH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_OidosH').setValue(null);
                                                                                    Ext.getCmp('memEF_OidosH').disable();
                                                                                    Ext.getCmp('memEF_OidosH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_OidosH').enable();
                                                                                    Ext.getCmp('memEF_OidosH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - OIDOS - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_OidosH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Nariz',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - NARIZ",
                                                                        id: 'strEF_Nariz',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_NarizH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_NarizH').setValue(null);
                                                                                    Ext.getCmp('memEF_NarizH').disable();
                                                                                    Ext.getCmp('memEF_NarizH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_NarizH').enable();
                                                                                    Ext.getCmp('memEF_NarizH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - NARIZ - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_NarizH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Boca',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - BOCA",
                                                                        id: 'strEF_Boca',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_BocaH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_BocaH').setValue(null);
                                                                                    Ext.getCmp('memEF_BocaH').disable();
                                                                                    Ext.getCmp('memEF_BocaH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_BocaH').enable();
                                                                                    Ext.getCmp('memEF_BocaH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - BOCA - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_BocaH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Cuello',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - CUELLO",
                                                                        id: 'strEF_Cuello',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_CuelloH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_CuelloH').setValue(null);
                                                                                    Ext.getCmp('memEF_CuelloH').disable();
                                                                                    Ext.getCmp('memEF_CuelloH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_CuelloH').enable();
                                                                                    Ext.getCmp('memEF_CuelloH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - CUELLO - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_CuelloH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Tórax',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - TORAX",
                                                                        id: 'strEF_Torax',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_ToraxH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_ToraxH').setValue(null);
                                                                                    Ext.getCmp('memEF_ToraxH').disable();
                                                                                    Ext.getCmp('memEF_ToraxH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_ToraxH').enable();
                                                                                    Ext.getCmp('memEF_ToraxH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - TORAX - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_ToraxH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 4.1
                                                                width: 105,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: []
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Inspección',
                                                                        anchor: '100%', //width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - TORAX - INSPECCIÓN",
                                                                        id: 'strEF_ToraxInspeccion',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_ToraxInspeccionH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_ToraxInspeccionH').setValue(null);
                                                                                    Ext.getCmp('memEF_ToraxInspeccionH').disable();
                                                                                    Ext.getCmp('memEF_ToraxInspeccionH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_ToraxInspeccionH').enable();
                                                                                    Ext.getCmp('memEF_ToraxInspeccionH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 615,
                                                                colspan:3,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - TORAX - INSPECCIÓN - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_ToraxInspeccionH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 4.1
                                                                width: 105,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: []
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Auscultación',
                                                                        anchor: '100%',
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - TORAX - AUSCULTACIÓN",
                                                                        id: 'strEF_ToraxAuscultacion',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_ToraxAuscultacionH').setValue("RsCs: RITMICOS REGULARES SIN SOPLOS\nRsRs: MURMULLO VESICULAR LIMPIO");
                                                                                }else{
                                                                                    Ext.getCmp('memEF_ToraxAuscultacionH').setValue(null);
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 615,
                                                                colspan:3,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - TORAX - AUSCULTACIÓN - HALLAZGOS",
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: false,
                                                                        value: 'RsCs: RITMICOS REGULARES SIN SOPLOS\nRsRs: MURMULLO VESICULAR LIMPIO',
                                                                        id: 'memEF_ToraxAuscultacionH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 4.1
                                                                width: 105,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: []
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Palpación',
                                                                        anchor: '100%',
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - TORAX - PALPACIÓN",
                                                                        id: 'strEF_ToraxPalpacion',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_ToraxPalpacionH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_ToraxPalpacionH').setValue(null);
                                                                                    Ext.getCmp('memEF_ToraxPalpacionH').disable();
                                                                                    Ext.getCmp('memEF_ToraxPalpacionH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_ToraxPalpacionH').enable();
                                                                                    Ext.getCmp('memEF_ToraxPalpacionH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 615,
                                                                colspan:3,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - TORAX - PALPACIÓN - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_ToraxPalpacionH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', 
                                                                        fieldLabel: 'Mamas',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - MAMAS",
                                                                        id: 'strEF_Mamas',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_MamasH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_MamasH').setValue(null);
                                                                                    Ext.getCmp('memEF_MamasH').disable();
                                                                                    Ext.getCmp('memEF_MamasH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_MamasH').enable();
                                                                                    Ext.getCmp('memEF_MamasH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - MAMAS - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_MamasH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Abdomen',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - ABDOMEN",
                                                                        id: 'strEF_Abdomen',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_AbdomenH').setValue("RsIs: POSITIVOS NORMALES");
                                                                                }else{
                                                                                    Ext.getCmp('memEF_AbdomenH').setValue(null);
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - ABDOMEN - HALLAZGOS",
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: false,
                                                                        value: 'RsIs: POSITIVOS NORMALES, NO MASAS, NO HERNIAS',
                                                                        id: 'memEF_AbdomenH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 4.1
                                                                width: 105,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: []
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Inspección',
                                                                        anchor: '100%', //width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - ABDOMEN - INSPECCIÓN",
                                                                        id: 'strEF_AbdomenInspeccion',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_AbdomenInspeccionH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_AbdomenInspeccionH').setValue(null);
                                                                                    Ext.getCmp('memEF_AbdomenInspeccionH').disable();
                                                                                    Ext.getCmp('memEF_AbdomenInspeccionH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_AbdomenInspeccionH').enable();
                                                                                    Ext.getCmp('memEF_AbdomenInspeccionH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 615,
                                                                colspan:3,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - ABDOMEN - INSPECCIÓN - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_AbdomenInspeccionH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 4.1
                                                                width: 105,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: []
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Auscultación',
                                                                        anchor: '100%',
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - ABDOMEN - AUSCULTACIÓN",
                                                                        id: 'strEF_AbdomenAuscultacion',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_AbdomenAuscultacionH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_AbdomenAuscultacionH').setValue(null);
                                                                                    Ext.getCmp('memEF_AbdomenAuscultacionH').disable();
                                                                                    Ext.getCmp('memEF_AbdomenAuscultacionH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_AbdomenAuscultacionH').enable();
                                                                                    Ext.getCmp('memEF_AbdomenAuscultacionH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 615,
                                                                colspan:3,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - ABDOMEN - AUSCULTACIÓN - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_AbdomenAuscultacionH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 4.1
                                                                width: 105,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: []
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Palpación',
                                                                        anchor: '100%',
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - ABDOMEN - PALPACIÓN",
                                                                        id: 'strEF_AbdomenPalpacion',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_AbdomenPalpacionH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_AbdomenPalpacionH').setValue(null);
                                                                                    Ext.getCmp('memEF_AbdomenPalpacionH').disable();
                                                                                    Ext.getCmp('memEF_AbdomenPalpacionH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_AbdomenPalpacionH').enable();
                                                                                    Ext.getCmp('memEF_AbdomenPalpacionH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 615,
                                                                colspan:3,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - ABDOMEN - PALPACIÓN - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_AbdomenPalpacionH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', 
                                                                        fieldLabel: 'Miembros Sup.',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - MIEMBROS SUPERIORES",
                                                                        id: 'strEF_MiembrosSup',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_MiembrosSupH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_MiembrosSupH').setValue(null);
                                                                                    Ext.getCmp('memEF_MiembrosSupH').disable();
                                                                                    Ext.getCmp('memEF_MiembrosSupH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_MiembrosSupH').enable();
                                                                                    Ext.getCmp('memEF_MiembrosSupH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - MIEMBROS SUPERIORES - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_MiembrosSupH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 4.1
                                                                width: 105,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: []
                                                            },
                                                            {
                                                                xtype: 'panel', // col 4.2
                                                                width: 150,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', 
                                                                        fieldLabel: 'Tinnel',
                                                                        anchor: '100%',
                                                                        allowBlank: false,
                                                                        store: 'StorePositivoNegativo',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NEGATIVO (-)',
                                                                        name:"EXANEN FISICO - MIEMBROS SUPERIORES - TINNEL",
                                                                        id: 'strEF_MiembrosSupTinnel'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 4.2
                                                                width: 150,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                colspan: 3,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', 
                                                                        fieldLabel: 'Phalen',
                                                                        anchor: '100%',
                                                                        allowBlank: false,
                                                                        store: 'StorePositivoNegativo',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NEGATIVO (-)',
                                                                        name:"EXANEN FISICO - MIEMBROS SUPERIORES - PHALEN",
                                                                        id: 'strEF_MiembrosSupPhalen'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', 
                                                                        fieldLabel: 'Miembros Inf.',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - MIEMBROS INFERIORES",
                                                                        id: 'strEF_MiembrosInf',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_MiembrosInfH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_MiembrosInfH').setValue(null);
                                                                                    Ext.getCmp('memEF_MiembrosInfH').disable();
                                                                                    Ext.getCmp('memEF_MiembrosInfH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_MiembrosInfH').enable();
                                                                                    Ext.getCmp('memEF_MiembrosInfH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - MIEMBROS INFERIORES - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_MiembrosInfH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Columna Vertebral',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - COLUMNA VERTEBRAL",
                                                                        id: 'strEF_Columna',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_ColumnaH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_ColumnaH').setValue(null);
                                                                                    Ext.getCmp('memEF_ColumnaH').disable();
                                                                                    Ext.getCmp('memEF_ColumnaH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_ColumnaH').enable();
                                                                                    Ext.getCmp('memEF_ColumnaH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - COLUMNA VERTEBRAL - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_ColumnaH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 4.1
                                                                width: 105,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: []
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Inspección',
                                                                        anchor: '100%', //width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - COLUMNA VERTEBRAL - INSPECCIÓN",
                                                                        id: 'strEF_ColumnaInspeccion',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_ColumnaInspeccionH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_ColumnaInspeccionH').setValue(null);
                                                                                    Ext.getCmp('memEF_ColumnaInspeccionH').disable();
                                                                                    Ext.getCmp('memEF_ColumnaInspeccionH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_ColumnaInspeccionH').enable();
                                                                                    Ext.getCmp('memEF_ColumnaInspeccionH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 615,
                                                                colspan:3,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - COLUMNA VERTEBRAL - INSPECCIÓN - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_ColumnaInspeccionH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 4.1
                                                                width: 105,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: []
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Palpación',
                                                                        anchor: '100%',
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - COLUMNA VERTEBRAL - PALPACIÓN",
                                                                        id: 'strEF_ColumnaPalpacion',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_ColumnaPalpacionH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_ColumnaPalpacionH').setValue(null);
                                                                                    Ext.getCmp('memEF_ColumnaPalpacionH').disable();
                                                                                    Ext.getCmp('memEF_ColumnaPalpacionH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_ColumnaPalpacionH').enable();
                                                                                    Ext.getCmp('memEF_ColumnaPalpacionH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 615,
                                                                colspan:3,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - COLUMNA VERTEBRAL - PALPACIÓN - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_ColumnaPalpacionH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', 
                                                                        fieldLabel: 'Genitales',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormalNoEvalua',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NO SE EVALUA',
                                                                        name:"EXANEN FISICO - GENITALES",
                                                                        id: 'strEF_Genitales',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_GenitalesH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_GenitalesH').setValue(null);
                                                                                    Ext.getCmp('memEF_GenitalesH').disable();
                                                                                    Ext.getCmp('memEF_GenitalesH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_GenitalesH').enable();
                                                                                    Ext.getCmp('memEF_GenitalesH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - GENITALES - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        value: "NO SE EXPLORA",
                                                                        id: 'memEF_GenitalesH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', 
                                                                        fieldLabel: 'Neurologico',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - NEUROLOGICO",
                                                                        id: 'strEF_Neurologico',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_NeurologicoH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_NeurologicoH').setValue(null);
                                                                                    Ext.getCmp('memEF_NeurologicoH').disable();
                                                                                    Ext.getCmp('memEF_NeurologicoH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_NeurologicoH').enable();
                                                                                    Ext.getCmp('memEF_NeurologicoH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - NEUROLOGICO - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_NeurologicoH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', 
                                                                        fieldLabel: 'Esf. Mental',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - ESFERA MENTAL",
                                                                        id: 'strEF_EsfMental',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(Ext.getCmp('strEF_EsfMental').getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_EsfMentalH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_EsfMentalH').setValue(null);
                                                                                    Ext.getCmp('memEF_EsfMentalH').disable();
                                                                                    Ext.getCmp('memEF_EsfMentalH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_EsfMentalH').enable();
                                                                                    Ext.getCmp('memEF_EsfMentalH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - ESFERA MENTAL - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_EsfMentalH'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'PARACLINICOS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs10',
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Descripción',
                                                        anchor: '100%',
                                                        height: 50,            
                                                        allowBlank: false,
                                                        value: 'NINGUNO',
                                                        name: 'PARACLINICOS',
                                                        id: 'memParaclinicos'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'DIAGNOSTICO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs11',
                                                items: [
                                                    {
                                                        xtype: 'combo', 
                                                        fieldLabel: 'Paciente Sano',
                                                        name: 'PACIENTE SANO',
                                                        width: 100,
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        value: 'SI',
                                                        id: 'strDx_PacienteSano'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: '1',
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 15,
                                                        id: 'sysCausaExternaHC'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Otros Diagnosticos Relacionados',
                                                        name: 'Otros Diagnosticos Relacionados',
                                                        height: 50, 
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        value: 'PACIENTE SANO',
                                                        id: 'memResumenDx'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CONCEPTO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs13',
                                                items: [
                                                     {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        columns: 3,
                                                        border: false,
                                                        items: [
                                                            {
                                                                xtype: 'panel', // col 4.1
                                                                width: 105,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: []
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 400,
                                                                layout: 'form',
                                                                labelWidth: 250,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'APTO SIN RESTRICCIONES',
                                                                        name: 'APTO SIN RESTRICCIONES',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCONCEPAptoSinRest'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'APTO CON RESTRICCIONES',
                                                                        name: 'APTO CON RESTRICCIONES',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCONCEPAptoConRest'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'APTO CON CONDICIONES',
                                                                        name: 'APTO CON CONDICIONES',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCONCEPAptoConCondi'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'NO APTO TEMPORALMENTE',
                                                                        name: 'NO APTO TEMPORALMENTE',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCONCEPNoAptoTempo'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'NO APTO',
                                                                        name: 'NO APTO',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCONCEPNoApto'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 400,
                                                                layout: 'form',
                                                                labelWidth: 250,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'APTO PARA TRABAJAR EN ALTURAS',
                                                                        name: 'APTO PARA TRABAJAR EN ALTURAS',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCONCEPAptoTrabajoAlturas'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'POSIBLE PATOLOGIA ORIGEN LABORAL',
                                                                        name: 'POSIBLE PATOLOGIA ORIGEN LABORAL',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCONCEPPatologiaLaboral'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'CON SECUELAS DE ACCIDENTE LABORAL',
                                                                        name: 'CON SECUELAS DE ACCIDENTE LABORAL',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCONCEPSecuelasLaboral'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'EXAMEN PERIODICO NORMAL',
                                                                        name: 'EXAMEN PERIODICO NORMAL',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCONCEPExamenPeriodicoNormal'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'EXAMEN RETIRO NORMAL',
                                                                        name: 'EXAMEN RETIRO NORMAL',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCONCEPExamenRetiroNormal'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                     },
                                                     {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Descripción',
                                                        height: 50,            
                                                        grow: true,
                                                        minGrow: true,
                                                        allowBlank: true,
                                                        id: 'memConcepto'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'TIPO DE RESTRICCIONES O CAUSA DE APLAZAMIENTO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs12',
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Descripción',
                                                        name: 'TIPO DE RESTRICCIONES O CAUSA DE APLAZAMIENTO',
                                                        height: 50,            
                                                        grow: true,
                                                        minGrow: true,
                                                        allowBlank: false,
                                                        value: 'NINGUNO',
                                                        id: 'memRestricciones'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RECOMENDACIONES Y OBSERVACIONES',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs15',
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        columns: 3,
                                                        border: false,
                                                        items: [
                                                            {
                                                                xtype: 'panel', // col 4.1
                                                                width: 105,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: []
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 400,
                                                                layout: 'form',
                                                                labelWidth: 250,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'USO ADECUADO DE ELEMENTOS DE PROTECCION',
                                                                        name: 'USO ADECUADO DE ELEMENTOS DE PROTECCION',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENUsoAdecuadoElem'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'CONTROL ANUAL POR OPTOMETRIA EN LA EPS',
                                                                        name: 'CONTROL ANUAL POR OPTOMETRIA EN LA EPS',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENControlAnualOptometria'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'REALIZAR PAUSAS ACTIVAS',
                                                                        name: 'REALIZAR PAUSAS ACTIVAS',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENRealizaPausasActivas'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'DEBE CERTIFICARSE PARA TRABAJAR EN ALTURAS',
                                                                        name: 'DEBE CERTIFICARSE PARA TRABAJAR EN ALTURAS',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENCertificarTrabajoAlturas'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'USAR MEDIAS DE SOPORTE ELASTICO PARA VARICES',
                                                                        name: 'USAR MEDIAS DE SOPORTE ELASTICO PARA VARICES',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENUsarMediasVarices'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'REALIZAR CITOLOGIA ANUAL',
                                                                        name: 'REALIZAR CITOLOGIA ANUAL',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENRealizarCitologia'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'REALIZAR DIETA, EJERCICIO Y REDUCIR PESO',
                                                                        name: 'REALIZAR DIETA, EJERCICIO Y REDUCIR PESO',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENRealizarDietaEjercicio'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 400,
                                                                layout: 'form',
                                                                labelWidth: 250,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'EVALUAR POR NUTRICION EN LA EPS',
                                                                        name: 'EVALUAR POR NUTRICION EN LA EPS',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENEvaluarxNutricion'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'DEJAR EL HABITO DE FUMAR',
                                                                        name: 'DEJAR EL HABITO DE FUMAR',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENDejarFumar'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'DISMINUIR CONSUMO DE ALCOHOL',
                                                                        name: 'DISMINUIR CONSUMO DE ALCOHOL',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENDisminuirConsumoAlcohol'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'INGRESAR AL SISTEMA DE VIGILANCIA EPIDEMIOLOGICA',
                                                                        name: 'INGRESAR AL SISTEMA DE VIGILANCIA EPIDEMIOLOGICA',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENIngresarProgaEpidemio'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'REALIZAR PRUEBAS PARA MANIPULACION DE ALIMENTOS',
                                                                        name: 'REALIZAR PRUEBAS PARA MANIPULACION DE ALIMENTOS',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENPruebasManipulaAlimentos'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'REALIZAR PRUEBAS COMPLEMENTARIAS',
                                                                        name: 'REALIZAR PRUEBAS COMPLEMENTARIAS',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENPruebasComplementarias'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Otros',
                                                        name: 'OTROS',
                                                        height: 50,            
                                                        grow: true,
                                                        minGrow: true,
                                                        allowBlank: true,
                                                        id: 'memRECOMENOtros'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'ANEXO OSTEOMUSCULAR',
                                //autoHeight: true,
                                //height: 300,
                                autoScroll: true,
                                frame: true,
                                border: false,
                                id: 'fichaAnexo',
                                layout: 'form',
                                tbar: {
                                    xtype: 'toolbar',
                                    items: [
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Guardar Anexo',
                                            iconCls: 'btnGuardar',
                                            id: 'btnGuardarAnexo',
                                            listeners:{
                                                click : function(){
                                                    if (Ext.getCmp('sysYaGuardoAnexo').getValue() == 0) {
                                                        fnGuardarRegistrosAnexo();
                                                    }else{
                                                        fnModificarRegistrosAnexo();
                                                    }
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'tbfill'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Anexo Osteomuscular',
                                            iconCls: 'btnImprimir',
                                            id: 'btnPrintAnexoFromHC',
                                            listeners:{
                                                click : function(){
                                                    window.open ("../../controlador/asistencial/ofimedicalprinthc_soanexoosteo001.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('intIdPaciente').getValue() + "&pEvolucion=" + Ext.getCmp('sysCASHC').getValue(),"Anexo Osteomuscular");
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        }
                                    ]
                                },
                                items: [
                                     {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '99%',
                                        id: 'frmAnexoOsteo',
                                        url: '../../controlador/asistencial/saludocupacional.php',
                                        padding: 0,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'fieldset',
                                                title: 'LA ACTIVIDADES LAS REALIZA:',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fsREALIAACTIV',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'systxtaCTIVrEALIZA1',
                                                                value: 'Sentado:'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAORealizaActividadesSentado'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'systxtaCTIVrEALIZA2',
                                                                value: 'De Pie:'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAORealizaActividadesPie'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'systxtaCTIVrEALIZA3',
                                                                value: 'Inclinado:'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAORealizaActividadesInclinado'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'systxtaCTIVrEALIZA4',
                                                                value: 'Arrodillado:'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAORealizaActividadesArrodillado'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'systxtaCTIVrEALIZA5',
                                                                value: 'Caminando:'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAORealizaActividadesCaminando'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'systxtaCTIVrEALIZA6',
                                                                value: 'Otro:'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAORealizaActividadesOtro'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'systxtaCTIVrEALIZA7',
                                                                value: 'Cual:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 300,
                                                                allowBlank: true,
                                                                id: 'strAORealizaActividadesCual'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ACCIONES QUE REALIZA:',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fsACCIOONESREALIZA',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'systxtAccionRealiza1',
                                                                value: 'Alcanzar:'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAORealizaActividadesAlcanzar'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'systxtAccionRealiza2',
                                                                value: 'Halar:'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAORealizaActividadesHalar'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'systxtAccionRealiza3',
                                                                value: 'Empujar:'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAORealizaActividadesEmpujar'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'systxtAccionRealiza4',
                                                                value: 'Levantar:'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAORealizaActividadesLevantar'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'systxtAccionRealiza5',
                                                                value: 'Arrastrar:'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAORealizaActividadesArrastrar'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'systxtAccionRealiza6',
                                                                value: 'Otra:'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAORealizaActividadesOtra'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'systxtAccionRealiza7',
                                                                value: 'Cual:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 300,
                                                                allowBlank: true,
                                                                id: 'strAORealizaActividadesOtraCual'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'PARA REALIZAR LO ANTERIOR CUENTA CON AYUDA:',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fsREALIZAAYUDA',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent; text-align:left;',
                                                        items: [
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'systxtRealizaAyuda1',
                                                                value: 'Mecanica:'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAORealizaAyudaMecanica'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'systxtRealizaAyuda2',
                                                                value: 'De Otra Persona:'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAORealizaAyudaOtraPersona'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'systxtRealizaAyuda3a',
                                                                value: 'Ninguna:'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAORealizaAyudaNinguna'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'systxtRealizaAyuda3',
                                                                value: 'Otra:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 300,
                                                                allowBlank: true,
                                                                id: 'strAORealizaAyudaOtra'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: '',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fsAOOTRO',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent; text-align:left;',
                                                        items: [
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'systxtAOOtro1',
                                                                value: 'REALIZA MOVIMIENTOS REPETITIVOS:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                submitValue: true,
                                                                value: 'NO',
                                                                id: 'strAOMovRepetitivos'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'systxtAOOtro2',
                                                                value: 'USA TERMINALES DE COMPUTO:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                submitValue: true,
                                                                value: 'NO',
                                                                id: 'strAOUsaTerminalComputo'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'SINTOMAS ACTUALES',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fsAOSINTOMAS',
                                                items: [
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'ESPASMO MUSCULAR',
                                                        layout: 'form',
                                                        collapsible: false,
                                                        animCollapse: false,
                                                        titleCollapse: false,
                                                        labelWidth: 120,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        id: 'fsAOEF_EM',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent; text-align:left;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'DURANTE LABORES',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        submitValue: true,
                                                                        value: 'NO',
                                                                        id: 'strAOSintomaEspasmoMuscularLAB'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'systxtAOSintomas2',
                                                                        value: 'EN REPOSO:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        submitValue: true,
                                                                        value: 'NO',
                                                                        id: 'strAOSintomaEspasmoMuscularREP'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 430,
                                                                        allowBlank: true,
                                                                        emptyText: 'PARTE DEL CUERPO AFECTADA',
                                                                        id: 'strAOSintomasEspasmoMuscularH'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'MIALGIAS',
                                                        layout: 'form',
                                                        collapsible: false,
                                                        animCollapse: false,
                                                        titleCollapse: false,
                                                        labelWidth: 120,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        id: 'fsAOEF_MIAL',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent; text-align:left;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'DURANTE LABORES',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        submitValue: true,
                                                                        value: 'NO',
                                                                        id: 'strAOSintomaMialgiasLAB'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'systxtAOSintomas5',
                                                                        value: 'EN REPOSO:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        submitValue: true,
                                                                        value: 'NO',
                                                                        id: 'strAOSintomaMialgiasREP'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 430,
                                                                        emptyText: 'PARTE DEL CUERPO AFECTADA',
                                                                        allowBlank: true,
                                                                        id: 'strAOMialgiasH'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'ARTRALGIAS',
                                                        layout: 'form',
                                                        collapsible: false,
                                                        animCollapse: false,
                                                        titleCollapse: false,
                                                        labelWidth: 120,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        id: 'fsAOEF_ARTRAL',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent; text-align:left;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'DURANTE LABORES',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        submitValue: true,
                                                                        value: 'NO',
                                                                        id: 'strAOSintomaArtralgiasLAB'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'systxtAOSintomas8',
                                                                        value: 'EN REPOSO:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        submitValue: true,
                                                                        value: 'NO',
                                                                        id: 'strAOSintomaArtralgiasREP'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 430,
                                                                        emptyText: 'PARTE DEL CUERPO AFECTADA',
                                                                        allowBlank: true,
                                                                        id: 'strAOArtralgiasH'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'ADORMECIMIENTO, HORMIGUEOS O DISMINUCION DE FUERZZA EN MsSs',
                                                        layout: 'form',
                                                        collapsible: false,
                                                        animCollapse: false,
                                                        titleCollapse: false,
                                                        labelWidth: 120,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        id: 'fsAOSINT_MS',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent; text-align:left;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'DURANTE LABORES',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        submitValue: true,
                                                                        value: 'NO',
                                                                        id: 'strAOSintomaMsSsLAB'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'systxtAOSintomas11',
                                                                        value: 'EN REPOSO:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        submitValue: true,
                                                                        value: 'NO',
                                                                        id: 'strAOSintomaMsSsREP'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 430,
                                                                        emptyText: 'PARTE DEL CUERPO AFECTADA',
                                                                        allowBlank: true,
                                                                        id: 'strAOMsSsH'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'ADORMECIMIENTO, HORMIGUEOS O DISMINUCION DE FUERZZA EN MsIs',
                                                        layout: 'form',
                                                        collapsible: false,
                                                        animCollapse: false,
                                                        titleCollapse: false,
                                                        labelWidth: 120,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        id: 'fsAOSINT_MI',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent; text-align:left;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'DURANTE LABORES',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        submitValue: true,
                                                                        value: 'NO',
                                                                        id: 'strAOSintomaMsIsLAB'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'systxtAOSintomas14',
                                                                        value: 'EN REPOSO:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        submitValue: true,
                                                                        value: 'NO',
                                                                        id: 'strAOSintomaMsIsREP'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 430,
                                                                        emptyText: 'PARTE DEL CUERPO AFECTADA',
                                                                        allowBlank: true,
                                                                        id: 'strAOMsIsH'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EXAMEN FISICO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fsAOEF',
                                                items: [
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'COLUMNA VERTEBRAL',
                                                        layout: 'form',
                                                        collapsible: false,
                                                        animCollapse: false,
                                                        titleCollapse: false,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        id: 'fsAOEF_CV',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Curvaturas',
                                                                        width: 150,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        id: 'strAO_EF_ColumnaCurvaturaNA'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 555,
                                                                        allowBlank: true,
                                                                        id: 'strAO_EF_ColumnaCurvaturaH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Palpacion',
                                                                        width: 150,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        id: 'strAO_EF_ColumnaPalpacionNA'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 555,
                                                                        allowBlank: true,
                                                                        id: 'strAO_EF_ColumnaPalpacionH'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'MIEMBROS SUPERIORES ARCOS DE MOVIMIENTO',
                                                        layout: 'form',
                                                        collapsible: false,
                                                        animCollapse: false,
                                                        titleCollapse: false,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        id: 'fsAOEF_MS',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'HOMBRO',
                                                                        width: 150,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        id: 'strAO_EF_MSHombroNA'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 555,
                                                                        allowBlank: true,
                                                                        id: 'strAO_EF_MSHombroH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'CODO',
                                                                        width: 150,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        id: 'strAO_EF_MSCodoNA'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 555,
                                                                        allowBlank: true,
                                                                        id: 'strAO_EF_MSCodoH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'MANOS-DEDOS',
                                                                        width: 150,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        id: 'strAO_EF_MSManosNA'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 555,
                                                                        allowBlank: true,
                                                                        id: 'strAO_EF_MSManosH'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'MIEMBROS INFERIORES PALPACION Y ARCOS DE MOVIMIENTO',
                                                        layout: 'form',
                                                        collapsible: false,
                                                        animCollapse: false,
                                                        titleCollapse: false,
                                                        anchor: '99%',
                                                        autoHeight: true,
                                                        id: 'fsAOEF_MI',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'CADERAS',
                                                                        width: 150,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        id: 'strAO_EF_MSCaderasNA'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 555,
                                                                        allowBlank: true,
                                                                        id: 'strAO_EF_MSCaderasH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'RODILLAS',
                                                                        width: 150,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        id: 'strAO_EF_MSRodillasNA'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 555,
                                                                        allowBlank: true,
                                                                        id: 'strAO_EF_MSRodillasH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'TOBILLOS-PIES',
                                                                        width: 150,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        id: 'strAO_EF_MSTobillosNA'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 555,
                                                                        allowBlank: true,
                                                                        id: 'strAO_EF_MSTobillosH'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EXAMEN NEUROLOGICO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fsAOEN',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'TONO',
                                                                width: 150,
                                                                allowBlank: false,
                                                                store: 'StoreNormalAnormal',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NORMAL',
                                                                id: 'strAO_EN_TonoNA'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 565,
                                                                allowBlank: true,
                                                                id: 'strAO_EN_TonosH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'FUERZA',
                                                                width: 150,
                                                                allowBlank: false,
                                                                store: 'StoreNormalAnormal',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NORMAL',
                                                                id: 'strAO_EN_FuerzaNA'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 565,
                                                                allowBlank: true,
                                                                id: 'strAO_EN_FuerzaH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'SENSIBILIDAD',
                                                                width: 150,
                                                                allowBlank: false,
                                                                store: 'StoreNormalAnormal',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NORMAL',
                                                                id: 'strAO_EN_SensibilidadNA'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 565,
                                                                allowBlank: true,
                                                                id: 'strAO_EN_SensibilidadH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'MARCHA',
                                                                width: 150,
                                                                allowBlank: false,
                                                                store: 'StoreNormalAnormal',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NORMAL',
                                                                id: 'strAO_EN_MarchaNA'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 565,
                                                                allowBlank: true,
                                                                id: 'strAO_EN_MarchaH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'PUNTAS',
                                                                width: 150,
                                                                allowBlank: false,
                                                                store: 'StoreNormalAnormal',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NORMAL',
                                                                id: 'strAO_EN_PuntasNA'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 565,
                                                                allowBlank: true,
                                                                id: 'strAO_EN_PuntasH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'TALONES',
                                                                width: 150,
                                                                allowBlank: false,
                                                                store: 'StoreNormalAnormal',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NORMAL',
                                                                id: 'strAO_EN_TalonesNA'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 565,
                                                                allowBlank: true,
                                                                id: 'strAO_EN_TalonesH'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'PRUEBAS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fsAOPRU',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'systxtAOPruebas1',
                                                                value: 'DERECHA:'
                                                            },
                                                            {
                                                                xtype: 'combo', 
                                                                fieldLabel: 'TINNEL',
                                                                anchor: '100%',
                                                                allowBlank: false,
                                                                store: 'StorePositivoNegativo',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NEGATIVO (-)',
                                                                id: 'strAO_PrueblasTinnelD'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'systxtAOPruebas2',
                                                                value: 'IZQUIERDA:'
                                                            },
                                                            {
                                                                xtype: 'combo', 
                                                                anchor: '100%',
                                                                allowBlank: false,
                                                                store: 'StorePositivoNegativo',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NEGATIVO (-)',
                                                                id: 'strAO_PrueblasTinnelI'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'systxtAOPruebas3',
                                                                value: 'DERECHA:'
                                                            },
                                                            {
                                                                xtype: 'combo', 
                                                                fieldLabel: 'FINKELSTEIN',
                                                                anchor: '100%',
                                                                allowBlank: false,
                                                                store: 'StorePositivoNegativo',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NEGATIVO (-)',
                                                                id: 'strAO_PrueblasFinkelD'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'systxtAOPruebas4',
                                                                value: 'IZQUIERDA:'
                                                            },
                                                            {
                                                                xtype: 'combo', 
                                                                anchor: '100%',
                                                                allowBlank: false,
                                                                store: 'StorePositivoNegativo',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NEGATIVO (-)',
                                                                id: 'strAO_PrueblasFinkelI'
                                                            }
                                                        ]
                                                    }, 
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'systxtAOPruebas5',
                                                                value: 'DERECHA:'
                                                            },
                                                            {
                                                                xtype: 'combo', 
                                                                fieldLabel: 'PHALEN',
                                                                anchor: '100%',
                                                                allowBlank: false,
                                                                store: 'StorePositivoNegativo',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NEGATIVO (-)',
                                                                id: 'strAO_PrueblasPhalenD'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'systxtAOPruebas6',
                                                                value: 'IZQUIERDA:'
                                                            },
                                                            {
                                                                xtype: 'combo', 
                                                                anchor: '100%',
                                                                allowBlank: false,
                                                                store: 'StorePositivoNegativo',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NEGATIVO (-)',
                                                                id: 'strAO_PrueblasPhalenI'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'systxtAOPruebas7',
                                                                value: 'DERECHA:'
                                                            },
                                                            {
                                                                xtype: 'combo', 
                                                                fieldLabel: 'LASSEGUE',
                                                                anchor: '100%',
                                                                allowBlank: false,
                                                                store: 'StorePositivoNegativo',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NEGATIVO (-)',
                                                                id: 'strAO_PrueblasLassegueD'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'systxtAOPruebas8',
                                                                value: 'IZQUIERDA:'
                                                            },
                                                            {
                                                                xtype: 'combo', 
                                                                anchor: '100%',
                                                                allowBlank: false,
                                                                store: 'StorePositivoNegativo',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NEGATIVO (-)',
                                                                id: 'strAO_PrueblasLassegueI'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            }
                                        ],
                                        listeners : {
                                            render : function(){
                                                if(paramOpcion != "Nuevo"){
                                                    var frmAnexo = Ext.getCmp('frmAnexoOsteo').getForm();
                                                    frmAnexo.load({
                                                        params:{
                                                            pPaciente: Ext.getCmp('intIdPaciente').getValue(),
                                                            pConsecutivo: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                                                            task: 'SALUDOCUPACIONAL001_ANEXO_CARGAR'
                                                        }
                                                    });
                                                }
                                            }
                                        }
                                     }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 352,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                if(paramOpcion != "Nuevo"){
                    var frm = Ext.getCmp('frmHC').getForm();
                    frm.load({
                        params:{
                            pCAS: Ext.getCmp('sysCASHC').getValue(),
                            pConsecutivo: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                            task: 'SALUDOCUPACIONAL001_CARGAR'
                        },
                        success: function(){
                            frm.items.each(function(item, index, length)
                            {
                                if (item instanceof Ext.form.Field)
                                {
                                    tipodato = item.getId().substring(0,3);
                                    tipocampo = item.getXType();
                                    if (tipocampo == "compositefield")
                                    {
                                        item.items.each(function(item, index, length){
                                            tipodato = item.getId().substring(0,3);
                                            subtipocampo = item.getXType();
                                            if (subtipocampo != "checkboxgroup" && subtipocampo != "radiogroup" && subtipocampo != "displayfield"){
                                                if (tipodato != "sys" && subtipocampo == "combo")
                                                {
                                                    if (item.getValue() == "ANORMAL") {
                                                        txtCampo = "mem" + item.getId().substring(3,item.getId().length) + "H";
                                                        try {
                                                            var campo = Ext.getCmp(txtCampo);
                                                            if ( campo != null ) {
                                                                Ext.getCmp(txtCampo).enable();
                                                                Ext.getCmp(txtCampo).allowBlank = false;
                                                            }
                                                        }catch(ex){
                                                            // aqui se atrapo el error y se le puede mandar un mensaje al usuario o hacer alguna acción que controle el error.
                                                            //Ext.Msg('El campo no se encontro,' + ex.Message);
                                                        }
                                                    }
                                                }
                                            }
                                        });
                                    } else {
                                        if (tipocampo != "checkboxgroup" && tipocampo != "radiogroup" && tipocampo != "displayfield"){
                                            if (tipodato != "sys" && tipocampo == "combo")
                                            {
                                                if (item.getValue() == "ANORMAL") {
                                                    txtCampo = "mem" + item.getId().substring(3,item.getId().length) + "H";
                                                    try {
                                                        var campo = Ext.getCmp(txtCampo);
                                                        if ( campo != null ) {
                                                            Ext.getCmp(txtCampo).enable();
                                                            Ext.getCmp(txtCampo).allowBlank = false;
                                                        }
                                                    }catch(ex){
                                                        // aqui se atrapo el error y se le puede mandar un mensaje al usuario o hacer alguna acción que controle el error.
                                                        //Ext.Msg('El campo no se encontro,' + ex.Message);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                } 
                            });
                            if(Ext.getCmp('strAPDeporte').getValue()=="SI"){
                                Ext.getCmp('strAPDeporteOtros').enable();
                                Ext.getCmp('strAPDeporteOtros').allowBlank = false;
                            }
                        }
                    });
                }else{
                    var frm1 = Ext.getCmp('frmHC').getForm();
                    frm1.load({
                        params:{
                            pCAS: Ext.getCmp('sysCASHC').getValue(),
                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                            task: 'SALUDOCUPACIONAL001_CARGAR_HCANTERIOR'
                        },
                        success: function(){
                            frm1.items.each(function(item, index, length)
                            {
                                if (item instanceof Ext.form.Field)
                                {
                                    tipodato = item.getId().substring(0,3);
                                    tipocampo = item.getXType();
                                    if (tipocampo == "compositefield")
                                    {
                                        item.items.each(function(item, index, length){
                                            tipodato = item.getId().substring(0,3);
                                            subtipocampo = item.getXType();
                                            if (subtipocampo != "checkboxgroup" && subtipocampo != "radiogroup" && subtipocampo != "displayfield"){
                                                if (tipodato != "sys" && subtipocampo == "combo")
                                                {
                                                    if (item.getValue() == "ANORMAL") {
                                                        txtCampo = "mem" + item.getId().substring(3,item.getId().length) + "H";
                                                        try {
                                                            var campo = Ext.getCmp(txtCampo);
                                                            if ( campo != null ) {
                                                                Ext.getCmp(txtCampo).enable();
                                                                Ext.getCmp(txtCampo).allowBlank = false;
                                                            }
                                                        }catch(ex){
                                                            // aqui se atrapo el error y se le puede mandar un mensaje al usuario o hacer alguna acción que controle el error.
                                                            //Ext.Msg('El campo no se encontro,' + ex.Message);
                                                        }
                                                    }
                                                }
                                            }
                                        });
                                    } else {
                                        if (tipocampo != "checkboxgroup" && tipocampo != "radiogroup" && tipocampo != "displayfield"){
                                            if (tipodato != "sys" && tipocampo == "combo")
                                            {
                                                if (item.getValue() == "ANORMAL") {
                                                    txtCampo = "mem" + item.getId().substring(3,item.getId().length) + "H";
                                                    try {
                                                        var campo = Ext.getCmp(txtCampo);
                                                        if ( campo != null ) {
                                                            Ext.getCmp(txtCampo).enable();
                                                            Ext.getCmp(txtCampo).allowBlank = false;
                                                        }
                                                    }catch(ex){
                                                        // aqui se atrapo el error y se le puede mandar un mensaje al usuario o hacer alguna acción que controle el error.
                                                        //Ext.Msg('El campo no se encontro,' + ex.Message);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                } 
                            });
                            if(Ext.getCmp('strAPDeporte').getValue()=="SI"){
                                Ext.getCmp('strAPDeporteOtros').enable();
                                Ext.getCmp('strAPDeporteOtros').allowBlank = false;
                            }
                        }
                    });
                    
                }
                Ext.getCmp('strCargoActual').store.load();
                Ext.getCmp('strEmpresaSaludOcupacional').store.load();
            }}
        });
        winHCSALUDOCUPACIONAL001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: '../../controlador/asistencial/saludocupacional.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: '../../controlador/asistencial/saludocupacional.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnGuardarRegistrosAnexo(){
    var frm = Ext.getCmp('frmAnexoOsteo').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: '../../controlador/asistencial/saludocupacional.php',
            params:{
                task: 'guardar_anexo',
                CAMPOS: listacampos,
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoAnexo').setValue(1);
                        break;

                    default:
                        Ext.getCmp('sysYaGuardoAnexo').setValue(1);
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.getCmp('sysYaGuardoAnexo').setValue(1);
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosAnexo(){
    var frm = Ext.getCmp('frmAnexoOsteo').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: '../../controlador/asistencial/saludocupacional.php',
            params:{
                task: 'modificar_anexo',
                CAMPOS: listacampos,
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoAnexo').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

