/*
* @category    Formulario Seleccionar Elementos de Proteccion Salud Ocupacional
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winSeleccionarElementosUi = Ext.extend(Ext.Window, {
    title: '.:: Elementos de Protección ::.',
    width: 400,
    autoHeight: true,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winSeleccionarElementos',
    initComponent: function() {
        
        //var myMask = new Ext.LoadMask(Ext.getBody(), {msg:"Cargando Información..."});
        //myMask.show();
        var xg = Ext.grid;
        
        var chkColumnSeleccionar = new xg.CheckColumn({
           header: 'Seleccionar',
           dataIndex: 'Seleccionar',
           id: 'chkColumnSeleccionar',
           value: false,
           width: 70
        });

        this.items = [
            {
                xtype: 'hidden',
                id: 'sysOpcionElementosProtec',
                value: "0",
                allowBlank: true
            },
            {
                xtype: 'grid',
                id: 'gridSeleccionarElementos',
                store: 'StoreElementosProteccionSO',
                anchor: "100%",
                height: 290,
                border: false,
                frame: true,
                loadMask: true,
                cm: new xg.ColumnModel([
                    chkColumnSeleccionar,
                    {
                        header: 'Descripción',
                        dataIndex: 'Descripcion',
                        readOnly: true,
                        sortable: true,
                        width: 290,
                        hideable: false
                    }
                ]),
                plugins: [chkColumnSeleccionar],
                iconCls:'icon-grid',
                viewConfig: {
                    forceFit:true
                },
                columnLines: true,
                buttons: [
                    {
                        text: 'Seleccionar',
                        iconCls: 'btnSelect',
                        id: 'btnSeleccionarItemsElementos',
                        listeners: {
                            click : function() {
                                Ext.Msg.show({
                                    title: 'eOfiClinic',
                                    msg: 'Esta seguro que desea adicionar los Items?',
                                    buttons: Ext.Msg.YESNO,
                                    icon: Ext.Msg.QUESTION,
                                    fn: function(btn)
                                    {
                                        if(btn=="yes")
                                        {
                                           //recorrer el estor del grid
                                            var xtemp = " ";
                                            var xval = 0;
                                            switch (Ext.getCmp('sysOpcionElementosProtec').getValue()){
                                                case "HistorialLaboral":
                                                    Ext.getCmp('memElementosProtecHistoLaboral').setValue(null);
                                                    break;
                                                default:
                                                    break;
                                            }
                                            Ext.getCmp('gridSeleccionarElementos').store.filterBy(function(record,id){
                                                return record.get('Seleccionar') == true;
                                            });
                                            Ext.getCmp('gridSeleccionarElementos').store.each(function(record){
                                                switch (Ext.getCmp('sysOpcionElementosProtec').getValue()){
                                                    case "HistorialLaboral":
                                                        xtemp = Ext.getCmp('memElementosProtecHistoLaboral').getValue();
                                                        if (xval == 0){
                                                            if(xtemp.length > 0)
                                                                Ext.getCmp('memElementosProtecHistoLaboral').setValue(xtemp + ", " + record.get('Descripcion'));
                                                            else
                                                                Ext.getCmp('memElementosProtecHistoLaboral').setValue(record.get('Descripcion'));
                                                        }else{
                                                            Ext.getCmp('memElementosProtecHistoLaboral').setValue(xtemp + ", " + record.get('Descripcion'));
                                                        }
                                                        xval ++; 
                                                        break;
                                                    default:
                                                        break;
                                                }
                                            });
                                            Ext.getCmp('gridSeleccionarElementos').store.clearFilter();
                                            Ext.getCmp('winSeleccionarElementos').close();
                                        }
                                    }
                                });
                            }
                        }
                    },
                    {
                        text: 'Salir',
                        iconCls: 'btnSalir',
                        listeners: {
                            click : function() {
                                Ext.Msg.show({
                                    title: 'eOfiClinic',
                                    msg: 'Esta seguro que desea cerrar la ventana?',
                                    buttons: Ext.Msg.YESNO,
                                    icon: Ext.Msg.QUESTION,
                                    fn: function(btn)
                                    {
                                        if(btn=="yes")
                                        {
                                            Ext.getCmp('winSeleccionarElementos').close();
                                        }
                                    }
                                });
                            }
                        }
                    }
                ],
                buttonAlign: 'center',
                listeners: {
                    viewready : function() {
                        //myMask.hide();
                    }
                }
            }
        ];
        winSeleccionarElementosUi.superclass.initComponent.call(this);
    }
});
