/*
* @category    Formulario Seleccionar Riesgos Salud Ocupacional
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winSeleccionarRiesgosUi = Ext.extend(Ext.Window, {
    title: '.:: Factores de Riesgo ::.',
    width: 400,
    autoHeight: true,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winSeleccionarRiesgos',
    initComponent: function() {
        
        //var myMask = new Ext.LoadMask(Ext.getBody(), {msg:"Cargando Información..."});
        //myMask.show();
        var xg = Ext.grid;
        
        var chkColumnSeleccionar = new xg.CheckColumn({
           header: 'Seleccionar',
           dataIndex: 'Seleccionar',
           id: 'chkColumnSeleccionar',
           value: false,
           width: 70
        });

        this.items = [
            {
                xtype: 'hidden',
                id: 'sysOpcionFacRiesgo',
                value: "0",
                allowBlank: true
            },
            {
                xtype: 'grid',
                id: 'gridSeleccionar',
                store: 'StoreFacRiesgoSO',
                anchor: "100%",
                height: 290,
                border: false,
                frame: true,
                loadMask: true,
                cm: new xg.ColumnModel([
                    chkColumnSeleccionar,
                    {
                        header: 'Descripción',
                        dataIndex: 'Descripcion',
                        readOnly: true,
                        sortable: true,
                        width: 290,
                        hideable: false
                    }
                ]),
                plugins: [chkColumnSeleccionar],
                iconCls:'icon-grid',
                viewConfig: {
                    forceFit:true
                },
                columnLines: true,
                buttons: [
                    {
                        text: 'Seleccionar',
                        iconCls: 'btnSelect',
                        id: 'btnSeleccionarItems',
                        listeners: {
                            click : function() {
                                Ext.Msg.show({
                                    title: 'eOfiClinic',
                                    msg: 'Esta seguro que desea adicionar los Items?',
                                    buttons: Ext.Msg.YESNO,
                                    icon: Ext.Msg.QUESTION,
                                    fn: function(btn)
                                    {
                                        if(btn=="yes")
                                        {
                                            //recorrer el estor del grid
                                            switch (Ext.getCmp('sysOpcionFacRiesgo').getValue()){
                                                case "HistorialLaboral":
                                                    Ext.getCmp('memFactorRiesgoHistoLaboral').setValue(null);
                                                    break;
                                                default:
                                                     Ext.getCmp('memFactorRiesgoActual').setValue(null);
                                                    break;
                                            }
                                            var xtemp = " ";
                                            var xval = 0;
                                            Ext.getCmp('gridSeleccionar').store.filterBy(function(record,id){
                                                return record.get('Seleccionar') == true;
                                            });
                                            Ext.getCmp('gridSeleccionar').store.each(function(record){
                                                switch (Ext.getCmp('sysOpcionFacRiesgo').getValue()){
                                                    case "HistorialLaboral":
                                                        xtemp = Ext.getCmp('memFactorRiesgoHistoLaboral').getValue();
                                                        if (xval == 0){
                                                            if(xtemp.length > 0)
                                                                Ext.getCmp('memFactorRiesgoHistoLaboral').setValue(xtemp + ", " + record.get('Descripcion'));
                                                            else
                                                                Ext.getCmp('memFactorRiesgoHistoLaboral').setValue(record.get('Descripcion'));
                                                        }else{
                                                            Ext.getCmp('memFactorRiesgoHistoLaboral').setValue(xtemp + ", " + record.get('Descripcion'));
                                                        }
                                                        xval ++; 
                                                        break;
                                                    default:
                                                        xtemp = Ext.getCmp('memFactorRiesgoActual').getValue();
                                                        if (xval == 0){
                                                            if(xtemp.length > 0)
                                                                Ext.getCmp('memFactorRiesgoActual').setValue(xtemp + ", " + record.get('Descripcion'));
                                                            else
                                                                Ext.getCmp('memFactorRiesgoActual').setValue(record.get('Descripcion'));
                                                        }else{
                                                            Ext.getCmp('memFactorRiesgoActual').setValue(xtemp + ", " + record.get('Descripcion'));
                                                        }
                                                        xval ++; 
                                                        break;
                                                }
                                            });
                                            Ext.getCmp('gridSeleccionar').store.clearFilter();
                                            Ext.getCmp('winSeleccionarRiesgos').close();
                                        }
                                    }
                                });
                            }
                        }
                    },
                    {
                        text: 'Salir',
                        iconCls: 'btnSalir',
                        listeners: {
                            click : function() {
                                Ext.Msg.show({
                                    title: 'eOfiClinic',
                                    msg: 'Esta seguro que desea cerrar la ventana?',
                                    buttons: Ext.Msg.YESNO,
                                    icon: Ext.Msg.QUESTION,
                                    fn: function(btn)
                                    {
                                        if(btn=="yes")
                                        {
                                            Ext.getCmp('winSeleccionarRiesgos').close();
                                        }
                                    }
                                });
                            }
                        }
                    }
                ],
                buttonAlign: 'center',
                listeners: {
                    viewready : function() {
                        //myMask.hide();
                    }
                }
            }
        ];
        winSeleccionarRiesgosUi.superclass.initComponent.call(this);
    }
});
