/*
* @category    Solicitud Examenes por Programa
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

SolExaIPSxPROG201501Ui = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    initComponent: function() {
        //var xg = Ext.grid;
        var xg = Ext.grid;
        var chkColumnSeleccionarServicioxPrograma = new xg.CheckColumn({
           header: 'Solicitar',
           dataIndex: 'Seleccionar',
           id: 'chkColumnSeleccionarServicioxPrograma',
           value: false,
           width: 50
        });
        
        this.items = [
            {
                xtype: 'editorgrid',
                id: 'gridSolServiciosxPrograma',
                store: 'StoreSolServiciosxPrograma',
                anchor: "100%",
                height: 335,
                border: false,
                frame: true,
                loadMask: true,
                stripeRows: true,
                clicksToEdit: 1,
                title: 'Solicitud de Servicios del Programa',
                cm: new xg.ColumnModel([
                    chkColumnSeleccionarServicioxPrograma,
                    {
                        header: 'Descripción',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'DesProced',
                        width: 810
                    }
                ]),
                plugins: [chkColumnSeleccionarServicioxPrograma],
                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                viewConfig: {
                    forceFit:true
                },
                view: new Ext.grid.GridView({ 
                    getRowClass: function(record, index, rowParams, store){
                        var estado = record.data.Obligatorio;
                        switch (estado){
                            case "1":
                                return 'Apto';
                                break;
                            default:
                                return; 
                                break;
                        }
                    }
                }),
                columnLines: true
            }
        ];
        SolExaIPSxPROG201501Ui.superclass.initComponent.call(this);
    }
});