/*
* @category    Formulario Control de Signos Vitales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddSignosVitalesUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Control de Signos Vitales ::.',
    width: 1000,
    autoHeight: true,
    closable: true,
    resizable: false,
    draggable: false,
    modal: true,
    autoScroll: true,
    padding: 10,
    id: 'winAddSignosVitales',
    initComponent: function() {
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '85%',
                id: 'panelHC',
                border: false,
                autoHeight: true,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'form',
                        frame: true,
                        anchor: '100%',
                        id: 'frmAddSignosVitales',
                        padding: 10,
                        border: false,
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                value: 'NA',
                                fieldLabel: 'Pantalla',
                                id: 'sysPantalla'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'Usuario',
                                id: 'sysUsuario'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'ConsecutivoRegistro',
                                id: 'sysConsecutivoRegistro'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'IdPaciente',
                                id: 'sysIdPaciente'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'FechaRegistro',
                                value: new Date().format('Y-m-d'),
                                id: 'sysFechaRegistro'
                            },
                            {
                                xtype: 'panel',
                                title: '<center>DATOS BASICOS</center>',
                                layout: 'form',
                                anchor: '100%',
                                labelSeparator: '',
                                autoHeight: true,
                                id: 'pnDatosBasicos',
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        anchor: '100%',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Tipo Doc ID',
                                                anchor: '75%',
                                                name: 'cbTdoc',
                                                allowBlank: false,
                                                store: 'StoreTdocPac',
                                                readOnly: true,
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione Tipo Documento....',
                                                mode: 'local',
                                                triggerAction: 'all',
                                                forceSelection: true,
                                                id: 'sysTipoDoc'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: false,
                                                readOnly: true,
                                                emptyText: 'Documento',
                                                id: 'sysDocumento'
                                            },
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        anchor: '100%',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: false,
                                                readOnly: true,
                                                fieldLabel: 'Paciente',
                                                emptyText: 'Primer Apellido',
                                                id: 'sysPrimerApellido'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: true,
                                                readOnly: true,
                                                emptyText: 'Segundo Apellido',
                                                id: 'sysSegundoApellido'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: false,
                                                readOnly: true,
                                                emptyText: 'Primer Nombre',
                                                id: 'sysPrimerNombre'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: true,
                                                readOnly: true,
                                                emptyText: 'Segundo Nombre',
                                                id: 'sysSegundoNombre'
                                            },
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                width: 150,
                                                name: 'Fecha Nac',
                                                fieldLabel: 'Fecha Nac',
                                                allowBlank: false,
                                                readOnly: true,
                                                emptyText: '(dia/mes/año) ',
                                                style: 'text-align:center;',
                                                id: 'sysFechaNac'
                                            },
                                            {
                                                html: 'Genero'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 200,
                                                name: 'Genero',
                                                allowBlank: false,
                                                readOnly: true,
                                                store: 'StoreGenero',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                emptyText: 'Seleccione Genero....',
                                                forceSelection: true,
                                                id: 'sysGenero'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 150,
                                        allowBlank: false,
                                        readOnly: true,
                                        emptyText: 'CAS',
                                        fieldLabel: 'CAS',
                                        id: 'sysIdCAS'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '<center>Signos Vitales</center>',
                                layout: 'form',
                                anchor: '100%',
                                labelSeparator: '',
                                labelWidth: 100,
                                autoHeight: true,
                                id: 'pnTomaSignos',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Profesional',
                                        anchor: '100%',
                                        allowBlank: false,
                                        store: 'StoreProfesionales',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'sysProfesionalHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                width: 120,
                                                fieldLabel: 'Fecha Toma',
                                                name: 'Fecha Toma',
                                                allowBlank: false,
                                                emptyText: '(dia/mes/año) ',
                                                style: 'text-align:center;',
                                                id: 'fecToma'
                                            },
                                            {
                                                html: 'Hora:'
                                            },
                                            {
                                                xtype: 'timefield',
                                                name: 'Hora Toma',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: false,
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHora'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'numberfield',
                                                fieldLabel: 'T.A.',
                                                name: 'T.A. Sistolica',
                                                width: 70,
                                                minValue: 0,
                                                maxValue: 300,
                                                decimalPrecision: 0,
                                                allowBlank: false,
                                                id: 'intTASistolica'
                                            },
                                            {
                                                html: '/'
                                            },
                                            {
                                                xtype: 'numberfield',
                                                name: 'T.A. Diastolica',
                                                width: 70,
                                                minValue: 0,
                                                maxValue: 300,
                                                decimalPrecision: 0,
                                                allowBlank: false,
                                                id: 'intTADiastolica'
                                            },  
                                            {
                                                html: 'Ronquido'
                                            },                                                  
                                            {
                                                xtype: 'textfield',
                                                width: 70,
                                                name: 'Ronquido',
                                                allowBlank: false,
                                                id: 'intGlucometria'
                                            },
                                            {
                                                html: 'SAO2'
                                            },
                                            {
                                                xtype: 'numberfield',
                                                width: 70,
                                                minValue: 0,
                                                decimalPrecision: 2,
                                                name: 'SAO2',
                                                allowBlank: false,
                                                id: 'intSpO2'
                                            },
                                            {
                                                html: 'F.C.'
                                            },                                                            
                                            {
                                                xtype: 'numberfield',
                                                width: 70,
                                                minValue: 0,
                                                decimalPrecision: 2,
                                                name: 'FC',
                                                allowBlank: false,
                                                id: 'intFC'
                                            },
                                            {
                                                html: 'APNEA'
                                            },                                                            
                                            {
                                                xtype: 'textfield',
                                                width: 70,
                                                name: 'APNEA',
                                                allowBlank: false,
                                                id: 'intFR'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Comentario',
                                        fieldLabel: 'Comentario',
                                        allowBlank: false,
                                        anchor: '100%',
                                        id: 'strObservacion'
                                    },
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Crear Registro',
                            iconCls: 'btnAsignarCita',
                            id: 'btnCrearSignosVitales',
                            listeners:{
                                click : function(){
                                    guardarSignosVitales()
                            }
                        }
                    }
                ]
            }
        }];
        winAddSignosVitalesUi.superclass.initComponent.call(this);
    }
});

function guardarSignosVitales(){
        Ext.Msg.show({
        title: 'Guardar SignosVitales....!',
        msg: 'Esta seguro que desea Guardar la Informacion?',
        buttons: Ext.Msg.YESNO,
        icon: Ext.Msg.QUESTION,
        fn: function(btn)
        {
            if(btn=="yes")
            {
              var frm = Ext.getCmp('frmAddSignosVitales').getForm();
                if (frm.isValid())
                {
                    frm.submit({
                        url: '../../controlador/asistencial/evolucionhc2013.php',
                        params: {
                            task: 'CREAR_SIGNOS_VITALES',
                            pEmpresa: ID_EMPRESA,
                            pIPS: ID_IPS,
                            pPaciente: Ext.getCmp('sysIdPaciente').getValue(),
                            pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                            pFechaAtencion: Ext.getCmp('fecToma').getValue(),
                            pHoraAtencion: Ext.getCmp('strHora').getValue(),
                            pCAS: Ext.getCmp('sysIdCAS').getValue(),
                            pTASIS: Ext.getCmp('intTASistolica').getValue(),
                            pTADIAS: Ext.getCmp('intTADiastolica').getValue(),
                            pFC: Ext.getCmp('intFC').getValue(),
                            pFR: Ext.getCmp('intFR').getValue(),
                            pSpO2: Ext.getCmp('intSpO2').getValue(),
                            pGlucometria: Ext.getCmp('intGlucometria').getValue(),
                            pObservaciones: Ext.getCmp('strObservacion').getValue(),
                            pUsuario: ID_USUARIO
                        },
                        success: function(res,req)
                        {
                            switch(req.result.requestedId){
                                case "1":
                                    Ext.MessageBox.show({
                                        title: 'Guardar SignosVitales',
                                        msg: 'Se Guardo Informacion con Exito.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                    Ext.getCmp('winAddSignosVitales').close();
                                    Ext.getCmp('gridSignosVitales').store.baseParams = {
                                        task: 'LISTAR_CONTROL_SIGNOS_VITALES',
                                        pPaciente: Ext.getCmp('intPacienteLegalizacion').getValue(),
                                        pIPS: ID_IPS
                                    };
                                    Ext.getCmp('gridSignosVitales').store.load();
                                    break;

                                default:
                                    Ext.MessageBox.show({
                                        title: 'Guardar SignosVitales',
                                        msg: 'Ocurrio un error al Guardar la Informacion o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                    break;
                            }
                        },
                        failure: function(response,options)
                        {
                            Ext.MessageBox.show({
                                title: 'Error Base Datos',
                                msg: 'No podemos Guardar la Informacion en estos momentos',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    });
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }
        }
    });
}
