/*
* @category    Formulario Control de Signos Vitales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddEvolucion002Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Evolucion Enfermeria ::.',
    width: 1000,
    height: 636,
    closable: true,
    resizable: false,
    draggable: false,
    modal: true,
    autoScroll: true,
    id: 'winAddEvolucion002',
    initComponent: function() {
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '85%',
                id: 'panelHC',
                border: false,
                autoHeight: true,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'form',
                        frame: true,
                        anchor: '100%',
                        id: 'frmAddHCEvolucion002',
                        padding: 10,
                        border: false,
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                value: 'NA',
                                fieldLabel: 'Pantalla',
                                id: 'sysPantalla'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'Usuario',
                                id: 'sysUsuario'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'ConsecutivoRegistro',
                                id: 'sysConsecutivoRegistro'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'IdPaciente',
                                id: 'sysIdPaciente'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'FechaRegistro',
                                value: new Date().format('Y-m-d'),
                                id: 'sysFechaRegistro'
                            },
                            {
                                xtype: 'panel',
                                title: '<center>DATOS BASICOS</center>',
                                layout: 'form',
                                anchor: '100%',
                                labelSeparator: '',
                                autoHeight: true,
                                id: 'pnDatosBasicos',
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        anchor: '100%',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Tipo Doc ID',
                                                anchor: '75%',
                                                name: 'cbTdoc',
                                                allowBlank: false,
                                                store: 'StoreTdocPac',
                                                readOnly: true,
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione Tipo Documento....',
                                                mode: 'local',
                                                triggerAction: 'all',
                                                forceSelection: true,
                                                id: 'sysTipoDoc'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: false,
                                                readOnly: true,
                                                emptyText: 'Documento',
                                                id: 'sysDocumento'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        anchor: '100%',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: false,
                                                readOnly: true,
                                                fieldLabel: 'Paciente',
                                                emptyText: 'Primer Apellido',
                                                id: 'sysPrimerApellido'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: true,
                                                readOnly: true,
                                                emptyText: 'Segundo Apellido',
                                                id: 'sysSegundoApellido'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: false,
                                                readOnly: true,
                                                emptyText: 'Primer Nombre',
                                                id: 'sysPrimerNombre'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: true,
                                                readOnly: true,
                                                emptyText: 'Segundo Nombre',
                                                id: 'sysSegundoNombre'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                width: 150,
                                                name: 'Fecha Nac',
                                                fieldLabel: 'Fecha Nac',
                                                allowBlank: false,
                                                readOnly: true,
                                                emptyText: '(dia/mes/año) ',
                                                style: 'text-align:center;',
                                                id: 'sysFechaNac'
                                            },
                                            {
                                                html: 'Genero'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 200,
                                                name: 'Genero',
                                                allowBlank: false,
                                                readOnly: true,
                                                store: 'StoreGenero',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                emptyText: 'Seleccione Genero....',
                                                forceSelection: true,
                                                id: 'sysGenero'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 150,
                                        allowBlank: false,
                                        readOnly: true,
                                        emptyText: 'CAS',
                                        fieldLabel: 'CAS',
                                        id: 'sysIdCAS'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '<center>Evolucion</center>',
                                layout: 'form',
                                anchor: '100%',
                                labelSeparator: '',
                                labelWidth: 100,
                                autoHeight: true,
                                id: 'pnEvolucion',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Profesional',
                                        anchor: '100%',
                                        allowBlank: false,
                                        store: 'StoreProfesionales',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'sysProfesionalHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                width: 120,
                                                fieldLabel: 'Fecha',
                                                name: 'Fecha',
                                                allowBlank: false,
                                                emptyText: '(dia/mes/año) ',
                                                style: 'text-align:center;',
                                                id: 'sysFecha'
                                            },
                                            {
                                                html: 'Hora:'
                                            },
                                            {
                                                xtype: 'timefield',
                                                name: 'Hora',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: false,
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'sysHora'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'EVOLUCION',
                                        layout: 'table',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 7,
                                        items: [
                                            {
                                                xtype: 'textarea',
                                                anchor: '100%',
                                                width: 880,
                                                fieldLabel: 'EVOLUCION',
                                                name: 'EVOLUCION',
                                                height: 100,
                                                allowBlank: false,
                                                id: 'memEvolucion'
                                            }
                                        ]
                                    },{
                                        xtype: 'fieldset',
                                        title: 'CRISIS',
                                        layout: 'table',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 7,
                                        items: [
                                            {
                                                xtype: 'textarea',
                                                anchor: '100%',
                                                width: 880,
                                                fieldLabel: 'CRISIS',
                                                name: 'CRISIS',
                                                height: 100,
                                                allowBlank: true,
                                                id: 'memCrisis'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'RIPS',
                                        layout: 'form',
                                        collapsible: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        id: 'fsRips',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 96,
                                                        allowBlank: false,
                                                        fieldLabel: 'Diagnostico Principal',
                                                        id: 'sysDiagPpalHC',
                                                        listeners:{
                                                            specialkey: function(f,e){
                                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                {
                                                                    if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                        Ext.Ajax.request({
                                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                                            params:{
                                                                                task: 'BUSCAR',
                                                                                pCodigo: f.getValue().toUpperCase()
                                                                            },
                                                                            success: function(response,options)
                                                                            {
                                                                                var el = Ext.get('response'); // get the LOG
                                                                                var Respuesta = response.responseText;
                                                                                var Contenido = Respuesta.split('^');
                                                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                    Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                    Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                } else {
                                                                                    Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                                    Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                }
                                                                            },
                                                                            failure: function(response,options){
                                                                                var el = Ext.get('response');
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            },
                                                                            scope:this //bind the callbacks
                                                                        });
                                                                    }else{
                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 625,
                                                        height: 22,
                                                        id: 'sysDiagPpalHCNom'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Diagnostico Principal',
                                                        id: 'btnSearchDiagPpalHC',
                                                        listeners:{
                                                            click : function(){
                                                                buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 96,
                                                        allowBlank: true,
                                                        fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                        id: 'sysDiagRel1HC',
                                                        listeners:{
                                                            specialkey: function(f,e){
                                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                {
                                                                    if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                        Ext.Ajax.request(
                                                                        {
                                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                                            params:{
                                                                                task: 'BUSCAR',
                                                                                pCodigo: f.getValue().toUpperCase()
                                                                            },
                                                                            success: function(response,options)
                                                                            {
                                                                                var el = Ext.get('response'); // get the LOG
                                                                                var Respuesta = response.responseText;
                                                                                var Contenido = Respuesta.split('^');
                                                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                    Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                    Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                } else {
                                                                                    Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                                    Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                }
                                                                            },
                                                                            failure: function(response,options){
                                                                                var el = Ext.get('response');
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            },
                                                                            scope:this //bind the callbacks
                                                                        });
                                                                    }else{
                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 625,
                                                        height: 22,
                                                        id: 'sysDiagRel1HCNom'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Diagnostico Relacionado1',
                                                        id: 'btnSearchDiagRel1HC',
                                                        listeners:{
                                                            click : function(){
                                                                buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 96,
                                                        allowBlank: true,
                                                        fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                        id: 'sysDiagRel2HC',
                                                        listeners:{
                                                            specialkey: function(f,e){
                                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                {
                                                                    if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                        Ext.Ajax.request(
                                                                        {
                                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                                            params:{
                                                                                task: 'BUSCAR',
                                                                                pCodigo: f.getValue().toUpperCase()
                                                                            },
                                                                            success: function(response,options)
                                                                            {
                                                                                var el = Ext.get('response'); // get the LOG
                                                                                var Respuesta = response.responseText;
                                                                                var Contenido = Respuesta.split('^');
                                                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                    Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                    Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                } else {
                                                                                    Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                                    Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                }
                                                                            },
                                                                            failure: function(response,options){
                                                                                var el = Ext.get('response');
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            },
                                                                            scope:this //bind the callbacks
                                                                        });
                                                                    }else{
                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 625,
                                                        height: 22,
                                                        id: 'sysDiagRel2HCNom'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Diagnostico Relacionado2',
                                                        id: 'btnSearchDiagRel2HC1',
                                                        listeners:{
                                                            click : function(){
                                                                buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 96,
                                                        allowBlank: true,
                                                        fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                        id: 'sysDiagRel3HC',
                                                        listeners:{
                                                            specialkey: function(f,e){
                                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                {
                                                                    if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                        Ext.Ajax.request(
                                                                        {
                                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                                            params:{
                                                                                task: 'BUSCAR',
                                                                                pCodigo: f.getValue().toUpperCase()
                                                                            },
                                                                            success: function(response,options)
                                                                            {
                                                                                var el = Ext.get('response'); // get the LOG
                                                                                var Respuesta = response.responseText;
                                                                                var Contenido = Respuesta.split('^');
                                                                                if(Contenido[0]==="" || Contenido[0]=== "{success:false}" || Contenido[0]=== null){
                                                                                    Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                    Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                } else {
                                                                                    Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                                    Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                }
                                                                            },
                                                                            failure: function(response,options){
                                                                                var el = Ext.get('response');
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            },
                                                                            scope:this //bind the callbacks
                                                                        });
                                                                    }else{
                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 625,
                                                        height: 22,
                                                        id: 'sysDiagRel3HCNom'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Diagnostico Relacionado3',
                                                        id: 'btnSearchDiagRel3HC',
                                                        listeners:{
                                                            click : function(){
                                                                buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Tipo de Diagnostico',
                                                width:750,
                                                name: 'Tipo de Diagnostico',
                                                allowBlank: false,
                                                store: 'StoreTipoDiagnostico',
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                submitValue: true,
                                                id: 'sysTipoDiagosticoHC'
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Finalidad Consulta',
                                                width:750,
                                                name: 'Finalidad Consulta',
                                                allowBlank: false,
                                                store: 'StoreFinalidadConsulta',
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                submitValue: true,
                                                value: 10,
                                                id: 'sysFinalidadConsultaHC'
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Causa Externa',
                                                width:750,
                                                name: 'Causa Externa',
                                                allowBlank: false,
                                                store: 'StoreCausaExterna',
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                submitValue: true,
                                                value: 13,
                                                id: 'sysCausaExternaHC'
                                            }                            
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Crear Evolucion',
                            iconCls: 'btnAsignarCita',
                            id: 'btnCrearEvolucion002',
                            listeners:{
                                click : function(){
                                    guardarEvolucionEnfermeria();
                            }
                        }
                    }
                ]
            }
        }];
        winAddEvolucion002Ui.superclass.initComponent.call(this);
    }
});

function guardarEvolucionEnfermeria(){
        Ext.Msg.show({
        title: 'Guardar Evolucion....!',
        msg: 'Esta seguro que desea Guardar la Informacion?',
        buttons: Ext.Msg.YESNO,
        icon: Ext.Msg.QUESTION,
        fn: function(btn)
        {
            if(btn==="yes")
            {
                var frm = Ext.getCmp('frmAddHCEvolucion002').getForm();
                var listacampos = ExtraerCamposFrmHC(frm);
                if (frm.isValid())
                {
                    frm.submit({
                        url: '../../controlador/asistencial/evolucionhc2014.php',
                        params: {
                            task: 'GUARDA_NOTA_ENFERMERIA',
                            CAMPOS: listacampos,
                            pEmpresa: ID_EMPRESA,
                            pIPS: ID_IPS,
                            pPaciente: Ext.getCmp('sysIdPaciente').getValue(),
                            pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                            pFechaAtencion: Ext.getCmp('sysFecha').getValue(),
                            pHoraAtencion: Ext.getCmp('sysHora').getValue(),
                            pCAS: Ext.getCmp('sysIdCAS').getValue(),
                            pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                            pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                            pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                            pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                            pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                            pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                            pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                            pUsuario: ID_USUARIO
                        },
                        success: function(res,req)
                        {
                            switch(req.result.requestedId){
                                case "1":
                                    Ext.MessageBox.show({
                                        title: 'Guardar SignosVitales',
                                        msg: 'Se Guardo Informacion con Exito.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                    Ext.getCmp('winAddEvolucion002').close();
                                    Ext.getCmp('gridNotasEnfermeria').store.baseParams = {
                                        task: 'LISTAR_NOTAS_ENFERMERIA',
                                        pPaciente: Ext.getCmp('intPacienteLegalizacion').getValue(),
                                        pIPS: ID_IPS
                                    };
                                    Ext.getCmp('gridNotasEnfermeria').store.load();
                                    break;

                                default:
                                    Ext.MessageBox.show({
                                        title: 'Guardar SignosVitales',
                                        msg: 'Ocurrio un error al Guardar la Informacion o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                    break;
                            }
                        },
                        failure: function(response,options)
                        {
                            Ext.MessageBox.show({
                                title: 'Error Base Datos',
                                msg: 'No podemos Guardar la Informacion en estos momentos',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    });
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }
        }
    });
}
