/*
* @category    Formulario Pre-Inscripcion Pacientes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddAdministracionTratamientosUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Administracion de Tratamientos ::.',
    width: 1000,
    autoHeight: true,
    closable: true,
    resizable: false,
    draggable: false,
    modal: true,
    autoScroll: true,
    padding: 10,
    id: 'winAddAdministracionTratamientos',
    initComponent: function() {
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '85%',
                id: 'panelHC',
                border: false,
                autoHeight: true,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'form',
                        frame: true,
                        anchor: '100%',
                        id: 'frmAddAdministracionTratamientos',
                        padding: 10,
                        border: false,
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                value: 'NA',
                                fieldLabel: 'Pantalla',
                                id: 'sysPantalla'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'Usuario',
                                id: 'sysUsuario'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'ConsecutivoRegistro',
                                id: 'sysConsecutivoRegistro'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'IdPaciente',
                                id: 'sysIdPaciente'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'FechaRegistro',
                                value: new Date().format('Y-m-d'),
                                id: 'sysFechaRegistro'
                            },
                            {
                                xtype: 'panel',
                                title: '<center>DATOS BASICOS</center>',
                                layout: 'form',
                                anchor: '100%',
                                labelSeparator: '',
                                autoHeight: true,
                                id: 'pnDatosBasicos',
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        anchor: '100%',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Tipo Doc ID',
                                                anchor: '75%',
                                                name: 'cbTdoc',
                                                allowBlank: false,
                                                store: 'StoreTdocPac',
                                                readOnly: true,
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione Tipo Documento....',
                                                mode: 'local',
                                                triggerAction: 'all',
                                                forceSelection: true,
                                                id: 'sysTipoDoc'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: false,
                                                readOnly: true,
                                                emptyText: 'Documento',
                                                id: 'sysDocumento'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        anchor: '100%',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: false,
                                                readOnly: true,
                                                fieldLabel: 'Paciente',
                                                emptyText: 'Primer Apellido',
                                                id: 'sysPrimerApellido'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: true,
                                                readOnly: true,
                                                emptyText: 'Segundo Apellido',
                                                id: 'sysSegundoApellido'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: false,
                                                readOnly: true,
                                                emptyText: 'Primer Nombre',
                                                id: 'sysPrimerNombre'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: true,
                                                readOnly: true,
                                                emptyText: 'Segundo Nombre',
                                                id: 'sysSegundoNombre'
                                            },
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                width: 150,
                                                name: 'Fecha Nac',
                                                fieldLabel: 'Fecha Nac',
                                                allowBlank: false,
                                                readOnly: true,
                                                emptyText: '(dia/mes/año) ',
                                                style: 'text-align:center;',
                                                id: 'sysFechaNac'
                                            },
                                            {
                                                html: 'Genero'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 200,
                                                name: 'Genero',
                                                allowBlank: false,
                                                readOnly: true,
                                                store: 'StoreGenero',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                emptyText: 'Seleccione Genero....',
                                                forceSelection: true,
                                                id: 'sysGenero'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '<center>Signos Vitales</center>',
                                layout: 'form',
                                anchor: '100%',
                                labelSeparator: '',
                                autoHeight: true,
                                id: 'pnTomaSignos',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Profesional',
                                        anchor: '100%',
                                        allowBlank: false,
                                        store: 'StoreProfesionales',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'sysProfesionalHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                width: 120,
                                                fieldLabel: 'Fecha Toma',
                                                name: 'Fecha Toma',
                                                allowBlank: false,
                                                emptyText: '(dia/mes/año) ',
                                                style: 'text-align:center;',
                                                id: 'fecToma'
                                            },
                                            {
                                                html: 'Hora:'
                                            },
                                            {
                                                xtype: 'timefield',
                                                name: 'Hora Toma',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: false,
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHora'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Concepto',
                                        anchor: '100%',
                                        allowBlank: false,
                                        store: 'StoreAdministracionTratamientos',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'sysConcepto'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 300,
                                                allowBlank: true,
                                                fieldLabel: 'Dosis',
                                                name: 'Dosis',
                                                id: 'strDosis'
                                            },
                                            {
                                                html: 'Via Administracion'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 120,
                                                allowBlank: true,
                                                name: 'Via Administracion',
                                                id: 'strVia'
                                            },
                                            {
                                                html: 'Cantidad'
                                            },
                                            {
                                                xtype: 'numberfield',
                                                name: 'Cantidad',
                                                width: 50,
                                                minValue: 0,
                                                allowBlank: true,
                                                id: 'intCantidad'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Crear Registro',
                            iconCls: 'btnAsignarCita',
                            id: 'btnCrearAdministracionTratamientos',
                            listeners:{
                                click : function(){
                                    guardarAdministracionTratamientos()
                            }
                        }
                    }
                ]
            }
        }];
        winAddAdministracionTratamientosUi.superclass.initComponent.call(this);
    }
});

function guardarAdministracionTratamientos(){
        Ext.Msg.show({
        title: 'Guardar AdministracionTratamientos....!',
        msg: 'Esta seguro que desea Guardar la Informacion?',
        buttons: Ext.Msg.YESNO,
        icon: Ext.Msg.QUESTION,
        fn: function(btn)
        {
            if(btn=="yes")
            {
              var frm = Ext.getCmp('frmAddAdministracionTratamientos').getForm();
                if (frm.isValid())
                {
                    frm.submit({
                        url: '../../controlador/asistencial/evolucionhc2013.php',
                        params: {
                            task: 'CREAR_ADMINISTRACION_MEDICAMENTOS',
                            pPaciente: Ext.getCmp('sysIdPaciente').getValue(),
                            pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                            pFechaAtencion: Ext.getCmp('fecToma').getValue(),
                            pHoraAtencion: Ext.getCmp('strHora').getValue(),
                            pServicio: Ext.getCmp('sysConcepto').getValue(),
                            pDosis: Ext.getCmp('strDosis').getValue(),
                            pVia: Ext.getCmp('strVia').getValue(),
                            pCantidad: Ext.getCmp('intCantidad').getValue(),
                            pCAS: 0,
                            pUsuario: ID_USUARIO
                        },
                        success: function(res,req)
                        {
                            switch(req.result.requestedId){
                                case "1":
                                    Ext.MessageBox.show({
                                        title: 'Guardar AdministracionTratamientos',
                                        msg: 'Se Guardo Informacion con Exito.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                    Ext.getCmp('winAddAdministracionTratamientos').close();
                                    Ext.getCmp('gridAdministracionTratamientos').store.load();
                                    break;

                                default:
                                    Ext.MessageBox.show({
                                        title: 'Guardar AdministracionTratamientos',
                                        msg: 'Ocurrio un error al Guardar la Informacion o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                    break;
                            }
                        },
                        failure: function(response,options)
                        {
                            Ext.MessageBox.show({
                                title: 'Error Base Datos',
                                msg: 'No podemos Guardar la Informacion en estos momentos',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    });
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }
        }
    });
}
