/*
* @category    Formulario kardex de Pacientes 
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmEnfermeriaUi = Ext.extend(Ext.Window, {
    layout: 'fit',
    title: '.:: Enfermeria ::.',
    width: 1000,
    height: 600,
    closeAction: 'hide',
    plain: true,
    modal: true,
    frame: true,
    border: false,
    closable: false,
    draggable: false,
    resizable: false,
    id: 'winFrmEnfermeria',
    initComponent: function() {
        Ext.BLANK_IMAGE_URL = '../../../lib/extjs/resources/images/default/s.gif';
        wPaciente = 0;
        wCAS = 0;
        
        var stGrid = new StoreGridControlSignosVitales();
        var stGridAdministracionTratamientos = new StoreGridAdministracionTratamientos();
        
        
        
        //Store Local
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                autoHeight: true,
                anchor: '100%',
                autoScroll: true,
                id: 'frmEnfermeria',
                items: [
                    {
                        xtype: 'hidden',
                        id: 'intPacienteLegalizacion',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysIdEmpresa',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysIdSede',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysIPS',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysTipDoc',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysDoc',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysPrimer_Nombre',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysSegundo_Nombre',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysPrimer_Apellido',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysSegundo_Apellido',
                        value: 0
                    },
                    {
                        xtype: 'datefield',
                        hidden: true,
                        id: 'sysFecNac',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysSexo',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysCAS',
                        value: 0
                    },
                    {
                        xtype: 'compositefield',
                        anchor: '100%',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 815,
                                fieldLabel: 'Paciente',
                                readOnly: true,
                                allowBlank: true,
                                emptyText: 'Debe Buscar Paciente....',
                                id: 'sysPacienteLegalizacion'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar Paciente',
                                id: 'btnBuscarPacienteLegalizacion'
                            },
                            {
                                xtype: 'button',
                                tooltip: 'Limpiar Datos del Paciente',
                                iconCls: 'btnLimpiar',
                                id: 'btnLimpiarPacienteLegalizacion'
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'tabpanel',
                anchor: '99%',
                autoHeight: true,
                border: false,
                enableTabScroll: true,
                ref: 'fTabPanel',
                id: 'fTabPanel',
                activeTab: 0,
                items: [
                    {
                        xtype: 'panel',
                        title: 'Control de Signos Vitales',
                        autoHeight: true,
                        autoScroll: true,
                        anchor: '98%',
                        frame: true,
                        border: false,
                        id: 'fichaSignosVitales',
                        layout: 'form',
                        items: [
                            {
                                xtype: 'grid',
                                id: 'gridSignosVitales',
                                store: stGrid,
                                autoWidth: true,
                                height: 475,
                                border: false,
                                frame: true,
                                loadMask: true,
                                stripeRows: true,
                                colModel: new Ext.ux.grid.LockingColumnModel([
                                    {
                                        header: 'FechaRegistro',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'FechaRegistro',
                                        align: 'center',
                                        width: 125,
                                        hideable: false
                                    },
                                    {
                                        header: 'HoraRegistro',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'HoraRegistro',
                                        align: 'center',
                                        width: 100,
                                        hideable: false
                                    },
                                    {
                                        header: 'TASistolica',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'TASistolica',
                                        align: 'center',
                                        width: 75,
                                        hideable: false
                                    },
                                    {
                                        header: 'TADiastolica',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'TADiastolica',
                                        align: 'center',
                                        width: 75,
                                        hideable: false
                                    },
                                    {
                                        header: 'FC',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'FC',
                                        align: 'center',
                                        width: 75,
                                        hideable: false
                                    },
                                    {
                                        header: 'FR',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'FR',
                                        align: 'center',
                                        width: 75,
                                        hideable: false
                                    },
                                    {
                                        header: 'Temp',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'Temp',
                                        align: 'center',
                                        width: 75,
                                        hideable: false
                                    },
                                    {
                                        header: 'SpO2',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'SpO2',
                                        align: 'center',
                                        width: 75,
                                        hideable: false
                                    },
                                    {
                                        header: 'Glucometria',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'Glucometria',
                                        align: 'center',
                                        width: 75,
                                        hideable: false
                                    },
                                    {
                                        header: 'LiqAdministrados',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'Liquidos_Administrados',
                                        align: 'center',
                                        width: 75,
                                        hideable: false
                                    },
                                    {
                                        header: 'LiqEliminados',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'Liquidos_Eliminacion',
                                        align: 'center',
                                        width: 75,
                                        hideable: false
                                    },
                                    {
                                        header: 'LiqBalance',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'Liquidos_Balance',
                                        align: 'center',
                                        width: 75,
                                        hideable: false
                                    },
                                    {
                                        header: 'Deposiciones',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'Deposiciones',
                                        align: 'center',
                                        width: 75,
                                        hideable: false
                                    },
                                    {
                                        header: 'Profesional',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'Profesional',
                                        align: 'center',
                                        width: 205,
                                        hideable: false
                                    }
                                ]),
                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                view: new Ext.ux.grid.LockingGridView(),
                                columnLines: true,
                                tbar: {
                                    xtype: 'toolbar',
                                    anchor:'100%',
                                    items:[
                                        {
                                            xtype: 'button',
                                            text: 'Actualizar',
                                            iconCls: 'btnActualizarGrid',
                                            id: 'btnPacientesControlSignosVitales'
                                        },
                                        {
                                            xtype: 'tbfill'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Registro',
                                            iconCls: 'btnEditRow',
                                            id: 'btnCrearRegistro'
                                        },
                                        /*{
                                            xtype: 'button',
                                            text: 'Retiro del Programa',
                                            iconCls: 'btnDelRow',
                                            id: 'btnRetiroPrograma'
                                        }*/
                                    ]
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        title: 'Administracion de Tratamientos',
                        autoHeight: true,
                        autoScroll: true,
                        anchor: '98%',
                        frame: true,
                        border: false,
                        id: 'fichaAdministracionTratamientos',
                        layout: 'form',
                        items: [
                            {
                                xtype: 'grid',
                                id: 'gridAdministracionTratamientos',
                                store: stGridAdministracionTratamientos,
                                autoWidth: true,
                                height: 475,
                                border: false,
                                frame: true,
                                loadMask: true,
                                stripeRows: true,
                                colModel: new Ext.ux.grid.LockingColumnModel([
                                    {
                                        header: 'FechaRegistro',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'FechaAdministracion',
                                        align: 'center',
                                        width: 125,
                                        hideable: false
                                    },
                                    {
                                        header: 'HoraRegistro',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'HoraAdministracion',
                                        align: 'center',
                                        width: 100,
                                        hideable: false
                                    },
                                    {
                                        header: 'Servicio',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'Servicio',
                                        align: 'center',
                                        width: 300,
                                        hideable: false
                                    },
                                    {
                                        header: 'DosisAdministrada',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'DosisAdministrada',
                                        align: 'center',
                                        width: 158,
                                        hideable: false
                                    },
                                    {
                                        header: 'Cantidad',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'Cantidad',
                                        align: 'center',
                                        width: 70,
                                        hideable: false
                                    },
                                    {
                                        header: 'Profesional',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'Profesional',
                                        align: 'center',
                                        width: 205,
                                        hideable: false
                                    }
                                ]),
                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                view: new Ext.ux.grid.LockingGridView(),
                                columnLines: true,
                                tbar: {
                                    xtype: 'toolbar',
                                    anchor:'100%',
                                    items:[
                                        {
                                            xtype: 'button',
                                            text: 'Actualizar',
                                            iconCls: 'btnActualizarGrid',
                                            id: 'btnPacientesAdministracionMedicamentos'
                                        },
                                        {
                                            xtype: 'tbfill'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Registro',
                                            iconCls: 'btnEditRow',
                                            id: 'btnCrearRegistroAdministracionMedicamentos'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Eliminar',
                                            iconCls: 'btnDelRow',
                                            id: 'btnEliminar'
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                ]
            }
        ];
        this.bbar = {
            xtype: 'toolbar',
            id: 'bbar',
            items: [
                {
                    xtype: 'tbfill'
                },
                {
                    xtype: 'button',
                    text: 'Salir',
                    iconCls: 'btnSalir',
                    ref: '../btnSalir',
                    id: 'btnSalir'
                }
            ]
        };
        winFrmEnfermeriaUi.superclass.initComponent.call(this);
    }
});
