/*
* @category    Programacion Eventos Formulario Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmEnfermeria = Ext.extend(winFrmEnfermeriaUi, {
    initComponent: function() {
        winFrmEnfermeria.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        BD_MULTIPRESTADOR = "NA";

        
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        
        Ext.getCmp('sysIdEmpresa').setValue(ID_EMPRESA);
        Ext.getCmp('sysIPS').setValue(ID_IPS);
        
        var btnBuscarPacienteLegalizacion = Ext.getCmp('btnBuscarPacienteLegalizacion').on("click",this.BuscarPacienteLegaliza,this);
        var btnLimpiarPacienteLegalizacion = Ext.getCmp('btnLimpiarPacienteLegalizacion').on("click",this.LimpiarDatosPaciente,this);
        var btnCrearRegistro = Ext.getCmp('btnCrearRegistro').on("click",this.NuevoRegistro,this);
        var btnEliminar = Ext.getCmp('btnEliminar').on("click",this.EliminarAdministracion,this);
        var btnCrearRegistroAdministracionMedicamentos = Ext.getCmp('btnCrearRegistroAdministracionMedicamentos').on("click",this.NuevoRegistroAdministracionMedicamentos,this);
        var btnCrearEvolucionar = Ext.getCmp('btnCrearEvolucionar').on("click",this.AdicionarEvolucion,this);
        var btnCrearEvolucionarCVM = Ext.getCmp('btnCrearEvolucionarCVM').on("click",this.AdicionarEvolucionCVM,this);
        var btnPacientesControlSignosVitales = Ext.getCmp('btnPacientesControlSignosVitales').on("click",this.ListarPacientesControlSignosVitales,this);
        var btnPacientesAdministracionMedicamentos = Ext.getCmp('btnPacientesAdministracionMedicamentos').on("click",this.ListarPacientesAdministracionMedicamentos,this);
        var btnListarPacientesEvolucion = Ext.getCmp('btnListarPacientesEvolucion').on("click",this.ListarEvoluciones,this);
        var btnSalir = Ext.getCmp('btnSalir').on("click",this.SalirOpcion,this);
    },
    AdicionarEvolucionCVM: function(){
        if (Ext.getCmp('intPacienteLegalizacion').getValue() !== 0){
            var winAddEvolucionHCCVM = new winAddEvolucionCVMUi();
            Ext.getCmp('sysIdPacienteHC').setValue(Ext.getCmp('intPacienteLegalizacion').getValue());
            Ext.getCmp('sysIdCAS').setValue(Ext.getCmp('intCASLegalizacion').getValue());
            /*Ext.getCmp('sysTipoDoc').setValue(Ext.getCmp('sysTipDoc').getValue());
            Ext.getCmp('sysDocumento').setValue(Ext.getCmp('sysDoc').getValue());
            Ext.getCmp('sysPrimerNombre').setValue(Ext.getCmp('sysPrimer_Nombre').getValue());
            Ext.getCmp('sysSegundoNombre').setValue(Ext.getCmp('sysSegundo_Nombre').getValue());
            Ext.getCmp('sysPrimerApellido').setValue(Ext.getCmp('sysPrimer_Apellido').getValue());
            Ext.getCmp('sysSegundoApellido').setValue(Ext.getCmp('sysSegundo_Apellido').getValue());
            Ext.getCmp('sysFechaNac').setValue(Ext.getCmp('sysFecNac').getValue());
            Ext.getCmp('sysGenero').setValue(Ext.getCmp('sysSexo').getValue());
            */winAddEvolucionHCCVM.show();
        }else{
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'Seleccione el Paciente',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    AdicionarEvolucion: function(){
        if (Ext.getCmp('intPacienteLegalizacion').getValue() !== 0){
            var winAddEvolucionHC002 = new winAddEvolucion002Ui();
            Ext.getCmp('sysIdPaciente').setValue(Ext.getCmp('intPacienteLegalizacion').getValue());
            Ext.getCmp('sysIdCAS').setValue(Ext.getCmp('intCASLegalizacion').getValue());Ext.getCmp('sysTipoDoc').setValue(Ext.getCmp('sysTipDoc').getValue());
            Ext.getCmp('sysDocumento').setValue(Ext.getCmp('sysDoc').getValue());
            Ext.getCmp('sysPrimerNombre').setValue(Ext.getCmp('sysPrimer_Nombre').getValue());
            Ext.getCmp('sysSegundoNombre').setValue(Ext.getCmp('sysSegundo_Nombre').getValue());
            Ext.getCmp('sysPrimerApellido').setValue(Ext.getCmp('sysPrimer_Apellido').getValue());
            Ext.getCmp('sysSegundoApellido').setValue(Ext.getCmp('sysSegundo_Apellido').getValue());
            Ext.getCmp('sysFechaNac').setValue(Ext.getCmp('sysFecNac').getValue());
            Ext.getCmp('sysGenero').setValue(Ext.getCmp('sysSexo').getValue());
            winAddEvolucionHC002.show();
        }else{
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'Seleccione el Paciente',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    NuevoRegistro: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea Realizar el Registro de Signos Vitales?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    if(Ext.getCmp('intPacienteLegalizacion').getValue() == 0 || Ext.getCmp('intPacienteLegalizacion').getValue() == null || Ext.getCmp('intPacienteLegalizacion').getValue() == ""){
                        Ext.MessageBox.show({
                            title: 'Error',
                            msg: 'Seleccione un Paciente',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }else{
                        var winSignosVitales = new winAddSignosVitalesUi();
                        Ext.getCmp('sysIdCAS').setValue(Ext.getCmp('intCASLegalizacion').getValue());
                        Ext.getCmp('sysTipoDoc').setValue(Ext.getCmp('sysTipDoc').getValue());
                        Ext.getCmp('sysDocumento').setValue(Ext.getCmp('sysDoc').getValue());
                        Ext.getCmp('sysPrimerNombre').setValue(Ext.getCmp('sysPrimer_Nombre').getValue());
                        Ext.getCmp('sysSegundoNombre').setValue(Ext.getCmp('sysSegundo_Nombre').getValue());
                        Ext.getCmp('sysPrimerApellido').setValue(Ext.getCmp('sysPrimer_Apellido').getValue());
                        Ext.getCmp('sysSegundoApellido').setValue(Ext.getCmp('sysSegundo_Apellido').getValue());
                        Ext.getCmp('sysFechaNac').setValue(Ext.getCmp('sysFecNac').getValue());
                        Ext.getCmp('sysGenero').setValue(Ext.getCmp('sysSexo').getValue());
                        Ext.getCmp('sysIdPaciente').setValue(Ext.getCmp('intPacienteLegalizacion').getValue());
                        winSignosVitales.show();
                    }
                }
            }
        });
    },
    
    NuevoRegistroAdministracionMedicamentos: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea Realizar el Registro de Administracion?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    if(Ext.getCmp('intPacienteLegalizacion').getValue() == 0 || Ext.getCmp('intPacienteLegalizacion').getValue() == null || Ext.getCmp('intPacienteLegalizacion').getValue() == ""){
                        Ext.MessageBox.show({
                            title: 'Error',
                            msg: 'Seleccione un Paciente',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }else{
                        var winAddAdministracionTratamientos = new winAddAdministracionTratamientosUi();
                        Ext.getCmp('sysIdCAS').setValue(Ext.getCmp('intCASLegalizacion').getValue());
                        Ext.getCmp('sysTipoDoc').setValue(Ext.getCmp('sysTipDoc').getValue());
                        Ext.getCmp('sysDocumento').setValue(Ext.getCmp('sysDoc').getValue());
                        Ext.getCmp('sysPrimerNombre').setValue(Ext.getCmp('sysPrimer_Nombre').getValue());
                        Ext.getCmp('sysSegundoNombre').setValue(Ext.getCmp('sysSegundo_Nombre').getValue());
                        Ext.getCmp('sysPrimerApellido').setValue(Ext.getCmp('sysPrimer_Apellido').getValue());
                        Ext.getCmp('sysSegundoApellido').setValue(Ext.getCmp('sysSegundo_Apellido').getValue());
                        Ext.getCmp('sysFechaNac').setValue(Ext.getCmp('sysFecNac').getValue());
                        Ext.getCmp('sysGenero').setValue(Ext.getCmp('sysSexo').getValue());
                        Ext.getCmp('sysIdPaciente').setValue(Ext.getCmp('intPacienteLegalizacion').getValue());
                        winAddAdministracionTratamientos.show();
                    }
                }
            }
        });
    },
    
    EliminarAdministracion: function(){
        if(Ext.getCmp('gridAdministracionTratamientos').selModel.getCount() == 1){
            fnEliminarAdministracion();
        }
    },
    
    LimpiarDatosPaciente: function(){
        Ext.getCmp('intPacienteLegalizacion').setValue(0);
        Ext.getCmp('intCASLegalizacion').setValue(0);
        Ext.getCmp('sysPacienteLegalizacion').setValue(null);
        Ext.getCmp('gridKardexPacientes').store.baseParams = {
            task: 'LISTAR',
            pPaciente: 0,
            pIPS: ID_IPS
        };
        Ext.getCmp('gridKardexPacientes').store.load();
    },
    
    ListarPacientesControlSignosVitales: function(){
        if(Ext.getCmp('intPacienteLegalizacion').getValue() == null || Ext.getCmp('intPacienteLegalizacion').getValue() == "" || Ext.getCmp('intPacienteLegalizacion').getValue() == 0){
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'Seleccione un Paciente',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }else{
            Ext.getCmp('gridSignosVitales').store.baseParams = {
                task: 'LISTAR_CONTROL_SIGNOS_VITALES',
                pPaciente: Ext.getCmp('intPacienteLegalizacion').getValue(),
                pCAS: Ext.getCmp('intCASLegalizacion').getValue(),
                pIPS: ID_IPS
            };
            Ext.getCmp('gridSignosVitales').store.load();
        }
    },
            
    ListarEvoluciones: function(){
        if(Ext.getCmp('intPacienteLegalizacion').getValue() === null || Ext.getCmp('intPacienteLegalizacion').getValue() === "" || Ext.getCmp('intPacienteLegalizacion').getValue() === 0){
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'Seleccione un Paciente',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }else{
            Ext.getCmp('gridNotasEnfermeria').store.baseParams = {
                task: 'LISTAR_NOTAS_ENFERMERIA',
                pPaciente: Ext.getCmp('intPacienteLegalizacion').getValue(),
                pCAS: Ext.getCmp('intCASLegalizacion').getValue(),
                pIPS: ID_IPS
            };
            Ext.getCmp('gridNotasEnfermeria').store.load();
        }
    },
    
    ListarPacientesAdministracionMedicamentos: function(){
        if(Ext.getCmp('intPacienteLegalizacion').getValue() === null || Ext.getCmp('intPacienteLegalizacion').getValue() === "" || Ext.getCmp('intPacienteLegalizacion').getValue() === 0){
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'Seleccione un Paciente',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }else{
            Ext.getCmp('gridAdministracionTratamientos').store.baseParams = {
                task: 'LISTAR_ADMINISTRACION_MEDICAMENTOS',
                pPaciente: Ext.getCmp('intPacienteLegalizacion').getValue(),
                pCAS: Ext.getCmp('intCASLegalizacion').getValue()
            };
            Ext.getCmp('gridAdministracionTratamientos').store.load();
        }
    },
    
    
    BuscarPacienteLegaliza: function(){
        buscarestudios("PacienteTomaSignos");
    },
    BuscarPacienteAgendaManual: function(){
        buscarpacienteagendamanual();
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    }
});





function fnEliminarAdministracion(){
        Ext.Msg.show({
        title: 'Eliminar Administracion de Tratamientos....!',
        msg: 'Esta seguro que desea Eliminar la Informacion?',
        buttons: Ext.Msg.YESNO,
        icon: Ext.Msg.QUESTION,
        fn: function(btn)
        {
            if(btn=="yes")
            {
                var selections = Ext.getCmp('gridAdministracionTratamientos').selModel.getSelections();
                var frm = Ext.getCmp('frmEnfermeria').getForm();
                if (frm.isValid())
                {
                    frm.submit({
                        url: '../../controlador/asistencial/evolucionhc2013.php',
                        params: {
                            task: 'ELIMINAR_ADMINISTRACION_MEDICAMENTOS',
                            pIdConsecutivoAdministracion: selections[0].json.IdConsecutivoAdministracion
                        },
                        success: function(res,req)
                        {
                            switch(req.result.requestedId){
                                case "1":
                                    Ext.MessageBox.show({
                                        title: 'Eliminar Administracion de Tratamientos',
                                        msg: 'Se Elimino la Informacion con Exito.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                    Ext.getCmp('gridAdministracionTratamientos').store.load();
                                    break;

                                default:
                                    Ext.MessageBox.show({
                                        title: 'Eliminar Administracion de Tratamientos',
                                        msg: 'Ocurrio un error al Eliminar la Informacion o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                    break;
                            }
                        },
                        failure: function(response,options)
                        {
                            Ext.MessageBox.show({
                                title: 'Error Base Datos',
                                msg: 'No podemos Eliminar la Informacion en estos momentos',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    });
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }
        }
    });
}
