/*
* @category    Programacion Eventos Formulario Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmVerTranscripcionImgDx = Ext.extend(winFrmVerTranscripcionImgDxUi, {
    initComponent: function() {
        winFrmVerTranscripcionImgDx.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        BD_MULTIPRESTADOR = "NA";
        el = Ext.get('IdMunicipio');
        ID_MUNICIPIO = el.getValue();
        el = Ext.get('idaplicacion');
        NOMAPLICACION = el.getValue();
        ID_ESTADO_CERRADO = "01";
        
        CODPROCED_SELECCIONADO = "NA";
        DESPROCED_SELECCIONADO = "NA";
        TARPROCED_SELECCIONADO = 0;
        
        wURL = "";
        wNomImagen = "";
        winImgxPac = "";
        winDocxPac = "";
        
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        Ext.getCmp('fNomSede').setValue("");
        Ext.getCmp('fNomIPS').setValue("");
        Ext.getCmp('fNomUSR').setValue("");
        
        var sysFechaAgenda = Ext.getCmp('sysFechaAgendaImgDx').on("select",this.CargaDetalleTranscribirImgDx,this);
        var btnCASImgDx = Ext.getCmp('btnCASImgDx').on("click",this.CargaDetalleCASTranscribirImgDx,this);
        var btnActualizarImgDx = Ext.getCmp('btnActualizarImgDx').on("click",this.ActualizarAgenda,this);
        var btnEvolucionar = Ext.getCmp('btnEvolucionar').on("click",this.EvolucionarPaciente,this);
        var btnCerrarImgDx = Ext.getCmp('btnCerrarImgDx').on("click",this.CerrarTranscripcion,this);
        var btnimprimirImgDx = Ext.getCmp('btnimprimirImgDx').on("click",this.ImprimirReporte,this);
        var btnimprimirImgDxTodo = Ext.getCmp('btnimprimirImgDxTodo').on("click",this.ImprimirReporteTodos,this);
        var btnSalir = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion, this);
        //var btnPrintAgendaCitasManual = Ext.getCmp('btnPrintAgendaCitasManual').on("click",this.ImprimirAgendaManual, this);
        
    },
    ImprimirReporteTodos: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() === 1){
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            if (selections[0].json.EstadoReg !== '01'){
                switch (NOMAPLICACION){
                    case "OfiMedical":
                        window.open ("../../controlador/asistencial/imprimirhclab002.php?pT=S&pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pEvolucion=" + selections[0].json.ConsecutivoHC,"Historia Clinica");
                        break;
                    default:
                        window.open ("../../controlador/asistencial/imprimirhclab002.php?pT=S&pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pEvolucion=" + selections[0].json.ConsecutivoHC,"Historia Clinica");
                        break;
                }
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'El registro NO esta disponible para imprimir el reporte.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    ImprimirReporte: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() === 1){
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            if (selections[0].json.EstadoReg !== '01'){
                switch (NOMAPLICACION){
                    case "OfiMedical":
                        window.open ("../../controlador/asistencial/imprimirhclab002.php?pT=N&pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pEvolucion=" + selections[0].json.ConsecutivoHC,"Historia Clinica");
                        break;
                    default:
                        window.open ("../../controlador/asistencial/imprimirhclab002.php?pT=N&pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pEvolucion=" + selections[0].json.ConsecutivoHC,"Historia Clinica");
                        break;
                }
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'El registro NO esta disponible para imprimir el reporte.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    },
    CerrarTranscripcion: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() === 1){
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            if (selections[0].json.EstadoReg === '02'){
                Ext.Msg.show({
                    title: 'Transcripcion',
                    msg: 'Esta seguro que desea cerrar la transcripcion del CAS: ' + selections[0].json.CAS + '?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn){
                        if(btn=="yes"){
                            Ext.Ajax.request({
                                waitMsg: 'Por favor Espere...',
                                url: '../../controlador/transcribirimgdx/controlador_transcribirimgdx.php',
                                params:{
                                    task: 'cerrar_proc',
                                    pCerrar: 1,
                                    pCAS: selections[0].json.CAS,
                                    pConsecutivoDetalle: selections[0].json.ConsecutivoDetalle
                                },
                                success: function(response){
                                    switch(req.result.requestedId){
                                        case "1":
                                            Ext.getCmp('gridFormulario').store.load({
                                                params: {
                                                    pPrestador: ID_EMPRESA,
                                                    pIPS: ID_IPS,
                                                    pCAS: getCmp('sysCASImgDx').getValue(),
                                                    pFecha: Ext.getCmp('sysFechaAgendaImgDx').getValue().format("Y-m-d")
                                                }
                                            });
                                            Ext.MessageBox.show({
                                                title: 'eOfiClinic',
                                                msg: 'Se cerro la transcripcion del procedimiento seleccionado',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.INFO
                                            });
                                            break;

                                        default:
                                            Ext.MessageBox.show({
                                                title: 'Error',
                                                msg: 'No podemos cerrar la transcripcion en estos momentos',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                            break;
                                    }
                                },
                                failure: function(response){
                                    var result = response.responseText;
                                    Ext.MessageBox.show({
                                        title: 'Error Base Datos',
                                        msg: 'No podemos cerrar la transcripcion en estos momentos',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                }
                            });
                        }
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'El registro NO esta disponible para cerrar la transcripción.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    EvolucionarPaciente: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() === 1)
        {
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            if (selections[0].json.YaLegalizado === '1'){
                ID_ESTADO_CERRADO = selections[0].json.EstadoReg;
                var winHCTranscribeLaboratorio001 = new winHCTranscribeLaboratorio001Ui();
                Ext.getCmp('sysIdCodProcedHC').setValue(selections[0].json.IdProcedimiento);
                Ext.getCmp('sysIdCodPlantillaHC').setValue(10001);
                Ext.getCmp('sysUsaGridSalida').setValue(1);
                Ext.getCmp('sysYaGuardoHC').setValue(0);
                Ext.getCmp('sysPlantillaHC').setValue("LABORATORIOCLINICO");
                Ext.getCmp('sysRutaRptHC').setValue("ReporteLabClinicoCaldas");
                Ext.getCmp('sysActividadHC').setValue(PonerAcentosMayusculas(selections[0].json.Actividad));
                Ext.getCmp('sysEmpresaHC').setValue(ID_EMPRESA);
                Ext.getCmp('sysIPSHC').setValue(ID_IPS);
                Ext.getCmp('sysUsuarioHC').setValue(ID_USUARIO);
                Ext.getCmp('sysIdPacienteHC').setValue(selections[0].json.Paciente);
                Ext.getCmp('sysAperturaHC').setValue(new Date().format("h:i:s"));
                Ext.getCmp('sysClienteHC').setValue(PonerAcentosMayusculas(selections[0].json.Cliente));
                Ext.getCmp('sysIdClienteHC').setValue(selections[0].json.idCliente);
                Ext.getCmp('sysIdPlanHC').setValue(selections[0].json.idPlan);
                Ext.getCmp('sysIdSubPlanHC').setValue(selections[0].json.idSubPlan);
                Ext.getCmp('sysIdContratoHC').setValue(selections[0].json.idContrato);
                Ext.getCmp('sysGeneroPacHC').setValue(selections[0].json.Genero);
                Ext.getCmp('sysEdadPacHC').setValue(selections[0].json.Edad);
                //Ext.getCmp('sysProfesionalAgendaHC').setValue();
                Ext.getCmp('sysConsecutivoDetalleHC').setValue(selections[0].json.ConsecutivoDetalle);
                Ext.getCmp('sysCASHC').setValue(selections[0].json.CAS);
                Ext.getCmp('sysFechaHC').setValue(selections[0].json.FechaCita);
                Ext.getCmp('sysHoraHC').setValue(selections[0].json.HoraAgenda);
                //Ext.getCmp('sysLegalizacionHC,').setValue();
                Ext.getCmp('sysLegalizaHC').setValue(new Date().format("h:i:s"));
                Ext.getCmp('sysPacienteHC').setValue(PonerAcentosMayusculas(selections[0].json.TipDoc + '-' + selections[0].json.Documento + ' ' + selections[0].json.PrimerNombre + ' ' + selections[0].json.SegundoNombre + ' ' + selections[0].json.PrimerApellido + ' ' + selections[0].json.SegundoApellido));
                Ext.getCmp('sysGeneroPacHC').setValue(selections[0].json.Genero);
                //Ext.getCmp('sysFecNacPacHC').setValue();
                Ext.getCmp('sysEdadPacHC').setValue(selections[0].json.Edad);
                winHCTranscribeLaboratorio001.show();
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'El Paciente: " ' + selections[0].json.PrimerNombre + ' ' + selections[0].json.SegundoNombre + ' ' + selections[0].json.PrimerApellido + ' ' + selections[0].json.SegundoApellido + '", No ha legalizado la cita.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    CargaDetalleCASTranscribirImgDx: function(){
        if(Ext.getCmp('sysCASImgDx').getValue() === null || Ext.getCmp('sysCASImgDx').getValue() === ""){
            Ext.getCmp('sysCASImgDx').setValue(0);
        }
        Ext.getCmp('gridFormulario').store.load({
            params: {
                pPrestador: ID_EMPRESA,
                pIPS: ID_IPS,
                pCAS: Ext.getCmp('sysCASImgDx').getValue()
            }
        });  
    },
    CargaDetalleTranscribirImgDx: function(f, d) {
        Ext.getCmp('gridFormulario').store.load({
            params: {
                pPrestador: ID_EMPRESA,
                pIPS: ID_IPS,
                pCAS: 0,
                pFecha: d.format("Y-m-d")
            }
        });  
    },
    ActualizarAgenda: function(){
        if(Ext.getCmp('sysFechaAgendaImgDx').getValue() === null || Ext.getCmp('sysFechaAgendaImgDx').getValue() === ""){
            Ext.getCmp('sysFechaAgendaImgDx').setValue(new Date().format("Y-m-d"));
        }
        Ext.getCmp('sysCASImgDx').setValue(0);
        Ext.getCmp('gridFormulario').store.load({
            params: {
                pPrestador: ID_EMPRESA,
                pIPS: ID_IPS,
                pCAS: 0,
                pFecha: Ext.getCmp('sysFechaAgendaImgDx').getValue().format("Y-m-d")
            }
        });  
    },
    CerrarVentana: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                   Ext.getCmp('winProfesionalesUi').close();
                }
            }
        });
    }
});
