/*
* @category    Programacion Eventos Formulario Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmVerTranscripcionLabo = Ext.extend(winFrmVerTranscripcionLaboUi, {
    initComponent: function() {
        winFrmVerTranscripcionLabo.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        BD_MULTIPRESTADOR = "NA";
        el = Ext.get('IdMunicipio');
        ID_MUNICIPIO = el.getValue();
        el = Ext.get('idaplicacion');
        NOMAPLICACION = el.getValue();
        ID_ESTADO_CERRADO = "01";
        
        CODPROCED_SELECCIONADO = "NA";
        DESPROCED_SELECCIONADO = "NA";
        TARPROCED_SELECCIONADO = 0;
        
        wURL = "";
        wNomImagen = "";
        winImgxPac = "";
        winDocxPac = "";
        
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        Ext.getCmp('fNomSede').setValue("");
        Ext.getCmp('fNomIPS').setValue("");
        Ext.getCmp('fNomUSR').setValue("");
        
        var btnActualizarImgDx = Ext.getCmp('btnActualizarImgDx').on("click",this.ActualizarAgenda,this);
        var btnimprimirImgDx = Ext.getCmp('btnimprimirImgDx').on("click",this.ImprimirReporte,this);
        var btnimprimirImgDxTodo = Ext.getCmp('btnimprimirImgDxTodo').on("click",this.ImprimirReporteTodos,this);
        var btnSalir = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion, this);
        
    },
    ImprimirReporte: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() === 1){
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            if (selections[0].json.EstadoReg !== '01'){
                window.open ("../../controlador/asistencial/imprimirhclabaql.php?pT=N&pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pCAS=" + selections[0].json.CAS + "&pConsecutivoDetalle=" + selections[0].json.ConsecutivoDetalle,"Reporte Laboratorio");
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'El registro NO esta disponible para imprimir el reporte.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    ImprimirReporteTodos: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() === 1){
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            if (selections[0].json.EstadoReg !== '01'){
                window.open ("../../controlador/asistencial/imprimirhclabaql.php?pT=S&pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pCAS=" + selections[0].json.CAS + "&pConsecutivoDetalle=" + selections[0].json.ConsecutivoDetalle,"Reporte Laboratorio");
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'El registro NO esta disponible para imprimir el reporte.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    },
    ActualizarAgenda: function(){
        Ext.getCmp('gridFormulario').store.load({
            params: {
                pPrestador: ID_EMPRESA,
                pIPS: ID_IPS,
                pCAS: 0,
                pFecha: null
            }
        });  
    },
    CerrarVentana: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                   Ext.getCmp('winProfesionalesUi').close();
                }
            }
        });
    }
});
