/*
* @category    Formulario Cambiar Fecha de Radicación
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmCambiarNroExamenUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Cambiar Nro Examen - Placa ::.',
    id: 'winFrmCambiarNroExamen',
    closable:false,
    width:980,
    //height:280,
    autoHeight: true,
    resizable : false,
    border: false,
    frame: true,
    y:120,
    initComponent: function() {
        var mybbar = new utilBbarUi();
                
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        this.bbar = mybbar;
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmModificarFechaRadica',
                padding: 10,
                border: false,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        id: 'sysCASCambiarExamen'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysConsecutivoDetalleCambiarExamen'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Paciente - CAS',
                                width: 790,
                                readOnly: true,
                                allowBlank: false,
                                emptyText: 'Seleccione....',
                                id: 'fPacienteCambiarExamen'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar CAS',
                                id: 'btnBuscarPacienteUnificaMalo'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        width: 250,
                        fieldLabel: 'Nro Examen',
                        allowBlank: false,
                        readOnly: true,
                        id: 'sysNroExamenActual'
                    },
                    {
                        xtype: 'fieldset',
                        autoHeight: true,
                        title: 'Laboratorio Anatomía Patológica y Citología',
                        autoScroll: true,
                        collapsible: true,
                        anchor: '100%',
                        animCollapse: true,
                        items: [
                            {
                                xtype: 'combo',
                                title: '',
                                width: 542,
                                store: 'StoreExamen',
                                fieldLabel: 'Examen',
                                anchor: '100%',
                                validationDelay: 50,
                                triggerAction: 'all',
                                mode: 'local',
                                typeAhead: true,
                                forceSelection: true,
                                displayField: 'Descripcion',
                                listWidth: 950,
                                listEmptyText: '',
                                valueField: 'Codigo',
                                allowBlank: false,
                                id: 'intExamenCambiarExamen',
                                listeners:
                                {
                                    scope: this,
                                    select: function(cmb, rec, idx) {
                                        Ext.getCmp('strPrefijoExamenCambiarExamen').setValue(rec.data.Prefijo);
                                    }
                                }
                            },
                            {
                                xtype: 'compositefield',
                                fieldLabel: 'Nro Examen',
                                anchor: '100%',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        flex: 1,
                                        readOnly: true,
                                        allowBlank: false,
                                        width: 79,
                                        id: 'strPrefijoExamenCambiarExamen',
                                        listeners: {
                                            specialkey: function(field, e){
                                                if(field.getValue() != "" && field.getValue() != null && Ext.getCmp('strNroExamenCambiarExamen').getValue() != null && Ext.getCmp('strNroExamenCambiarExamen').getValue() != 0){
                                                    if (e.getKey() == e.ENTER || e.getKey() == e.TAB){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/citopato/controlador_citopato.php',
                                                            params:{
                                                                task: 'BUSCAR_CONSECUTIVO',
                                                                pPrefijo: field.getValue(),
                                                                pConsecutivo: Ext.getCmp('strNroExamenCambiarExamen').getValue()
                                                            },
                                                            success: function(response,options){
                                                                var el = Ext.get('response'); 
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0]!="{success:false}"){
                                                                    Ext.MessageBox.show({
                                                                        title: 'eOfiClinic',
                                                                        msg: 'El numero de examen: "' + field.getValue() + '-' + Ext.getCmp('strNroExamenCambiarExamen').getValue() + '", ya fue radicado',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                    Ext.getCmp('strNroExamenCambiarExamen').setValue(null);
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.MessageBox.show({
                                                                    title: 'eOfiClinic',
                                                                    msg: 'No se pudo establecer conexión con el servidor.',
                                                                    buttons: Ext.MessageBox.OK,
                                                                    icon: Ext.MessageBox.ERROR
                                                                });
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textfield',
                                        flex: 1,
                                        width: 130,
                                        allowBlank: false,
                                        id: 'strNroExamenCambiarExamen',
                                        listeners: {
                                            specialkey: function(field, e){
                                                if(field.getValue() != 0 && field.getValue() != null && Ext.getCmp('strPrefijoExamenCambiarExamen').getValue() != null && Ext.getCmp('strPrefijoExamenCambiarExamen').getValue() != ""){
                                                    if (e.getKey() == e.ENTER || e.getKey() == e.TAB){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/citopato/controlador_citopato.php',
                                                            params:{
                                                                task: 'BUSCAR_CONSECUTIVO',
                                                                pPrefijo: Ext.getCmp('strPrefijoExamenCambiarExamen').getValue(),
                                                                pConsecutivo: field.getValue()
                                                            },
                                                            success: function(response,options){
                                                                var el = Ext.get('response'); 
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0]!="{success:false}"){
                                                                    Ext.MessageBox.show({
                                                                        title: 'eOfiClinic',
                                                                        msg: 'El numero de examen: "' + Ext.getCmp('strPrefijoExamenCambiarExamen').getValue() + '-' + field.getValue() + '", ya fue radicado',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                    field.setValue(null);
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.MessageBox.show({
                                                                    title: 'eOfiClinic',
                                                                    msg: 'No se pudo establecer conexión con el servidor.',
                                                                    buttons: Ext.MessageBox.OK,
                                                                    icon: Ext.MessageBox.ERROR
                                                                });
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }
                                                }
                                            }
                                        }
                                    }
                                ]
                            }
                        ]
                    }
                ],
                tbar: {
                    xtype: 'toolbar',
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            iconCls: 'btnAceptar',
                            text: 'Cambiar Nro Examen',
                            id: 'btnUnificar'
                        }
                    ]
                }
            }
        ];
        winFrmCambiarNroExamenUi.superclass.initComponent.call(this);
    }
});
