/*
* @category    Programacion Eventos Formulario Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmVerTranscripcionAnatomo = Ext.extend(winFrmVerTranscripcionAnatomoUi, {
    initComponent: function() {
        winFrmVerTranscripcionAnatomo.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        BD_MULTIPRESTADOR = "NA";
        el = Ext.get('IdMunicipio');
        ID_MUNICIPIO = el.getValue();
        el = Ext.get('idaplicacion');
        NOMAPLICACION = el.getValue();
        ID_ESTADO_CERRADO = "01";
        ID_ESTADO_TRANSCRIPCION = "SIN TRANSCRIBIR";
        
        CODPROCED_SELECCIONADO = "NA";
        DESPROCED_SELECCIONADO = "NA";
        TARPROCED_SELECCIONADO = 0;
        
        wURL = "";
        wNomImagen = "";
        winImgxPac = "";
        winDocxPac = "";
        
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        Ext.getCmp('fNomSede').setValue("");
        Ext.getCmp('fNomIPS').setValue("");
        Ext.getCmp('fNomUSR').setValue("");
        
        var sysFechaAgenda = Ext.getCmp('sysFechaAgendaAnatomo').on("select",this.CargaDetalleTranscribirAnatomo,this);
        var btnCASAnatomo = Ext.getCmp('btnCASAnatomo').on("click",this.CargaDetalleCASTranscribirAnatomo,this);
        var btnActualizarAnatomo = Ext.getCmp('btnActualizarAnatomo').on("click",this.ActualizarAgenda,this);
        //var btnEvolucionar = Ext.getCmp('btnEvolucionar').on("click",this.EvolucionarPaciente,this);
        var btnCerrarAnatomo = Ext.getCmp('btnCerrarAnatomo').on("click",this.CerrarTranscripcion,this);
        var btnFirmarAnatomo = Ext.getCmp('btnFirmarAnatomo').on("click",this.FirmarTranscripcion,this);
        
        var btnimprimirAnatomo = Ext.getCmp('btnimprimirAnatomo').on("click",this.ImprimirReporte,this);
        var btnTransPatoAnatomo = Ext.getCmp('btnTransPatoAnatomo').on("click",this.TranscribirPatologia,this);
        var btnTransCitoAnatomo = Ext.getCmp('btnTransCitoAnatomo').on("click",this.TranscribirCitologia,this);
        var btnTransHer2Anatomo = Ext.getCmp('btnTransHer2Anatomo').on("click",this.TranscribirHER2,this);
        
        var btnSalir = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion, this);
        //var btnPrintAgendaCitasManual = Ext.getCmp('btnPrintAgendaCitasManual').on("click",this.ImprimirAgendaManual, this);
        
    },
    FirmarTranscripcion: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "FirmarAnatomopatologia";
        });
        acceso.each(function(item,index){
            permitir = true;
        });
        if (!permitir){
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'Usted no tiene permiso para realizar la firma de examenes',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }else{
            if(Ext.getCmp('gridFormulario').selModel.getCount() === 1){
                var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
                ID_ESTADO_TRANSCRIPCION = selections[0].json.EstadoTranscripcion;
                if (selections[0].json.EstadoTranscripcion === 'CERRADO'){
                    Ext.Msg.show({
                        title: 'Transcripcion',
                        msg: 'Esta seguro que desea Firmar la transcripcion del CAS: ' + selections[0].json.CAS + '?',
                        buttons: Ext.Msg.YESNO,
                        icon: Ext.Msg.QUESTION,
                        fn: function(btn){
                            if(btn=="yes"){
                                if(Ext.getCmp('sysFechaAgendaAnatomo').getValue() !== "" || Ext.getCmp('sysFechaAgendaAnatomo').getValue() !== null){
                                    var xFecAgenda = null;
                                }else{
                                    var xFecAgenda = Ext.getCmp('sysFechaAgendaAnatomo').getValue().format("Y-m-d");
                                }
                                Ext.Ajax.request({
                                    waitMsg: 'Por favor Espere...',
                                    url: '../../controlador/transcribirpato/controlador_transcribirpato.php',
                                    params:{
                                        task: 'firmar_proc',
                                        pCerrar: 1,
                                        pCAS: selections[0].json.CAS,
                                        pConsecutivoDetalle: selections[0].json.ConsecutivoDetalle,
                                        pUsuario: ID_USUARIO
                                    },
                                    success: function(response,options){
                                        var el = Ext.get('response'); // get the LOG
                                        var Respuesta = response.responseText;
                                        var Contenido = Respuesta.split('^');
                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                            Ext.MessageBox.show({
                                                title: 'Error',
                                                msg: 'Usted no esta autorizado para firmar este examen',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        } else {
                                            switch(Contenido[0]){
                                                case "1":
                                                    Ext.getCmp('gridFormulario').store.load({
                                                        params: {
                                                            pPrestador: ID_EMPRESA,
                                                            pIPS: ID_IPS,
                                                            pCAS: Ext.getCmp('sysCASAnatomo').getValue(),
                                                            pFecha: xFecAgenda
                                                        }
                                                    });
                                                    Ext.MessageBox.show({
                                                        title: 'eOfiClinic',
                                                        msg: 'Se firmo la transcripcion del procedimiento seleccionado',
                                                        buttons: Ext.MessageBox.OK,
                                                        icon: Ext.MessageBox.INFO
                                                    });
                                                    break;

                                                default:
                                                    Ext.MessageBox.show({
                                                        title: 'Error',
                                                        msg: 'Conexion, No podemos firmar la transcripcion en estos momentos',
                                                        buttons: Ext.MessageBox.OK,
                                                        icon: Ext.MessageBox.ERROR
                                                    });
                                                    break;
                                            }
                                        }
                                    },
                                    failure: function(response,options){
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'No podemos cerrar la transcripcion en estos momentos',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                });
                            }
                        }
                    });
                }else{
                    Ext.MessageBox.show({
                        title: 'eOfiClinic',
                        msg: 'El estudio no esta cerrado y/o ya esta firmado.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }
        }
    },
    TranscribirHER2: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() === 1){
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            stCIE10 = new StoreCIE10();
            objMX = "NA";
            objMXADD = "NA";
            objEXA = "NA";
            objEXAADD = "NA";
            objREM = "NA";
            objREMADD = "NA";
            wPaciente = selections[0].json.Paciente;
            wCAS = selections[0].json.CAS;
            ID_ESTADO_CERRADO = selections[0].json.EstadoReg;
            ID_ESTADO_TRANSCRIPCION = selections[0].json.EstadoTranscripcion;
            if(ID_ESTADO_TRANSCRIPCION !== "CERRADO"){
                ScriptMgr.loadJs({
                    scripts : "../../../app/frm_js/asistencial/transcribepato/winhctranscribepatologia003.ui.js",
                    callback : function(){
                        var winHC = new winHCTranscribePato003Ui();
                        Ext.getCmp('sysPlantillaHC').setValue(PonerAcentosMayusculas("HER-2"));
                        Ext.getCmp('sysRutaRptHC').setValue(PonerAcentosMayusculas("ReporteHER2ICP"));
                        Ext.getCmp('sysRutaRptMx').setValue(null);
                        Ext.getCmp('sysRutaRptExa').setValue(null);
                        Ext.getCmp('sysRutaRptRem').setValue(null);
                        Ext.getCmp('sysActividadHC').setValue(PonerAcentosMayusculas(selections[0].json.Actividad));
                        Ext.getCmp('sysEmpresaHC').setValue(ID_EMPRESA);
                        Ext.getCmp('sysIPSHC').setValue(ID_IPS);
                        Ext.getCmp('sysUsuarioHC').setValue(ID_USUARIO);
                        Ext.getCmp('sysProfesionalHC').setValue(null);
                        Ext.getCmp('sysIdPacienteHC').setValue(selections[0].json.Paciente);
                        Ext.getCmp('sysClienteHC').setValue(selections[0].json.Cliente);
                        Ext.getCmp('sysCASHC').setValue(selections[0].json.CAS);
                        Ext.getCmp('sysProfesionalAgendaHC').setValue(null);
                        Ext.getCmp('sysFechaHC').setValue(selections[0].json.FechaCita);
                        Ext.getCmp('sysHoraHC').setValue(selections[0].json.HoraAgenda);
                        Ext.getCmp('sysLegalizaHC').setValue(selections[0].json.FechaLegaliza);
                        Ext.getCmp('sysPacienteHC').setValue(PonerAcentosMayusculas(selections[0].json.TipDoc + '-' + selections[0].json.Documento + ' ' + selections[0].json.PrimerNombre + ' ' + selections[0].json.SegundoNombre + ' ' + selections[0].json.PrimerApellido + ' ' + selections[0].json.SegundoApellido));
                        Ext.getCmp('sysAperturaHC').setValue(new Date().format("h:i:s"));
                        Ext.getCmp('sysConsecutivoDetalleHC').setValue(selections[0].json.ConsecutivoDetalle);
                        Ext.getCmp('sysIdClienteHC').setValue(selections[0].json.idCliente);
                        Ext.getCmp('sysIdPlanHC').setValue(selections[0].json.idPlan);
                        Ext.getCmp('sysIdSubPlanHC').setValue(selections[0].json.idSubPlan);
                        Ext.getCmp('sysIdContratoHC').setValue(selections[0].json.idContrato);
                        Ext.getCmp('sysIdCodPlantillaHC').setValue(1);
                        Ext.getCmp('sysGeneroPacHCfrm').setValue(selections[0].json.Genero);
                        Ext.getCmp('sysGeneroPacHCfrm').setValue(selections[0].json.Genero);
                        Ext.getCmp('sysNroExamenHC').setValue(selections[0].json.NroPlacaRef);
                        try {
                            if(selections[0].json.Genero == "F"){
                                var campo3 = Ext.getCmp('sysGeneroPacHC');
                                if ( campo3 != null ) {
                                    if(selections[0].json.Genero == "M"){
                                        Ext.getCmp('sysGeneroPacHC').setValue("MASCULINO");
                                    }else{
                                        Ext.getCmp('sysGeneroPacHC').setValue("FEMENINO");
                                    }
                                }
                            }
                        }catch(ex) {
                        }
                        try {
                            var campo4 = Ext.getCmp('sysEdadPacHC');
                            if ( campo4 != null ) {
                                Ext.getCmp('sysEdadPacHC').setValue(selections[0].json.Edad);
                            }
                        }catch(ex) {
                        }    
                        try {
                            var campo5 = Ext.getCmp('sysFecNacPacHC');
                            if ( campo5 != null ) {
                                Ext.getCmp('sysFecNacPacHC').setValue(selections[0].json.FecNac);
                            }
                        }catch(ex) {
                        }
                        try {
                            var campo6a = Ext.getCmp('sysDatBasEdadHC');
                            if ( campo6a != null ) {
                                Ext.getCmp('sysDatBasEdadHC').setValue(selections[0].json.Edad);
                            }
                        }catch(ex) {
                        }   
                        try {
                            var campo7a = Ext.getCmp('sysDatBasGeneroHC');
                            if ( campo7a != null ) {
                                if(selections[0].json.Genero == "M"){
                                    Ext.getCmp('sysDatBasGeneroHC').setValue("MASCULINO");
                                }else{
                                    Ext.getCmp('sysDatBasGeneroHC').setValue("FEMENINO");
                                }
                            }
                        }catch(ex) {
                        }  
                        try {
                            var campo8 = Ext.getCmp('sysIdCodProcedHC');
                            if ( campo8 !== null ) {
                                Ext.getCmp('sysIdCodProcedHC').setValue(selections[0].json.IdProcedimiento); 
                            }
                        }catch(ex) {
                        }  
                        winHC.show();
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'El estudio esta cerrado y no se puede modificar.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'eOfiClinic',
                msg: 'Debe Seleccionar una Plantilla.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    TranscribirCitologia: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() === 1){
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            stCIE10 = new StoreCIE10();
            objMX = "NA";
            objMXADD = "NA";
            objEXA = "NA";
            objEXAADD = "NA";
            objREM = "NA";
            objREMADD = "NA";
            wPaciente = selections[0].json.Paciente;
            wCAS = selections[0].json.CAS;
            ID_ESTADO_CERRADO = selections[0].json.EstadoReg;
            ID_ESTADO_TRANSCRIPCION = selections[0].json.EstadoTranscripcion;
            if(ID_ESTADO_TRANSCRIPCION !== "CERRADO"){
                ScriptMgr.loadJs({
                    scripts : "../../../app/frm_js/asistencial/transcribepato/winhctranscribepatologia002.ui.js",
                    callback : function(){
                        var winHC = new winHCTranscribePato002Ui();
                        Ext.getCmp('sysPlantillaHC').setValue(PonerAcentosMayusculas("CITOLOGIA"));
                        Ext.getCmp('sysRutaRptHC').setValue(PonerAcentosMayusculas("ReporteCITOLOGIAICP"));
                        Ext.getCmp('sysRutaRptMx').setValue(null);
                        Ext.getCmp('sysRutaRptExa').setValue(null);
                        Ext.getCmp('sysRutaRptRem').setValue(null);
                        Ext.getCmp('sysActividadHC').setValue(PonerAcentosMayusculas(selections[0].json.Actividad));
                        Ext.getCmp('sysEmpresaHC').setValue(ID_EMPRESA);
                        Ext.getCmp('sysIPSHC').setValue(ID_IPS);
                        Ext.getCmp('sysUsuarioHC').setValue(ID_USUARIO);
                        Ext.getCmp('sysProfesionalHC').setValue(null);
                        Ext.getCmp('sysIdPacienteHC').setValue(selections[0].json.Paciente);
                        Ext.getCmp('sysClienteHC').setValue(selections[0].json.Cliente);
                        Ext.getCmp('sysCASHC').setValue(selections[0].json.CAS);
                        Ext.getCmp('sysProfesionalAgendaHC').setValue(null);
                        Ext.getCmp('sysFechaHC').setValue(selections[0].json.FechaCita);
                        Ext.getCmp('sysHoraHC').setValue(selections[0].json.HoraAgenda);
                        Ext.getCmp('sysLegalizaHC').setValue(selections[0].json.FechaLegaliza);
                        Ext.getCmp('sysPacienteHC').setValue(PonerAcentosMayusculas(selections[0].json.TipDoc + '-' + selections[0].json.Documento + ' ' + selections[0].json.PrimerNombre + ' ' + selections[0].json.SegundoNombre + ' ' + selections[0].json.PrimerApellido + ' ' + selections[0].json.SegundoApellido));
                        Ext.getCmp('sysAperturaHC').setValue(new Date().format("h:i:s"));
                        Ext.getCmp('sysConsecutivoDetalleHC').setValue(selections[0].json.ConsecutivoDetalle);
                        Ext.getCmp('sysIdClienteHC').setValue(selections[0].json.idCliente);
                        Ext.getCmp('sysIdPlanHC').setValue(selections[0].json.idPlan);
                        Ext.getCmp('sysIdSubPlanHC').setValue(selections[0].json.idSubPlan);
                        Ext.getCmp('sysIdContratoHC').setValue(selections[0].json.idContrato);
                        Ext.getCmp('sysIdCodPlantillaHC').setValue(2);
                        Ext.getCmp('sysNroExamenHC').setValue(selections[0].json.NroPlacaRef);
                        //Ext.getCmp('sysGeneroPacHCfrm').setValue(selections[0].json.Genero);
                        try {
                            if(selections[0].json.Genero == "F"){
                                var campo3 = Ext.getCmp('sysGeneroPacHC');
                                if ( campo3 != null ) {
                                    if(selections[0].json.Genero == "M"){
                                        Ext.getCmp('sysGeneroPacHC').setValue("MASCULINO");
                                    }else{
                                        Ext.getCmp('sysGeneroPacHC').setValue("FEMENINO");
                                    }
                                }
                            }
                        }catch(ex) {
                        }
                        try {
                            var campo4 = Ext.getCmp('sysEdadPacHC');
                            if ( campo4 != null ) {
                                Ext.getCmp('sysEdadPacHC').setValue(selections[0].json.Edad);
                            }
                        }catch(ex) {
                        }    
                        try {
                            var campo5 = Ext.getCmp('sysFecNacPacHC');
                            if ( campo5 != null ) {
                                Ext.getCmp('sysFecNacPacHC').setValue(selections[0].json.FecNac);
                            }
                        }catch(ex) {
                        }
                        try {
                            var campo6a = Ext.getCmp('sysDatBasEdadHC');
                            if ( campo6a != null ) {
                                Ext.getCmp('sysDatBasEdadHC').setValue(selections[0].json.Edad);
                            }
                        }catch(ex) {
                        }   
                        try {
                            var campo7a = Ext.getCmp('sysDatBasGeneroHC');
                            if ( campo7a != null ) {
                                if(selections[0].json.Genero == "M"){
                                    Ext.getCmp('sysDatBasGeneroHC').setValue("MASCULINO");
                                }else{
                                    Ext.getCmp('sysDatBasGeneroHC').setValue("FEMENINO");
                                }
                            }
                        }catch(ex) {
                        }  
                        try {
                            var campo8 = Ext.getCmp('sysIdCodProcedHC');
                            if ( campo8 !== null ) {
                                Ext.getCmp('sysIdCodProcedHC').setValue(selections[0].json.IdProcedimiento); 
                            }
                        }catch(ex) {
                        }  
                        winHC.show();
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'El estudio esta cerrado y no se puede modificar.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'eOfiClinic',
                msg: 'Debe Seleccionar una Plantilla.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    TranscribirPatologia: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() === 1){
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            stCIE10 = new StoreCIE10();
            objMX = "NA";
            objMXADD = "NA";
            objEXA = "NA";
            objEXAADD = "NA";
            objREM = "NA";
            objREMADD = "NA";
            wPaciente = selections[0].json.Paciente;
            wCAS = selections[0].json.CAS;
            ID_ESTADO_CERRADO = selections[0].json.EstadoReg;
            ID_ESTADO_TRANSCRIPCION = selections[0].json.EstadoTranscripcion;
            if(ID_ESTADO_TRANSCRIPCION !== "CERRADO"){
                ScriptMgr.loadJs({
                    scripts : "../../../app/frm_js/asistencial/transcribepato/winhctranscribepatologia001.ui.js",
                    callback : function(){
                        var winHC = new winHCTranscribePato001Ui();
                        Ext.getCmp('sysPlantillaHC').setValue(PonerAcentosMayusculas("ANATOMOPATOLOGIA"));
                        Ext.getCmp('sysRutaRptHC').setValue(PonerAcentosMayusculas("ReportePATOLOGIAICP"));
                        Ext.getCmp('sysRutaRptMx').setValue(null);
                        Ext.getCmp('sysRutaRptExa').setValue(null);
                        Ext.getCmp('sysRutaRptRem').setValue(null);
                        Ext.getCmp('sysActividadHC').setValue(PonerAcentosMayusculas(selections[0].json.Actividad));
                        Ext.getCmp('sysEmpresaHC').setValue(ID_EMPRESA);
                        Ext.getCmp('sysIPSHC').setValue(ID_IPS);
                        Ext.getCmp('sysUsuarioHC').setValue(ID_USUARIO);
                        Ext.getCmp('sysProfesionalHC').setValue(null);
                        Ext.getCmp('sysIdPacienteHC').setValue(selections[0].json.Paciente);
                        Ext.getCmp('sysClienteHC').setValue(selections[0].json.Cliente);
                        Ext.getCmp('sysCASHC').setValue(selections[0].json.CAS);
                        Ext.getCmp('sysProfesionalAgendaHC').setValue(null);
                        Ext.getCmp('sysFechaHC').setValue(selections[0].json.FechaCita);
                        Ext.getCmp('sysHoraHC').setValue(selections[0].json.HoraAgenda);
                        Ext.getCmp('sysLegalizaHC').setValue(selections[0].json.FechaLegaliza);
                        Ext.getCmp('sysPacienteHC').setValue(PonerAcentosMayusculas(selections[0].json.TipDoc + '-' + selections[0].json.Documento + ' ' + selections[0].json.PrimerNombre + ' ' + selections[0].json.SegundoNombre + ' ' + selections[0].json.PrimerApellido + ' ' + selections[0].json.SegundoApellido));
                        Ext.getCmp('sysAperturaHC').setValue(new Date().format("h:i:s"));
                        Ext.getCmp('sysConsecutivoDetalleHC').setValue(selections[0].json.ConsecutivoDetalle);
                        Ext.getCmp('sysIdClienteHC').setValue(selections[0].json.idCliente);
                        Ext.getCmp('sysIdPlanHC').setValue(selections[0].json.idPlan);
                        Ext.getCmp('sysIdSubPlanHC').setValue(selections[0].json.idSubPlan);
                        Ext.getCmp('sysIdContratoHC').setValue(selections[0].json.idContrato);
                        Ext.getCmp('sysIdCodPlantillaHC').setValue(1);
                        Ext.getCmp('sysGeneroPacHCfrm').setValue(selections[0].json.Genero);
                        Ext.getCmp('sysGeneroPacHCfrm').setValue(selections[0].json.Genero);
                        Ext.getCmp('sysNroExamenHC').setValue(selections[0].json.NroPlacaRef);
                        try {
                            if(selections[0].json.Genero == "F"){
                                var campo3 = Ext.getCmp('sysGeneroPacHC');
                                if ( campo3 != null ) {
                                    if(selections[0].json.Genero == "M"){
                                        Ext.getCmp('sysGeneroPacHC').setValue("MASCULINO");
                                    }else{
                                        Ext.getCmp('sysGeneroPacHC').setValue("FEMENINO");
                                    }
                                }
                            }
                        }catch(ex) {
                        }
                        try {
                            var campo4 = Ext.getCmp('sysEdadPacHC');
                            if ( campo4 != null ) {
                                Ext.getCmp('sysEdadPacHC').setValue(selections[0].json.Edad);
                            }
                        }catch(ex) {
                        }    
                        try {
                            var campo5 = Ext.getCmp('sysFecNacPacHC');
                            if ( campo5 != null ) {
                                Ext.getCmp('sysFecNacPacHC').setValue(selections[0].json.FecNac);
                            }
                        }catch(ex) {
                        }
                        try {
                            var campo6a = Ext.getCmp('sysDatBasEdadHC');
                            if ( campo6a != null ) {
                                Ext.getCmp('sysDatBasEdadHC').setValue(selections[0].json.Edad);
                            }
                        }catch(ex) {
                        }   
                        try {
                            var campo7a = Ext.getCmp('sysDatBasGeneroHC');
                            if ( campo7a != null ) {
                                if(selections[0].json.Genero == "M"){
                                    Ext.getCmp('sysDatBasGeneroHC').setValue("MASCULINO");
                                }else{
                                    Ext.getCmp('sysDatBasGeneroHC').setValue("FEMENINO");
                                }
                            }
                        }catch(ex) {
                        }  
                        try {
                            var campo8 = Ext.getCmp('sysIdCodProcedHC');
                            if ( campo8 !== null ) {
                                Ext.getCmp('sysIdCodProcedHC').setValue(selections[0].json.IdProcedimiento); 
                            }
                        }catch(ex) {
                        }  
                        winHC.show();
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'El estudio esta cerrado y no se puede modificar.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'eOfiClinic',
                msg: 'Debe Seleccionar una Plantilla.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    ImprimirReporte: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() === 1){
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            if (selections[0].json.EstadoTranscripcion !== 'SIN TRANSCRIBIR'){
                switch (NOMAPLICACION){
                    case "OfiMedical":
                        window.open ("../../controlador/asistencial/imprimirhc.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pEvolucion=" + selections[0].json.ConsecutivoHC,"Historia Clinica");
                        break;
                    default:
                        window.open ("../../controlador/asistencial/imprimirhc.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pEvolucion=" + selections[0].json.ConsecutivoHC,"Historia Clinica");
                        break;
                }
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'El registro NO esta disponible para imprimir el reporte.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    },
    CerrarTranscripcion: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() === 1){
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            ID_ESTADO_TRANSCRIPCION = selections[0].json.EstadoTranscripcion;
            if (selections[0].json.EstadoTranscripcion !== 'CERRADO'){
                Ext.Msg.show({
                    title: 'Transcripcion',
                    msg: 'Esta seguro que desea cerrar la transcripcion del CAS: ' + selections[0].json.CAS + '?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn){
                        if(btn=="yes"){
                            Ext.Ajax.request({
                                waitMsg: 'Por favor Espere...',
                                url: '../../controlador/transcribirpato/controlador_transcribirpato.php',
                                params:{
                                    task: 'cerrar_proc',
                                    pCerrar: 1,
                                    pCAS: selections[0].json.CAS,
                                    pConsecutivoDetalle: selections[0].json.ConsecutivoDetalle,
                                    pUsuario: ID_USUARIO
                                },
                                success: function(response,options){
                                    var el = Ext.get('response'); // get the LOG
                                    var Respuesta = response.responseText;
                                    var Contenido = Respuesta.split('^');
                                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'Usted no esta autorizado para cerrar este examen',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    } else {
                                        if(Ext.getCmp('sysFechaAgendaAnatomo').getValue() !== "" || Ext.getCmp('sysFechaAgendaAnatomo').getValue() !== null){
                                            var xFecAgenda = null;
                                        }else{
                                            var xFecAgenda = Ext.getCmp('sysFechaAgendaAnatomo').getValue().format("Y-m-d");
                                        }
                                        switch(Contenido[0]){
                                            case "1":
                                                Ext.getCmp('gridFormulario').store.load({
                                                    params: {
                                                        pPrestador: ID_EMPRESA,
                                                        pIPS: ID_IPS,
                                                        pCAS: Ext.getCmp('sysCASAnatomo').getValue(),
                                                        pFecha: xFecAgenda
                                                    }
                                                });
                                                Ext.MessageBox.show({
                                                    title: 'eOfiClinic',
                                                    msg: 'Se cerro la transcripcion del procedimiento seleccionado',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.INFO
                                                });
                                                break;

                                            default:
                                                Ext.MessageBox.show({
                                                    title: 'Error',
                                                    msg: 'Conexion, No podemos cerrar la transcripcion en estos momentos',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                                break;
                                        }
                                    }
                                },
                                failure: function(response,options){
                                    Ext.MessageBox.show({
                                        title: 'Error',
                                        msg: 'No podemos cerrar la transcripcion en estos momentos',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                }
                            });
                        }
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'El estudio ya esta cerrado.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    CargaDetalleCASTranscribirAnatomo: function(){
        if(Ext.getCmp('sysCASAnatomo').getValue() === null || Ext.getCmp('sysCASAnatomo').getValue() === ""){
            Ext.getCmp('sysCASAnatomo').setValue(0);
        }
        Ext.getCmp('gridFormulario').store.load({
            params: {
                pPrestador: ID_EMPRESA,
                pIPS: ID_IPS,
                pCAS: Ext.getCmp('sysCASAnatomo').getValue()
            }
        });  
    },
    CargaDetalleTranscribirAnatomo: function(f, d) {
        Ext.getCmp('gridFormulario').store.load({
            params: {
                pPrestador: ID_EMPRESA,
                pIPS: ID_IPS,
                pCAS: 0,
                pFecha: d.format("Y-m-d")
            }
        });  
    },
    ActualizarAgenda: function(){
        if(Ext.getCmp('sysFechaAgendaAnatomo').getValue() === null || Ext.getCmp('sysFechaAgendaAnatomo').getValue() === ""){
            Ext.getCmp('sysFechaAgendaAnatomo').setValue(new Date().format("Y-m-d"));
        }
        Ext.getCmp('sysCASAnatomo').setValue(0);
        Ext.getCmp('gridFormulario').store.load({
            params: {
                pPrestador: ID_EMPRESA,
                pIPS: ID_IPS,
                pCAS: 0,
                pFecha: Ext.getCmp('sysFechaAgendaAnatomo').getValue().format("Y-m-d")
            }
        });  
    },
    CerrarVentana: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                   Ext.getCmp('winProfesionalesUi').close();
                }
            }
        });
    }
});
