/*
* @category    Formulario Modelo Reporte Citologia
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCTranscribePato002Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Transcripcion - Citologia ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {

        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        DataBethesCalidadMuestra = new Array();
        DataBethesDescripcion = new Array();
        DataBethesInterpretacion = new Array();
        DataBethesControl = new Array();
        DataBethesMicro = new Array();
        tCalidad = "";
	tDescripcion = "";
	tInterpretacion = "";
	tMicro = "";
        stBethesdaCalidadMuestra = new StoreBethesdaCalidadMuestra();
        stBethesdaDescripcion = new StoreBethesdaDescripcion();
        stBethesdaInterpretacion = new StoreBethesdaInterpretacion();
        stBethesdaControl = new StoreBethesdaControl();
        stBethesdaMicro = new StoreBethesdaMicroorganismos();
        
        
        stBethesdaCalidadMuestra.load();
        stBethesdaCalidadMuestra.on('load', function(store, records) {
            for (var i = 0; i < records.length; i++) {
                var valueToPush = new Array();
                valueToPush[0] = records[i].get('cod_calidad');
                valueToPush[1] = records[i].get('des_calidad');
                valueToPush[2] = records[i].get('nom_calidad');
                DataBethesCalidadMuestra.push(valueToPush);
            }
        });
        
        stBethesdaDescripcion.load();
        stBethesdaDescripcion.on('load', function(store, records) {
            for (var i = 0; i < records.length; i++) {
                var valueToPush = new Array();
                valueToPush[0] = records[i].get('cod_descripcion');
                valueToPush[1] = records[i].get('des_descripcion');
                valueToPush[2] = records[i].get('nom_descripcion');
                DataBethesDescripcion.push(valueToPush);
            }
        });
        
        stBethesdaInterpretacion.load();
        stBethesdaInterpretacion.on('load', function(store, records) {
            for (var i = 0; i < records.length; i++) {
                var valueToPush = new Array();
                valueToPush[0] = records[i].get('cod_interpretacion');
                valueToPush[1] = records[i].get('des_interpretacion');
                valueToPush[2] = records[i].get('nom_interpretacion');
                DataBethesInterpretacion.push(valueToPush);
            }
        });
        
        stBethesdaControl.load();
        stBethesdaControl.on('load', function(store, records) {
            for (var i = 0; i < records.length; i++) {
                var valueToPush = new Array();
                valueToPush[0] = records[i].get('cod_control');
                valueToPush[1] = records[i].get('des_control');
                valueToPush[2] = records[i].get('nom_control');
                DataBethesControl.push(valueToPush);
            }
        });
        
        stBethesdaMicro.load();
        stBethesdaMicro.on('load', function(store, records) {
            for (var i = 0; i < records.length; i++) {
                var valueToPush = new Array();
                valueToPush[0] = records[i].get('cod_micro');
                valueToPush[1] = records[i].get('des_micro');
                valueToPush[2] = records[i].get('nom_micro');
                DataBethesMicro.push(valueToPush);
            }
        });
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        
        var dataCerrarTranscripcion = [
            [1,'SI'],
            [0,'NO']
        ];
        var stCerrarTranscripcion = new Ext.data.ArrayStore({
            fields: [
               {name: 'Codigo'},
               {name: 'Descripcion'}
            ]
        });
        stCerrarTranscripcion.loadData(dataCerrarTranscripcion);
        
        var dataTamanoFuente = [
            [7],
            [8],
            [9],
            [10],
            [11],
            [12]
        ];
        var stTamanoFuente = new Ext.data.ArrayStore({
            fields: [
               {name: 'Tamano'}
            ]
        });
        stTamanoFuente.loadData(dataTamanoFuente);
        
        //Store Locales
        var dataResultadoCitologia = [
            ['NO REALIZADA'],
            ['NORMAL'],
            ['ANORMAL']
        ];
        var stResultadoCitologia = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stResultadoCitologia.loadData(dataResultadoCitologia);
        
        
        var dataProfesional = [
            ['Citotecnologo'],
            ['Patologo']
        ];
        var stProfesional = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stProfesional.loadData(dataProfesional);
        
        var dsPlantillasProced = new Ext.data.Store({
            id: 'dsPlantillasProced',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/profesionales/controlador_profesionales.php',
                method: 'POST'
            }),
            baseParams: {
                task: "PLANTILLA_PROCED_LISTAR"
            },
            loadMask: {msg:"Cargando Registros, por favor espere..."},
            autoload: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
              },[
                {name: 'Codigo'},
                {name: 'Descripcion'},
                {name: 'formatoPlantilla'}
             ])
        });
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                padding: 10,
                border: false,
                height: 610,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodProcedHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Genero',
                        id: 'sysGeneroPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'NroExamen',
                        id: 'sysNroExamenHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                width: 120,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysLegalizaHC'
                            },
                            {
                                html: 'Nro Examen:'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysNroExamenHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 120,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroPacHC'
                            },
                            {
                                html: 'Fecha Nacimiento'
                            },
                            {
                                xtype: 'textfield',
                                width: 120,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFecNacPacHC'
                            },
                            {
                                html: 'Edad'
                            },
                            {
                                xtype: 'textfield',
                                width: 250,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysEdadPacHC'
                            }
                        ]
                    },
                    {
                        xtype: 'tabpanel',
                        width: 930,
                        autoHeight: true,
                        border: false,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Transcripión',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'hidden',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Genero',
                                                id: 'sysGeneroPacHCfrm'
                                            },
                                            {
                                                xtype: 'hidden',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFecNacPacHCfrm'
                                            },
                                            {
                                                xtype: 'hidden',
                                                value: 0,
                                                id: 'sysCerrarTranscriptorHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                id: 'sysHoraAtencionPacienteHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                value: 0,
                                                id: 'sysHoraSalidaPacienteHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                value: 11,
                                                id: 'sysTamanoFuenteHC'
                                            },
                                            {
                                                html: '<hr>'
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Informacion de la Toma de Citologia Remitida por la Entidad',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'datefield',
                                                        width: 120,
                                                        fieldLabel: 'Fecha Toma Citologia',
                                                        name: 'Fecha Toma Citologia',
                                                        allowBlank: true,
                                                        disabledDates: '',
                                                        emptyText: '(dia/mes/año) ',
                                                        style: 'text-align:center;',
                                                        id: 'fecCITFecCitologia'
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'Antecedentes',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 5,
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {   
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Lactancia Actual', 
                                                                        name: 'Lactancia Actual',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        value:'NO',
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strCITLactancia'
                                                                    },
                                                                    {
                                                                        html: 'Fecha Ultima Mestruacion'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Ultima Mestruacion',
                                                                        allowBlank: true,
                                                                        disabledDates: '',
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecCITFecUltMestruacion'
                                                                    },
                                                                    {
                                                                        html: '&nbsp;&nbsp;-&nbsp;&nbsp;G:'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'G',
                                                                        emptyText: 'Gestaciones', 
                                                                        width: 70,
                                                                        minValue: 0,
                                                                        maxValue: 20,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intCITGestaciones'
                                                                    },
                                                                    {
                                                                        html: 'P:'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'P',
                                                                        emptyText: 'Partos', 
                                                                        width: 70,
                                                                        minValue: 0,
                                                                        maxValue: 20,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intCITPartos'
                                                                    },
                                                                    {
                                                                        html: 'A:'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'A',
                                                                        emptyText: 'Abortos', 
                                                                        width: 70,
                                                                        minValue: 0,
                                                                        maxValue: 20,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intCITAbortos'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {   
                                                                        xtype: 'combo',
                                                                        name: 'Embarazo Actual',
                                                                        fieldLabel: 'Embarazo Actual', 
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        value:'NO',
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strCITEmbarazoActual'
                                                                    },
                                                                    {
                                                                        html: 'Metodo Planificacion'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Metodo Planificacion',
                                                                        width: 200,
                                                                        allowBlank: true,
                                                                        store: 'StoreMetodosPlanificacion',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strCITMetodoPlanifica'
                                                                    },
                                                                    {
                                                                        html: 'Tiempo de Uso'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Tiempo de Uso',
                                                                        width: 150,
                                                                        allowBlank: true,
                                                                        id: 'strCITTiempoUso'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Ultima Citologia',
                                                                        fieldLabel: 'Fecha Ultima Citologia',
                                                                        allowBlank: true,
                                                                        disabledDates: '',
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecCITFecUltCitologia'
                                                                    },
                                                                    {
                                                                        html: 'Resultado:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Resultado',
                                                                        width: 150,
                                                                        allowBlank: true,
                                                                        store: stResultadoCitologia,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strCITResultadoCitologia'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'Procedimientos Anteriores en Cuello',
                                                        layout: 'table',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 5,
                                                        layoutConfig: {
                                                            columns: 2
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 420,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Cauterizacion',
                                                                                name: 'Cauterizacion',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolCITCauterizacion',
                                                                                listeners:{
                                                                                    check: function(t, c){
                                                                                        if(c==true){
                                                                                            Ext.getCmp('fecCITCauterizacionFec').enable();
                                                                                            Ext.getCmp('fecCITCauterizacionFec').allowBlank = false;
                                                                                        }else{
                                                                                            Ext.getCmp('fecCITCauterizacionFec').disable();
                                                                                            Ext.getCmp('fecCITCauterizacionFec').clearInvalid();
                                                                                            Ext.getCmp('fecCITCauterizacionFec').setValue(null);
                                                                                            Ext.getCmp('fecCITCauterizacionFec').allowBlank = true;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                xtype: 'datefield',
                                                                                width: 120,
                                                                                allowBlank: true,
                                                                                disabledDates: '',
                                                                                disabled: true,
                                                                                emptyText: '(dia/mes/año) ',
                                                                                style: 'text-align:center;',
                                                                                id: 'fecCITCauterizacionFec'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Histerectomia',
                                                                                name: 'Histerectomia',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolCITHisterectomia',
                                                                                listeners:{
                                                                                    check: function(t, c){
                                                                                        if(c==true){
                                                                                            Ext.getCmp('fecCITHisterectomiaFec').enable();
                                                                                            Ext.getCmp('fecCITHisterectomiaFec').allowBlank = false;
                                                                                        }else{
                                                                                            Ext.getCmp('fecCITHisterectomiaFec').disable();
                                                                                            Ext.getCmp('fecCITHisterectomiaFec').clearInvalid();
                                                                                            Ext.getCmp('fecCITHisterectomiaFec').setValue(null);
                                                                                            Ext.getCmp('fecCITHisterectomiaFec').allowBlank = true;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                xtype: 'datefield',
                                                                                width: 120,
                                                                                allowBlank: true,
                                                                                disabledDates: '',
                                                                                emptyText: '(dia/mes/año) ',
                                                                                style: 'text-align:center;',
                                                                                id: 'fecCITHisterectomiaFec'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Vaporizacion',
                                                                                name: 'Vaporizacion',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolCITVaporizacion',
                                                                                listeners:{
                                                                                    check: function(t, c){
                                                                                        if(c==true){
                                                                                            Ext.getCmp('fecCITVaporizacionFec').enable();
                                                                                            Ext.getCmp('fecCITVaporizacionFec').allowBlank = false;
                                                                                        }else{
                                                                                            Ext.getCmp('fecCITVaporizacionFec').disable();
                                                                                            Ext.getCmp('fecCITVaporizacionFec').clearInvalid();
                                                                                            Ext.getCmp('fecCITVaporizacionFec').setValue(null);
                                                                                            Ext.getCmp('fecCITVaporizacionFec').allowBlank = true;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                xtype: 'datefield',
                                                                                width: 120,
                                                                                allowBlank: true,
                                                                                disabledDates: '',
                                                                                emptyText: '(dia/mes/año) ',
                                                                                style: 'text-align:center;',
                                                                                id: 'fecCITVaporizacionFec'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Conizacion',
                                                                                name: 'Conizacion',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolCITConizacion',
                                                                                listeners:{
                                                                                    check: function(t, c){
                                                                                        if(c==true){
                                                                                            Ext.getCmp('fecCITConizacionFec').enable();
                                                                                            Ext.getCmp('fecCITConizacionFec').allowBlank = false;
                                                                                        }else{
                                                                                            Ext.getCmp('fecCITConizacionFec').disable();
                                                                                            Ext.getCmp('fecCITConizacionFec').clearInvalid();
                                                                                            Ext.getCmp('fecCITConizacionFec').setValue(null);
                                                                                            Ext.getCmp('fecCITConizacionFec').allowBlank = true;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                xtype: 'datefield',
                                                                                width: 120,
                                                                                allowBlank: true,
                                                                                disabledDates: '',
                                                                                emptyText: '(dia/mes/año) ',
                                                                                style: 'text-align:center;',
                                                                                id: 'fecCITConizacionFec'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Crioterapia',
                                                                                name: 'Crioterapia',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolCITCrioterapia',
                                                                                listeners:{
                                                                                    check: function(t, c){
                                                                                        if(c==true){
                                                                                            Ext.getCmp('fecCITCrioterapiaFec').enable();
                                                                                            Ext.getCmp('fecCITCrioterapiaFec').allowBlank = false;
                                                                                        }else{
                                                                                            Ext.getCmp('fecCITCrioterapiaFec').disable();
                                                                                            Ext.getCmp('fecCITCrioterapiaFec').clearInvalid();
                                                                                            Ext.getCmp('fecCITCrioterapiaFec').setValue(null);
                                                                                            Ext.getCmp('fecCITCrioterapiaFec').allowBlank = true;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                xtype: 'datefield',
                                                                                width: 120,
                                                                                allowBlank: true,
                                                                                disabledDates: '',
                                                                                emptyText: '(dia/mes/año) ',
                                                                                style: 'text-align:center;',
                                                                                id: 'fecCITCrioterapiaFec'
                                                                            }
                                                                        ]
                                                                    }

                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 420,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Radioterapia',
                                                                                name: 'Radioterapia',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolCITRadioterapia',
                                                                                listeners:{
                                                                                    check: function(t, c){
                                                                                        if(c==true){
                                                                                            Ext.getCmp('fecCITRadioterapiaFec').enable();
                                                                                            Ext.getCmp('fecCITRadioterapiaFec').allowBlank = false;
                                                                                        }else{
                                                                                            Ext.getCmp('fecCITRadioterapiaFec').disable();
                                                                                            Ext.getCmp('fecCITRadioterapiaFec').clearInvalid();
                                                                                            Ext.getCmp('fecCITRadioterapiaFec').setValue(null);
                                                                                            Ext.getCmp('fecCITRadioterapiaFec').allowBlank = true;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                xtype: 'datefield',
                                                                                width: 120,
                                                                                allowBlank: true,
                                                                                disabledDates: '',
                                                                                emptyText: '(dia/mes/año) ',
                                                                                style: 'text-align:center;',
                                                                                id: 'fecCITRadioterapiaFec'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [        
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Tto Hormonal',
                                                                                name: 'Tto Hormonal',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolCITTtoHormonal',
                                                                                listeners:{
                                                                                    check: function(t, c){
                                                                                        if(c==true){
                                                                                            Ext.getCmp('fecCITTtoHormonalFec').enable();
                                                                                            Ext.getCmp('fecCITTtoHormonalFec').allowBlank = false;
                                                                                        }else{
                                                                                            Ext.getCmp('fecCITTtoHormonalFec').disable();
                                                                                            Ext.getCmp('fecCITTtoHormonalFec').clearInvalid();
                                                                                            Ext.getCmp('fecCITTtoHormonalFec').setValue(null);
                                                                                            Ext.getCmp('fecCITTtoHormonalFec').allowBlank = true;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                xtype: 'datefield',
                                                                                width: 120,
                                                                                allowBlank: true,
                                                                                disabledDates: '',
                                                                                emptyText: '(dia/mes/año) ',
                                                                                style: 'text-align:center;',
                                                                                id: 'fecCITTtoHormonalFec'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Biopsia',
                                                                                name: 'Biopsia',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolCITBiopsia',
                                                                                listeners:{
                                                                                    check: function(t, c){
                                                                                        if(c==true){
                                                                                            Ext.getCmp('fecCITBiopsiaFec').enable();
                                                                                            Ext.getCmp('fecCITBiopsiaFec').allowBlank = false;
                                                                                        }else{
                                                                                            Ext.getCmp('fecCITBiopsiaFec').disable();
                                                                                            Ext.getCmp('fecCITBiopsiaFec').clearInvalid();
                                                                                            Ext.getCmp('fecCITBiopsiaFec').setValue(null);
                                                                                            Ext.getCmp('fecCITBiopsiaFec').allowBlank = true;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                xtype: 'datefield',
                                                                                width: 120,
                                                                                allowBlank: true,
                                                                                disabledDates: '',
                                                                                emptyText: '(dia/mes/año) ',
                                                                                style: 'text-align:center;',
                                                                                id: 'fecCITBiopsiaFec'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Colposcopia',
                                                                                name: 'Colposcopia',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolCITColposcopia',
                                                                                listeners:{
                                                                                    check: function(t, c){
                                                                                        if(c==true){
                                                                                            Ext.getCmp('fecCITColposcopiaFec').enable();
                                                                                            Ext.getCmp('fecCITColposcopiaFec').allowBlank = false;
                                                                                        }else{
                                                                                            Ext.getCmp('fecCITColposcopiaFec').disable();
                                                                                            Ext.getCmp('fecCITColposcopiaFec').clearInvalid();
                                                                                            Ext.getCmp('fecCITColposcopiaFec').setValue(null);
                                                                                            Ext.getCmp('fecCITColposcopiaFec').allowBlank = true;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            },
                                                                            {
                                                                                xtype: 'datefield',
                                                                                width: 120,
                                                                                allowBlank: true,
                                                                                disabledDates: '',
                                                                                emptyText: '(dia/mes/año) ',
                                                                                style: 'text-align:center;',
                                                                                id: 'fecCITColposcopiaFec'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'Aspecto del Cuello',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 5,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                anchor: '100%',
                                                                layout: {
                                                                    columns: 3,
                                                                    type: 'table'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'panel',
                                                                        autoHeight: true,
                                                                        width: 280,
                                                                        layout: {
                                                                            type: 'form'
                                                                        },
                                                                        items: [
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Ausente',
                                                                                name: 'Ausente',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolCITAusente'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Sano',
                                                                                name: 'Sano',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolCITSano'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Atrofico',
                                                                                name: 'Atrofico',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolCITAtrofico'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        autoHeight: true,
                                                                        width: 280,
                                                                        layout: {
                                                                            type: 'form'
                                                                        },
                                                                        items: [
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Congestivo',
                                                                                name: 'Congestivo',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolCITCongestivo'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Ulcerado',
                                                                                name: 'Ulcerado',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolCITUlcerado'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        autoHeight: true,
                                                                        width: 280,
                                                                        layout: {
                                                                            type: 'form'
                                                                        },
                                                                        items: [
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Polipo',
                                                                                name: 'Polipo',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolCITPolipo'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Masa',
                                                                                name: 'Masa',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolCITMasa'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Observaciones de la Toma',
                                                        name: 'Observaciones de la Toma',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memCITObservacionesToma'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RESULTADO',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Calidad de la Muestra',
                                                        name: 'Calidad de la Muestra',
                                                        anchor: '100%',
                                                        allowBlank: false,
                                                        store: 'StoreBethesdaCalidadMuestra',
                                                        valueField: 'cod_calidad',
                                                        displayField: 'des_calidad',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        selecOnFocus: true,
                                                        id: 'strCalidadMuestraCit',
                                                        listeners:{
                                                            select: function(combo,record,index){
                                                                var vCalidad = combo.getValue();
                                                                tCalidad = DevuleveBethesda(vCalidad, DataBethesCalidadMuestra, 2);
                                                                var tObservaciones = "";
                                                                if (tCalidad !== ""){
                                                                    tObservaciones += "<b><u>CALIDAD DE LA MUESTRA:</b></u>" + "<br>" + tCalidad + "\n" + "\n";
                                                                }
                                                                if (tDescripcion !== ""){
                                                                    tObservaciones += "<b><u>DESCRIPCION:</b></u>" + "<br>" + tDescripcion + "<br><br>";
                                                                }
                                                                if (tInterpretacion !== ""){
                                                                    tObservaciones += "<b><u>INTERPRETACION:</b></u>" + "<br>" + tInterpretacion + "<br><br>";
                                                                }
                                                                if (tMicro !== ""){
                                                                    tObservaciones += "<b><u>MICROORGANISMOS:</b></u>" + "<br>" + tMicro + "<br><br>";
                                                                }
                                                                Ext.getCmp('memHTMLResultadoProcedimiento').setValue(tObservaciones);
                                                                if (vCalidad === "105"){
                                                                    Ext.getCmp('strDescripcionCit').allowBlank = true;
                                                                    Ext.getCmp('strInterpretacionCit').allowBlank = true;
                                                                    Ext.getCmp('strMicroorganismoCit').allowBlank = true;
                                                                    Ext.getCmp('strDescripcionCit').setReadOnly(true);
                                                                    Ext.getCmp('strInterpretacionCit').setReadOnly(true);
                                                                    Ext.getCmp('strMicroorganismoCit').setReadOnly(true);
                                                                }else
                                                                {
                                                                    Ext.getCmp('strDescripcionCit').allowBlank = false;
                                                                    Ext.getCmp('strInterpretacionCit').allowBlank = false;
                                                                    Ext.getCmp('strMicroorganismoCit').allowBlank = false;
                                                                    Ext.getCmp('strDescripcionCit').setReadOnly(false);
                                                                    Ext.getCmp('strInterpretacionCit').setReadOnly(false);
                                                                    Ext.getCmp('strMicroorganismoCit').setReadOnly(false);
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Descripcion',
                                                        name: 'Descripcion',
                                                        anchor: '100%',
                                                        allowBlank: false,
                                                        store: 'StoreBethesdaDescripcion',
                                                        valueField: 'cod_descripcion',
                                                        displayField: 'des_descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        selecOnFocus: true,
                                                        id: 'strDescripcionCit',
                                                        listeners:{
                                                            select: function(combo,record,index){
                                                                var vValor = combo.getValue();
                                                                tDescripcion = DevuleveBethesda(vValor, DataBethesDescripcion, 2);
                                                                var tObservaciones = "";
                                                                if (tCalidad !== "")
                                                                {
                                                                    tObservaciones += "<b><u>CALIDAD DE LA MUESTRA:</b></u>" + "<br>" + tCalidad + "<br><br>";
                                                                }

                                                                if (tDescripcion !== "")
                                                                {
                                                                    tObservaciones += "<b><u>DESCRIPCION:</b></u>" + "<br>" + tDescripcion + "<br><br>";
                                                                }

                                                                if (tInterpretacion !== "")
                                                                {
                                                                    tObservaciones += "<b><u>INTERPRETACION:</b></u>" + "<br>" + tInterpretacion + "<br><br>";
                                                                }

                                                                if (tMicro !== "")
                                                                {
                                                                    tObservaciones += "<b><u>MICROORGANISMOS:</b></u>" + "<br>" + tMicro + "<br><br>";
                                                                }
                                                                Ext.getCmp('memHTMLResultadoProcedimiento').setValue(tObservaciones);
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Interpretacion',
                                                        name: 'Interpretacion',
                                                        anchor: '100%',
                                                        allowBlank: false,
                                                        store: 'StoreBethesdaInterpretacion',
                                                        valueField: 'cod_interpretacion',
                                                        displayField: 'des_interpretacion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        selecOnFocus: true,
                                                        id: 'strInterpretacionCit',
                                                        listeners:{
                                                            select: function(combo,record,index){
                                                                //tInterpretacion = DataBethesInterpretacion[index][2];
                                                                var vValor = combo.getValue();
                                                                tInterpretacion = DevuleveBethesda(vValor, DataBethesInterpretacion, 2)
                                                                var tObservaciones = "";
                                                                if (tCalidad !== "")
                                                                {
                                                                    tObservaciones += "<b><u>CALIDAD DE LA MUESTRA:</b></u>" + "<br>" + tCalidad + "<br><br>";
                                                                }

                                                                if (tDescripcion !== "")
                                                                {
                                                                    tObservaciones += "<b><u>DESCRIPCION:</b></u>" + "<br>" + tDescripcion + "<br><br>";
                                                                }

                                                                if (tInterpretacion !== "")
                                                                {
                                                                    tObservaciones += "<b><u>INTERPRETACION:</b></u>" + "<br>" + tInterpretacion + "<br><br>";
                                                                }

                                                                if (tMicro !== "")
                                                                {
                                                                    tObservaciones += "<b><u>MICROORGANISMOS:</b></u>" + "<br>" + tMicro + "<br><br>";
                                                                }
                                                                Ext.getCmp('memHTMLResultadoProcedimiento').setValue(tObservaciones);
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Control Calidad',
                                                        name: 'Control Calidad',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        store: 'StoreBethesdaControl',
                                                        valueField: 'cod_control',
                                                        displayField: 'des_control',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        selecOnFocus: true,
                                                        id: 'strControlCalidadCit'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Microorganismos',
                                                        name: 'Microorganismos',
                                                        anchor: '100%',
                                                        allowBlank: false,
                                                        store: 'StoreBethesdaMicroorganismos',
                                                        valueField: 'cod_micro',
                                                        displayField: 'des_micro',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        selecOnFocus: true,
                                                        id: 'strMicroorganismoCit',
                                                        listeners:{
                                                            select: function(combo,record,index){
                                                                var vValor = combo.getValue();
                                                                tMicro = DevuleveBethesda(vValor, DataBethesMicro, 2)
                                                                var tObservaciones = "";
                                                                if (tCalidad !== "")
                                                                {
                                                                    tObservaciones += "<b><u>CALIDAD DE LA MUESTRA:</b></u>" + "<br>" + tCalidad + "<br><br>";
                                                                }

                                                                if (tDescripcion !== "")
                                                                {
                                                                    tObservaciones += "<b><u>DESCRIPCION:</b></u>" + "<br>" + tDescripcion + "<br><br>";
                                                                }

                                                                if (tInterpretacion !== "")
                                                                {
                                                                    tObservaciones += "<b><u>INTERPRETACION:</b></u>" + "<br>" + tInterpretacion + "<br><br>";
                                                                }

                                                                if (tMicro !== "")
                                                                {
                                                                    tObservaciones += "<b><u>MICROORGANISMOS:</b></u>" + "<br>" + tMicro + "<br><br>";
                                                                }
                                                                Ext.getCmp('memHTMLResultadoProcedimiento').setValue(tObservaciones);
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        fieldLabel: 'Observaciones',
                                                        name: 'Observaciones',
                                                        id: 'strObservacionesGeneralesCit'
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'htmleditor',
                                                                enableColors: false,
                                                                enableAlignments: false,
                                                                enableFont: false,
                                                                enableFontSize: false,
                                                                enableFormat: true,
                                                                enableLinks: false,
                                                                enableLists: false,
                                                                enableSourceEdit: true,
                                                                width: 850,
                                                                name: 'RESULTADO',
                                                                height: 300,
                                                                grow: true,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                emptyText:'Resultado de la Citologia',
                                                                id: 'memHTMLResultadoProcedimiento'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<hr>',
                                                        style: 'background:transparent;',
                                                        border: false
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Quien Realizo',
                                                        anchor: '100%',
                                                        allowBlank: false,
                                                        store: 'StoreProfesionales',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'sysProfesionalHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Quien Reviso',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        store: 'StoreProfesionales',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'sysProfesionalRevisoHC'
                                                    }        
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                anchor: '100%',
                                                autoHeight: true,
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                id: 'fsRIPSAP',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalProc',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalProc').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalProc').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalProc').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalProc').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagPpalProc').getValue() != "" && Ext.getCmp('sysDiagPpalProc').getValue() != null && Ext.getCmp('sysDiagPpalProc').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1Proc').getValue() && Ext.getCmp('sysDiagPpalProc').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2Proc').getValue()){
                                                                            Ext.Ajax.request({
                                                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                                                params:{
                                                                                    task: 'BUSCAR',
                                                                                    pCodigo: Ext.getCmp('sysDiagPpalProc').getValue().toUpperCase()
                                                                                },
                                                                                success: function(response,options)
                                                                                {
                                                                                    var el = Ext.get('response'); // get the LOG
                                                                                    var Respuesta = response.responseText;
                                                                                    var Contenido = Respuesta.split('^');
                                                                                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                        Ext.getCmp('sysDiagPpalProc').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalProcNom').setValue(null);
                                                                                    } else {
                                                                                        Ext.getCmp('sysDiagPpalProc').setValue(Contenido[0].toUpperCase());
                                                                                        Ext.getCmp('sysDiagPpalProcNom').setValue(Contenido[1].toUpperCase());
                                                                                    }
                                                                                },
                                                                                failure: function(response,options){
                                                                                    var el = Ext.get('response');
                                                                                    Ext.getCmp('sysDiagPpalProc').setValue(null);
                                                                                    Ext.getCmp('sysDiagPpalProcNom').setValue(null);
                                                                                },
                                                                                scope:this //bind the callbacks
                                                                            });
                                                                        }else{
                                                                            Ext.getCmp('sysDiagPpalProc').setValue(null);
                                                                            Ext.getCmp('sysDiagPpalProcNom').setValue(null);
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 600,
                                                                height: 22,
                                                                id: 'sysDiagPpalProcNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalProc',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalProc','sysDiagPpalProcNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado',
                                                                id: 'sysDiagRel1Proc',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalProc').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2Proc').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1Proc').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1Proc').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel1ProcNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1Proc').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1Proc').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel1Proc').getValue() != "" && Ext.getCmp('sysDiagRel1Proc').getValue() != null && Ext.getCmp('sysDiagRel1Proc').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalProc').getValue() && Ext.getCmp('sysDiagRel1Proc').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2Proc').getValue()){
                                                                            Ext.Ajax.request({
                                                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                                                params:{
                                                                                    task: 'BUSCAR',
                                                                                    pCodigo: Ext.getCmp('sysDiagRel1Proc').getValue().toUpperCase()
                                                                                },
                                                                                success: function(response,options)
                                                                                {
                                                                                    var el = Ext.get('response'); // get the LOG
                                                                                    var Respuesta = response.responseText;
                                                                                    var Contenido = Respuesta.split('^');
                                                                                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                        Ext.getCmp('sysDiagRel1Proc').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                                                                    } else {
                                                                                        Ext.getCmp('sysDiagRel1Proc').setValue(Contenido[0].toUpperCase());
                                                                                        Ext.getCmp('sysDiagRel1ProcNom').setValue(Contenido[1].toUpperCase());
                                                                                    }
                                                                                },
                                                                                failure: function(response,options){
                                                                                    var el = Ext.get('response');
                                                                                    Ext.getCmp('sysDiagRel1Proc').setValue(null);
                                                                                    Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                                                                },
                                                                                scope:this //bind the callbacks
                                                                            });
                                                                        }else{
                                                                            Ext.getCmp('sysDiagRel1Proc').setValue(null);
                                                                            Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 600,
                                                                height: 22,
                                                                id: 'sysDiagRel1ProcNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado',
                                                                id: 'btnSearchDiagRel1Proc',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1Proc','sysDiagRel1ProcNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Complicación',
                                                                id: 'sysDiagRel2Proc',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalProc').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1Proc').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2Proc').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2Proc').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel2ProcNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2Proc').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2Proc').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel2Proc').getValue() != "" && Ext.getCmp('sysDiagRel2Proc').getValue() != null && Ext.getCmp('sysDiagRel2Proc').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalProc').getValue() && Ext.getCmp('sysDiagRel2Proc').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1Proc').getValue()){
                                                                            Ext.Ajax.request({
                                                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                                                params:{
                                                                                    task: 'BUSCAR',
                                                                                    pCodigo: Ext.getCmp('sysDiagRel2Proc').getValue().toUpperCase()
                                                                                },
                                                                                success: function(response,options)
                                                                                {
                                                                                    var el = Ext.get('response'); // get the LOG
                                                                                    var Respuesta = response.responseText;
                                                                                    var Contenido = Respuesta.split('^');
                                                                                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                        Ext.getCmp('sysDiagRel2Proc').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                                                                    } else {
                                                                                        Ext.getCmp('sysDiagRel2Proc').setValue(Contenido[0].toUpperCase());
                                                                                        Ext.getCmp('sysDiagRel2ProcNom').setValue(Contenido[1].toUpperCase());
                                                                                    }
                                                                                },
                                                                                failure: function(response,options){
                                                                                    var el = Ext.get('response');
                                                                                    Ext.getCmp('sysDiagRel2Proc').setValue(null);
                                                                                    Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                                                                },
                                                                                scope:this //bind the callbacks
                                                                            });
                                                                        }else{
                                                                            Ext.getCmp('sysDiagRel2Proc').setValue(null);
                                                                            Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 600,
                                                                height: 22,
                                                                id: 'sysDiagRel2ProcNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Complicación',
                                                                id: 'btnSearchDiagRel2Proc',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2Proc','sysDiagRel2ProcNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Ambito',
                                                        width:700,
                                                        name: 'Ambito',
                                                        allowBlank: false,
                                                        store: 'StoreAmbitoProcedimiento',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 1,
                                                        id: 'sysAmbitoProc'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Procedimiento',
                                                        width:700,
                                                        name: 'Finalidad Procedimiento',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadProcedimiento',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 1,
                                                        id: 'sysFinalidadProcedimientoProc'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Personal Atiende',
                                                        width:700,
                                                        name: 'Personal Atiende',
                                                        allowBlank: false,
                                                        store: 'StorePersonalAtiendeProcedimiento',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 1,
                                                        id: 'sysPersonalAtiendeProcedimientoProc'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Forma Realización Acto Quirúrgico',
                                                        width:700,
                                                        name: 'Forma Realización Acto Quirúrgico',
                                                        allowBlank: false,
                                                        store: 'StoreFormaRealizacionProcedimiento',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 1,
                                                        id: 'sysFormaRealizaProcedimientoProc'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    if (Ext.getCmp('sysUsaGridSalida').getValue() == 1){
                                                        Ext.getCmp('gridFormulario').store.reload();
                                                    }
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Imagenes Asociadas',
                            iconCls: 'btnCargarFoto',
                            listeners:{
                                click : function(){
                                    if(!winImgxPac){
                                        winImgxPac = new winImagenAsocxPac({
                                            url:'../../controlador/pacientes/controlador_filesasoc.php',
                                            width:515,
                                            height:350
                                        });
                                    }
                                    winImgxPac.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Documentos Asociados',
                            iconCls: 'btnCargarFile',
                            listeners:{
                                click : function(){
                                    if(!winDocxPac){
                                        winDocxPac = new winDocumentoAsocxPac({
                                            url:'../../controlador/pacientes/controlador_docsasoc.php',
                                            width:515,
                                            height:350
                                        });
                                    }
                                    winDocxPac.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Transcripción',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0){
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosPato001();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistrosPato001();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                if(ID_ESTADO_CERRADO !==  "01"){
                    var frm = Ext.getCmp('frmHC').getForm();
                    frm.doAction('load', {
                        url: '../../controlador/transcribirpato/controlador_transcribirpato.php',
                        waitMsg: 'Cargando Información...',
                        params:{
                            pCAS: Ext.getCmp('sysConsecutivoDetalleHC').getValue(), //Ext.getCmp('sysCASHC').getValue(),
                            task: 'cargar_cito'
                        },
                        success:function(form, action) {
                            CargarDataHC(action.result.data.memHTMLResultadoProcedimiento);
                            Ext.getCmp('sysGeneroPacHC').setValue(action.result.data.sysGeneroPacHCfrm);
                            Ext.getCmp('sysFecNacPacHC').setValue(action.result.data.sysFecNacPacHCfrm);
                            Ext.getCmp('sysYaGuardoHC').setValue(1);
                        }
                    });
                }
            }}
        });
        winHCTranscribePato002Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosPato001(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid()){
        frm.submit({
            url: '../../controlador/transcribirpato/controlador_transcribirpato.php',
            params:{
                task: 'guardar_cito',
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCerrar: Ext.getCmp('sysCerrarTranscriptorHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalProc').getValue().toUpperCase(),
                pDiagrel1: Ext.getCmp('sysDiagRel1Proc').getValue().toUpperCase(),
                pDiagrel2: Ext.getCmp('sysDiagRel2Proc').getValue().toUpperCase(),
                pAmbito: Ext.getCmp('sysAmbitoProc').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadProcedimientoProc').getValue(),
                pPersona: Ext.getCmp('sysPersonalAtiendeProcedimientoProc').getValue(),
                pForma: Ext.getCmp('sysFormaRealizaProcedimientoProc').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pTamanoFuente: Ext.getCmp('sysTamanoFuenteHC').getValue(),
                pCITFecCitologia:  Ext.getCmp('fecCITFecCitologia').getValue(),
                pCITLactancia:  Ext.getCmp('strCITLactancia').getValue(),
                pCITFecUltMestruacion:  Ext.getCmp('fecCITFecUltMestruacion').getValue(),
                pCITGestaciones:  Ext.getCmp('intCITGestaciones').getValue(),
                pCITPartos:  Ext.getCmp('intCITPartos').getValue(),
                pCITAbortos:  Ext.getCmp('intCITAbortos').getValue(),
                pCITEmbarazoActual:  Ext.getCmp('strCITEmbarazoActual').getValue(),
                pCITMetodoPlanifica:  Ext.getCmp('strCITMetodoPlanifica').getValue(),
                pCITTiempoUso:  Ext.getCmp('strCITTiempoUso').getValue(),
                pCITFecUltCitologia:  Ext.getCmp('fecCITFecUltCitologia').getValue(),
                pCITResultadoCitologia:  Ext.getCmp('strCITResultadoCitologia').getValue(),
                pCITCauterizacion:  Ext.getCmp('bolCITCauterizacion').getValue(),
                pCITCauterizacionFec:  Ext.getCmp('fecCITCauterizacionFec').getValue(),
                pCITHisterectomia:  Ext.getCmp('bolCITHisterectomia').getValue(),
                pCITHisterectomiaFec:  Ext.getCmp('fecCITHisterectomiaFec').getValue(),
                pCITVaporizacion:  Ext.getCmp('bolCITVaporizacion').getValue(),
                pCITVaporizacionFec:  Ext.getCmp('fecCITVaporizacionFec').getValue(),
                pCITConizacion:  Ext.getCmp('bolCITConizacion').getValue(),
                pCITConizacionFec:  Ext.getCmp('fecCITConizacionFec').getValue(),
                pCITCrioterapia:  Ext.getCmp('bolCITCrioterapia').getValue(),
                pCITCrioterapiaFec:  Ext.getCmp('fecCITCrioterapiaFec').getValue(),
                pCITRadioterapia:  Ext.getCmp('bolCITRadioterapia').getValue(),
                pCITRadioterapiaFec:  Ext.getCmp('fecCITRadioterapiaFec').getValue(),
                pCITTtoHormonal:  Ext.getCmp('bolCITTtoHormonal').getValue(),
                pCITTtoHormonalFec:  Ext.getCmp('fecCITTtoHormonalFec').getValue(),
                pCITBiopsia:  Ext.getCmp('bolCITBiopsia').getValue(),
                pCITBiopsiaFec:  Ext.getCmp('fecCITBiopsiaFec').getValue(),
                pCITColposcopia:  Ext.getCmp('bolCITColposcopia').getValue(),
                pCITColposcopiaFec:  Ext.getCmp('fecCITColposcopiaFec').getValue(),
                pCITAusente:  Ext.getCmp('bolCITAusente').getValue(),
                pCITSano:  Ext.getCmp('bolCITSano').getValue(),
                pCITAtrofico:  Ext.getCmp('bolCITAtrofico').getValue(),
                pCITCongestivo:  Ext.getCmp('bolCITCongestivo').getValue(),
                pCITUlcerado:  Ext.getCmp('bolCITUlcerado').getValue(),
                pCITPolipo:  Ext.getCmp('bolCITPolipo').getValue(),
                pCITMasa:  Ext.getCmp('bolCITMasa').getValue(),
                pCITObservacionesToma:  Ext.getCmp('memCITObservacionesToma').getValue(),
                pBethesdaCalidadMuestra: Ext.getCmp('strCalidadMuestraCit').getValue(),
                pBethesdaDescripcion: Ext.getCmp('strDescripcionCit').getValue(),
                pBethesdaInterpretacion: Ext.getCmp('strInterpretacionCit').getValue(),
                pBethesdaControl: Ext.getCmp('strControlCalidadCit').getValue(),
                pBethesdaMicroorganismos: Ext.getCmp('strMicroorganismoCit').getValue(),
                pBethesdaObservaciones: Ext.getCmp('memHTMLResultadoProcedimiento').getValue(),
                pProfeRealizo: Ext.getCmp('sysProfesionalHC').getValue(),
                pProfeReviso: Ext.getCmp('sysProfesionalRevisoHC').getValue(),
                pNroExamen: Ext.getCmp('sysNroExamenHC').getValue(),
                pObservacionesGeneralesCit: Ext.getCmp('strObservacionesGeneralesCit').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosPato001(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid()){
        frm.submit({
            url: '../../controlador/transcribirpato/controlador_transcribirpato.php',
            params:{
                task: 'modificar_cito',
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCerrar: Ext.getCmp('sysCerrarTranscriptorHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalProc').getValue().toUpperCase(),
                pDiagrel1: Ext.getCmp('sysDiagRel1Proc').getValue().toUpperCase(),
                pDiagrel2: Ext.getCmp('sysDiagRel2Proc').getValue().toUpperCase(),
                pAmbito: Ext.getCmp('sysAmbitoProc').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadProcedimientoProc').getValue(),
                pPersona: Ext.getCmp('sysPersonalAtiendeProcedimientoProc').getValue(),
                pForma: Ext.getCmp('sysFormaRealizaProcedimientoProc').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pTamanoFuente: Ext.getCmp('sysTamanoFuenteHC').getValue(),
                pCITFecCitologia:  Ext.getCmp('fecCITFecCitologia').getValue(),
                pCITLactancia:  Ext.getCmp('strCITLactancia').getValue(),
                pCITFecUltMestruacion:  Ext.getCmp('fecCITFecUltMestruacion').getValue(),
                pCITGestaciones:  Ext.getCmp('intCITGestaciones').getValue(),
                pCITPartos:  Ext.getCmp('intCITPartos').getValue(),
                pCITAbortos:  Ext.getCmp('intCITAbortos').getValue(),
                pCITEmbarazoActual:  Ext.getCmp('strCITEmbarazoActual').getValue(),
                pCITMetodoPlanifica:  Ext.getCmp('strCITMetodoPlanifica').getValue(),
                pCITTiempoUso:  Ext.getCmp('strCITTiempoUso').getValue(),
                pCITFecUltCitologia:  Ext.getCmp('fecCITFecUltCitologia').getValue(),
                pCITResultadoCitologia:  Ext.getCmp('strCITResultadoCitologia').getValue(),
                pCITCauterizacion:  Ext.getCmp('bolCITCauterizacion').getValue(),
                pCITCauterizacionFec:  Ext.getCmp('fecCITCauterizacionFec').getValue(),
                pCITHisterectomia:  Ext.getCmp('bolCITHisterectomia').getValue(),
                pCITHisterectomiaFec:  Ext.getCmp('fecCITHisterectomiaFec').getValue(),
                pCITVaporizacion:  Ext.getCmp('bolCITVaporizacion').getValue(),
                pCITVaporizacionFec:  Ext.getCmp('fecCITVaporizacionFec').getValue(),
                pCITConizacion:  Ext.getCmp('bolCITConizacion').getValue(),
                pCITConizacionFec:  Ext.getCmp('fecCITConizacionFec').getValue(),
                pCITCrioterapia:  Ext.getCmp('bolCITCrioterapia').getValue(),
                pCITCrioterapiaFec:  Ext.getCmp('fecCITCrioterapiaFec').getValue(),
                pCITRadioterapia:  Ext.getCmp('bolCITRadioterapia').getValue(),
                pCITRadioterapiaFec:  Ext.getCmp('fecCITRadioterapiaFec').getValue(),
                pCITTtoHormonal:  Ext.getCmp('bolCITTtoHormonal').getValue(),
                pCITTtoHormonalFec:  Ext.getCmp('fecCITTtoHormonalFec').getValue(),
                pCITBiopsia:  Ext.getCmp('bolCITBiopsia').getValue(),
                pCITBiopsiaFec:  Ext.getCmp('fecCITBiopsiaFec').getValue(),
                pCITColposcopia:  Ext.getCmp('bolCITColposcopia').getValue(),
                pCITColposcopiaFec:  Ext.getCmp('fecCITColposcopiaFec').getValue(),
                pCITAusente:  Ext.getCmp('bolCITAusente').getValue(),
                pCITSano:  Ext.getCmp('bolCITSano').getValue(),
                pCITAtrofico:  Ext.getCmp('bolCITAtrofico').getValue(),
                pCITCongestivo:  Ext.getCmp('bolCITCongestivo').getValue(),
                pCITUlcerado:  Ext.getCmp('bolCITUlcerado').getValue(),
                pCITPolipo:  Ext.getCmp('bolCITPolipo').getValue(),
                pCITMasa:  Ext.getCmp('bolCITMasa').getValue(),
                pCITObservacionesToma:  Ext.getCmp('memCITObservacionesToma').getValue(),
                pBethesdaCalidadMuestra: Ext.getCmp('strCalidadMuestraCit').getValue(),
                pBethesdaDescripcion: Ext.getCmp('strDescripcionCit').getValue(),
                pBethesdaInterpretacion: Ext.getCmp('strInterpretacionCit').getValue(),
                pBethesdaControl: Ext.getCmp('strControlCalidadCit').getValue(),
                pBethesdaMicroorganismos: Ext.getCmp('strMicroorganismoCit').getValue(),
                pBethesdaObservaciones: Ext.getCmp('memHTMLResultadoProcedimiento').getValue(),
                pProfeRealizo: Ext.getCmp('sysProfesionalHC').getValue(),
                pProfeReviso: Ext.getCmp('sysProfesionalRevisoHC').getValue(),
                pNroExamen: Ext.getCmp('sysNroExamenHC').getValue(),
                pObservacionesGeneralesCit: Ext.getCmp('strObservacionesGeneralesCit').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

