/*
* @category    Formulario Grid Agenda Transcripcion Imagenes Diagnosticas
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmVerTranscripcionImgDxUi = Ext.extend(Ext.Window, {
    //title: 'OfiClinic© Web..! .:: Agenda por Profesional ::.',
    id: 'winFrmVerAgenda',
    closable:false,
    draggable : false,
    width:980,
    height:480,
    plain:true,
    resizable : false,
    y:120,
    padding: 5,
    maximized: true,
    frame: true,
    layout: 'form',
    initComponent: function() {
        function VerHoraLegaliza(value, metaData, record, rowIndex, colIndex, store){
            metaData.attr = '<style="white-space:normal;"';
            return '<p style="color: red; font-weight:bold; text-decoration:blink; text-align:center;">'+value + '</p>Hora Estimada Atención: </br>' + record.get('HoraAtencion');
	}
        
        function VerPaciente(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return '<p>' + record.get('TipDoc') + '-' + record.get('Documento') + '</br>' + record.get('PrimerNombre') + ' ' + record.get('SegundoNombre') + ' ' + record.get('PrimerApellido') + ' ' + record.get('SegundoApellido') + '</br>Genero: ' + record.get('Genero') + ' FecNac: ' + record.get('FecNac') + '</br>' + record.get('Edad');  
        }
        
        function VerCita(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return value;  
        }
        
        function VerCAS(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return record.get('CAS') + '</br>' + record.get('DescEstadoReg');  
        }
        
        function VerCliente(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return record.get('Cliente') + '</br>' + record.get('Actividad');  
        }
        
        var stGrid = new StoreGridTrascribirImgDx();
        var mybbar = new utilBbarUi();
        this.bbar = mybbar;
        this.items = [
            {
                xtype: 'tabpanel',
                //width: 990,
                height: screen.height,
                border: false,
                ref: 'fTabPanel',
                id: 'fTabPanel',
                activeTab: 0,
                items: [
                    {
                        xtype: 'panel',
                        title: 'Procedimientos a Transcribir',
                        height: screen.height-240,
                        //width: 951,
                        frame: true,
                        border: false,
                        layout: 'form',
                        id: 'fichaDatos',
                        labelWidth: 1,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        html: 'FECHA:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        allowBlank: false,
                                        style: 'text-align:center;',
                                        emptyText: '(dia/mes/año) ',
                                        id: 'sysFechaAgendaImgDx'
                                    },
                                    {
                                        html: ' - CAS:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        width: 120,
                                        allowBlank: true,
                                        id: 'sysCASImgDx'
                                    },
                                    {
                                        xtype: 'button',
                                        text: 'Buscar CAS',
                                        iconCls: 'btnBuscar',
                                        tooltip: 'Buscar CAS',
                                        id: 'btnCASImgDx'
                                    },
                                    {
                                        html: ' - PACIENTE:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        emptyText: 'Nro Documento...!',
                                        id: 'searchpDocumentoImgDx',
                                        width: 110
                                    },
                                    {
                                        xtype: 'textfield',
                                        emptyText: '1er Nombre...!',
                                        id: 'searchpNom1ImgDx',
                                        width: 110
                                    },
                                    {
                                        xtype: 'textfield',
                                        emptyText: '2do Nombre...!',
                                        id: 'searchpNom2ImgDx',
                                        width: 110
                                    },
                                    {
                                        xtype: 'textfield',
                                        emptyText: '1er Apellido...!',
                                        id: 'searchpApe1ImgDx',
                                        width: 110
                                    },
                                    {
                                        xtype: 'textfield',
                                        emptyText: '2do Apellido...!',
                                        id: 'searchpApe2ImgDx',
                                        width: 110
                                    },
                                    {
                                        xtype: 'button',
                                        tooltip: 'Buscar Paciente',
                                        text: 'Buscar Paciente',
                                        iconCls: 'btnBuscar',
                                        id: 'btnEjecutarSearchPacImgDx',
                                        listeners:{
                                            click: function(){
                                                Ext.getCmp('gridFormulario').store.load({
                                                    params: {
                                                        task: 'LISTAR_TRANSCRIBIR_IMGDX_PAC',
                                                        pPrestador: ID_EMPRESA,
                                                        pIPS: ID_IPS,
                                                        pNomBaseDatos: BD_MULTIPRESTADOR,
                                                        pDocumento: QuitarAcentosTxtMayusculas(Ext.getCmp('searchpDocumentoImgDx').getValue().toUpperCase()),
                                                        pNom1: QuitarAcentosTxtMayusculas(Ext.getCmp('searchpNom1ImgDx').getValue().toUpperCase()),
                                                        pNom2: QuitarAcentosTxtMayusculas(Ext.getCmp('searchpNom2ImgDx').getValue().toUpperCase()),
                                                        pApe1: QuitarAcentosTxtMayusculas(Ext.getCmp('searchpApe1ImgDx').getValue().toUpperCase()),
                                                        pApe2: QuitarAcentosTxtMayusculas(Ext.getCmp('searchpApe2ImgDx').getValue().toUpperCase())
                                                    }
                                                });
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'button',
                                        tooltip: 'Limpiar Datos del Paciente',
                                        text: 'Limpiar',
                                        iconCls: 'btnLimpiar',
                                        id: 'btnLimpiarSearchPac',
                                        listeners:{
                                            click: function(){
                                                Ext.getCmp('searchpDocumentoImgDx').setValue(null);
                                                Ext.getCmp('searchpNom1ImgDx').setValue(null);
                                                Ext.getCmp('searchpNom2ImgDx').setValue(null);
                                                Ext.getCmp('searchpApe1ImgDx').setValue(null);
                                                Ext.getCmp('searchpApe2ImgDx').setValue(null);
                                                Ext.getCmp('sysCASImgDx').setValue(0);
                                                Ext.getCmp('gridFormulario').store.load({
                                                    params: {
                                                        pPrestador: ID_EMPRESA,
                                                        pIPS: ID_IPS,
                                                        pCAS: Ext.getCmp('sysCASImgDx').getValue(),
                                                        pFecha: new Date().format("Y-m-d")
                                                    }
                                                });
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'grid',
                                id: 'gridFormulario',
                                store: stGrid,
                                layout: 'fit',
                                anchor: "100%",
                                height: screen.height-250,
                                border: false,
                                frame: true,
                                loadMask: true,
                                stripeRows: true,
                                colModel: new Ext.ux.grid.LockingColumnModel([
                                    {
                                        header: 'CAS',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'CAS',
                                        renderer: VerCAS,
                                        width: 120,
                                        hideable: false
                                    },
                                    {
                                        header: 'Hora',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'HoraAgenda',
                                        renderer: VerCita,
                                        width: 110,
                                        hideable: false
                                    },
                                    {
                                        header: 'Hora Legalización',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'FechaLegaliza',
                                        width: 130,
                                        renderer: VerHoraLegaliza,
                                        hideable: false
                                    },
                                    {
                                        header: 'Paciente',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'Paciente',
                                        width: 330,
                                        renderer: VerPaciente,
                                        hideable: false
                                    },
                                    {
                                        header: 'Cliente',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'Cliente',
                                        width: 250,
                                        renderer: VerCliente,
                                        hideable: false
                                    },
                                    {
                                        header: 'Profesional',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'Profesional',
                                        width: 250,
                                        hideable: false
                                    }
                                ]),
                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                view: new Ext.ux.grid.LockingGridView(),
                                columnLines: true,
                                tbar:
                                    {
                                        xtype: 'toolbar',
                                        items: [
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Actualizar Lista',
                                                iconCls: 'btnActualizarGrid',
                                                tooltip: 'Actualizar Lista',
                                                id: 'btnActualizarImgDx'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Cerrar Transcripcion',
                                                iconCls: 'btnCerrar',
                                                tooltip: 'Cerrar Transcripcion',
                                                id: 'btnCerrarImgDx'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            
                                            {
                                                xtype: 'tbfill'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Imprimir Reporte',
                                                iconCls: 'btnImprimir',
                                                tooltip: 'Imprimir Reporte',
                                                id: 'btnimprimirImgDx'
                                            }
                                        ]
                                    },
                                bbar:
                                    {
                                        xtype: 'toolbar',
                                        items: [
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Evolucionar Paciente',
                                                iconCls: 'btnEvolucionar',
                                                tooltip: 'Evolucionar Paciente',
                                                id: 'btnEvolucionar'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            }
                                        ]
                                    }
                            }
                        ]
                    }
                ]
            }
        ];
        winFrmVerTranscripcionImgDxUi.superclass.initComponent.call(this);
    }
});








