/*
* @category    Fieldset Identificacion del Estudiante
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsIDEstudianteUi = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    //collapseFirst: false,
    collapsible: false,
    //animCollapse: true,
    //titleCollapse: true,
    labelWidth: 70,
    layout: 'form',
    title: 'Identificacion del Estudiante',
    padding: 0,
    id: 'fsIDEstudiante',
    initComponent: function() {
        this.items = [
            {
                xtype: 'hidden',
                id: 'sysIDEstudiante',
                value: 0
            },
            {
                xtype: 'compositefield',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'textfield',
                        width: 96,
                        allowBlank: false,
                        fieldLabel: 'Codigo',
                        id: 'sysCodigoEstudiante',
                        listeners:{
                            specialkey: function(f,e){
                                if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                {
                                    if (f.getValue() !== "" && f.getValue() !== null){
                                        Ext.Ajax.request({
                                            url: '../../controlador/uautonoma/controlador_estudiante.php',
                                            params:{
                                                task: 'BUSCAR_AGENDA',
                                                pCodigo: f.getValue().toUpperCase()
                                            },
                                            success: function(response,options)
                                            {
                                                var el = Ext.get('response'); // get the LOG
                                                var Respuesta = response.responseText;
                                                var Contenido = Respuesta.split('^');
                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                    Ext.getCmp('sysIDEstudiante').setValue(0);
                                                    Ext.getCmp('sysCodigoEstudiante').setValue(null);
                                                    Ext.getCmp('sysCodigoEstudianteNom').setValue(null);
                                                    
                                                    Ext.getCmp('sysProfeAgenda').store.removeAll();
                                                    Ext.getCmp('sysUbicacionAgenda').store.removeAll();
                                                    Ext.getCmp('gridFormulario').store.removeAll();
                                                    
                                                    Ext.getCmp('sysProfeAgenda').setValue(null);
                                                    Ext.getCmp('sysUbicacionAgenda').setValue(null);
                                                    Ext.getCmp('sysFechaAgenda').setValue(null);
                                                    
                                                } else {
                                                    Ext.getCmp('sysIDEstudiante').setValue(Contenido[0]);
                                                    Ext.getCmp('sysCodigoEstudiante').setValue(Contenido[1].toUpperCase());
                                                    Ext.getCmp('sysCodigoEstudianteNom').setValue(Contenido[2].toUpperCase());
                                                    
                                                    Ext.getCmp('sysProfeAgenda').setValue(null);
                                                    Ext.getCmp('sysUbicacionAgenda').setValue(null);
                                                    Ext.getCmp('sysFechaAgenda').setValue(null);
                                                    Ext.getCmp('sysUbicacionAgenda').store.removeAll();
                                                    Ext.getCmp('gridFormulario').store.removeAll();
                                                    
                                                    Ext.getCmp('sysProfeAgenda').store.load({
                                                        params: {
                                                            pEstudiante: Ext.getCmp('sysIDEstudiante').getValue()
                                                        }
                                                    });
                                                }
                                            },
                                            failure: function(response,options){
                                                var el = Ext.get('response');
                                                Ext.getCmp('sysIDEstudiante').setValue(0);
                                                Ext.getCmp('sysCodigoEstudiante').setValue(null);
                                                Ext.getCmp('sysCodigoEstudianteNom').setValue(null);
                                                
                                                Ext.getCmp('sysProfeAgenda').store.removeAll();
                                                Ext.getCmp('sysUbicacionAgenda').store.removeAll();
                                                Ext.getCmp('gridFormulario').store.removeAll();
                                                Ext.getCmp('sysProfeAgenda').setValue(null);
                                                Ext.getCmp('sysUbicacionAgenda').setValue(null);
                                                Ext.getCmp('sysFechaAgenda').setValue(null);
                                            },
                                            scope:this //bind the callbacks
                                        });
                                    }else{
                                        Ext.getCmp('sysIDEstudiante').setValue(0);
                                        Ext.getCmp('sysCodigoEstudiante').setValue(null);
                                        Ext.getCmp('sysCodigoEstudianteNom').setValue(null);
                                        
                                        Ext.getCmp('sysProfeAgenda').store.removeAll();
                                        Ext.getCmp('sysUbicacionAgenda').store.removeAll();
                                        Ext.getCmp('gridFormulario').store.removeAll();
                                        
                                        Ext.getCmp('sysProfeAgenda').setValue(null);
                                        Ext.getCmp('sysUbicacionAgenda').setValue(null);
                                        Ext.getCmp('sysFechaAgenda').setValue(null);
                                    }
                                }
                            }
                        }
                    },
                    {
                        xtype: 'textarea',
                        readOnly: true,
                        width: 750,
                        height: 22,
                        id: 'sysCodigoEstudianteNom'
                    }
                ]
            }
        ];
        fsIDEstudianteUi.superclass.initComponent.call(this);
    }
});
