/*
* @category    Formulario Modelo Anexo Alineacion Postural
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winAnexoAlineacionPosturalUi = Ext.extend(Ext.Window, {
    title: '.:: ANEXO Alineacion Postural ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winAnexoAlineacionPostural',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '99%',
                height: 605,
                id: 'frmAnexoAlineacionPostural',
                padding: 5,
                border: false,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysCASAnexoAlineacionPostural'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysPacienteAnexoAlineacionPostural'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysProfesionalAnexoAlineacionPostural'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysYaGuardoAnexoAlineacionPostural'
                    },
                    {
                        xtype: 'fieldset',
                        title: 'PLANO FRONTAL - VISTA POSTERIOR',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '98%',
                        autoHeight: true,
                        padding: 7,
                        items: [
                            {
                                xtype: 'fieldset',
                                title: '1. Desplazamiento Lateral en relacion con la linea de la plomada (cm)',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '98%',
                                autoHeight: true,
                                padding: 7,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                width: 60,
                                                fieldLabel: 'Cabeza: N-S',
                                                allowBlank: true,
                                                id: 'strAP1aNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP1aDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP1aIzq'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                width: 60,
                                                fieldLabel: 'Columna Vertebral: N-S',
                                                allowBlank: true,
                                                id: 'strAP1bNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP1bDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP1bIzq'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                width: 60,
                                                fieldLabel: 'Pliegue Intergluteo: N-S',
                                                allowBlank: true,
                                                id: 'strAP1cNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP1cDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP1cIzq'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                title: '2. Alineacion de la Columna Cervical',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '98%',
                                autoHeight: true,
                                padding: 7,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                width: 60,
                                                labelWidth: 450,
                                                fieldLabel: 'Inclinada (Distancia en cm entre la base de la Oreja y la punta del Acromion): N-S',
                                                allowBlank: true,
                                                id: 'strAP2aNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP2aDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP2aIzq'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                title: '3. Nivelacion de los hombros',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '98%',
                                autoHeight: true,
                                padding: 7,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                width: 60,
                                                fieldLabel: 'Ascendido: N-S',
                                                allowBlank: true,
                                                id: 'strAP3aNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP3aDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP3aIzq'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                width: 60,
                                                fieldLabel: 'Descendido: N-S',
                                                allowBlank: true,
                                                id: 'strAP3bNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP3bDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP3bIzq'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                title: '4. Pocision, ubicacion y nivelacion de las Escapulas',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '98%',
                                autoHeight: true,
                                padding: 7,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Asimetria (Lateralizacion de las escapulas valor en cm): N-S',
                                                labelwidth: 350,
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP4aNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP4aDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP4aIzq'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                title: '5. Alineacion de la Columna Vertebral',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '98%',
                                autoHeight: true,
                                padding: 7,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Desviacion lateral (Dorsal, Dorsolumbar, Lumbar: N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP5aNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP5aDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP5aIzq'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                title: '6. Alineacion delTendon de Aquiles',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '98%',
                                autoHeight: true,
                                padding: 7,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Talon Valgo: N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP6aNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP6aDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP6aIzq'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Talon Varo: N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP6bNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP6bDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP6bIzq'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                title: '7. Prueba de Adams (Descripcion de los Hallazgos)',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '98%',
                                autoHeight: true,
                                padding: 7,
                                items: [
                                    {
                                        xtype: 'textarea',
                                        anchor: '98%',
                                        labelWidth: 10,
                                        name: 'Prueba de Adams',
                                        height: 100,            
                                        allowBlank: false,
                                        id: 'memAP7'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'PLANO FRONTAL - VISTA ANTERIOR',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '98%',
                        autoHeight: true,
                        padding: 7,
                        items: [
                            {
                                xtype: 'fieldset',
                                title: '1. Simetria Facial)',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '98%',
                                autoHeight: true,
                                padding: 7,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Asimetria (Medida base Oreja hasta Menton): N-S',
                                                width: 60,
                                                labelWidth: 250,
                                                allowBlank: true,
                                                id: 'strAP8aNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP8aDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP8aIzq'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                title: '2. Nivelacion de los Hombros (linea que une el acromion y las Claviculas)',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '98%',
                                autoHeight: true,
                                padding: 7,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Ascendido: N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP9aNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP9aDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP9aIzq'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Descendido: N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP9bNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP9bDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP9bIzq'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                title: '3. Nivelacion de los Pezones',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '98%',
                                autoHeight: true,
                                padding: 7,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Ascendido: N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP10aNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP10aDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP10aIzq'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                title: '4. Simetria del Torax',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '98%',
                                autoHeight: true,
                                padding: 7,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Asimetrico (prominente): N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP11aNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP11aDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP11aIzq'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'En Paloma: N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP11bNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP11bDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP11bIzq'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Excavado: N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP11cNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP11cDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP11cIzq'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'En tonel: N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP11dNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP11dDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP11dIzq'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                title: '5. Angulo del Talle',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '98%',
                                autoHeight: true,
                                padding: 7,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Asimetrico (Disminuido o abolido): N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP12aNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP12aDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP12aIzq'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                title: '6. Nivelacion de las Espinas Iliacas Antero Superiores (E.I.A.S)',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '98%',
                                autoHeight: true,
                                padding: 7,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Ascendida: N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP13aNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP13aDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP13aIzq'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Descendida: N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP13bNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP13bDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP13bIzq'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                title: '7. Alineacion del Femur',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '98%',
                                autoHeight: true,
                                padding: 7,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Torsion Interna: N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP14aNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP14aDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP14aIzq'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Torsion Externa: N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP14bNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP14bDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP14bIzq'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                title: '8. Alineacion de las Rodillas',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '98%',
                                autoHeight: true,
                                padding: 7,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Varo (Distancia intercondilea en cm): N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP15aNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP15aDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP15aIzq'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Valgo (Distancia intermaleolar en cm): N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP15bNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP15bDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP15bIzq'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                title: '9. Alineacion de las Paletas',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '98%',
                                autoHeight: true,
                                padding: 7,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Desviacion Lateral: N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP16aNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP16aDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP16aIzq'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Desviacion Medial: N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP16bNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP16bDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP16bIzq'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                title: '10. Alineacion de la tibia',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '98%',
                                autoHeight: true,
                                padding: 7,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Torsion Interna: N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP17aNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP17aDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP17aIzq'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Torsion Externa: N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP17bNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP17bDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP17bIzq'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        name: 'N-S',
                                        fieldLabel: '11. Forma y Disposicion espacial de los dedos del Pie(Hallux Valgus HV, Dedo en Martillo DM, Pie Egipcio PE):: N-S',
                                        width: 60,
                                        labelWidth: 400,
                                        allowBlank: true,
                                        id: 'strAP18aNS'
                                    },
                                    {
                                        html: 'Derecha'
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Derecha',
                                        width: 60,
                                        allowBlank: true,
                                        id: 'strAP18aDer'
                                    },
                                    {
                                        html: 'Izquierda'
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Izquierda',
                                        width: 60,
                                        allowBlank: true,
                                        id: 'strAP18aIzq'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'PLANO SAGITAL - VISTA LATERAL',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '98%',
                        autoHeight: true,
                        padding: 7,
                        items: [
                            {
                                xtype: 'fieldset',
                                title: '1. Posicion de la Cabeza en relacion con la Linea de la Plonada',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '98%',
                                autoHeight: true,
                                padding: 7,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Desplazamiento hacia adelante: N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP19aNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP19aDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP19aIzq'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Desplazamiento hacia atras: N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP19bNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP19bDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP19bIzq'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                title: '2. Alineacion de los Hombros',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '98%',
                                autoHeight: true,
                                padding: 7,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Protraccion (Desplazamiento Anterior): N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP20aNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP20aDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP20aIzq'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                html: ':'
                                            },
                                            {
                                                html: 'N-S'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Protraccion (Desplazamiento Posterior): N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP20bNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP20bDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP20bIzq'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                title: '3. Curvas Fisiologicas de Columna Vertebral',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '98%',
                                autoHeight: true,
                                padding: 7,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'a. Lordosis Cervical: N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP21aNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP21aDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP21aIzq'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Hiperlordosis: N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP21bNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP21bDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP21bIzq'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Borramiento o Aplanamiento: N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP21cNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP21cDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP21cIzq'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'b. Cifosis Dorsal: N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP21dNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP21dDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP21dIzq'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Hipercifosis: N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP21dNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP21dDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP21dIzq'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Disminucion o Borramiento: N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP21dNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP21dDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP21dIzq'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'c. Lordosis Lumbar: N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP21eNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP21eDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP21eIzq'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Hiperlordosis: N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP21fNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP21fDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP21fIzq'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                title: '4. Posicion de los brazos con respecto al tronco (Paralelos al tronco y los Muslos-Normal)',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '98%',
                                autoHeight: true,
                                padding: 7,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Desplazamiento hacia Adelante: N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP22aNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP22aDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP22aIzq'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Desplazamiento hacia Atras: N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP22bNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP22bDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP22bIzq'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                title: '5. Alineacion y forma del abdomen',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '98%',
                                autoHeight: true,
                                padding: 7,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Prominente: N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP23aNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP23aDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP23aIzq'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                title: '6. Alineacion de las Rodillas',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '98%',
                                autoHeight: true,
                                padding: 7,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Recurvatum (Hiperextension): N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP24aNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP24aDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP24aIzq'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Antecurvatum (Flexum): N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP24bNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP24bDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP24bIzq'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                title: '6. Altura y alineacion del arco longitudinal medial del pie',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '98%',
                                autoHeight: true,
                                padding: 7,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Aumentado (Pie Cavo): N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP25aNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP25aDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP25aIzq'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Disminuido (Pie Plano): N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP25bNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP25bDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP25bIzq'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'N-S',
                                                fieldLabel: 'Abolido (Pie Plano): N-S',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP25cNS'
                                            },
                                            {
                                                html: 'Derecha'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Derecha',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP25cDer'
                                            },
                                            {
                                                html: 'Izquierda'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Izquierda',
                                                width: 60,
                                                allowBlank: true,
                                                id: 'strAP25cIzq'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'LONGITUD DE MMII',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '98%',
                        autoHeight: true,
                        padding: 7,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        name: 'N-S',
                                        fieldLabel: 'Medida Real: N-S',
                                        width: 60,
                                        allowBlank: true,
                                        id: 'strAP26aNS'
                                    },
                                    {
                                        html: 'Derecha'
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Derecha',
                                        width: 60,
                                        allowBlank: true,
                                        id: 'strAP26aDer'
                                    },
                                    {
                                        html: 'Izquierda'
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Izquierda',
                                        width: 60,
                                        allowBlank: true,
                                        id: 'strAP26aIzq'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        name: 'N-S',
                                        fieldLabel: 'Medida Aparente: N-S',
                                        width: 60,
                                        allowBlank: true,
                                        id: 'strAP26bNS'
                                    },
                                    {
                                        html: 'Derecha'
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Derecha',
                                        width: 60,
                                        allowBlank: true,
                                        id: 'strAP26bDer'
                                    },
                                    {
                                        html: 'Izquierda'
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Izquierda',
                                        width: 60,
                                        allowBlank: true,
                                        id: 'strAP26bIzq'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'LONGITUD DE MMSS',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '98%',
                        autoHeight: true,
                        padding: 7,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        name: 'N-S',
                                        fieldLabel: 'Medida Real: N-S',
                                        width: 60,
                                        allowBlank: true,
                                        id: 'strAP27aNS'
                                    },
                                    {
                                        html: 'Derecha'
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Derecha',
                                        width: 60,
                                        allowBlank: true,
                                        id: 'strAP27aDer'
                                    },
                                    {
                                        html: 'Izquierda'
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Izquierda',
                                        width: 60,
                                        allowBlank: true,
                                        id: 'strAP27aIzq'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        name: 'N-S',
                                        fieldLabel: 'Medida Aparente: N-S',
                                        width: 60,
                                        allowBlank: true,
                                        id: 'strAP27bNS'
                                    },
                                    {
                                        html: 'Derecha'
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Derecha',
                                        width: 60,
                                        allowBlank: true,
                                        id: 'strAP27bDer'
                                    },
                                    {
                                        html: 'Izquierda'
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Izquierda',
                                        width: 60,
                                        allowBlank: true,
                                        id: 'strAP27bIzq'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'textarea',
                        anchor: '98%',
                        fieldLabel: 'Observaciones',
                        name: 'Observaciones',
                        height: 100,            
                        allowBlank: true,
                        id: 'memAPObservaciones'
                    },
                    {
                        xtype: 'textarea',
                        anchor: '98%',
                        fieldLabel: 'Interpretacion de Resultados',
                        name: 'Interpretacion de Resultados',
                        height: 100,            
                        allowBlank: true,
                        id: 'memAPInterpretacionResultados'
                    },
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirAnexoAlineacionPostural',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoAnexoAlineacionPostural').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('winAnexoAlineacionPostural').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado el Anexo y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('winAnexoAlineacionPostural').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Anexo',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarAnexoAlineacionPostural',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoAnexoAlineacionPostural').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar el Anexo?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarAnexoAlineacionPostural();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar el Anexo?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarAnexoAlineacionPostural();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        
        winAnexoAlineacionPosturalUi.superclass.initComponent.call(this);
    }
});

function fnGuardarAnexoAlineacionPostural(){
    var frm = Ext.getCmp('frmAnexoAlineacionPostural').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/fisioterapia/controlador_fisioterapia.php',
            params:{
                task: 'GuardarAnexoAlineacionPostural',
                CAMPOS: listacampos,
                pPaciente: Ext.getCmp('sysPacienteAnexoAlineacionPostural').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalAnexoAlineacionPostural').getValue(),
                pCAS: Ext.getCmp('sysCASAnexoAlineacionPostural').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoAnexoAlineacionPostural').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarAnexoAlineacionPostural(){
    var frm = Ext.getCmp('frmAnexoAlineacionPostural').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/fisioterapia/controlador_fisioterapia.php',
            params:{
                task: 'ModificarAnexoAlineacionPostural',
                CAMPOS: listacampos,
                pPaciente: Ext.getCmp('sysPacienteAnexoAlineacionPostural').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalAnexoAlineacionPostural').getValue(),
                pCAS: Ext.getCmp('sysCASAnexoAlineacionPostural').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoAnexoAlineacionPostural').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
