/*
* @category    Formulario Modelo Anexo Escala de Aschworth Modificada
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winAnexoEscalaAschworthUi = Ext.extend(Ext.Window, {
    title: '.:: ANEXO Escala de Aschworth Modificada ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winAnexoEscalaAschworth',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '99%',
                height: 605,
                id: 'frmAnexoEscalaAschworth',
                padding: 5,
                border: false,
                autoScroll: true,
                labelWidth: 600,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysCASAnexoEscalaAschworth'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysPacienteAnexoEscalaAschworth'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysProfesionalAnexoEscalaAschworth'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysYaGuardoAnexoEscalaAschworth'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(0 )Tono Muscular Normal',
                        name: '(0 )Tono Muscular Normal',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEA1'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(1 )Incremento leve del tono muscular; aumento minimo de resistencia al final del arco de movimiento cuando el segmento afectado se mueve en flexion o en extension.',
                        name: '(1 )Incremento leve del tono muscular; aumento minimo de resistencia al final del arco de movimiento cuando el segmento afectado se mueve en flexion o en extension.',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEA2'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(1+) Incremento leve del tono muscular; aumenta la resistencia en menos de la mitad del arco de movimiento',
                        name: '(1+) Incremento leve del tono muscular; aumenta la resistencia en menos de la mitad del arco de movimiento',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEA3'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(2 )Aumento acentuado del tono muscular en la mayor parte del arco de movimiento, pero el segmento evaluado puede moverse facilmente',
                        name: '(2 )Aumento acentuado del tono muscular en la mayor parte del arco de movimiento, pero el segmento evaluado puede moverse facilmente',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEA4'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(3 )Aumento considerable del tono muscular; dificulta para el movimiento pasivo del segmento comprometido o evaluado',
                        name: '(3 )Aumento considerable del tono muscular; dificulta para el movimiento pasivo del segmento comprometido o evaluado',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEA5'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(4 )Segmento afectado rigido en flexion o en extension',
                        name: '(4 )Segmento afectado rigido en flexion o en extension',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEA6'
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirAnexoEscalaAschworth',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoAnexoEscalaAschworth').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('winAnexoEscalaAschworth').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado el Anexo y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('winAnexoEscalaAschworth').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Anexo',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarAnexoEscalaAschworth',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoAnexoEscalaAschworth').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar el Anexo?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarAnexoEscalaAschworth();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar el Anexo?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarAnexoEscalaAschworth();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        
        winAnexoEscalaAschworthUi.superclass.initComponent.call(this);
    }
});

function fnGuardarAnexoEscalaAschworth(){
    var frm = Ext.getCmp('frmAnexoEscalaAschworth').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/fisioterapia/controlador_fisioterapia.php',
            params:{
                task: 'GuardarAnexoEscalaAschworth',
                CAMPOS: listacampos,
                pPaciente: Ext.getCmp('sysPacienteAnexoEscalaAschworth').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalAnexoEscalaAschworth').getValue(),
                pCAS: Ext.getCmp('sysCASAnexoEscalaAschworth').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoAnexoEscalaAschworth').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarAnexoEscalaAschworth(){
    var frm = Ext.getCmp('frmAnexoEscalaAschworth').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/fisioterapia/controlador_fisioterapia.php',
            params:{
                task: 'ModificarAnexoEscalaAschworth',
                CAMPOS: listacampos,
                pPaciente: Ext.getCmp('sysPacienteAnexoEscalaAschworth').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalAnexoEscalaAschworth').getValue(),
                pCAS: Ext.getCmp('sysCASAnexoEscalaAschworth').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoAnexoEscalaAschworth').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
