/*
* @category    Formulario Modelo Anexo Escala de Fuerza Muscular
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winAnexoEscalaFuerzaMuscularUi = Ext.extend(Ext.Window, {
    title: '.:: ANEXO Escala de Fuerza Muscular ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winAnexoEscalaFuerzaMuscular',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '99%',
                height: 605,
                id: 'frmAnexoEscalaFuerzaMuscular',
                padding: 5,
                border: false,
                labelWidth: 450,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysCASAnexoEscalaFuerzaMuscular'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysPacienteAnexoEscalaFuerzaMuscular'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysProfesionalAnexoEscalaFuerzaMuscular'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysYaGuardoAnexoEscalaFuerzaMuscular'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(5 )AMA Completo en contra de la gravedad y maxima resistencia',
                        name: '(5 )AMA Completo en contra de la gravedad y maxima resistencia',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEFM1'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(4+)AMA Completo en contra de la gravedad y resistencia sostenida',
                        name: '(4+)AMA Completo en contra de la gravedad y resistencia sostenida',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEFM2'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(4 )AMA Completo en contra de la gravedad y resistencia',
                        name: '(4 )AMA Completo en contra de la gravedad y resistencia',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEFM3'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(4-)AMA Completo en contra de la gravedad y mediana resistencia',
                        name: '(4-)AMA Completo en contra de la gravedad y mediana resistencia',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEFM4'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(3+)AMA Completo en contra de la gravedad y ligera resistencia',
                        name: '(3+)AMA Completo en contra de la gravedad y ligera resistencia',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEFM5'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(3 )AMA Completo en contra de la gravedad sin resistencia',
                        name: '(3 )AMA Completo en contra de la gravedad sin resistencia',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEFM6'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(3-)1/2 o 2/3 partes del AMA en contra de la gravedad',
                        name: '(3-)1/2 o 2/3 partes del AMA en contra de la gravedad',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEFM7'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(2+)Inicia  movimiento en contra de la gravedad sin resistencia',
                        name: '(2+)Inicia  movimiento en contra de la gravedad sin resistencia',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEFM8'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(2 )AMA completo sin gravedad y resistencia',
                        name: '(2 )AMA completo sin gravedad y resistencia',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEFM9'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(2-)1/2 o 2/3 del AMA sin gravedad',
                        name: '(2-)1/2 o 2/3 del AMA sin gravedad',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEFM10'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(1+)Inicia movimiento sin gravedad',
                        name: '(1+)Inicia movimiento sin gravedad',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEFM11'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(1 )Contraccion Sostenida',
                        name: '(1 )Contraccion Sostenida',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEFM12'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: '(0 )Paralisis, no hay Contraccion',
                        name: '(0 )Paralisis, no hay Contraccion',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolAEFM13'
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirAnexoEscalaFuerzaMuscular',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoAnexoEscalaFuerzaMuscular').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('winAnexoEscalaFuerzaMuscular').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado el Anexo y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('winAnexoEscalaFuerzaMuscular').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Anexo',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarAnexoEscalaFuerzaMuscular',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoAnexoEscalaFuerzaMuscular').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar el Anexo?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarAnexoEscalaFuerzaMuscular();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar el Anexo?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarAnexoEscalaFuerzaMuscular();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        
        winAnexoEscalaFuerzaMuscularUi.superclass.initComponent.call(this);
    }
});

function fnGuardarAnexoEscalaFuerzaMuscular(){
    var frm = Ext.getCmp('frmAnexoEscalaFuerzaMuscular').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/fisioterapia/controlador_fisioterapia.php',
            params:{
                task: 'GuardarAnexoEscalaFuerzaMuscular',
                CAMPOS: listacampos,
                pPaciente: Ext.getCmp('sysPacienteAnexoEscalaFuerzaMuscular').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalAnexoEscalaFuerzaMuscular').getValue(),
                pCAS: Ext.getCmp('sysCASAnexoEscalaFuerzaMuscular').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoAnexoEscalaFuerzaMuscular').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarAnexoEscalaFuerzaMuscular(){
    var frm = Ext.getCmp('frmAnexoEscalaFuerzaMuscular').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/fisioterapia/controlador_fisioterapia.php',
            params:{
                task: 'ModificarAnexoEscalaFuerzaMuscular',
                CAMPOS: listacampos,
                pPaciente: Ext.getCmp('sysPacienteAnexoEscalaFuerzaMuscular').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalAnexoEscalaFuerzaMuscular').getValue(),
                pCAS: Ext.getCmp('sysCASAnexoEscalaFuerzaMuscular').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoAnexoEscalaFuerzaMuscular').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
