/*
* @category    Formulario Modelo Anexo Evaluacion Fisioterapeutica de la Persona con Sindrome de Disfuncion CraneoMandibular
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


    winAnexoEvaluacionCraneoMandibularUi = Ext.extend(Ext.Window, {
    title: '.:: ANEXO Evaluacion Fisioterapeutica de la Persona con Sindrome de Disfuncion CraneoMandibular ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winAnexoEvaluacionCraneoMandibular',
    initComponent: function() {
        
        var dataSimetria = [
            ['SIMETRICO'],
            ['ASIMETRICO']
        ];
        var stSimetria = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stSimetria.loadData(dataSimetria);
        
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '99%',
                height: 605,
                id: 'frmAnexoEvaluacionCraneoMandibular',
                padding: 5,
                border: false,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysCASAnexoEvaluacionCraneoMandibular'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysPacienteAnexoEvaluacionCraneoMandibular'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysProfesionalAnexoEvaluacionCraneoMandibular'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysYaGuardoAnexoEvaluacionCraneoMandibular'
                    },
                    {
                        xtype: 'fieldset',
                        title: 'ANTECEDENTES',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 5,
                        items: [
                            {
                                xtype: 'fieldset',
                                title: 'Habitos:',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '100%',
                                autoHeight: true,
                                padding: 5,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Muerde Objtos',
                                                name: 'Muerde Objtos',
                                                width: 60,
                                                allowBlank: true,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strAECMHabitos1'
                                           },
                                           {
                                               html: 'Come Unas'
                                           },
                                           {
                                                xtype: 'combo',
                                                name: 'Come Unas',
                                                width: 60,
                                                allowBlank: true,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strAECMHabitos2'
                                           },
                                           {
                                               html: 'Chupa Dedo'
                                           },
                                           {
                                                xtype: 'combo',
                                                name: 'Chupa Dedo',
                                                width: 60,
                                                allowBlank: true,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strAECMHabitos3'
                                           },
                                           {
                                               html: 'Muerde Labios'
                                           },
                                           {
                                                xtype: 'combo',
                                                name: 'Muerde Labios',
                                                width: 60,
                                                allowBlank: true,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strAECMHabitos4'
                                           }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'textfield',
                                width: 300,
                                name: 'Lado de Preferencia Masticatoria',
                                fieldLabel: 'Lado de Preferencia Masticatoria',
                                allowBlank: true,
                                id: 'strAECMAntecedentes1'
                            },
                            {
                                xtype: 'textfield',
                                width: 300,
                                name: 'Posicion de la Lengua',
                                fieldLabel: 'Posicion de la Lengua',
                                allowBlank: true,
                                id: 'strAECMAntecedentes2'
                            },
                            {
                                xtype: 'textfield',
                                width: 300,
                                name: 'Posicion de la Mandibula',
                                fieldLabel: 'Posicion de la Mandibula',
                                allowBlank: true,
                                id: 'strAECMAntecedentes3'
                            },
                            {
                                xtype: 'textfield',
                                width: 300,
                                name: 'Motivo de la Consulta',
                                fieldLabel: 'Motivo de la Consulta',
                                allowBlank: true,
                                id: 'strAECMAntecedentes4'
                            },
                            {
                                xtype: 'textfield',
                                width: 300,
                                name: 'Remitido por',
                                fieldLabel: 'Remitido por',
                                allowBlank: true,
                                id: 'strAECMAntecedentes5'
                            },
                            {
                                xtype: 'textfield',
                                width: 300,
                                name: 'Diagnostico',
                                fieldLabel: 'Diagnostico',
                                allowBlank: true,
                                id: 'strAECMAntecedentes6'
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'EVALUACION FISIOTERAPEUTICA',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 5,
                        items: [
                            {
                                xtype: 'fieldset',
                                title: 'A la Observacion',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '100%',
                                autoHeight: true,
                                padding: 5,
                                items: [
                                    {
                                        xtype: 'fieldset',
                                        title: 'Simetria Facial',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 5,
                                        items: [
                                            {    
                                                xtype: 'textfield',
                                                width: 100,
                                                name: 'Del Angulo Externo del Ojo al Angulo Externo de la Boca',
                                                fieldLabel: 'Del Angulo Externo del Ojo al Angulo Externo de la Boca',
                                                allowBlank: true,
                                                id: 'strAECMEvaluacion1'
                                            },
                                            {    
                                                xtype: 'textfield',
                                                width: 100,
                                                name: 'De la Base de la Nariz al Menton',
                                                fieldLabel: 'De la Base de la Nariz al Menton',
                                                allowBlank: true,
                                                id: 'strAECMEvaluacion2'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'Movimiento de Apertura y Cierre de la Boca',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 5,
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Desviacion',
                                                        name: 'Desviacion',
                                                        width: 60,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strAECMEvaluacion3'
                                                   },
                                                   {
                                                       html: 'Sinuceo:'
                                                   },
                                                   {
                                                        xtype: 'combo',
                                                        name: 'Sinuceo',
                                                        width: 60,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strAECMEvaluacion4'
                                                   }
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Hipertrofia de los Meseteros',
                                                name: 'Hipertrofia de los Meseteros',
                                                width: 60,
                                                allowBlank: true,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strAECMEvaluacion5'
                                           },
                                           {
                                               html: 'Superficies Oclusales:'
                                           },
                                           {
                                                xtype: 'combo',
                                                name: 'Superficies Oclusales',
                                                width: 60,
                                                allowBlank: true,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strAECMEvaluacion6'
                                           },
                                           {
                                               html: 'Oclusion:'
                                           },
                                           {
                                                xtype: 'combo',
                                                name: 'Oclusion',
                                                width: 60,
                                                allowBlank: true,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strAECMEvaluacion7'
                                           }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'Apertura Mandibular (en mm)',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 5,
                                        items: [
                                            {
                                                xtype: 'fieldset',
                                                title: 'Fecha 1',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                     {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                fieldLabel: 'Fecha',
                                                                name: 'Fecha',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecAECMEvaluacion8Fec'
                                                            },
                                                            {
                                                                html: 'Pre Qx'
                                                            },
                                                            {    
                                                                xtype: 'textfield',
                                                                width: 70,
                                                                name: 'Pre Qx',
                                                                allowBlank: true,
                                                                id: 'strAECMEvaluacion8Pre'
                                                            },
                                                            {
                                                                html: 'Post Qx'
                                                            },
                                                            {    
                                                                xtype: 'textfield',
                                                                width: 70,
                                                                name: 'Post Qx',
                                                                allowBlank: true,
                                                                id: 'strAECMEvaluacion8Post'
                                                            }
                                                        ]
                                                     }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Fecha 2',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                     {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                fieldLabel: 'Fecha',
                                                                name: 'Fecha',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecAECMEvaluacion9Fec'
                                                            },
                                                            {
                                                                html: 'Pre Qx'
                                                            },
                                                            {    
                                                                xtype: 'textfield',
                                                                width: 70,
                                                                name: 'Pre Qx',
                                                                allowBlank: true,
                                                                id: 'strAECMEvaluacion9Pre'
                                                            },
                                                            {
                                                                html: 'Post Qx'
                                                            },
                                                            {    
                                                                xtype: 'textfield',
                                                                width: 70,
                                                                name: 'Post Qx',
                                                                allowBlank: true,
                                                                id: 'fecAECMEvaluacion9Post'
                                                            }
                                                        ]
                                                     }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Fecha 3',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                     {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                fieldLabel: 'Fecha',
                                                                name: 'Fecha',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecAECMEvaluacion10Fec'
                                                            },
                                                            {
                                                                html: 'Pre Qx'
                                                            },
                                                            {    
                                                                xtype: 'textfield',
                                                                width: 70,
                                                                name: 'Pre Qx',
                                                                allowBlank: true,
                                                                id: 'strAECMEvaluacion10Pre'
                                                            },
                                                            {
                                                                html: 'Post Qx'
                                                            },
                                                            {    
                                                                xtype: 'textfield',
                                                                width: 70,
                                                                name: 'Post Qx',
                                                                allowBlank: true,
                                                                id: 'strAECMEvaluacion10Post'
                                                            }
                                                        ]
                                                     }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Fecha 4',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                     {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                fieldLabel: 'Fecha',
                                                                name: 'Fecha',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecAECMEvaluacion11Fec'
                                                            },
                                                            {
                                                                html: 'Pre Qx'
                                                            },
                                                            {    
                                                                xtype: 'textfield',
                                                                width: 70,
                                                                name: 'Pre Qx',
                                                                allowBlank: true,
                                                                id: 'strAECMEvaluacion11Pre'
                                                            },
                                                            {
                                                                html: 'Post Qx'
                                                            },
                                                            {    
                                                                xtype: 'textfield',
                                                                width: 70,
                                                                name: 'Post Qx',
                                                                allowBlank: true,
                                                                id: 'strAECMEvaluacion11Post'
                                                            }
                                                        ]
                                                     }
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'Movimientos Laterales (en mm)',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 5,
                                        items: [
                                            {
                                                xtype: 'fieldset',
                                                title: 'Fecha 1',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                     {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                fieldLabel: 'Fecha',
                                                                name: 'Fecha',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecAECMEvaluacion12Fec'
                                                            },
                                                            {
                                                                html: 'Pre Qx'
                                                            },
                                                            {    
                                                                xtype: 'textfield',
                                                                width: 70,
                                                                name: 'Pre Qx',
                                                                allowBlank: true,
                                                                id: 'strAECMEvaluacion12Pre'
                                                            },
                                                            {
                                                                html: 'Post Qx'
                                                            },
                                                            {    
                                                                xtype: 'textfield',
                                                                width: 70,
                                                                name: 'Post Qx',
                                                                allowBlank: true,
                                                                id: 'strAECMEvaluacion12Post'
                                                            }
                                                        ]
                                                     }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Fecha 2',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                     {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                fieldLabel: 'Fecha',
                                                                name: 'Fecha',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecAECMEvaluacion13Fec'
                                                            },
                                                            {
                                                                html: 'Pre Qx'
                                                            },
                                                            {    
                                                                xtype: 'textfield',
                                                                width: 70,
                                                                name: 'Pre Qx',
                                                                allowBlank: true,
                                                                id: 'strAECMEvaluacion13Pre'
                                                            },
                                                            {
                                                                html: 'Post Qx'
                                                            },
                                                            {    
                                                                xtype: 'textfield',
                                                                width: 70,
                                                                name: 'Post Qx',
                                                                allowBlank: true,
                                                                id: 'strAECMEvaluacion13Post'
                                                            }
                                                        ]
                                                     }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Fecha 3',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                     {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                fieldLabel: 'Fecha',
                                                                name: 'Fecha',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecAECMEvaluacion14Fec'
                                                            },
                                                            {
                                                                html: 'Pre Qx'
                                                            },
                                                            {    
                                                                xtype: 'textfield',
                                                                width: 70,
                                                                name: 'Pre Qx',
                                                                allowBlank: true,
                                                                id: 'strAECMEvaluacion14Pre'
                                                            },
                                                            {
                                                                html: 'Post Qx'
                                                            },
                                                            {    
                                                                xtype: 'textfield',
                                                                width: 70,
                                                                name: 'Post Qx',
                                                                allowBlank: true,
                                                                id: 'strAECMEvaluacion14Post'
                                                            }
                                                        ]
                                                     }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Fecha 4',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                     {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                fieldLabel: 'Fecha',
                                                                name: 'Fecha',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecAECMEvaluacion15Fec'
                                                            },
                                                            {
                                                                html: 'Pre Qx'
                                                            },
                                                            {    
                                                                xtype: 'textfield',
                                                                width: 70,
                                                                name: 'Pre Qx',
                                                                allowBlank: true,
                                                                id: 'strAECMEvaluacion15Pre'
                                                            },
                                                            {
                                                                html: 'Post Qx'
                                                            },
                                                            {    
                                                                xtype: 'textfield',
                                                                width: 70,
                                                                name: 'Post Qx',
                                                                allowBlank: true,
                                                                id: 'strAECMEvaluacion15Post'
                                                            }
                                                        ]
                                                     }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                title: 'A la Auscultacion',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '100%',
                                autoHeight: true,
                                padding: 5,
                                items: [
                                    {    
                                        xtype: 'textfield',
                                        width: 300,
                                        fieldLabel: 'Normal',
                                        name: 'Normal',
                                        allowBlank: true,
                                        id: 'strAECMEvaluacion16'
                                    },
                                    {    
                                        xtype: 'textfield',
                                        width: 300,
                                        fieldLabel: 'Crepitacion',
                                        name: 'Crepitacion',
                                        allowBlank: true,
                                        id: 'strAECMEvaluacion17'
                                    },
                                    {    
                                        xtype: 'textfield',
                                        width: 300,
                                        fieldLabel: 'Clikcing o Chasquido',
                                        name: 'Clikcing o Chasquido',
                                        allowBlank: true,
                                        id: 'strAECMEvaluacion18'
                                    },
                                    {
                                        xtype: 'textarea',
                                        anchor: '100%',
                                        width: 880,
                                        fieldLabel: 'Observaciones',
                                        name: 'Observaciones',
                                        height: 100,            
                                        allowBlank: false,
                                        id: 'strAECMEvaluacion19'
                                    },
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                title: 'A la Palpacion',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '100%',
                                autoHeight: true,
                                padding: 5,
                                items: [
                                    {
                                        xtype: 'fieldset',
                                        title: 'Dolor',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 5,
                                        items: [
                                            {    
                                                xtype: 'textfield',
                                                width: 300,
                                                fieldLabel: 'Ubicacion',
                                                name: 'Ubicacion',
                                                allowBlank: true,
                                                id: 'strAECMEvaluacion20'
                                            },
                                            {    
                                                xtype: 'textfield',
                                                width: 300,
                                                fieldLabel: 'Frecuencia',
                                                name: 'Frecuencia',
                                                allowBlank: true,
                                                id: 'strAECMEvaluacion21'
                                            },
                                            {    
                                                xtype: 'textfield',
                                                width: 300,
                                                fieldLabel: 'Intensidad (ENV)',
                                                name: 'Intensidad (ENV)',
                                                allowBlank: true,
                                                id: 'strAECMEvaluacion22'
                                            },
                                            {    
                                                xtype: 'textfield',
                                                width: 300,
                                                fieldLabel: 'Factores Atenuantes',
                                                name: 'Factores Atenuantes',
                                                allowBlank: true,
                                                id: 'strAECMEvaluacion23'
                                            },
                                            {    
                                                xtype: 'textfield',
                                                width: 300,
                                                fieldLabel: 'Factores Agravantes',
                                                name: 'Factores Agravantes',
                                                allowBlank: true,
                                                id: 'strAECMEvaluacion24'
                                            },
                                            {    
                                                xtype: 'textfield',
                                                width: 300,
                                                fieldLabel: 'Tiempo de Evolucion',
                                                name: 'Tiempo de Evolucion',
                                                allowBlank: true,
                                                id: 'strAECMEvaluacion25'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'Movimiento (Con los dedos por delante del Conducto Auditivo Externo)',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 5,
                                        items: [
                                            {   
                                                xtype: 'combo',
                                                name: 'Apertura y Cierre',
                                                fieldLabel: 'Apertura y Cierre',
                                                width: 90,
                                                allowBlank: true,
                                                value:'NO',
                                                store: stSimetria,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strAECMEvaluacion26'
                                            },
                                            {
                                                html: 'Lateralizaciones:'
                                            },
                                            {   
                                                xtype: 'combo',
                                                name: 'Lateralizaciones',
                                                width: 90,
                                                allowBlank: true,
                                                value:'NO',
                                                store: stSimetria,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strAECMEvaluacion27'
                                            },
                                        ]
                                    },
                                    {    
                                        xtype: 'textfield',
                                        width: 300,
                                        labelWidth: 100,
                                        fieldLabel: 'Sensibilidad Superficial (Ramas Sensitivas trigemino)',
                                        name: 'Sensibilidad Superficial (Ramas Sensitivas trigemino)',
                                        allowBlank: true,
                                        id: 'strAECMEvaluacion28'
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'Musculos',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 5,
                                        items: [
                                            {    
                                                xtype: 'textfield',
                                                width: 300,
                                                fieldLabel: 'Espasmos Musculares (ubicacion)',
                                                name: 'Espasmos Musculares (ubicacion)',
                                                allowBlank: true,
                                                id: 'strAECMEvaluacion29'
                                            },
                                            {    
                                                xtype: 'textfield',
                                                width: 300,
                                                fieldLabel: 'Puntos Gatillos Activos',
                                                name: 'Puntos Gatillos Activos',
                                                allowBlank: true,
                                                id: 'strAECMEvaluacion30'
                                            },
                                            {    
                                                xtype: 'textfield',
                                                width: 300,
                                                fieldLabel: 'Dolor Referido a',
                                                name: 'Dolor Referido a',
                                                allowBlank: true,
                                                id: 'strAECMEvaluacion31'
                                            },
                                            {    
                                                xtype: 'textfield',
                                                width: 300,
                                                fieldLabel: 'Otros Puntos',
                                                name: 'Otros Puntos',
                                                allowBlank: true,
                                                id: 'strAECMEvaluacion32'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                title: 'Evaluacion Muscular Funcional',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '100%',
                                autoHeight: true,
                                padding: 5,
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 450,
                                        fieldLabel: 'Grupo de Apertura Mandibular',
                                        name: 'Grupo de Apertura Mandibular',
                                        allowBlank: true,
                                        id: 'strAECMEvaluacion33'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 450,
                                        fieldLabel: 'Grupo de Cierre',
                                        name: 'Grupo de Cierre',
                                        allowBlank: true,
                                        id: 'strAECMEvaluacion34'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 450,
                                        fieldLabel: 'Grupo de Lateralidad Derecha',
                                        name: 'Grupo de Lateralidad Derecha',
                                        allowBlank: true,
                                        id: 'strAECMEvaluacion35'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 450,
                                        fieldLabel: 'Grupo de Lateralidad Izquierda',
                                        name: 'Grupo de Lateralidad Izquierda',
                                        allowBlank: true,
                                        id: 'strAECMEvaluacion36'
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                title: 'Alineacion Corporal',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '100%',
                                autoHeight: true,
                                padding: 5,
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 450,
                                        fieldLabel: 'Vista Posterior',
                                        name: 'Vista Posterior',
                                        allowBlank: true,
                                        id: 'strAECMEvaluacion37'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 450,
                                        fieldLabel: 'Vista Anterior',
                                        name: 'Vista Anterior',
                                        allowBlank: true,
                                        id: 'strAECMEvaluacion38'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 450,
                                        fieldLabel: 'Vista Lateral',
                                        name: 'Vista Lateral',
                                        allowBlank: true,
                                        id: 'strAECMEvaluacion39'
                                    },
                                    {
                                        xtype: 'textarea',
                                        anchor: '98%',
                                        width: 880,
                                        fieldLabel: 'Observaciones y Conclusiones',
                                        name: 'Observaciones y Conclusiones',
                                        height: 100,            
                                        allowBlank: false,
                                        id: 'strAECMEvaluacion40'
                                    }
                                ]
                            },
                            {
                                xtype: 'textfield',
                                width: 450,
                                fieldLabel: 'Diagnostico Fisioterapia',
                                name: 'Diagnostico Fisioterapia',
                                allowBlank: true,
                                id: 'strAECMEvaluacionDx'
                            },
                        ]
                    }                    
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirAnexoEvaluacionCraneoMandibular',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoAnexoEvaluacionCraneoMandibular').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('winAnexoEvaluacionCraneoMandibular').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado el Anexo y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('winAnexoEvaluacionCraneoMandibular').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Anexo',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarAnexoEvaluacionCraneoMandibular',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoAnexoEvaluacionCraneoMandibular').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar el Anexo?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarAnexoEvaluacionCraneoMandibular();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar el Anexo?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarAnexoEvaluacionCraneoMandibular();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        
        winAnexoEvaluacionCraneoMandibularUi.superclass.initComponent.call(this);
    }
});

function fnGuardarAnexoEvaluacionCraneoMandibular(){
    var frm = Ext.getCmp('frmAnexoEvaluacionCraneoMandibular').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/fisioterapia/controlador_fisioterapia.php',
            params:{
                task: 'GuardarAnexoEvaluacionCraneoMandibular',
                CAMPOS: listacampos,
                pPaciente: Ext.getCmp('sysPacienteAnexoEvaluacionCraneoMandibular').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalAnexoEvaluacionCraneoMandibular').getValue(),
                pCAS: Ext.getCmp('sysCASAnexoEvaluacionCraneoMandibular').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoAnexoEvaluacionCraneoMandibular').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarAnexoEvaluacionCraneoMandibular(){
    var frm = Ext.getCmp('frmAnexoEvaluacionCraneoMandibular').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/fisioterapia/controlador_fisioterapia.php',
            params:{
                task: 'ModificarAnexoEvaluacionCraneoMandibular',
                CAMPOS: listacampos,
                pPaciente: Ext.getCmp('sysPacienteAnexoEvaluacionCraneoMandibular').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalAnexoEvaluacionCraneoMandibular').getValue(),
                pCAS: Ext.getCmp('sysCASAnexoEvaluacionCraneoMandibular').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoAnexoEvaluacionCraneoMandibular').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
