/*
* @category    Formulario Modelo Evolucion Anexo Endodoncia
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCAutonomaOdo003Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Examen Endodoncia - Universidad Autonoma de Manizales::.',
    width: 1004,
    height: 600,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        
        function DescripcionGrid(val, x, store){
            mostrarHC = '<table><tr><td style="padding: 1px;">';
            mostrarHC += val;
            mostrarHC += '</td></tr></table>';
            return mostrarHC;
        }
        
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
            
        var stGridDienteActividadesRealizadas = new StoreGridDienteActividadesRealizadas();
        stGridDienteActividadesRealizadas.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        var dataSintomatologiaIntensidad = [
            ['LEVE'],
            ['MODERADO'],
            ['SEVERO']
        ];
        var stSintomatologiaIntensidad = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stSintomatologiaIntensidad.loadData(dataSintomatologiaIntensidad);
                
        var dataSintomatologiaDuracion = [
            ['CORTO'],
            ['MEDIANO'],
            ['LARGO']
        ];
        var stSintomatologiaDuracion = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stSintomatologiaDuracion.loadData(dataSintomatologiaDuracion);
        
        var dataSintomatologiaLocalizacion = [
            ['LOCALIZADO'],
            ['IRRADIADO']
        ];
        var stSintomatologiaLocalizacion = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stSintomatologiaLocalizacion.loadData(dataSintomatologiaLocalizacion);
        
        var dataSintomatologiaEstimulo = [
            ['PROVOCADO'],
            ['ESPONTANEO']
        ];
        var stSintomatologiaEstimulo = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stSintomatologiaEstimulo.loadData(dataSintomatologiaEstimulo);
        
        var dataSintomatologiaTipoEstimulo = [
            ['CALOR (+ / -)'],
            ['FRIO (+ / -)']
        ];
        var stSintomatologiaTipoEstimulo = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stSintomatologiaTipoEstimulo.loadData(dataSintomatologiaTipoEstimulo);
        
        var dataSintomatologiaPositivoNegativo = [
            ['POSITIVO'],
            ['NEGATIVO']
        ];
        var stSintomatologiaPositivoNegativo = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stSintomatologiaPositivoNegativo.loadData(dataSintomatologiaPositivoNegativo);
        
        var ConvencionesOdontograma = new winConvencionesOdontogramaUi();
        var ViewOdontogramas = new winViewOdontogramasUi();
        //var xAsignarProximaCita = new fsAsignarProximaCita001Ui();
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                //padding: 10,
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'tabpanel',
                        //width: 930,
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'IDENTIFICACION',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaIdentifica',
                                layout: 'form',
                                items:[
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysIdCodPlantillaHC'
                                    },
                                     {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        value: 1,
                                        id: 'sysUsaGridSalida'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        value: 0,
                                        id: 'sysYaGuardoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        value: 0,
                                        id: 'sysYaAsignoCitaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysPlantillaHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptMx'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptExa'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptRem'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Actividad',
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        id: 'sysActividadHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Empresa',
                                        id: 'sysEmpresaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'IPS',
                                        id: 'sysIPSHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Usuario',
                                        id: 'sysUsuarioHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        id: 'sysIdPacienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Apertura',
                                        id: 'sysAperturaHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Cliente',
                                        id: 'sysClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdSubPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdContratoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Genero',
                                        id: 'sysGeneroPacHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Edad',
                                        id: 'sysEdadPacHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalAgendaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'ConsecutivoDetalle',
                                        id: 'sysConsecutivoDetalleHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'CAS',
                                                id: 'sysCASHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysFechaHC',
                                                value: 'Fecha: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysHoraHC',
                                                value: 'Hora: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysHoraHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysLegalizacionHC',
                                                value: 'Legalización: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysLegalizaHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                                        id: 'sysPacienteHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 96,
                                                allowBlank: false,
                                                fieldLabel: 'Ocupacion',
                                                id: 'sysOcupacionHC'
                                            },
                                            {
                                                xtype: 'textarea',
                                                readOnly: true,
                                                width: 695,
                                                height: 22,
                                                id: 'sysOcupacionHCNom'
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnBuscar',
                                                tooltip: 'Buscar Ocupacion',
                                                id: 'btnSearchOcupacionHC',
                                                listeners:{
                                                    click : function(){
                                                        buscarciuo('sysOcupacionHC','sysOcupacionHCNom');
                                                    }
                                                }
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Etnia',
                                                name: 'Etnia',
                                                width: 370,
                                                allowBlank: false,
                                                store: 'StoreEtnia4505',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'sysEtniaHC'
                                            },
                                            {
                                                html: 'Escolaridad:'
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Escolaridad',
                                                width: 380,
                                                allowBlank: false,
                                                store: 'StoreEscolaridad4505',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'sysEscolaridadHC'
                                            }
                                        ]
                                    },
                                    {
                                        html: '<hr>',
                                        style: 'background:transparent;',
                                        border: false
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'EXAMEN',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '99%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                anchor: '99%',
                                                fieldLabel: 'DIENTE Y/O ZONA',
                                                name: 'DIENTE Y/O ZONA',
                                                allowBlank: false,
                                                id: 'strDienteZona'
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: '1. Descripción de Historia de dolor y/o Trauma : ¿Qué?¿Cómo?¿Cuándo?¿Dónde?¿Por qué?',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'DESCRIPCION DE HIISTORIA DE DOLOR',
                                                        name: 'DESCRIPCION DE HIISTORIA DE DOLOR',
                                                        grow: true,
                                                        allowBlank: false,
                                                        id: 'memHistoriaDolor'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: '2. Sintomatología actual',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 150,
                                                                fieldLabel: 'Intensidad',
                                                                name: 'Intensidad',
                                                                allowBlank: false,
                                                                store: stSintomatologiaIntensidad,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSintomatologia_Intensidad'
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                width: 650,
                                                                emptyText: 'DESCRIPCION',
                                                                name: 'DESCRIPCION',
                                                                grow: true,
                                                                allowBlank: true,
                                                                id: 'memSintomatologia_IntensidadH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 150,
                                                                fieldLabel: 'Duración',
                                                                name: 'Duración',
                                                                allowBlank: false,
                                                                store: stSintomatologiaDuracion,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSintomatologia_Duracion'
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                width: 650,
                                                                emptyText: 'DESCRIPCION',
                                                                name: 'DESCRIPCION',
                                                                grow: true,
                                                                allowBlank: true,
                                                                id: 'memSintomatologia_DuracionH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 150,
                                                                fieldLabel: 'Localización',
                                                                name: 'Localización',
                                                                allowBlank: false,
                                                                store: stSintomatologiaLocalizacion,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSintomatologia_Localizacion'
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                width: 650,
                                                                emptyText: 'DESCRIPCION',
                                                                name: 'DESCRIPCION',
                                                                grow: true,
                                                                allowBlank: true,
                                                                id: 'memSintomatologia_LocalizacionH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 150,
                                                                fieldLabel: 'Categoría del Estimulo',
                                                                name: 'Categoría del Estimulo',
                                                                allowBlank: false,
                                                                store: stSintomatologiaEstimulo,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSintomatologia_CategoriaEstimulo'
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                width: 650,
                                                                emptyText: 'DESCRIPCION',
                                                                name: 'DESCRIPCION',
                                                                grow: true,
                                                                allowBlank: true,
                                                                id: 'memSintomatologia_CategoriaEstimuloH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 150,
                                                                fieldLabel: 'Tipo de Estímulo',
                                                                name: 'Tipo de Estimulo',
                                                                allowBlank: false,
                                                                store: stSintomatologiaTipoEstimulo,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSintomatologia_TipoEstimulo'
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                width: 650,
                                                                emptyText: 'DESCRIPCION',
                                                                name: 'DESCRIPCION',
                                                                grow: true,
                                                                allowBlank: true,
                                                                id: 'memSintomatologia_TipoEstimuloH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 150,
                                                                fieldLabel: 'Percusión',
                                                                name: 'Percusión',
                                                                allowBlank: false,
                                                                store: stSintomatologiaPositivoNegativo,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSintomatologia_Percusion'
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                width: 650,
                                                                emptyText: 'DESCRIPCION',
                                                                name: 'DESCRIPCION',
                                                                grow: true,
                                                                allowBlank: true,
                                                                id: 'memSintomatologia_PercusionH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 150,
                                                                fieldLabel: 'Palpación',
                                                                name: 'Palpación',
                                                                allowBlank: false,
                                                                store: stSintomatologiaPositivoNegativo,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSintomatologia_Palpacion'
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                width: 650,
                                                                emptyText: 'DESCRIPCION',
                                                                name: 'DESCRIPCION',
                                                                grow: true,
                                                                allowBlank: true,
                                                                id: 'memSintomatologia_PalpacionH'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: '3. Examen Clínico del Diente',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        autoScroll: true,
                                                        anchor: '100%',
                                                        frame: true,
                                                        border: false,
                                                        layout: 'table',
                                                        layoutConfig: {
                                                            columns: 2
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: '1. Caries',
                                                                        name: '1. Caries',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strEXACLINICO_Caries',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('memEXACLINICO_CariesH').allowBlank = true;
                                                                                    Ext.getCmp('memEXACLINICO_CariesH').setValue(null);
                                                                                    Ext.getCmp('memEXACLINICO_CariesH').disable();
                                                                                    Ext.getCmp('memEXACLINICO_CariesH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXACLINICO_CariesH').enable();
                                                                                    Ext.getCmp('memEXACLINICO_CariesH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', 
                                                                width: 700,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 1. Caries",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXACLINICO_CariesH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: '2. Pérdida del tejido dental',
                                                                        name: '2. Pérdida del tejido dental',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strEXACLINICO_PerdidaTejido',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('memEXACLINICO_PerdidaTejidoH').allowBlank = true;
                                                                                    Ext.getCmp('memEXACLINICO_PerdidaTejidoH').setValue(null);
                                                                                    Ext.getCmp('memEXACLINICO_PerdidaTejidoH').disable();
                                                                                    Ext.getCmp('memEXACLINICO_PerdidaTejidoH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXACLINICO_PerdidaTejidoH').enable();
                                                                                    Ext.getCmp('memEXACLINICO_PerdidaTejidoH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', 
                                                                width: 700,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 2. Pérdida del tejido dental",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXACLINICO_PerdidaTejidoH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: '3. Cambio de Color',
                                                                        name: '3. Cambio de Color',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strEXACLINICO_CambioColor',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('memEXACLINICO_CambioColorH').allowBlank = true;
                                                                                    Ext.getCmp('memEXACLINICO_CambioColorH').setValue(null);
                                                                                    Ext.getCmp('memEXACLINICO_CambioColorH').disable();
                                                                                    Ext.getCmp('memEXACLINICO_CambioColorH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXACLINICO_CambioColorH').enable();
                                                                                    Ext.getCmp('memEXACLINICO_CambioColorH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', 
                                                                width: 700,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXACLINICO_CambioColorH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: '4. Edema Intraoral',
                                                                        name: '4. Edema Intraoral',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strEXACLINICO_EdemaIntraoral',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('memEXACLINICO_EdemaIntraoralH').allowBlank = true;
                                                                                    Ext.getCmp('memEXACLINICO_EdemaIntraoralH').setValue(null);
                                                                                    Ext.getCmp('memEXACLINICO_EdemaIntraoralH').disable();
                                                                                    Ext.getCmp('memEXACLINICO_EdemaIntraoralH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXACLINICO_EdemaIntraoralH').enable();
                                                                                    Ext.getCmp('memEXACLINICO_EdemaIntraoralH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', 
                                                                width: 700,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXACLINICO_EdemaIntraoralH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: '5. Edema Extraoral',
                                                                        name: '5. Edema Extraoral',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strEXACLINICO_EdemaExtraoral',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('memEXACLINICO_EdemaExtaoralH').allowBlank = true;
                                                                                    Ext.getCmp('memEXACLINICO_EdemaExtaoralH').setValue(null);
                                                                                    Ext.getCmp('memEXACLINICO_EdemaExtaoralH').disable();
                                                                                    Ext.getCmp('memEXACLINICO_EdemaExtaoralH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXACLINICO_EdemaExtaoralH').enable();
                                                                                    Ext.getCmp('memEXACLINICO_EdemaExtaoralH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', 
                                                                width: 700,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXACLINICO_EdemaExtaoralH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: '6. Tracto Sinusal (fístula)',
                                                                        name: '6. Tracto Sinusal (fístula)',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strEXACLINICO_TractoSinusal',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('memEXACLINICO_TractoSinusalH').allowBlank = true;
                                                                                    Ext.getCmp('memEXACLINICO_TractoSinusalH').setValue(null);
                                                                                    Ext.getCmp('memEXACLINICO_TractoSinusalH').disable();
                                                                                    Ext.getCmp('memEXACLINICO_TractoSinusalH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXACLINICO_TractoSinusalH').enable();
                                                                                    Ext.getCmp('memEXACLINICO_TractoSinusalH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', 
                                                                width: 700,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXACLINICO_TractoSinusalH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: '7. Compromiso Endo-Periodontal',
                                                                        name: '7. Compromiso Endo-Periodontal',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strEXACLINICO_CompromisoEndoPeriodontal',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('memEXACLINICO_CompromisoEndoPeriodontalH').allowBlank = true;
                                                                                    Ext.getCmp('memEXACLINICO_CompromisoEndoPeriodontalH').setValue(null);
                                                                                    Ext.getCmp('memEXACLINICO_CompromisoEndoPeriodontalH').disable();
                                                                                    Ext.getCmp('memEXACLINICO_CompromisoEndoPeriodontalH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXACLINICO_CompromisoEndoPeriodontalH').enable();
                                                                                    Ext.getCmp('memEXACLINICO_CompromisoEndoPeriodontalH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', 
                                                                width: 700,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXACLINICO_CompromisoEndoPeriodontalH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: '8. Sondaje (presencia de bolsa)',
                                                                        name: '8. Sondaje (presencia de bolsa)',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strEXACLINICO_Sondaje',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('memEXACLINICO_SondajeH').allowBlank = true;
                                                                                    Ext.getCmp('memEXACLINICO_SondajeH').setValue(null);
                                                                                    Ext.getCmp('memEXACLINICO_SondajeH').disable();
                                                                                    Ext.getCmp('memEXACLINICO_SondajeH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXACLINICO_SondajeH').enable();
                                                                                    Ext.getCmp('memEXACLINICO_SondajeH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', 
                                                                width: 700,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXACLINICO_SondajeH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: '9. Movilidad',
                                                                        name: '9. Movilidad',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strEXACLINICO_Movilidad',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('memEXACLINICO_MovilidadH').allowBlank = true;
                                                                                    Ext.getCmp('memEXACLINICO_MovilidadH').setValue(null);
                                                                                    Ext.getCmp('memEXACLINICO_MovilidadH').disable();
                                                                                    Ext.getCmp('memEXACLINICO_MovilidadH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXACLINICO_MovilidadH').enable();
                                                                                    Ext.getCmp('memEXACLINICO_MovilidadH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', 
                                                                width: 700,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXACLINICO_MovilidadH'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: '4. Evaluación Radiográfica',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'EVALUACION RADIOGRAFICA',
                                                        name: 'EVALUACION RADIOGRAFICA',
                                                        grow: true,
                                                        allowBlank: false,
                                                        id: 'memEvaluacionRadiografica'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsRips',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }                            
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'ACTIVIDADES REALIZADAS',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaActividades',
                                items: [
                                    {
                                        xtype: 'grid',
                                        layout: 'fit',
                                        id: 'gridDientesActividadesRealizadas',
                                        store: stGridDienteActividadesRealizadas,
                                        anchor: "100%",
                                        height: 470,
                                        border: false,
                                        frame: true,
                                        loadMask: true,
                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Id',
                                                sortable: false,
                                                width: 1,
                                                hidden: true,
                                                hideable: false,
                                                dataIndex: 'IdConsecutivoDientesActividad',
                                                id: 'IdConsecutivoDientesActividad'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Fecha',
                                                sortable: true,
                                                width: 110,
                                                dataIndex: 'FechaAtencion',
                                                id: 'FechaAtencion'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Profesional',
                                                sortable: true,
                                                width: 170,
                                                dataIndex: 'Profesional',
                                                id: 'Profesional'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Diente',
                                                sortable: true,
                                                width: 60,
                                                dataIndex: 'Diente',
                                                id: 'Diente'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Superficie',
                                                sortable: true,
                                                width: 60,
                                                dataIndex: 'Superficie',
                                                id: 'Superficie'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Procedimiento/Actividad',
                                                sortable: true,
                                                width: 170,
                                                dataIndex: 'DesProced',
                                                renderer: DescripcionGrid,
                                                id: 'DesProced'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Notas Evolución',
                                                sortable: false,
                                                width: 270,
                                                dataIndex: 'NotasEvolucion',
                                                renderer: DescripcionGrid,
                                                id: 'NotasEvolucion'
                                            }
                                        ]),
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                                        iconCls:'icon-grid',
                                        //view: new Ext.grid.GroupingView(),
                                        tbar:
                                            {
                                                xtype: 'toolbar',
                                                items: [
                                                    {
                                                        xtype: 'button',
                                                        text: 'Adicionar Registro',
                                                        iconCls: 'btnAddRow',
                                                        id: 'btnAddActividadDiente',
                                                        listeners: {
                                                            click : function() {
                                                                if (Ext.getCmp('sysYaGuardoHC').getValue() == 1){
                                                                    var winAddDienteActividadRealizada = new winAddDienteActividadRealizadaUi();
                                                                    Ext.getCmp('intPacienteDienteActividad').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                                    Ext.getCmp('intCASDienteActividad').setValue(Ext.getCmp('sysCASHC').getValue());
                                                                    //Ext.getCmp('intProfesionalDienteActividad').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                                                    Ext.getCmp('intIdProcedDienteActividad').store.load({
                                                                        params: {
                                                                            pServicio: "%SEMIOLO%"
                                                                        }
                                                                    });
                                                                    winAddDienteActividadRealizada.show();
                                                                }else{
                                                                    Ext.Msg.show({
                                                                        title: 'eOfiClinic',
                                                                        msg: 'Usted No ha Guardado la Historia de Semiologia',
                                                                        buttons: Ext.Msg.OK,
                                                                        icon: Ext.Msg.ERROR
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Eliminar Registro',
                                                        iconCls: 'btnDelRow',
                                                        id: 'btnDelActividadDiente',
                                                        listeners: {
                                                            click : function() {
                                                                if(Ext.getCmp('gridDientesActividadesRealizadas').selModel.getCount() == 1)
                                                                {
                                                                    var selections = Ext.getCmp('gridDientesActividadesRealizadas').selModel.getSelections();
                                                                    if(selections[0].json.CAS == Ext.getCmp('sysCASHC').getValue()){
                                                                        Ext.Msg.show({
                                                                            title: 'Actividades Realizadas en el Diente: ' + selections[0].json.Diente,
                                                                            msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.DesProced + '?',
                                                                            buttons: Ext.Msg.YESNO,
                                                                            icon: Ext.Msg.QUESTION,
                                                                            fn: function(btn)
                                                                            {
                                                                                if(btn=="yes")
                                                                                {
                                                                                    fnEliminarRegistros("../../controlador/asistencial/controlador_odontologia.php",{task: "ELIMINAR_DIENTE_ACTIVIDAD", pIdRegistroActividadDiente: selections[0].json.IdConsecutivoDientesActividad}, 'gridDientesActividadesRealizadas');
                                                                                }
                                                                            }
                                                                        });
                                                                    }else{
                                                                        Ext.MessageBox.show({
                                                                            title: 'Error',
                                                                            msg: 'Este Registro No Fue Creado por Usted y No Se Puede Eliminar',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                    }
                                                                }else{
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    }
                                                ]
                                            }
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 352,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                            /*,
                            {
                                xtype: 'panel',
                                title: 'Solicitud CTC',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaCTC',
                                items: [
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                items: [
                                ]
                            },*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    if (Ext.getCmp('sysUsaGridSalida').getValue() == 1){
                                                        Ext.getCmp('gridFormulario').store.reload();
                                                    }
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Imagenes Asociadas',
                            iconCls: 'btnCargarFoto',
                            listeners:{
                                click : function(){
                                    if(!winImgxPac){
                                        winImgxPac = new winImagenAsocxPac({
                                            url:'../../controlador/pacientes/controlador_filesasoc.php',
                                            width:515,
                                            height:350
                                        });
                                    }
                                    winImgxPac.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Documentos Asociados',
                            iconCls: 'btnCargarFile',
                            listeners:{
                                click : function(){
                                    if(!winDocxPac){
                                        winDocxPac = new winDocumentoAsocxPac({
                                            url:'../../controlador/pacientes/controlador_docsasoc.php',
                                            width:515,
                                            height:350
                                        });
                                    }
                                    winDocxPac.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosOdo003();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosOdo003();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                //Ext.getCmp('fsCLASIFICADX_Sano').setVisible(false);
                //RAFA
            }}
        }); 
        winHCAutonomaOdo003Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosOdo003(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnGuardarRegistrosOdo003(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/controlador_cardiologia.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
