/*
* @category    Formulario Modelo Evolucion Anexo Periodontal
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCAutonomaOdo002Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Examen Periodontal - Universidad Autonoma de Manizales::.',
    width: 1024,
    height: 600,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        
        function DescripcionGrid(val, x, store){
            mostrarHC = '<table><tr><td style="padding: 1px;">';
            mostrarHC += val;
            mostrarHC += '</td></tr></table>';
            return mostrarHC;
        }
        
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
            
        var stGridDienteActividadesRealizadas = new StoreGridDienteActividadesRealizadas();
        stGridDienteActividadesRealizadas.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        var OdontogramaInical = new Ext.Panel({
            autoLoad:{
                url:'../../../app/frm/odontograma/odontograma001.php?pPaciente=' + wPaciente + '&pCAS=' + wCAS,
                scripts:true,
                scope:this
            },
            id:'OdontogramaInical',
            height: 480,
            autoScroll:true,
            closable:false
        });
        
        var Periodontograma = new Ext.Panel({
            autoLoad:{
                url:'../../../app/frm/periodontograma/frmperiodontograma.php',
                scripts:true,
                scope:this
            },
            id:'viewPeriodontograma1',
            height: 410,
            autoScroll:true,
            closable:false
        });
        
        
        var dataExamenPSR = [
            ['0','0 = AREA COLOREADA DE LA SONDA COMPLETAMENTE VISIBLE EN EL SURCO. NO SE DETECTAN MARGENES DEFECTUOSOS O CALCULOS. TEJIDO GINGIVAL SANO SIN HEMORRAGIA DESPUES DEL SONDAJE.'],
            ['1','1 = AREA COLOREADA DE LA SONDA COMPLETAMENTE VISIBLE. NO SE DETECTAN MARGENES DEFECTUOSOS O CALCULOS. HEMORRAGIA AL SONDAJE.'],
            ['2','2 = AREA COLOREADA DE LA SONDA COMPLETAMENTE VISIBLE. PRESENCIA DE CALCULOS SUPRA O SUBGINGIVALES Y/O MARGENES DEFECTUOSOS.'],
            ['3','3 = AREA COLOREADA DE LA SONDA PERMANECE PARCIALMENTE VISIBLE AL SONDAJE.'],
            ['4','4 = AREA COLOREADA DE LA SONDA DESAPARECE COMPLETAMENTE, INDICANDO PROFUNDIDAD MAYOR A 5.5 MM.'],
            ['*','* = DENOTA ANORMALIDADES COMO INVASION DE LA FURCACION, MOVILIDAD, PROBLEMAS MUCOGINGIVALES O RECESION.'],
            ['X','X = SEXTANTE EDENTULO.']
        ];
        var stExamenPSR = new Ext.data.ArrayStore({
            fields: [
               {name: 'Codigo'},
               {name: 'Descripcion'}
            ]
        });
        stExamenPSR.loadData(dataExamenPSR);
        
        var dataDiagnosticoInicial = [
            ['SANO'],
            ['0']
        ];
        var stDiagnosticoInicial = new Ext.data.ArrayStore({
            fields: [
               {name: 'Codigo'},
               {name: 'Descripcion'}
            ]
        });
        stDiagnosticoInicial.loadData(dataDiagnosticoInicial);
        
        var dataFurcacion = [
            ['GRADO 0'],
            ['GRADO 1'],
            ['GRADO 2'],
            ['GRADO 3']
        ];
        var stFurcacion = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stFurcacion.loadData(dataFurcacion);
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                //padding: 10,
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'tabpanel',
                        //width: 930,
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'IDENTIFICACION',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaIdentifica',
                                layout: 'form',
                                items:[
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysIdCodPlantillaHC'
                                    },
                                     {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        value: 1,
                                        id: 'sysUsaGridSalida'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        value: 0,
                                        id: 'sysYaGuardoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysPlantillaHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptMx'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptExa'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptRem'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Actividad',
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        id: 'sysActividadHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Empresa',
                                        id: 'sysEmpresaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'IPS',
                                        id: 'sysIPSHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Usuario',
                                        id: 'sysUsuarioHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        id: 'sysIdPacienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Apertura',
                                        id: 'sysAperturaHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Cliente',
                                        id: 'sysClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdSubPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdContratoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Genero',
                                        id: 'sysGeneroPacHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Edad',
                                        id: 'sysEdadPacHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalAgendaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'ConsecutivoDetalle',
                                        id: 'sysConsecutivoDetalleHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'CAS',
                                                id: 'sysCASHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysFechaHC',
                                                value: 'Fecha: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysHoraHC',
                                                value: 'Hora: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysHoraHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysLegalizacionHC',
                                                value: 'Legalización: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysLegalizaHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                                        id: 'sysPacienteHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 96,
                                                allowBlank: false,
                                                fieldLabel: 'Ocupacion',
                                                id: 'sysOcupacionHC'
                                            },
                                            {
                                                xtype: 'textarea',
                                                readOnly: true,
                                                width: 695,
                                                height: 22,
                                                id: 'sysOcupacionHCNom'
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnBuscar',
                                                tooltip: 'Buscar Ocupacion',
                                                id: 'btnSearchOcupacionHC',
                                                listeners:{
                                                    click : function(){
                                                        buscarciuo('sysOcupacionHC','sysOcupacionHCNom');
                                                    }
                                                }
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Etnia',
                                                name: 'Etnia',
                                                width: 370,
                                                allowBlank: false,
                                                store: 'StoreEtnia4505',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'sysEtniaHC'
                                            },
                                            {
                                                html: 'Escolaridad:'
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Escolaridad',
                                                width: 380,
                                                allowBlank: false,
                                                store: 'StoreEscolaridad4505',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'sysEscolaridadHC'
                                            }
                                        ]
                                    },
                                    {
                                        html: '<hr>',
                                        style: 'background:transparent;',
                                        border: false
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'EXAMEN',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '99%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'panel',
                                                title: '<center>1. Examen PSR</center>',
                                                autoHeight: true,
                                                collapsible: true,
                                                titleCollapse: true,
                                                width: 920,
                                                layout: {
                                                    columns: 6,
                                                    type: 'table'
                                                },
                                                items: [
                                                    {           
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        width: 154,
                                                        padding: 5,
                                                        title: '<center>S1</center>',
                                                        items:[
                                                            {
                                                                xtype: 'combo',
                                                                width: 149,
                                                                fieldLabel: 'S1',
                                                                name: 'S1',
                                                                allowBlank: false,
                                                                store: stExamenPSR,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                tpl: '<tpl for="."><div class="cbExamenPSR"><h3>{Codigo}</h3><p style="font-size: 10; color: #00F">{Descripcion}<hr /></div></tpl>',
                                                                itemSelector: 'div.cbExamenPSR',
                                                                listWidth: 600,
                                                                maxHeight: 450,
                                                                id: 'strEXAMENPSR_S1'
                                                            }
                                                        ]
                                                    },
                                                    {           
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        width: 154,
                                                        padding: 5,
                                                        title: '<center>S2</center>',
                                                        items:[
                                                            {
                                                                xtype: 'combo',
                                                                width: 149,
                                                                fieldLabel: 'S2',
                                                                name: 'S2',
                                                                allowBlank: false,
                                                                store: stExamenPSR,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                tpl: '<tpl for="."><div class="cbExamenPSR"><h3>{Codigo}</h3><p style="font-size: 10; color: #00F">{Descripcion}<hr /></div></tpl>',
                                                                itemSelector: 'div.cbExamenPSR',
                                                                listWidth: 600,
                                                                maxHeight: 450,
                                                                id: 'strEXAMENPSR_S2'
                                                            }
                                                        ]
                                                    },
                                                    {           
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        width: 153,
                                                        padding: 5,
                                                        title: '<center>S3</center>',
                                                        items:[
                                                            {
                                                                xtype: 'combo',
                                                                width: 148,
                                                                fieldLabel: 'S3',
                                                                name: 'S3',
                                                                allowBlank: false,
                                                                store: stExamenPSR,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                tpl: '<tpl for="."><div class="cbExamenPSR"><h3>{Codigo}</h3><p style="font-size: 10; color: #00F">{Descripcion}<hr /></div></tpl>',
                                                                itemSelector: 'div.cbExamenPSR',
                                                                listWidth: 600,
                                                                maxHeight: 450,
                                                                id: 'strEXAMENPSR_S3'
                                                            }
                                                        ]
                                                    },
                                                    {           
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        width: 153,
                                                        padding: 5,
                                                        title: '<center>S4</center>',
                                                        items:[
                                                            {
                                                                xtype: 'combo',
                                                                width: 148,
                                                                fieldLabel: 'S4',
                                                                name: 'S4',
                                                                allowBlank: false,
                                                                store: stExamenPSR,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                tpl: '<tpl for="."><div class="cbExamenPSR"><h3>{Codigo}</h3><p style="font-size: 10; color: #00F">{Descripcion}<hr /></div></tpl>',
                                                                itemSelector: 'div.cbExamenPSR',
                                                                listWidth: 600,
                                                                maxHeight: 450,
                                                                id: 'strEXAMENPSR_S4'
                                                            }
                                                        ]
                                                    },
                                                    {           
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        width: 153,
                                                        padding: 5,
                                                        title: '<center>S5</center>',
                                                        items:[
                                                            {
                                                                xtype: 'combo',
                                                                width: 148,
                                                                fieldLabel: 'S5',
                                                                name: 'S5',
                                                                allowBlank: false,
                                                                store: stExamenPSR,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                tpl: '<tpl for="."><div class="cbExamenPSR"><h3>{Codigo}</h3><p style="font-size: 10; color: #00F">{Descripcion}<hr /></div></tpl>',
                                                                itemSelector: 'div.cbExamenPSR',
                                                                listWidth: 600,
                                                                maxHeight: 450,
                                                                id: 'strEXAMENPSR_S5'
                                                            }
                                                        ]
                                                    },
                                                    {           
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        width: 153,
                                                        padding: 5,
                                                        title: '<center>S6</center>',
                                                        items:[
                                                            {
                                                                xtype: 'combo',
                                                                width: 148,
                                                                fieldLabel: 'S6',
                                                                name: 'S6',
                                                                allowBlank: false,
                                                                store: stExamenPSR,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                tpl: '<tpl for="."><div class="cbExamenPSR"><h3>{Codigo}</h3><p style="font-size: 10; color: #00F">{Descripcion}<hr /></div></tpl>',
                                                                itemSelector: 'div.cbExamenPSR',
                                                                listWidth: 600,
                                                                maxHeight: 450,
                                                                id: 'strEXAMENPSR_S6'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                html: '<br>'
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: '2. Hallazgos Radiográficos',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'HALLAZGOS RADIOGRAFICOS',
                                                        name: 'HALLAZGOS RADIOGRAFICOS',
                                                        grow: true,
                                                        allowBlank: false,
                                                        id: 'memHallazgosRadiograficos'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: '3. Clasificación Diagnósticos y Protocolo de Atención y Remisión',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                labelWidth: 200,
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'SANO',
                                                        name: 'SANO',
                                                        width: 70,
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "SI",
                                                        id: 'strCLASIFICADX_Sano',
                                                        listeners:{
                                                            select : function(cmb, rec, idx){
                                                                if(cmb.getValue() == "SI"){
                                                                    Ext.getCmp('fsCLASIFICADX_Sano').setVisible(false);
                                                                    Ext.getCmp('bolCLASIFICADX_SanoH1').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_SanoH2').setValue(false);
                                                                    Ext.getCmp('memCLASIFICADX_SanoLocalizacion').setValue(null);
                                                                    Ext.getCmp('memCLASIFICADX_SanoLocalizacion').allowBlank = true;
                                                                    Ext.getCmp('memCLASIFICADX_SanoLocalizacion').clearInvalid();
                                                                    Ext.getCmp('memCLASIFICADX_SanoPronostico').setValue(null);
                                                                    Ext.getCmp('memCLASIFICADX_SanoPronostico').allowBlank = true;
                                                                    Ext.getCmp('memCLASIFICADX_SanoPronostico').clearInvalid();
                                                                    Ext.getCmp('bolCLASIFICADX_SanoProtocoloAte1').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_SanoProtocoloAte2').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_SanoProtocoloRem1').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_SanoProtocoloRem2').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_SanoProtocoloRem3').setValue(false);
                                                                }else{
                                                                    Ext.getCmp('fsCLASIFICADX_Sano').setVisible(true);
                                                                    Ext.getCmp('memCLASIFICADX_SanoLocalizacion').allowBlank = false;
                                                                    Ext.getCmp('memCLASIFICADX_SanoPronostico').allowBlank = false;
                                                                    Ext.getCmp('memCLASIFICADX_SanoLocalizacion').setVisible(true);
                                                                    Ext.getCmp('memCLASIFICADX_SanoPronostico').setVisible(true);
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'SANO',
                                                        layout: 'form',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 5,
                                                        id: 'fsCLASIFICADX_Sano',
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                title: 'HALLAZGOS',
                                                                layout: 'form',
                                                                anchor: '100%',
                                                                labelWidth: 250,
                                                                autoHeight: true,
                                                                padding: 5,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Profundidad de surco de 0-3 mm',
                                                                        name: 'Profundidad de surco de 0-3 mm',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_SanoH1'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Sin presencia de sangrado al sondaje',
                                                                        name: 'Sin presencia de sangrado al sondaje',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_SanoH2'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'LOCALIZACIÓN DIENTE/SEXTANTE',
                                                                layout: 'form',
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                padding: 5,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        anchor: '99%',
                                                                        fieldLabel: ' ',
                                                                        name: 'LOCALIZACIÓN DIENTE/SEXTANTE',
                                                                        grow: true,
                                                                        allowBlank: true,
                                                                        id: 'memCLASIFICADX_SanoLocalizacion'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'PRONOSTICO',
                                                                layout: 'form',
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                padding: 5,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        anchor: '99%',
                                                                        fieldLabel: '',
                                                                        name: 'PRONOSTICO',
                                                                        grow: true,
                                                                        allowBlank: true,
                                                                        id: 'memCLASIFICADX_SanoPronostico'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'PROTOCOLO DE ATENCIÓN',
                                                                layout: 'form',
                                                                anchor: '100%',
                                                                labelWidth: 250,
                                                                autoHeight: true,
                                                                padding: 5,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '1. Tratamiento preventivo hasta 2 citas:<br>- CPB, educación y profilaxis<br>- Registro y seguimiento en índice O´leary',
                                                                        name: '1. Tratamiento preventivo hasta 2 citas<br>CPB, educación y profilaxis<br>Registro y seguimiento en índice O´leary',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_SanoProtocoloAte1'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '2.	Control en 3, 6 o 1 año',
                                                                        name: '2. Control en 3, 6 o 1 año',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_SanoProtocoloAte2'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'PROTOCOLO DE REMISIÓN A',
                                                                layout: 'form',
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                padding: 5,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '1.	Higiene oral',
                                                                        name: '1. Higiene oral',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_SanoProtocoloRem1'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '2.	Ortodoncia',
                                                                        name: '2. Ortodoncia',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_SanoProtocoloRem2'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '3. Rehabilitación',
                                                                        name: '3. Rehabilitación',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_SanoProtocoloRem3'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'GINGIVITIS',
                                                        name: 'GINGIVITIS',
                                                        width: 70,
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'strCLASIFICADX_Gingivitis',
                                                        listeners:{
                                                            select : function(cmb, rec, idx){
                                                                if(cmb.getValue() == "NO"){
                                                                    Ext.getCmp('fsCLASIFICADX_Gingivitis').setVisible(false);
                                                                    Ext.getCmp('bolCLASIFICADX_GingivitisH1').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_GingivitisH2').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_GingivitisH3').setValue(false);
                                                                    Ext.getCmp('memCLASIFICADX_GingivitisLocalizacion').setValue(null);
                                                                    Ext.getCmp('memCLASIFICADX_GingivitisLocalizacion').allowBlank = true;
                                                                    Ext.getCmp('memCLASIFICADX_GingivitisLocalizacion').clearInvalid();
                                                                    Ext.getCmp('memCLASIFICADX_GingivitisPronostico').setValue(null);
                                                                    Ext.getCmp('memCLASIFICADX_GingivitisPronostico').allowBlank = true;
                                                                    Ext.getCmp('memCLASIFICADX_GingivitisPronostico').clearInvalid();
                                                                    Ext.getCmp('bolCLASIFICADX_GingivitisProtocoloAte1').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_GingivitisProtocoloAte2').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_GingivitisProtocoloRem1').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_GingivitisProtocoloRem2').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_GingivitisProtocoloRem3').setValue(false);
                                                                }else{
                                                                    Ext.getCmp('fsCLASIFICADX_Gingivitis').setVisible(true);
                                                                    Ext.getCmp('memCLASIFICADX_GingivitisLocalizacion').allowBlank = false;
                                                                    Ext.getCmp('memCLASIFICADX_GingivitisPronostico').allowBlank = false;
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'GINGIVITIS',
                                                        layout: 'form',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 5,
                                                        id: 'fsCLASIFICADX_Gingivitis',
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                title: 'HALLAZGOS',
                                                                layout: 'form',
                                                                anchor: '100%',
                                                                labelWidth: 250,
                                                                autoHeight: true,
                                                                padding: 5,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Profundidad de surco de 0-3 mm',
                                                                        name: 'Profundidad de surco de 0-3 mm',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_GingivitisH1'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Presencia de sangrado e inflamación',
                                                                        name: 'Presencia de sangrado e inflamación',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_GingivitisH2'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Presencia de biofilm y/o cálculos supragingivales',
                                                                        name: 'Presencia de biofilm y/o cálculos supragingivales',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_GingivitisH3'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'LOCALIZACIÓN DIENTE/SEXTANTE',
                                                                layout: 'form',
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                padding: 5,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        anchor: '99%',
                                                                        fieldLabel: ' ',
                                                                        name: 'LOCALIZACIÓN DIENTE/SEXTANTE',
                                                                        grow: true,
                                                                        allowBlank: true,
                                                                        id: 'memCLASIFICADX_GingivitisLocalizacion'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'PRONOSTICO',
                                                                layout: 'form',
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                padding: 5,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        anchor: '99%',
                                                                        fieldLabel: '',
                                                                        name: 'PRONOSTICO',
                                                                        grow: true,
                                                                        allowBlank: true,
                                                                        id: 'memCLASIFICADX_GingivitisPronostico'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'PROTOCOLO DE ATENCIÓN',
                                                                layout: 'form',
                                                                anchor: '100%',
                                                                labelWidth: 250,
                                                                autoHeight: true,
                                                                padding: 5,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '1. Tratamiento preventivo hasta 3 o 4 citas:<br>- CPB, educación y profilaxis<br>- Registro y seguimiento en índice O´leary',
                                                                        name: '1. Tratamiento preventivo hasta 3 o 4 citas:<br>- CPB, educación y profilaxis<br>- Registro y seguimiento en índice O´leary',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_GingivitisProtocoloAte1'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '2.	Control en 3, 6 o 1 año',
                                                                        name: '2. Control en 3, 6 o 1 año',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_GingivitisProtocoloAte2'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'PROTOCOLO DE REMISIÓN A',
                                                                layout: 'form',
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                padding: 5,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '1.	Higiene oral',
                                                                        name: '1. Higiene oral',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_GingivitisProtocoloRem1'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '2.	Ortodoncia',
                                                                        name: '2. Ortodoncia',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_GingivitisProtocoloRem2'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '3. Rehabilitación',
                                                                        name: '3. Rehabilitación',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_GingivitisProtocoloRem3'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'PERIODONTITIS LEVE',
                                                        name: 'PERIODONTITIS LEVE',
                                                        width: 70,
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'strCLASIFICADX_PeriodontitisLeve',
                                                        listeners:{
                                                            select : function(cmb, rec, idx){
                                                                if(cmb.getValue() == "NO"){
                                                                    Ext.getCmp('fsCLASIFICADX_PeriodontitisLeve').setVisible(false);
                                                                    Ext.getCmp('bolCLASIFICADX_PeriodontitisLeveH1').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_PeriodontitisLeveH2').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_PeriodontitisLeveH3').setValue(false);
                                                                    Ext.getCmp('memCLASIFICADX_PeriodontitisLeveLocalizacion').setValue(null);
                                                                    Ext.getCmp('memCLASIFICADX_PeriodontitisLeveLocalizacion').allowBlank = true;
                                                                    Ext.getCmp('memCLASIFICADX_PeriodontitisLeveLocalizacion').clearInvalid();
                                                                    Ext.getCmp('memCLASIFICADX_PeriodontitisLevePronostico').setValue(null);
                                                                    Ext.getCmp('memCLASIFICADX_PeriodontitisLevePronostico').allowBlank = true;
                                                                    Ext.getCmp('memCLASIFICADX_PeriodontitisLevePronostico').clearInvalid();
                                                                    Ext.getCmp('bolCLASIFICADX_PeriodontitisLeveProtocoloAte1').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_PeriodontitisLeveProtocoloAte2').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_PeriodontitisLeveProtocoloAte3').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_PeriodontitisLeveProtocoloAte4').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_PeriodontitisLeveProtocoloAte5').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_PeriodontitisLeveProtocoloRem1').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_PeriodontitisLeveProtocoloRem2').setValue(false);
                                                                }else{
                                                                    Ext.getCmp('fsCLASIFICADX_PeriodontitisLeve').setVisible(true);
                                                                    Ext.getCmp('memCLASIFICADX_PeriodontitisLeveLocalizacion').allowBlank = false;
                                                                    Ext.getCmp('memCLASIFICADX_PeriodontitisLevePronostico').allowBlank = false;
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'PERIODONTITIS LEVE',
                                                        layout: 'form',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 5,
                                                        id: 'fsCLASIFICADX_PeriodontitisLeve',
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                title: 'HALLAZGOS',
                                                                layout: 'form',
                                                                anchor: '100%',
                                                                labelWidth: 250,
                                                                autoHeight: true,
                                                                padding: 5,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Bolsas  de 3 a 5 mm de profundidad',
                                                                        name: 'Bolsas  de 3 a 5 mm de profundidad',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_PeriodontitisLeveH1'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Presencia de sangrado e inflamación',
                                                                        name: 'Presencia de sangrado e inflamación',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_PeriodontitisLeveH2'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Presencia de biofilm y/o cálculos supragingivales',
                                                                        name: 'Presencia de biofilm y/o cálculos supragingivales',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_PeriodontitisLeveH3'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'LOCALIZACIÓN DIENTE/SEXTANTE',
                                                                layout: 'form',
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                padding: 5,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        anchor: '99%',
                                                                        fieldLabel: ' ',
                                                                        name: 'LOCALIZACIÓN DIENTE/SEXTANTE',
                                                                        grow: true,
                                                                        allowBlank: true,
                                                                        id: 'memCLASIFICADX_PeriodontitisLeveLocalizacion'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'PRONOSTICO',
                                                                layout: 'form',
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                padding: 5,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        anchor: '99%',
                                                                        fieldLabel: '',
                                                                        name: 'PRONOSTICO',
                                                                        grow: true,
                                                                        allowBlank: true,
                                                                        id: 'memCLASIFICADX_PeriodontitisLevePronostico'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'PROTOCOLO DE ATENCIÓN',
                                                                layout: 'form',
                                                                anchor: '100%',
                                                                labelWidth: 250,
                                                                autoHeight: true,
                                                                padding: 5,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '1. CPB, educación y, profilaxis.',
                                                                        name: '1. CPB, educación y, profilaxis.',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_PeriodontitisLeveProtocoloAte1'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '2.	Registro y seguimiento en índice O´leary',
                                                                        name: '2. Registro y seguimiento en índice O´leary',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_PeriodontitisLeveProtocoloAte2'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '3. Raspaje y alisado radicular a campo cerrado',
                                                                        name: '3. Raspaje y alisado radicular a campo cerrado',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_PeriodontitisLeveProtocoloAte3'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '4. Controles periodontales a los 8, 15 y 30 días',
                                                                        name: '4. Controles periodontales a los 8, 15 y 30 días',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_PeriodontitisLeveProtocoloAte4'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '5. Mantenimiento periodontal cada 3 o 6 meses hasta estabilizar al paciente',
                                                                        name: '5. Mantenimiento periodontal cada 3 o 6 meses hasta estabilizar al paciente',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_PeriodontitisLeveProtocoloAte5'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'PROTOCOLO DE REMISIÓN A',
                                                                layout: 'form',
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                padding: 5,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '1. Remisión inmediata al servicio de periodoncia',
                                                                        name: '1. Remisión inmediata al servicio de periodoncia',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_PeriodontitisLeveProtocoloRem1'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '2. De acuerdo con evolución el servicio realiza remisión a ortodoncia y/o rehabilitación',
                                                                        name: '2. De acuerdo con evolución el servicio realiza remisión a ortodoncia y/o rehabilitación',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_PeriodontitisLeveProtocoloRem2'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'PERIODONTITIS MODERADA',
                                                        name: 'PERIODONTITIS MODERADA',
                                                        width: 70,
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'strCLASIFICADX_PeriodontitisModerada',
                                                        listeners:{
                                                            select : function(cmb, rec, idx){
                                                                if(cmb.getValue() == "NO"){
                                                                    Ext.getCmp('fsCLASIFICADX_PeriodontitisModerada').setVisible(false);
                                                                    Ext.getCmp('bolCLASIFICADX_PeriodontitisModeradaH1').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_PeriodontitisModeradaH2').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_PeriodontitisModeradaH3').setValue(false);
                                                                    Ext.getCmp('memCLASIFICADX_PeriodontitisModeradaLocalizacion').setValue(null);
                                                                    Ext.getCmp('memCLASIFICADX_PeriodontitisModeradaLocalizacion').allowBlank = true;
                                                                    Ext.getCmp('memCLASIFICADX_PeriodontitisModeradaLocalizacion').clearInvalid();
                                                                    Ext.getCmp('memCLASIFICADX_PeriodontitisModeradaPronostico').setValue(null);
                                                                    Ext.getCmp('memCLASIFICADX_PeriodontitisModeradaPronostico').allowBlank = true;
                                                                    Ext.getCmp('memCLASIFICADX_PeriodontitisModeradaPronostico').clearInvalid();
                                                                    Ext.getCmp('bolCLASIFICADX_PeriodontitisModeradaProtocoloAte1').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_PeriodontitisModeradaProtocoloAte2').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_PeriodontitisModeradaProtocoloAte3').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_PeriodontitisModeradaProtocoloAte4').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_PeriodontitisModeradaProtocoloAte5').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_PeriodontitisModeradaProtocoloRem1').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_PeriodontitisModeradaProtocoloRem2').setValue(false);
                                                                }else{
                                                                    Ext.getCmp('fsCLASIFICADX_PeriodontitisModerada').setVisible(true);
                                                                    Ext.getCmp('memCLASIFICADX_PeriodontitisModeradaLocalizacion').allowBlank = false;
                                                                    Ext.getCmp('memCLASIFICADX_PeriodontitisModeradaPronostico').allowBlank = false;
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'PERIODONTITIS MODERADA',
                                                        layout: 'form',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 5,
                                                        id: 'fsCLASIFICADX_PeriodontitisModerada',
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                title: 'HALLAZGOS',
                                                                layout: 'form',
                                                                anchor: '100%',
                                                                labelWidth: 250,
                                                                autoHeight: true,
                                                                padding: 5,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Bolsas de 5 a 7 mm de profundidad',
                                                                        name: 'Bolsas de 5 a 7 mm de profundidad',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_PeriodontitisModeradaH1'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Presencia de sangrado, inflamación, movilidad, exudado o perdida de inserción ',
                                                                        name: 'Presencia de sangrado, inflamación, movilidad, exudado o perdida de inserción ',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_PeriodontitisModeradaH2'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Presencia de biofilm y/o cálculos supragingivales',
                                                                        name: 'Presencia de biofilm y/o cálculos supragingivales',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_PeriodontitisModeradaH3'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'LOCALIZACIÓN DIENTE/SEXTANTE',
                                                                layout: 'form',
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                padding: 5,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        anchor: '99%',
                                                                        fieldLabel: ' ',
                                                                        name: 'LOCALIZACIÓN DIENTE/SEXTANTE',
                                                                        grow: true,
                                                                        allowBlank: true,
                                                                        id: 'memCLASIFICADX_PeriodontitisModeradaLocalizacion'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'PRONOSTICO',
                                                                layout: 'form',
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                padding: 5,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        anchor: '99%',
                                                                        fieldLabel: '',
                                                                        name: 'PRONOSTICO',
                                                                        grow: true,
                                                                        allowBlank: true,
                                                                        id: 'memCLASIFICADX_PeriodontitisModeradaPronostico'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'PROTOCOLO DE ATENCIÓN',
                                                                layout: 'form',
                                                                anchor: '100%',
                                                                labelWidth: 250,
                                                                autoHeight: true,
                                                                padding: 5,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '1. CPB, educación y, profilaxis.',
                                                                        name: '1. CPB, educación y, profilaxis.',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_PeriodontitisModeradaProtocoloAte1'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '2.	Registro y seguimiento en índice O´leary',
                                                                        name: '2. Registro y seguimiento en índice O´leary',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_PeriodontitisModeradaProtocoloAte2'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '3. Raspaje y alisado radicular a campo cerrado',
                                                                        name: '3. Raspaje y alisado radicular a campo cerrado',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_PeriodontitisModeradaProtocoloAte3'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '4. Controles periodontales a los 8, 15 y 30 días',
                                                                        name: '4. Controles periodontales a los 8, 15 y 30 días',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_PeriodontitisModeradaProtocoloAte4'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '5. Mantenimiento periodontal cada 3 o 6 meses hasta estabilizar al paciente',
                                                                        name: '5. Mantenimiento periodontal cada 3 o 6 meses hasta estabilizar al paciente',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_PeriodontitisModeradaProtocoloAte5'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'PROTOCOLO DE REMISIÓN A',
                                                                layout: 'form',
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                padding: 5,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '1. Remisión inmediata al servicio de periodoncia',
                                                                        name: '1. Remisión inmediata al servicio de periodoncia',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_PeriodontitisModeradaProtocoloRem1'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '2. De acuerdo con evolución el servicio realiza remisión a ortodoncia y/o rehabilitación',
                                                                        name: '2. De acuerdo con evolución el servicio realiza remisión a ortodoncia y/o rehabilitación',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_PeriodontitisModeradaProtocoloRem2'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'PERIODONTITIS AVANZADA',
                                                        name: 'PERIODONTITIS AVANZADA',
                                                        width: 70,
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'strCLASIFICADX_PeriodontitisAvanzada',
                                                        listeners:{
                                                            select : function(cmb, rec, idx){
                                                                if(cmb.getValue() == "NO"){
                                                                    Ext.getCmp('fsCLASIFICADX_PeriodontitisAvanzada').setVisible(false);
                                                                    Ext.getCmp('bolCLASIFICADX_PeriodontitisAvanzadaH1').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_PeriodontitisAvanzadaH2').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_PeriodontitisAvanzadaH3').setValue(false);
                                                                    Ext.getCmp('memCLASIFICADX_PeriodontitisAvanzadaLocalizacion').setValue(null);
                                                                    Ext.getCmp('memCLASIFICADX_PeriodontitisAvanzadaLocalizacion').allowBlank = true;
                                                                    Ext.getCmp('memCLASIFICADX_PeriodontitisAvanzadaLocalizacion').clearInvalid();
                                                                    Ext.getCmp('memCLASIFICADX_PeriodontitisAvanzadaPronostico').setValue(null);
                                                                    Ext.getCmp('memCLASIFICADX_PeriodontitisAvanzadaPronostico').allowBlank = true;
                                                                    Ext.getCmp('memCLASIFICADX_PeriodontitisAvanzadaPronostico').clearInvalid();
                                                                    Ext.getCmp('bolCLASIFICADX_PeriodontitisAvanzadaProtocoloAte1').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_PeriodontitisAvanzadaProtocoloAte2').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_PeriodontitisAvanzadaProtocoloAte3').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_PeriodontitisAvanzadaProtocoloAte4').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_PeriodontitisAvanzadaProtocoloAte5').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_PeriodontitisAvanzadaProtocoloRem1').setValue(false);
                                                                    Ext.getCmp('bolCLASIFICADX_PeriodontitisAvanzadaProtocoloRem2').setValue(false);
                                                                }else{
                                                                    Ext.getCmp('fsCLASIFICADX_PeriodontitisAvanzada').setVisible(true);
                                                                    Ext.getCmp('memCLASIFICADX_PeriodontitisAvanzadaLocalizacion').allowBlank = false;
                                                                    Ext.getCmp('memCLASIFICADX_PeriodontitisAvanzadaPronostico').allowBlank = false;
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'PERIODONTITIS AVANZADA',
                                                        layout: 'form',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 5,
                                                        id: 'fsCLASIFICADX_PeriodontitisAvanzada',
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                title: 'HALLAZGOS',
                                                                layout: 'form',
                                                                anchor: '100%',
                                                                labelWidth: 250,
                                                                autoHeight: true,
                                                                padding: 5,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Bolsas de 5 a 7 mm de profundidad',
                                                                        name: 'Bolsas de 5 a 7 mm de profundidad',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_PeriodontitisAvanzadaH1'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Presencia de sangrado, inflamación, movilidad, exudado o perdida de inserción',
                                                                        name: 'Presencia de sangrado, inflamación, movilidad, exudado o perdida de inserción',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_PeriodontitisAvanzadaH2'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Presencia de biofilm y/o cálculos supragingivales',
                                                                        name: 'Presencia de biofilm y/o cálculos supragingivales',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_PeriodontitisAvanzadaH3'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'LOCALIZACIÓN DIENTE/SEXTANTE',
                                                                layout: 'form',
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                padding: 5,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        anchor: '99%',
                                                                        fieldLabel: ' ',
                                                                        name: 'LOCALIZACIÓN DIENTE/SEXTANTE',
                                                                        grow: true,
                                                                        allowBlank: true,
                                                                        id: 'memCLASIFICADX_PeriodontitisAvanzadaLocalizacion'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'PRONOSTICO',
                                                                layout: 'form',
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                padding: 5,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        anchor: '99%',
                                                                        fieldLabel: '',
                                                                        name: 'PRONOSTICO',
                                                                        grow: true,
                                                                        allowBlank: true,
                                                                        id: 'memCLASIFICADX_PeriodontitisAvanzadaPronostico'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'PROTOCOLO DE ATENCIÓN',
                                                                layout: 'form',
                                                                anchor: '100%',
                                                                labelWidth: 250,
                                                                autoHeight: true,
                                                                padding: 5,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '1. CPB, educación y, profilaxis.',
                                                                        name: '1. CPB, educación y, profilaxis.',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_PeriodontitisAvanzadaProtocoloAte1'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '2.	Registro y seguimiento en índice O´leary',
                                                                        name: '2. Registro y seguimiento en índice O´leary',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_PeriodontitisAvanzadaProtocoloAte2'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '3. Raspaje y alisado radicular a campo cerrado',
                                                                        name: '3. Raspaje y alisado radicular a campo cerrado',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_PeriodontitisAvanzadaProtocoloAte3'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '4. Controles periodontales a los 8, 15 y 30 días',
                                                                        name: '4. Controles periodontales a los 8, 15 y 30 días',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_PeriodontitisAvanzadaProtocoloAte4'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '5. Mantenimiento periodontal cada 3 o 6 meses hasta estabilizar al paciente',
                                                                        name: '5. Mantenimiento periodontal cada 3 o 6 meses hasta estabilizar al paciente',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_PeriodontitisAvanzadaProtocoloAte5'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'PROTOCOLO DE REMISIÓN A',
                                                                layout: 'form',
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                padding: 5,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '1. Remisión inmediata al servicio de periodoncia',
                                                                        name: '1. Remisión inmediata al servicio de periodoncia',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_PeriodontitisAvanzadaProtocoloRem1'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: '2. De acuerdo con evolución el servicio realiza remisión a ortodoncia y/o rehabilitación',
                                                                        name: '2. De acuerdo con evolución el servicio realiza remisión a ortodoncia y/o rehabilitación',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCLASIFICADX_PeriodontitisAvanzadaProtocoloRem2'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: '4. Observaciones',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'OBSERVACIONES',
                                                        name: 'OBSERVACIONES',
                                                        grow: true,
                                                        allowBlank: false,
                                                        id: 'memObservaciones'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsRips',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }                            
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'PERIODONTOGRAMA',
                                //height: 352,
                                autoHeight: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaPeriodontograma',
                                items: [
                                    {
                                        xtype: 'button',
                                        text: 'Actualizar Periodontograma',
                                        iconCls: 'btnActualizarGrid',
                                        id: 'btnUpdatePeriodonto',
                                        listeners:{
                                            click : function(){
                                                Ext.getCmp('viewPeriodontograma1').load({
                                                    url: '../../../app/frm/periodontograma/frmperiodontograma.php',
                                                    scripts: true, 
                                                    scope: this,
                                                    params:{
                                                        dataDientes: 'jorge'
                                                    }
                                                });
                                                //var updater = Ext.getCmp('OdontogramaInical').getUpdater();
                                                //updater.refresh();
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'panel',
                                        autoHeight: true,
                                        collapsible: true,
                                        titleCollapse: true,
                                        anchor: '98%',
                                        border: true,
                                        frame: true,
                                        title: '<center>SUPERIOR - VESTIBULAR</center>',
                                        layout: {
                                            columns: 9,
                                            type: 'table'
                                        },
                                        items: [
                                            {
                                                xtype: 'panel',
                                                title: '-',
                                                width: 132,
                                                height: 220,
                                                border: true,
                                                //autoHeight: true,
                                                padding: 1,
                                                layout: {
                                                    columns: 1,
                                                    type: 'table'
                                                },
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 130,
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        border: 0,
                                                        style: 'background:transparent;text-align:right;border:none;',
                                                        value: 'Ausente:',
                                                        id: 'sysTbl1Ausente_a'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 130,
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        border: 0,
                                                        style: 'background:transparent;text-align:right;border:none;',
                                                        value: 'Implante:',
                                                        id: 'sysTbl1Implante_a'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 130,
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        border: 0,
                                                        style: 'background:transparent;text-align:right;border:none;',
                                                        value: 'Movilidad:',
                                                        id: 'sysTbl1Movilidad_a'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 130,
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        border: 0,
                                                        style: 'background:transparent;text-align:right;border:none;',
                                                        value: 'Furcacion:',
                                                        id: 'sysTbl1Furca_a'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 130,
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        border: 0,
                                                        style: 'background:transparent;text-align:right;border:none;',
                                                        value: 'Sangrado/Supuracion:',
                                                        id: 'sysTbl1Sangrado_a'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                border: 0,
                                                                style: 'background:transparent;text-align:right;border:none;',
                                                                value: 'Placa:',
                                                                id: 'sysTbl1Placa_a'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                border: 0,
                                                                style: 'background:transparent;text-align:right;border:none;',
                                                                value: 'Margen Gingival:',
                                                                id: 'sysTbl1Margen_a'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 130,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                border: 0,
                                                                style: 'background:transparent;text-align:right;border:none;',
                                                                value: 'Profundidad Sondaje:',
                                                                id: 'sysTbl1Profundidad_a'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '<center>18</center>',
                                                layout: 'form',
                                                labelWidth: 0.1,
                                                border: true,
                                                style: 'text-align:center;',
                                                width: 103,
                                                //autoHeight: true,
                                                height: 220,
                                                padding: 1,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        width: 92,
                                                        value: 'false',
                                                        name: 'bolTbl1Ausente_18a',
                                                        id: 'bolTbl1Ausente_18a',
                                                        listeners:{
                                                            check: function( t, checked ){
                                                                PintaDientes();
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'checkbox',
                                                        width: 92,
                                                        value: 'false',
                                                        name: 'bolTbl1Implante_18a',
                                                        id: 'bolTbl1Implante_18a',
                                                        listeners:{
                                                            check: function( t, checked ){
                                                                PintaDientes();
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 92,
                                                        maxValue: 3,
                                                        minValue: -3,
                                                        value: 0,
                                                        name: 'intTbl1Movilidad_18a',
                                                        id: 'intTbl1Movilidad_18a'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        width: 92,
                                                        allowBlank: true,
                                                        store: stFurcacion,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        name: 'strTbl1Furcacion_18a',
                                                        id: 'strTbl1Furcacion_18a'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Sangrado1_18a',
                                                                id: 'bolTbl1Sangrado1_18a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Sangrado2_18a',
                                                                id: 'bolTbl1Sangrado2_18a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Sangrado3_18a',
                                                                id: 'bolTbl1Sangrado3_18a'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Placa1_18a',
                                                                id: 'bolTbl1Placa1_18a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Placa2_18a',
                                                                id: 'bolTbl1Placa2_18a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Placa3_18a',
                                                                id: 'bolTbl1Placa3_18a'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1MargenGingival1_18a',
                                                                id: 'intTbl1MargenGingival1_18a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(18,'a',40,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1MargenGingival2_18a',
                                                                id: 'intTbl1MargenGingival2_18a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(18,'a',40,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1MargenGingival3_18a',
                                                                id: 'intTbl1MargenGingival3_18a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(18,'a',40,160);
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1ProfundidadSondaje1_18a',
                                                                id: 'intTbl1ProfundidadSondaje1_18a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(18,'a',40,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1ProfundidadSondaje2_18a',
                                                                id: 'intTbl1ProfundidadSondaje2_18a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(18,'a',40,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1ProfundidadSondaje3_18a',
                                                                id: 'intTbl1ProfundidadSondaje3_18a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(18,'a',40,160);
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '<center>17</center>',
                                                layout: 'form',
                                                labelWidth: 0.1,
                                                style: 'text-align:center;',
                                                width: 103,
                                               height: 220,
                                                padding: 1,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        width: 92,
                                                        value: 'false',
                                                        name: 'bolTbl1Ausente_17a',
                                                        id: 'bolTbl1Ausente_17a',
                                                        listeners:{
                                                            check: function( t, checked ){
                                                                PintaDientes();
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'checkbox',
                                                        width: 92,
                                                        value: 'false',
                                                        name: 'bolTbl1Implante_17a',
                                                        id: 'bolTbl1Implante_17a',
                                                        listeners:{
                                                            check: function( t, checked ){
                                                                PintaDientes();
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 92,
                                                        maxValue: 3,
                                                        minValue: -3,
                                                        value: 0,
                                                        name: 'intTbl1Movilidad_17a',
                                                        id: 'intTbl1Movilidad_17a'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        width: 92,
                                                        allowBlank: true,
                                                        store: stFurcacion,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        name: 'strTbl1Furcacion_17a',
                                                        id: 'strTbl1Furcacion_17a'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Sangrado1_17a',
                                                                id: 'bolTbl1Sangrado1_17a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Sangrado2_17a',
                                                                id: 'bolTbl1Sangrado2_17a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Sangrado3_17a',
                                                                id: 'bolTbl1Sangrado3_17a'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Placa1_17a',
                                                                id: 'bolTbl1Placa1_17a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Placa2_17a',
                                                                id: 'bolTbl1Placa2_17a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Placa3_17a',
                                                                id: 'bolTbl1Placa3_17a'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1MargenGingival1_17a',
                                                                id: 'intTbl1MargenGingival1_17a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(17,'a',40,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1MargenGingival2_17a',
                                                                id: 'intTbl1MargenGingival2_17a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(17,'a',40,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1MargenGingival3_17a',
                                                                id: 'intTbl1MargenGingival3_17a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(17,'a',40,160);
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1ProfundidadSondaje1_17a',
                                                                id: 'intTbl1ProfundidadSondaje1_17a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(17,'a',40,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1ProfundidadSondaje2_17a',
                                                                id: 'intTbl1ProfundidadSondaje2_17a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(17,'a',40,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1ProfundidadSondaje3_17a',
                                                                id: 'intTbl1ProfundidadSondaje3_17a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(17,'a',40,160);
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '<center>16</center>',
                                                layout: 'form',
                                                labelWidth: 0.1,
                                                style: 'text-align:center;',
                                                width: 103,
                                               height: 220,
                                                padding: 1,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        width: 92,
                                                        value: 'false',
                                                        name: 'bolTbl1Ausente_16a',
                                                        id: 'bolTbl1Ausente_16a',
                                                        listeners:{
                                                            check: function( t, checked ){
                                                                PintaDientes();
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'checkbox',
                                                        width: 92,
                                                        value: 'false',
                                                        name: 'bolTbl1Implante_16a',
                                                        id: 'bolTbl1Implante_16a',
                                                        listeners:{
                                                            check: function( t, checked ){
                                                                PintaDientes();
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 92,
                                                        maxValue: 3,
                                                        minValue: -3,
                                                        value: 0,
                                                        name: 'intTbl1Movilidad_16a',
                                                        id: 'intTbl1Movilidad_16a'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        width: 92,
                                                        allowBlank: true,
                                                        store: stFurcacion,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        name: 'strTbl1Furcacion_16a',
                                                        id: 'strTbl1Furcacion_16a'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Sangrado1_16a',
                                                                id: 'bolTbl1Sangrado1_16a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Sangrado2_16a',
                                                                id: 'bolTbl1Sangrado2_16a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Sangrado3_16a',
                                                                id: 'bolTbl1Sangrado3_16a'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Placa1_16a',
                                                                id: 'bolTbl1Placa1_16a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Placa2_16a',
                                                                id: 'bolTbl1Placa2_16a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Placa3_16a',
                                                                id: 'bolTbl1Placa3_16a'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1MargenGingival1_16a',
                                                                id: 'intTbl1MargenGingival1_16a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(16,'a',50,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1MargenGingival2_16a',
                                                                id: 'intTbl1MargenGingival2_16a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(16,'a',50,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1MargenGingival3_16a',
                                                                id: 'intTbl1MargenGingival3_16a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(16,'a',50,160);
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1ProfundidadSondaje1_16a',
                                                                id: 'intTbl1ProfundidadSondaje1_16a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(16,'a',50,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1ProfundidadSondaje2_16a',
                                                                id: 'intTbl1ProfundidadSondaje2_16a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(16,'a',50,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1ProfundidadSondaje3_16a',
                                                                id: 'intTbl1ProfundidadSondaje3_16a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(16,'a',50,160);
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '<center>15</center>',
                                                layout: 'form',
                                                labelWidth: 0.1,
                                                style: 'text-align:center;',
                                                width: 103,
                                                height: 220,
                                                padding: 1,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        width: 92,
                                                        value: 'false',
                                                        name: 'bolTbl1Ausente_15a',
                                                        id: 'bolTbl1Ausente_15a',
                                                        listeners:{
                                                            check: function( t, checked ){
                                                                PintaDientes();
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'checkbox',
                                                        width: 92,
                                                        value: 'false',
                                                        name: 'bolTbl1Implante_15a',
                                                        id: 'bolTbl1Implante_15a',
                                                        listeners:{
                                                            check: function( t, checked ){
                                                                PintaDientes();
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 92,
                                                        maxValue: 3,
                                                        minValue: -3,
                                                        value: 0,
                                                        name: 'intTbl1Movilidad_15a',
                                                        id: 'intTbl1Movilidad_15a'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        width: 92,
                                                        allowBlank: true,
                                                        store: stFurcacion,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        name: 'strTbl1Furcacion_15a',
                                                        id: 'strTbl1Furcacion_15a'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Sangrado1_15a',
                                                                id: 'bolTbl1Sangrado1_15a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Sangrado2_15a',
                                                                id: 'bolTbl1Sangrado2_15a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Sangrado3_15a',
                                                                id: 'bolTbl1Sangrado3_15a'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Placa1_15a',
                                                                id: 'bolTbl1Placa1_15a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Placa2_15a',
                                                                id: 'bolTbl1Placa2_15a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Placa3_15a',
                                                                id: 'bolTbl1Placa3_15a'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1MargenGingival1_15a',
                                                                id: 'intTbl1MargenGingival1_15a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(15,'a',28,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1MargenGingival2_15a',
                                                                id: 'intTbl1MargenGingival2_15a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(15,'a',28,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1MargenGingival3_15a',
                                                                id: 'intTbl1MargenGingival3_15a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(15,'a',28,160);
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1ProfundidadSondaje1_15a',
                                                                id: 'intTbl1ProfundidadSondaje1_15a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(15,'a',28,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1ProfundidadSondaje2_15a',
                                                                id: 'intTbl1ProfundidadSondaje2_15a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(15,'a',28,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1ProfundidadSondaje3_15a',
                                                                id: 'intTbl1ProfundidadSondaje3_15a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(15,'a',28,160);
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '<center>14</center>',
                                                layout: 'form',
                                                labelWidth: 0.1,
                                                style: 'text-align:center;',
                                                width: 103,
                                               height: 220,
                                                padding: 1,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        width: 92,
                                                        value: 'false',
                                                        name: 'bolTbl1Ausente_14a',
                                                        id: 'bolTbl1Ausente_14a',
                                                        listeners:{
                                                            check: function( t, checked ){
                                                                PintaDientes();
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'checkbox',
                                                        width: 92,
                                                        value: 'false',
                                                        name: 'bolTbl1Implante_14a',
                                                        id: 'bolTbl1Implante_14a',
                                                        listeners:{
                                                            check: function( t, checked ){
                                                                PintaDientes();
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 92,
                                                        maxValue: 3,
                                                        minValue: -3,
                                                        value: 0,
                                                        name: 'intTbl1Movilidad_14a',
                                                        id: 'intTbl1Movilidad_14a'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        width: 92,
                                                        allowBlank: true,
                                                        store: stFurcacion,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        name: 'strTbl1Furcacion_14a',
                                                        id: 'strTbl1Furcacion_14a'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Sangrado1_14a',
                                                                id: 'bolTbl1Sangrado1_14a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Sangrado2_14a',
                                                                id: 'bolTbl1Sangrado2_14a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Sangrado3_14a',
                                                                id: 'bolTbl1Sangrado3_14a'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Placa1_14a',
                                                                id: 'bolTbl1Placa1_14a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Placa2_14a',
                                                                id: 'bolTbl1Placa2_14a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Placa3_14a',
                                                                id: 'bolTbl1Placa3_14a'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1MargenGingival1_14a',
                                                                id: 'intTbl1MargenGingival1_14a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(14,'a',28,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1MargenGingival2_14a',
                                                                id: 'intTbl1MargenGingival2_14a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(14,'a',28,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1MargenGingival3_14a',
                                                                id: 'intTbl1MargenGingival3_14a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(14,'a',28,160);
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1ProfundidadSondaje1_14a',
                                                                id: 'intTbl1ProfundidadSondaje1_14a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(14,'a',28,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1ProfundidadSondaje2_14a',
                                                                id: 'intTbl1ProfundidadSondaje2_14a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(14,'a',28,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1ProfundidadSondaje3_14a',
                                                                id: 'intTbl1ProfundidadSondaje3_14a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(14,'a',28,160);
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '<center>13</center>',
                                                layout: 'form',
                                                labelWidth: 0.1,
                                                style: 'text-align:center;',
                                                width: 103,
                                               height: 220,
                                                padding: 1,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        width: 92,
                                                        value: 'false',
                                                        name: 'bolTbl1Ausente_13a',
                                                        id: 'bolTbl1Ausente_13a',
                                                        listeners:{
                                                            check: function( t, checked ){
                                                                PintaDientes();
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'checkbox',
                                                        width: 92,
                                                        value: 'false',
                                                        name: 'bolTbl1Implante_13a',
                                                        id: 'bolTbl1Implante_13a',
                                                        listeners:{
                                                            check: function( t, checked ){
                                                                PintaDientes();
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 92,
                                                        maxValue: 3,
                                                        minValue: -3,
                                                        value: 0,
                                                        name: 'intTbl1Movilidad_13a',
                                                        id: 'intTbl1Movilidad_13a'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        width: 92,
                                                        allowBlank: true,
                                                        store: stFurcacion,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        name: 'strTbl1Furcacion_13a',
                                                        id: 'strTbl1Furcacion_13a'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Sangrado1_13a',
                                                                id: 'bolTbl1Sangrado1_13a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Sangrado2_13a',
                                                                id: 'bolTbl1Sangrado2_13a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Sangrado3_13a',
                                                                id: 'bolTbl1Sangrado3_13a'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Placa1_13a',
                                                                id: 'bolTbl1Placa1_13a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Placa2_13a',
                                                                id: 'bolTbl1Placa2_13a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Placa3_13a',
                                                                id: 'bolTbl1Placa3_13a'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1MargenGingival1_13a',
                                                                id: 'intTbl1MargenGingival1_13a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(13,'a',28,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1MargenGingival2_13a',
                                                                id: 'intTbl1MargenGingival2_13a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(13,'a',28,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1MargenGingival3_13a',
                                                                id: 'intTbl1MargenGingival3_13a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(13,'a',28,160);
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1ProfundidadSondaje1_13a',
                                                                id: 'intTbl1ProfundidadSondaje1_13a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(13,'a',28,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1ProfundidadSondaje2_13a',
                                                                id: 'intTbl1ProfundidadSondaje2_13a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(13,'a',28,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1ProfundidadSondaje3_13a',
                                                                id: 'intTbl1ProfundidadSondaje3_13a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(13,'a',28,160);
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '<center>12</center>',
                                                layout: 'form',
                                                labelWidth: 0.1,
                                                style: 'text-align:center;',
                                                width: 103,
                                                height: 220,
                                                padding: 1,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        width: 92,
                                                        value: 'false',
                                                        name: 'bolTbl1Ausente_12a',
                                                        id: 'bolTbl1Ausente_12a',
                                                        listeners:{
                                                            check: function( t, checked ){
                                                                PintaDientes();
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'checkbox',
                                                        width: 92,
                                                        value: 'false',
                                                        name: 'bolTbl1Implante_12a',
                                                        id: 'bolTbl1Implante_12a',
                                                        listeners:{
                                                            check: function( t, checked ){
                                                                PintaDientes();
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 92,
                                                        maxValue: 3,
                                                        minValue: -3,
                                                        value: 0,
                                                        name: 'intTbl1Movilidad_12a',
                                                        id: 'intTbl1Movilidad_12a'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        width: 92,
                                                        allowBlank: true,
                                                        store: stFurcacion,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        name: 'strTbl1Furcacion_12a',
                                                        id: 'strTbl1Furcacion_12a'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Sangrado1_12a',
                                                                id: 'bolTbl1Sangrado1_12a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Sangrado2_12a',
                                                                id: 'bolTbl1Sangrado2_12a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Sangrado3_12a',
                                                                id: 'bolTbl1Sangrado3_12a'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Placa1_12a',
                                                                id: 'bolTbl1Placa1_12a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Placa2_12a',
                                                                id: 'bolTbl1Placa2_12a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Placa3_12a',
                                                                id: 'bolTbl1Placa3_12a'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1MargenGingival1_12a',
                                                                id: 'intTbl1MargenGingival1_12a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(12,'a',27,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1MargenGingival2_12a',
                                                                id: 'intTbl1MargenGingival2_12a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(12,'a',27,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1MargenGingival3_12a',
                                                                id: 'intTbl1MargenGingival3_12a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(12,'a',27,160);
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1ProfundidadSondaje1_12a',
                                                                id: 'intTbl1ProfundidadSondaje1_12a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(12,'a',27,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1ProfundidadSondaje2_12a',
                                                                id: 'intTbl1ProfundidadSondaje2_12a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(12,'a',27,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1ProfundidadSondaje3_12a',
                                                                id: 'intTbl1ProfundidadSondaje3_12a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(12,'a',27,160);
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '<center>11</center>',
                                                layout: 'form',
                                                labelWidth: 0.1,
                                                style: 'text-align:center;',
                                                width: 103,
                                                height: 220,
                                                padding: 1,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        width: 92,
                                                        value: 'false',
                                                        name: 'bolTbl1Ausente_11a',
                                                        id: 'bolTbl1Ausente_11a',
                                                        listeners:{
                                                            check: function( t, checked ){
                                                                PintaDientes();
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'checkbox',
                                                        width: 92,
                                                        value: 'false',
                                                        name: 'bolTbl1Implante_11a',
                                                        id: 'bolTbl1Implante_11a',
                                                        listeners:{
                                                            check: function( t, checked ){
                                                                PintaDientes();
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 92,
                                                        maxValue: 3,
                                                        minValue: -3,
                                                        value: 0,
                                                        name: 'intTbl1Movilidad_11a',
                                                        id: 'intTbl1Movilidad_11a'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        width: 92,
                                                        allowBlank: true,
                                                        store: stFurcacion,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        name: 'strTbl1Furcacion_11a',
                                                        id: 'strTbl1Furcacion_11a'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Sangrado1_11a',
                                                                id: 'bolTbl1Sangrado1_11a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Sangrado2_11a',
                                                                id: 'bolTbl1Sangrado2_11a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Sangrado3_11a',
                                                                id: 'bolTbl1Sangrado3_11a'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Placa1_11a',
                                                                id: 'bolTbl1Placa1_11a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Placa2_11a',
                                                                id: 'bolTbl1Placa2_11a'
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                width: 23,
                                                                value: 'false',
                                                                name: 'bolTbl1Placa3_11a',
                                                                id: 'bolTbl1Placa3_11a'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1MargenGingival1_11a',
                                                                id: 'intTbl1MargenGingival1_11a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(11,'a',33,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1MargenGingival2_11a',
                                                                id: 'intTbl1MargenGingival2_11a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(11,'a',33,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1MargenGingival3_11a',
                                                                id: 'intTbl1MargenGingival3_11a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(11,'a',33,160);
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1ProfundidadSondaje1_11a',
                                                                id: 'intTbl1ProfundidadSondaje1_11a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(11,'a',33,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1ProfundidadSondaje2_11a',
                                                                id: 'intTbl1ProfundidadSondaje2_11a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(11,'a',33,160);
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'-'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 23,
                                                                maxValue: 9,
                                                                minValue: -9,
                                                                value: 0,
                                                                name: 'intTbl1ProfundidadSondaje3_11a',
                                                                id: 'intTbl1ProfundidadSondaje3_11a',
                                                                listeners:{
                                                                    change: function(t, newValue, oldValue ){
                                                                        PintaPeriodontograma(11,'a',33,160);
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                //title: 'Imagen',
                                                width: 921,
                                                autoHeight: true, //420,
                                                padding: 1,
                                                colspan: 9,
                                                items: [
                                                    Periodontograma
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'ACTIVIDADES REALIZADAS',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaActividades',
                                items: [
                                    {
                                        xtype: 'grid',
                                        layout: 'fit',
                                        id: 'gridDientesActividadesRealizadas',
                                        store: stGridDienteActividadesRealizadas,
                                        anchor: "100%",
                                        height: 470,
                                        border: false,
                                        frame: true,
                                        loadMask: true,
                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Id',
                                                sortable: false,
                                                width: 1,
                                                hidden: true,
                                                hideable: false,
                                                dataIndex: 'IdConsecutivoDientesActividad',
                                                id: 'IdConsecutivoDientesActividad'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Fecha',
                                                sortable: true,
                                                width: 110,
                                                dataIndex: 'FechaAtencion',
                                                id: 'FechaAtencion'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Profesional',
                                                sortable: true,
                                                width: 170,
                                                dataIndex: 'Profesional',
                                                id: 'Profesional'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Diente',
                                                sortable: true,
                                                width: 60,
                                                dataIndex: 'Diente',
                                                id: 'Diente'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Superficie',
                                                sortable: true,
                                                width: 60,
                                                dataIndex: 'Superficie',
                                                id: 'Superficie'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Procedimiento/Actividad',
                                                sortable: true,
                                                width: 170,
                                                dataIndex: 'DesProced',
                                                renderer: DescripcionGrid,
                                                id: 'DesProced'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Notas Evolución',
                                                sortable: false,
                                                width: 270,
                                                dataIndex: 'NotasEvolucion',
                                                renderer: DescripcionGrid,
                                                id: 'NotasEvolucion'
                                            }
                                        ]),
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                                        iconCls:'icon-grid',
                                        //view: new Ext.grid.GroupingView(),
                                        tbar:
                                            {
                                                xtype: 'toolbar',
                                                items: [
                                                    {
                                                        xtype: 'button',
                                                        text: 'Adicionar Registro',
                                                        iconCls: 'btnAddRow',
                                                        id: 'btnAddActividadDiente',
                                                        listeners: {
                                                            click : function() {
                                                                if (Ext.getCmp('sysYaGuardoHC').getValue() == 1){
                                                                    var winAddDienteActividadRealizada = new winAddDienteActividadRealizadaUi();
                                                                    Ext.getCmp('intPacienteDienteActividad').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                                    Ext.getCmp('intCASDienteActividad').setValue(Ext.getCmp('sysCASHC').getValue());
                                                                    //Ext.getCmp('intProfesionalDienteActividad').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                                                    Ext.getCmp('intIdProcedDienteActividad').store.load({
                                                                        params: {
                                                                            pServicio: "%SEMIOLO%"
                                                                        }
                                                                    });
                                                                    winAddDienteActividadRealizada.show();
                                                                }else{
                                                                    Ext.Msg.show({
                                                                        title: 'eOfiClinic',
                                                                        msg: 'Usted No ha Guardado la Historia de Semiologia',
                                                                        buttons: Ext.Msg.OK,
                                                                        icon: Ext.Msg.ERROR
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Eliminar Registro',
                                                        iconCls: 'btnDelRow',
                                                        id: 'btnDelActividadDiente',
                                                        listeners: {
                                                            click : function() {
                                                                if(Ext.getCmp('gridDientesActividadesRealizadas').selModel.getCount() == 1)
                                                                {
                                                                    var selections = Ext.getCmp('gridDientesActividadesRealizadas').selModel.getSelections();
                                                                    if(selections[0].json.CAS == Ext.getCmp('sysCASHC').getValue()){
                                                                        Ext.Msg.show({
                                                                            title: 'Actividades Realizadas en el Diente: ' + selections[0].json.Diente,
                                                                            msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.DesProced + '?',
                                                                            buttons: Ext.Msg.YESNO,
                                                                            icon: Ext.Msg.QUESTION,
                                                                            fn: function(btn)
                                                                            {
                                                                                if(btn=="yes")
                                                                                {
                                                                                    fnEliminarRegistros("../../controlador/asistencial/controlador_odontologia.php",{task: "ELIMINAR_DIENTE_ACTIVIDAD", pIdRegistroActividadDiente: selections[0].json.IdConsecutivoDientesActividad}, 'gridDientesActividadesRealizadas');
                                                                                }
                                                                            }
                                                                        });
                                                                    }else{
                                                                        Ext.MessageBox.show({
                                                                            title: 'Error',
                                                                            msg: 'Este Registro No Fue Creado por Usted y No Se Puede Eliminar',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                    }
                                                                }else{
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    }
                                                ]
                                            }
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'CARTA DENTAL',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaCartaDentalInicial',
                                tbar:{
                                    items: [
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Crear Odontograma',
                                            iconCls: 'btnDiente',
                                            id: 'btnCrearOdontograma'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        '->',
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Actualizar Odontograma',
                                            iconCls: 'btnActualizarGrid',
                                            id: 'btnUpdate',
                                            listeners:{
                                                click : function(){
                                                    var updater = Ext.getCmp('OdontogramaInical').getUpdater();
                                                    updater.refresh();
                                                }
                                            }
                                        }
                                    ]
                                },
                                items: [
                                    OdontogramaInical
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 352,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                            /*,
                            {
                                xtype: 'panel',
                                title: 'Solicitud CTC',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaCTC',
                                items: [
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                items: [
                                ]
                            },*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    if (Ext.getCmp('sysUsaGridSalida').getValue() == 1){
                                                        Ext.getCmp('gridFormulario').store.reload();
                                                    }
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Imagenes Asociadas',
                            iconCls: 'btnCargarFoto',
                            listeners:{
                                click : function(){
                                    if(!winImgxPac){
                                        winImgxPac = new winImagenAsocxPac({
                                            url:'../../controlador/pacientes/controlador_filesasoc.php',
                                            width:515,
                                            height:350
                                        });
                                    }
                                    winImgxPac.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Documentos Asociados',
                            iconCls: 'btnCargarFile',
                            listeners:{
                                click : function(){
                                    if(!winDocxPac){
                                        winDocxPac = new winDocumentoAsocxPac({
                                            url:'../../controlador/pacientes/controlador_docsasoc.php',
                                            width:515,
                                            height:350
                                        });
                                    }
                                    winDocxPac.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosOdo002();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosOdo002();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                if(paramOpcion != "Nuevo"){
                    var frm = Ext.getCmp('frmHC').getForm();
                    frm.doAction('load', {
                        url: '../../controlador/asistencial/controlador_cardiologia.php',
                        waitMsg: 'Cargando Información...',
                        params:{
                            pCAS: Ext.getCmp('sysCASHC').getValue(),
                            pConsecutivo: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                            task: 'CARGAR_DATOS_HC'
                        },
                        success:function(form, action) {
                            CargarDataHC(action.result.data.sysEvolucion);
                        }
                    });
                }
                Ext.getCmp('fsCLASIFICADX_Sano').setVisible(false);
                Ext.getCmp('fsCLASIFICADX_Gingivitis').setVisible(false);
                Ext.getCmp('fsCLASIFICADX_PeriodontitisLeve').setVisible(false);
                Ext.getCmp('fsCLASIFICADX_PeriodontitisModerada').setVisible(false);
                Ext.getCmp('fsCLASIFICADX_PeriodontitisAvanzada').setVisible(false);
            }}
        }); 
        winHCAutonomaOdo002Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosOdo002(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnGuardarRegistrosOdo002(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/controlador_cardiologia.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
function PintaDientes(){
    Ext.getCmp('viewPeriodontograma1').load({
        url: '../../../app/frm/periodontograma/frmperiodontograma.php',
        scripts: true, 
        scope: this,
        params:{
            p18Ausente: Ext.getCmp('bolTbl1Ausente_18a').getValue(),
            p18Implante: Ext.getCmp('bolTbl1Implante_18a').getValue(),
            p17Ausente: Ext.getCmp('bolTbl1Ausente_17a').getValue(),
            p17Implante: Ext.getCmp('bolTbl1Implante_17a').getValue(),
            p16Ausente: Ext.getCmp('bolTbl1Ausente_16a').getValue(),
            p16Implante: Ext.getCmp('bolTbl1Implante_16a').getValue(),
            p15Ausente: Ext.getCmp('bolTbl1Ausente_15a').getValue(),
            p15Implante: Ext.getCmp('bolTbl1Implante_15a').getValue(),
            p14Ausente: Ext.getCmp('bolTbl1Ausente_14a').getValue(),
            p14Implante: Ext.getCmp('bolTbl1Implante_14a').getValue(),
            p13Ausente: Ext.getCmp('bolTbl1Ausente_13a').getValue(),
            p13Implante: Ext.getCmp('bolTbl1Implante_13a').getValue(),
            p12Ausente: Ext.getCmp('bolTbl1Ausente_12a').getValue(),
            p12Implante: Ext.getCmp('bolTbl1Implante_12a').getValue(),
            p11Ausente: Ext.getCmp('bolTbl1Ausente_11a').getValue(),
            p11Implante: Ext.getCmp('bolTbl1Implante_11a').getValue()
        },
        callback: PintaPeriodontogramaAll()
    });
    
}

function PintaPeriodontogramaAll(){
    var pMargin1 = 0;
    var pMargin2 = 0;
    var pMargin3 = 0;
    var pProson1 = 0;
    var pProson2 = 0;
    var pProson3 = 0;
    var pDiente = 0;
    var pCara = "0";
    for (var i=11; i<=18; i++){
        pMargin1 = Ext.getCmp('intTbl1MargenGingival1_' + i + 'a').getValue();
        pMargin2 = Ext.getCmp('intTbl1MargenGingival2_' + i + 'a').getValue();
        pMargin3 = Ext.getCmp('intTbl1MargenGingival3_' + i + 'a').getValue();
        pProson1 = Ext.getCmp('intTbl1ProfundidadSondaje1_' + i + 'a').getValue();
        pProson2 = Ext.getCmp('intTbl1ProfundidadSondaje2_' + i + 'a').getValue();
        pProson3 = Ext.getCmp('intTbl1ProfundidadSondaje3_' + i + 'a').getValue();
        pDiente = i;
        pCara = 'a';
        if(Ext.getCmp('bolTbl1Ausente_' + i + 'a').getValue() != true){
            cargarDataDiente(pDiente,pCara,pMargin1,pMargin2,pMargin3,pProson1,pProson2,pProson3);       
        }
    }
}

function PintaPeriodontograma(wDiente, wCara){
    var pMargin1 = 0;
    var pMargin2 = 0;
    var pMargin3 = 0;
    var pProson1 = 0;
    var pProson2 = 0;
    var pProson3 = 0;
    var pDiente = 0;
    var pCara = "0";
    pMargin1 = Ext.getCmp('intTbl1MargenGingival1_' + wDiente + 'a').getValue();
    pMargin2 = Ext.getCmp('intTbl1MargenGingival2_' + wDiente + 'a').getValue();
    pMargin3 = Ext.getCmp('intTbl1MargenGingival3_' + wDiente + 'a').getValue();
    pProson1 = Ext.getCmp('intTbl1ProfundidadSondaje1_' + wDiente + 'a').getValue();
    pProson2 = Ext.getCmp('intTbl1ProfundidadSondaje2_' + wDiente + 'a').getValue();
    pProson3 = Ext.getCmp('intTbl1ProfundidadSondaje3_' + wDiente + 'a').getValue();
    pDiente = wDiente;
    pCara = wCara;
    cargarDataDiente(pDiente,pCara,pMargin1,pMargin2,pMargin3,pProson1,pProson2,pProson3);       
}