winFrmPuestoTabajo001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HISTORIA CLINICA DE ENFERMERIA - UNIVERSIDAD DE CALDAS ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHCW001',
    initComponent: function() {
        /*tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;*/
        myPaciente = 0;
        myCAS = 0;
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaW001');
            if ( campo !== null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaW001').getValue();
            }
        }catch(ex){
        }
        if(myPaciente === 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteW001');
                if ( campo1 !== null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteW001').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente === 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefW001');
                if ( campo5 !== null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefW001').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaW001');
            if ( campo2 !== null ) {
                myCAS = Ext.getCmp('sysCASPlantillaW001').getValue();
            }
        }catch(ex){
        }
        if(myCAS === 0){
            try {
                var campo3 = Ext.getCmp('sysCASW001');
                if ( campo3 !== null ) {
                    myCAS = Ext.getCmp('sysCASW001').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS === 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefW001');
                if ( campo4 !== null ) {
                    myCAS = Ext.getCmp('sysCASRefW001').getValue();
                }
            }catch(ex){
            }
        }
        
        var fsEscalaAutoeficaciaW001 = new fsEscalaAutoeficaciaUi();
        var fsIndiceBarthelW001 = new fsIndiceBarthelUi();
        var fsEscalaLawtonW001 = new fsEscalaLawtonUi();
        var fsDepresionGeriatricaW001 = new fsDepresionGeriatricaUi();
        var fsEscalaAnsiedadW001 = new fsEscalaAnsiedadUi();
        //var fsEjecucionFisicaW001 = new fsEjecucionFisicaUi();
        var fsMiniNutricionalW001 = new fsMiniNutricionalUi();
        
        //
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHCW001',
                padding: 10,
                border: false,
                height: 610,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaW001'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalidaW001'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoW001'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaW001',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptW001'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMxW001'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExaW001'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRemW001'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadW001',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaW001'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSW001'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioW001'
                    },
                    /*{
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalW001'
                    },*/
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteW001'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaW001'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteW001'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteW001'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanW001'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanW001'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoW001'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Genero',
                        id: 'sysGeneroPacW001'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacW001'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaW001'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleW001'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASW001'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaW001',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 100,
                                id: 'sysFechaW001'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraW001',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 90,
                                id: 'sysHoraW001'
                            },
                            {
                                xtype: 'hidden',
                                allowBlank: true,
                                readOnly: true,
                                width: 100,
                                id: 'sysLegalizaW001'
                            },
                            {
                                xtype: 'hidden',
                                width: 210,
                                allowBlank: true,
                                style: 'color:brown;',
                                readOnly: true,
                                id: 'sysNroAutorizacionW001'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteW001'
                    },
                    {
                        xtype: 'hidden',
                        width: '150',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysDatBasGeneroW001'
                    },
                    //{
                    //    html: 'Edad: '
                    //},
                    {
                        xtype: 'hidden',
                        width: '350',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysDatBasEdadW001'
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        width: 930,
                        autoHeight: true,
                        border: false,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        enableTabScroll: true, 
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Enfermeria',
                                autoHeight: true,
                                autoScroll: true,
                                anchor: '100%',
                                frame: true,
                                border: false,
                                id: 'fichaEvolucionW001',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmW001',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            /*{
                                                xtype: 'textarea',
                                                anchor: '100%',
                                                grow: true,
                                                fieldLabel: 'Motivo Consulta',
                                                name: 'Motivo Consulta',
                                                emptyText: 'Registrar la razón fundamental del paciente',
                                                allowBlank: true,
                                                id: 'memMotivoConsultaW001'
                                            },*/
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                fieldLabel: 'Motivo Consulta',
                                                name: 'Motivo Consulta',
                                                allowBlank: true,
                                                id: 'memMotivoConsultaW001'
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Habitos',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                name: 'Tabaquismo',
                                                                fieldLabel: 'Tabaquismo',
                                                                allowBlank: false,
                                                                store: stUCNoSi,
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                submitValue: true,
                                                                id: 'intTabaquismoW001'
                                                            },
                                                            {
                                                                html: 'Indice Tabaquismo:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Indice Tabaquismo',
                                                                width: 250,
                                                                allowBlank: true,
                                                                id: 'strIndiceTabaquismoW001'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        width: 200,
                                                        name: 'Alcohol',
                                                        fieldLabel: 'Alcohol',
                                                        allowBlank: false,
                                                        store: stUCAlcohol,
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'intAlcoholW001'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Examen Fisico',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                fieldLabel: 'TALLA (cm)',
                                                                name:"TALLA (cm)",
                                                                emptyText: '(cm)',
                                                                id: 'intTallaW001',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intTallaW001').setValue(null);
                                                                            Ext.getCmp('intIMCW001').setValue(0);
                                                                        }else{
                                                                            if(Ext.getCmp('intPesoW001').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intTallaW001').getValue() / 100;
                                                                                Ext.getCmp('intIMCW001').setValue(Ext.getCmp('intPesoW001').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intIMCW001').setValue(0);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'PESO (Kg):'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                emptyText: '(Kg)',
                                                                name:"PESO (Kg)",
                                                                id: 'intPesoW001',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intPesoW001').setValue(null);
                                                                            Ext.getCmp('intIMCW001').setValue(0);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('intTallaW001').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intTallaW001').getValue() / 100;
                                                                                Ext.getCmp('intIMCW001').setValue(Ext.getCmp('intPesoW001').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intIMCW001').setValue(0);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'IMC:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                readOnly: true,
                                                                name: "IMC",
                                                                id: 'intIMCW001'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'Signos Vitales',
                                                        layout: 'form',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        html: 'Acostado:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Tension Arterial Acostado',
                                                                        fieldLabel: 'Tension Arterial',
                                                                        width: 150,
                                                                        allowBlank: false,
                                                                        id: 'strTensionArterialCostadoW001'
                                                                    },
                                                                    {
                                                                        html: 'Sentado:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Tension Arterial Sentado',
                                                                        width: 150,
                                                                        allowBlank: false,
                                                                        id: 'strTensionArterialSentadoW001'
                                                                    },
                                                                    {
                                                                        html: 'De pie:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Tension Arterial De pie',
                                                                        width: 150,
                                                                        allowBlank: false,
                                                                        id: 'strTensionArterialDePieW001'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 60,
                                                                        minValue: 0,
                                                                        decimalPrecision: 2,
                                                                        allowBlank: false,
                                                                        name: "FC",
                                                                        fieldLabel: "FC",
                                                                        id: 'intFCW001'
                                                                    },
                                                                    {
                                                                        html: 'FR:'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 60,
                                                                        minValue: 0,
                                                                        decimalPrecision: 2,
                                                                        allowBlank: false,
                                                                        name: "FR",
                                                                        id: 'intFRW001'
                                                                    },
                                                                    {
                                                                        html: 'Pulso:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Pulso',
                                                                        width: 60,
                                                                        allowBlank: false,
                                                                        id: 'strPulsoW001'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        name: 'Soplos',
                                                                        fieldLabel: 'Soplos',
                                                                        allowBlank: false,
                                                                        store: stUCNoSi,
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Codigo',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        submitValue: true,
                                                                        id: 'intPulsosSoplosW001'
                                                                    },
                                                                    {
                                                                        html: 'Especifique:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Soplos - Especifique',
                                                                        width: 250,
                                                                        allowBlank: true,
                                                                        id: 'strPulsosSoplosEspecifiqueW001'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        name: 'Pulsos',
                                                                        fieldLabel: 'Pulsos',
                                                                        allowBlank: false,
                                                                        store: stUCTinettiMarcha,
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Codigo',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        submitValue: true,
                                                                        id: 'intPulsosW001'
                                                                    },
                                                                    {
                                                                        html: 'Especifique:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Soplos - Especifique',
                                                                        width: 250,
                                                                        allowBlank: true,
                                                                        id: 'strPulsosEspecifiqueW001'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'textarea',
                                                anchor: '100%',
                                                grow: true,
                                                fieldLabel: 'Densitometría',
                                                name: 'Densitometría',
                                                allowBlank: false,
                                                id: 'memDensitometriaW001'
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Profesional',
                                                anchor: '100%',
                                                allowBlank: false,
                                                store: 'StoreProfesionales',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'sysProfesionalW001'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Test Autoeficacia',
                                autoHeight: true,
                                autoScroll: true,
                                anchor: '100%',
                                frame: true,
                                border: false,
                                id: 'fichaAnexo1W001',
                                layout: 'form',
                                items: [
                                    fsEscalaAutoeficaciaW001
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Test Barthel',
                                autoHeight: true,
                                autoScroll: true,
                                anchor: '100%',
                                frame: true,
                                border: false,
                                id: 'fichaAnexo2W001',
                                layout: 'form',
                                items: [
                                    fsIndiceBarthelW001
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Test Lawton y Brody',
                                autoHeight: true,
                                autoScroll: true,
                                anchor: '100%',
                                frame: true,
                                border: false,
                                id: 'fichaAnexo3W001',
                                layout: 'form',
                                items: [
                                    fsEscalaLawtonW001
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Test Yesavage',
                                autoHeight: true,
                                autoScroll: true,
                                anchor: '100%',
                                frame: true,
                                border: false,
                                id: 'fichaAnexo6W001',
                                layout: 'form',
                                items: [
                                    fsDepresionGeriatricaW001
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Test Hamilton',
                                autoHeight: true,
                                autoScroll: true,
                                anchor: '100%',
                                frame: true,
                                border: false,
                                id: 'fichaAnexo7W001',
                                layout: 'form',
                                items: [
                                    fsEscalaAnsiedadW001
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Test Mininutricional',
                                autoHeight: true,
                                autoScroll: true,
                                anchor: '100%',
                                frame: true,
                                border: false,
                                id: 'fichaAnexo9W001',
                                layout: 'form',
                                items: [
                                    fsMiniNutricionalW001
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucionW001',
                            listeners:{
                                click : function(){
                                    if (parseInt(Ext.getCmp('sysYaGuardoW001').getValue()) === 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn){
                                                if(btn === "yes"){
                                                    CerrarPuesto001();
                                                    //Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHCW001').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn){
                                                if(btn === "yes"){
                                                    CerrarPuesto001();
                                                    //Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHCW001').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerW001',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionW001').title = "PACIENTE: " + Ext.getCmp('sysPacienteW001').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaW001').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteW001').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'button',
                            text: 'Imagenes Asociadas',
                            iconCls: 'btnCargarFoto',
                            listeners:{
                                click : function(){
                                    if(!winImgxPac){
                                        winImgxPac = new winImagenAsocxPac({
                                            url:'../../controlador/pacientes/controlador_filesasoc.php',
                                            width:515,
                                            height:350
                                        });
                                    }
                                    winImgxPac.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Documentos Asociados',
                            iconCls: 'btnCargarFile',
                            listeners:{
                                click : function(){
                                    if(!winDocxPac){
                                        winDocxPac = new winDocumentoAsocxPac({
                                            url:'../../controlador/pacientes/controlador_docsasoc.php',
                                            width:515,
                                            height:350
                                        });
                                    }
                                    winDocxPac.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucionW001',
                            listeners:{
                                click : function(){
                                    if (parseInt(Ext.getCmp('sysYaGuardoW001').getValue()) === 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    fnGuardarRegistrosW001();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    fnGuardarRegistrosW001();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                //Cargar Datos Examen Fisico
                var frm = Ext.getCmp('frmW001').getForm();
                frm.doAction('load', {
                    url: '../../controlador/clinicacaidas/controlador_clinicacaidas.php',
                    waitMsg: 'Cargando Información...',
                    params:{
                        pConsecutivoHC: wConsecutivoHC,
                        task: 'LOAD_DATA_008'
                    },
                    success:function(form, action) {
                        //CargarDataHCUltimaAtencion(action.result.data.sysEvolucion);
                    }
                });
                var frm = Ext.getCmp('frmW001').getForm();
                frm.doAction('load', {
                    url: '../../controlador/clinicacaidas/controlador_clinicacaidas.php',
                    waitMsg: 'Cargando Información...',
                    params:{
                        pConsecutivoHC: wConsecutivoHC,
                        pFrm: "Puesto001",
                        task: 'LOAD_DATA_005'
                    },
                    success:function(form, action) {
                        //CargarDataHCUltimaAtencion(action.result.data.sysEvolucion);
                    }
                });
            }}
        });
        winFrmPuestoTabajo001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosW001(){
    var frm = Ext.getCmp('frmW001').getForm();
    if (frm.isValid())
    {
        frm.submit({
            url: '../../controlador/clinicacaidas/controlador_clinicacaidas.php',
            params:{
                task: 'GUARDAR_HC_ENFERMERIA',
                pConsecutivoHC: wConsecutivoHC,
                pProfesional: Ext.getCmp('sysProfesionalW001').getValue(),
                pMotivoConsulta: Ext.getCmp('memMotivoConsultaW001').getValue(),
                pTalla: Ext.getCmp('intTallaW001').getValue(),
                pPeso: Ext.getCmp('intPesoW001').getValue(),
                pIMC: Ext.getCmp('intIMCW001').getValue(),
                pTensionArterialCostado: Ext.getCmp('strTensionArterialCostadoW001').getValue(),
                pTensionArterialSentado: Ext.getCmp('strTensionArterialSentadoW001').getValue(),
                pTensionArterialDePie: Ext.getCmp('strTensionArterialDePieW001').getValue(),
                pFC: Ext.getCmp('intFCW001').getValue(),
                pFR: Ext.getCmp('intFRW001').getValue(),
                pPulsoSignosVitales: Ext.getCmp('strPulsoW001').getValue(),
                pPulsosSoplos: Ext.getCmp('intPulsosSoplosW001').getValue(),
                pPulsosSoplosEspecifique: Ext.getCmp('strPulsosSoplosEspecifiqueW001').getValue(),
                pPulsos: Ext.getCmp('intPulsosW001').getValue(),
                pPulsosEspecifique: Ext.getCmp('strPulsosEspecifiqueW001').getValue(),
                pTabaquismo: Ext.getCmp('intTabaquismoW001').getValue(),
                pIndiceTabaquismo: Ext.getCmp('strIndiceTabaquismoW001').getValue(),
                pAlcohol: Ext.getCmp('intAlcoholW001').getValue(),
                pDensitometria: Ext.getCmp('memDensitometriaW001').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function CerrarPuesto001(){
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: "../../controlador/clinicacaidas/controlador_clinicacaidas.php",
        params:{
            task: "CERRAR_UBICACION_ENFERMERIA",
            pUbicacion: "RECEPCION",
            pProceso: "ENFERMERIA",
            pConsecutivoHC: wConsecutivoHC
        },
        success: function(response,options){
            //Satisfactorio
            Ext.getCmp('gridFormulario').store.reload();
        },
        failure: function(response,options){
            //NO Satisfactorio
            Ext.getCmp('gridFormulario').store.reload();
        }
    });
}