/*
* @category    Fieldset SEGUIMIENTO TELEFONICO
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsSeguimientoTelefonicoUi = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    collapseFirst: false,
    collapsible: false,
    animCollapse: true,
    titleCollapse: true,
    padding: 0,
    id: 'fsSeguimientoTelefonico',
    initComponent: function() {
        
        
        var dataSintomasAnteriores = [
            ['Desaparicion de Sintomas'],
            ['Mejor'],
            ['Igual'],
            ['Peor']
        ];
        var stSintomasAnteriores = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stSintomasAnteriores.loadData(dataSintomasAnteriores);
        
        var dataCausaCaida = [
            ['Se Tropezo'],
            ['Se Deslizo'],
            ['Se mareo y se cayo'],
            ['Otra']
        ];
        var stCausaCaida = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stCausaCaida.loadData(dataCausaCaida);
        
        var dataMiedoCaida = [
            ['Ninguno'],
            ['Poco'],
            ['Regular'],
            ['Mucho']
        ];
        var stMiedoCaida = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stMiedoCaida.loadData(dataMiedoCaida);
        
        this.bbar = [
            {
                xtype: 'tbfill'
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Guardar Seguimiento',
                iconCls: 'btnGuardar',
                listeners:{
                    click : function(){
                        fnGuaradarSeguimientoTelefonico();
                    }
                }
            },
            {
                xtype: 'tbseparator'
            }
        ];
        
        stProfesionalesxLogin = new StoreProfesionales();
        stProfesionalesxLogin.load({
            params: {
                pUsuario: ID_USUARIO
            }
        });
        
        var stComboUbicacion = new StoreConsultoriosxIPS();
        stComboUbicacion.load({
            params: {
                pIPS: ID_IPS
            }
        });
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmSeguimiento',
                height: 450,
                padding: 10,
                border: false,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'fieldset',
                        title: 'DATOS BASICOS',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 7,
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Profesional',
                                anchor: '100%',
                                allowBlank: false,
                                store: stProfesionalesxLogin,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'sysProfesionalPlantillaSeguimiento'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Ubicación / Consultorio',
                                anchor: '100%',
                                allowBlank: false,
                                store: stComboUbicacion,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'sysUbicacionPlantillaSeguimiento'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                anchor: '100%',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Cliente',
                                        width: 300,
                                        allowBlank: false,
                                        store: 'StoreCliente',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione Cliente....',
                                        mode: 'local',
                                        triggerAction: 'all',
                                        forceSelection: true,
                                        id: 'sysIdCliente_Seguimiento',
                                        listeners: {
                                            select: function(cmb, rec, idx) {
                                                if(cmb.getValue() == null || cmb.getValue() == ""){
                                                    Ext.getCmp('sysIdPlan_Seguimiento').store.removeAll(true);
                                                    Ext.getCmp('sysIdSubPlan_Seguimiento').store.removeAll(true);
                                                    Ext.getCmp('sysIdContrato_Seguimiento').store.removeAll(true);
                                                    Ext.getCmp('intIdProcedimientoSeguimiento').store.removeAll(true);
                                                    Ext.getCmp('sysIdPlan_Seguimiento').setValue(null);
                                                    Ext.getCmp('sysIdSubPlan_Seguimiento').setValue(null);
                                                    Ext.getCmp('intIdProcedimientoSeguimiento').setValue(null);
                                                    Ext.getCmp('sysIdPlan_Seguimiento').disable();
                                                    Ext.getCmp('sysIdSubPlan_Seguimiento').disable();
                                                    Ext.getCmp('sysIdContrato_Seguimiento').disable();

                                                }else{
                                                    Ext.getCmp('sysIdPlan_Seguimiento').store.removeAll(true);
                                                    Ext.getCmp('sysIdSubPlan_Seguimiento').store.removeAll(true);
                                                    Ext.getCmp('sysIdContrato_Seguimiento').store.removeAll(true);
                                                    Ext.getCmp('intIdProcedimientoSeguimiento').store.removeAll(true);
                                                    Ext.getCmp('intIdProcedimientoSeguimiento').setValue(null);
                                                    Ext.getCmp('intIdProcedimientoSeguimiento').store.load({
                                                        params:{
                                                            pIPS: ID_IPS,
                                                            pCliente: cmb.getValue()
                                                        }
                                                    });
                                                    Ext.getCmp('sysIdPlan_Seguimiento').setValue(null);
                                                    Ext.getCmp('sysIdSubPlan_Seguimiento').setValue(null);
                                                    Ext.getCmp('sysIdSubPlan_Seguimiento').disable();
                                                    Ext.getCmp('sysIdPlan_Seguimiento').store.load({
                                                        params:{
                                                            pCliente: cmb.getValue()
                                                        },
                                                        callback: function(){
                                                            Ext.getCmp('sysIdPlan_Seguimiento').enable();
                                                        }
                                                    });
                                                    Ext.getCmp('sysIdContrato_Seguimiento').store.load({
                                                        params:{
                                                            pCliente: cmb.getValue()
                                                        },
                                                        callback: function(){
                                                            Ext.getCmp('sysIdContrato_Seguimiento').enable();
                                                        }
                                                    });
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'displayfield',
                                        value: 'Plan:'
                                    },
                                    {
                                        xtype: 'combo',
                                        width: 135,
                                        listWidth: 250,
                                        allowBlank: false,
                                        disabled: true,
                                        store: 'StoreClientesPlan',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        valueField: 'IdPlan',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione Plan....',
                                        mode: 'local',
                                        triggerAction: 'all',
                                        forceSelection: true,
                                        id: 'sysIdPlan_Seguimiento',
                                        listeners: {
                                            select: function(cmb, rec, idx) {
                                                if(cmb.getValue() == null || cmb.getValue() == ""){
                                                    Ext.getCmp('sysIdSubPlan_Seguimiento').store.removeAll(true);
                                                    Ext.getCmp('sysIdSubPlan_Seguimiento').setValue(null);
                                                    Ext.getCmp('sysIdSubPlan_Seguimiento').disable();
                                                }else{
                                                    Ext.getCmp('sysIdSubPlan_Seguimiento').store.removeAll(true);
                                                    Ext.getCmp('sysIdSubPlan_Seguimiento').store.load({
                                                        params:{
                                                            pPlan: cmb.getValue()
                                                        },
                                                        callback: function(){
                                                            Ext.getCmp('sysIdSubPlan_Seguimiento').enable();
                                                        }
                                                    });
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'displayfield',
                                        value: 'SubPlan:'
                                    },
                                    {
                                        xtype: 'combo',
                                        width: 135,
                                        listWidth: 250,
                                        allowBlank: false,
                                        disabled: true,
                                        store: 'StoreClienteSubplan',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        valueField: 'IdSubPlan',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione Plan....',
                                        mode: 'local',
                                        triggerAction: 'all',
                                        forceSelection: true,
                                        id: 'sysIdSubPlan_HC'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        value: 'Contrato:'
                                    },
                                    {
                                        xtype: 'combo',
                                        width: 133,
                                        listWidth: 250,
                                        allowBlank: false,
                                        disabled: true,
                                        store: 'StoreClienteContrato',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        valueField: 'IdContrato',
                                        displayField: 'Contrato',
                                        emptyText: 'Seleccione Contrato....',
                                        mode: 'local',
                                        triggerAction: 'all',
                                        forceSelection: true,
                                        id: 'sysIdContrato_Seguimiento'
                                    }
                                ]
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Concepto',
                                anchor: '100%',
                                allowBlank: false,
                                store: 'StoreConceptosCliente',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                tpl: '<tpl for="."><div class="cbRango"><h3>{Descripcion}</h3><span style="font-size: 12; color: #AA0033">Codigo: {CUPSCodigo}</span><br/><span style="font-size: 12; color: #0000EE ">Tarifa: $ {Tarifa}</span><hr /></div></tpl>',
                                emptyText: 'Seleccione Concepto....',
                                itemSelector: 'div.cbRango',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'intIdProcedimientoSeguimiento',
                                listeners:{
                                    select: function(cmb, rec, idx) {
                                        if(cmb.getValue() != null && cmb.getValue() != ""){
                                            Ext.getCmp('sysDesConceptoSeguimiento').setValue(rec.data.Descripcion);
                                            Ext.getCmp('sysCodConceptoSeguimiento').setValue(rec.data.CodProced);
                                            Ext.getCmp('sysVlrConceptoSeguimiento').setValue(rec.data.VlrTarifa);
                                        }else{
                                            Ext.getCmp('sysDesConceptoSeguimiento').setValue(null);
                                            Ext.getCmp('sysCodConceptoSeguimiento').setValue(null);
                                            Ext.getCmp('sysVlrConceptoSeguimiento').setValue(null);
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                fieldLabel: 'Fecha Cita',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        fieldLabel: 'Fecha Cita',
                                        allowBlank: false,
                                        disabledDates: '',
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        value: new Date().format('d/m/Y'),
                                        id: 'sysFechaPlantillaSeguimiento'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        value: '&nbsp;&nbsp;&nbsp;Nro Autorización'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 120,
                                        allowBlank: true,
                                        style: 'text-align:center;',
                                        id: 'sysNroAutorizacionSeguimiento'
                                    }
                                ]
                            }
                        ]
                    },       
                    {
                        xtype: 'checkbox',
                        fieldLabel: 'FALLECIO',
                        name: 'FALLECIO',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolFallecio'
                    },
                    {
                        xtype: 'fieldset',
                        title: 'ENFERMEDAD ACTUAL',
                        layout: 'form',
                        collapseFirst: false,
                        labelWidth: 350,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        labelSeparator: '',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Respecto a Sintomas Anteriores',
                                name: 'Respecto a Sintomas Anteriores',
                                width: 150,
                                allowBlank: true,
                                store: stSintomasAnteriores,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strSintomasAnteriores'
                            },
                            {
                                html: '<H3>CAIDAS</H3><br>'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Desde la ultima consulta se ha <b><u>CAIDO</u></b> al piso',
                                name: 'Desde la ultima consulta se ha CAIDO al piso',
                                width: 150,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strUltimaConsultaCaida'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'numberfield',
                                        fieldLabel: 'Cuantas Veces',
                                        name: 'Cuantas Veces',
                                        width: 150,
                                        minValue: 0,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'intUltimaConsultaCaidaCantidad'
                                    },
                                    {
                                        html: 'Lugar de la Caida'
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Lugar de la Caida',
                                        width: 150,
                                        allowBlank: true,
                                        id: 'strUltimaConsultaLugarCaida'
                                    }
                                ]
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Causa',
                                name: 'Causa',
                                width: 150,
                                allowBlank: true,
                                store: stCausaCaida,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strUltimaConsultaCausaCaida'
                            }, 
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Que estaba haciendo en el momento de la ultima caida?',
                                name: 'Que estaba haciendo en el momento de la ultima caida?',
                                width: 150,
                                allowBlank: true,
                                id: 'strUltimaConsultaLabor'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Necesito ayuda de otra persona para levantarse?',
                                name: 'Necesito ayuda de otra persona para levantarse?',
                                width: 150,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strUltimaConsultaAyuda'
                            },
                            {
                                xtype: 'numberfield',
                                fieldLabel: 'En la utima caida cuanto tiempo estuvo en el piso?',
                                name: 'En la utima caida cuanto tiempo estuvo en el piso?',
                                width: 150,
                                minValue: 0,
                                decimalPrecision: 0,
                                allowBlank: true,
                                emptyText: 'Segundos',
                                id: 'intUltimaConsultaCaidatiempo'
                            },
                            {
                                html: 'Por esa caida tuvo lesiones:'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Se fracturo?',
                                        name: 'Se fracturo?',
                                        width: 150,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strUltimaConsultaLesionFractura'
                                    },
                                    {
                                        html: 'Sitio'
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Sitio Fractura',
                                        width: 150,
                                        allowBlank: true,
                                        id: 'strUltimaConsultaLesionFracturaSitio'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Se disloco o torcio algo?',
                                        name: 'Se disloco o torcio algo?',
                                        width: 150,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strUltimaConsultaLesionDislocacion'
                                    },
                                    {
                                        html: 'Sitio'
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Sitio Dislocacion',
                                        width: 150,
                                        allowBlank: true,
                                        id: 'strUltimaConsultaLesionDislocacionSitio'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Se hirio?',
                                        name: 'Se hirio?',
                                        width: 150,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strUltimaConsultaLesionHerida'
                                    },
                                    {
                                        html: 'Sitio'
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Sitio Herida',
                                        width: 150,
                                        allowBlank: true,
                                        id: 'strUltimaConsultaLesionHeridaSitio'
                                    }
                                ]
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Se golpeo la cabeza y lo hospitalizaron?',
                                name: 'Se golpeo la cabeza y lo hospitalizaron?',
                                width: 150,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strUltimaConsultaLesionHospitalizacion'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Otra Lesion',
                                        name: 'Otra Lesion',
                                        width: 150,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strUltimaConsultaOtraLesion'
                                    },
                                    {
                                        html: 'Cual'
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Cual Otra Lesion',
                                        width: 150,
                                        allowBlank: true,
                                        id: 'strUltimaConsultaCualOtraLesion'
                                    }
                                ]
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Por alguna caida tuvo la necesidad de consultar?',
                                name: 'Por alguna caida tuvo la necesidad de consultar?',
                                width: 150,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strCaidaNecesidadConsulta'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'numberfield',
                                        fieldLabel: 'N. de Veces',
                                        name: 'N. de Veces',
                                        width: 150,
                                        minValue: 0,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'intCaidaNecesidadConsultaVeces'
                                    },
                                    {
                                        html: 'Sitio de la Consulta'
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Sitio de la Consulta',
                                        width: 150,
                                        allowBlank: true,
                                        id: 'strCaidaNecesidadConsultaSitio'
                                    }
                                ]
                            },
                            {
                                html: 'A consecuencia de una caida en el ultimo año, estuvo usted incapacitado para:'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Caminar dentro de a casa',
                                name: 'Caminar dentro de a casa',
                                width: 150,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strConsecuenciasCaidaCaminar'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'hacer oficio en la casa',
                                name: 'hacer oficio en la casa',
                                width: 150,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strConsecuenciasCaidaOficio'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Ir a trabajar',
                                name: 'Ir a trabajar',
                                width: 150,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strConsecuenciasCaidaTrabajo'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Tiene miedo a caer?',
                                name: 'Tiene miedo a caer?',
                                width: 150,
                                allowBlank: true,
                                store: stMiedoCaida,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strMiedoCaer'
                            }, 
                            {
                                xtype: 'combo',
                                fieldLabel: 'En caso afirmativo, por miedo a caer ha suspendido alguna actividad que usualmente realizaba?',
                                name: 'En caso afirmativo, por miedo a caer ha suspendido alguna actividad que usualmente realizaba?',
                                width: 150,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strMiedoCaerSuspensionActividad'
                            },
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'HOSPITALIZACIONES',
                        layout: 'form',
                        collapseFirst: false,
                        labelWidth: 350,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        labelSeparator: '',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Hospitalizacion',
                                name: 'Hospitalizacion',
                                width: 150,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strHospitalizacion'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'numberfield',
                                        fieldLabel: 'N. de Veces en el ultimo año',
                                        name: 'N. de Veces en el ultimo año',
                                        width: 150,
                                        minValue: 0,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'intHospitalizacionNumero'
                                    },
                                    {
                                        html: 'Sitio de la Consulta'
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Sitio de la Consulta',
                                        width: 150,
                                        allowBlank: true,
                                        id: 'strHospitalizacionRazon'
                                    }
                                ]
                            },
                            {
                                xtype: 'numberfield',
                                fieldLabel: 'Promedio de dias de Hospitalizacion',
                                name: 'Promedio de dias de Hospitalizacion',
                                width: 150,
                                minValue: 0,
                                decimalPrecision: 0,
                                allowBlank: true,
                                id: 'intHospitalizacionPromedio'
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'INSTITUCIONALIZACION',
                        layout: 'form',
                        labelWidth: 350,
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        labelSeparator: '',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'INSTITUCIONALIZACION',
                                name: 'INSTITUCIONALIZACION',
                                width: 150,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strInstitucionalizacion'
                            }
                        ]
                    }
                ]
            }
        ];
        fsSeguimientoTelefonicoUi.superclass.initComponent.call(this);
    }
});


function fnGuardarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmSeguimiento').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc2013.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: ID_EMPRESA,
                pIPS: ID_IPS,
                pPaciente: Ext.getCmp('intIdPaciente').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),//falta
                pCAS: Ext.getCmp('sysCASHC').getValue(),//falta
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),//falta
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),//falta
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),//falta
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pGuardarSignos: "SI"
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
