/*
* @category    Fieldset ESCALA AUTOEFICACIA RELACIONADA CON CAIDAS
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsEscalaAnsiedadUi = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    title: 'ESCALA DE ANSIEDAD',
    collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    titleCollapse: true,
    padding: 0,
    labelWidth: 280,
    id: 'fsEscalaAnsiedad',
    initComponent: function() {
        
        var dataHamilton = [
            [0,'Ausente / Ninguno'],
            [1,'Poco / Ligero / Leve'],
            [2,'Regular / Media / Moderado'],
            [3,'Mucha / Elevada / Grave'],
            [4,'Muy Grave / Invalidante']
        ];
        var stHamilton = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stHamilton.loadData(dataHamilton);
        
        
        var pHamiltonEstadoAnimo = 0; 
        var pHamiltonTension = 0; 
        var pHamiltonMiedosTemores = 0; 
        var pHamiltonInsomnio = 0; 
        var pHamiltonFuncionesIntelectuales = 0; 
        var pHamiltonEstadoAnimoDeprimido = 0; 
        var pHamiltonSintomasSomativosMusculares = 0; 
        var pHamiltonSintomasSomativosGenerales = 0; 
        var pHamiltonSintomasCardiovasculares = 0; 
        var pHamiltonSintomasRespiratorios = 0; 
        var pHamiltonSintomasGastrointestinales= 0; 
        var pHamiltonSintomasGenitourinariosSexuales = 0; 
        var pHamiltonSintomasNerviosoAutonomo = 0; 
        var pHamiltonComportamientoEntrevista = 0; 
        
        this.bbar = [
            {
                xtype: 'tbfill'
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Guardar Test',
                iconCls: 'btnGuardar',
                listeners:{
                    click : function(){
                        fnGuaradarTest007();
                    }
                }
            },
            {
                xtype: 'tbseparator'
            }
        ];
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmEscalaAnsiedad',
                padding: 10,
                border: false,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'combo',
                        fieldLabel: 'Se siente tenso o ansioso?',
                        name: 'Se siente tenso o ansioso?',
                        width: 60,
                        allowBlank: false,
                        store: 'StoreSiNo',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strTensoAnsioso',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew != '' || pNew != null){
                                    calculoEscalaHamilton();
                                }
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Se preocupa mucho acerca de las cosas?',
                        name: 'Se preocupa mucho acerca de las cosas?',
                        width: 60,
                        allowBlank: false,
                        store: 'StoreSiNo',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strPreocupacion',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew != '' || pNew != null){
                                    calculoEscalaHamilton();
                                }
                            }
                        }
                    },
                    {
                        xtype: 'fieldset',
                        title: 'ESCALA DE HAMILTON',
                        layout: 'form',
                        collapsible: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 7,
                        labelWidth: 400,
                        id: 'fsEscalaHamilton',
                        items: [
                            {
                                html: 'Inquietud, anticipacion de lo peor, aprension (anticipacion temerosa), irritabilidad'
                            },
                            {
                                xtype: 'combo',
                                name: 'Estado de Animo Ansioso',
                                fieldLabel: 'Estado de Animo Ansioso',
                                width: 400,
                                allowBlank: false,
                                store: stHamilton,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'intHamiltonEstadoAnimo',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        if(pNew == null || pNew == ''){
                                            pHamiltonEstadoAnimo = 0;        
                                            Ext.getCmp('intHamiltonPuntajeTotal').setValue(pHamiltonEstadoAnimo + pHamiltonTension + pHamiltonMiedosTemores + pHamiltonInsomnio + pHamiltonFuncionesIntelectuales + pHamiltonEstadoAnimoDeprimido + pHamiltonSintomasSomativosMusculares + pHamiltonSintomasSomativosGenerales + pHamiltonSintomasCardiovasculares + pHamiltonSintomasRespiratorios + pHamiltonSintomasGastrointestinales + pHamiltonSintomasGenitourinariosSexuales + pHamiltonSintomasNerviosoAutonomo + pHamiltonComportamientoEntrevista)
                                        }else{
                                            pHamiltonEstadoAnimo = Ext.getCmp('intHamiltonEstadoAnimo').getValue();
                                            Ext.getCmp('intHamiltonPuntajeTotal').setValue(pHamiltonEstadoAnimo + pHamiltonTension + pHamiltonMiedosTemores + pHamiltonInsomnio + pHamiltonFuncionesIntelectuales + pHamiltonEstadoAnimoDeprimido + pHamiltonSintomasSomativosMusculares + pHamiltonSintomasSomativosGenerales + pHamiltonSintomasCardiovasculares + pHamiltonSintomasRespiratorios + pHamiltonSintomasGastrointestinales + pHamiltonSintomasGenitourinariosSexuales + pHamiltonSintomasNerviosoAutonomo + pHamiltonComportamientoEntrevista)
                                        }
                                    }
                                }
                            },
                            {
                                html: '<br>'
                            },
                            {
                                html: 'Sensaciones de tension Fatigabilidad, Imposibilidad de Relajarse. Reacciones de sobresalto. Llanto facil. Temblores. Sensaciones de inquietud.'
                            },
                            {
                                xtype: 'combo',
                                name: 'Tension',
                                fieldLabel: 'Tension',
                                width: 400,
                                allowBlank: false,
                                store: stHamilton,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'intHamiltonTension',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        if(pNew == null || pNew == ''){
                                            pHamiltonTension = 0;        
                                            Ext.getCmp('intHamiltonPuntajeTotal').setValue(pHamiltonEstadoAnimo + pHamiltonTension + pHamiltonMiedosTemores + pHamiltonInsomnio + pHamiltonFuncionesIntelectuales + pHamiltonEstadoAnimoDeprimido + pHamiltonSintomasSomativosMusculares + pHamiltonSintomasSomativosGenerales + pHamiltonSintomasCardiovasculares + pHamiltonSintomasRespiratorios + pHamiltonSintomasGastrointestinales + pHamiltonSintomasGenitourinariosSexuales + pHamiltonSintomasNerviosoAutonomo + pHamiltonComportamientoEntrevista)
                                        }else{
                                            pHamiltonTension = Ext.getCmp('intHamiltonTension').getValue();
                                            Ext.getCmp('intHamiltonPuntajeTotal').setValue(pHamiltonEstadoAnimo + pHamiltonTension + pHamiltonMiedosTemores + pHamiltonInsomnio + pHamiltonFuncionesIntelectuales + pHamiltonEstadoAnimoDeprimido + pHamiltonSintomasSomativosMusculares + pHamiltonSintomasSomativosGenerales + pHamiltonSintomasCardiovasculares + pHamiltonSintomasRespiratorios + pHamiltonSintomasGastrointestinales + pHamiltonSintomasGenitourinariosSexuales + pHamiltonSintomasNerviosoAutonomo + pHamiltonComportamientoEntrevista)
                                        }
                                    }
                                }
                            },
                            {
                                html: '<br>'
                            },
                            {
                                html: 'A la Oscuridad. A los desconocidos. A quedarse solo. A los animales. A la circunstancia. A las multitudes'
                            },
                            {
                                xtype: 'combo',
                                name: 'Miedos / Temores',
                                fieldLabel: 'Miedos / Temores',
                                width: 400,
                                allowBlank: false,
                                store: stHamilton,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'intHamiltonMiedosTemores',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        if(pNew == null || pNew == ''){
                                            pHamiltonMiedosTemores = 0;        
                                            Ext.getCmp('intHamiltonPuntajeTotal').setValue(pHamiltonEstadoAnimo + pHamiltonTension + pHamiltonMiedosTemores + pHamiltonInsomnio + pHamiltonFuncionesIntelectuales + pHamiltonEstadoAnimoDeprimido + pHamiltonSintomasSomativosMusculares + pHamiltonSintomasSomativosGenerales + pHamiltonSintomasCardiovasculares + pHamiltonSintomasRespiratorios + pHamiltonSintomasGastrointestinales + pHamiltonSintomasGenitourinariosSexuales + pHamiltonSintomasNerviosoAutonomo + pHamiltonComportamientoEntrevista)
                                        }else{
                                            pHamiltonMiedosTemores = Ext.getCmp('intHamiltonMiedosTemores').getValue();
                                            Ext.getCmp('intHamiltonPuntajeTotal').setValue(pHamiltonEstadoAnimo + pHamiltonTension + pHamiltonMiedosTemores + pHamiltonInsomnio + pHamiltonFuncionesIntelectuales + pHamiltonEstadoAnimoDeprimido + pHamiltonSintomasSomativosMusculares + pHamiltonSintomasSomativosGenerales + pHamiltonSintomasCardiovasculares + pHamiltonSintomasRespiratorios + pHamiltonSintomasGastrointestinales + pHamiltonSintomasGenitourinariosSexuales + pHamiltonSintomasNerviosoAutonomo + pHamiltonComportamientoEntrevista)
                                        }
                                    }
                                }
                            },
                            {
                                html: '<br>'
                            },
                            {
                                html: 'Dificultades para Domirse. Sueño interrumpido. Sueño no Satisfactorio y cansancio al despertar'
                            },
                            {
                                xtype: 'combo',
                                name: 'Insomnio',
                                fieldLabel: 'Insomnio',
                                width: 400,
                                allowBlank: false,
                                store: stHamilton,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'intHamiltonInsomnio',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        if(pNew == null || pNew == ''){
                                            pHamiltonInsomnio = 0;        
                                            Ext.getCmp('intHamiltonPuntajeTotal').setValue(pHamiltonEstadoAnimo + pHamiltonTension + pHamiltonMiedosTemores + pHamiltonInsomnio + pHamiltonFuncionesIntelectuales + pHamiltonEstadoAnimoDeprimido + pHamiltonSintomasSomativosMusculares + pHamiltonSintomasSomativosGenerales + pHamiltonSintomasCardiovasculares + pHamiltonSintomasRespiratorios + pHamiltonSintomasGastrointestinales + pHamiltonSintomasGenitourinariosSexuales + pHamiltonSintomasNerviosoAutonomo + pHamiltonComportamientoEntrevista)
                                        }else{
                                            pHamiltonInsomnio = Ext.getCmp('intHamiltonInsomnio').getValue();
                                            Ext.getCmp('intHamiltonPuntajeTotal').setValue(pHamiltonEstadoAnimo + pHamiltonTension + pHamiltonMiedosTemores + pHamiltonInsomnio + pHamiltonFuncionesIntelectuales + pHamiltonEstadoAnimoDeprimido + pHamiltonSintomasSomativosMusculares + pHamiltonSintomasSomativosGenerales + pHamiltonSintomasCardiovasculares + pHamiltonSintomasRespiratorios + pHamiltonSintomasGastrointestinales + pHamiltonSintomasGenitourinariosSexuales + pHamiltonSintomasNerviosoAutonomo + pHamiltonComportamientoEntrevista)
                                        }
                                    }
                                }
                            },
                            {
                                html: '<br>'
                            },
                            {
                                html: 'Dificultad para concentracion. Mala memoria'
                            },
                            {
                                xtype: 'combo',
                                name: 'Funciones Intelectuales (Cognoscitivas)',
                                fieldLabel: 'Funciones Intelectuales (Cognoscitivas)',
                                width: 400,
                                allowBlank: false,
                                store: stHamilton,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'intHamiltonFuncionesIntelectuales',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        if(pNew == null || pNew == ''){
                                            pHamiltonFuncionesIntelectuales = 0;        
                                            Ext.getCmp('intHamiltonPuntajeTotal').setValue(pHamiltonEstadoAnimo + pHamiltonTension + pHamiltonMiedosTemores + pHamiltonInsomnio + pHamiltonFuncionesIntelectuales + pHamiltonEstadoAnimoDeprimido + pHamiltonSintomasSomativosMusculares + pHamiltonSintomasSomativosGenerales + pHamiltonSintomasCardiovasculares + pHamiltonSintomasRespiratorios + pHamiltonSintomasGastrointestinales + pHamiltonSintomasGenitourinariosSexuales + pHamiltonSintomasNerviosoAutonomo + pHamiltonComportamientoEntrevista)
                                        }else{
                                            pHamiltonFuncionesIntelectuales = Ext.getCmp('intHamiltonFuncionesIntelectuales').getValue();
                                            Ext.getCmp('intHamiltonPuntajeTotal').setValue(pHamiltonEstadoAnimo + pHamiltonTension + pHamiltonMiedosTemores + pHamiltonInsomnio + pHamiltonFuncionesIntelectuales + pHamiltonEstadoAnimoDeprimido + pHamiltonSintomasSomativosMusculares + pHamiltonSintomasSomativosGenerales + pHamiltonSintomasCardiovasculares + pHamiltonSintomasRespiratorios + pHamiltonSintomasGastrointestinales + pHamiltonSintomasGenitourinariosSexuales + pHamiltonSintomasNerviosoAutonomo + pHamiltonComportamientoEntrevista)
                                        }
                                    }
                                }
                            },
                            {
                                html: '<br>'
                            },
                            {
                                html: 'Perdida del interes. Insatisfaccion en las diversiones. Depresion. Insomnio de madrugada. Cambios de humos a lo largo del dia'
                            },
                            {
                                xtype: 'combo',
                                name: 'Estado de Animo Deprimido',
                                fieldLabel: 'Estado de Animo Deprimido',
                                width: 400,
                                allowBlank: false,
                                store: stHamilton,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'intHamiltonEstadoAnimoDeprimido',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        if(pNew == null || pNew == ''){
                                            pHamiltonEstadoAnimoDeprimido = 0;        
                                            Ext.getCmp('intHamiltonPuntajeTotal').setValue(pHamiltonEstadoAnimo + pHamiltonTension + pHamiltonMiedosTemores + pHamiltonInsomnio + pHamiltonFuncionesIntelectuales + pHamiltonEstadoAnimoDeprimido + pHamiltonSintomasSomativosMusculares + pHamiltonSintomasSomativosGenerales + pHamiltonSintomasCardiovasculares + pHamiltonSintomasRespiratorios + pHamiltonSintomasGastrointestinales + pHamiltonSintomasGenitourinariosSexuales + pHamiltonSintomasNerviosoAutonomo + pHamiltonComportamientoEntrevista)
                                        }else{
                                            pHamiltonEstadoAnimoDeprimido = Ext.getCmp('intHamiltonEstadoAnimoDeprimido').getValue();
                                            Ext.getCmp('intHamiltonPuntajeTotal').setValue(pHamiltonEstadoAnimo + pHamiltonTension + pHamiltonMiedosTemores + pHamiltonInsomnio + pHamiltonFuncionesIntelectuales + pHamiltonEstadoAnimoDeprimido + pHamiltonSintomasSomativosMusculares + pHamiltonSintomasSomativosGenerales + pHamiltonSintomasCardiovasculares + pHamiltonSintomasRespiratorios + pHamiltonSintomasGastrointestinales + pHamiltonSintomasGenitourinariosSexuales + pHamiltonSintomasNerviosoAutonomo + pHamiltonComportamientoEntrevista)
                                        }
                                    }
                                }
                            },
                            {
                                html: '<br>'
                            },
                            {
                                html: 'Dolores y molestias musculares. Rigidez muscular. Sacudidas clonicas. Rechinar de Dientes. Voz quebrada'
                            },
                            {
                                xtype: 'combo',
                                name: 'Sintomas Somativos musculares',
                                fieldLabel: 'Sintomas Somativos musculares',
                                width: 400,
                                allowBlank: false,
                                store: stHamilton,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'intHamiltonSintomasSomativosMusculares',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        if(pNew == null || pNew == ''){
                                            pHamiltonSintomasSomativosMusculares = 0;        
                                            Ext.getCmp('intHamiltonPuntajeTotal').setValue(pHamiltonEstadoAnimo + pHamiltonTension + pHamiltonMiedosTemores + pHamiltonInsomnio + pHamiltonFuncionesIntelectuales + pHamiltonEstadoAnimoDeprimido + pHamiltonSintomasSomativosMusculares + pHamiltonSintomasSomativosGenerales + pHamiltonSintomasCardiovasculares + pHamiltonSintomasRespiratorios + pHamiltonSintomasGastrointestinales + pHamiltonSintomasGenitourinariosSexuales + pHamiltonSintomasNerviosoAutonomo + pHamiltonComportamientoEntrevista)
                                        }else{
                                            pHamiltonSintomasSomativosMusculares = Ext.getCmp('intHamiltonSintomasSomativosMusculares').getValue();
                                            Ext.getCmp('intHamiltonPuntajeTotal').setValue(pHamiltonEstadoAnimo + pHamiltonTension + pHamiltonMiedosTemores + pHamiltonInsomnio + pHamiltonFuncionesIntelectuales + pHamiltonEstadoAnimoDeprimido + pHamiltonSintomasSomativosMusculares + pHamiltonSintomasSomativosGenerales + pHamiltonSintomasCardiovasculares + pHamiltonSintomasRespiratorios + pHamiltonSintomasGastrointestinales + pHamiltonSintomasGenitourinariosSexuales + pHamiltonSintomasNerviosoAutonomo + pHamiltonComportamientoEntrevista)
                                        }
                                    }
                                }
                            },
                            {
                                html: '<br>'
                            },
                            {
                                html: 'Zumbidos de oidos. Vision Borrosa. Oleadas de Calor o Frio. Sensacion de Debilidad. Sensacion de hormigueo'
                            },
                            {
                                xtype: 'combo',
                                name: 'Sintomas Somativos Generales',
                                fieldLabel: 'Sintomas Somativos Generales',
                                width: 400,
                                allowBlank: false,
                                store: stHamilton,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'intHamiltonSintomasSomativosGenerales',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        if(pNew == null || pNew == ''){
                                            pHamiltonSintomasSomativosGenerales = 0;        
                                            Ext.getCmp('intHamiltonPuntajeTotal').setValue(pHamiltonEstadoAnimo + pHamiltonTension + pHamiltonMiedosTemores + pHamiltonInsomnio + pHamiltonFuncionesIntelectuales + pHamiltonEstadoAnimoDeprimido + pHamiltonSintomasSomativosMusculares + pHamiltonSintomasSomativosGenerales + pHamiltonSintomasCardiovasculares + pHamiltonSintomasRespiratorios + pHamiltonSintomasGastrointestinales + pHamiltonSintomasGenitourinariosSexuales + pHamiltonSintomasNerviosoAutonomo + pHamiltonComportamientoEntrevista)
                                        }else{
                                            pHamiltonSintomasSomativosGenerales = Ext.getCmp('intHamiltonSintomasSomativosGenerales').getValue();
                                            Ext.getCmp('intHamiltonPuntajeTotal').setValue(pHamiltonEstadoAnimo + pHamiltonTension + pHamiltonMiedosTemores + pHamiltonInsomnio + pHamiltonFuncionesIntelectuales + pHamiltonEstadoAnimoDeprimido + pHamiltonSintomasSomativosMusculares + pHamiltonSintomasSomativosGenerales + pHamiltonSintomasCardiovasculares + pHamiltonSintomasRespiratorios + pHamiltonSintomasGastrointestinales + pHamiltonSintomasGenitourinariosSexuales + pHamiltonSintomasNerviosoAutonomo + pHamiltonComportamientoEntrevista)
                                        }
                                    }
                                }
                            },
                            {
                                html: '<br>'
                            },
                            {
                                html: 'Taquicardia. Palpaciones. Dolor Toracico. Latidos vasculares. Sensaciones de "baja presion" o desmayos. Extrasistoles (arritmias cardiacas benignas)'
                            },
                            {
                                xtype: 'combo',
                                name: 'Sintomas Cardiovasculares',
                                fieldLabel: 'Sintomas Cardiovasculares',
                                width: 400,
                                allowBlank: false,
                                store: stHamilton,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'intHamiltonSintomasCardiovasculares',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        if(pNew == null || pNew == ''){
                                            pHamiltonSintomasCardiovasculares = 0;        
                                            Ext.getCmp('intHamiltonPuntajeTotal').setValue(pHamiltonEstadoAnimo + pHamiltonTension + pHamiltonMiedosTemores + pHamiltonInsomnio + pHamiltonFuncionesIntelectuales + pHamiltonEstadoAnimoDeprimido + pHamiltonSintomasSomativosMusculares + pHamiltonSintomasSomativosGenerales + pHamiltonSintomasCardiovasculares + pHamiltonSintomasRespiratorios + pHamiltonSintomasGastrointestinales + pHamiltonSintomasGenitourinariosSexuales + pHamiltonSintomasNerviosoAutonomo + pHamiltonComportamientoEntrevista)
                                        }else{
                                            pHamiltonSintomasCardiovasculares = Ext.getCmp('intHamiltonSintomasCardiovasculares').getValue();
                                            Ext.getCmp('intHamiltonPuntajeTotal').setValue(pHamiltonEstadoAnimo + pHamiltonTension + pHamiltonMiedosTemores + pHamiltonInsomnio + pHamiltonFuncionesIntelectuales + pHamiltonEstadoAnimoDeprimido + pHamiltonSintomasSomativosMusculares + pHamiltonSintomasSomativosGenerales + pHamiltonSintomasCardiovasculares + pHamiltonSintomasRespiratorios + pHamiltonSintomasGastrointestinales + pHamiltonSintomasGenitourinariosSexuales + pHamiltonSintomasNerviosoAutonomo + pHamiltonComportamientoEntrevista)
                                        }
                                    }
                                }
                            },
                            {
                                html: '<br>'
                            },
                            {
                                html: 'Opresion o constriccion en el pecho. Sensacion de ahogoo falta de aire. Suspiros. Disnea (Dificultad para Respiracion)'
                            },
                            {
                                xtype: 'combo',
                                name: 'Sintomas Respiratorios',
                                fieldLabel: 'Sintomas Respiratorios',
                                width: 400,
                                allowBlank: false,
                                store: stHamilton,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'intHamiltonSintomasRespiratorios',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        if(pNew == null || pNew == ''){
                                            pHamiltonSintomasRespiratorios = 0;        
                                            Ext.getCmp('intHamiltonPuntajeTotal').setValue(pHamiltonEstadoAnimo + pHamiltonTension + pHamiltonMiedosTemores + pHamiltonInsomnio + pHamiltonFuncionesIntelectuales + pHamiltonEstadoAnimoDeprimido + pHamiltonSintomasSomativosMusculares + pHamiltonSintomasSomativosGenerales + pHamiltonSintomasCardiovasculares + pHamiltonSintomasRespiratorios + pHamiltonSintomasGastrointestinales + pHamiltonSintomasGenitourinariosSexuales + pHamiltonSintomasNerviosoAutonomo + pHamiltonComportamientoEntrevista)
                                        }else{
                                            pHamiltonSintomasRespiratorios = Ext.getCmp('intHamiltonSintomasRespiratorios').getValue();
                                            Ext.getCmp('intHamiltonPuntajeTotal').setValue(pHamiltonEstadoAnimo + pHamiltonTension + pHamiltonMiedosTemores + pHamiltonInsomnio + pHamiltonFuncionesIntelectuales + pHamiltonEstadoAnimoDeprimido + pHamiltonSintomasSomativosMusculares + pHamiltonSintomasSomativosGenerales + pHamiltonSintomasCardiovasculares + pHamiltonSintomasRespiratorios + pHamiltonSintomasGastrointestinales + pHamiltonSintomasGenitourinariosSexuales + pHamiltonSintomasNerviosoAutonomo + pHamiltonComportamientoEntrevista)
                                        }
                                    }
                                }
                            },
                            {
                                html: '<br>'
                            },
                            {
                                html: 'Dificultad para tragar. Gases. Dispepsia. Dolores antes o despues de comar. Sensacion de estomago vacio. Digestion Lenta. Ruido Intestinal. Diarrea. Perdida de peso. Estreñimiento'
                            },
                            {
                                xtype: 'combo',
                                name: 'Sintomas Gastrointestinales',
                                fieldLabel: 'Sintomas Gastrointestinales',
                                width: 400,
                                allowBlank: false,
                                store: stHamilton,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'intHamiltonSintomasGastrointestinales',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        if(pNew == null || pNew == ''){
                                            pHamiltonSintomasGastrointestinales = 0;        
                                            Ext.getCmp('intHamiltonPuntajeTotal').setValue(pHamiltonEstadoAnimo + pHamiltonTension + pHamiltonMiedosTemores + pHamiltonInsomnio + pHamiltonFuncionesIntelectuales + pHamiltonEstadoAnimoDeprimido + pHamiltonSintomasSomativosMusculares + pHamiltonSintomasSomativosGenerales + pHamiltonSintomasCardiovasculares + pHamiltonSintomasRespiratorios + pHamiltonSintomasGastrointestinales + pHamiltonSintomasGenitourinariosSexuales + pHamiltonSintomasNerviosoAutonomo + pHamiltonComportamientoEntrevista)
                                        }else{
                                            pHamiltonSintomasGastrointestinales = Ext.getCmp('intHamiltonSintomasGastrointestinales').getValue();
                                            Ext.getCmp('intHamiltonPuntajeTotal').setValue(pHamiltonEstadoAnimo + pHamiltonTension + pHamiltonMiedosTemores + pHamiltonInsomnio + pHamiltonFuncionesIntelectuales + pHamiltonEstadoAnimoDeprimido + pHamiltonSintomasSomativosMusculares + pHamiltonSintomasSomativosGenerales + pHamiltonSintomasCardiovasculares + pHamiltonSintomasRespiratorios + pHamiltonSintomasGastrointestinales + pHamiltonSintomasGenitourinariosSexuales + pHamiltonSintomasNerviosoAutonomo + pHamiltonComportamientoEntrevista)
                                        }
                                    }
                                }
                            },
                            {
                                html: '<br>'
                            },
                            {
                                html: 'Micciones frecuentes. Miccion imperiosa. Falta del periodo mestrual. Hemorragia genital. Frigidez. Eyaculacion Precoz. Impotensia. Ausencia de ereccion.'
                            },
                            {
                                xtype: 'combo',
                                name: 'Sintomas Genitourinarios y Sexuales',
                                fieldLabel: 'Sintomas Genitourinarios y Sexuales',
                                width: 400,
                                allowBlank: false,
                                store: stHamilton,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'intHamiltonSintomasGenitourinariosSexuales',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        if(pNew == null || pNew == ''){
                                            pHamiltonSintomasGenitourinariosSexuales = 0;        
                                            Ext.getCmp('intHamiltonPuntajeTotal').setValue(pHamiltonEstadoAnimo + pHamiltonTension + pHamiltonMiedosTemores + pHamiltonInsomnio + pHamiltonFuncionesIntelectuales + pHamiltonEstadoAnimoDeprimido + pHamiltonSintomasSomativosMusculares + pHamiltonSintomasSomativosGenerales + pHamiltonSintomasCardiovasculares + pHamiltonSintomasRespiratorios + pHamiltonSintomasGastrointestinales + pHamiltonSintomasGenitourinariosSexuales + pHamiltonSintomasNerviosoAutonomo + pHamiltonComportamientoEntrevista)
                                        }else{
                                            pHamiltonSintomasGenitourinariosSexuales = Ext.getCmp('intHamiltonSintomasGenitourinariosSexuales').getValue();
                                            Ext.getCmp('intHamiltonPuntajeTotal').setValue(pHamiltonEstadoAnimo + pHamiltonTension + pHamiltonMiedosTemores + pHamiltonInsomnio + pHamiltonFuncionesIntelectuales + pHamiltonEstadoAnimoDeprimido + pHamiltonSintomasSomativosMusculares + pHamiltonSintomasSomativosGenerales + pHamiltonSintomasCardiovasculares + pHamiltonSintomasRespiratorios + pHamiltonSintomasGastrointestinales + pHamiltonSintomasGenitourinariosSexuales + pHamiltonSintomasNerviosoAutonomo + pHamiltonComportamientoEntrevista)
                                        }
                                    }
                                }
                            },
                            {
                                html: '<br>'
                            },
                            {
                                html: 'Boca seca. Rubor. Palidez. Tendencia a la Sudoracion. Vertigos. Cefalea de tension. Piloereccion (pelos de ereccion)'
                            },
                            {
                                xtype: 'combo',
                                name: 'Sintomas Nervioso Autonomo',
                                fieldLabel: 'Sintomas Nervioso Autonomo',
                                width: 400,
                                allowBlank: false,
                                store: stHamilton,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'intHamiltonSintomasNerviosoAutonomo',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        if(pNew == null || pNew == ''){
                                            pHamiltonSintomasNerviosoAutonomo = 0;        
                                            Ext.getCmp('intHamiltonPuntajeTotal').setValue(pHamiltonEstadoAnimo + pHamiltonTension + pHamiltonMiedosTemores + pHamiltonInsomnio + pHamiltonFuncionesIntelectuales + pHamiltonEstadoAnimoDeprimido + pHamiltonSintomasSomativosMusculares + pHamiltonSintomasSomativosGenerales + pHamiltonSintomasCardiovasculares + pHamiltonSintomasRespiratorios + pHamiltonSintomasGastrointestinales + pHamiltonSintomasGenitourinariosSexuales + pHamiltonSintomasNerviosoAutonomo + pHamiltonComportamientoEntrevista)
                                        }else{
                                            pHamiltonSintomasNerviosoAutonomo = Ext.getCmp('intHamiltonSintomasNerviosoAutonomo').getValue();
                                            Ext.getCmp('intHamiltonPuntajeTotal').setValue(pHamiltonEstadoAnimo + pHamiltonTension + pHamiltonMiedosTemores + pHamiltonInsomnio + pHamiltonFuncionesIntelectuales + pHamiltonEstadoAnimoDeprimido + pHamiltonSintomasSomativosMusculares + pHamiltonSintomasSomativosGenerales + pHamiltonSintomasCardiovasculares + pHamiltonSintomasRespiratorios + pHamiltonSintomasGastrointestinales + pHamiltonSintomasGenitourinariosSexuales + pHamiltonSintomasNerviosoAutonomo + pHamiltonComportamientoEntrevista)
                                        }
                                    }
                                }
                            },
                            {
                                html: '<br>'
                            },
                            {
                                html: 'Tenso, no relajado, agitacion nerviosa: manos, dedos cogidos, apretados, tics, enrollar el panuleo. Inquietud: va y viene. Temblor de animos. Comportamiento fisiologico'
                            },
                            {
                                xtype: 'combo',
                                name: 'Comportamiento en la entrevista',
                                fieldLabel: 'Comportamiento en la entrevista',
                                width: 400,
                                allowBlank: false,
                                store: stHamilton,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'intHamiltonComportamientoEntrevista',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        if(pNew == null || pNew == ''){
                                            pHamiltonComportamientoEntrevista = 0;        
                                            Ext.getCmp('intHamiltonPuntajeTotal').setValue(pHamiltonEstadoAnimo + pHamiltonTension + pHamiltonMiedosTemores + pHamiltonInsomnio + pHamiltonFuncionesIntelectuales + pHamiltonEstadoAnimoDeprimido + pHamiltonSintomasSomativosMusculares + pHamiltonSintomasSomativosGenerales + pHamiltonSintomasCardiovasculares + pHamiltonSintomasRespiratorios + pHamiltonSintomasGastrointestinales + pHamiltonSintomasGenitourinariosSexuales + pHamiltonSintomasNerviosoAutonomo + pHamiltonComportamientoEntrevista)
                                        }else{
                                            pHamiltonComportamientoEntrevista = Ext.getCmp('intHamiltonComportamientoEntrevista').getValue();
                                            Ext.getCmp('intHamiltonPuntajeTotal').setValue(pHamiltonEstadoAnimo + pHamiltonTension + pHamiltonMiedosTemores + pHamiltonInsomnio + pHamiltonFuncionesIntelectuales + pHamiltonEstadoAnimoDeprimido + pHamiltonSintomasSomativosMusculares + pHamiltonSintomasSomativosGenerales + pHamiltonSintomasCardiovasculares + pHamiltonSintomasRespiratorios + pHamiltonSintomasGastrointestinales + pHamiltonSintomasGenitourinariosSexuales + pHamiltonSintomasNerviosoAutonomo + pHamiltonComportamientoEntrevista)
                                        }
                                    }
                                }
                            },
                            {
                                html: '<br><hr><br>'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'Puntaje Total',
                                fieldLabel: 'Puntaje Total',
                                width: 50,
                                minValue: 0,
                                decimalPrecision: 0,
                                allowBlank: false,
                                value: 0,
                                id: 'intHamiltonPuntajeTotal'
                            }
                        ]
                    }
                ]
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                var frm = Ext.getCmp('frmEscalaAnsiedad').getForm();
                frm.doAction('load', {
                    url: '../../controlador/clinicacaidas/controlador_clinicacaidas.php',
                    waitMsg: 'Cargando Información...',
                    params:{
                        pConsecutivoHC: wConsecutivoHC,
                        task: 'LOAD_TEST_007'
                    },
                    success:function(form, action) {
                        //CargarDataHCUltimaAtencion(action.result.data.sysEvolucion);
                    }
                });
            }}
        });
        fsEscalaAnsiedadUi.superclass.initComponent.call(this);
    }
});


function calculoEscalaHamilton(){
    if(Ext.getCmp('strTensoAnsioso').getValue() == "SI" && Ext.getCmp('strPreocupacion').getValue() == "SI" ){
        Ext.getCmp('fsEscalaHamilton').setVisible(true);
    }else{
        Ext.getCmp('fsEscalaHamilton').setVisible(false);
    }
}

function fnGuaradarTest007(){
    var frm = Ext.getCmp('frmEscalaAnsiedad').getForm();
    if (frm.isValid()){
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: '../../controlador/clinicacaidas/controlador_clinicacaidas.php',
            params:{
                task: 'GUARDAR_TEST_007',
                pConsecutivoHC: wConsecutivoHC,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}