/*
* @category    Fieldset ABC SOCIAL
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsEjecucionFisicaUi = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    title: 'EJECUCION FISICA (SPPB)',
    collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    titleCollapse: true,
    padding: 0,
    id: 'fsEjecucionFisica',
    initComponent: function() {
        
        var dataEquilibrioPiesJuntos = [
            ['Mantiene 10 seg'],
            ['No mantiene 10 seg'],
            ['No lo Intenta']
        ];
        var stEquilibrioPiesJuntos = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stEquilibrioPiesJuntos.loadData(dataEquilibrioPiesJuntos);
               
        
        var dataEquilibrioSemitandem = [
            ['Mantiene 10 seg'],
            ['no mantiene 10 seg'],
            ['No lo Intenta']
        ];
        var stEquilibrioSemitandem = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stEquilibrioSemitandem.loadData(dataEquilibrioSemitandem);
               
        
        var dataIncorporarseSilla = [
            ['Incapaz de completar 5 o lo completa en > 60seg'],
            ['16,70 seg o mas'],
            ['13,70 seg a 16,69 seg'],
            ['11,20 seg a 13,69 seg'],
            ['11,19 seg o menos']
        ];
        var stIncorporarseSilla = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stIncorporarseSilla.loadData(dataIncorporarseSilla);
               
        
        var dataEquilibrioTandem = [
            ['Mantiene 10 seg'],
            ['Mantiene 3 - 9,99 seg'],
            ['no mantiene 10 seg'],
            ['No lo Intenta']
        ];
        var stEquilibrioTandem = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stEquilibrioTandem.loadData(dataEquilibrioTandem);
               
        this.bbar = [
            {
                xtype: 'tbfill'
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Guardar Test',
                iconCls: 'btnGuardar',
                listeners:{
                    click : function(){
                        fnGuaradarTest008();
                    }
                }
            },
            {
                xtype: 'tbseparator'
            }
        ];
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAnexo8EjecucionFisica',
                padding: 10,
                border: false,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'fieldset',
                        title: 'PRUEBA DE EQUILIBRIO',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        labelWidth: 90,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsPruebaEquilibrio',
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'Pies Juntos',
                                        fieldLabel: 'Pies Juntos',
                                        width: 150,
                                        allowBlank: true,
                                        store: stEquilibrioPiesJuntos,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strAnexo8EquilibrioPiesJuntos',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                CalificarSPPB();
                                            }
                                        }
                                    },
                                    {
                                        html: 'Semitandem:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Semitandem',
                                        width: 150,
                                        allowBlank: true,
                                        store: stEquilibrioSemitandem,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strAnexo8EquilibrioSemitandem',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                CalificarSPPB();
                                            }
                                        }
                                    },
                                    {
                                        html: 'Tandem:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Tandem',
                                        width: 150,
                                        allowBlank: true,
                                        store: stEquilibrioTandem,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strAnexo8EquilibrioTandem',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                CalificarSPPB();
                                            }
                                        }
                                    },
                                    {
                                        html: 'Puntaje:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Puntaje Prueba Equilibrio',
                                        width: 50,
                                        minValue: 0,
                                        decimalPrecision: 0,
                                        readOnly: true,
                                        allowBlank: true,
                                        value: 0,
                                        id: 'intAnexo8PuntajePruebaEquilibrio'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'PRUEBA DE VELOCIDAD DE LA MARCHA',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        labelWidth: 90,
                        autoHeight: true,
                        padding: 5,
                        id: 'fsVelocidadMarcha',
                        items: [
                            {
                                xtype: 'panel',
                                layout: 'form',
                                anchor: '100%',
                                labelWidth: 180,
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'checkbox',
                                        fieldLabel: 'Distancia Cuatro Metros',
                                        name: 'Distancia Cuatro Metros',
                                        anchor: '100%',
                                        value: 'true',
                                        id: 'bolAnexo8DistanciaCuatroMetros'
                                    }
                                ]
                            },
                            {
                                html: '<br>'
                            },
                            {
                                html: 'Tiempo para recorrer 4 Metros'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo para recorrer 4 Metros Primera Prueba',
                                        fieldLabel: 'Primera Prueba',
                                        emptyText: '___,___seg',
                                        width: 60,
                                        decimalPrecision: 2,
                                        allowBlank: true,
                                        id: 'intAnexo8TiempoPrimeraPrueba',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                CalificarSPPB();
                                            }
                                        }
                                    },
                                    {
                                        html: 'Segunda Prueba'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo para recorrer 4 Metros Segunda Prueba',
                                        emptyText: '___,___seg',
                                        width: 60,
                                        decimalPrecision: 2,
                                        allowBlank: true,
                                        id: 'intAnexo8TiempoSegundaPrueba',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                CalificarSPPB();
                                            }
                                        }
                                    },
                                    {
                                        html: 'Mejor Tiempo:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Mejor Tiempo',
                                        emptyText: '___,___seg',
                                        width: 60,
                                        decimalPrecision: 2,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'intAnexo8TiempoMejorPrueba'
                                    },
                                    {
                                        html: 'Puntaje Velocidad de la Marcha:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Puntaje Velocidad de la Marcha',
                                        readOnly: true,
                                        width: 50,
                                        minValue: 0,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        value: 0,
                                        id: 'intAnexo8PuntajeVelocidadMarcha'
                                    }
                                ]
                            },
                            {
                                html: '<br>'
                            },
                            {
                                html: 'Ayudas para caminar:'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'checkbox',
                                        fieldLabel: 'Ninguno',
                                        name: 'Ninguno',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolAnexo8AyudaNinguno'
                                    },
                                    {
                                        html: 'Baston'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        name: 'Baston',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolAnexo8AyudaBaston'
                                    },
                                    {
                                        html: 'Otra'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        name: 'Otra',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolAnexo8AyudaOtra'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'PRUEBA DE INCORPORARSE DE LA SILLA',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        height: 120,
                        padding: 5,
                        items: [
                            {
                                html: 'Incorporarse de forma repetida 5 veces.'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Se cuenta cuando se sienta',
                                        name: 'Incorporarse de forma repetida 5 veces',
                                        width: 350,
                                        height: 200,
                                        allowBlank: true,
                                        store: stIncorporarseSilla,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strAnexo8IncorporarseSilla',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                CalificarSPPB();
                                            }
                                        }
                                    },
                                    {
                                        html: 'Puntaje Incorporarse de la Silla'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Puntaje Incorporarse de la Silla',
                                        width: 50,
                                        minValue: 0,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        readOnly: true,
                                        value: 0,
                                        id: 'intAnexo8PuntajeIncorporarseSilla'
                                    }
                                ]
                            }
                        ]
                    },      
                    {
                        html: '<br><hr><br>'
                    },
                    {
                        xtype: 'numberfield',
                        name: 'Puntaje Total',
                        fieldLabel: 'Puntaje Total',
                        width: 50,
                        minValue: 0,
                        decimalPrecision: 0,
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'intAnexo8PuntajeTotal'
                    }
                ]
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                var frm = Ext.getCmp('frmAnexo8EjecucionFisica').getForm();
                frm.doAction('load', {
                    url: '../../controlador/clinicacaidas/controlador_clinicacaidas.php',
                    waitMsg: 'Cargando Información...',
                    params:{
                        pConsecutivoHC: wConsecutivoHC,
                        task: 'LOAD_TEST_008'
                    },
                    success:function(form, action) {
                        //CargarDataHCUltimaAtencion(action.result.data.sysEvolucion);
                    }
                });
            }}
        });
        fsEjecucionFisicaUi.superclass.initComponent.call(this);
    }
});

function fnGuaradarTest008(){
    var frm = Ext.getCmp('frmAnexo8EjecucionFisica').getForm();
    if (frm.isValid()){
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: '../../controlador/clinicacaidas/controlador_clinicacaidas.php',
            params:{
                task: 'GUARDAR_TEST_008',
                pConsecutivoHC: wConsecutivoHC,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function CalificarSPPB(){
    var pEquilibrioPiesJuntos = 0;
    var pEquilibrioSemitandem = 0;
    var pEquilibrioTandem = 0;
    var pIncorporarseSilla = 0;
    if(Ext.getCmp('intAnexo8TiempoPrimeraPrueba').getValue() === "" || Ext.getCmp('intAnexo8TiempoPrimeraPrueba').getValue() === null || parseFloat(Ext.getCmp('intAnexo8TiempoPrimeraPrueba').getValue()) === 0){
        Ext.getCmp('intAnexo8TiempoPrimeraPrueba').setValue(0);
        Ext.getCmp('intAnexo8TiempoMejorPrueba').setValue(0);
        Ext.getCmp('intAnexo8PuntajeVelocidadMarcha').setValue(0);
    }
    if(Ext.getCmp('intAnexo8TiempoSegundaPrueba').getValue() === "" || Ext.getCmp('intAnexo8TiempoSegundaPrueba').getValue() === null || parseFloat(Ext.getCmp('intAnexo8TiempoSegundaPrueba').getValue()) === 0){
        Ext.getCmp('intAnexo8TiempoSegundaPrueba').setValue(0);
        Ext.getCmp('intAnexo8TiempoMejorPrueba').setValue(0);
        Ext.getCmp('intAnexo8PuntajeVelocidadMarcha').setValue(0);
    }
    if(parseFloat(Ext.getCmp('intAnexo8TiempoPrimeraPrueba').getValue()) < parseFloat(Ext.getCmp('intAnexo8TiempoSegundaPrueba').getValue())){
        Ext.getCmp('intAnexo8TiempoMejorPrueba').setValue(Ext.getCmp('intAnexo8TiempoPrimeraPrueba').getValue());
    }else{
        Ext.getCmp('intAnexo8TiempoMejorPrueba').setValue(Ext.getCmp('intAnexo8TiempoSegundaPrueba').getValue());
    }
    Ext.getCmp('intAnexo8PuntajeVelocidadMarcha').setValue(0);
    if(Ext.getCmp('bolAnexo8DistanciaCuatroMetros').getValue() === true){
        if(parseFloat(Ext.getCmp('intAnexo8TiempoMejorPrueba').getValue()) < 4.82 ){
            Ext.getCmp('intAnexo8PuntajeVelocidadMarcha').setValue(4);
        }else{
            if(parseFloat(Ext.getCmp('intAnexo8TiempoMejorPrueba').getValue()) < 6.21 ){
                Ext.getCmp('intAnexo8PuntajeVelocidadMarcha').setValue(3);
            }else{
                if(parseFloat(Ext.getCmp('intAnexo8TiempoMejorPrueba').getValue()) < 8.71 ){
                    Ext.getCmp('intAnexo8PuntajeVelocidadMarcha').setValue(2);
                }else{
                    Ext.getCmp('intAnexo8PuntajeVelocidadMarcha').setValue(1);
                }
            }
        }
    }
    pEquilibrioPiesJuntos = 0;
    if(Ext.getCmp('strAnexo8EquilibrioPiesJuntos').getValue() === 'Mantiene 10 seg' ){
        pEquilibrioPiesJuntos = 1;
    }
    pEquilibrioSemitandem = 0;
    if(Ext.getCmp('strAnexo8EquilibrioSemitandem').getValue() === 'Mantiene 10 seg' ){
        pEquilibrioSemitandem = 1;
    }
    pEquilibrioTandem = 0;
    if(Ext.getCmp('strAnexo8EquilibrioTandem').getValue() === 'Mantiene 10 seg' ){
        pEquilibrioTandem = 2;
    }else{
        if(Ext.getCmp('strAnexo8EquilibrioTandem').getValue() === 'Mantiene 3 - 9,99 seg' ){
            pEquilibrioTandem = 1;
        }
    }
    Ext.getCmp('intAnexo8PuntajePruebaEquilibrio').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem);
    if(Ext.getCmp('strAnexo8IncorporarseSilla').getValue() === 'Incapaz de completar 5 o lo completa en > 60seg'){
        pIncorporarseSilla = 0;
    }else{
        if(Ext.getCmp('strAnexo8IncorporarseSilla').getValue() === '16,70 seg o mas'){
            pIncorporarseSilla = 1;
        }else{
            if(Ext.getCmp('strAnexo8IncorporarseSilla').getValue() === '13,70 seg a 16,69 seg'){
                pIncorporarseSilla = 2;
            }else{
                if(Ext.getCmp('strAnexo8IncorporarseSilla').getValue() === '11,20 seg a 13,69 seg'){
                    pIncorporarseSilla = 3;
                }else{
                    if(Ext.getCmp('strAnexo8IncorporarseSilla').getValue() === '11,19 seg o menos'){
                        pIncorporarseSilla = 4;
                    }else{
                        pIncorporarseSilla = 0;
                    }
                }
            }
        }
    }
    Ext.getCmp('intAnexo8PuntajeIncorporarseSilla').setValue(pIncorporarseSilla);
    Ext.getCmp('intAnexo8PuntajeTotal').setValue(parseInt(Ext.getCmp('intAnexo8PuntajePruebaEquilibrio').getValue()) + parseInt(Ext.getCmp('intAnexo8PuntajeVelocidadMarcha').getValue()) + parseInt(Ext.getCmp('intAnexo8PuntajeIncorporarseSilla').getValue()));
}