/*
* @category    Fieldset ESCALA AUTOEFICACIA RELACIONADA CON CAIDAS
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsValoracionCognoscitivaUi = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    title: 'VALORACION COGNOSCITIVA',
    collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    titleCollapse: true,
    padding: 0,
    labelWidth: 200,
    id: 'fsDepresionGeriatrica',
    initComponent: function() {
        
        var OrientacionAnio = 0;
        var OrientacionMes = 0;
        var OrientacionDia = 0;
        var OrientacionDiaSemana = 0;
        var OrientacionHora = 0;
        var OrientacionPais = 0;
        var OrientacionDepartamento = 0;
        var OrientacionCiudad = 0;
        var OrientacionBarrio = 0;
        var OrientacionLugar = 0;
        var RepitePrimeraPalabra = 0;
        var RepiteSegundaPalabra = 0;
        var RepiteTerceraPalabra = 0;
        var PrimeraRespuestaCorrecta = 0;
        var SegundaRespuestaCorrecta = 0;
        var TerceraRespuestaCorrecta = 0;
        var CuartaRespuestaCorrecta = 0;
        var QuintaRespuestaCorrecta = 0;
        var NroPalabrasRecuerda = 0;
        var DenominarObjeto1 = 0;
        var DenominarObjeto2 = 0;
        var RepiteFrase = 0;
        var ComprensionEtapaUno = 0;
        var ComprensionEtapaDos = 0;
        var ComprensionEtapaTres = 0;
        var ObedeceCierraOjos = 0;
        var ObedeceEscribaFrase = 0;
        var ObedeceCopieDibujo = 0;
        
        this.tbar = [
            {
                xtype: 'tbfill'
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Guardar Test',
                iconCls: 'btnGuardar',
                listeners:{
                    click : function(){
                        alert("Guardar Test");
                    }
                }
            },
            {
                xtype: 'tbseparator'
            }
        ];
        this.items = [
            {
                html: '<br>'
            },
            {
                xtype: 'fieldset',
                title: 'ORIENTACION',
                layout: 'form',
                labelWidth: 270,
                collapsible: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 7,
                items: [
                    {
                        xtype: 'checkbox',
                        fieldLabel: 'Diga en que <b>Año</b> nos encontramos',
                        name: 'Diga en que Año nos encontramos',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolOrientacionAnio',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew === true || pNew === "true"){
                                    OrientacionAnio = 1;
                                }else{
                                    OrientacionAnio = 0;
                                }
                                CalcularTest005(OrientacionAnio,OrientacionMes, OrientacionDia, OrientacionDiaSemana, OrientacionHora, OrientacionPais, OrientacionDepartamento, OrientacionCiudad, OrientacionBarrio, OrientacionLugar, RepitePrimeraPalabra, RepiteSegundaPalabra, RepiteTerceraPalabra, PrimeraRespuestaCorrecta, SegundaRespuestaCorrecta, TerceraRespuestaCorrecta, CuartaRespuestaCorrecta, QuintaRespuestaCorrecta, NroPalabrasRecuerda, DenominarObjeto1, DenominarObjeto2, RepiteFrase, ComprensionEtapaUno, ComprensionEtapaDos, ComprensionEtapaTres, ObedeceCierraOjos, ObedeceEscribaFrase, ObedeceCopieDibujo);
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: 'Diga en que <b>Mes</b> nos encontramos',
                        name: 'Diga en que Mes nos encontramos',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolOrientacionMes',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew === true || pNew === "true"){
                                    OrientacionMes = 1;
                                }else{
                                    OrientacionMes = 0;
                                }
                                CalcularTest005(OrientacionAnio,OrientacionMes, OrientacionDia, OrientacionDiaSemana, OrientacionHora, OrientacionPais, OrientacionDepartamento, OrientacionCiudad, OrientacionBarrio, OrientacionLugar, RepitePrimeraPalabra, RepiteSegundaPalabra, RepiteTerceraPalabra, PrimeraRespuestaCorrecta, SegundaRespuestaCorrecta, TerceraRespuestaCorrecta, CuartaRespuestaCorrecta, QuintaRespuestaCorrecta, NroPalabrasRecuerda, DenominarObjeto1, DenominarObjeto2, RepiteFrase, ComprensionEtapaUno, ComprensionEtapaDos, ComprensionEtapaTres, ObedeceCierraOjos, ObedeceEscribaFrase, ObedeceCopieDibujo);
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: 'Diga en que <b>Dia</b> nos encontramos',
                        name: 'Diga en que Dia nos encontramos',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolOrientacionDia',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew === true || pNew === "true"){
                                    OrientacionDia = 1;
                                }else{
                                    OrientacionDia = 0;
                                }
                                CalcularTest005(OrientacionAnio,OrientacionMes, OrientacionDia, OrientacionDiaSemana, OrientacionHora, OrientacionPais, OrientacionDepartamento, OrientacionCiudad, OrientacionBarrio, OrientacionLugar, RepitePrimeraPalabra, RepiteSegundaPalabra, RepiteTerceraPalabra, PrimeraRespuestaCorrecta, SegundaRespuestaCorrecta, TerceraRespuestaCorrecta, CuartaRespuestaCorrecta, QuintaRespuestaCorrecta, NroPalabrasRecuerda, DenominarObjeto1, DenominarObjeto2, RepiteFrase, ComprensionEtapaUno, ComprensionEtapaDos, ComprensionEtapaTres, ObedeceCierraOjos, ObedeceEscribaFrase, ObedeceCopieDibujo);
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: 'Diga en que <b>Dia/Semana</b> nos encontramos',
                        name: 'Diga en que Dia/Semana nos encontramos',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolOrientacionDiaSemana',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew === true || pNew === "true"){
                                    OrientacionDiaSemana = 1;
                                }else{
                                    OrientacionDiaSemana = 0;
                                }
                                CalcularTest005(OrientacionAnio,OrientacionMes, OrientacionDia, OrientacionDiaSemana, OrientacionHora, OrientacionPais, OrientacionDepartamento, OrientacionCiudad, OrientacionBarrio, OrientacionLugar, RepitePrimeraPalabra, RepiteSegundaPalabra, RepiteTerceraPalabra, PrimeraRespuestaCorrecta, SegundaRespuestaCorrecta, TerceraRespuestaCorrecta, CuartaRespuestaCorrecta, QuintaRespuestaCorrecta, NroPalabrasRecuerda, DenominarObjeto1, DenominarObjeto2, RepiteFrase, ComprensionEtapaUno, ComprensionEtapaDos, ComprensionEtapaTres, ObedeceCierraOjos, ObedeceEscribaFrase, ObedeceCopieDibujo);
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: 'Diga en que <b>Hora (mañana - tarde - noche)</b> nos encontramos',
                        name: 'Diga en que Hora (mañana - tarde - noche) nos encontramos',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolOrientacionHora',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew === true || pNew === "true"){
                                    OrientacionHora = 1;
                                }else{
                                    OrientacionHora = 0;
                                }
                                CalcularTest005(OrientacionAnio,OrientacionMes, OrientacionDia, OrientacionDiaSemana, OrientacionHora, OrientacionPais, OrientacionDepartamento, OrientacionCiudad, OrientacionBarrio, OrientacionLugar, RepitePrimeraPalabra, RepiteSegundaPalabra, RepiteTerceraPalabra, PrimeraRespuestaCorrecta, SegundaRespuestaCorrecta, TerceraRespuestaCorrecta, CuartaRespuestaCorrecta, QuintaRespuestaCorrecta, NroPalabrasRecuerda, DenominarObjeto1, DenominarObjeto2, RepiteFrase, ComprensionEtapaUno, ComprensionEtapaDos, ComprensionEtapaTres, ObedeceCierraOjos, ObedeceEscribaFrase, ObedeceCopieDibujo);
                            }
                        }
                    },
                    {
                        html: '<br><hr><br>'
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: 'En que <b>Pais</b> nos encontramos',
                        name: 'En que Pais nos encontramos',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolOrientacionPais',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew === true || pNew === "true"){
                                    OrientacionPais = 1;
                                }else{
                                    OrientacionPais = 0;
                                }
                                CalcularTest005(OrientacionAnio,OrientacionMes, OrientacionDia, OrientacionDiaSemana, OrientacionHora, OrientacionPais, OrientacionDepartamento, OrientacionCiudad, OrientacionBarrio, OrientacionLugar, RepitePrimeraPalabra, RepiteSegundaPalabra, RepiteTerceraPalabra, PrimeraRespuestaCorrecta, SegundaRespuestaCorrecta, TerceraRespuestaCorrecta, CuartaRespuestaCorrecta, QuintaRespuestaCorrecta, NroPalabrasRecuerda, DenominarObjeto1, DenominarObjeto2, RepiteFrase, ComprensionEtapaUno, ComprensionEtapaDos, ComprensionEtapaTres, ObedeceCierraOjos, ObedeceEscribaFrase, ObedeceCopieDibujo);
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: 'En que <b>Departamento</b> nos encontramos',
                        name: 'En que Departamento nos encontramos',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolOrientacionDepartamento',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew === true || pNew === "true"){
                                    OrientacionDepartamento = 1;
                                }else{
                                    OrientacionDepartamento = 0;
                                }
                                CalcularTest005(OrientacionAnio,OrientacionMes, OrientacionDia, OrientacionDiaSemana, OrientacionHora, OrientacionPais, OrientacionDepartamento, OrientacionCiudad, OrientacionBarrio, OrientacionLugar, RepitePrimeraPalabra, RepiteSegundaPalabra, RepiteTerceraPalabra, PrimeraRespuestaCorrecta, SegundaRespuestaCorrecta, TerceraRespuestaCorrecta, CuartaRespuestaCorrecta, QuintaRespuestaCorrecta, NroPalabrasRecuerda, DenominarObjeto1, DenominarObjeto2, RepiteFrase, ComprensionEtapaUno, ComprensionEtapaDos, ComprensionEtapaTres, ObedeceCierraOjos, ObedeceEscribaFrase, ObedeceCopieDibujo);
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: 'En que <b>Ciudad</b> nos encontramos',
                        name: 'En que Ciudad nos encontramos',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolOrientacionCiudad',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew === true || pNew === "true"){
                                    OrientacionCiudad = 1;
                                }else{
                                    OrientacionCiudad = 0;
                                }
                                CalcularTest005(OrientacionAnio,OrientacionMes, OrientacionDia, OrientacionDiaSemana, OrientacionHora, OrientacionPais, OrientacionDepartamento, OrientacionCiudad, OrientacionBarrio, OrientacionLugar, RepitePrimeraPalabra, RepiteSegundaPalabra, RepiteTerceraPalabra, PrimeraRespuestaCorrecta, SegundaRespuestaCorrecta, TerceraRespuestaCorrecta, CuartaRespuestaCorrecta, QuintaRespuestaCorrecta, NroPalabrasRecuerda, DenominarObjeto1, DenominarObjeto2, RepiteFrase, ComprensionEtapaUno, ComprensionEtapaDos, ComprensionEtapaTres, ObedeceCierraOjos, ObedeceEscribaFrase, ObedeceCopieDibujo);
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: 'En que <b>Barrio/Vereda</b> nos encontramos',
                        name: 'En que Barrio/Vereda nos encontramos',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolOrientacionBarrio',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew === true || pNew === "true"){
                                    OrientacionBarrio = 1;
                                }else{
                                    OrientacionBarrio = 0;
                                }
                                CalcularTest005(OrientacionAnio,OrientacionMes, OrientacionDia, OrientacionDiaSemana, OrientacionHora, OrientacionPais, OrientacionDepartamento, OrientacionCiudad, OrientacionBarrio, OrientacionLugar, RepitePrimeraPalabra, RepiteSegundaPalabra, RepiteTerceraPalabra, PrimeraRespuestaCorrecta, SegundaRespuestaCorrecta, TerceraRespuestaCorrecta, CuartaRespuestaCorrecta, QuintaRespuestaCorrecta, NroPalabrasRecuerda, DenominarObjeto1, DenominarObjeto2, RepiteFrase, ComprensionEtapaUno, ComprensionEtapaDos, ComprensionEtapaTres, ObedeceCierraOjos, ObedeceEscribaFrase, ObedeceCopieDibujo);
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        fieldLabel: 'En que <b>Lugar/Sitio</b> nos encontramos',
                        name: 'En que Lugar/Sitio nos encontramos',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolOrientacionLugar',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew === true || pNew === "true"){
                                    OrientacionLugar = 1;
                                }else{
                                    OrientacionLugar = 0;
                                }
                                CalcularTest005(OrientacionAnio,OrientacionMes, OrientacionDia, OrientacionDiaSemana, OrientacionHora, OrientacionPais, OrientacionDepartamento, OrientacionCiudad, OrientacionBarrio, OrientacionLugar, RepitePrimeraPalabra, RepiteSegundaPalabra, RepiteTerceraPalabra, PrimeraRespuestaCorrecta, SegundaRespuestaCorrecta, TerceraRespuestaCorrecta, CuartaRespuestaCorrecta, QuintaRespuestaCorrecta, NroPalabrasRecuerda, DenominarObjeto1, DenominarObjeto2, RepiteFrase, ComprensionEtapaUno, ComprensionEtapaDos, ComprensionEtapaTres, ObedeceCierraOjos, ObedeceEscribaFrase, ObedeceCopieDibujo);
                            }
                        }
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'MEMORIA',
                layout: 'form',
                labelWidth: 200,
                collapsible: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 7,
                items: [
                    {
                        html: 'Diga tres Nombre: casa, mesa, arbol. Un segundo para cada uno. Luego pida al paciente que los repita. Un punto por cada una. Repitalos hasta que el paciente los registre. Anote el numero de ensayos requeridos.'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                name: 'Primera Palabra',
                                fieldLabel: 'Primera Palabra',
                                width: 150,
                                allowBlank: true,
                                id: 'strPrimeraPalabra'
                            },
                            {
                                xtype: 'checkbox',
                                name: 'Repite Primera Palabra',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolRepitePrimeraPalabra',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        if(pNew === true || pNew === "true"){
                                            RepitePrimeraPalabra = 1;
                                        }else{
                                            RepitePrimeraPalabra = 0;
                                        }
                                        CalcularTest005(OrientacionAnio,OrientacionMes, OrientacionDia, OrientacionDiaSemana, OrientacionHora, OrientacionPais, OrientacionDepartamento, OrientacionCiudad, OrientacionBarrio, OrientacionLugar, RepitePrimeraPalabra, RepiteSegundaPalabra, RepiteTerceraPalabra, PrimeraRespuestaCorrecta, SegundaRespuestaCorrecta, TerceraRespuestaCorrecta, CuartaRespuestaCorrecta, QuintaRespuestaCorrecta, NroPalabrasRecuerda, DenominarObjeto1, DenominarObjeto2, RepiteFrase, ComprensionEtapaUno, ComprensionEtapaDos, ComprensionEtapaTres, ObedeceCierraOjos, ObedeceEscribaFrase, ObedeceCopieDibujo);
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                name: 'Segunda Palabra',
                                fieldLabel: 'Segunda Palabra',
                                width: 150,
                                allowBlank: true,
                                id: 'strSegundaPalabra'
                            },
                            {
                                xtype: 'checkbox',
                                name: 'Repite Segunda Palabra',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolRepiteSegundaPalabra',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        if(pNew === true || pNew === "true"){
                                            RepiteSegundaPalabra = 1;
                                        }else{
                                            RepiteSegundaPalabra = 0;
                                        }
                                        CalcularTest005(OrientacionAnio,OrientacionMes, OrientacionDia, OrientacionDiaSemana, OrientacionHora, OrientacionPais, OrientacionDepartamento, OrientacionCiudad, OrientacionBarrio, OrientacionLugar, RepitePrimeraPalabra, RepiteSegundaPalabra, RepiteTerceraPalabra, PrimeraRespuestaCorrecta, SegundaRespuestaCorrecta, TerceraRespuestaCorrecta, CuartaRespuestaCorrecta, QuintaRespuestaCorrecta, NroPalabrasRecuerda, DenominarObjeto1, DenominarObjeto2, RepiteFrase, ComprensionEtapaUno, ComprensionEtapaDos, ComprensionEtapaTres, ObedeceCierraOjos, ObedeceEscribaFrase, ObedeceCopieDibujo);
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                name: 'Tercera Palabra',
                                fieldLabel: 'Tercera Palabra',
                                width: 150,
                                allowBlank: true,
                                id: 'strTerceraPalabra'
                            },
                            {
                                xtype: 'checkbox',
                                name: 'Repite Tercera Palabra',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolRepiteTerceraPalabra',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        if(pNew === true || pNew === "true"){
                                            RepiteTerceraPalabra = 1;
                                        }else{
                                            RepiteTerceraPalabra = 0;
                                        }
                                        CalcularTest005(OrientacionAnio,OrientacionMes, OrientacionDia, OrientacionDiaSemana, OrientacionHora, OrientacionPais, OrientacionDepartamento, OrientacionCiudad, OrientacionBarrio, OrientacionLugar, RepitePrimeraPalabra, RepiteSegundaPalabra, RepiteTerceraPalabra, PrimeraRespuestaCorrecta, SegundaRespuestaCorrecta, TerceraRespuestaCorrecta, CuartaRespuestaCorrecta, QuintaRespuestaCorrecta, NroPalabrasRecuerda, DenominarObjeto1, DenominarObjeto2, RepiteFrase, ComprensionEtapaUno, ComprensionEtapaDos, ComprensionEtapaTres, ObedeceCierraOjos, ObedeceEscribaFrase, ObedeceCopieDibujo);
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'numberfield',
                        name: 'Numero Repeticiones',
                        fieldLabel: 'Numero Repeticiones',
                        width: 50,
                        value: 0,
                        id: 'intNumeroRepeticiones'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'ATENCION Y CALCULO',
                layout: 'form',
                labelWidth: 200,
                collapsible: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 7,
                items: [
                    {
                        html: 'Restar del 100 - 7 en forma sucesiva. Pare a la quinta respuesta. Registre un punto por cada respuesta correcta.(93 - 86 - 79 - 72 - 65)'
                    },
                    {
                        html: '<br>'
                    },
                    {
                        html: 'Decir los meses del año al reves. Pare a la quinta respuesta. Registre un punto por cada respuesta correcta. (Diciembre - Noviembre - Octubre - Septiembre - Agosto)'
                    },
                    {
                        html: '<br>'
                    },
                    {
                        xtype: 'checkbox',
                        name: 'Primera Respuesta Correcta',
                        fieldLabel: 'Primera Respuesta Correcta',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolPrimeraRespuestaCorrecta',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew === true || pNew === "true"){
                                    PrimeraRespuestaCorrecta = 1;
                                }else{
                                    PrimeraRespuestaCorrecta = 0;
                                }
                                CalcularTest005(OrientacionAnio,OrientacionMes, OrientacionDia, OrientacionDiaSemana, OrientacionHora, OrientacionPais, OrientacionDepartamento, OrientacionCiudad, OrientacionBarrio, OrientacionLugar, RepitePrimeraPalabra, RepiteSegundaPalabra, RepiteTerceraPalabra, PrimeraRespuestaCorrecta, SegundaRespuestaCorrecta, TerceraRespuestaCorrecta, CuartaRespuestaCorrecta, QuintaRespuestaCorrecta, NroPalabrasRecuerda, DenominarObjeto1, DenominarObjeto2, RepiteFrase, ComprensionEtapaUno, ComprensionEtapaDos, ComprensionEtapaTres, ObedeceCierraOjos, ObedeceEscribaFrase, ObedeceCopieDibujo);
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        name: 'Segunda Respuesta Correcta',
                        fieldLabel: 'Segunda Respuesta Correcta',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolSegundaRespuestaCorrecta',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew === true || pNew === "true"){
                                    SegundaRespuestaCorrecta = 1;
                                }else{
                                    SegundaRespuestaCorrecta = 0;
                                }
                                CalcularTest005(OrientacionAnio,OrientacionMes, OrientacionDia, OrientacionDiaSemana, OrientacionHora, OrientacionPais, OrientacionDepartamento, OrientacionCiudad, OrientacionBarrio, OrientacionLugar, RepitePrimeraPalabra, RepiteSegundaPalabra, RepiteTerceraPalabra, PrimeraRespuestaCorrecta, SegundaRespuestaCorrecta, TerceraRespuestaCorrecta, CuartaRespuestaCorrecta, QuintaRespuestaCorrecta, NroPalabrasRecuerda, DenominarObjeto1, DenominarObjeto2, RepiteFrase, ComprensionEtapaUno, ComprensionEtapaDos, ComprensionEtapaTres, ObedeceCierraOjos, ObedeceEscribaFrase, ObedeceCopieDibujo);
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        name: 'Tercera Respuesta Correcta',
                        fieldLabel: 'Tercera Respuesta Correcta',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolTerceraRespuestaCorrecta',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew === true || pNew === "true"){
                                    TerceraRespuestaCorrecta = 1;
                                }else{
                                    TerceraRespuestaCorrecta = 0;
                                }
                                CalcularTest005(OrientacionAnio,OrientacionMes, OrientacionDia, OrientacionDiaSemana, OrientacionHora, OrientacionPais, OrientacionDepartamento, OrientacionCiudad, OrientacionBarrio, OrientacionLugar, RepitePrimeraPalabra, RepiteSegundaPalabra, RepiteTerceraPalabra, PrimeraRespuestaCorrecta, SegundaRespuestaCorrecta, TerceraRespuestaCorrecta, CuartaRespuestaCorrecta, QuintaRespuestaCorrecta, NroPalabrasRecuerda, DenominarObjeto1, DenominarObjeto2, RepiteFrase, ComprensionEtapaUno, ComprensionEtapaDos, ComprensionEtapaTres, ObedeceCierraOjos, ObedeceEscribaFrase, ObedeceCopieDibujo);
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        name: 'Cuarta Respuesta Correcta',
                        fieldLabel: 'Cuarta Respuesta Correcta',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolCuartaRespuestaCorrecta',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew === true || pNew === "true"){
                                    CuartaRespuestaCorrecta = 1;
                                }else{
                                    CuartaRespuestaCorrecta = 0;
                                }
                                CalcularTest005(OrientacionAnio,OrientacionMes, OrientacionDia, OrientacionDiaSemana, OrientacionHora, OrientacionPais, OrientacionDepartamento, OrientacionCiudad, OrientacionBarrio, OrientacionLugar, RepitePrimeraPalabra, RepiteSegundaPalabra, RepiteTerceraPalabra, PrimeraRespuestaCorrecta, SegundaRespuestaCorrecta, TerceraRespuestaCorrecta, CuartaRespuestaCorrecta, QuintaRespuestaCorrecta, NroPalabrasRecuerda, DenominarObjeto1, DenominarObjeto2, RepiteFrase, ComprensionEtapaUno, ComprensionEtapaDos, ComprensionEtapaTres, ObedeceCierraOjos, ObedeceEscribaFrase, ObedeceCopieDibujo);
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        name: 'Quinta Respuesta Correcta',
                        fieldLabel: 'Quinta Respuesta Correcta',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolQuintaRespuestaCorrecta',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew === true || pNew === "true"){
                                    QuintaRespuestaCorrecta = 1;
                                }else{
                                    QuintaRespuestaCorrecta = 0;
                                }
                                CalcularTest005(OrientacionAnio,OrientacionMes, OrientacionDia, OrientacionDiaSemana, OrientacionHora, OrientacionPais, OrientacionDepartamento, OrientacionCiudad, OrientacionBarrio, OrientacionLugar, RepitePrimeraPalabra, RepiteSegundaPalabra, RepiteTerceraPalabra, PrimeraRespuestaCorrecta, SegundaRespuestaCorrecta, TerceraRespuestaCorrecta, CuartaRespuestaCorrecta, QuintaRespuestaCorrecta, NroPalabrasRecuerda, DenominarObjeto1, DenominarObjeto2, RepiteFrase, ComprensionEtapaUno, ComprensionEtapaDos, ComprensionEtapaTres, ObedeceCierraOjos, ObedeceEscribaFrase, ObedeceCopieDibujo);
                            }
                        }
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'EVOCACION',
                layout: 'form',
                labelWidth: 200,
                collapsible: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 7,
                items: [
                    {
                        html: 'Recuerde las tres palabras que le dijo antes.<br>'
                    },
                    {
                        xtype: 'numberfield',
                        fieldLabel: 'Numero de Palabras que Recuerda',
                        name: 'Numero de Palabras que Recuerda',
                        width: 40,
                        minValue: 0,
                        maxValue: 3,
                        decimalPrecision: 0,
                        allowBlank: true,
                        id: 'intPalabrasRecuerda',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew !== null || pNew !== ''){
                                    NroPalabrasRecuerda = pNew;
                                }else{
                                    NroPalabrasRecuerda = 0;
                                }
                                CalcularTest005(OrientacionAnio,OrientacionMes, OrientacionDia, OrientacionDiaSemana, OrientacionHora, OrientacionPais, OrientacionDepartamento, OrientacionCiudad, OrientacionBarrio, OrientacionLugar, RepitePrimeraPalabra, RepiteSegundaPalabra, RepiteTerceraPalabra, PrimeraRespuestaCorrecta, SegundaRespuestaCorrecta, TerceraRespuestaCorrecta, CuartaRespuestaCorrecta, QuintaRespuestaCorrecta, NroPalabrasRecuerda, DenominarObjeto1, DenominarObjeto2, RepiteFrase, ComprensionEtapaUno, ComprensionEtapaDos, ComprensionEtapaTres, ObedeceCierraOjos, ObedeceEscribaFrase, ObedeceCopieDibujo);
                            }
                        }
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'LENGUAJE',
                layout: 'form',
                labelWidth: 200,
                collapsible: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 7,
                items: [
                    {
                        html: 'Denominar dos Objetos.<br>'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                name: 'Primer Objeto',
                                fieldLabel: 'Primer Objeto',
                                width: 150,
                                allowBlank: true,
                                id: 'strPrimerObjeto'
                            },
                            {
                                xtype: 'checkbox',
                                name: 'Denominar Primer Objeto',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolDenominarObjetos1',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        if(pNew === true || pNew === "true"){
                                            DenominarObjeto1 = 1;
                                        }else{
                                            DenominarObjeto1 = 0;
                                        }
                                        CalcularTest005(OrientacionAnio,OrientacionMes, OrientacionDia, OrientacionDiaSemana, OrientacionHora, OrientacionPais, OrientacionDepartamento, OrientacionCiudad, OrientacionBarrio, OrientacionLugar, RepitePrimeraPalabra, RepiteSegundaPalabra, RepiteTerceraPalabra, PrimeraRespuestaCorrecta, SegundaRespuestaCorrecta, TerceraRespuestaCorrecta, CuartaRespuestaCorrecta, QuintaRespuestaCorrecta, NroPalabrasRecuerda, DenominarObjeto1, DenominarObjeto2, RepiteFrase, ComprensionEtapaUno, ComprensionEtapaDos, ComprensionEtapaTres, ObedeceCierraOjos, ObedeceEscribaFrase, ObedeceCopieDibujo);
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                name: 'Segundo Objeto',
                                fieldLabel: 'Segundo Objeto',
                                width: 150,
                                allowBlank: true,
                                id: 'strSegundoObjeto'
                            },
                            {
                                xtype: 'checkbox',
                                name: 'Denominar Segundo Objeto',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolDenominarObjetos2',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        if(pNew === true || pNew === "true"){
                                            DenominarObjeto2 = 1;
                                        }else{
                                            DenominarObjeto2 = 0;
                                        }
                                        CalcularTest005(OrientacionAnio,OrientacionMes, OrientacionDia, OrientacionDiaSemana, OrientacionHora, OrientacionPais, OrientacionDepartamento, OrientacionCiudad, OrientacionBarrio, OrientacionLugar, RepitePrimeraPalabra, RepiteSegundaPalabra, RepiteTerceraPalabra, PrimeraRespuestaCorrecta, SegundaRespuestaCorrecta, TerceraRespuestaCorrecta, CuartaRespuestaCorrecta, QuintaRespuestaCorrecta, NroPalabrasRecuerda, DenominarObjeto1, DenominarObjeto2, RepiteFrase, ComprensionEtapaUno, ComprensionEtapaDos, ComprensionEtapaTres, ObedeceCierraOjos, ObedeceEscribaFrase, ObedeceCopieDibujo);
                                    }
                                }
                            }
                        ]
                    },
                    {
                        html: '<br>'
                    },
                    {
                        xtype: 'checkbox',
                        name: 'Repetir: En un trigal habia cinco perros',
                        fieldLabel: 'Repetir: En un trigal habia cinco perros',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolRepiteFrase',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew === true || pNew === "true"){
                                    RepiteFrase = 1;
                                }else{
                                    RepiteFrase = 0;
                                }
                                CalcularTest005(OrientacionAnio,OrientacionMes, OrientacionDia, OrientacionDiaSemana, OrientacionHora, OrientacionPais, OrientacionDepartamento, OrientacionCiudad, OrientacionBarrio, OrientacionLugar, RepitePrimeraPalabra, RepiteSegundaPalabra, RepiteTerceraPalabra, PrimeraRespuestaCorrecta, SegundaRespuestaCorrecta, TerceraRespuestaCorrecta, CuartaRespuestaCorrecta, QuintaRespuestaCorrecta, NroPalabrasRecuerda, DenominarObjeto1, DenominarObjeto2, RepiteFrase, ComprensionEtapaUno, ComprensionEtapaDos, ComprensionEtapaTres, ObedeceCierraOjos, ObedeceEscribaFrase, ObedeceCopieDibujo);
                            }
                        }
                    },
                    {
                        html: '<br>Comprension: Obedecer Una orden en tres etapas<br>'
                    },
                    {
                        xtype: 'checkbox',
                        name: 'Obedecer Una orden en tres etapas. Etapa Uno',
                        fieldLabel: 'Tome la Hoja en su mano derecha',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolComprensionEtapaUno',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew === true || pNew === "true"){
                                    ComprensionEtapaUno = 1;
                                }else{
                                    ComprensionEtapaUno = 0;
                                }
                                CalcularTest005(OrientacionAnio,OrientacionMes, OrientacionDia, OrientacionDiaSemana, OrientacionHora, OrientacionPais, OrientacionDepartamento, OrientacionCiudad, OrientacionBarrio, OrientacionLugar, RepitePrimeraPalabra, RepiteSegundaPalabra, RepiteTerceraPalabra, PrimeraRespuestaCorrecta, SegundaRespuestaCorrecta, TerceraRespuestaCorrecta, CuartaRespuestaCorrecta, QuintaRespuestaCorrecta, NroPalabrasRecuerda, DenominarObjeto1, DenominarObjeto2, RepiteFrase, ComprensionEtapaUno, ComprensionEtapaDos, ComprensionEtapaTres, ObedeceCierraOjos, ObedeceEscribaFrase, ObedeceCopieDibujo);
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        name: 'Obedecer Una orden en tres etapas. Etapa Dos',
                        fieldLabel: 'Doblela por la mitad',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolComprensionEtapaDos',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew === true || pNew === "true"){
                                    ComprensionEtapaDos = 1;
                                }else{
                                    ComprensionEtapaDos = 0;
                                }
                                CalcularTest005(OrientacionAnio,OrientacionMes, OrientacionDia, OrientacionDiaSemana, OrientacionHora, OrientacionPais, OrientacionDepartamento, OrientacionCiudad, OrientacionBarrio, OrientacionLugar, RepitePrimeraPalabra, RepiteSegundaPalabra, RepiteTerceraPalabra, PrimeraRespuestaCorrecta, SegundaRespuestaCorrecta, TerceraRespuestaCorrecta, CuartaRespuestaCorrecta, QuintaRespuestaCorrecta, NroPalabrasRecuerda, DenominarObjeto1, DenominarObjeto2, RepiteFrase, ComprensionEtapaUno, ComprensionEtapaDos, ComprensionEtapaTres, ObedeceCierraOjos, ObedeceEscribaFrase, ObedeceCopieDibujo);
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        name: 'Obedecer Una orden en tres etapas. Etapa Tres',
                        fieldLabel: 'Pongala en el suelo',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolComprensionEtapaTres',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew === true || pNew === "true"){
                                    ComprensionEtapaTres = 1;
                                }else{
                                    ComprensionEtapaTres = 0;
                                }
                                CalcularTest005(OrientacionAnio,OrientacionMes, OrientacionDia, OrientacionDiaSemana, OrientacionHora, OrientacionPais, OrientacionDepartamento, OrientacionCiudad, OrientacionBarrio, OrientacionLugar, RepitePrimeraPalabra, RepiteSegundaPalabra, RepiteTerceraPalabra, PrimeraRespuestaCorrecta, SegundaRespuestaCorrecta, TerceraRespuestaCorrecta, CuartaRespuestaCorrecta, QuintaRespuestaCorrecta, NroPalabrasRecuerda, DenominarObjeto1, DenominarObjeto2, RepiteFrase, ComprensionEtapaUno, ComprensionEtapaDos, ComprensionEtapaTres, ObedeceCierraOjos, ObedeceEscribaFrase, ObedeceCopieDibujo);
                            }
                        }
                    },
                    {
                        html: '<br>Lea y obedezca la siguiente orden<br>'
                    },
                    {
                        xtype: 'checkbox',
                        name: 'Lea y obedezca la siguiente orden: Cierre los ojos',
                        fieldLabel: 'Cierre los ojos',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolObedeceCierraOjos',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew === true || pNew === "true"){
                                    ObedeceCierraOjos = 1;
                                }else{
                                    ObedeceCierraOjos = 0;
                                }
                                CalcularTest005(OrientacionAnio,OrientacionMes, OrientacionDia, OrientacionDiaSemana, OrientacionHora, OrientacionPais, OrientacionDepartamento, OrientacionCiudad, OrientacionBarrio, OrientacionLugar, RepitePrimeraPalabra, RepiteSegundaPalabra, RepiteTerceraPalabra, PrimeraRespuestaCorrecta, SegundaRespuestaCorrecta, TerceraRespuestaCorrecta, CuartaRespuestaCorrecta, QuintaRespuestaCorrecta, NroPalabrasRecuerda, DenominarObjeto1, DenominarObjeto2, RepiteFrase, ComprensionEtapaUno, ComprensionEtapaDos, ComprensionEtapaTres, ObedeceCierraOjos, ObedeceEscribaFrase, ObedeceCopieDibujo);
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        name: 'Lea y obedezca la siguiente orden: Escriba una frase',
                        fieldLabel: 'Escriba una frase',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolObedeceEscribaFrase',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew === true || pNew === "true"){
                                    ObedeceEscribaFrase = 1;
                                }else{
                                    ObedeceEscribaFrase = 0;
                                }
                                CalcularTest005(OrientacionAnio,OrientacionMes, OrientacionDia, OrientacionDiaSemana, OrientacionHora, OrientacionPais, OrientacionDepartamento, OrientacionCiudad, OrientacionBarrio, OrientacionLugar, RepitePrimeraPalabra, RepiteSegundaPalabra, RepiteTerceraPalabra, PrimeraRespuestaCorrecta, SegundaRespuestaCorrecta, TerceraRespuestaCorrecta, CuartaRespuestaCorrecta, QuintaRespuestaCorrecta, NroPalabrasRecuerda, DenominarObjeto1, DenominarObjeto2, RepiteFrase, ComprensionEtapaUno, ComprensionEtapaDos, ComprensionEtapaTres, ObedeceCierraOjos, ObedeceEscribaFrase, ObedeceCopieDibujo);
                            }
                        }
                    },
                    {
                        xtype: 'checkbox',
                        name: 'Lea y obedezca la siguiente orden: Copie el diseño o dibujo',
                        fieldLabel: 'Copie el diseño o dibujo',
                        anchor: '100%',
                        value: 'false',
                        id: 'bolObedeceCopieDibujo',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew === true || pNew === "true"){
                                    ObedeceCopieDibujo = 1;
                                }else{
                                    ObedeceCopieDibujo = 0;
                                }
                                CalcularTest005(OrientacionAnio,OrientacionMes, OrientacionDia, OrientacionDiaSemana, OrientacionHora, OrientacionPais, OrientacionDepartamento, OrientacionCiudad, OrientacionBarrio, OrientacionLugar, RepitePrimeraPalabra, RepiteSegundaPalabra, RepiteTerceraPalabra, PrimeraRespuestaCorrecta, SegundaRespuestaCorrecta, TerceraRespuestaCorrecta, CuartaRespuestaCorrecta, QuintaRespuestaCorrecta, NroPalabrasRecuerda, DenominarObjeto1, DenominarObjeto2, RepiteFrase, ComprensionEtapaUno, ComprensionEtapaDos, ComprensionEtapaTres, ObedeceCierraOjos, ObedeceEscribaFrase, ObedeceCopieDibujo);
                            }
                        }
                    }
                ]
            },
            {
                html: '<br><hr><br>'
            },
            {
                xtype: 'numberfield',
                name: 'Puntaje Total',
                fieldLabel: 'Puntaje Total',
                width: 50,
                minValue: 0,
                decimalPrecision: 0,
                allowBlank: true,
                value: 0,
                id: 'intAnexo5PuntajeTotal'
            }
        ];
        fsValoracionCognoscitivaUi.superclass.initComponent.call(this);
    }
});

function CalcularTest005(OrientacionAnio,OrientacionMes, OrientacionDia, OrientacionDiaSemana, OrientacionHora, OrientacionPais, OrientacionDepartamento, OrientacionCiudad, OrientacionBarrio, OrientacionLugar, RepitePrimeraPalabra, RepiteSegundaPalabra, RepiteTerceraPalabra, PrimeraRespuestaCorrecta, SegundaRespuestaCorrecta, TerceraRespuestaCorrecta, CuartaRespuestaCorrecta, QuintaRespuestaCorrecta, NroPalabrasRecuerda, DenominarObjeto1, DenominarObjeto2, RepiteFrase, ComprensionEtapaUno, ComprensionEtapaDos, ComprensionEtapaTres, ObedeceCierraOjos, ObedeceEscribaFrase, ObedeceCopieDibujo){
    Ext.getCmp('intAnexo5PuntajeTotal').setValue(0);
    Ext.getCmp('intAnexo5PuntajeTotal').setValue(OrientacionAnio + OrientacionMes + OrientacionDia + OrientacionDiaSemana + OrientacionHora + OrientacionPais + OrientacionDepartamento + OrientacionCiudad + OrientacionBarrio + OrientacionLugar + RepitePrimeraPalabra + RepiteSegundaPalabra + RepiteTerceraPalabra + PrimeraRespuestaCorrecta + SegundaRespuestaCorrecta + TerceraRespuestaCorrecta + CuartaRespuestaCorrecta + QuintaRespuestaCorrecta + NroPalabrasRecuerda + DenominarObjeto1 + DenominarObjeto2 + RepiteFrase + ComprensionEtapaUno + ComprensionEtapaDos + ComprensionEtapaTres + ObedeceCierraOjos + ObedeceEscribaFrase + ObedeceCopieDibujo);
}