/*
* @category    Fieldset ABC SOCIAL
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsEjecucionFisicaUi = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    title: 'EJECUCION FISICA (SPPB)',
    collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    titleCollapse: true,
    padding: 0,
    id: 'fsEjecucionFisica',
    initComponent: function() {
        
        var pEquilibrioPiesJuntos = 0;
        var pEquilibrioSemitandem = 0;
        var pEquilibrioTandem = 0;
        var pIncorporarseSilla = 0;
        var pVelocidadMarcha = 0;
        
        var dataEquilibrioPiesJuntos = [
            ['Mantiene 10 seg'],
            ['No mantiene 10 seg'],
            ['No lo Intenta']
        ];
        var stEquilibrioPiesJuntos = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stEquilibrioPiesJuntos.loadData(dataEquilibrioPiesJuntos);
               
        
        var dataEquilibrioSemitandem = [
            ['Mantiene 10 seg'],
            ['no mantiene 10 seg'],
            ['No lo Intenta']
        ];
        var stEquilibrioSemitandem = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stEquilibrioSemitandem.loadData(dataEquilibrioSemitandem);
               
        
        var dataIncorporarseSilla = [
            ['Incapaz de completar 5 o lo completa en > 60seg'],
            ['16,70 seg o mas'],
            ['13,70 seg a 16,69 seg'],
            ['11,20 seg a 13,69 seg'],
            ['11,19 seg o menos']
        ];
        var stIncorporarseSilla = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stIncorporarseSilla.loadData(dataIncorporarseSilla);
               
        
        var dataEquilibrioTandem = [
            ['Mantiene 10 seg'],
            ['Mantiene 3 - 9,99 seg'],
            ['no mantiene 10 seg'],
            ['No lo Intenta']
        ];
        var stEquilibrioTandem = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stEquilibrioTandem.loadData(dataEquilibrioTandem);
               
        
        this.items = [
            {
                xtype: 'fieldset',
                title: 'PRUEBA DE EQUILIBRIO',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                labelWidth: 90,
                autoHeight: true,
                padding: 5,
                id: 'fsPruebaEquilibrio',
                items: [
                    {
                        xtype: 'combo',
                        name: 'Pies Juntos',
                        fieldLabel: 'Pies Juntos',
                        width: 300,
                        allowBlank: true,
                        store: stEquilibrioPiesJuntos,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intEquilibrioPiesJuntos',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew == null || pNew == ''){
                                    pEquilibrioPiesJuntos = 0;
                                    Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                }else{
                                    if(pNew === 'Mantiene 10 seg' ){
                                        pEquilibrioPiesJuntos = 1;
                                        Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                    }else{
                                        pEquilibrioPiesJuntos = 0;
                                        Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                    }
                                }
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        name: 'Semitandem',
                        fieldLabel: 'Semitandem',
                        width: 300,
                        allowBlank: true,
                        store: stEquilibrioSemitandem,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intEquilibrioSemitandem',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew == null || pNew == ''){
                                    pEquilibrioSemitandem = 0;
                                    Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                }else{
                                    if(pNew === 'Mantiene 10 seg' ){
                                        pEquilibrioSemitandem = 1;
                                        Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                    }else{
                                        pEquilibrioSemitandem = 0;
                                        Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                    }
                                }
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        name: 'Tandem',
                        fieldLabel: 'Tandem',
                        width: 300,
                        allowBlank: true,
                        store: stEquilibrioTandem,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intEquilibrioTandem',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew == null || pNew == ''){
                                    pEquilibrioTandem = 0;
                                    Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                }else{
                                    if(pNew == 'Mantiene 10 seg' ){
                                        pEquilibrioTandem = 2;
                                        Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                    }else{
                                        if(pNew == 'Mantiene 3 - 9,99 seg' ){
                                            pEquilibrioTandem = 1;
                                            Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                        }else{
                                            pEquilibrioTandem = 0;
                                            Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                        }
                                    }
                                }
                            }
                        }
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'PRUEBA DE VELOCIDAD DE LA MARCHA',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                labelWidth: 90,
                autoHeight: true,
                padding: 5,
                id: 'fsVelocidadMarcha',
                items: [
                    {
                        html: 'Distancia de la pueba'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'checkbox',
                                fieldLabel: 'Cuatro Metros',
                                name: 'Distancia Cuatro Metros',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolDistanciaCuatroMetros',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        if(pNew == true){
                                            Ext.getCmp('bolDistanciaTresMetros').setValue('false')
                                        }
                                    }
                                }
                            },
                            {
                                html: 'Tres Metros'
                            },
                            {
                                xtype: 'checkbox',
                                name: 'Distancia Tres Metros',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolDistanciaTresMetros',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        if(pNew == true){
                                            Ext.getCmp('bolDistanciaCuatroMetros').setValue('false')
                                        }
                                    }
                                }
                            }
                        ]
                    },
                    {
                        html: '<br>'
                    },
                    {
                        html: 'Tiempo para recorrer 3 o 4 Metros'
                    },
                    {
                        xtype: 'numberfield',
                        name: 'Tiempo para recorrer 3 o 4 Metros Primera Prueba',
                        fieldLabel: 'Primera Prueba',
                        emptyText: '___,___seg',
                        width: 100,
                        decimalPrecision: 2,
                        allowBlank: true,
                        id: 'intTiempoPrimeraPrueba',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew == null || pNew == ''){
                                    pVelocidadMarcha = 0;
                                    Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                }else{
                                    if(Ext.getCmp('bolDistanciaCuatroMetros').getValue() == true && pNew >= 8.70 ){
                                        pVelocidadMarcha = 1;
                                        Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                    }else{
                                        if(Ext.getCmp('bolDistanciaCuatroMetros').getValue() == true && pNew >= 6.21 && pNew <= 8.70){
                                            pVelocidadMarcha = 2;
                                            Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                        }else{
                                            if(Ext.getCmp('bolDistanciaCuatroMetros').getValue() == true && pNew >= 4.82 && pNew <= 6.20){
                                                pVelocidadMarcha = 3;
                                                Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                            }else{
                                                if(Ext.getCmp('bolDistanciaCuatroMetros').getValue() == true && pNew <= 4.82){
                                                    pVelocidadMarcha = 4;
                                                    Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                }else{
                                                    if(Ext.getCmp('bolDistanciaTresMetros').getValue() == true && pNew >= 6.52 ){
                                                        pVelocidadMarcha = 1;
                                                        Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                    }else{
                                                        if(Ext.getCmp('bolDistanciaTresMetros').getValue() == true && pNew >= 4.66 && pNew <= 6.51){
                                                            pVelocidadMarcha = 2;
                                                            Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                        }else{
                                                            if(Ext.getCmp('bolDistanciaTresMetros').getValue() == true && pNew >= 3.62 && pNew <= 4.65){
                                                                pVelocidadMarcha = 3;
                                                                Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                            }else{
                                                                if(Ext.getCmp('bolDistanciaTresMetros').getValue() == true && pNew <= 3.62){
                                                                    pVelocidadMarcha = 4;
                                                                    Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    },
                    {
                        xtype: 'numberfield',
                        name: 'Tiempo para recorrer 3 o 4 Metros Segunda Prueba',
                        fieldLabel: 'Segunda Prueba',
                        emptyText: '___,___seg',
                        width: 100,
                        decimalPrecision: 2,
                        allowBlank: true,
                        id: 'intTiempoSegundaPrueba'
                    },
                    {
                        html: '<br>'
                    },
                    {
                        html: 'Ayudas para caminar:'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'checkbox',
                                fieldLabel: 'Ninguno',
                                name: 'Ninguno',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolAyudaNinguno'
                            },
                            {
                                html: 'Baston'
                            },
                            {
                                xtype: 'checkbox',
                                name: 'Baston',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolAyudaBaston'
                            },
                            {
                                html: 'Otra'
                            },
                            {
                                xtype: 'checkbox',
                                name: 'Otra',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolAyudaOtra'
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'PRUEBA DE INCORPORARSE DE LA SILLA',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                labelWidth: 10,
                padding: 5,
                id: 'fsIncorporarseSilla',
                items: [
                    {
                        html: 'Incorporarse de forma repetida 5 veces. Se cuenta cuando se sienta: '
                    },
                    {
                        xtype: 'combo',
                        name: 'Incorporarse de forma repetida 5 veces',
                        width: 350,
                        height: 200,
                        allowBlank: true,
                        store: stIncorporarseSilla,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intIncorporarseSilla',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew == null || pNew == ''){
                                    pIncorporarseSilla = 0;
                                    Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                }else{
                                    if(pNew == 'Incapaz de completar 5 o lo completa en > 60seg'){
                                        pIncorporarseSilla = 0;
                                        Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                    }else{
                                        if(pNew == '16,70 seg o mas'){
                                            pIncorporarseSilla = 1;
                                            Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                        }else{
                                            if(pNew == '13,70 seg a 16,69 seg'){
                                                pIncorporarseSilla = 2;
                                                Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                            }else{
                                                if(pNew == '11,20 seg a 13,69 seg'){
                                                    pIncorporarseSilla = 3;
                                                    Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                }else{
                                                    if(pNew == '11,19 seg o menos'){
                                                        pIncorporarseSilla = 4;
                                                        Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                    }else{
                                                        pIncorporarseSilla = 0;
                                                        Ext.getCmp('intAnexo8PuntajeTotal').setValue(pEquilibrioPiesJuntos + pEquilibrioSemitandem + pEquilibrioTandem + pVelocidadMarcha + pIncorporarseSilla)
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                ]
            },      
            {
                html: '<br><hr><br>'
            },
            {
                xtype: 'numberfield',
                name: 'Puntaje Total',
                fieldLabel: 'Puntaje Total',
                width: 50,
                minValue: 0,
                decimalPrecision: 0,
                allowBlank: true,
                value: 0,
                id: 'intAnexo8PuntajeTotal'
            }
        ];
        fsEjecucionFisicaUi.superclass.initComponent.call(this);
    }
});
