/*
* @category    Formulario Modelo Evolucion Historia Clinica CxAsociados 002
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCcxasociados002Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC - Paciente Obeso ::.',
    width: 990,
    height: 600,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
            
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                padding: 10,
                border: false,
                height: 560,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Genero',
                        id: 'sysGeneroPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 100,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 90,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 100,
                                id: 'sysLegalizaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysAutorizacionHC',
                                value: 'Nro Autorización: '
                            },
                            {
                                xtype: 'textfield',
                                width: 210,
                                allowBlank: true,
                                style: 'color:brown;',
                                readOnly: true,
                                id: 'sysNroAutorizacionHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 120,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroPacHC'
                            },
                            {
                                html: 'Fecha Nacimiento'
                            },
                            {
                                xtype: 'textfield',
                                width: 120,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFecNacPacHC'
                            },
                            {
                                html: 'Edad'
                            },
                            {
                                xtype: 'textfield',
                                width: 250,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysEdadPacHC'
                            }
                        ]
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        width: 930,
                        autoHeight: true,
                        border: false,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'panel',
                                                title: 'RESUMEN ULTIMA ATENCION',
                                                collapsible: true,
                                                titleCollapse: true,
                                                autoScroll: true,
                                                closable: false,
                                                anchor: '100%',
                                                autoHeight: true,
                                                style: 'color:#999;',
                                                id: 'viewResumenUltimaAtencionHC'
                                            },
                                            {
                                                html: '<br>'
                                            },
                                            {
                                                xtype: 'textfield',
                                                anchor: '100%',
                                                fieldLabel: 'Remitido Por',
                                                name: 'Remitido Por',
                                                allowBlank: true,
                                                id: 'strRemitidoPor'
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Motivo de Consulta - Enfermedad Actual',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'Motivo de Consulta - Enfermedad Actual',
                                                        name: 'Motivo de Consulta - Enfermedad Actual',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        id: 'memMotivoConsulta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Antecedentes Personales',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'Antecedentes Personales',
                                                        name: 'Antecedentes Personales',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        id: 'memAntecedentesPersonales'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Medicaciones',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'Medicaciones',
                                                        name: 'Medicaciones',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,
                                                        allowBlank: true,
                                                        id: 'memMedicaciones'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANALISIS SICOLOGICO GENERAL',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                layout: 'table',
                                                layoutConfig: {
                                                    columns: 1
                                                },
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        anchor: '99%',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'EL ESTADO ACTUAL DEL PACIENTE LE PERMITE ENTENDER  LAS RESTRICCIONES QUE TENDRA CON LA ALIMENTACION Y LOS CAMBIOS DE LA MISMA?',
                                                                name: 'EL ESTADO ACTUAL DEL PACIENTE LE PERMITE ENTENDER  LAS RESTRICCIONES QUE TENDRA CON LA ALIMENTACION Y LOS CAMBIOS DE LA MISMA?',
                                                                allowBlank: true,
                                                                id: 'strANALISISPSICOGEN1'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        anchor: '99%',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'HAY ALGUN ESTADO PSICOTICO O PSIQUIATRICO EN ANTECEDENTES?',
                                                                name: 'HAY ALGUN ESTADO PSICOTICO O PSIQUIATRICO EN ANTECEDENTES?',
                                                                allowBlank: true,
                                                                id: 'strANALISISPSICOGEN2'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        anchor: '99%',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'EL PACIENTE SE VE RESPETUOSO  EN LA CONSULTA?',
                                                                name: 'EL PACIENTE SE VE RESPETUOSO  EN LA CONSULTA?',
                                                                allowBlank: true,
                                                                id: 'strANALISISPSICOGEN3'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        anchor: '99%',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'ES CUMPLIDO CON SU CITA MEDICA Y CONTROLES?',
                                                                name: 'ES CUMPLIDO CON SU CITA MEDICA Y CONTROLES?',
                                                                allowBlank: true,
                                                                id: 'strANALISISPSICOGEN4'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        anchor: '99%',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'EL PACIENTE ES CONCIENTE DE QUE EL PROCESO PREOPERATORIO ES LARGO Y DEBE ASUMIRLO?',
                                                                name: 'EL PACIENTE ES CONCIENTE DE QUE EL PROCESO PREOPERATORIO ES LARGO Y DEBE ASUMIRLO?',
                                                                allowBlank: true,
                                                                id: 'strANALISISPSICOGEN5'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        anchor: '99%',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'PACIENTE ES MUY FUMADOR?',
                                                                name: 'PACIENTE ES MUY FUMADOR?',
                                                                allowBlank: true,
                                                                id: 'strANALISISPSICOGEN6'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        anchor: '99%',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'PACIENTE INGIERE LICOR FRECUENTEMENTE?',
                                                                name: 'PACIENTE INGIERE LICOR FRECUENTEMENTE?',
                                                                allowBlank: true,
                                                                id: 'strANALISISPSICOGEN7'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        anchor: '99%',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'QUE PIENSA EL PACIENTE DE PERDER PESO EN EL PREOPERATORIO?',
                                                                name: 'QUE PIENSA EL PACIENTE DE PERDER PESO EN EL PREOPERATORIO?',
                                                                allowBlank: true,
                                                                id: 'strANALISISPSICOGEN8'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        anchor: '99%',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'EL PACIENTE SE HA SOMETIDO A UNA CIRUGIA BARIATRICA ANTES Y HA FALLADO?',
                                                                name: 'EL PACIENTE SE HA SOMETIDO A UNA CIRUGIA BARIATRICA ANTES Y HA FALLADO?',
                                                                allowBlank: true,
                                                                id: 'strANALISISPSICOGEN9'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        anchor: '99%',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'EL PACIENTE HA INFORMADO A SU FAMILIA SOBRE  LA CIRUGIA Y QUIERE QUE ELLOS PARTICIPEN DE LA MISMA O POR EL CONTRARIO NO QUIERE QUE ELLOS SEPAN?',
                                                                name: 'EL PACIENTE HA INFORMADO A SU FAMILIA SOBRE  LA CIRUGIA Y QUIERE QUE ELLOS PARTICIPEN DE LA MISMA O POR EL CONTRARIO NO QUIERE QUE ELLOS SEPAN?',
                                                                allowBlank: true,
                                                                id: 'strANALISISPSICOGEN10'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        anchor: '99%',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'EL PACIENTE  DICE QUE QUIERE QUE USTED LO  OPERE Y HABLA MAL DE OTROS CIRUJANOS?',
                                                                name: 'EL PACIENTE  DICE QUE QUIERE QUE USTED LO  OPERE Y HABLA MAL DE OTROS CIRUJANOS?',
                                                                allowBlank: true,
                                                                id: 'strANALISISPSICOGEN11'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        anchor: '99%',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'EL PACIENTE A TENIDO UN TRAUMA SICOLOGICO RECIENTE ( PERDIDA DE UN SER QUERIDO – PROBLEMAS SENTIMENTALES- ETC)?',
                                                                name: 'EL PACIENTE A TENIDO UN TRAUMA SICOLOGICO RECIENTE ( PERDIDA DE UN SER QUERIDO – PROBLEMAS SENTIMENTALES- ETC)?',
                                                                allowBlank: true,
                                                                id: 'strANALISISPSICOGEN12'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CONSIDERACIONES MEDICAS ANTES DE LA CIRUGIA',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                layout: 'table',
                                                layoutConfig: {
                                                    columns: 1
                                                },
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        anchor: '99%',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'SUFRE EL PACIENTE DE  ALGUNA ENFERMEDAD  GRAVE ( CANCER  -  HIV -  CIRROSIS )?',
                                                                name: 'SUFRE EL PACIENTE DE  ALGUNA ENFERMEDAD  GRAVE ( CANCER  -  HIV -  CIRROSIS )?',
                                                                allowBlank: true,
                                                                id: 'strCONCIDERAMEDPREVCX1'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        anchor: '99%',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'COMO ES LA CALIDAD DE VIDA ACTUAL  Y SI LA CIRUGIA PENSAMOS VA A MEJORARLA  O YA ESTA TAN PERDIDA QUE DIFICILMENTE MEJORARA?',
                                                                name: 'COMO ES LA CALIDAD DE VIDA ACTUAL  Y SI LA CIRUGIA PENSAMOS VA A MEJORARLA  O YA ESTA TAN PERDIDA QUE DIFICILMENTE MEJORARA?',
                                                                allowBlank: true,
                                                                id: 'strCONCIDERAMEDPREVCX2'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        anchor: '99%',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'HAY CIRUGIAS PREVIAS – CUALES – EN QUE PARTE DEL CUERPO?',
                                                                name: 'HAY CIRUGIAS PREVIAS – CUALES – EN QUE PARTE DEL CUERPO?',
                                                                allowBlank: true,
                                                                id: 'strCONCIDERAMEDPREVCX3'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        anchor: '99%',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'EL PACIENTE TIENE ENFERMEDAD DE CROHN?',
                                                                name: 'EL PACIENTE TIENE ENFERMEDAD DE CROHN?',
                                                                allowBlank: true,
                                                                id: 'strCONCIDERAMEDPREVCX4'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        anchor: '99%',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'HA TENIDO CIRUGIAS DE RESECCION INTESTINAL?',
                                                                name: 'HA TENIDO CIRUGIAS DE RESECCION INTESTINAL?',
                                                                allowBlank: true,
                                                                id: 'strCONCIDERAMEDPREVCX5'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        anchor: '99%',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'HA TENIDO RADIACION?',
                                                                name: 'HA TENIDO RADIACION?',
                                                                allowBlank: true,
                                                                id: 'strCONCIDERAMEDPREVCX6'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        anchor: '99%',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'HA SIDO SOMETIDO A ALGUN TIPO DE TRASPLANTE?',
                                                                name: 'HA SIDO SOMETIDO A ALGUN TIPO DE TRASPLANTE?',
                                                                allowBlank: true,
                                                                id: 'strCONCIDERAMEDPREVCX7'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        anchor: '99%',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'HA SIDO SOMETIDO A UNA CIRUGIA BARIATRICA PREVIA?',
                                                                name: 'HA SIDO SOMETIDO A UNA CIRUGIA BARIATRICA PREVIA?',
                                                                allowBlank: true,
                                                                id: 'strCONCIDERAMEDPREVCX8'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        anchor: '99%',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'HAY  ALGUNA CIRUGIA ANTIREFLUJO?',
                                                                name: 'HAY  ALGUNA CIRUGIA ANTIREFLUJO?',
                                                                allowBlank: true,
                                                                id: 'strCONCIDERAMEDPREVCX9'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'MEDICION DE RIESGO DE MORTALIDAD (TABLA DE MARIA)',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                layout: 'table',
                                                layoutConfig: {
                                                    columns: 2
                                                },
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        width: 480,
                                                        layout: 'form',
                                                        labelWidth: 350,
                                                        labelStyle: 'text-align:right;',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'INDICE DE MASA CORPORAL MAYOR DE 50?',
                                                                name: 'INDICE DE MASA CORPORAL MAYOR DE 50?',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolMEDICIONRIESGOTBLMARIA1'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'SEXO MASCULINO?',
                                                                name: 'SEXO MASCULINO?',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolMEDICIONRIESGOTBLMARIA2'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'HIPERTENSION?',
                                                                name: 'HIPERTENSION?',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolMEDICIONRIESGOTBLMARIA3'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'RIESGO DE EMBOLISMO PULMONAR (TROMBOEMBOLISMO PREVIO , FILTRO DE CAVA , ENFERMEDAD VENOSA PREVIA GRAVE, HISTORIA DE FALLA CARDIACA DERECHA  O HIPERTENSION PULMONAR)?',
                                                                name: 'RIESGO DE EMBOLISMO PULMONAR (TROMBOEMBOLISMO PREVIO , FILTRO DE CAVA , ENFERMEDAD VENOSA PREVIA GRAVE, HISTORIA DE FALLA CARDIACA DERECHA  O HIPERTENSION PULMONAR)?',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolMEDICIONRIESGOTBLMARIA4'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        width: 480,
                                                        layout: 'form',
                                                        labelWidth: 350,
                                                        labelStyle: 'text-align:right;',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                html: '<b>SCORES:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;MORTALIDAD</b>:'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'CLASE A (0-1):&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0.2%',
                                                                name: 'CLASE A (0-1):&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0.2%',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolMEDICIONRIESGOTBLMARIASCORE1'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'CLASE B (2-3):&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1.1%',
                                                                name: 'CLASE B (2-3):&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1.1%',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolMEDICIONRIESGOTBLMARIASCORE2'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'CLASE C (4-5):&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2.4%',
                                                                name: 'CLASE C (4-5):&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2.4%',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolMEDICIONRIESGOTBLMARIASCORE3'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'INDICACIONES PARA TEST PULMONARES (PRUEBAS DE FUNCION – GASES ARTERIALES)',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                layout: 'table',
                                                layoutConfig: {
                                                    columns: 2
                                                },
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        width: 440,
                                                        layout: 'form',
                                                        labelWidth: 350,
                                                        labelStyle: 'text-align:right;',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'HAY ANTECEDENTES DE ENFERMEDAD PULMONAR?',
                                                                name: 'HAY ANTECEDENTES DE ENFERMEDAD PULMONAR?',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolINDICATESTPULMONAR1'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'DISNEA?',
                                                                name: 'DISNEA?',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolINDICATESTPULMONAR2'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'INDICE DE MASA CORPORAL MAYOR DE 60?',
                                                                name: 'INDICE DE MASA CORPORAL MAYOR DE 60?',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolINDICATESTPULMONAR3'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'FUMADOR?',
                                                                name: 'FUMADOR?',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolINDICATESTPULMONAR4'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'APNEA DEL SUEÑO?',
                                                                name: 'APNEA DEL SUEÑO?',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolINDICATESTPULMONAR5'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                fieldLabel: 'Aplica?',
                                                                name: '',
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strINDICATESTPULMONAR6'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        width: 410,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                anchor: '99%',
                                                                fieldLabel: 'AMERITA CPAP POS OPERATORIO?',
                                                                name: 'AMERITA CPAP POS OPERATORIO?',
                                                                allowBlank: true,
                                                                id: 'memINDICATESTPULMONAR7'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'INDICACIONES PARA VALORACION POR CARDIOLOGO',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                layout: 'table',
                                                layoutConfig: {
                                                    columns: 2
                                                },
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        width: 440,
                                                        layout: 'form',
                                                        labelWidth: 350,
                                                        labelStyle: 'text-align:right;',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'SUPER OBESO ( IMB MAYOR DE 50 ) CON HIPERTENSION?',
                                                                name: 'SUPER OBESO ( IMB MAYOR DE 50 ) CON HIPERTENSION?',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolINDICAVALORACARDIOLOGO1'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'OBESIDAD SEVERA Y RETENCION DE LIQUIDOS?',
                                                                name: 'OBESIDAD SEVERA Y RETENCION DE LIQUIDOS?',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolINDICAVALORACARDIOLOGO2'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                fieldLabel: 'Aplica?',
                                                                name: '',
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strINDICAVALORACARDIOLOGO5'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        width: 410,
                                                        layout: 'form',
                                                        labelWidth: 350,
                                                        labelStyle: 'text-align:right;',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'APNEA DEL SUEÑO E HIPERTENSION?',
                                                                name: 'APNEA DEL SUEÑO E HIPERTENSION?',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolINDICAVALORACARDIOLOGO3'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'SOSPECHA CLINICA DE ANGINA  O ENFERMEDAD CORONARIA?',
                                                                name: 'SOSPECHA CLINICA DE ANGINA  O ENFERMEDAD CORONARIA?',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolINDICAVALORACARDIOLOGO4'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EXAMEN FISICO',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                labelWidth: 210,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 120,
                                                                fieldLabel: 'TA',
                                                                name: 'TA',
                                                                allowBlank: true,
                                                                id: 'strEF_TA'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysCxAsociados01_a',
                                                                value: 'FC: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 120,
                                                                name: 'FC',
                                                                allowBlank: true,
                                                                id: 'strEF_FC'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysCxAsociados01_b',
                                                                value: 'FR: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                name: 'FR',
                                                                allowBlank: true,
                                                                id: 'strEF_FR'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysCxAsociados01_c',
                                                                value: 'SO2: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                name: 'SO2',
                                                                allowBlank: true,
                                                                id: 'strEF_SO2'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'TALLA (cm)',
                                                                name:"TALLA (cm)",
                                                                emptyText: '(cm)',
                                                                id: 'intEF_Talla',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEF_Talla').setValue(null);
                                                                            Ext.getCmp('intEF_IMC').setValue(0);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('intEF_Peso').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEF_Talla').getValue() / 100;
                                                                                Ext.getCmp('intEF_IMC').setValue(Ext.getCmp('intEF_Peso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEF_IMC').setValue(0);
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('intEF_IMC').getValue()<1){
                                                                           Ext.getCmp('strEF_IMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEF_IMC').getValue()<24.9){
                                                                               Ext.getCmp('strEF_IMCClasificacon').setValue("ACEPTABLE");
                                                                            }else{
                                                                                if(Ext.getCmp('intEF_IMC').getValue()<29.9){
                                                                                   Ext.getCmp('strEF_IMCClasificacon').setValue("SOBREPESO");
                                                                                }else{
                                                                                    Ext.getCmp('strEF_IMCClasificacon').setValue("OBESIDAD");
                                                                                }

                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysCxAsociados01_d',
                                                                value: 'PESO (Kg): '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                emptyText: '(Kg)',
                                                                name:"PESO (Kg)",
                                                                id: 'intEF_Peso',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEF_Peso').setValue(null);
                                                                            Ext.getCmp('intEF_IMC').setValue(0);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('intEF_Talla').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEF_Talla').getValue() / 100;
                                                                                Ext.getCmp('intEF_IMC').setValue(Ext.getCmp('intEF_Peso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEF_IMC').setValue(0);
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('intEF_IMC').getValue()<1){
                                                                           Ext.getCmp('strEF_IMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEF_IMC').getValue()<24.9){
                                                                               Ext.getCmp('strEF_IMCClasificacon').setValue("ACEPTABLE");
                                                                            }else{
                                                                                if(Ext.getCmp('intEF_IMC').getValue()<29.9){
                                                                                   Ext.getCmp('strEF_IMCClasificacon').setValue("SOBREPESO");
                                                                                }else{
                                                                                    Ext.getCmp('strEF_IMCClasificacon').setValue("OBESIDAD");
                                                                                }

                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysCxAsociados01_e',
                                                                value: 'IMC: '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                name: "IMC",
                                                                id: 'intEF_IMC'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                name: "IMC - CLASIFICACION",
                                                                id: 'strEF_IMCClasificacon'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                fieldLabel: 'INDICE DE CINTURA',
                                                                name: 'INDICE DE CINTURA',
                                                                allowBlank: true,
                                                                id: 'intEF_INDICECINTURA'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysCxAsociados01_f',
                                                                value: 'INDICE DE CUELLO: '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'INDICE DE CUELLO',
                                                                allowBlank: true,
                                                                id: 'intEF_INDICECUELLO'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                fieldLabel: 'DIAMETRO DE MUSLOS DER',
                                                                name: 'DIAMETRO DE MUSLOS DER',
                                                                allowBlank: true,
                                                                id: 'intEF_INDICEMUSLOSDER'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysCxAsociados01_G',
                                                                value: 'DIAMETRO DE MUSLOS IZQ: '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'DIAMETRO DE MUSLOS IZQ',
                                                                allowBlank: true,
                                                                id: 'intEF_INDICEMUSLOSIZQ'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                fieldLabel: 'DIAMETRO DE BRAZOS DER',
                                                                name: 'DIAMETRO DE BRAZOS DER',
                                                                allowBlank: true,
                                                                id: 'intEF_INDICEBRAZODER'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysCxAsociados01_G',
                                                                value: 'DIAMETRO DE BRAZOS IZQ: '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'DIAMETRO DE BRAZOS IZQ',
                                                                allowBlank: true,
                                                                id: 'intEF_INDICEBRAZOIZQ'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        anchor: '100%',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                anchor: '99%',
                                                                fieldLabel: 'EXAMEN CARDIOPULMONAR',
                                                                name: 'EXAMEN CARDIOPULMONAR',
                                                                allowBlank: true,
                                                                id: 'memEF_CARDIOPULMONAR'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        anchor: '100%',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                anchor: '99%',
                                                                fieldLabel: 'EXAMEN DE ABDOMEN',
                                                                name: 'EXAMEN DE ABDOMEN',
                                                                allowBlank: true,
                                                                id: 'memEF_ABDOMEN'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        anchor: '100%',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                anchor: '99%',
                                                                fieldLabel: 'EXAMEN VASCULAR Y DE MIEMBROS INFERIORES',
                                                                name: 'EXAMEN VASCULAR Y DE MIEMBROS INFERIORES',
                                                                allowBlank: true,
                                                                id: 'memEF_VASCULARMI'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'TIPO DE OBESIDAD',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                labelWidth: 250,
                                                layout: 'form',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'SOBREPESO ( IMB  ENTRE 25 Y 29)?',
                                                                name: 'SOBREPESO ( IMB  ENTRE 25 Y 29)?',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolTIPOOBESIDAD1'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 500,
                                                                allowBlank: true,
                                                                name: "",
                                                                id: 'strTIPOOBESIDAD1H'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'checkbox',
                                                        fieldLabel: 'OBESIDAD CLASE  I ( IMB ENTRE 30 Y 35)?',
                                                        name: 'OBESIDAD CLASE  I ( IMB ENTRE 30 Y 35)?',
                                                        anchor: '100%',
                                                        value: 'false',
                                                        id: 'bolTIPOOBESIDAD2'
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        border: false,
                                                        layout: 'form',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'HAY ALGUNA COMORBILIDAD ASOCIADA?',
                                                                name: 'HAY ALGUNA COMORBILIDAD ASOCIADA?',
                                                                id: 'strTIPOOBESIDAD2_1H'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'O TIENE DIETAS POR MAS DE 6 MESES SUPERVISADAS?',
                                                                name: 'O TIENE DIETAS POR MAS DE 6 MESES SUPERVISADAS?',
                                                                id: 'strTIPOOBESIDAD2_2H'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'O HAY UN SINDROME METABOLICO  ASOCIADO?',
                                                                name: 'O HAY UN SINDROME METABOLICO  ASOCIADO?',
                                                                id: 'strTIPOOBESIDAD2_3H'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'checkbox',
                                                        fieldLabel: 'OBESIDAD CLASE II ( IMB ENTRE 35 Y 39)?',
                                                        name: 'OBESIDAD CLASE II ( IMB ENTRE 35 Y 39)?',
                                                        anchor: '100%',
                                                        value: 'false',
                                                        id: 'bolTIPOOBESIDAD3'
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        border: false,
                                                        layout: 'form',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'HAY ALGUNA COMORBILIDAD ASOCIADA?',
                                                                name: 'HAY ALGUNA COMORBILIDAD ASOCIADA?',
                                                                id: 'strTIPOOBESIDAD3_1H'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'O TIENE DIETAS POR MAS DE 6 MESES SUPERVISADAS?',
                                                                name: 'O TIENE DIETAS POR MAS DE 6 MESES SUPERVISADAS?',
                                                                id: 'strTIPOOBESIDAD3_2H'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'O HAY UN SINDROME METABOLICO  ASOCIADO?',
                                                                name: 'O HAY UN SINDROME METABOLICO  ASOCIADO?',
                                                                id: 'strTIPOOBESIDAD3_3H'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'OBESIDAD  CLASE III (IMB  MAYOR DE 40)?',
                                                                name: 'OBESIDAD  CLASE III (IMB  MAYOR DE 40)?',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolTIPOOBESIDAD4'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 500,
                                                                allowBlank: true,
                                                                name: "",
                                                                id: 'strTIPOOBESIDAD4H'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'OBESIDAD  CLASE III (IMB  MAYOR DE 50)?',
                                                                name: 'OBESIDAD  CLASE III (IMB  MAYOR DE 50)?',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolTIPOOBESIDAD5'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 500,
                                                                allowBlank: true,
                                                                name: "",
                                                                id: 'strTIPOOBESIDAD5H'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANOTACIONES DEACUERDO A LA HISTORIA(PARACLINICOS SI LOS TRAE)',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'ANOTACIONES DEACUERDO A LA HISTORIA(PARACLINICOS SI LOS TRAE)',
                                                        name: 'ANOTACIONES DEACUERDO A LA HISTORIA(PARACLINICOS SI LOS TRAE)',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,            
                                                        allowBlank: true,
                                                        id: 'memAnotacionesHC'
                                                    },
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'PLAN',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'PLAN',
                                                        name: 'PLAN',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,           
                                                        allowBlank: false,
                                                        id: 'memConducta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CIRUGIA RECOMENDADA Y PORQUE',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'CIRUGIA RECOMENDADA Y PORQUE',
                                                        name: 'CIRUGIA RECOMENDADA Y PORQUE',
                                                        height: 30,
                                                        grow: true,
                                                        minGrow: 30,           
                                                        allowBlank: false,
                                                        id: 'memCxRecomendada'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsRips',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }                            
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 352,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                            /*,
                            {
                                xtype: 'panel',
                                title: 'Solicitud CTC',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaCTC',
                                items: [
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                items: [
                                ]
                            },*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    if (Ext.getCmp('sysUsaGridSalida').getValue() == 1){
                                                        Ext.getCmp('gridFormulario').store.reload();
                                                    }
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistros();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistros();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                if(paramOpcion === "Nuevo"){ 
                    var frm = Ext.getCmp('frmHC').getForm();
                    frm.doAction('load', {
                        url: '../../controlador/asistencial/evolucionhc.php',
                        waitMsg: 'Cargando Información...',
                        params:{
                            pCAS: myCAS,
                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                            task: 'ImportarAntecedentesFamiliares'
                        },
                        success:function(form, action) {
                            CargarDataHCAntecedentes(action.result.data.sysEvolucion);
                            frm.doAction('load', {
                                url: '../../controlador/asistencial/evolucionhc.php',
                                waitMsg: 'Cargando Información...',
                                params:{
                                    pCAS: myCAS,
                                    pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                    task: 'ImportarAntecedentesPersonales'
                                },
                                success:function(form, action) {
                                    CargarDataHCAntecedentes(action.result.data.sysEvolucion);
                                }
                            });
                        }
                    });
                }
                var frm = Ext.getCmp('frmHC').getForm();
                frm.doAction('load', {
                    url: '../../controlador/asistencial/evolucionhc.php',
                    waitMsg: 'Cargando Información...',
                    params:{
                        pCAS: myCAS,
                        pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                        task: 'ImportarUltimaAtencion'
                    },
                    success:function(form, action) {
                        Ext.getCmp('viewResumenUltimaAtencionHC').load({
                            url: '../../controlador/asistencial/viewhcxformato.php?pEmpresa=' + ID_EMPRESA + '&pIPS=' + ID_IPS + '&pPaciente=' + Ext.getCmp('sysIdPacienteHC').getValue() + '&pEvolucion=' + action.result.data.ConsecutivoHC,
                            scripts:true,
                            scope:this,
                            nocache: false,
                            text: 'Cargando...'
                        });
                        //CargarDataHCUltimaAtencion(action.result.data.sysEvolucion);
                    }
                });
            }}
        });
        winHCcxasociados002Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
