
/*
* @category    Formulario Seleccion Plantilla HC y Apertura HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddEvolucionOfimedicalUi = Ext.extend(Ext.Window, {
    title: '.:: Apertura de Historia Clínica ::.',
    //x: ((screen.width - 1004)/2) + 130,
    y: 50,
    width: 1010,
    autoHeight: true,
    modal: true,
    closable: false,
    frame: true,
    padding: 10,
    labelWidth: 150,
    layout: 'form',
    id: 'winAddEvolucionOfimedicalUi',
    style: 'background:transparent;',
    initComponent: function() {
        
        var myMask = new Ext.LoadMask(Ext.getBody(), {msg:"Cargando Formulario..."});
        myMask.show();
        
        var stGrid = new StoreGridPlantillasHC();
        var stComboUbicacion = new StoreConsultoriosxIPS();
        stComboUbicacion.load({
            params: {
                pIPS: ID_IPS
            }
        });
        stGrid.setBaseParam('pEmpresa', ID_EMPRESA);
        stGrid.load();
        stProfesionalesxLogin = new StoreProfesionales();
        stProfesionalesxLogin.load({
            params: {
                pUsuario: ID_USUARIO
            }
        });
        this.bbar = [
            '->',
            {
                text: 'Salir',
                iconCls: 'btnSalir',
                listeners: {
                    click : function() {
                        Ext.Msg.show({
                            title: 'eOfiClinic',
                            msg: 'Esta seguro que desea cerrar la ventana?',
                            buttons: Ext.Msg.YESNO,
                            icon: Ext.Msg.QUESTION,
                            fn: function(btn)
                            {
                                if(btn=="yes")
                                {
                                    Ext.getCmp('winAddEvolucionOfimedicalUi').close();
                                }
                            }
                        });
                    }
                }
            }
        ];
        this.items = [
            {
                xtype: 'form',
                id: 'frmParms',
                anchor: '100%',
                frame: true,
                autoHeight: true,
                items:[
                    {
                        xtype: 'hidden',
                        id: 'sysEmpresaPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysSedePlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysGeneroPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysIPSPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysActividadPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysPlantillaPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysUsuarioPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysPacientePlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysConsecutivoDetalle_HC'
                    },
                    {
                        xtype: 'hidden',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysHoraPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysFechaLegalizaPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysHoraEstimadaPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'CAS',
                        id: 'sysCASPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysNomProfesionalPlantillaHC'
                    },

                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClientePlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad Programada',
                        id: 'sysActividadPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        autoHeight: true,
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysNomPacientePlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        readOnly: true,
                        width: 96,
                        allowBlank: true,
                        style: 'color: #0000cc; font-weight: bold;',
                        id: 'sysVlrConcepto'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysIVA',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysVlrIVA',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysidTipoReg',
                        value: 0
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Profesional',
                        anchor: '100%',
                        allowBlank: false,
                        store: stProfesionalesxLogin,
                        typeAhead: true,
                        typeAheadDelay: 50,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        emptyText: 'Seleccione....',
                        mode: 'local',
                        triggerAction: 'all',
                        forceSelection: true,
                        id: 'sysProfesionalPlantillaHC'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Ubicación / Consultorio',
                        anchor: '100%',
                        allowBlank: false,
                        store: stComboUbicacion,
                        typeAhead: true,
                        typeAheadDelay: 50,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        emptyText: 'Seleccione....',
                        mode: 'local',
                        triggerAction: 'all',
                        forceSelection: true,
                        id: 'sysUbicacionPlantillaHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        anchor: '100%',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Cliente',
                                width: 300,
                                allowBlank: false,
                                store: 'StoreCliente',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione Cliente....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'sysIdCliente_HC',
                                listeners: {
                                    select: function(cmb, rec, idx) {
                                        if(cmb.getValue() == null || cmb.getValue() == ""){
                                            Ext.getCmp('sysIdPlan_HC').store.removeAll(true);
                                            Ext.getCmp('sysIdSubPlan_HC').store.removeAll(true);
                                            Ext.getCmp('sysIdContrato_HC').store.removeAll(true);
                                            //Ext.getCmp('intIdProcedimiento').store.removeAll(true);
                                            Ext.getCmp('sysIdPlan_HC').setValue(null);
                                            Ext.getCmp('sysIdSubPlan_HC').setValue(null);
                                            Ext.getCmp('intIdProcedimiento').setValue(null);
                                            Ext.getCmp('sysIdPlan_HC').disable();
                                            Ext.getCmp('sysIdSubPlan_HC').disable();
                                            Ext.getCmp('sysIdContrato_HC').disable();
                                            
                                        }else{
                                            Ext.getCmp('sysIdPlan_HC').store.removeAll(true);
                                            Ext.getCmp('sysIdSubPlan_HC').store.removeAll(true);
                                            Ext.getCmp('sysIdContrato_HC').store.removeAll(true);
                                            //Ext.getCmp('intIdProcedimiento').store.removeAll(true);
                                            Ext.getCmp('intIdProcedimiento').setValue(null);
                                            /*Ext.getCmp('intIdProcedimiento').store.load({
                                                params:{
                                                    pIPS: ID_IPS,
                                                    pCliente: cmb.getValue()
                                                }
                                            });*/
                                            Ext.getCmp('sysIdPlan_HC').setValue(null);
                                            Ext.getCmp('sysIdSubPlan_HC').setValue(null);
                                            Ext.getCmp('sysIdSubPlan_HC').disable();
                                            Ext.getCmp('sysIdPlan_HC').store.load({
                                                params:{
                                                    pCliente: cmb.getValue()
                                                },
                                                callback: function(){
                                                    Ext.getCmp('sysIdPlan_HC').enable();
                                                }
                                            });
                                            Ext.getCmp('sysIdContrato_HC').store.load({
                                                params:{
                                                    pCliente: cmb.getValue()
                                                },
                                                callback: function(){
                                                    Ext.getCmp('sysIdContrato_HC').enable();
                                                }
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'displayfield',
                                value: 'Plan:'
                            },
                            {
                                xtype: 'combo',
                                width: 135,
                                listWidth: 250,
                                allowBlank: false,
                                disabled: true,
                                store: 'StoreClientesPlan',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'IdPlan',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione Plan....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'sysIdPlan_HC',
                                listeners: {
                                    select: function(cmb, rec, idx) {
                                        if(cmb.getValue() == null || cmb.getValue() == ""){
                                            Ext.getCmp('sysIdSubPlan_HC').store.removeAll(true);
                                            Ext.getCmp('sysIdSubPlan_HC').setValue(null);
                                            Ext.getCmp('sysIdSubPlan_HC').disable();
                                        }else{
                                            Ext.getCmp('sysIdSubPlan_HC').store.removeAll(true);
                                            Ext.getCmp('sysIdSubPlan_HC').store.load({
                                                params:{
                                                    pPlan: cmb.getValue()
                                                },
                                                callback: function(){
                                                    Ext.getCmp('sysIdSubPlan_HC').enable();
                                                }
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'displayfield',
                                value: 'SubPlan:'
                            },
                            {
                                xtype: 'combo',
                                width: 135,
                                listWidth: 250,
                                allowBlank: false,
                                disabled: true,
                                store: 'StoreClienteSubplan',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'IdSubPlan',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione Plan....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'sysIdSubPlan_HC'
                            },
                            {
                                xtype: 'displayfield',
                                value: 'Contrato:'
                            },
                            {
                                xtype: 'combo',
                                width: 133,
                                listWidth: 250,
                                allowBlank: false,
                                disabled: true,
                                store: 'StoreClienteContrato',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'IdContrato',
                                displayField: 'Contrato',
                                emptyText: 'Seleccione Contrato....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'sysIdContrato_HC'
                            }
                        ]
                    },
                    {
                        xtype: 'hidden',
                        fieldLabel: 'Concepto',
                        allowBlank: true,
                        id: 'intIdProcedimiento'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        anchor: '100%',
                        items: [
                            {
                                xtype: 'textfield',
                                readOnly: true,
                                width: 96,
                                allowBlank: true,
                                style: 'color: #0000cc; font-weight: bold;',
                                id: 'sysCodConcepto'
                            },
                            {
                                xtype: 'textfield',
                                readOnly: true,
                                width: 730,
                                //height: 50,
                                fieldLabel: 'Descripción',
                                style: 'font-family: Arial,Helvetica,sans-serif;font-size: 10px; color: #0000cc; font-weight: bold;',
                                id: 'sysDesConcepto'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar Concepto',
                                listeners: {
                                    click: function(){
                                        buscarconceptoBasico('Search');
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        fieldLabel: 'Fecha Cita',
                        items: [
                            {
                                xtype: 'datefield',
                                width: 120,
                                fieldLabel: 'Fecha Cita',
                                allowBlank: false,
                                disabledDates: '',
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                value: new Date().format('d/m/Y'),
                                id: 'sysFechaPlantillaHC'
                            },
                            {
                                xtype: 'displayfield',
                                value: '&nbsp;&nbsp;&nbsp;Nro Autorización'
                            },
                            {
                                xtype: 'textfield',
                                width: 120,
                                allowBlank: true,
                                style: 'text-align:center;',
                                id: 'sysNroAutorizacion'
                            },
                            {
                                xtype: 'displayfield',
                                value: '&nbsp;'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnGuardar',
                                tooltip: 'Crear Registro de Evolución',
                                id: 'btnCrearHC',
                                text: 'Crear Registro de Evolución',
                                handler:function(){
                                    if(Ext.getCmp('sysUbicacionPlantillaHC').getValue() != "" && Ext.getCmp('sysUbicacionPlantillaHC').getValue() != null && Ext.getCmp('sysIdCliente_HC').getValue() != "" && Ext.getCmp('sysIdCliente_HC').getValue() != null && Ext.getCmp('sysFechaPlantillaHC').getValue() != "" && Ext.getCmp('sysFechaPlantillaHC').getValue() != null && Ext.getCmp('intIdProcedimiento').getValue() != "" && Ext.getCmp('intIdProcedimiento').getValue() != null && Ext.getCmp('intIdProcedimiento').getValue() != 0){
                                        var Municipio = " ";
                                        try {
                                            var campo = Ext.getCmp('strDeptoMuni');
                                            if ( campo != null ) {
                                                Municipio = Ext.getCmp('strDeptoMuni').getValue();
                                            }
                                            var campo1 = Ext.getCmp('strMunicipio');
                                            if ( campo1 != null ) {
                                                Municipio = Ext.getCmp('strMunicipio').getValue();
                                            }
                                        }catch(ex) {
                                            // aqui se atrapo el error y se le puede mandar un mensaje al usuario o hacer alguna acción que controle el error.
                                            //Ext.Msg('El campo no se encontro,' + ex.Message);
                                        }
                                        Ext.Ajax.request(
                                        {
                                            waitMsg: 'Por favor Espere...',
                                            url: "../../controlador/asistencial/ofimedicalhc.php",
                                            params:{
                                                task: "CrearESTUDIOS002",
                                                pEmpresa: ID_EMPRESA,
                                                pConsultorio: Ext.getCmp('sysUbicacionPlantillaHC').getValue(),
                                                pCliente: Ext.getCmp('sysIdCliente_HC').getValue(),
                                                pPlan: Ext.getCmp('sysIdPlan_HC').getValue(),
                                                pSubPlan: Ext.getCmp('sysIdSubPlan_HC').getValue(),
                                                pContrato: Ext.getCmp('sysIdContrato_HC').getValue(),
                                                pFecha:  Ext.getCmp('sysFechaPlantillaHC').getValue().format('Y/m/d'),
                                                pProfesional: Ext.getCmp('sysProfesionalPlantillaHC').getValue(),
                                                pPaciente: Ext.getCmp('intIdPaciente').getValue(),
                                                pEdadPaciente: Ext.getCmp('strEdad').getValue(),
                                                pDeptoMunici: Municipio, 
                                                pIdProcedimiento: Ext.getCmp('intIdProcedimiento').getValue(), 
                                                pCodProcedimiento: Ext.getCmp('sysCodConcepto').getValue(), 
                                                pDesProcedimiento: Ext.getCmp('sysDesConcepto').getValue(),
                                                pVlrProcedimiento: Ext.getCmp('sysVlrConcepto').getValue(),
                                                pAutorizacion: Ext.getCmp('sysNroAutorizacion').getValue(),
                                                pUsuario: ID_USUARIO
                                            },
                                            success: function(response,options)
                                            {
                                                var el = Ext.get('response'); 
                                                var Respuesta = response.responseText;
                                                var Contenido = Respuesta.split('^');
                                                var NroCAS = Contenido[0];
                                                if(NroCAS > 0){
                                                    Ext.getCmp('sysCASPlantillaHC').setValue(Contenido[0]);
                                                    Ext.getCmp('sysConsecutivoDetalle_HC').setValue(Contenido[1]);
                                                    Ext.getCmp('sysNomProfesionalPlantillaHC').setValue(Contenido[2]);
                                                    Ext.getCmp('gridSeleccionarPlantillaHC').setVisible(true);
                                                } else {
                                                    Ext.Msg.hide();
                                                    Ext.MessageBox.show({
                                                        title: 'Crear Registro Evolución',
                                                        msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                                                        buttons: Ext.MessageBox.OK,
                                                        icon: Ext.MessageBox.ERROR
                                                    });
                                                }
                                            },
                                            failure: function(response,options)
                                            {
                                                Ext.MessageBox.hide();
                                                Ext.MessageBox.show({
                                                    title: 'Crear Registro Evolución',
                                                    msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        });
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'Los campos de la pantalla son requeridos',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'grid',
                        id: 'gridSeleccionarPlantillaHC',
                        store: stGrid,
                        anchor: "100%",
                        height: 290,
                        border: false,
                        frame: true,
                        loadMask: true,
                        stripeRows: true,
                        columnLines: true,
                        columns: [
                            {
                                header: 'Plantilla',
                                dataIndex: 'NomPlantilla',
                                readOnly: true,
                                sortable: false,
                                width: 650,
                                hideable: false
                            },{
                                header: 'Grupo',
                                dataIndex: 'Grupo',
                                readOnly: true,
                                sortable: false,
                                width: 100,
                                hidden: true,
                                hideable: false
                            }
                        ],
                        tbar:
                        {
                            xtype: 'toolbar',
                            items: [
                                '->',
                                new Ext.app.SearchField({
                                    id: 'qryPlantillasHC',
                                    store: stGrid,
                                    emptyText: 'Escriba el criterio que desea buscar',
                                    width: 120
                                })
                            ]
                        },
                        viewConfig: {
                            forceFit:true
                        },
                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                        view: new Ext.grid.GroupingView({
                           groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})'
                        }),
                        buttons: [
                            {
                                text: 'Abrir Histora Clínica',
                                iconCls: 'btnEvolucionar',
                                listeners: {
                                    click : function() {
                                        if(Ext.getCmp('gridSeleccionarPlantillaHC').selModel.getCount() == 1)
                                        {
                                            var totalRegistros = -1;
                                            var selections = Ext.getCmp('gridSeleccionarPlantillaHC').selModel.getSelections();
                                            stCIE10 = new StoreCIE10();
                                            objMX = "NA";
                                            objMXADD = "NA";
                                            objEXA = "NA";
                                            objEXAADD = "NA";
                                            objREM = "NA";
                                            objREMADD = "NA";
                                            if(selections[0].json.RutaFrmMx != null && selections[0].json.RutaFrmMx != ""){
                                                ScriptMgr.loadJs({
                                                    scripts : selections[0].json.RutaFrmMx,
                                                    callback : function(){
                                                        objMX = selections[0].json.NomObjetoMx;
                                                        ScriptMgr.loadJs({
                                                            scripts : selections[0].json.RutaFrmAddMx,
                                                            callback : function(){
                                                                objMXADD = selections[0].json.NomObjetoAddMx;
                                                            }
                                                        });
                                                    }
                                                });
                                            }
                                            if(selections[0].json.RutaFrmExa != null && selections[0].json.RutaFrmExa != ""){
                                                ScriptMgr.loadJs({
                                                    scripts : selections[0].json.RutaFrmExa,
                                                    callback : function(){
                                                        objEXA = selections[0].json.NomObjetoExa;
                                                        ScriptMgr.loadJs({
                                                            scripts : selections[0].json.RutaFrmAddExa,
                                                            callback : function(){
                                                                objEXAADD = selections[0].json.NomObjetoAddExa;
                                                            }
                                                        });
                                                    }
                                                });
                                            }
                                            if(selections[0].json.RutaFrmRem != null && selections[0].json.RutaFrmRem != ""){
                                                ScriptMgr.loadJs({
                                                    scripts : selections[0].json.RutaFrmRem,
                                                    callback : function(){
                                                        objREM = selections[0].json.NomObjetoRem;
                                                        ScriptMgr.loadJs({
                                                            scripts : selections[0].json.RutaFrmAddRem,
                                                            callback : function(){
                                                                objREMADD = selections[0].json.NomObjetoAddRem;
                                                            }
                                                        });
                                                    }
                                                });
                                            }
                                            if(selections[0].json.UsaTestBarthel != null && selections[0].json.UsaTestBarthel != "" && selections[0].json.UsaTestBarthel == "1"){
                                                ScriptMgr.loadJs({
                                                    scripts : '../../../app/frm_js/asistencial/ofimedical/wintestbarthel.ui.js'
                                                });
                                            }
                                            if(selections[0].json.UsaTestHachinski != null && selections[0].json.UsaTestHachinski != "" && selections[0].json.UsaTestHachinski == "1"){
                                                ScriptMgr.loadJs({
                                                    scripts : '../../../app/frm_js/asistencial/ofimedical/wintesthachinski.ui.js'
                                                });
                                            }
                                            if(selections[0].json.UsaTestFolstein != null && selections[0].json.UsaTestFolstein != "" && selections[0].json.UsaTestFolstein == "1"){
                                                ScriptMgr.loadJs({
                                                    scripts : '../../../app/frm_js/asistencial/ofimedical/wintestfolstein.ui.js'
                                                });
                                            }
                                            if(selections[0].json.UsaTestLawton != null && selections[0].json.UsaTestLawton != "" && selections[0].json.UsaTestLawton == "1"){
                                                ScriptMgr.loadJs({
                                                    scripts : '../../../app/frm_js/asistencial/ofimedical/wintestlawton.ui.js'
                                                });
                                            }
                                            if(selections[0].json.UsaTestYesavage != null && selections[0].json.UsaTestYesavage != "" && selections[0].json.UsaTestYesavage == "1"){
                                                ScriptMgr.loadJs({
                                                    scripts : '../../../app/frm_js/asistencial/ofimedical/wintestyesavage.ui.js'
                                                });
                                            }
                                            // ***** CARGAR LOS COMPONENTES ASOCIADOS A LA PLANTILLA
                                            var dsComponentesPlantilla = new Ext.data.Store({
                                                id: 'dsComponentesPlantilla',
                                                proxy: new Ext.data.HttpProxy({
                                                    url: '../../controlador/asistencial/controlador_plantillashc.php',
                                                    method: 'POST'
                                                }),
                                                baseParams: {
                                                    task: "LISTAR_COMPONENTES",
                                                    pPlantilla: selections[0].json.IdPlantilla
                                                },
                                                loadMask: {msg:"Cargando Registros, por favor espere..."},
                                                autoload: false,
                                                reader: new Ext.data.JsonReader({
                                                    root: 'results',
                                                    totalProperty: 'total',
                                                    id: 'id'
                                                  },[
                                                    {name: 'RutaComponente'},
                                                    {name: 'NomComponente'}
                                                 ])
                                            });
                                            dsComponentesPlantilla.load({
                                                callback: function(){
                                                    totalRegistros = dsComponentesPlantilla.getTotalCount();
                                                    var i = 0;
                                                    if(totalRegistros !== 0 && totalRegistros !== -1){
                                                        dsComponentesPlantilla.each(function(record){
                                                            ScriptMgr.loadJs({
                                                                scripts : record.get('RutaComponente'),
                                                                callback: function(){
                                                                    i++;
                                                                    //alert("componente: " + record.get('NomComponente'));
                                                                    //cargarFormularioHC(i,totalRegistros, selections[0].json.RutaPlantilla,selections[0].json.NomObjeto,selections[0].json.NomPlantilla, selections[0].json.IdPlantilla, selections[0].json.RutaRptHC, selections[0].json.RutaRptMx, selections[0].json.RutaRptExa, selections[0].json.RutaRptRem);
                                                                    if(i === totalRegistros){
                                                                        ScriptMgr.loadJs({
                                                                            scripts : selections[0].json.RutaPlantilla,
                                                                            waitMsg: 'Por favor Espere...',
                                                                            callback : function(){
                                                                                wPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
                                                                                wCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
                                                                                wConsecutivoDetalle = Ext.getCmp('sysConsecutivoDetalle_HC').getValue(); 
                                                                                paramOpcion = "Nuevo";
                                                                                var winHC = eval(selections[0].json.NomObjeto);//new winHCUi();
                                                                                Ext.getCmp('sysPlantillaHC').setValue(PonerAcentosMayusculas(selections[0].json.NomPlantilla));

                                                                                Ext.getCmp('sysActividadHC').setValue(PonerAcentosMayusculas(Ext.getCmp('sysDesConcepto').getValue()));
                                                                                Ext.getCmp('sysEmpresaHC').setValue(ID_EMPRESA);
                                                                                Ext.getCmp('sysIPSHC').setValue(ID_IPS);
                                                                                Ext.getCmp('sysUsuarioHC').setValue(ID_USUARIO);
                                                                                Ext.getCmp('sysProfesionalHC').setValue(Ext.getCmp('sysProfesionalPlantillaHC').getValue());
                                                                                Ext.getCmp('sysIdPacienteHC').setValue(Ext.getCmp('sysPacientePlantillaHC').getValue());
                                                                                Ext.getCmp('sysClienteHC').setValue(Ext.getCmp('sysIdCliente_HC').getRawValue());
                                                                                Ext.getCmp('sysCASHC').setValue(Ext.getCmp('sysCASPlantillaHC').getValue());
                                                                                Ext.getCmp('sysProfesionalAgendaHC').setValue(PonerAcentosMayusculas(Ext.getCmp('sysNomProfesionalPlantillaHC').getValue()));
                                                                                Ext.getCmp('sysFechaHC').setValue(Ext.getCmp('sysFechaPlantillaHC').getValue().format('Y/m/d'));
                                                                                Ext.getCmp('sysHoraHC').setValue(new Date().format("h:i:s"));
                                                                                Ext.getCmp('sysLegalizaHC').setValue(new Date().format("h:i:s"));
                                                                                Ext.getCmp('sysPacienteHC').setValue(PonerAcentosMayusculas(Ext.getCmp('sysNomPacientePlantillaHC').getValue()));
                                                                                Ext.getCmp('sysAperturaHC').setValue(new Date().format("h:i:s"));
                                                                                Ext.getCmp('sysConsecutivoDetalleHC').setValue(Ext.getCmp('sysConsecutivoDetalle_HC').getValue());
                                                                                Ext.getCmp('sysIdClienteHC').setValue(Ext.getCmp('sysIdCliente_HC').getValue());
                                                                                Ext.getCmp('sysIdContratoHC').setValue(1);
                                                                                Ext.getCmp('sysIdCodPlantillaHC').setValue(selections[0].json.IdPlantilla);
                                                                                try {
                                                                                    var campo = Ext.getCmp('sysNroAutorizacionHC');
                                                                                    if ( campo != null ) {
                                                                                        Ext.getCmp('sysNroAutorizacionHC').setValue(Ext.getCmp('sysNroAutorizacion').getValue());
                                                                                    }
                                                                                }catch(ex) {
                                                                                }
                                                                                try {
                                                                                    var campo1 = Ext.getCmp('strEmpresaSaludOcupacional');
                                                                                    if ( campo1 != null ) {
                                                                                        Ext.getCmp('strEmpresaSaludOcupacional').setValue(Ext.getCmp('strEmpresaTrabaja').getValue());
                                                                                    }
                                                                                }catch(ex) {
                                                                                }
                                                                                try {
                                                                                    if(Ext.getCmp('sysGeneroPlantillaHC').getValue() == "F"){
                                                                                        var campoAP_Ginecologicos = Ext.getCmp('memAP_Ginecologicos');
                                                                                        if ( campoAP_Ginecologicos != null ) {
                                                                                            Ext.getCmp('memAP_Ginecologicos').setVisible(true);
                                                                                        }
                                                                                    }
                                                                                }catch(ex) {
                                                                                }
                                                                                try {
                                                                                    var campo2 = Ext.getCmp('sysRutaRptHC');
                                                                                    if ( campo2 != null ) {
                                                                                        Ext.getCmp('sysRutaRptHC').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptHC));
                                                                                    }
                                                                                }catch(ex) {
                                                                                }
                                                                                try {
                                                                                    var campo3 = Ext.getCmp('sysRutaRptMx');
                                                                                    if ( campo3 != null ) {
                                                                                        Ext.getCmp('sysRutaRptMx').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptMx));
                                                                                    }
                                                                                }catch(ex) {
                                                                                }
                                                                                try {
                                                                                    var campo4 = Ext.getCmp('sysRutaRptExa');
                                                                                    if ( campo4 != null ) {
                                                                                        Ext.getCmp('sysRutaRptExa').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptExa));
                                                                                    }
                                                                                }catch(ex) {
                                                                                }
                                                                                try {
                                                                                    var campo5 = Ext.getCmp('sysRutaRptRem');
                                                                                    if ( campo5 != null ) {
                                                                                        Ext.getCmp('sysRutaRptRem').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptRem));
                                                                                    }
                                                                                }catch(ex) {
                                                                                }
                                                                                try { 
                                                                                    var campo6 = Ext.getCmp('sysInfoPacHCEdad');
                                                                                    if ( campo6 != null ) {
                                                                                        Ext.getCmp('sysInfoPacHCEdad').setValue(Ext.getCmp('strEdad').getValue());
                                                                                    }
                                                                                }catch(ex) {
                                                                                }
                                                                                try {
                                                                                    var campo8 = Ext.getCmp('sysInfoPacHCOcupacion');
                                                                                    if ( campo8 != null ) {
                                                                                        Ext.getCmp('sysInfoPacHCOcupacion').setValue(Ext.getCmp('strProfesionPac').getRawValue());
                                                                                    }
                                                                                }catch(ex) {
                                                                                }
                                                                                try {
                                                                                    var campo9 = Ext.getCmp('sysInfoPacHCDireccion');
                                                                                    if ( campo9 != null ) {
                                                                                        Ext.getCmp('sysInfoPacHCDireccion').setValue(Ext.getCmp('strDireccion').getValue());
                                                                                    }
                                                                                }catch(ex) {
                                                                                }
                                                                                try {
                                                                                    var campo10 = Ext.getCmp('sysInfoPacHCTelefonos');
                                                                                    if ( campo10 != null ) {
                                                                                        Ext.getCmp('sysInfoPacHCTelefonos').setValue(Ext.getCmp('strTel1').getValue() + " - " + Ext.getCmp('strTel2').getValue());
                                                                                    }
                                                                                }catch(ex) {
                                                                                }
                                                                                try {
                                                                                    if(Ext.getCmp('sysGeneroPlantillaHC').getValue() != null){
                                                                                        var campo3_1 = Ext.getCmp('sysGeneroPacHC');
                                                                                        if(Ext.getCmp('sysGeneroPlantillaHC').getValue() == "M"){
                                                                                            Ext.getCmp('sysGeneroPacHC').setValue("MASCULINO");
                                                                                        }else{
                                                                                            Ext.getCmp('sysGeneroPacHC').setValue("FEMENINO");
                                                                                        }
                                                                                    }
                                                                                }catch(ex) {
                                                                                }

                                                                                //OJO OMAR
                                                                                try {
                                                                                    if(Ext.getCmp('sysGeneroPlantillaHC').getValue() != null){
                                                                                        var campo3_2 = Ext.getCmp('sysGeneroPacHC');
                                                                                        if(Ext.getCmp('sysGeneroPlantillaHC').getValue() == "M"){
                                                                                            Ext.getCmp('sysGeneroHC').setValue("MASCULINO");
                                                                                        }else{
                                                                                            Ext.getCmp('sysGeneroHC').setValue("FEMENINO");
                                                                                        }
                                                                                    }
                                                                                }catch(ex) {
                                                                                }
                                                                                try {
                                                                                    var campo5_2 = Ext.getCmp('sysFechaNac');
                                                                                    if ( campo5_2 != null ) {
                                                                                        Ext.getCmp('sysFechaNac').setValue(Ext.getCmp('fecFecNac').getValue().format('d/m/Y'));
                                                                                    }
                                                                                }catch(ex) {
                                                                                }
                                                                                try {
                                                                                    var campo4_2 = Ext.getCmp('sysEdadPacHC');
                                                                                    if ( campo4_2 != null ) {
                                                                                        Ext.getCmp('sysEdadHC').setValue(Ext.getCmp('strEdad').getValue());
                                                                                    }
                                                                                }catch(ex) {
                                                                                }    
                                                                                //FIN OMAR


                                                                                try {
                                                                                    var campo4_1 = Ext.getCmp('sysEdadPacHC');
                                                                                    if ( campo4_1 != null ) {
                                                                                        Ext.getCmp('sysEdadPacHC').setValue(Ext.getCmp('strEdad').getValue());
                                                                                    }
                                                                                }catch(ex) {
                                                                                }    
                                                                                try {
                                                                                    var campo5_1 = Ext.getCmp('sysFecNacPacHC');
                                                                                    if ( campo5_1 != null ) {
                                                                                        Ext.getCmp('sysFecNacPacHC').setValue(Ext.getCmp('fecFecNac').getValue().format('d/m/Y'));
                                                                                    }
                                                                                }catch(ex) {
                                                                                }
                                                                                winHC.show();
                                                                                Ext.getCmp('winAddEvolucionOfimedicalUi').close();
                                                                            }
                                                                        });
                                                                    }
                                                                }
                                                            });
                                                        });
                                                    }else{
                                                        ScriptMgr.loadJs({
                                                            scripts : selections[0].json.RutaPlantilla,
                                                            waitMsg: 'Por favor Espere...',
                                                            callback : function(){
                                                                wPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
                                                                wCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
                                                                paramOpcion = "Nuevo";
                                                                var winHC = eval(selections[0].json.NomObjeto);//new winHCUi();
                                                                Ext.getCmp('sysPlantillaHC').setValue(PonerAcentosMayusculas(selections[0].json.NomPlantilla));

                                                                Ext.getCmp('sysActividadHC').setValue(PonerAcentosMayusculas(Ext.getCmp('sysDesConcepto').getValue()));
                                                                Ext.getCmp('sysEmpresaHC').setValue(ID_EMPRESA);
                                                                Ext.getCmp('sysIPSHC').setValue(ID_IPS);
                                                                Ext.getCmp('sysUsuarioHC').setValue(ID_USUARIO);
                                                                Ext.getCmp('sysProfesionalHC').setValue(Ext.getCmp('sysProfesionalPlantillaHC').getValue());
                                                                Ext.getCmp('sysIdPacienteHC').setValue(Ext.getCmp('sysPacientePlantillaHC').getValue());
                                                                Ext.getCmp('sysClienteHC').setValue(Ext.getCmp('sysIdCliente_HC').getRawValue());
                                                                Ext.getCmp('sysCASHC').setValue(Ext.getCmp('sysCASPlantillaHC').getValue());
                                                                Ext.getCmp('sysProfesionalAgendaHC').setValue(PonerAcentosMayusculas(Ext.getCmp('sysNomProfesionalPlantillaHC').getValue()));
                                                                Ext.getCmp('sysFechaHC').setValue(Ext.getCmp('sysFechaPlantillaHC').getValue().format('Y/m/d'));
                                                                Ext.getCmp('sysHoraHC').setValue(new Date().format("h:i:s"));
                                                                Ext.getCmp('sysLegalizaHC').setValue(new Date().format("h:i:s"));
                                                                Ext.getCmp('sysPacienteHC').setValue(PonerAcentosMayusculas(Ext.getCmp('sysNomPacientePlantillaHC').getValue()));
                                                                Ext.getCmp('sysAperturaHC').setValue(new Date().format("h:i:s"));
                                                                Ext.getCmp('sysConsecutivoDetalleHC').setValue(Ext.getCmp('sysConsecutivoDetalle_HC').getValue());
                                                                Ext.getCmp('sysIdClienteHC').setValue(Ext.getCmp('sysIdCliente_HC').getValue());
                                                                Ext.getCmp('sysIdContratoHC').setValue(1);
                                                                Ext.getCmp('sysIdCodPlantillaHC').setValue(selections[0].json.IdPlantilla);
                                                                try {
                                                                    var campo = Ext.getCmp('sysNroAutorizacionHC');
                                                                    if ( campo != null ) {
                                                                        Ext.getCmp('sysNroAutorizacionHC').setValue(Ext.getCmp('sysNroAutorizacion').getValue());
                                                                    }
                                                                }catch(ex) {
                                                                }
                                                                try {
                                                                    var campo1 = Ext.getCmp('strEmpresaSaludOcupacional');
                                                                    if ( campo1 != null ) {
                                                                        Ext.getCmp('strEmpresaSaludOcupacional').setValue(Ext.getCmp('strEmpresaTrabaja').getValue());
                                                                    }
                                                                }catch(ex) {
                                                                }
                                                                try {
                                                                    if(Ext.getCmp('sysGeneroPlantillaHC').getValue() == "F"){
                                                                        var campoAP_Ginecologicos = Ext.getCmp('memAP_Ginecologicos');
                                                                        if ( campoAP_Ginecologicos != null ) {
                                                                            Ext.getCmp('memAP_Ginecologicos').setVisible(true);
                                                                        }
                                                                    }
                                                                }catch(ex) {
                                                                }
                                                                try {
                                                                    var campo2 = Ext.getCmp('sysRutaRptHC');
                                                                    if ( campo2 != null ) {
                                                                        Ext.getCmp('sysRutaRptHC').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptHC));
                                                                    }
                                                                }catch(ex) {
                                                                }
                                                                try {
                                                                    var campo3 = Ext.getCmp('sysRutaRptMx');
                                                                    if ( campo3 != null ) {
                                                                        Ext.getCmp('sysRutaRptMx').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptMx));
                                                                    }
                                                                }catch(ex) {
                                                                }
                                                                try {
                                                                    var campo4 = Ext.getCmp('sysRutaRptExa');
                                                                    if ( campo4 != null ) {
                                                                        Ext.getCmp('sysRutaRptExa').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptExa));
                                                                    }
                                                                }catch(ex) {
                                                                }
                                                                try {
                                                                    var campo5 = Ext.getCmp('sysRutaRptRem');
                                                                    if ( campo5 != null ) {
                                                                        Ext.getCmp('sysRutaRptRem').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptRem));
                                                                    }
                                                                }catch(ex) {
                                                                }
                                                                try { 
                                                                    var campo6 = Ext.getCmp('sysInfoPacHCEdad');
                                                                    if ( campo6 != null ) {
                                                                        Ext.getCmp('sysInfoPacHCEdad').setValue(Ext.getCmp('strEdad').getValue());
                                                                    }
                                                                }catch(ex) {
                                                                }
                                                                try {
                                                                    var campo8 = Ext.getCmp('sysInfoPacHCOcupacion');
                                                                    if ( campo8 != null ) {
                                                                        Ext.getCmp('sysInfoPacHCOcupacion').setValue(Ext.getCmp('strProfesionPac').getRawValue());
                                                                    }
                                                                }catch(ex) {
                                                                }
                                                                try {
                                                                    var campo9 = Ext.getCmp('sysInfoPacHCDireccion');
                                                                    if ( campo9 != null ) {
                                                                        Ext.getCmp('sysInfoPacHCDireccion').setValue(Ext.getCmp('strDireccion').getValue());
                                                                    }
                                                                }catch(ex) {
                                                                }
                                                                try {
                                                                    var campo10 = Ext.getCmp('sysInfoPacHCTelefonos');
                                                                    if ( campo10 != null ) {
                                                                        Ext.getCmp('sysInfoPacHCTelefonos').setValue(Ext.getCmp('strTel1').getValue() + " - " + Ext.getCmp('strTel2').getValue());
                                                                    }
                                                                }catch(ex) {
                                                                }
                                                                try {
                                                                    if(Ext.getCmp('sysGeneroPlantillaHC').getValue() != null){
                                                                        var campo3_1 = Ext.getCmp('sysGeneroPacHC');
                                                                        if(Ext.getCmp('sysGeneroPlantillaHC').getValue() == "M"){
                                                                            Ext.getCmp('sysGeneroPacHC').setValue("MASCULINO");
                                                                        }else{
                                                                            Ext.getCmp('sysGeneroPacHC').setValue("FEMENINO");
                                                                        }
                                                                    }
                                                                }catch(ex) {
                                                                }

                                                                //OJO OMAR
                                                                try {
                                                                    if(Ext.getCmp('sysGeneroPlantillaHC').getValue() != null){
                                                                        var campo3_2 = Ext.getCmp('sysGeneroPacHC');
                                                                        if(Ext.getCmp('sysGeneroPlantillaHC').getValue() == "M"){
                                                                            Ext.getCmp('sysGeneroHC').setValue("MASCULINO");
                                                                        }else{
                                                                            Ext.getCmp('sysGeneroHC').setValue("FEMENINO");
                                                                        }
                                                                    }
                                                                }catch(ex) {
                                                                }
                                                                try {
                                                                    var campo5_2 = Ext.getCmp('sysFechaNac');
                                                                    if ( campo5_2 != null ) {
                                                                        Ext.getCmp('sysFechaNac').setValue(Ext.getCmp('fecFecNac').getValue().format('d/m/Y'));
                                                                    }
                                                                }catch(ex) {
                                                                }
                                                                try {
                                                                    var campo4_2 = Ext.getCmp('sysEdadPacHC');
                                                                    if ( campo4_2 != null ) {
                                                                        Ext.getCmp('sysEdadHC').setValue(Ext.getCmp('strEdad').getValue());
                                                                    }
                                                                }catch(ex) {
                                                                }    
                                                                //FIN OMAR


                                                                try {
                                                                    var campo4_1 = Ext.getCmp('sysEdadPacHC');
                                                                    if ( campo4_1 != null ) {
                                                                        Ext.getCmp('sysEdadPacHC').setValue(Ext.getCmp('strEdad').getValue());
                                                                    }
                                                                }catch(ex) {
                                                                }    
                                                                try {
                                                                    var campo5_1 = Ext.getCmp('sysFecNacPacHC');
                                                                    if ( campo5_1 != null ) {
                                                                        Ext.getCmp('sysFecNacPacHC').setValue(Ext.getCmp('fecFecNac').getValue().format('d/m/Y'));
                                                                    }
                                                                }catch(ex) {
                                                                }
                                                                winHC.show();
                                                                Ext.getCmp('winAddEvolucionOfimedicalUi').close();
                                                            }
                                                        });
                                                    }
                                                }
                                            });
                                        }else{
                                            Ext.MessageBox.show({
                                                title: 'eOfiClinic',
                                                msg: 'Debe Seleccionar una Plantilla.',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        }
                                    }
                                }
                            }
                        ],
                        buttonAlign: 'center',
                        listeners: {
                            viewready : function() {
                                myMask.hide();
                            }
                        }
                    }
                ]
            }
        ];
        this.on({
            /*afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Msg.hide();
                    var frm = Ext.getCmp('frmParms').getForm();
                    frm.doAction('load', {
                        url: '../../controlador/asistencial/ofimedicalhc.php',
                        waitMsg: 'Cargando Información...',
                        params:{
                            pIPS: ID_IPS,
                            task: 'CargarParametrosAddEvolucion'
                        }
                    });
                }
            }*/ 
        });
        winAddEvolucionOfimedicalUi.superclass.initComponent.call(this);
    }
});
